# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from fabric_cm.credmgr.swagger_server.models.base_model_ import Model
from fabric_cm.credmgr.swagger_server.models.jwks_keys import JwksKeys  # noqa: F401,E501
from fabric_cm.credmgr.swagger_server import util


class Jwks(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, keys: List[JwksKeys]=None):  # noqa: E501
        """Jwks - a model defined in Swagger

        :param keys: The keys of this Jwks.  # noqa: E501
        :type keys: List[JwksKeys]
        """
        self.swagger_types = {
            'keys': List[JwksKeys]
        }

        self.attribute_map = {
            'keys': 'keys'
        }
        self._keys = keys

    @classmethod
    def from_dict(cls, dikt) -> 'Jwks':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The jwks of this Jwks.  # noqa: E501
        :rtype: Jwks
        """
        return util.deserialize_model(dikt, cls)

    @property
    def keys(self) -> List[JwksKeys]:
        """Gets the keys of this Jwks.


        :return: The keys of this Jwks.
        :rtype: List[JwksKeys]
        """
        return self._keys

    @keys.setter
    def keys(self, keys: List[JwksKeys]):
        """Sets the keys of this Jwks.


        :param keys: The keys of this Jwks.
        :type keys: List[JwksKeys]
        """

        self._keys = keys
