# coding: utf-8

"""
    PartSearch Api

    Search for products and retrieve details and pricing.  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from digikey.v3.productinformation.api_client import ApiClient


class PartSearchApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def digi_reel_pricing(self, digi_key_part_number, requested_quantity, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """Calculate the DigiReel pricing for the given DigiKeyPartNumber and RequestedQuantity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.digi_reel_pricing(digi_key_part_number, requested_quantity, authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str digi_key_part_number: The Digi-Key PartNumber requested for Digi-Reel price calculation. It must be a  Digi-Key part number that is for a Digi-Reel pack type. (required)
        :param int requested_quantity: The quantity of the product you are looking to create a Digi-Reel with. Must be greater  than 0. (required)
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str includes: Comma separated list of fields to return. Used to customize response to reduce bandwidth by  selecting fields that you wish to receive. For example: \"ExtendedPrice,ReelingFee\"
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :return: DigiReelPricing
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.digi_reel_pricing_with_http_info(digi_key_part_number, requested_quantity, authorization, x_digikey_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.digi_reel_pricing_with_http_info(digi_key_part_number, requested_quantity, authorization, x_digikey_client_id, **kwargs)  # noqa: E501
            return data

    def digi_reel_pricing_with_http_info(self, digi_key_part_number, requested_quantity, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """Calculate the DigiReel pricing for the given DigiKeyPartNumber and RequestedQuantity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.digi_reel_pricing_with_http_info(digi_key_part_number, requested_quantity, authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str digi_key_part_number: The Digi-Key PartNumber requested for Digi-Reel price calculation. It must be a  Digi-Key part number that is for a Digi-Reel pack type. (required)
        :param int requested_quantity: The quantity of the product you are looking to create a Digi-Reel with. Must be greater  than 0. (required)
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str includes: Comma separated list of fields to return. Used to customize response to reduce bandwidth by  selecting fields that you wish to receive. For example: \"ExtendedPrice,ReelingFee\"
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :return: DigiReelPricing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['digi_key_part_number', 'requested_quantity', 'authorization', 'x_digikey_client_id', 'includes', 'x_digikey_locale_site', 'x_digikey_locale_language', 'x_digikey_locale_currency', 'x_digikey_locale_ship_to_country', 'x_digikey_customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method digi_reel_pricing" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'digi_key_part_number' is set
        if ('digi_key_part_number' not in params or
                params['digi_key_part_number'] is None):
            raise ValueError("Missing the required parameter `digi_key_part_number` when calling `digi_reel_pricing`")  # noqa: E501
        # verify the required parameter 'requested_quantity' is set
        if ('requested_quantity' not in params or
                params['requested_quantity'] is None):
            raise ValueError("Missing the required parameter `requested_quantity` when calling `digi_reel_pricing`")  # noqa: E501
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `digi_reel_pricing`")  # noqa: E501
        # verify the required parameter 'x_digikey_client_id' is set
        if ('x_digikey_client_id' not in params or
                params['x_digikey_client_id'] is None):
            raise ValueError("Missing the required parameter `x_digikey_client_id` when calling `digi_reel_pricing`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'digi_key_part_number' in params:
            path_params['digiKeyPartNumber'] = params['digi_key_part_number']  # noqa: E501

        query_params = []
        if 'requested_quantity' in params:
            query_params.append(('requestedQuantity', params['requested_quantity']))  # noqa: E501
        if 'includes' in params:
            query_params.append(('includes', params['includes']))  # noqa: E501

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501
        if 'x_digikey_client_id' in params:
            header_params['X-DIGIKEY-Client-Id'] = params['x_digikey_client_id']  # noqa: E501
        if 'x_digikey_locale_site' in params:
            header_params['X-DIGIKEY-Locale-Site'] = params['x_digikey_locale_site']  # noqa: E501
        if 'x_digikey_locale_language' in params:
            header_params['X-DIGIKEY-Locale-Language'] = params['x_digikey_locale_language']  # noqa: E501
        if 'x_digikey_locale_currency' in params:
            header_params['X-DIGIKEY-Locale-Currency'] = params['x_digikey_locale_currency']  # noqa: E501
        if 'x_digikey_locale_ship_to_country' in params:
            header_params['X-DIGIKEY-Locale-ShipToCountry'] = params['x_digikey_locale_ship_to_country']  # noqa: E501
        if 'x_digikey_customer_id' in params:
            header_params['X-DIGIKEY-Customer-Id'] = params['x_digikey_customer_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeySecurity', 'oauth2AccessCodeSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/Products/{digiKeyPartNumber}/DigiReelPricing', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DigiReelPricing',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def keyword_search(self, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """KeywordSearch can search for any product in the Digi-Key catalog.  # noqa: E501

        Search by keyword, then narrow down the search using available filters and search options.<br />  Locale information is required in the headers for accurate pricing and currencies. Locale defaults to United  States. <br />  Note that KeywordSearch results have cached pricing and availability. If real time pricing and availability is  needed, make a ProductDetails call.<br />  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.keyword_search(authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str includes: Comma separated list of fields to return. Used to customize response to reduce bandwidth by  selecting fields that you wish to receive. For example: \"Products(DigiKeyPartNumber,QuantityAvailable)\"
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :param KeywordSearchRequest body: KeywordSearchRequest
        :return: KeywordSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.keyword_search_with_http_info(authorization, x_digikey_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.keyword_search_with_http_info(authorization, x_digikey_client_id, **kwargs)  # noqa: E501
            return data

    def keyword_search_with_http_info(self, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """KeywordSearch can search for any product in the Digi-Key catalog.  # noqa: E501

        Search by keyword, then narrow down the search using available filters and search options.<br />  Locale information is required in the headers for accurate pricing and currencies. Locale defaults to United  States. <br />  Note that KeywordSearch results have cached pricing and availability. If real time pricing and availability is  needed, make a ProductDetails call.<br />  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.keyword_search_with_http_info(authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str includes: Comma separated list of fields to return. Used to customize response to reduce bandwidth by  selecting fields that you wish to receive. For example: \"Products(DigiKeyPartNumber,QuantityAvailable)\"
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :param KeywordSearchRequest body: KeywordSearchRequest
        :return: KeywordSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'x_digikey_client_id', 'includes', 'x_digikey_locale_site', 'x_digikey_locale_language', 'x_digikey_locale_currency', 'x_digikey_locale_ship_to_country', 'x_digikey_customer_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method keyword_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `keyword_search`")  # noqa: E501
        # verify the required parameter 'x_digikey_client_id' is set
        if ('x_digikey_client_id' not in params or
                params['x_digikey_client_id'] is None):
            raise ValueError("Missing the required parameter `x_digikey_client_id` when calling `keyword_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'includes' in params:
            query_params.append(('includes', params['includes']))  # noqa: E501

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501
        if 'x_digikey_client_id' in params:
            header_params['X-DIGIKEY-Client-Id'] = params['x_digikey_client_id']  # noqa: E501
        if 'x_digikey_locale_site' in params:
            header_params['X-DIGIKEY-Locale-Site'] = params['x_digikey_locale_site']  # noqa: E501
        if 'x_digikey_locale_language' in params:
            header_params['X-DIGIKEY-Locale-Language'] = params['x_digikey_locale_language']  # noqa: E501
        if 'x_digikey_locale_currency' in params:
            header_params['X-DIGIKEY-Locale-Currency'] = params['x_digikey_locale_currency']  # noqa: E501
        if 'x_digikey_locale_ship_to_country' in params:
            header_params['X-DIGIKEY-Locale-ShipToCountry'] = params['x_digikey_locale_ship_to_country']  # noqa: E501
        if 'x_digikey_customer_id' in params:
            header_params['X-DIGIKEY-Customer-Id'] = params['x_digikey_customer_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeySecurity', 'oauth2AccessCodeSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/Products/Keyword', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KeywordSearchResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def manufacturer_product_details(self, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """Create list of ProductDetails from the matches of the requested manufacturer product name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.manufacturer_product_details(authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str includes: Comma separated list of fields to return. Used to customize response to reduce bandwidth by  selecting fields that you wish to receive. For example: \"Products(DigiKeyPartNumber,QuantityAvailable)\"
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :param ManufacturerProductDetailsRequest body: ManufacturerProductDetailsRequest
        :return: ProductDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.manufacturer_product_details_with_http_info(authorization, x_digikey_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.manufacturer_product_details_with_http_info(authorization, x_digikey_client_id, **kwargs)  # noqa: E501
            return data

    def manufacturer_product_details_with_http_info(self, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """Create list of ProductDetails from the matches of the requested manufacturer product name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.manufacturer_product_details_with_http_info(authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str includes: Comma separated list of fields to return. Used to customize response to reduce bandwidth by  selecting fields that you wish to receive. For example: \"Products(DigiKeyPartNumber,QuantityAvailable)\"
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :param ManufacturerProductDetailsRequest body: ManufacturerProductDetailsRequest
        :return: ProductDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'x_digikey_client_id', 'includes', 'x_digikey_locale_site', 'x_digikey_locale_language', 'x_digikey_locale_currency', 'x_digikey_locale_ship_to_country', 'x_digikey_customer_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method manufacturer_product_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `manufacturer_product_details`")  # noqa: E501
        # verify the required parameter 'x_digikey_client_id' is set
        if ('x_digikey_client_id' not in params or
                params['x_digikey_client_id'] is None):
            raise ValueError("Missing the required parameter `x_digikey_client_id` when calling `manufacturer_product_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'includes' in params:
            query_params.append(('includes', params['includes']))  # noqa: E501

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501
        if 'x_digikey_client_id' in params:
            header_params['X-DIGIKEY-Client-Id'] = params['x_digikey_client_id']  # noqa: E501
        if 'x_digikey_locale_site' in params:
            header_params['X-DIGIKEY-Locale-Site'] = params['x_digikey_locale_site']  # noqa: E501
        if 'x_digikey_locale_language' in params:
            header_params['X-DIGIKEY-Locale-Language'] = params['x_digikey_locale_language']  # noqa: E501
        if 'x_digikey_locale_currency' in params:
            header_params['X-DIGIKEY-Locale-Currency'] = params['x_digikey_locale_currency']  # noqa: E501
        if 'x_digikey_locale_ship_to_country' in params:
            header_params['X-DIGIKEY-Locale-ShipToCountry'] = params['x_digikey_locale_ship_to_country']  # noqa: E501
        if 'x_digikey_customer_id' in params:
            header_params['X-DIGIKEY-Customer-Id'] = params['x_digikey_customer_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeySecurity', 'oauth2AccessCodeSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/Products/ManufacturerProductDetails', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductDetailsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def product_details(self, digi_key_part_number, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """Retrieve detailed product information including real time pricing and availability.  # noqa: E501

        Works best with a Digi-Key part number. Some manufacturer part numbers conflict with unrelated parts and may not  return the correct product.  Locale information is required in the headers for accurate pricing and currencies. Locale defaults to United  States.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.product_details(digi_key_part_number, authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str digi_key_part_number: The product to retrieve details for. (required)
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str includes: Comma separated list of fields to return. Used to customize response to reduce bandwidth by  selecting fields that you wish to receive. For example: \"DigiKeyPartNumber,QuantityAvailable,AssociatedProducts[2]\"
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :return: ProductDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.product_details_with_http_info(digi_key_part_number, authorization, x_digikey_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.product_details_with_http_info(digi_key_part_number, authorization, x_digikey_client_id, **kwargs)  # noqa: E501
            return data

    def product_details_with_http_info(self, digi_key_part_number, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """Retrieve detailed product information including real time pricing and availability.  # noqa: E501

        Works best with a Digi-Key part number. Some manufacturer part numbers conflict with unrelated parts and may not  return the correct product.  Locale information is required in the headers for accurate pricing and currencies. Locale defaults to United  States.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.product_details_with_http_info(digi_key_part_number, authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str digi_key_part_number: The product to retrieve details for. (required)
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str includes: Comma separated list of fields to return. Used to customize response to reduce bandwidth by  selecting fields that you wish to receive. For example: \"DigiKeyPartNumber,QuantityAvailable,AssociatedProducts[2]\"
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :return: ProductDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['digi_key_part_number', 'authorization', 'x_digikey_client_id', 'includes', 'x_digikey_locale_site', 'x_digikey_locale_language', 'x_digikey_locale_currency', 'x_digikey_locale_ship_to_country', 'x_digikey_customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'digi_key_part_number' is set
        if ('digi_key_part_number' not in params or
                params['digi_key_part_number'] is None):
            raise ValueError("Missing the required parameter `digi_key_part_number` when calling `product_details`")  # noqa: E501
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `product_details`")  # noqa: E501
        # verify the required parameter 'x_digikey_client_id' is set
        if ('x_digikey_client_id' not in params or
                params['x_digikey_client_id'] is None):
            raise ValueError("Missing the required parameter `x_digikey_client_id` when calling `product_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'digi_key_part_number' in params:
            path_params['digiKeyPartNumber'] = params['digi_key_part_number']  # noqa: E501

        query_params = []
        if 'includes' in params:
            query_params.append(('includes', params['includes']))  # noqa: E501

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501
        if 'x_digikey_client_id' in params:
            header_params['X-DIGIKEY-Client-Id'] = params['x_digikey_client_id']  # noqa: E501
        if 'x_digikey_locale_site' in params:
            header_params['X-DIGIKEY-Locale-Site'] = params['x_digikey_locale_site']  # noqa: E501
        if 'x_digikey_locale_language' in params:
            header_params['X-DIGIKEY-Locale-Language'] = params['x_digikey_locale_language']  # noqa: E501
        if 'x_digikey_locale_currency' in params:
            header_params['X-DIGIKEY-Locale-Currency'] = params['x_digikey_locale_currency']  # noqa: E501
        if 'x_digikey_locale_ship_to_country' in params:
            header_params['X-DIGIKEY-Locale-ShipToCountry'] = params['x_digikey_locale_ship_to_country']  # noqa: E501
        if 'x_digikey_customer_id' in params:
            header_params['X-DIGIKEY-Customer-Id'] = params['x_digikey_customer_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeySecurity', 'oauth2AccessCodeSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/Products/{digiKeyPartNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def suggested_parts(self, part_number, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """Retrieve detailed product information and two suggested products  # noqa: E501

        Works best with a Digi-Key part number. Some manufacturer part numbers conflict with unrelated parts and may not  return the correct product.  Locale information is required in the headers for accurate pricing and currencies. Locale defaults to United  States.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.suggested_parts(part_number, authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str part_number: The product to retrieve details for. (required)
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :return: ProductDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.suggested_parts_with_http_info(part_number, authorization, x_digikey_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.suggested_parts_with_http_info(part_number, authorization, x_digikey_client_id, **kwargs)  # noqa: E501
            return data

    def suggested_parts_with_http_info(self, part_number, authorization, x_digikey_client_id, **kwargs):  # noqa: E501
        """Retrieve detailed product information and two suggested products  # noqa: E501

        Works best with a Digi-Key part number. Some manufacturer part numbers conflict with unrelated parts and may not  return the correct product.  Locale information is required in the headers for accurate pricing and currencies. Locale defaults to United  States.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.suggested_parts_with_http_info(part_number, authorization, x_digikey_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str part_number: The product to retrieve details for. (required)
        :param str authorization: OAuth Bearer Token. Please see<a href= \"https://developer.digikey.com/documentation/oauth\" target= \"_blank\" > OAuth 2.0 Documentation </a > page for more info. (required)
        :param str x_digikey_client_id: The Client Id for your App. (required)
        :param str x_digikey_locale_site: Two letter code for Digi-Key product website to search on. Different countries sites have different part restrictions, supported languages, and currencies. Acceptable values include: US, CA, JP, UK, DE, AT, BE, DK, FI, GR, IE, IT, LU, NL, NO, PT, ES, KR, HK, SG, CN, TW, AU, FR, IN, NZ, SE, MX, CH, IL, PL, SK, SI, LV, LT, EE, CZ, HU, BG, MY, ZA, RO, TH, PH.
        :param str x_digikey_locale_language: Two letter code for language to search on. Langauge must be supported by the selected site. If searching on keyword, this language is used to find matches. Acceptable values include: en, ja, de, fr, ko, zhs, zht, it, es, he, nl, sv, pl, fi, da, no.
        :param str x_digikey_locale_currency: Three letter code for Currency to return part pricing for. Currency must be supported by the selected site. Acceptable values include: USD, CAD, JPY, GBP, EUR, HKD, SGD, TWD, KRW, AUD, NZD, INR, DKK, NOK, SEK, ILS, CNY, PLN, CHF, CZK, HUF, RON, ZAR, MYR, THB, PHP.
        :param str x_digikey_locale_ship_to_country: ISO code for country to ship to.
        :param str x_digikey_customer_id: Your Digi-Key Customer id. If your account has multiple Customer Ids for different regions, this allows you to select one of them.
        :return: ProductDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['part_number', 'authorization', 'x_digikey_client_id', 'x_digikey_locale_site', 'x_digikey_locale_language', 'x_digikey_locale_currency', 'x_digikey_locale_ship_to_country', 'x_digikey_customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method suggested_parts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'part_number' is set
        if ('part_number' not in params or
                params['part_number'] is None):
            raise ValueError("Missing the required parameter `part_number` when calling `suggested_parts`")  # noqa: E501
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `suggested_parts`")  # noqa: E501
        # verify the required parameter 'x_digikey_client_id' is set
        if ('x_digikey_client_id' not in params or
                params['x_digikey_client_id'] is None):
            raise ValueError("Missing the required parameter `x_digikey_client_id` when calling `suggested_parts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'part_number' in params:
            path_params['partNumber'] = params['part_number']  # noqa: E501

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501
        if 'x_digikey_client_id' in params:
            header_params['X-DIGIKEY-Client-Id'] = params['x_digikey_client_id']  # noqa: E501
        if 'x_digikey_locale_site' in params:
            header_params['X-DIGIKEY-Locale-Site'] = params['x_digikey_locale_site']  # noqa: E501
        if 'x_digikey_locale_language' in params:
            header_params['X-DIGIKEY-Locale-Language'] = params['x_digikey_locale_language']  # noqa: E501
        if 'x_digikey_locale_currency' in params:
            header_params['X-DIGIKEY-Locale-Currency'] = params['x_digikey_locale_currency']  # noqa: E501
        if 'x_digikey_locale_ship_to_country' in params:
            header_params['X-DIGIKEY-Locale-ShipToCountry'] = params['x_digikey_locale_ship_to_country']  # noqa: E501
        if 'x_digikey_customer_id' in params:
            header_params['X-DIGIKEY-Customer-Id'] = params['x_digikey_customer_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeySecurity', 'oauth2AccessCodeSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/Products/{partNumber}/WithSuggestedProducts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
