import os
import yara

class YaraScanner:
    def __init__(self):
        # Create the list of rules
        try:
            yara_path = os.path.join(os.path.dirname(__file__), 'yaraRules')
            self.yara_rules = os.listdir(yara_path)
            self.rule_file = os.path.join(yara_path, 'yaraRules.yar')
            self.compiled_rules = yara.compile(self.rule_file)
            self.rule_list = []
        except yara.SyntaxError as e:
            print("Unable to compile rules. Do you have dotnet enabled")

    # Yara Scanner Returns the Rule Name
    def yara_scan(self, raw_data):
        matches = self.compiled_rules.match(data=raw_data)
        rule_list = []

        for match in matches:
            rule_list.append(match.rule)
        self.rule_list = rule_list
