import unittest
from unittest.mock import MagicMock
from datetime import timedelta

from osgar.drivers.velodyne import parse_packet, Velodyne
from osgar.bus import Bus


SAMPLE_DATA = bytes.fromhex("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")


class VelodyneTest(unittest.TestCase):

    def test_parse_packet(self):
        xyz = parse_packet(SAMPLE_DATA)
        self.assertEqual(len(xyz), 192)
        self.assertEqual(xyz[0], [2.15059913937319, 0.5416715141352251, -0.5942485275553877])

    def test_node(self):
        config = {}
        logger = MagicMock()
        logger.write = MagicMock(return_value=timedelta(42))
        bus = Bus(logger)
        imu = Velodyne(config, bus=bus.handle('velodyne'))
        imu.start()
        imu.bus.queue.put((timedelta(43), 'raw', SAMPLE_DATA))
        imu.request_stop()
        imu.join()

# vim: expandtab sw=4 ts=4
