/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.logging.FmtLog;

public class IOX {
    public static final Path currentDirectory = Path.of(".", new String[0]);

    public static RuntimeIOException exception(IOException ioException) {
        return new RuntimeIOException(ioException);
    }

    public static RuntimeIOException exception(String message, IOException ioException) {
        return new RuntimeIOException(message, ioException);
    }

    public static void run(ActionIO action) {
        try {
            action.run();
        }
        catch (IOException e2) {
            throw IOX.exception(e2);
        }
    }

    public static boolean safeWrite(Path file, IOConsumer<OutputStream> writerAction) {
        Path tmp = IOX.createTempFile(file.getParent(), file.getFileName().toString(), ".tmp", new FileAttribute[0]);
        return IOX.safeWrite(file, tmp, writerAction);
    }

    public static boolean safeWrite(Path file, Path tmpFile, IOConsumer<OutputStream> writerAction) {
        try {
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));){
                writerAction.actionEx(out);
            }
            IOX.move(tmpFile, file);
            return true;
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static void delete(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException ex) {
            FmtLog.error(IOX.class, (Throwable)ex, "IOException deleting %s", path);
            throw IOX.exception(ex);
        }
    }

    public static void move(Path src, Path dst) {
        try {
            Files.move(src, dst, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException ex) {
            FmtLog.error(IOX.class, (Throwable)ex, "IOException moving %s to %s", src, dst);
            throw IOX.exception(ex);
        }
    }

    public static void deleteAll(String start) {
        IOX.deleteAll(Paths.get(start, new String[0]));
    }

    public static void deleteAll(Path start) {
        try {
            Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e2) throws IOException {
                    if (e2 == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e2;
                }
            });
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static void copy(String srcFilename, String dstFilename) {
        Path src = Path.of(srcFilename, new String[0]);
        if (!Files.exists(src, new LinkOption[0])) {
            throw new RuntimeIOException("No such file: " + srcFilename);
        }
        Path dst = Path.of(dstFilename, new String[0]);
        if (Files.isDirectory(dst, new LinkOption[0])) {
            dst = dst.resolve(src.getFileName());
        }
        try {
            Files.copy(src, dst, new CopyOption[0]);
        }
        catch (IOException ex) {
            FmtLog.error(IOX.class, (Throwable)ex, "IOException copying %s to %s", srcFilename, dstFilename);
            throw IOX.exception(ex);
        }
    }

    public static void createDirectory(Path dir) {
        try {
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static byte[] readAll(Path pathname) {
        try {
            return Files.readAllBytes(pathname);
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static void writeAll(Path pathname, byte[] value) {
        try {
            Files.write(pathname, value, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) {
        try {
            return Files.createTempFile(dir, prefix, suffix, attrs);
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static Path uniqueDerivedPath(Path path, Function<String, String> basenameMapping) {
        String base = path.getFileName().toString();
        if (basenameMapping != null) {
            base = basenameMapping.apply(base);
        }
        for (int x = 0; x < 10000; ++x) {
            String destname = base + "-" + x;
            Path destpath = path.resolveSibling(destname);
            if (Files.exists(destpath, new LinkOption[0])) continue;
            return destpath;
        }
        return null;
    }

    @FunctionalInterface
    public static interface ActionIO {
        public void run() throws IOException;
    }

    @FunctionalInterface
    public static interface IOConsumer<X> {
        public void actionEx(X var1) throws IOException;
    }
}

