/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdUpdate;
import java.io.OutputStream;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.system.Txn;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class update
extends CmdUpdate {
    static final ArgDecl updateArg = new ArgDecl(true, "update", "file");
    static final ArgDecl dumpArg = new ArgDecl(false, "dump");
    List<String> requestFiles = null;
    boolean dump = false;

    public static void main(String ... argv) {
        new update(argv).mainRun();
    }

    protected update(String[] argv) {
        super(argv);
        super.add(updateArg, "--update=FILE", "Update commands to execute");
        super.add(dumpArg, "--dump", "Dump the resulting graph store");
    }

    @Override
    protected void processModulesAndArgs() {
        this.requestFiles = this.getValues(updateArg);
        this.dump = this.contains(dumpArg);
        super.processModulesAndArgs();
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --desc=assembler [--dump] --update=<request file>";
    }

    @Override
    protected void execUpdate(DatasetGraph graphStore) {
        if (this.requestFiles.size() == 0 && this.getPositional().size() == 0) {
            throw new CmdException("Nothing to do");
        }
        DatasetGraph transactional = graphStore;
        for (String filename : this.requestFiles) {
            Txn.executeWrite(transactional, () -> this.execOneFile(filename, graphStore));
        }
        for (String requestString : super.getPositional()) {
            String requestString2 = this.indirect(requestString);
            Txn.executeWrite(transactional, () -> this.execOne(requestString2, graphStore));
        }
        if (!(transactional instanceof DatasetGraph)) {
            SystemARQ.sync(graphStore);
        }
        if (this.dump) {
            Txn.executeRead(transactional, () -> RDFDataMgr.write((OutputStream)System.out, graphStore, Lang.TRIG));
        }
    }

    protected void execOneFile(String filename, DatasetGraph store) {
        UpdateRequest req = UpdateFactory.read(filename, this.updateSyntax);
        UpdateExec.newBuilder().update(req).dataset(store).execute();
    }

    protected void execOne(String requestString, DatasetGraph store) {
        UpdateRequest req = UpdateFactory.create(requestString, this.updateSyntax);
        UpdateExec.newBuilder().update(req).dataset(store).execute();
    }

    @Override
    protected DatasetGraph dealWithNoDataset() {
        return DatasetGraphFactory.createGeneral();
    }
}

