from abc import ABC
from typing import Any
from typing_extensions import Literal

def clear_empty_fields(d): ...
def create_dictionary_string(
    dict_,
    open_dict: str = ...,
    close_dict: str = ...,
    field_join: str = ...,
    key_value_join: str = ...,
    has_empty_fields: bool = ...,
): ...
def create_list_string(list_): ...
def iobj_ref(n): ...
def create_stream(stream): ...

class PDFObject:
    def __init__(self, id: Any | None = ...) -> None: ...
    @property
    def id(self): ...
    @id.setter
    def id(self, n) -> None: ...
    @property
    def ref(self): ...
    def serialize(self, fpdf: Any | None = ..., obj_dict: Any | None = ...): ...

def camel_case(snake_case: str) -> str: ...

class PDFString(str):
    def serialize(self): ...

class PDFArray(list[Any]):
    def serialize(self): ...

class Destination(ABC):
    def as_str(self, pdf: Any | None = ...) -> None: ...

class DestinationXYZ(Destination):
    page: int
    x: float
    y: float
    zoom: float | Literal["null"]
    page_as_obj_id: bool
    def __init__(
        self, page: int, x: float = ..., y: float = ..., zoom: float | Literal["null"] = ..., page_as_obj_id: bool = ...
    ) -> None: ...
    def as_str(self, pdf: Any | None = ...): ...

class Raw(str): ...

class Name(str):
    def pdf_repr(self) -> str: ...
