"""
Granularity Enumeration

Meteorological data provided by Meteostat (https://dev.meteostat.net)
under the terms of the Creative Commons Attribution-NonCommercial
4.0 International Public License.

The code is licensed under the MIT license.
"""

from enum import Enum


class Granularity(Enum):
    """
    The different levels of time series granularity
    """

    HOURLY = 'hourly'
    DAILY = 'daily'
    MONTHLY = 'monthly'
    NORMALS = 'normals'
