# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2017-04-15 09:41
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(upload_to=b'files')),
                ('name', models.CharField(blank=True, max_length=100)),
                ('position', models.PositiveSmallIntegerField()),
            ],
            options={
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='Content',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveSmallIntegerField()),
                ('content_type', models.CharField(max_length=100)),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name=b'created')),
                ('changed', models.DateTimeField(auto_now=True, db_index=True, verbose_name=b'changed')),
            ],
            options={
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='ContentsContainer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='Number',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('number', models.IntegerField(blank=True, null=True)),
                ('suffix', models.CharField(blank=True, max_length=10, null=True)),
                ('title', models.CharField(blank=True, max_length=100)),
            ],
            options={
                'ordering': ('content', 'id'),
            },
        ),
        migrations.CreateModel(
            name='Photo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to=b'photos')),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('position', models.PositiveSmallIntegerField()),
            ],
            options={
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='Quote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('job_title', models.CharField(max_length=255)),
                ('image', models.ImageField(blank=True, null=True, upload_to=b'quotes')),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('quote', models.TextField()),
            ],
            options={
                'ordering': ('content', 'id'),
            },
        ),
        migrations.CreateModel(
            name='CodeInput',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='xprez.Content')),
                ('code', models.TextField()),
            ],
            bases=('xprez.content',),
        ),
        migrations.CreateModel(
            name='CodeTemplate',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='xprez.Content')),
                ('template_name', models.CharField(blank=True, max_length=255, null=True)),
            ],
            bases=('xprez.content',),
        ),
        migrations.CreateModel(
            name='DownloadContent',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='xprez.Content')),
                ('title', models.CharField(blank=True, max_length=255)),
            ],
            options={
                'abstract': False,
            },
            bases=('xprez.content',),
        ),
        migrations.CreateModel(
            name='FeatureBoxes',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='xprez.Content')),
                ('box_1', models.TextField(blank=True)),
                ('box_2', models.TextField(blank=True)),
                ('box_3', models.TextField(blank=True)),
            ],
            bases=('xprez.content',),
        ),
        migrations.CreateModel(
            name='Gallery',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='xprez.Content')),
                ('width', models.CharField(choices=[(b'full', b'full'), (b'mid', b'mid'), (b'text', b'text')], default=b'full', max_length=50)),
                ('columns', models.PositiveSmallIntegerField(default=1)),
                ('divided', models.BooleanField(default=False)),
                ('crop', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
            bases=('xprez.content',),
        ),
        migrations.CreateModel(
            name='MediumEditor',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='xprez.Content')),
                ('text', models.TextField()),
                ('css_class', models.CharField(blank=True, max_length=100, null=True)),
                ('box', models.BooleanField(default=False)),
                ('width', models.CharField(choices=[(b'full', b'full'), (b'mid', b'mid'), (b'text', b'text')], default=b'full', max_length=50)),
            ],
            bases=('xprez.content',),
        ),
        migrations.CreateModel(
            name='NumbersContent',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='xprez.Content')),
            ],
            options={
                'abstract': False,
            },
            bases=('xprez.content',),
        ),
        migrations.CreateModel(
            name='QuoteContent',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='xprez.Content')),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('box', models.BooleanField(default=False)),
                ('display_two', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
            bases=('xprez.content',),
        ),
        migrations.CreateModel(
            name='Video',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='xprez.Content')),
                ('poster_image', models.ImageField(blank=True, null=True, upload_to=b'video')),
                ('url', models.URLField()),
                ('width', models.CharField(choices=[(b'full', b'full'), (b'mid', b'mid'), (b'text', b'text')], default=b'full', max_length=50)),
                ('video_type', models.CharField(choices=[(b'youtube', b'YouTube'), (b'vimeo', b'Vimeo')], max_length=50)),
                ('video_id', models.CharField(max_length=200)),
            ],
            bases=('xprez.content',),
        ),
        migrations.AddField(
            model_name='content',
            name='page',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contents', to='xprez.ContentsContainer'),
        ),
        migrations.AddField(
            model_name='quote',
            name='content',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='quotes', to='xprez.QuoteContent'),
        ),
        migrations.AddField(
            model_name='photo',
            name='gallery',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='photos', to='xprez.Gallery'),
        ),
        migrations.AddField(
            model_name='number',
            name='content',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='numbers', to='xprez.NumbersContent'),
        ),
        migrations.AddField(
            model_name='attachment',
            name='content',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='xprez.DownloadContent'),
        ),
    ]
