"""remove the field "current" from the table "script"

Revision ID: 4dc6a93dfed8
Revises: 68cb1c590d1f
Create Date: 2024-02-04 09:01:35.420772

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = '4dc6a93dfed8'
down_revision = '68cb1c590d1f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute('PRAGMA foreign_keys=OFF;')
    with op.batch_alter_table('script', schema=None) as batch_op:
        batch_op.drop_column('current')
    op.execute('PRAGMA foreign_keys=ON;')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute('PRAGMA foreign_keys=OFF;')

    # Step 1: Add the column as nullable
    with op.batch_alter_table('script', schema=None) as batch_op:
        batch_op.add_column(sa.Column('current', sa.BOOLEAN(), nullable=True))

    # Step 2: Update existing rows to set the default value for the new column
    op.execute(
        '''
        UPDATE script
        SET current = False
    '''
    )

    # Step 3: Alter the column to be non-nullable
    with op.batch_alter_table('script', schema=None) as batch_op:
        batch_op.alter_column('current', nullable=False)

    # An alternative way that sets the default value in the database level
    # with op.batch_alter_table('script', schema=None) as batch_op:
    #     batch_op.add_column(
    #         sa.Column(
    #             'current',
    #             sa.BOOLEAN(),
    #             nullable=False,
    #             server_default=sa.sql.expression.false(),
    #         )
    #     )
    op.execute('PRAGMA foreign_keys=ON;')

    # ### end Alembic commands ###
