"""add the table "script"

Revision ID: 6e3cf7d9b6bf
Revises: 2fa41efc56f0
Create Date: 2024-01-29 15:11:23.479015

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = '6e3cf7d9b6bf'
down_revision = '2fa41efc56f0'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute('PRAGMA foreign_keys=OFF;')
    op.create_table('script',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('current', sa.Boolean(), nullable=False),
    sa.Column('script', sa.Text(), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_script'))
    )
    with op.batch_alter_table('script', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_script_id'), ['id'], unique=False)

    with op.batch_alter_table('run', schema=None) as batch_op:
        batch_op.add_column(sa.Column('script_id', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_run_script_id_script'), 'script', ['script_id'], ['id'])
    op.execute('PRAGMA foreign_keys=ON;')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute('PRAGMA foreign_keys=OFF;')
    with op.batch_alter_table('run', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_run_script_id_script'), type_='foreignkey')
        batch_op.drop_column('script_id')

    with op.batch_alter_table('script', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_script_id'))

    op.drop_table('script')
    op.execute('PRAGMA foreign_keys=ON;')
    # ### end Alembic commands ###
