# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['virtualassitant']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.1.3,<9.0.0']

entry_points = \
{'console_scripts': ['asistente = VirtualAssitant.main:main']}

setup_kwargs = {
    'name': 'virtualassitant',
    'version': '1.0',
    'description': 'Agendamiento de actividades mediante comandos de voz en google calendar',
    'long_description': '# Proyecto Final, Segundo Bimestre - PYTHON BÁSICO\n\n- **Vencimiento: Miércoles, 27 de julio**\n- **Calificación: .../10 (Auto califique su trabajo)**\n\n## Objetivos de aprendizaje\n- Aplicar nuevas habilidades a un problema del mundo real\n- Sintetizar las técnicas aprendidas\n\n## Herramientas\n- git\n- github\n- python\n- poetry\n- pandas\n- numpy\n- click\n\n\n\n## Organización de carpetas\n\nArchivos generados automáticamente por poetry\n\n```\npoetry-demo\n├── pyproject.toml              \n├── README.md                   # Documentación del proyecto    \n├── poetry_demo\n│   └── __init__.py\n└── tests\n    ├── __init__.py\n    └── test_poetry_demo.py\n```\n\n\n## Flujo de Trabajo\n1. Clona este repositorio en tu máquina local    \n2. Edite los archivos que sean necesarios y complete todas las tareas semanales que se señalan en los entregables.\n3. Confirme sus cambios y envíelos a github. \n\n\n## Entregables\n- **Semana 2 (15 jun.):** \n  - Definición de problema. Debe ser un problema relacionado con su área de estudio y que se pueda dividir en módulos, analice algún problema que lo este desarrollando de forma manual y que pueda ser automatizado. Es importante que en el problema se realice operaciones numéricas con vectores, matrices. En su repositorio genere el archivo propuesta.txt.\n \n- **Semana 3 (22 jun.):** \n  - Lista de funcionalidades del problema a automatizar, en el mismo archivo propuesta.txt.\n  - Implementación de funciones (30%)\n  - Funcionamiento de aplicación por consola (empleando un menú).\n   \n- **Semana 6 (13 jul.):**  \n  - Implementación de funciones en módulos (60%).\n  - Creación de paquete empleando poetry en carpeta de proyecto. \n  - Funcionamiento de aplicación por consola empleando click\n  - **\\*** Publicación de paquete en [test.pypi.org](https://test.pypi.org/)\n  \n- **Semana 8 (27 jul.):**  \n  - Implementación de funciones en módulos (100%).\n  - Generación de gráficas\n  - **\\*** Almacenamiento de gráficas empleando el método savefig de matplotlib.  \n  - Pruebas de funcionamiento del programa.\n  - Documentación del proyecto: actualizar el contenido de README.md empleando el archivo plantilla_doc.md.\n  - Publicación de paquete en [pypi](https://pypi.org/)\n\n\\* Opcional.\n\n## Instrucciones\n\nEl proyecto final pretende ser un proyecto independiente que utilice las habilidades que ha aprendido en esta clase, así como las cosas que ha aprendido por su cuenta, para crear un programa de Interfaz de línea de comandos (CLI) que logre una o más tareas relevantes para resolver un problema del mundo real relacionadas con su **área de estudio**. A diferencia de otras actividades en las que se proporciono el problema, ahora es su turno de plantear un problema que desee automatizar. \n\nEspecíficamente, deberá utilizar técnicas de programación modular (uso de funciones), crear un paquete de la solución y publicarlo en pypi. \n\nRevisar los siguientes vídeos de referencia:\n- [Creación de paquete con poetry](https://youtu.be/ZOSWdktsKf0?list=PLwkJQeEWueTsRrnrFJo3oRf89oYx--7PJ&t=3072)\n- [Gestión de paquetes con poetry](https://youtu.be/4g9zXWzCLX0?t=682)\n- [Poetry: "dependency management and packaging made easy"](https://youtu.be/QX_Nhu1zhlg?t=670) \n- [Creación de una aplicación CLI](https://www.youtube.com/watch?v=nNfgWhCqk4w&list=PL6cBnnS2SIgoSRRXYuvN6czVek-resNyl&ab_channel=Feregrino%E2%80%93ThatC%23guy)\n\n\n### Criterios de revisión\n\nLa especificación del problema describe una lista de requisitos sobre la funcionalidad y el enfoque requerido. La calificación se basa en cuántos de los requisitos se satisfacen con la solución dada.\n\nPara obtener el máximo crédito por el proyecto final, deberá:\n\n1. Entregar una propuesta de proyecto antes del jueves 16 de junio. La descripción de la propuesta solo necesita ser de un párrafo. Debe describir en palabras lo que hará su proyecto final. Revisaré su propuesta lo antes posible y se le informara si es aceptable. Coloque la descripción de su propuesta en un archivo de texto llamado propuesta.txt(o propuesta.md si lo prefiere, markdown) y súbalo a través de github.\n\n2. En su proyecto deberá utilizar programación modular (uso de funciones), paquetes (poetry), la librería numpy y matplolib. \n\n    En el caso de necesitar leer algún archivo de texto o CSV puede utilizar los métodos loadtxt, loadcsv de numpy ([revisar vídeo](https://www.youtube.com/watch?v=uGgKGuZqHuE)). Si son archivos de excel será más fácil utilizando la [librería pandas](https://www.quora.com/How-do-I-extract-data-from-Excel-into-NumPy).\n\n\n3. Documente y comente su código, utilice nombres de variables y funciones representativos. Dado que este es su proyecto y no un ejercicio ordinario, es posible que no sepamos lo que está tratando de hacer. La documentación nos permitirá comprender mejor sus intenciones. Agregue comentarios a sus códigos para informarnos sus intenciones, si no se distinguen fácilmente de los comandos de código específicos. El uso de nombres representativos en variables y funciones ayudará a sólo dejar comentarios en las partes importantes y no en todo el código.   \n\n4. Presente su proyecto a la clase el miércoles 27 de julio. Deberá tener claro lo que hizo y mostrar comprensión de su proyecto. No debe preparar una presentación formal (es decir, NO hacer un powerpoint). Simplemente describa oralmente lo que hizo para su proyecto y brinde una descripción general rápida de su (s) código (s) y los resultados obtenidos. Planee que su presentación tome solo 4 a 5 minutos. \n\n5. También debe entregar los archivos de datos necesarios para ejecutar sus códigos o proporcionar un enlace web donde se puedan descargar si pesa más de 100 MB. \n\n6. Actualizar el contenido de README.md empleando el archivo plantilla_README.md  \n\n\n### Ejemplos de ideas de proyectos\n\n- Aplicación para estimar el costo de construcción de una casa. \n- Aplicación para Funcionalidad de espacios (matriz de relaciones)\n- Aplicación para procesar datos de sensores. \n- Procesar datos desde un repositorio público. \n\n',
    'author': 'Danilo',
    'author_email': 'drleon416@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
