# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hypercat', 'hypercatgui']

package_data = \
{'': ['*']}

install_requires = \
['astropy',
 'h5py==2.9.0',
 'ipython>=7.24.1,<8.0.0',
 'jupyterlab>=3.0.16,<4.0.0',
 'matplotlib',
 'numpy',
 'pandas>=1.2.4,<2.0.0',
 'scikit-image',
 'scipy',
 'urwid>=2.0.1']

entry_points = \
{'console_scripts': ['hypercatgui = hypercatgui:main']}

setup_kwargs = {
    'name': 'hypercat',
    'version': '0.1.9',
    'description': 'Hypercube of clumpy AGN tori',
    'long_description': '![PyPI](https://img.shields.io/pypi/v/hypercat)\n![PyPI - Python Version](https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fpypi.org%2Fpypi%2Fhypercat%2Fjson&query=info.requires_python&label=python)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/hypercat)\n![GitHub issues](https://img.shields.io/github/issues/rnikutta/hypercat)\n\n\n# HYPERCAT\n\nHypercubes of (clumpy) AGN tori\n\n![Hypercat images at 2.2 and 30 micron, and their composite](./rgb.png)\n*Hypercat images at 2.2 and 30 micron, and their composite.*\n\n## Synopsis\n\nHandle a hypercube of CLUMPY brightness maps and 2D projected dust\nmaps. Easy-to-use classes and functions are provided to interpolate\nimages in many dimensions (spanned by the model parameters), extract\nmonochromatic or multi-wavelength images, as well as rotate images,\nzoom in and out, apply PSFs, extract interferometric signals, quantify\nmorphologies, etc.\n\n## Authors\n\nRobert Nikutta [\\<robert.nikutta@gmail.com\\>](mailto:robert.nikutta@gmail.com), Enrique Lopez-Rodriguez, Kohei Ichikawa\n\n## Version\n\nVersion of this document: 2022-09-20\n\nCurrent version of the HYPERCAT package: ![PyPI](https://img.shields.io/pypi/v/hypercat)\n\n## License and Attribution\n\nHYPERCAT is open-source software and freely available at\nhttps://github.com/rnikutta/hypercat/ and\nhttps://pypi.org/project/hypercat/ under a permissive [BSD 3-clause\nlicense](./LICENSE) .\n\nIn short, if you are using in your research any of the HYPERCAT\nsoftware or its components, and/or the HYPERCAT model data hypercubes,\nand/or telescope pupil images, please cite these two papers:\n\n- *Nikutta, Lopez-Rodriguez, Ichikawa, Levenson, Packham, Hönig,\n  Alonso-Herrero, "Hypercubes of AGN Tori (Hypercat) -- I. Models and\n  Image Morphology", ApJ (2021, accepted)*\n\n- *Nikutta, Lopez-Rodriguez, Ichikawa, Levenson, Packham, Hönig,\n  Alonso-Herrero, "Hypercubes of AGN Tori (Hypercat) -- II. Resolving\n  the torus with Extremely Large Telescopes", ApJ (2021, under\n  review)*\n\n\n## Minimal install instructions\n\nIf you don\'t mind installing HYPERCAT and its dependencies into your\ncurrent environment (real or virtual), simply run:\n\n```\npip install hypercat\n```\n\n\nIf you prefer to install HYPERCAT into a fresh new environment without affecting your existing Python installation, you can create a new environment in various ways.\n\n**If you are a user of conda / anaconda / miniconda / astroconda:**\n\nWe recommend to update the conda-installled packages first (but you also first try to install HYPERCAT without updating):\n\n```\nconda update --all\n```\n\nAfter that:\n\n```\nconda create -n hypercat-env python=3.7.2\nconda activate hypercat-env\n\npip install hypercat\n```\n\n**If you are a user of pyenv:**\n\n```\npyenv install 3.7.2\n. .venv/bin/activate\n\npip install hypercat\n```\n\n### Installation trouble-shooting\n\ntbw\n\n## HYPERCAT / CLUMPY model images and 2D dust cloud maps\n\nHypercat needs to access the hypercubes of Clumpy images and dust\nmaps. They can be downloaded as hdf5 files from the link given at\nhttps://www.clumpy.org/images/ (which currently is\nftp://ftp.tuc.noirlab.edu/pub/nikutta/hypercat/).\n\nWe offer several model files, which only differ in the wavelength range they cover:\n\n|File name                     | Size compressed / raw (GB) | Nwave | Wavelengths (micron) |\n|------------------------------|----------------------------|-------|----------------------|\n| hypercat_20200830_all.hdf5   | 271 / 913                  | 25    | all of the below     | \n| hypercat_20200830_nir.hdf5   |  44 / 146                  |  4    | 1.2, 2.2, 3.5, 4.8   | \n| hypercat_20200830_mir.hdf5   | 120 / 402                  | 11    | 8.7, 9.3, 9.8, 10, 10.3, 10.6, 11.3, 11.6, 12, 12.5, 18.5 | \n| hypercat_20200830_fir.hdf5   |  65 / 219                  |  6    | 31.5, 37.1, 53, 89, 154, 214 | \n| hypercat_20200830_submm.hdf5 |  42 / 146                  |  4    | 350, 460, 690, 945   | \n\n\n**Download and unpacking**\n\nFor example, the `*_all.hdf5.gz` file contains the image hypercube at\nall sampled wavelengths. This is the maximally compressed version of\nthe hdf5 file, which must be uncompressed on the user’s computer\nsystem. To reduce the peak storage required on the target computer,\nboth steps can be executed in one go (all commands in a single line):\n\n```\nlftp -e \'set net:timeout 10; cat /pub/nikutta/hypercat/hypercat_20200830_all.hdf5.gz; bye\' ftp.tuc.noirlab.edu | gunzip >\nhypercat_20200830_all.hdf5\n```\n\nThe program `lftp` must be installed on the target system, and 913 GB\nof space must be available on it (but only 271 GB of compressed data\nwill be downloaded).\n\n\n**File validation**\n\nOne should also download the checksums file\n`ftp://ftp.tuc.noirlab.edu/pub/nikutta/hypercat/hypercat_20200830.md5`\nand verify the hypercube file:\n\n```\n# this can take 30 minutes even on a modern computer\nmd5sum --ignore-missing -c hypercat_20200830.md5\nhypercat_20200830_all.hdf5: OK\n\n# or on MacOS and BSD variants\nmd5 hypercat_20200830_all.hdf5\n\n#... and compare the printed hash with the one in the .md5 file\n```\n\n**Pointing HYPERCAT to a model file**\n\nThe software, and the example Jupyter notebooks (see below) will need\nto be instructed about the location of the model file(s). This is very\neasy to do upon loading the model file; the notebooks have several\nexamples on how to accomplish this, e.g.\n\n```\nimport hypercat as hc\nfname = \'hypercat_20200830_all.hdf5\' # use your local location to the HDF5 model file\ncube = hc.ModelCube(fname,hypercube=\'imgdata\')  # use \'imgdata\' for brightness maps, and \'clddata\' for 2D cloud maps\n```\n\n## Example Jupyter notebooks\n\nSeveral Jupyter example notebooks demonstrate some of HYPERCAT\'s functionality:\n\n- [01-hypercat-basics.ipynb](https://github.com/rnikutta/hypercat/tree/master/examples/01-hypercat-basics.ipynb):\n  Loading a model hypercube, generating model images, images at\n  multiple wavelengths, images at multiple values of other model\n  parameters, accessing cloud maps\n\n- [02-hypercat-astro.ipynb](https://github.com/rnikutta/hypercat/tree/master/examples/02-hypercat-astro.ipynb):\n  Adding physical units to images, world coordinate system, field of\n  view and pixel scale operations, image rotation / position angle,\n  saving to FITS files\n\n- [03-hypercat-singledish.ipynb](https://github.com/rnikutta/hypercat/tree/master/examples/03-hypercat-singledish.ipynb):\n  Telescope pupil images (JWST, Keck, GMT, TMT, ELT), simulating\n  observations with single-dish telescopes, noisy observations,\n  Richardson-Lucy deconvolotuion, detector pixel scale, flux\n  preservation, observations at multiple wavelengths\n\n- [04-hypercat-morphology-intro.ipynb](https://github.com/rnikutta/hypercat/tree/master/examples/05-hypercat-morphology-intro.ipynb):\n  Introduction to morphological measurements (on 2D Gaussians), image\n  centroid, rotation, measuring size of emission features, elongation,\n  half-light radius, Gini coefficient\n\n- [05-hypercat-morphology-clumpy.ipynb](https://github.com/rnikutta/hypercat/tree/master/examples/05-hypercat-morphology-clumpy.ipynb):\n  Morphology of the HYPERCAT model images; morphological sizes,\n  elongation, centroid location; compare morphologies of of emission\n  and their underlying dust distributions; from 2D cloud maps to real\n  cloud numbers per LOS; photon escape probability along a LOS\n\n\n## User Manual\n\nWARNING -- the User Manual is still work-in-progress:\n\nFor more detailed installation instructions and other usage examples,\nplease see the HYPERCAT User Manual [User Manual](./docs/manual/) (in\naddition to the [example Jupyter notebooks](./examples/) )\n\n## Contributing\n\nBug fixes and feature contributions to HYPERCAT are welcome. Please\nmake a pull request against the \'master\' branch.\n',
    'author': 'Robert Nikutta',
    'author_email': 'robert.nikutta@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rnikutta/hypercat',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.2',
}


setup(**setup_kwargs)
