import motor.motor_asyncio
from fastapi_users.db import MongoDBUserDatabase

from backend.models.user import UserDB
from backend.core.settings.config import settings


client = motor.motor_asyncio.AsyncIOMotorClient(
    settings.DATABASE_URL, uuidRepresentation="standard"
)

db = client["database_name"]
collection = db["users"]


async def get_user_db():
    yield MongoDBUserDatabase(UserDB, collection)
