import logging
import sys
from deepdriver.sdk import util
import os

# Google introduced an incompatibility into protobuf-4.21.x
# that is not backwards compatible with many libraries.
# Once those libraries have updated to rebuild their _pb2.py files,
# this can be removed.
os.environ["PROTOCOL_BUFFERS_PYTHON_IMPLEMENTATION"] = "python"

logger = logging.getLogger("deepdriver")

console_handler = logging.StreamHandler(sys.stdout)
if not util.is_notebook():
    formatter = logging.Formatter('%(asctime)s %(levelname)s [%(name)s] [%(filename)s:%(lineno)d] - %(message)s')
    console_handler.setFormatter(formatter)
logger.setLevel(logging.INFO)
logger.addHandler(console_handler)


from deepdriver.sdk.artifact import *
from deepdriver.sdk.config import *
from deepdriver.sdk.experiment import *
from deepdriver.sdk.login import *
from deepdriver.sdk.setting import *
from deepdriver.sdk.run import *
from deepdriver.sdk.visualization import visualize
from deepdriver.sdk.chart.histogram import histogram
from deepdriver.sdk.chart.line import line
from deepdriver.sdk.chart.scatter import scatter
from deepdriver.sdk.chart.confusion_matrix import confusion_matrix
from deepdriver.sdk.chart.roc_curve import roc_curve
from deepdriver.sdk.data_types.dataFrame import DataFrame
from deepdriver.sdk.data_types.image import Image
from deepdriver.sdk.data_types.table import Table

from deepdriver.intergration.keras import keras
config = Config()


