# coding: utf-8

"""
    Marketing Events Extension

    These APIs allow you to interact with HubSpot's Marketing Events Extension. It allows you to: * Create, Read or update Marketing Event information in HubSpot * Specify whether a HubSpot contact has registered, attended or cancelled a registration to a Marketing Event. * Specify a URL that can be called to get the details of a Marketing Event.   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.marketing.events.configuration import Configuration


class PropertyValue(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "value": "str",
        "timestamp": "int",
        "source_id": "str",
        "source_label": "str",
        "source": "str",
        "selected_by_user": "bool",
        "selected_by_user_timestamp": "int",
        "source_vid": "list[int]",
        "source_metadata": "str",
        "request_id": "str",
        "updated_by_user_id": "int",
    }

    attribute_map = {
        "name": "name",
        "value": "value",
        "timestamp": "timestamp",
        "source_id": "sourceId",
        "source_label": "sourceLabel",
        "source": "source",
        "selected_by_user": "selectedByUser",
        "selected_by_user_timestamp": "selectedByUserTimestamp",
        "source_vid": "sourceVid",
        "source_metadata": "sourceMetadata",
        "request_id": "requestId",
        "updated_by_user_id": "updatedByUserId",
    }

    def __init__(
        self,
        name=None,
        value=None,
        timestamp=None,
        source_id=None,
        source_label=None,
        source=None,
        selected_by_user=None,
        selected_by_user_timestamp=None,
        source_vid=None,
        source_metadata=None,
        request_id=None,
        updated_by_user_id=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """PropertyValue - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._value = None
        self._timestamp = None
        self._source_id = None
        self._source_label = None
        self._source = None
        self._selected_by_user = None
        self._selected_by_user_timestamp = None
        self._source_vid = None
        self._source_metadata = None
        self._request_id = None
        self._updated_by_user_id = None
        self.discriminator = None

        self.name = name
        self.value = value
        self.timestamp = timestamp
        self.source_id = source_id
        self.source_label = source_label
        self.source = source
        self.selected_by_user = selected_by_user
        self.selected_by_user_timestamp = selected_by_user_timestamp
        self.source_vid = source_vid
        self.source_metadata = source_metadata
        self.request_id = request_id
        if updated_by_user_id is not None:
            self.updated_by_user_id = updated_by_user_id

    @property
    def name(self):
        """Gets the name of this PropertyValue.  # noqa: E501


        :return: The name of this PropertyValue.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PropertyValue.


        :param name: The name of this PropertyValue.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def value(self):
        """Gets the value of this PropertyValue.  # noqa: E501


        :return: The value of this PropertyValue.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this PropertyValue.


        :param value: The value of this PropertyValue.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    @property
    def timestamp(self):
        """Gets the timestamp of this PropertyValue.  # noqa: E501


        :return: The timestamp of this PropertyValue.  # noqa: E501
        :rtype: int
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this PropertyValue.


        :param timestamp: The timestamp of this PropertyValue.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and timestamp is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp`, must not be `None`")  # noqa: E501

        self._timestamp = timestamp

    @property
    def source_id(self):
        """Gets the source_id of this PropertyValue.  # noqa: E501


        :return: The source_id of this PropertyValue.  # noqa: E501
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id):
        """Sets the source_id of this PropertyValue.


        :param source_id: The source_id of this PropertyValue.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source_id is None:  # noqa: E501
            raise ValueError("Invalid value for `source_id`, must not be `None`")  # noqa: E501

        self._source_id = source_id

    @property
    def source_label(self):
        """Gets the source_label of this PropertyValue.  # noqa: E501


        :return: The source_label of this PropertyValue.  # noqa: E501
        :rtype: str
        """
        return self._source_label

    @source_label.setter
    def source_label(self, source_label):
        """Sets the source_label of this PropertyValue.


        :param source_label: The source_label of this PropertyValue.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source_label is None:  # noqa: E501
            raise ValueError("Invalid value for `source_label`, must not be `None`")  # noqa: E501

        self._source_label = source_label

    @property
    def source(self):
        """Gets the source of this PropertyValue.  # noqa: E501


        :return: The source of this PropertyValue.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this PropertyValue.


        :param source: The source of this PropertyValue.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source is None:  # noqa: E501
            raise ValueError("Invalid value for `source`, must not be `None`")  # noqa: E501
        allowed_values = [
            "IMPORT",
            "API",
            "FORM",
            "ANALYTICS",
            "MIGRATION",
            "SALESFORCE",
            "INTEGRATION",
            "CONTACTS_WEB",
            "WAL_INCREMENTAL",
            "TASK",
            "EMAIL",
            "WORKFLOWS",
            "CALCULATED",
            "SOCIAL",
            "BATCH_UPDATE",
            "SIGNALS",
            "BIDEN",
            "DEFAULT",
            "COMPANIES",
            "DEALS",
            "ASSISTS",
            "PRESENTATIONS",
            "TALLY",
            "SIDEKICK",
            "CRM_UI",
            "MERGE_CONTACTS",
            "PORTAL_USER_ASSOCIATOR",
            "INTEGRATIONS_PLATFORM",
            "BCC_TO_CRM",
            "FORWARD_TO_CRM",
            "ENGAGEMENTS",
            "SALES",
            "HEISENBERG",
            "LEADIN",
            "GMAIL_INTEGRATION",
            "ACADEMY",
            "SALES_MESSAGES",
            "AVATARS_SERVICE",
            "MERGE_COMPANIES",
            "SEQUENCES",
            "COMPANY_FAMILIES",
            "MOBILE_IOS",
            "MOBILE_ANDROID",
            "CONTACTS",
            "ASSOCIATIONS",
            "EXTENSION",
            "SUCCESS",
            "BOT",
            "INTEGRATIONS_SYNC",
            "AUTOMATION_PLATFORM",
            "CONVERSATIONS",
            "EMAIL_INTEGRATION",
            "CONTENT_MEMBERSHIP",
            "QUOTES",
            "BET_ASSIGNMENT",
            "QUOTAS",
            "BET_CRM_CONNECTOR",
            "MEETINGS",
            "MERGE_OBJECTS",
            "RECYCLING_BIN",
            "ADS",
            "AI_GROUP",
            "COMMUNICATOR",
            "SETTINGS",
            "PROPERTY_SETTINGS",
            "PIPELINE_SETTINGS",
            "COMPANY_INSIGHTS",
            "BEHAVIORAL_EVENTS",
            "PAYMENTS",
            "GOALS",
            "PORTAL_OBJECT_SYNC",
            "APPROVALS",
        ]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and source not in allowed_values:  # noqa: E501
            raise ValueError("Invalid value for `source` ({0}), must be one of {1}".format(source, allowed_values))  # noqa: E501

        self._source = source

    @property
    def selected_by_user(self):
        """Gets the selected_by_user of this PropertyValue.  # noqa: E501


        :return: The selected_by_user of this PropertyValue.  # noqa: E501
        :rtype: bool
        """
        return self._selected_by_user

    @selected_by_user.setter
    def selected_by_user(self, selected_by_user):
        """Sets the selected_by_user of this PropertyValue.


        :param selected_by_user: The selected_by_user of this PropertyValue.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and selected_by_user is None:  # noqa: E501
            raise ValueError("Invalid value for `selected_by_user`, must not be `None`")  # noqa: E501

        self._selected_by_user = selected_by_user

    @property
    def selected_by_user_timestamp(self):
        """Gets the selected_by_user_timestamp of this PropertyValue.  # noqa: E501


        :return: The selected_by_user_timestamp of this PropertyValue.  # noqa: E501
        :rtype: int
        """
        return self._selected_by_user_timestamp

    @selected_by_user_timestamp.setter
    def selected_by_user_timestamp(self, selected_by_user_timestamp):
        """Sets the selected_by_user_timestamp of this PropertyValue.


        :param selected_by_user_timestamp: The selected_by_user_timestamp of this PropertyValue.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and selected_by_user_timestamp is None:  # noqa: E501
            raise ValueError("Invalid value for `selected_by_user_timestamp`, must not be `None`")  # noqa: E501

        self._selected_by_user_timestamp = selected_by_user_timestamp

    @property
    def source_vid(self):
        """Gets the source_vid of this PropertyValue.  # noqa: E501


        :return: The source_vid of this PropertyValue.  # noqa: E501
        :rtype: list[int]
        """
        return self._source_vid

    @source_vid.setter
    def source_vid(self, source_vid):
        """Sets the source_vid of this PropertyValue.


        :param source_vid: The source_vid of this PropertyValue.  # noqa: E501
        :type: list[int]
        """
        if self.local_vars_configuration.client_side_validation and source_vid is None:  # noqa: E501
            raise ValueError("Invalid value for `source_vid`, must not be `None`")  # noqa: E501

        self._source_vid = source_vid

    @property
    def source_metadata(self):
        """Gets the source_metadata of this PropertyValue.  # noqa: E501

        Source metadata encoded as a base64 string. For example: `ZXhhbXBsZSBzdHJpbmc=`  # noqa: E501

        :return: The source_metadata of this PropertyValue.  # noqa: E501
        :rtype: str
        """
        return self._source_metadata

    @source_metadata.setter
    def source_metadata(self, source_metadata):
        """Sets the source_metadata of this PropertyValue.

        Source metadata encoded as a base64 string. For example: `ZXhhbXBsZSBzdHJpbmc=`  # noqa: E501

        :param source_metadata: The source_metadata of this PropertyValue.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source_metadata is None:  # noqa: E501
            raise ValueError("Invalid value for `source_metadata`, must not be `None`")  # noqa: E501

        self._source_metadata = source_metadata

    @property
    def request_id(self):
        """Gets the request_id of this PropertyValue.  # noqa: E501


        :return: The request_id of this PropertyValue.  # noqa: E501
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this PropertyValue.


        :param request_id: The request_id of this PropertyValue.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and request_id is None:  # noqa: E501
            raise ValueError("Invalid value for `request_id`, must not be `None`")  # noqa: E501

        self._request_id = request_id

    @property
    def updated_by_user_id(self):
        """Gets the updated_by_user_id of this PropertyValue.  # noqa: E501


        :return: The updated_by_user_id of this PropertyValue.  # noqa: E501
        :rtype: int
        """
        return self._updated_by_user_id

    @updated_by_user_id.setter
    def updated_by_user_id(self, updated_by_user_id):
        """Sets the updated_by_user_id of this PropertyValue.


        :param updated_by_user_id: The updated_by_user_id of this PropertyValue.  # noqa: E501
        :type: int
        """

        self._updated_by_user_id = updated_by_user_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item, value.items()))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PropertyValue):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PropertyValue):
            return True

        return self.to_dict() != other.to_dict()
