# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['drf_integrations',
 'drf_integrations.integrations',
 'drf_integrations.management',
 'drf_integrations.management.commands',
 'drf_integrations.migrations']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=9.1.0,<10.0.0',
 'django-oauth-toolkit>=1.3,<1.5',
 'djangorestframework>=3.11.0,<4.0.0']

setup_kwargs = {
    'name': 'drf-integrations-framework',
    'version': '0.8.1',
    'description': 'Django REST Framework plugin that simplifies the management of third party integrations',
    'long_description': '# DRF Integrations Framework\n\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n[![Build Status](https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fyoyowallet%2Fdrf-integrations-framework%2Fbadge%3Fref%3Dmaster&style=flat)](https://actions-badge.atrox.dev/yoyowallet/drf-integrations-framework/goto?ref=master)\n\nDRF Integrations Framework is a toolkit that plugs in to [Django REST Framework](https://www.django-rest-framework.org/)\nand simplifies the management of third party integrations. If you find yourself connecting to multiple services with\ndifferent sets of credentials, or handling multiple inbound requests from third party services, DRF Integrations\nFramework will probably simplify that for you. DRF Integrations Framework will help you split the responsibilities\nbetween the source/destiny of events, how these requests are authenticated and the business logic associated to them.\n\n## Requirements\n- Python 3.7+\n- Django 2.2+\n- Django REST Framework 3.9.2+\n- Django OAuth Toolkit 1.7.1+\n\n## Installation\n\nThe following library is required in order to build on `Linux systems`. It fixes the\nproblem where `Error: pg_config executable not found.` is given when installing psycopg2\nvia `poetry install`\n```\nsudo apt install libpq-dev\n```\n\nInstall from PyPi:\n```bash\npip install drf-integrations-framework\n```\nOr install from source:\n```bash\npip install https://github.com/yoyowallet/drf-integrations-framework/archive/v0.7.1.tar.gz\n```\n\nAdd the apps to your `INSTALLED_APPS`:\n```python\nINSTALLED_APPS = [\n    ...,\n    "rest_framework",\n    "oauth2_provider",\n    "drf_integrations",\n]\n```\n\nIf you are going to configure any inbound integration, you will want to add the integration URLs to your `urls.py`:\n```python\nfrom drf_integrations import integrations\n\nurlpatterns = [\n    ...\n] + integrations.get_urls()\n```\n\n## Configuration\n### Settings\nDRF Integrations Framework relies on Django OAuth Toolkit to manage third party applications. In order to be able to use\nit, first you\'ll need to configure DOT by setting (at least) the model references in your settings.\n```python\nOAUTH2_PROVIDER_APPLICATION_MODEL = "drf_integrations.Application"\nOAUTH2_PROVIDER_ACCESS_TOKEN_MODEL = "drf_integrations.AccessToken"\nOAUTH2_PROVIDER_GRANT_MODEL = "drf_integrations.Grant"\nOAUTH2_PROVIDER_REFRESH_TOKEN_MODEL = "drf_integrations.RefreshToken"\n```\nThen, similarly, you will have to configure the model for the integrations.\n```python\nINTEGRATIONS_APPLICATION_INSTALLATION_MODEL = "drf_integrations.ApplicationInstallation"\n```\nYou will also have to configure how the integrations are stored in the database. On the one hand, you will have to set\nthe type of JSON field your DB uses. On the other hand, you will have to set the name of the attribute where you want to\nrelate the integrations.\n```python\nDB_BACKEND_JSON_FIELD = "django.db.models.JSONField"\nINTEGRATIONS_APPLICATION_INSTALLATION_INSTALL_ATTRIBUTE = "organisation"\n```\nFinally, you have to set the list of integrations that are available in your system (see the following section to learn\nabout creating integrations).\n```python\nINSTALLED_INTEGRATIONS = [\n    "example.drf_integrations_example.api.integrations.APIClientIntegration",\n]\n```\n### Creating integrations\nAn integration is represented by an extension of `BaseIntegration`. Then, the integration will be available to be\ninstalled to different clients (as related with the previously configured\n`INTEGRATIONS_APPLICATION_INSTALLATION_INSTALL_ATTRIBUTE`) once it is stored into an `Application`. This can be done in\ntwo different ways:\n1. Internal integrations (or non-local integrations) are those that can be configured once and installed to different clients with different\nparameters. For example, your system may connect to Mixpanel, the connections and interactions with the service are all\nthe same, only the secret in the connection changes.\n\n   These will only have 1 `Application` object in the database, and it can be related to multiple installations. They\n   can also be automatically created by using the `syncregistry` management command.\n   ```bash\n   python manage.py syncregistry\n   ```\n\n1. Local integrations are those that are specific to just one client. For example, OAuth clients are local, there is\n1 application per client, which will have the specific credentials for them, so they can only be installed once. These\nare usually created on demand as required by clients.\n\nAn integration broadly has 3 functions:\n1. Generates a list of URLs that a third party represented by this integration can connect to.\nMainly used for inward integrations.\n1. Returns a client that can connect to the third party it represents. Mainly used for outward integrations.\n1. Produce queryset filter lookups to search for installations of the integration.\n\nOnce you have a class inheriting from `BaseIntegration` that represents a third party, simply add it to\n`INSTALLED_INTEGRATIONS` in your settings and the sky is the limit! You can create custom authentication backends,\npermissions, event hooks... Take a look at [the example](example) to see some basic examples of how you can make use\nof DRF Integrations Framework.\n\n### Preconfigured\nThere are some features that DRF Integrations Framework provides out of the box.\n\n- Admin model for `ApplicationInstallation` that already handles integration-specific configuration via dynamic forms.\n- Automatic form validation for integrations that have one.\n- An authentication backend for local OAuth2 integrations\n(`drf_integrations.auth_backends.IntegrationOAuth2Authentication`).\n\n## Running the tests\n\nTo run the tests you need to have a postgresql server running on localhost and have a\npostgres user/role defined. To create the postgres user and role you can use the\nfollowing:\n\n```psql -c \'CREATE ROLE postgres WITH LOGIN SUPERUSER\' ```\n\nTo run the tests execute the following\n\n```make tests```\n\nIf running tests under pycharm ensure that `python tests` -> `pytest` is used and set\nthe `Additional Arguments` to `--no-migrations`\n\nFailing to specify `--no-migrations` will result in the following error:\n```\nValueError: Related model \'oauth2_provider.idtoken\' cannot be resolved\n```\n\n## Changelog\nSee [Releases](https://github.com/yoyowallet/drf-integrations-framework/releases)\n\n## Authors\nDRF Integrations Framework is an original idea by [@jianyuan](https://github.com/jianyuan), developed and maintained by\nthe platform team at [@yoyowallet](https://github.com/yoyowallet).\n',
    'author': 'Yoyo',
    'author_email': 'dev@yoyowallet.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/yoyowallet/drf-integrations-framework',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
