# Datahub-py

Pip version of Datahub core

Emitter focused for now, with buffered queue if RabbitMQ isn't running on the local network, rabbitMQ auto-connect, buffer delivery on connection.

Service auto-discovery on the entire wifi network via /specs endpoint


## Project Integration

```
from datahub_py import Project
import config

project = Project(config)
project.beacon.emit("my_queue", { "hello": "world" })

project.beacon.helper.get_local_ip_address()
project.beacon.helper.find_emitters_and_consumers()
project.beacon.helper.find_on_ip("192.168.0.3")
project.beacon.helper.get_available_port()
project.beacon.helper.get_rabbitmq_local_ip()
project.beacon.callService(address, port, endpoint, params)
```


## Build & deploy from source

```
  pip install -e .
  python setup.py sdist
  twine upload dist/datahub_py-0.0.12.tar.gz
  twine upload dist/datahub_py-{version}.tar.gz

  pip uninstall datahub_py && pip install datahub_py
```