import asyncio
from abc import ABCMeta
from typing import Dict, Generic

from web_foundation.kernel.container import GenericDependencyContainer
from web_foundation.kernel.messaging.channel import IChannel


class Isolate(Generic[GenericDependencyContainer], metaclass=ABCMeta):
    name: str
    channel: IChannel
    container: GenericDependencyContainer
    init_kwargs: Dict

    def __init__(self, name: str, container: GenericDependencyContainer, **kwargs):
        self.name = name
        self.container = container
        self.channel = IChannel(f"Channel_{name}")
        self.init_kwargs = kwargs

    async def work(self, **kwargs) -> None:
        raise NotImplementedError

    def run_forked(self) -> None:
        async def call():
            nonlocal self
            await self.container.init_resources()
            asyncio.create_task(self.channel.listen_consume())
            await self.work(**self.init_kwargs)
            await self.container.shutdown_resources()

        try:
            asyncio.run(call())
        except KeyboardInterrupt:
            asyncio.run(self.container.shutdown_resources())
            self.close()

    def close(self):
        pass
