#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) 2021 Satpy developers
#
# This file is part of satpy.
#
# satpy is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# satpy is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# satpy.  If not, see <http://www.gnu.org/licenses/>.
"""Module for testing the satpy.readers.msi_safe module."""
import unittest
import unittest.mock as mock
from io import BytesIO, StringIO

import numpy as np
import pytest
import xarray as xr

from satpy.tests.utils import make_dataid

mtd_tile_xml = b"""<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<n1:Level-1C_Tile_ID xmlns:n1="https://psd-14.sentinel2.eo.esa.int/PSD/S2_PDI_Level-1C_Tile_Metadata.xsd" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="https://psd-14.sentinel2.eo.esa.int/PSD/S2_PDI_Level-1C_Tile_Metadata.xsd /gpfs/dpc/app/s2ipf/FORMAT_METADATA_TILE_L1C/02.14.00/scripts/../../../schemas/02.17.00/PSD/S2_PDI_Level-1C_Tile_Metadata.xsd">

  <n1:General_Info>
    <TILE_ID metadataLevel="Brief">S2B_OPER_MSI_L1C_TL_VGS1_20201001T183541_A018656_T16SEB_N02.09</TILE_ID>
    <DATASTRIP_ID metadataLevel="Standard">S2B_OPER_MSI_L1C_DS_VGS1_20201001T183541_S20201001T162735_N02.09</DATASTRIP_ID>
    <DOWNLINK_PRIORITY metadataLevel="Standard">NOMINAL</DOWNLINK_PRIORITY>
    <SENSING_TIME metadataLevel="Standard">2020-10-01T16:34:23.153611Z</SENSING_TIME>
    <Archiving_Info metadataLevel="Expertise">
      <ARCHIVING_CENTRE>VGS1</ARCHIVING_CENTRE>
      <ARCHIVING_TIME>2020-10-01T18:55:55.59803Z</ARCHIVING_TIME>
    </Archiving_Info>
  </n1:General_Info>

  <n1:Geometric_Info>
    <Tile_Geocoding metadataLevel="Brief">
      <HORIZONTAL_CS_NAME>WGS84 / UTM zone 16N</HORIZONTAL_CS_NAME>
      <HORIZONTAL_CS_CODE>EPSG:32616</HORIZONTAL_CS_CODE>
      <Size resolution="10">
        <NROWS>10980</NROWS>
        <NCOLS>10980</NCOLS>
      </Size>
      <Size resolution="20">
        <NROWS>5490</NROWS>
        <NCOLS>5490</NCOLS>
      </Size>
      <Size resolution="60">
        <NROWS>1830</NROWS>
        <NCOLS>1830</NCOLS>
      </Size>
      <Geoposition resolution="10">
        <ULX>499980</ULX>
        <ULY>3700020</ULY>
        <XDIM>10</XDIM>
        <YDIM>-10</YDIM>
      </Geoposition>
      <Geoposition resolution="20">
        <ULX>499980</ULX>
        <ULY>3700020</ULY>
        <XDIM>20</XDIM>
        <YDIM>-20</YDIM>
      </Geoposition>
      <Geoposition resolution="60">
        <ULX>499980</ULX>
        <ULY>3700020</ULY>
        <XDIM>60</XDIM>
        <YDIM>-60</YDIM>
      </Geoposition>
    </Tile_Geocoding>
    <Tile_Angles metadataLevel="Standard">
      <Sun_Angles_Grid>
        <Zenith>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>39.8824 39.8636 39.8448 39.8261 39.8074 39.7888 39.7702 39.7516 39.7331 39.7145 39.6961 39.6776 39.6592 39.6408 39.6225 39.6042 39.5859 39.5677 39.5495 39.5313 39.5132 39.4951 39.477</VALUES>
            <VALUES>39.8404 39.8216 39.8029 39.7841 39.7655 39.7468 39.7282 39.7096 39.691 39.6725 39.654 39.6355 39.6171 39.5987 39.5804 39.5621 39.5438 39.5255 39.5073 39.4891 39.471 39.4529 39.4348</VALUES>
            <VALUES>39.7985 39.7797 39.7609 39.7422 39.7235 39.7048 39.6862 39.6675 39.649 39.6304 39.6119 39.5935 39.575 39.5566 39.5383 39.5199 39.5016 39.4834 39.4651 39.4469 39.4288 39.4107 39.3926</VALUES>
            <VALUES>39.7566 39.7377 39.719 39.7002 39.6815 39.6628 39.6441 39.6255 39.6069 39.5884 39.5699 39.5514 39.533 39.5145 39.4962 39.4778 39.4595 39.4412 39.423 39.4048 39.3866 39.3685 39.3504</VALUES>
            <VALUES>39.7146 39.6958 39.677 39.6582 39.6395 39.6208 39.6021 39.5835 39.5649 39.5464 39.5278 39.5093 39.4909 39.4724 39.4541 39.4357 39.4174 39.3991 39.3808 39.3626 39.3444 39.3263 39.3082</VALUES>
            <VALUES>39.6727 39.6539 39.635 39.6163 39.5975 39.5788 39.5601 39.5415 39.5229 39.5043 39.4858 39.4673 39.4488 39.4304 39.412 39.3936 39.3752 39.3569 39.3387 39.3204 39.3023 39.2841 39.266</VALUES>
            <VALUES>39.6308 39.6119 39.5931 39.5743 39.5556 39.5368 39.5181 39.4995 39.4809 39.4623 39.4437 39.4252 39.4067 39.3883 39.3699 39.3515 39.3331 39.3148 39.2965 39.2783 39.2601 39.2419 39.2238</VALUES>
            <VALUES>39.5889 39.57 39.5512 39.5324 39.5136 39.4949 39.4762 39.4575 39.4389 39.4203 39.4017 39.3832 39.3647 39.3462 39.3278 39.3094 39.291 39.2727 39.2544 39.2361 39.2179 39.1997 39.1816</VALUES>
            <VALUES>39.547 39.5281 39.5092 39.4904 39.4716 39.4529 39.4342 39.4155 39.3968 39.3782 39.3596 39.3411 39.3226 39.3041 39.2857 39.2673 39.2489 39.2306 39.2123 39.194 39.1758 39.1576 39.1394</VALUES>
            <VALUES>39.5051 39.4862 39.4673 39.4485 39.4297 39.4109 39.3922 39.3735 39.3548 39.3362 39.3176 39.2991 39.2805 39.2621 39.2436 39.2252 39.2068 39.1884 39.1701 39.1518 39.1336 39.1154 39.0972</VALUES>
            <VALUES>39.4632 39.4442 39.4254 39.4065 39.3877 39.3689 39.3502 39.3315 39.3128 39.2942 39.2756 39.257 39.2385 39.22 39.2015 39.1831 39.1647 39.1463 39.128 39.1097 39.0914 39.0732 39.055</VALUES>
            <VALUES>39.4213 39.4023 39.3834 39.3646 39.3458 39.327 39.3082 39.2895 39.2708 39.2522 39.2336 39.215 39.1964 39.1779 39.1594 39.141 39.1226 39.1042 39.0859 39.0676 39.0493 39.0311 39.0129</VALUES>
            <VALUES>39.3794 39.3604 39.3415 39.3227 39.3038 39.285 39.2663 39.2475 39.2288 39.2102 39.1915 39.1729 39.1544 39.1359 39.1174 39.0989 39.0805 39.0621 39.0438 39.0254 39.0072 38.9889 38.9707</VALUES>
            <VALUES>39.3375 39.3185 39.2996 39.2807 39.2619 39.2431 39.2243 39.2056 39.1868 39.1682 39.1495 39.1309 39.1123 39.0938 39.0753 39.0568 39.0384 39.02 39.0016 38.9833 38.965 38.9468 38.9285</VALUES>
            <VALUES>39.2956 39.2766 39.2577 39.2388 39.22 39.2011 39.1823 39.1636 39.1449 39.1262 39.1075 39.0889 39.0703 39.0518 39.0332 39.0148 38.9963 38.9779 38.9595 38.9412 38.9229 38.9046 38.8864</VALUES>
            <VALUES>39.2537 39.2348 39.2158 39.1969 39.178 39.1592 39.1404 39.1216 39.1029 39.0842 39.0655 39.0469 39.0283 39.0097 38.9912 38.9727 38.9542 38.9358 38.9174 38.8991 38.8807 38.8625 38.8442</VALUES>
            <VALUES>39.2119 39.1929 39.1739 39.155 39.1361 39.1173 39.0984 39.0797 39.0609 39.0422 39.0235 39.0049 38.9862 38.9677 38.9491 38.9306 38.9122 38.8937 38.8753 38.8569 38.8386 38.8203 38.8021</VALUES>
            <VALUES>39.17 39.151 39.132 39.1131 39.0942 39.0753 39.0565 39.0377 39.0189 39.0002 38.9815 38.9628 38.9442 38.9256 38.9071 38.8886 38.8701 38.8516 38.8332 38.8148 38.7965 38.7782 38.7599</VALUES>
            <VALUES>39.1281 39.1091 39.0901 39.0712 39.0523 39.0334 39.0145 38.9957 38.977 38.9582 38.9395 38.9208 38.9022 38.8836 38.865 38.8465 38.828 38.8095 38.7911 38.7727 38.7544 38.736 38.7178</VALUES>
            <VALUES>39.0863 39.0672 39.0482 39.0293 39.0104 38.9915 38.9726 38.9538 38.935 38.9162 38.8975 38.8788 38.8602 38.8416 38.823 38.8045 38.7859 38.7675 38.749 38.7306 38.7122 38.6939 38.6756</VALUES>
            <VALUES>39.0444 39.0254 39.0064 38.9874 38.9685 38.9496 38.9307 38.9118 38.893 38.8743 38.8555 38.8368 38.8182 38.7996 38.781 38.7624 38.7439 38.7254 38.7069 38.6885 38.6701 38.6518 38.6335</VALUES>
            <VALUES>39.0026 38.9835 38.9645 38.9455 38.9266 38.9076 38.8888 38.8699 38.8511 38.8323 38.8136 38.7949 38.7762 38.7575 38.7389 38.7204 38.7018 38.6833 38.6649 38.6464 38.628 38.6097 38.5913</VALUES>
            <VALUES>38.9607 38.9417 38.9226 38.9036 38.8847 38.8657 38.8468 38.828 38.8091 38.7903 38.7716 38.7529 38.7342 38.7155 38.6969 38.6783 38.6598 38.6413 38.6228 38.6043 38.5859 38.5676 38.5492</VALUES>
          </Values_List>
        </Zenith>
        <Azimuth>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>154.971 155.049 155.126 155.204 155.282 155.359 155.437 155.515 155.593 155.671 155.749 155.827 155.905 155.983 156.061 156.14 156.218 156.296 156.375 156.453 156.532 156.61 156.689</VALUES>
            <VALUES>154.953 155.03 155.108 155.186 155.263 155.341 155.419 155.497 155.575 155.653 155.731 155.809 155.887 155.965 156.043 156.122 156.2 156.278 156.357 156.435 156.514 156.592 156.671</VALUES>
            <VALUES>154.934 155.012 155.09 155.167 155.245 155.323 155.401 155.478 155.556 155.634 155.712 155.79 155.869 155.947 156.025 156.103 156.182 156.26 156.338 156.417 156.495 156.574 156.653</VALUES>
            <VALUES>154.916 154.994 155.071 155.149 155.227 155.304 155.382 155.46 155.538 155.616 155.694 155.772 155.85 155.928 156.007 156.085 156.163 156.242 156.32 156.399 156.477 156.556 156.634</VALUES>
            <VALUES>154.897 154.975 155.053 155.13 155.208 155.286 155.364 155.442 155.52 155.598 155.676 155.754 155.832 155.91 155.988 156.067 156.145 156.223 156.302 156.38 156.459 156.538 156.616</VALUES>
            <VALUES>154.879 154.956 155.034 155.112 155.19 155.267 155.345 155.423 155.501 155.579 155.657 155.735 155.814 155.892 155.97 156.048 156.127 156.205 156.284 156.362 156.441 156.519 156.598</VALUES>
            <VALUES>154.86 154.938 155.015 155.093 155.171 155.249 155.327 155.405 155.483 155.561 155.639 155.717 155.795 155.873 155.952 156.03 156.108 156.187 156.265 156.344 156.422 156.501 156.58</VALUES>
            <VALUES>154.841 154.919 154.997 155.075 155.152 155.23 155.308 155.386 155.464 155.542 155.62 155.698 155.777 155.855 155.933 156.012 156.09 156.168 156.247 156.325 156.404 156.483 156.561</VALUES>
            <VALUES>154.823 154.9 154.978 155.056 155.134 155.212 155.289 155.367 155.445 155.524 155.602 155.68 155.758 155.836 155.915 155.993 156.071 156.15 156.228 156.307 156.386 156.464 156.543</VALUES>
            <VALUES>154.804 154.882 154.959 155.037 155.115 155.193 155.271 155.349 155.427 155.505 155.583 155.661 155.739 155.818 155.896 155.974 156.053 156.131 156.21 156.289 156.367 156.446 156.525</VALUES>
            <VALUES>154.785 154.863 154.941 155.018 155.096 155.174 155.252 155.33 155.408 155.486 155.564 155.643 155.721 155.799 155.878 155.956 156.034 156.113 156.191 156.27 156.349 156.427 156.506</VALUES>
            <VALUES>154.766 154.844 154.922 155 155.077 155.155 155.233 155.311 155.389 155.467 155.546 155.624 155.702 155.78 155.859 155.937 156.016 156.094 156.173 156.251 156.33 156.409 156.488</VALUES>
            <VALUES>154.747 154.825 154.903 154.981 155.059 155.136 155.214 155.292 155.371 155.449 155.527 155.605 155.683 155.762 155.84 155.919 155.997 156.076 156.154 156.233 156.312 156.39 156.469</VALUES>
            <VALUES>154.728 154.806 154.884 154.962 155.04 155.118 155.196 155.274 155.352 155.43 155.508 155.586 155.665 155.743 155.821 155.9 155.978 156.057 156.136 156.214 156.293 156.372 156.451</VALUES>
            <VALUES>154.709 154.787 154.865 154.943 155.021 155.099 155.177 155.255 155.333 155.411 155.489 155.568 155.646 155.724 155.803 155.881 155.96 156.038 156.117 156.196 156.274 156.353 156.432</VALUES>
            <VALUES>154.69 154.768 154.846 154.924 155.002 155.08 155.158 155.236 155.314 155.392 155.47 155.549 155.627 155.705 155.784 155.862 155.941 156.019 156.098 156.177 156.256 156.334 156.413</VALUES>
            <VALUES>154.671 154.749 154.827 154.905 154.983 155.061 155.139 155.217 155.295 155.373 155.451 155.53 155.608 155.686 155.765 155.843 155.922 156.001 156.079 156.158 156.237 156.316 156.394</VALUES>
            <VALUES>154.652 154.73 154.808 154.886 154.964 155.042 155.12 155.198 155.276 155.354 155.432 155.511 155.589 155.668 155.746 155.825 155.903 155.982 156.06 156.139 156.218 156.297 156.376</VALUES>
            <VALUES>154.633 154.711 154.789 154.866 154.944 155.022 155.101 155.179 155.257 155.335 155.413 155.492 155.57 155.649 155.727 155.806 155.884 155.963 156.042 156.12 156.199 156.278 156.357</VALUES>
            <VALUES>154.614 154.691 154.769 154.847 154.925 155.003 155.081 155.16 155.238 155.316 155.394 155.473 155.551 155.63 155.708 155.787 155.865 155.944 156.023 156.101 156.18 156.259 156.338</VALUES>
            <VALUES>154.594 154.672 154.75 154.828 154.906 154.984 155.062 155.14 155.219 155.297 155.375 155.454 155.532 155.61 155.689 155.768 155.846 155.925 156.004 156.082 156.161 156.24 156.319</VALUES>
            <VALUES>154.575 154.653 154.731 154.809 154.887 154.965 155.043 155.121 155.199 155.278 155.356 155.434 155.513 155.591 155.67 155.748 155.827 155.906 155.985 156.063 156.142 156.221 156.3</VALUES>
            <VALUES>154.556 154.633 154.711 154.789 154.867 154.945 155.024 155.102 155.18 155.258 155.337 155.415 155.494 155.572 155.651 155.729 155.808 155.887 155.965 156.044 156.123 156.202 156.281</VALUES>
          </Values_List>
        </Azimuth>
      </Sun_Angles_Grid>
      <Mean_Sun_Angle>
        <ZENITH_ANGLE unit="deg">39.2158335161115</ZENITH_ANGLE>
        <AZIMUTH_ANGLE unit="deg">155.62398389104</AZIMUTH_ANGLE>
      </Mean_Sun_Angle>
      <Viewing_Incidence_Angles_Grids bandId="1" detectorId="1">
        <Zenith>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN 11.7128 11.3368 10.9601 10.5837 10.2053 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN 11.6285 11.2531 10.8763 10.4977 10.1207 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>11.9203 11.5439 11.1676 10.79 10.4135 10.036 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>11.8359 11.4595 11.0825 10.7054 10.3284 9.95143 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>11.751 11.3743 10.9977 10.6209 10.2437 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>11.6664 11.2901 10.9134 10.5362 10.1591 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>11.5818 11.2061 10.8293 10.4518 10.0747 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>11.4976 11.121 10.7439 10.3664 9.98937 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Zenith>
        <Azimuth>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN 111.269 111.67 112.096 112.551 113.041 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN 111.354 111.759 112.192 112.657 113.152 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>111.053 111.44 111.852 112.292 112.762 113.266 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>111.136 111.529 111.946 112.392 112.869 113.381 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>111.219 111.618 112.042 112.494 112.978 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>111.305 111.708 112.138 112.597 113.089 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>111.391 111.799 112.235 112.702 113.201 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>111.478 111.893 112.336 112.809 113.317 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Azimuth>
      </Viewing_Incidence_Angles_Grids>
      <Viewing_Incidence_Angles_Grids bandId="1" detectorId="2">
        <Zenith>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN NaN NaN NaN NaN NaN 9.82039 9.4373 9.05284 8.66805 8.28339 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN 9.73454 9.35159 8.96724 8.58182 8.19763 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 10.0315 9.64827 9.26401 8.87996 8.49572 8.11079 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 9.94572 9.56205 9.17796 8.79367 8.4095 8.02451 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 9.85977 9.47669 9.09189 8.70763 8.32282 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 9.77437 9.38968 9.00597 8.62183 8.23655 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 9.68751 9.30377 8.91958 8.53514 8.15057 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN 9.98449 9.60143 9.21746 8.83286 8.4486 8.06421 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 9.51494 9.13074 8.74664 8.3621 7.97741 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Zenith>
        <Azimuth>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN NaN NaN NaN NaN NaN 92.2969 91.9939 91.6606 91.294 90.8911 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN 92.2267 91.9172 91.5775 91.2031 90.7918 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 92.4452 92.1553 91.8379 91.4911 91.1101 90.6885 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 92.3781 92.0825 91.7591 91.4043 91.0144 90.5834 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 92.31 92.0089 91.6783 91.3163 90.9166 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 92.2413 91.9324 91.5954 91.2255 90.8166 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 92.1696 91.8556 91.5111 91.1322 90.7147 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN 92.391 92.0976 91.7769 91.4248 91.0382 90.611 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN 92.0248 91.6966 91.3373 90.9417 90.5043 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Azimuth>
      </Viewing_Incidence_Angles_Grids>
      <Viewing_Incidence_Angles_Grids bandId="1" detectorId="3">
        <Zenith>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 7.94194 7.56511 7.19038 6.81626 6.44423 NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 7.8569 7.48093 7.10605 6.73281 6.36089 NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 7.7724 7.39658 7.02215 6.64892 6.27782 NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 8.06455 7.688 7.31247 6.93823 6.56551 6.19477 NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 7.97983 7.60366 7.2287 6.85441 6.48197 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 7.8952 7.51946 7.14517 6.77071 6.39873 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 7.81105 7.43489 7.0603 6.68714 6.31558 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 7.72611 7.35074 6.97674 6.60389 6.23289 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN 8.01804 7.64172 7.26672 6.89282 6.52025 6.14959 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 7.55748 7.18239 6.80886 6.43657 NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Zenith>
        <Azimuth>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 116.798 117.613 118.509 119.504 120.609 NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 116.97 117.802 118.719 119.735 120.87 NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 117.146 117.996 118.934 119.975 121.137 NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 116.538 117.326 118.194 119.155 120.222 121.414 NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 116.706 117.511 118.397 119.38 120.474 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 116.877 117.699 118.604 119.612 120.733 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 117.05 117.892 118.82 119.85 120.998 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 117.231 118.089 119.037 120.092 121.27 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN 116.616 117.414 118.291 119.262 120.343 121.552 NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 117.601 118.499 119.492 120.6 NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Azimuth>
      </Viewing_Incidence_Angles_Grids>
      <Viewing_Incidence_Angles_Grids bandId="1" detectorId="4">
        <Zenith>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 5.98397 5.60436 5.22629 4.85051 4.47749 NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 5.89902 5.51979 5.14214 4.76699 4.39482 NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 5.81385 5.43495 5.05811 4.68338 4.31176 NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 6.10878 5.72912 5.35071 4.97413 4.59998 4.22933 NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 6.02356 5.64376 5.26618 4.88984 4.51664 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 5.938 5.55897 5.1813 4.80571 4.43316 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 5.85332 5.47505 5.09703 4.72192 4.35017 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 6.14847 5.76823 5.38949 5.01237 4.63811 4.26692 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 6.06275 5.68347 5.30458 4.92804 4.55459 4.18407 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 5.9774 5.59788 5.21981 4.84402 4.47086 NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 5.51271 5.13498 4.7597 4.38749 NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Zenith>
        <Azimuth>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 87.1015 86.1123 84.974 83.6538 82.1077 NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 86.8857 85.8663 84.6903 83.3238 81.7192 NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 86.6628 85.6105 84.3968 82.9801 81.3118 NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 87.3809 86.4344 85.3483 84.0925 82.6251 80.8924 NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 87.1741 86.1977 85.0768 83.7748 82.2541 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 86.9589 85.9527 84.7944 83.4481 81.8691 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 86.7408 85.7045 84.5049 83.1103 81.4708 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 87.4494 86.5139 85.442 84.2014 82.7561 81.052 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 87.244 86.2812 85.1729 83.8909 82.3929 80.6189 NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 87.0343 86.0398 84.8955 83.5691 82.0132 NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 85.7916 84.6089 83.2341 81.6205 NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Azimuth>
      </Viewing_Incidence_Angles_Grids>
      <Viewing_Incidence_Angles_Grids bandId="1" detectorId="5">
        <Zenith>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.27277 3.93031</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.19493 3.85385</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.11765 3.77876</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.38681 4.04091 3.70407</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.30823 3.96401 3.63007</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.22988 3.88788 3.55663</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.15225 3.8125 3.48381</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.4219 4.07481 3.73746 3.41201</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.34311 3.998 3.66286 3.34095</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.26482 3.92174 3.58929 3.27063</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 4.18686 3.84597 3.51627 3.20131</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 3.7708 3.44395 3.13291</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Zenith>
        <Azimuth>
          <COL_STEP unit="m">5000</COL_STEP>
          <ROW_STEP unit="m">5000</ROW_STEP>
          <Values_List>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 130.971 133.734</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 131.547 134.423</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 132.144 135.129</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 130.141 132.763 135.869</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 130.69 133.411 136.637</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 131.26 134.084 137.44</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 131.852 134.784 138.279</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 129.884 132.465 135.512 139.15</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 130.424 133.101 136.272 140.06</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 130.987 133.764 137.059 141.008</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 131.568 134.453 137.883 142.001</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 135.169 138.743 143.037</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
            <VALUES>NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN</VALUES>
          </Values_List>
        </Azimuth>
      </Viewing_Incidence_Angles_Grids>
      <Mean_Viewing_Incidence_Angle_List>
        <Mean_Viewing_Incidence_Angle bandId="0">
          <ZENITH_ANGLE unit="deg">7.18024135920399</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">106.255157702848</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="9">
          <ZENITH_ANGLE unit="deg">7.22336464325122</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">106.346078097961</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="10">
          <ZENITH_ANGLE unit="deg">6.98729381785528</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">105.765382381968</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="1">
          <ZENITH_ANGLE unit="deg">6.92446640065506</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">105.09376719949</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="2">
          <ZENITH_ANGLE unit="deg">6.95791117837005</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">105.44993173891</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="3">
          <ZENITH_ANGLE unit="deg">6.99577507894955</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">105.692478311655</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="4">
          <ZENITH_ANGLE unit="deg">7.0231940118902</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">105.844309043016</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="5">
          <ZENITH_ANGLE unit="deg">7.05361232723533</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">105.969629461909</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="6">
          <ZENITH_ANGLE unit="deg">7.0871211819946</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">106.101277617057</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="7">
          <ZENITH_ANGLE unit="deg">6.93953882104395</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">105.275888180279</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="8">
          <ZENITH_ANGLE unit="deg">7.12343057570894</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">106.21247453177</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="11">
          <ZENITH_ANGLE unit="deg">7.04938612963508</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">106.030547019406</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
        <Mean_Viewing_Incidence_Angle bandId="12">
          <ZENITH_ANGLE unit="deg">7.13282515906901</ZENITH_ANGLE>
          <AZIMUTH_ANGLE unit="deg">106.31610702063</AZIMUTH_ANGLE>
        </Mean_Viewing_Incidence_Angle>
      </Mean_Viewing_Incidence_Angle_List>
    </Tile_Angles>
  </n1:Geometric_Info>

  <n1:Quality_Indicators_Info metadataLevel="Standard">
    <Image_Content_QI>
      <CLOUDY_PIXEL_PERCENTAGE>0</CLOUDY_PIXEL_PERCENTAGE>
      <DEGRADED_MSI_DATA_PERCENTAGE>0</DEGRADED_MSI_DATA_PERCENTAGE>
    </Image_Content_QI>
    <Pixel_Level_QI geometry="FULL_RESOLUTION">
      <MASK_FILENAME bandId="0" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B01.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="0" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B01.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="0" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B01.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="0" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B01.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="0" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B01.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="1" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B02.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="1" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B02.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="1" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B02.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="1" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B02.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="1" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B02.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="2" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B03.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="2" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B03.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="2" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B03.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="2" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B03.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="2" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B03.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="3" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B04.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="3" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B04.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="3" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B04.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="3" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B04.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="3" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B04.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="4" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B05.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="4" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B05.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="4" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B05.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="4" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B05.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="4" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B05.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="5" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B06.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="5" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B06.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="5" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B06.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="5" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B06.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="5" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B06.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="6" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B07.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="6" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B07.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="6" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B07.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="6" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B07.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="6" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B07.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="7" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B08.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="7" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B08.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="7" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B08.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="7" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B08.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="7" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B08.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="8" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B8A.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="8" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B8A.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="8" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B8A.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="8" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B8A.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="8" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B8A.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="9" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B09.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="9" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B09.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="9" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B09.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="9" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B09.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="9" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B09.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="10" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B10.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="10" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B10.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="10" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B10.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="10" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B10.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="10" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B10.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="11" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B11.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="11" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B11.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="11" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B11.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="11" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B11.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="11" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B11.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="12" type="MSK_DEFECT">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DEFECT_B12.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="12" type="MSK_DETFOO">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_DETFOO_B12.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="12" type="MSK_NODATA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_NODATA_B12.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="12" type="MSK_SATURA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_SATURA_B12.gml</MASK_FILENAME>
      <MASK_FILENAME bandId="12" type="MSK_TECQUA">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_TECQUA_B12.gml</MASK_FILENAME>
      <MASK_FILENAME type="MSK_CLOUDS">GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/MSK_CLOUDS_B00.gml</MASK_FILENAME>
    </Pixel_Level_QI>
    <PVI_FILENAME>GRANULE/L1C_T16SEB_A018656_20201001T162735/QI_DATA/T16SEB_20201001T162019_PVI.jp2</PVI_FILENAME>
  </n1:Quality_Indicators_Info>

</n1:Level-1C_Tile_ID>
"""  # noqa


mtd_l1c_old_xml = """<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<n1:Level-1C_User_Product xmlns:n1="https://psd-14.sentinel2.eo.esa.int/PSD/User_Product_Level-1C.xsd" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="https://psd-14.sentinel2.eo.esa.int/PSD/User_Product_Level-1C.xsd">
  <n1:General_Info>
    <Product_Info>
      <PRODUCT_START_TIME>2021-05-17T10:36:19.024Z</PRODUCT_START_TIME>
      <PRODUCT_STOP_TIME>2021-05-17T10:36:19.024Z</PRODUCT_STOP_TIME>
      <PRODUCT_URI>S2B_MSIL1C_20210517T103619_N7990_R008_T30QVE_20210929T075738.SAFE</PRODUCT_URI>
      <PROCESSING_LEVEL>Level-1C</PROCESSING_LEVEL>
      <PRODUCT_TYPE>S2MSI1C</PRODUCT_TYPE>
      <PROCESSING_BASELINE>79.90</PROCESSING_BASELINE>
      <PRODUCT_DOI>https://doi.org/10.5270/S2_-742ikth</PRODUCT_DOI>
      <GENERATION_TIME>2021-09-29T07:57:38.000000Z</GENERATION_TIME>
      <PREVIEW_IMAGE_URL>Not applicable</PREVIEW_IMAGE_URL>
      <PREVIEW_GEO_INFO>Not applicable</PREVIEW_GEO_INFO>
      <Datatake datatakeIdentifier="GS2B_20210517T103619_021913_N79.90">
        <SPACECRAFT_NAME>Sentinel-2B</SPACECRAFT_NAME>
        <DATATAKE_TYPE>INS-NOBS</DATATAKE_TYPE>
        <DATATAKE_SENSING_START>2021-05-17T10:36:19.024Z</DATATAKE_SENSING_START>
        <SENSING_ORBIT_NUMBER>8</SENSING_ORBIT_NUMBER>
        <SENSING_ORBIT_DIRECTION>DESCENDING</SENSING_ORBIT_DIRECTION>
      </Datatake>
      <Query_Options completeSingleTile="true">
        <PRODUCT_FORMAT>SAFE_COMPACT</PRODUCT_FORMAT>
      </Query_Options>
      <Product_Organisation>
        <Granule_List>
          <Granule datastripIdentifier="S2B_OPER_MSI_L1C_DS_VGSR_20210929T075738_S20210517T104617_N79.90" granuleIdentifier="S2B_OPER_MSI_L1C_TL_VGSR_20210929T075738_A021913_T30QVE_N79.90" imageFormat="JPEG2000">
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B01</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B02</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B03</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B04</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B05</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B06</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B07</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B08</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B8A</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B09</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B10</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B11</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B12</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_TCI</IMAGE_FILE>
          </Granule>
        </Granule_List>
      </Product_Organisation>
    </Product_Info>
    <Product_Image_Characteristics>
      <Special_Values>
        <SPECIAL_VALUE_TEXT>NODATA</SPECIAL_VALUE_TEXT>
        <SPECIAL_VALUE_INDEX>0</SPECIAL_VALUE_INDEX>
      </Special_Values>
      <Special_Values>
        <SPECIAL_VALUE_TEXT>SATURATED</SPECIAL_VALUE_TEXT>
        <SPECIAL_VALUE_INDEX>65535</SPECIAL_VALUE_INDEX>
      </Special_Values>
      <Image_Display_Order>
        <RED_CHANNEL>3</RED_CHANNEL>
        <GREEN_CHANNEL>2</GREEN_CHANNEL>
        <BLUE_CHANNEL>1</BLUE_CHANNEL>
      </Image_Display_Order>
      <QUANTIFICATION_VALUE unit="none">10000</QUANTIFICATION_VALUE>
      <Reflectance_Conversion>
        <U>0.979428313059035</U>
        <Solar_Irradiance_List>
          <SOLAR_IRRADIANCE bandId="0" unit="W/m²/µm">1874.3</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="1" unit="W/m²/µm">1959.75</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="2" unit="W/m²/µm">1824.93</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="3" unit="W/m²/µm">1512.79</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="4" unit="W/m²/µm">1425.78</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="5" unit="W/m²/µm">1291.13</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="6" unit="W/m²/µm">1175.57</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="7" unit="W/m²/µm">1041.28</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="8" unit="W/m²/µm">953.93</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="9" unit="W/m²/µm">817.58</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="10" unit="W/m²/µm">365.41</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="11" unit="W/m²/µm">247.08</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="12" unit="W/m²/µm">87.75</SOLAR_IRRADIANCE>
        </Solar_Irradiance_List>
      </Reflectance_Conversion>
      <Spectral_Information_List>
        <Spectral_Information bandId="0" physicalBand="B1">
          <RESOLUTION>60</RESOLUTION>
          <Wavelength>
            <MIN unit="nm">411</MIN>
            <MAX unit="nm">456</MAX>
            <CENTRAL unit="nm">442.3</CENTRAL>
          </Wavelength>
          <Spectral_Response>
            <STEP unit="nm">1</STEP>
            <VALUES>0.0062411 0.01024045 0.00402983 0.00642179 0.00552753 0.0065525 0.00409887 0.006297 0.00436742 0.00233356 0.00058162 0.00202276 0.00294328 0.00485362 0.00317041 0.00237657 0.00234612 0.00440152 0.01292397 0.05001678 0.18650104 0.45441623 0.72307877 0.83999211 0.86456334 0.87472096 0.89215296 0.91090814 0.92588017 0.93924094 0.94491826 0.95078529 0.96803023 0.99939195 1 0.97548364 0.96148351 0.94986211 0.91841452 0.87989802 0.80383677 0.59752075 0.30474132 0.10798014 0.0304465 0.00885119</VALUES>
          </Spectral_Response>
        </Spectral_Information>
        <Spectral_Information bandId="1" physicalBand="B2">
          <RESOLUTION>10</RESOLUTION>
          <Wavelength>
            <MIN unit="nm">456</MIN>
            <MAX unit="nm">532</MAX>
            <CENTRAL unit="nm">492.3</CENTRAL>
          </Wavelength>
          <Spectral_Response>
            <STEP unit="nm">1</STEP>
            <VALUES>0.05529541 0.12005068 0.25199051 0.4623617 0.65162379 0.77642171 0.82319091 0.83083116 0.83382106 0.837526 0.86304286 0.88226141 0.90486326 0.92043837 0.93602675 0.930533 0.92714067 0.9161479 0.90551724 0.89745515 0.90266694 0.90854264 0.92047913 0.92417935 0.91845025 0.90743244 0.89733983 0.88646415 0.87189983 0.85643973 0.84473414 0.84190734 0.85644111 0.87782724 0.90261174 0.91840544 0.94585847 0.96887192 0.99336135 0.99927899 1 0.99520325 0.98412711 0.97947473 0.97808297 0.97213439 0.96277794 0.95342234 0.93802376 0.92460144 0.90932642 0.90192251 0.89184298 0.88963556 0.89146958 0.89877911 0.91056869 0.92427362 0.93823555 0.95311791 0.97150808 0.98737003 0.99658514 0.99367959 0.98144714 0.95874415 0.89291635 0.73566218 0.52060373 0.3322804 0.19492197 0.11732617 0.07507304 0.05094154 0.03213016 0.01510217 0.00447984</VALUES>
          </Spectral_Response>
        </Spectral_Information>
        <Spectral_Information bandId="10" physicalBand="B10">
          <RESOLUTION>60</RESOLUTION>
          <Wavelength>
            <MIN unit="nm">1339</MIN>
            <MAX unit="nm">1415</MAX>
            <CENTRAL unit="nm">1376.9</CENTRAL>
          </Wavelength>
          <Spectral_Response>
            <STEP unit="nm">1</STEP>
            <VALUES>2.472e-05 0.00013691 0.00012558 8.901e-05 0.00012425 9.941e-05 0.00013952 0.00015816 0.00019272 0.00025959 0.00032221 0.00034719 0.0003699 0.00054874 0.00105434 0.00218813 0.00480743 0.01135252 0.02671185 0.05776022 0.11176337 0.19587518 0.31418191 0.46188068 0.62292578 0.7709851 0.88086652 0.9448941 0.97405066 0.98616696 0.99306955 0.99775441 1 0.99942348 0.99616891 0.99082045 0.9842131 0.97708513 0.97013647 0.96374366 0.95755001 0.95127438 0.94546638 0.94069659 0.93759595 0.93624612 0.93510206 0.93054472 0.91630845 0.88530334 0.83129653 0.74856466 0.63524397 0.49733159 0.34907723 0.21259735 0.10971453 0.04789269 0.01853013 0.00716776 0.0031533 0.00157017 0.00084901 0.00053006 0.00033171 0.00019447 0.00022104 0.00022646 0.00018156 0.00016063 0.00015475 0.00014734 0.00014776 0.00017405 0.00023619 0.00012007 4.337e-05</VALUES>
          </Spectral_Response>
        </Spectral_Information>
      </Spectral_Information_List>
      <PHYSICAL_GAINS bandId="0">3.97083657</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="1">3.81081866</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="2">4.21881648</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="3">4.7545091</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="4">5.16489535</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="5">5.06418355</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="6">4.7429031</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="7">6.789537</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="8">5.73223234</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="9">9.32447797</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="10">56.36387909</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="11">37.15464608</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="12">108.67071783</PHYSICAL_GAINS>
      <REFERENCE_BAND>3</REFERENCE_BAND>
    </Product_Image_Characteristics>
  </n1:General_Info>
</n1:Level-1C_User_Product>
"""  # noqa

mtd_l1c_xml = """<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<n1:Level-1C_User_Product xmlns:n1="https://psd-14.sentinel2.eo.esa.int/PSD/User_Product_Level-1C.xsd" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="https://psd-14.sentinel2.eo.esa.int/PSD/User_Product_Level-1C.xsd">
  <n1:General_Info>
    <Product_Info>
      <PRODUCT_START_TIME>2021-05-17T10:36:19.024Z</PRODUCT_START_TIME>
      <PRODUCT_STOP_TIME>2021-05-17T10:36:19.024Z</PRODUCT_STOP_TIME>
      <PRODUCT_URI>S2B_MSIL1C_20210517T103619_N7990_R008_T30QVE_20210929T075738.SAFE</PRODUCT_URI>
      <PROCESSING_LEVEL>Level-1C</PROCESSING_LEVEL>
      <PRODUCT_TYPE>S2MSI1C</PRODUCT_TYPE>
      <PROCESSING_BASELINE>79.90</PROCESSING_BASELINE>
      <PRODUCT_DOI>https://doi.org/10.5270/S2_-742ikth</PRODUCT_DOI>
      <GENERATION_TIME>2021-09-29T07:57:38.000000Z</GENERATION_TIME>
      <PREVIEW_IMAGE_URL>Not applicable</PREVIEW_IMAGE_URL>
      <PREVIEW_GEO_INFO>Not applicable</PREVIEW_GEO_INFO>
      <Datatake datatakeIdentifier="GS2B_20210517T103619_021913_N79.90">
        <SPACECRAFT_NAME>Sentinel-2B</SPACECRAFT_NAME>
        <DATATAKE_TYPE>INS-NOBS</DATATAKE_TYPE>
        <DATATAKE_SENSING_START>2021-05-17T10:36:19.024Z</DATATAKE_SENSING_START>
        <SENSING_ORBIT_NUMBER>8</SENSING_ORBIT_NUMBER>
        <SENSING_ORBIT_DIRECTION>DESCENDING</SENSING_ORBIT_DIRECTION>
      </Datatake>
      <Query_Options completeSingleTile="true">
        <PRODUCT_FORMAT>SAFE_COMPACT</PRODUCT_FORMAT>
      </Query_Options>
      <Product_Organisation>
        <Granule_List>
          <Granule datastripIdentifier="S2B_OPER_MSI_L1C_DS_VGSR_20210929T075738_S20210517T104617_N79.90" granuleIdentifier="S2B_OPER_MSI_L1C_TL_VGSR_20210929T075738_A021913_T30QVE_N79.90" imageFormat="JPEG2000">
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B01</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B02</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B03</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B04</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B05</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B06</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B07</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B08</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B8A</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B09</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B10</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B11</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_B12</IMAGE_FILE>
            <IMAGE_FILE>GRANULE/L1C_T30QVE_A021913_20210517T104617/IMG_DATA/T30QVE_20210517T103619_TCI</IMAGE_FILE>
          </Granule>
        </Granule_List>
      </Product_Organisation>
    </Product_Info>
    <Product_Image_Characteristics>
      <Special_Values>
        <SPECIAL_VALUE_TEXT>NODATA</SPECIAL_VALUE_TEXT>
        <SPECIAL_VALUE_INDEX>0</SPECIAL_VALUE_INDEX>
      </Special_Values>
      <Special_Values>
        <SPECIAL_VALUE_TEXT>SATURATED</SPECIAL_VALUE_TEXT>
        <SPECIAL_VALUE_INDEX>65535</SPECIAL_VALUE_INDEX>
      </Special_Values>
      <Image_Display_Order>
        <RED_CHANNEL>3</RED_CHANNEL>
        <GREEN_CHANNEL>2</GREEN_CHANNEL>
        <BLUE_CHANNEL>1</BLUE_CHANNEL>
      </Image_Display_Order>
      <QUANTIFICATION_VALUE unit="none">10000</QUANTIFICATION_VALUE>
      <Radiometric_Offset_List>
        <RADIO_ADD_OFFSET band_id="0">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="1">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="2">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="3">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="4">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="5">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="6">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="7">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="8">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="9">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="10">-2000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="11">-1000</RADIO_ADD_OFFSET>
        <RADIO_ADD_OFFSET band_id="12">-1000</RADIO_ADD_OFFSET>
      </Radiometric_Offset_List>
      <Reflectance_Conversion>
        <U>0.979428313059035</U>
        <Solar_Irradiance_List>
          <SOLAR_IRRADIANCE bandId="0" unit="W/m²/µm">1874.3</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="1" unit="W/m²/µm">1959.75</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="2" unit="W/m²/µm">1824.93</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="3" unit="W/m²/µm">1512.79</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="4" unit="W/m²/µm">1425.78</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="5" unit="W/m²/µm">1291.13</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="6" unit="W/m²/µm">1175.57</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="7" unit="W/m²/µm">1041.28</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="8" unit="W/m²/µm">953.93</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="9" unit="W/m²/µm">817.58</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="10" unit="W/m²/µm">365.41</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="11" unit="W/m²/µm">247.08</SOLAR_IRRADIANCE>
          <SOLAR_IRRADIANCE bandId="12" unit="W/m²/µm">87.75</SOLAR_IRRADIANCE>
        </Solar_Irradiance_List>
      </Reflectance_Conversion>
      <Spectral_Information_List>
        <Spectral_Information bandId="0" physicalBand="B1">
          <RESOLUTION>60</RESOLUTION>
          <Wavelength>
            <MIN unit="nm">411</MIN>
            <MAX unit="nm">456</MAX>
            <CENTRAL unit="nm">442.3</CENTRAL>
          </Wavelength>
          <Spectral_Response>
            <STEP unit="nm">1</STEP>
            <VALUES>0.0062411 0.01024045 0.00402983 0.00642179 0.00552753 0.0065525 0.00409887 0.006297 0.00436742 0.00233356 0.00058162 0.00202276 0.00294328 0.00485362 0.00317041 0.00237657 0.00234612 0.00440152 0.01292397 0.05001678 0.18650104 0.45441623 0.72307877 0.83999211 0.86456334 0.87472096 0.89215296 0.91090814 0.92588017 0.93924094 0.94491826 0.95078529 0.96803023 0.99939195 1 0.97548364 0.96148351 0.94986211 0.91841452 0.87989802 0.80383677 0.59752075 0.30474132 0.10798014 0.0304465 0.00885119</VALUES>
          </Spectral_Response>
        </Spectral_Information>
        <Spectral_Information bandId="1" physicalBand="B2">
          <RESOLUTION>10</RESOLUTION>
          <Wavelength>
            <MIN unit="nm">456</MIN>
            <MAX unit="nm">532</MAX>
            <CENTRAL unit="nm">492.3</CENTRAL>
          </Wavelength>
          <Spectral_Response>
            <STEP unit="nm">1</STEP>
            <VALUES>0.05529541 0.12005068 0.25199051 0.4623617 0.65162379 0.77642171 0.82319091 0.83083116 0.83382106 0.837526 0.86304286 0.88226141 0.90486326 0.92043837 0.93602675 0.930533 0.92714067 0.9161479 0.90551724 0.89745515 0.90266694 0.90854264 0.92047913 0.92417935 0.91845025 0.90743244 0.89733983 0.88646415 0.87189983 0.85643973 0.84473414 0.84190734 0.85644111 0.87782724 0.90261174 0.91840544 0.94585847 0.96887192 0.99336135 0.99927899 1 0.99520325 0.98412711 0.97947473 0.97808297 0.97213439 0.96277794 0.95342234 0.93802376 0.92460144 0.90932642 0.90192251 0.89184298 0.88963556 0.89146958 0.89877911 0.91056869 0.92427362 0.93823555 0.95311791 0.97150808 0.98737003 0.99658514 0.99367959 0.98144714 0.95874415 0.89291635 0.73566218 0.52060373 0.3322804 0.19492197 0.11732617 0.07507304 0.05094154 0.03213016 0.01510217 0.00447984</VALUES>
          </Spectral_Response>
        </Spectral_Information>
        <Spectral_Information bandId="10" physicalBand="B10">
          <RESOLUTION>60</RESOLUTION>
          <Wavelength>
            <MIN unit="nm">1339</MIN>
            <MAX unit="nm">1415</MAX>
            <CENTRAL unit="nm">1376.9</CENTRAL>
          </Wavelength>
          <Spectral_Response>
            <STEP unit="nm">1</STEP>
            <VALUES>2.472e-05 0.00013691 0.00012558 8.901e-05 0.00012425 9.941e-05 0.00013952 0.00015816 0.00019272 0.00025959 0.00032221 0.00034719 0.0003699 0.00054874 0.00105434 0.00218813 0.00480743 0.01135252 0.02671185 0.05776022 0.11176337 0.19587518 0.31418191 0.46188068 0.62292578 0.7709851 0.88086652 0.9448941 0.97405066 0.98616696 0.99306955 0.99775441 1 0.99942348 0.99616891 0.99082045 0.9842131 0.97708513 0.97013647 0.96374366 0.95755001 0.95127438 0.94546638 0.94069659 0.93759595 0.93624612 0.93510206 0.93054472 0.91630845 0.88530334 0.83129653 0.74856466 0.63524397 0.49733159 0.34907723 0.21259735 0.10971453 0.04789269 0.01853013 0.00716776 0.0031533 0.00157017 0.00084901 0.00053006 0.00033171 0.00019447 0.00022104 0.00022646 0.00018156 0.00016063 0.00015475 0.00014734 0.00014776 0.00017405 0.00023619 0.00012007 4.337e-05</VALUES>
          </Spectral_Response>
        </Spectral_Information>
      </Spectral_Information_List>
      <PHYSICAL_GAINS bandId="0">3.97083657</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="1">3.81081866</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="2">4.21881648</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="3">4.7545091</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="4">5.16489535</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="5">5.06418355</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="6">4.7429031</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="7">6.789537</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="8">5.73223234</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="9">9.32447797</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="10">56.36387909</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="11">37.15464608</PHYSICAL_GAINS>
      <PHYSICAL_GAINS bandId="12">108.67071783</PHYSICAL_GAINS>
      <REFERENCE_BAND>3</REFERENCE_BAND>
    </Product_Image_Characteristics>
  </n1:General_Info>
</n1:Level-1C_User_Product>
"""  # noqa


class TestMTDXML(unittest.TestCase):
    """Test the SAFE MTD XML file handler."""

    def setUp(self):
        """Set up the test case."""
        from satpy.readers.msi_safe import SAFEMSIMDXML, SAFEMSITileMDXML
        filename_info = dict(observation_time=None, dtile_number=None, fmission_id="S2A")
        self.xml_tile_fh = SAFEMSITileMDXML(BytesIO(mtd_tile_xml), filename_info, mock.MagicMock())
        self.old_xml_fh = SAFEMSIMDXML(StringIO(mtd_l1c_old_xml), filename_info, mock.MagicMock())
        self.xml_fh = SAFEMSIMDXML(StringIO(mtd_l1c_xml), filename_info, mock.MagicMock(), mask_saturated=True)

    def test_satellite_zenith_array(self):
        """Test reading the satellite zenith array."""
        info = dict(xml_tag="Viewing_Incidence_Angles_Grids", xml_item="Zenith")

        expected_data = np.array([[11.7128, 11.18397802, 10.27667671, 9.35384969, 8.42850504,
                                   7.55445611, 6.65475545, 5.66517232, 4.75893757, 4.04976844],
                                  [11.88606009, 10.9799713, 10.07083278, 9.14571825, 8.22607131,
                                   7.35181457, 6.44647222, 5.46144173, 4.56625547, 3.86638233],
                                  [11.6823579, 10.7763071, 9.86302106, 8.93879112, 8.04005637,
                                   7.15028077, 6.21461062, 5.25780953, 4.39876601, 3.68620793],
                                  [11.06724679, 10.35723901, 9.63958896, 8.73072512, 7.83680864,
                                   6.94792574, 5.9889201, 5.05445872, 4.26089708, 3.50984272],
                                  [6.28411038, 6.28411038, 6.28411038, 6.28411038, 6.28411038,
                                   5.99769643, 5.62586167, 4.85165966, 4.13238314, 3.33781401],
                                  [3.7708, 3.7708, 3.7708, 3.7708, 3.7708,
                                   3.7708, 3.7708, 3.7708, 3.7708, 3.24140837],
                                  [3.7708, 3.7708, 3.7708, 3.7708, 3.7708,
                                   3.7708, 3.7708, 3.7708, 3.7708, 3.24140837],
                                  [3.7708, 3.7708, 3.7708, 3.7708, 3.7708,
                                   3.7708, 3.7708, 3.7708, 3.7708, 3.24140837],
                                  [3.7708, 3.7708, 3.7708, 3.7708, 3.7708,
                                   3.7708, 3.7708, 3.7708, 3.7708, 3.24140837],
                                  [3.7708, 3.7708, 3.7708, 3.7708, 3.7708,
                                   3.7708, 3.7708, 3.7708, 3.7708, 3.24140837]])
        res = self.xml_tile_fh.get_dataset(make_dataid(name="satellite_zenith_angle",
                                                       resolution=60),
                                           info)[::200, ::200]
        np.testing.assert_allclose(res, expected_data)

    def test_old_xml_calibration(self):
        """Test the calibration of older data formats (no offset)."""
        fake_data = xr.DataArray([[[0, 1, 2, 3],
                                   [4, 1000, 65534, 65535]]],
                                 dims=["band", "x", "y"])
        result = self.old_xml_fh.calibrate_to_reflectances(fake_data, "B01")
        np.testing.assert_allclose(result, [[[np.nan, 0.01, 0.02, 0.03],
                                             [0.04, 10, 655.34, np.inf]]])

    def test_xml_calibration(self):
        """Test the calibration with radiometric offset."""
        fake_data = xr.DataArray([[[0, 1, 2, 3],
                                   [4, 1000, 65534, 65535]]],
                                 dims=["band", "x", "y"])
        result = self.xml_fh.calibrate_to_reflectances(fake_data, "B01")
        np.testing.assert_allclose(result, [[[np.nan, 0.01 - 10, 0.02 - 10, 0.03 - 10],
                                             [0.04 - 10, 0, 655.34 - 10, np.inf]]])

    def test_xml_calibration_unmasked_saturated(self):
        """Test the calibration with radiometric offset but unmasked saturated pixels."""
        from satpy.readers.msi_safe import SAFEMSIMDXML
        filename_info = dict(observation_time=None, dtile_number=None, fmission_id="S2A")
        self.xml_fh = SAFEMSIMDXML(StringIO(mtd_l1c_xml), filename_info, mock.MagicMock(), mask_saturated=False)

        fake_data = xr.DataArray([[[0, 1, 2, 3],
                                   [4, 1000, 65534, 65535]]],
                                 dims=["band", "x", "y"])
        result = self.xml_fh.calibrate_to_reflectances(fake_data, "B01")
        np.testing.assert_allclose(result, [[[np.nan, 0.01 - 10, 0.02 - 10, 0.03 - 10],
                                             [0.04 - 10, 0, 655.34 - 10, 655.35 - 10]]])

    def test_xml_calibration_with_different_offset(self):
        """Test the calibration with a different offset."""
        fake_data = xr.DataArray([[[0, 1, 2, 3],
                                   [4, 1000, 65534, 65535]]],
                                 dims=["band", "x", "y"])
        result = self.xml_fh.calibrate_to_reflectances(fake_data, "B10")
        np.testing.assert_allclose(result, [[[np.nan, 0.01 - 20, 0.02 - 20, 0.03 - 20],
                                             [0.04 - 20, -10, 655.34 - 20, np.inf]]])

    def test_xml_calibration_to_radiance(self):
        """Test the calibration with a different offset."""
        fake_data = xr.DataArray([[[0, 1, 2, 3],
                                   [4, 1000, 65534, 65535]]],
                                 dims=["band", "x", "y"])
        result = self.xml_fh.calibrate_to_radiances(fake_data, "B01")
        expected = np.array([[[np.nan, -251.584265, -251.332429, -251.080593],
                              [-250.828757, 0., 16251.99095, np.inf]]])
        np.testing.assert_allclose(result, expected)

    def test_xml_navigation(self):
        """Test the navigation."""
        from pyproj import CRS
        crs = CRS('EPSG:32616')

        dsid = make_dataid(name="B01", resolution=60)
        result = self.xml_tile_fh.get_area_def(dsid)

        area_extents = (499980.0, 3590220.0, 609780.0, 3700020.0)
        assert result.crs == crs
        np.testing.assert_allclose(result.area_extent, area_extents)


class TestSAFEMSIL1C:
    """Test case for image reading (jp2k)."""

    def setup_method(self):
        """Set up the test."""
        from satpy.readers.msi_safe import SAFEMSITileMDXML
        self.filename_info = dict(observation_time=None, fmission_id="S2A", band_name="B01", dtile_number=None)
        self.fake_data = xr.DataArray([[[0, 1], [65534, 65535]]], dims=["band", "x", "y"])
        self.tile_mda = mock.create_autospec(SAFEMSITileMDXML)(BytesIO(mtd_tile_xml),
                                                               self.filename_info, mock.MagicMock())

    @pytest.mark.parametrize("mask_saturated,calibration,expected",
                             [(True, "reflectance", [[np.nan, 0.01 - 10], [645.34, np.inf]]),
                              (False, "reflectance", [[np.nan, 0.01 - 10], [645.34, 645.35]]),
                              (True, "radiance", [[np.nan, -251.58426503], [16251.99095011, np.inf]])])
    def test_calibration_and_masking(self, mask_saturated, calibration, expected):
        """Test that saturated is masked with inf when requested and that calibration is performed."""
        from satpy.readers.msi_safe import SAFEMSIL1C, SAFEMSIMDXML

        mda = SAFEMSIMDXML(StringIO(mtd_l1c_xml), self.filename_info, mock.MagicMock(),
                           mask_saturated=mask_saturated)
        self.jp2_fh = SAFEMSIL1C("somefile", self.filename_info, mock.MagicMock(), mda, self.tile_mda)

        with mock.patch("satpy.readers.msi_safe.rioxarray.open_rasterio", return_value=self.fake_data):
            res = self.jp2_fh.get_dataset(make_dataid(name="B01", calibration=calibration), info=dict())
            np.testing.assert_allclose(res, expected)
