
# PyOghma
**This project is currently in the early stages and no gaurantiees are made to it working.**

A python API for OghmaNano allowing for the programmatic discription and exceution of drift-diffusion simulations.

## Installation
Prior to installing PyOghma it is critical that OghmaNano is installed. OghmaNano can be found to download at: [oghma-nano.com](https://www.oghma-nano.com)

PyOghma may be installed using pip

```bash
    python -m pip install PyOghma
```
    
## Usage/Examples

In order to use PyOgham a soruce simulation generated by OghamNano must be generated, and the sim.json within sim.Oghma extracted. Once compleated modifications upon this simulation may be made programatically as in the example below by PyOghma.

```python
import PyOghma as po

Oghma = po.OghmaNano()
Results = po.Results()


source_simulation = "\exapmle\pm6y6\"

Oghma.set_source_simulation(source_simulation)

experiment_name = 'NewExperiment'

Oghma.set_experiment_name(experiment_name)

mobility = 1e-5
trap_desnsity = 1e-18
trapping_crosssection = 1e-20
recombination_crosssection = 1e-20
urbach_energy = 40e-3
temperature = 300
intensity = 0.5


experiment_name = 'NewExperiment' + str(1)
Oghma.clone('NewExperiment0')

Oghma.Optical.Light.set_light_Intensity(intensity)
Oghma.Optical.Light.update()

Oghma.Thermal.set_temperature(temperature)
Oghma.Thermal.update()

Oghma.Epitaxy.load_existing()
Oghma.Epitaxy.pm6y6.dos.mobility('both', mobility)
Oghma.Epitaxy.pm6y6.dos.trap_density('both', trap_desnsity)
Oghma.Epitaxy.pm6y6.dos.trapping_rate('both', 'free to trap',trapping_crosssection)
Oghma.Epitaxy.pm6y6.dos.trapping_rate('both', 'trap to free',recombination_crosssection)
Oghma.Epitaxy.pm6y6.dos.urbach_energy('both', urbach_energy)
Oghma.Epitaxy.update()

Oghma.add_job(experiment_name)
Oghma.run_jobs()

```


## Authors

- [@CaiWilliams](https://www.github.com/CaiWilliams)
