# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['basicserial']

package_data = \
{'': ['*']}

install_requires = \
['iso8601']

setup_kwargs = {
    'name': 'basicserial',
    'version': '1.2.0',
    'description': 'A convenience wrapper around serialization libraries to handle common tasks.',
    'long_description': '***********\nbasicserial\n***********\n\n.. image:: https://img.shields.io/pypi/v/basicserial.svg\n   :target: https://pypi.python.org/pypi/basicserial\n.. image:: https://img.shields.io/pypi/l/basicserial.svg\n   :target: https://pypi.python.org/pypi/basicserial\n.. image:: https://github.com/jayclassless/basicserial/workflows/Test/badge.svg\n   :target: https://github.com/jayclassless/basicserial/actions\n\n.. contents:: Contents\n\n\nOverview\n========\nDoes this look familiar?\n\n::\n\n    >>> import json\n    >>> from datetime import date\n    >>> MY_DATA = {\'foo\': 123, \'bar\': date(2018, 5, 22)}\n    >>> json.dumps(MY_DATA)\n    Traceback (most recent call last):\n        ...\n    TypeError: datetime.date(2018, 5, 22) is not JSON serializable\n\nIt\'s one thing when your serialization tools don\'t know how to handle your\ncustom classes, but it\'s annoying when they don\'t handle the built-in and/or\ncommon data types. Thus, ``basicserial`` was born.\n\nThis package is a thin wrapper around the common serialization tools that can\ndo the following for you when working with JSON, YAML, and TOML:\n\n* Automatically serializes the following types to common-sense representations:\n\n  .. list-table::\n     :header-rows: 1\n\n     * - Type\n       - JSON\n       - YAML\n       - TOML\n     * - `set <https://docs.python.org/3/library/stdtypes.html#set>`_\n       - array\n       - sequence\n       - array\n     * - `frozenset <https://docs.python.org/3/library/stdtypes.html#frozenset>`_\n       - array\n       - sequence\n       - array\n     * - `Decimal <https://docs.python.org/3/library/decimal.html>`_\n       - number\n       - float\n       - float\n     * - `Fraction <https://docs.python.org/3/library/fractions.html>`_\n       - string\n       - string\n       - string\n     * - `date <https://docs.python.org/3/library/datetime.html#date-objects>`_\n       - string (ISO 8601)\n       - timestamp\n       - string (ISO 8601)\n     * - `time <https://docs.python.org/3/library/datetime.html#time-objects>`_\n       - string (ISO 8601)\n       - string (ISO 8601)\n       - string (ISO 8601)\n     * - `datetime <https://docs.python.org/3/library/datetime.html#datetime-objects>`_\n       - string (ISO 8601)\n       - timestamp\n       - string (ISO 8601)\n     * - `complex <https://docs.python.org/3/library/functions.html#complex>`_\n       - string\n       - string\n       - string\n     * - `OrderedDict <https://docs.python.org/3/library/collections.html#collections.OrderedDict>`_\n       - object\n       - map\n       - key/value\n     * - `defaultdict <https://docs.python.org/3/library/collections.html#defaultdict-objects>`_\n       - object\n       - map\n       - key/value\n     * - `namedtuple <https://docs.python.org/3/library/collections.html#namedtuple-factory-function-for-tuples-with-named-fields>`_\n       - object\n       - map\n       - key/value\n     * - `UserDict <https://docs.python.org/3/library/collections.html#userdict-objects>`_\n       - object\n       - map\n       - key/value\n     * - `UserList <https://docs.python.org/3/library/collections.html#userlist-objects>`_\n       - array\n       - sequence\n       - array\n     * - `UserString <https://docs.python.org/3/library/collections.html#userstring-objects>`_\n       - string\n       - string\n       - string\n     * - `UUID <https://docs.python.org/3/library/uuid.html#uuid.UUID>`_\n       - string\n       - string\n       - string\n\n* Can serialize `Enum <https://docs.python.org/3/library/enum.html>`_ members\n  appropriately based on their type.\n\n* Can automatically deserialize dates, times, and datetimes into the native\n  Python objects.\n\n* Provides a simple flag for generating "pretty" strings.\n\n\nUsage\n=====\nTo use this package, install it from PyPI (``pip install basicserial``). Then,\nmake sure you install the serialization package you\'d like ``basicserial`` to\nuse:\n\n* For YAML, it supports `PyYAML <https://pypi.org/project/PyYAML>`_ and\n  `ruamel.yaml <https://pypi.org/project/ruamel.yaml>`_.\n* For TOML, it supports `toml <https://pypi.org/project/toml>`_, `pytoml\n  <https://pypi.org/project/pytoml>`_, `qtoml\n  <https://pypi.org/project/qtoml>`_, `tomlkit\n  <https://pypi.org/project/tomlkit>`_, and `tomli\n  <https://pypi.org/project/tomli>`_/`tomli-w <https://pypi.org/project/tomli_w>`_.\n* For JSON, it supports Python\'s built-in `json\n  <https://docs.python.org/3/library/json.html>`_ module, `simplejson\n  <https://pypi.org/project/simplejson>`_, `orjson\n  <https://pypi.org/project/orjson>`_, `rapidjson\n  <https://pypi.org/project/python-rapidjson>`_, `ujson\n  <https://pypi.org/project/ujson>`_, `hyperjson\n  <https://pypi.org/project/hyperjson>`_, and `pysimdjson\n  <https://pypi.org/project/pysimdjson>`_.\n\n``basicserial`` will automatically find a package to use, but if you want to\nuse a specific one, you can specify its name via the ``pkg`` argument to the\nfunctions.\n\nJSON::\n\n    >>> print(basicserial.to_json(MY_DATA))\n    {"foo": 123, "bar": "2018-05-22"}\n\n    >>> print(basicserial.to_json(MY_DATA, pretty=True))\n    {\n      "foo": 123,\n      "bar": "2018-05-22"\n    }\n\n    >>> basicserial.from_json(basicserial.to_json(MY_DATA))\n    {u\'foo\': 123, u\'bar\': datetime.date(2018, 5, 22)}\n\n    >>> basicserial.from_json(basicserial.to_json(MY_DATA), native_datetimes=False)\n    {u\'foo\': 123, u\'bar\': u\'2018-05-22\'}\n\n\nYAML::\n\n    >>> print(basicserial.to_yaml(MY_DATA))\n    {bar: 2018-05-22, foo: 123}\n\n    >>> print(basicserial.to_yaml(MY_DATA, pretty=True))\n    bar: 2018-05-22\n    foo: 123\n\n    >>> basicserial.from_yaml(basicserial.to_yaml(MY_DATA))\n    {u\'foo\': 123, u\'bar\': datetime.date(2018, 5, 22)}\n\n    >>> basicserial.from_yaml(basicserial.to_yaml(MY_DATA), native_datetimes=False)\n    {\'foo\': 123, \'bar\': u\'2018-05-22\'}\n\n\nTOML::\n\n    >>> print(basicserial.to_toml(MY_DATA))\n    foo = 123\n    bar = "2018-05-22"\n\n    >>> print(basicserial.to_toml(MY_DATA, pretty=True))\n    foo = 123\n    bar = "2018-05-22"\n\n    >>> basicserial.from_toml(basicserial.to_toml(MY_DATA))\n    {u\'foo\': 123, u\'bar\': datetime.date(2018, 5, 22)}\n\n    >>> basicserial.from_toml(basicserial.to_toml(MY_DATA), native_datetimes=False)\n    {u\'foo\': 123, u\'bar\': u\'2018-05-22\'}\n\n\nLicense\n=======\nThis project is released under the terms of the `MIT License`_.\n\n.. _MIT License: https://opensource.org/licenses/MIT\n\n',
    'author': 'Jason Simeone',
    'author_email': 'jay@classless.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jayclassless/basicserial',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
