"""
NEXIUM Response - HTTP response classes
Author: Juste Elysée MALANDILA
"""

from typing import Any, Dict, Optional
from starlette.responses import (
    Response as StarletteResponse,
    JSONResponse as StarletteJSONResponse,
    HTMLResponse as StarletteHTMLResponse,
    FileResponse as StarletteFileResponse,
    RedirectResponse as StarletteRedirectResponse,
)


class Response(StarletteResponse):
    """Base NEXIUM response."""
    pass


class JSONResponse(StarletteJSONResponse):
    """JSON response."""
    
    def __init__(
        self,
        content: Any = None,
        status_code: int = 200,
        headers: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super().__init__(
            content=content,
            status_code=status_code,
            headers=headers,
            **kwargs
        )


class HTMLResponse(StarletteHTMLResponse):
    """HTML response."""
    
    def __init__(
        self,
        content: str = "",
        status_code: int = 200,
        headers: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super().__init__(
            content=content,
            status_code=status_code,
            headers=headers,
            **kwargs
        )


class FileResponse(StarletteFileResponse):
    """File response."""
    pass


class RedirectResponse(StarletteRedirectResponse):
    """Redirect response."""
    pass
