"""
NEXIUM Request - HTTP request wrapper
Author: Juste Elysée MALANDILA
"""

from typing import Any, Dict, Optional
from starlette.requests import Request as StarletteRequest


class Request(StarletteRequest):
    """
    NEXIUM Request wrapper.
    
    Extends Starlette's Request with additional utilities.
    """
    
    @property
    def json_body(self) -> Optional[Dict[str, Any]]:
        """Get JSON body (cached)."""
        if not hasattr(self, "_json_body"):
            self._json_body = None
        return self._json_body
    
    async def json(self) -> Dict[str, Any]:
        """Parse JSON body."""
        if self._json_body is None:
            self._json_body = await super().json()
        return self._json_body
    
    @property
    def is_ajax(self) -> bool:
        """Check if request is AJAX."""
        return self.headers.get("X-Requested-With") == "XMLHttpRequest"
    
    @property
    def is_secure(self) -> bool:
        """Check if request is HTTPS."""
        return self.url.scheme == "https"
    
    @property
    def user_agent(self) -> Optional[str]:
        """Get user agent."""
        return self.headers.get("User-Agent")
