"""
OMNIWEB Exceptions - HTTP exceptions
Author: Juste Elysée MALANDILA
"""

from typing import Any, Dict, Optional


class OmniWebError(Exception):
    """Base OMNIWEB exception."""
    pass


class HTTPException(OmniWebError):
    """HTTP exception with status code."""
    
    def __init__(
        self,
        status_code: int,
        detail: str = "",
        headers: Optional[Dict[str, str]] = None,
    ):
        self.status_code = status_code
        self.detail = detail
        self.headers = headers or {}
        super().__init__(detail)


class BadRequest(HTTPException):
    """400 Bad Request."""
    def __init__(self, detail: str = "Bad Request", **kwargs):
        super().__init__(status_code=400, detail=detail, **kwargs)


class Unauthorized(HTTPException):
    """401 Unauthorized."""
    def __init__(self, detail: str = "Unauthorized", **kwargs):
        super().__init__(status_code=401, detail=detail, **kwargs)


class Forbidden(HTTPException):
    """403 Forbidden."""
    def __init__(self, detail: str = "Forbidden", **kwargs):
        super().__init__(status_code=403, detail=detail, **kwargs)


class NotFound(HTTPException):
    """404 Not Found."""
    def __init__(self, detail: str = "Not Found", **kwargs):
        super().__init__(status_code=404, detail=detail, **kwargs)


class MethodNotAllowed(HTTPException):
    """405 Method Not Allowed."""
    def __init__(self, detail: str = "Method Not Allowed", **kwargs):
        super().__init__(status_code=405, detail=detail, **kwargs)


class Conflict(HTTPException):
    """409 Conflict."""
    def __init__(self, detail: str = "Conflict", **kwargs):
        super().__init__(status_code=409, detail=detail, **kwargs)


class UnprocessableEntity(HTTPException):
    """422 Unprocessable Entity."""
    def __init__(self, detail: str = "Unprocessable Entity", **kwargs):
        super().__init__(status_code=422, detail=detail, **kwargs)


class InternalServerError(HTTPException):
    """500 Internal Server Error."""
    def __init__(self, detail: str = "Internal Server Error", **kwargs):
        super().__init__(status_code=500, detail=detail, **kwargs)


class ServiceUnavailable(HTTPException):
    """503 Service Unavailable."""
    def __init__(self, detail: str = "Service Unavailable", **kwargs):
        super().__init__(status_code=503, detail=detail, **kwargs)
