"""
OMNIWEB - One Framework, Every Platform

Web + Desktop applications with Django's power and FastAPI's speed.
The only Python framework that transforms web apps into native desktop apps!

Created by Juste Elysée MALANDILA
LinkedIn: https://linkedin.com/in/justelm/
"""

__version__ = "0.2.0"
__author__ = "Juste Elysée MALANDILA"
__email__ = "justech4dev@gmail.com"
__linkedin__ = "https://linkedin.com/in/justelm/"

# Core imports
from .app import OmniWeb
from .routing import Router, route, get, post, put, delete, patch
from .middleware import Middleware, middleware
from .response import Response, JSONResponse, HTMLResponse, FileResponse
from .request import Request
from .exceptions import (
    OmniWebError,
    HTTPException,
    NotFound,
    BadRequest,
    Unauthorized,
    Forbidden,
    InternalServerError,
)

# Import from sub-packages
from datavoxel import Model, Query
from integrium import validate, Field, schema
from velocrium import Client

# Desktop Mode (optional)
try:
    from .desktop import DesktopApp, DesktopAPI, run_as_desktop
    _desktop_available = True
except ImportError:
    _desktop_available = False
    DesktopApp = None
    DesktopAPI = None
    run_as_desktop = None

# Auth System
from .auth import enable_auth, requires_auth, AuthSystem, AuthConfig

# Real-time
from .realtime import (
    enable_realtime,
    broadcast,
    ServerSentEvents,
    realtime_route,
    RealTimeManager,
)

# Admin Panel
from .admin import AutoAdmin, AdminConfig, ModelAdmin

__all__ = [
    # Core
    "OmniWeb",
    "Router",
    "Middleware",
    "Request",
    "Response",
    "JSONResponse",
    "HTMLResponse",
    "FileResponse",
    # Decorators
    "route",
    "get",
    "post",
    "put",
    "delete",
    "patch",
    "middleware",
    "validate",
    # Models & ORM
    "Model",
    "Query",
    # Validation
    "Field",
    "schema",
    # HTTP Client
    "Client",
    # Desktop
    "DesktopApp",
    "DesktopAPI",
    "run_as_desktop",
    # Auth
    "enable_auth",
    "requires_auth",
    "AuthSystem",
    "AuthConfig",
    # Real-time
    "enable_realtime",
    "broadcast",
    "ServerSentEvents",
    "realtime_route",
    "RealTimeManager",
    # Admin
    "AutoAdmin",
    "AdminConfig",
    "ModelAdmin",
    # Exceptions
    "OmniWebError",
    "HTTPException",
    "NotFound",
    "BadRequest",
    "Unauthorized",
    "Forbidden",
    "InternalServerError",
    # Metadata
    "__version__",
]
