"""
NEXIUM Hello World Example
The simplest NEXIUM application
"""

from nexium import Nexium

app = Nexium(title="Hello World App", debug=True)


@app.get("/")
async def home():
    """Home endpoint."""
    return {
        "message": "Hello, NEXIUM! 🌟",
        "framework": "NEXIUM",
        "version": "0.1.0"
    }


@app.get("/greet/{name}")
async def greet(name: str):
    """Personalized greeting."""
    return {"message": f"Hello, {name}! Welcome to NEXIUM! 👋"}


if __name__ == "__main__":
    app.run(host="127.0.0.1", port=8000, reload=True)
