/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
const main = (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.lenght-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
/* main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    (0, tslib_1.__exportStar)(require(2) /* ./index */, exports);
},
/* tslib/tslib.es6.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) {
                for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p];
            };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    exports.__extends = __extends;
    var __assign = function () {
        exports.__assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return exports.__assign.apply(this, arguments);
    };
    exports.__assign = __assign;
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    exports.__rest = __rest;
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    exports.__decorate = __decorate;
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    exports.__param = __param;
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    exports.__metadata = __metadata;
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
                try {
                    step(generator.next(value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function rejected(value) {
                try {
                    step(generator["throw"](value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    exports.__awaiter = __awaiter;
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () {
                if (t[0] & 1)
                    throw t[1];
                return t[1];
            }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    exports.__generator = __generator;
    exports.__createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        Object.defineProperty(o, k2, { enumerable: true, get: function () { return m[k]; } });
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                (0, exports.__createBinding)(o, m, p);
    }
    exports.__exportStar = __exportStar;
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    exports.__values = __values;
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    exports.__read = __read;
    /** @deprecated */
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    exports.__spread = __spread;
    /** @deprecated */
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    exports.__spreadArrays = __spreadArrays;
    function __spreadArray(to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    }
    exports.__spreadArray = __spreadArray;
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    exports.__await = __await;
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) {
            if (g[n])
                i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); };
        }
        function resume(n, v) {
            try {
                step(g[n](v));
            }
            catch (e) {
                settle(q[0][3], e);
            }
        }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) {
            if (f(v), q.shift(), q.length)
                resume(q[0][0], q[0][1]);
        }
    }
    exports.__asyncGenerator = __asyncGenerator;
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }
    exports.__asyncDelegator = __asyncDelegator;
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    exports.__asyncValues = __asyncValues;
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    exports.__makeTemplateObject = __makeTemplateObject;
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    (0, exports.__createBinding)(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    }
    exports.__importStar = __importStar;
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    exports.__importDefault = __importDefault;
    function __classPrivateFieldGet(receiver, state, kind, f) {
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    }
    exports.__classPrivateFieldGet = __classPrivateFieldGet;
    function __classPrivateFieldSet(receiver, state, value, kind, f) {
        if (kind === "m")
            throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    }
    exports.__classPrivateFieldSet = __classPrivateFieldSet;
},
/* index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var version_1 = require(3) /* ./version */;
    __esExport("version", version_1.version);
    var embed_1 = require(4) /* ./embed */;
    __esExport("index", embed_1.index);
    exports.embed = (0, tslib_1.__importStar)(require(4) /* ./embed */);
    exports.protocol = (0, tslib_1.__importStar)(require(406) /* ./protocol */);
    exports._testing = (0, tslib_1.__importStar)(require(407) /* ./testing */);
    var logging_1 = require(19) /* ./core/logging */;
    __esExport("logger", logging_1.logger);
    __esExport("set_log_level", logging_1.set_log_level);
    var settings_1 = require(28) /* ./core/settings */;
    __esExport("settings", settings_1.settings);
    var base_1 = require(7) /* ./base */;
    __esExport("Models", base_1.Models);
    var document_1 = require(5) /* ./document */;
    __esExport("documents", document_1.documents);
    var safely_1 = require(408) /* ./safely */;
    __esExport("safely", safely_1.safely);
},
/* version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.version = "2.4.2-dev.1";
},
/* embed/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const document_1 = require(5) /* ../document */;
    const logging_1 = require(19) /* ../core/logging */;
    const string_1 = require(34) /* ../core/util/string */;
    const object_1 = require(13) /* ../core/util/object */;
    const types_1 = require(8) /* ../core/util/types */;
    const defer_1 = require(16) /* ../core/util/defer */;
    const standalone_1 = require(397) /* ./standalone */;
    const server_1 = require(399) /* ./server */;
    const dom_1 = require(398) /* ./dom */;
    var standalone_2 = require(397) /* ./standalone */;
    __esExport("add_document_standalone", standalone_2.add_document_standalone);
    __esExport("index", standalone_2.index);
    var server_2 = require(399) /* ./server */;
    __esExport("add_document_from_session", server_2.add_document_from_session);
    var notebook_1 = require(404) /* ./notebook */;
    __esExport("embed_items_notebook", notebook_1.embed_items_notebook);
    __esExport("kernels", notebook_1.kernels);
    var dom_2 = require(398) /* ./dom */;
    __esExport("BOKEH_ROOT", dom_2.BOKEH_ROOT);
    async function embed_item(item, target_id) {
        const docs_json = {};
        const doc_id = (0, string_1.uuid4)();
        docs_json[doc_id] = item.doc;
        if (target_id == null)
            target_id = item.target_id;
        const element = document.getElementById(target_id);
        if (element != null)
            element.classList.add(dom_1.BOKEH_ROOT);
        const roots = { [item.root_id]: target_id };
        const render_item = { roots, root_ids: [item.root_id], docid: doc_id };
        await (0, defer_1.defer)();
        const [views] = await _embed_items(docs_json, [render_item]);
        return views;
    }
    exports.embed_item = embed_item;
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    async function embed_items(docs_json, render_items, app_path, absolute_url) {
        await (0, defer_1.defer)();
        return _embed_items(docs_json, render_items, app_path, absolute_url);
    }
    exports.embed_items = embed_items;
    async function _embed_items(docs_json, render_items, app_path, absolute_url) {
        if ((0, types_1.isString)(docs_json))
            docs_json = JSON.parse((0, string_1.unescape)(docs_json));
        const docs = {};
        for (const [docid, doc_json] of (0, object_1.entries)(docs_json)) {
            docs[docid] = document_1.Document.from_json(doc_json);
        }
        const views = [];
        for (const item of render_items) {
            const element = (0, dom_1._resolve_element)(item);
            const roots = (0, dom_1._resolve_root_elements)(item);
            if (item.docid != null) {
                views.push(await (0, standalone_1.add_document_standalone)(docs[item.docid], element, roots, item.use_for_title));
            }
            else if (item.token != null) {
                const websocket_url = (0, server_1._get_ws_url)(app_path, absolute_url);
                logging_1.logger.debug(`embed: computed ws url: ${websocket_url}`);
                try {
                    views.push(await (0, server_1.add_document_from_session)(websocket_url, item.token, element, roots, item.use_for_title));
                    console.log("Bokeh items were rendered successfully");
                }
                catch (error) {
                    console.log("Error rendering Bokeh items:", error);
                }
            }
            else
                throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");
        }
        return views;
    }
},
/* document/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    (0, tslib_1.__exportStar)(require(6) /* ./document */, exports);
    (0, tslib_1.__exportStar)(require(35) /* ./events */, exports);
},
/* document/document.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const base_1 = require(7) /* ../base */;
    const version_1 = require(3) /* ../version */;
    const logging_1 = require(19) /* ../core/logging */;
    const bokeh_events_1 = require(251) /* ../core/bokeh_events */;
    const has_props_1 = require(14) /* ../core/has_props */;
    const serializer_1 = require(30) /* ../core/serializer */;
    const signaling_1 = require(15) /* ../core/signaling */;
    const refs_1 = require(17) /* ../core/util/refs */;
    const serialization_1 = require(31) /* ../core/util/serialization */;
    const ndarray_1 = require(29) /* ../core/util/ndarray */;
    const array_1 = require(9) /* ../core/util/array */;
    const object_1 = require(13) /* ../core/util/object */;
    const sets = (0, tslib_1.__importStar)(require(77) /* ../core/util/set */);
    const eq_1 = require(26) /* ../core/util/eq */;
    const types_1 = require(8) /* ../core/util/types */;
    const layout_dom_1 = require(309) /* ../models/layouts/layout_dom */;
    const column_data_source_1 = require(75) /* ../models/sources/column_data_source */;
    const model_1 = require(53) /* ../model */;
    const defs_1 = require(396) /* ./defs */;
    const events_1 = require(35) /* ./events */;
    // Dispatches events to the subscribed models
    class EventManager {
        constructor(document) {
            this.document = document;
            this.session = null;
            this.subscribed_models = new Set();
        }
        send_event(bokeh_event) {
            const event = new events_1.MessageSentEvent(this.document, "bokeh_event", bokeh_event.to_json());
            this.document._trigger_on_change(event);
        }
        trigger(event) {
            for (const model of this.subscribed_models) {
                if (event.origin != null && event.origin != model)
                    continue;
                model._process_event(event);
            }
        }
    }
    exports.EventManager = EventManager;
    EventManager.__name__ = "EventManager";
    exports.documents = [];
    exports.DEFAULT_TITLE = "Bokeh Application";
    // This class should match the API of the Python Document class
    // as much as possible.
    class Document {
        constructor(options) {
            var _a;
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._resolver = (_a = options === null || options === void 0 ? void 0 : options.resolver) !== null && _a !== void 0 ? _a : new base_1.ModelResolver();
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = new Map();
            this._all_models_freeze_count = 0;
            this._callbacks = new Map();
            this._message_callbacks = new Map();
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal0(this, "idle");
            this._idle_roots = new WeakMap(); // TODO: WeakSet would be better
            this._interactive_timestamp = null;
            this._interactive_plot = null;
        }
        get layoutables() {
            return this._roots.filter((root) => root instanceof layout_dom_1.LayoutDOM);
        }
        get is_idle() {
            for (const root of this.layoutables) {
                if (!this._idle_roots.has(root))
                    return false;
            }
            return true;
        }
        notify_idle(model) {
            this._idle_roots.set(model, true);
            if (this.is_idle) {
                logging_1.logger.info(`document idle at ${Date.now() - this._init_timestamp} ms`);
                this.event_manager.send_event(new bokeh_events_1.DocumentReady());
                this.idle.emit();
            }
        }
        clear() {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0]);
                }
            }
            finally {
                this._pop_all_models_freeze();
            }
        }
        interactive_start(plot, finalize = null) {
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_1.LODStart());
            }
            this._interactive_finalize = finalize;
            this._interactive_timestamp = Date.now();
        }
        interactive_stop() {
            if (this._interactive_plot != null) {
                this._interactive_plot.trigger_event(new bokeh_events_1.LODEnd());
                if (this._interactive_finalize != null) {
                    this._interactive_finalize();
                }
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
            this._interactive_finalize = null;
        }
        interactive_duration() {
            if (this._interactive_timestamp == null)
                return -1;
            else
                return Date.now() - this._interactive_timestamp;
        }
        destructively_move(dest_doc) {
            if (dest_doc === this) {
                throw new Error("Attempted to overwrite a document with itself");
            }
            dest_doc.clear();
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            const roots = (0, array_1.copy)(this._roots);
            this.clear();
            for (const root of roots) {
                if (root.document != null)
                    throw new Error(`Somehow we didn't detach ${root}`);
            }
            if (this._all_models.size != 0) {
                throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);
            }
            for (const root of roots) {
                dest_doc.add_root(root);
            }
            dest_doc.set_title(this._title);
        }
        // TODO other fields of doc
        _push_all_models_freeze() {
            this._all_models_freeze_count += 1;
        }
        _pop_all_models_freeze() {
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        }
        /*protected*/ _invalidate_all_models() {
            logging_1.logger.debug("invalidating document models");
            // if freeze count is > 0, we'll recompute on unfreeze
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        }
        _recompute_all_models() {
            let new_all_models_set = new Set();
            for (const r of this._roots) {
                new_all_models_set = sets.union(new_all_models_set, r.references());
            }
            const old_all_models_set = new Set(this._all_models.values());
            const to_detach = sets.difference(old_all_models_set, new_all_models_set);
            const to_attach = sets.difference(new_all_models_set, old_all_models_set);
            const recomputed = new Map();
            for (const model of new_all_models_set) {
                recomputed.set(model.id, model);
            }
            for (const d of to_detach) {
                d.detach_document();
            }
            for (const a of to_attach) {
                a.attach_document(this);
            }
            this._all_models = recomputed;
        }
        roots() {
            return this._roots;
        }
        add_root(model, setter_id) {
            logging_1.logger.debug(`Adding root: ${model}`);
            if ((0, array_1.includes)(this._roots, model))
                return;
            this._push_all_models_freeze();
            try {
                this._roots.push(model);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootAddedEvent(this, model, setter_id));
        }
        remove_root(model, setter_id) {
            const i = this._roots.indexOf(model);
            if (i < 0)
                return;
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootRemovedEvent(this, model, setter_id));
        }
        title() {
            return this._title;
        }
        set_title(title, setter_id) {
            if (title !== this._title) {
                this._title = title;
                this._trigger_on_change(new events_1.TitleChangedEvent(this, title, setter_id));
            }
        }
        get_model_by_id(model_id) {
            var _a;
            return (_a = this._all_models.get(model_id)) !== null && _a !== void 0 ? _a : null;
        }
        get_model_by_name(name) {
            const found = [];
            for (const model of this._all_models.values()) {
                if (model instanceof model_1.Model && model.name == name)
                    found.push(model);
            }
            switch (found.length) {
                case 0:
                    return null;
                case 1:
                    return found[0];
                default:
                    throw new Error(`Multiple models are named '${name}'`);
            }
        }
        on_message(msg_type, callback) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks == null)
                this._message_callbacks.set(msg_type, new Set([callback]));
            else
                message_callbacks.add(callback);
        }
        remove_on_message(msg_type, callback) {
            var _a;
            (_a = this._message_callbacks.get(msg_type)) === null || _a === void 0 ? void 0 : _a.delete(callback);
        }
        _trigger_on_message(msg_type, msg_data) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks != null) {
                for (const cb of message_callbacks) {
                    cb(msg_data);
                }
            }
        }
        on_change(callback, allow_batches = false) {
            if (!this._callbacks.has(callback)) {
                this._callbacks.set(callback, allow_batches);
            }
        }
        remove_on_change(callback) {
            this._callbacks.delete(callback);
        }
        _trigger_on_change(event) {
            for (const [callback, allow_batches] of this._callbacks) {
                if (!allow_batches && event instanceof events_1.DocumentEventBatch) {
                    for (const ev of event.events) {
                        callback(ev);
                    }
                }
                else {
                    callback(event); // TODO
                }
            }
        }
        _notify_change(model, attr, old_value, new_value, options) {
            this._trigger_on_change(new events_1.ModelChangedEvent(this, model, attr, old_value, new_value, options === null || options === void 0 ? void 0 : options.setter_id, options === null || options === void 0 ? void 0 : options.hint));
        }
        static _instantiate_object(obj_id, obj_type, obj_attrs, resolver) {
            const full_attrs = Object.assign(Object.assign({}, obj_attrs), { id: obj_id, __deferred__: true });
            const model = resolver.get(obj_type);
            return new model(full_attrs);
        }
        // given a JSON representation of all models in a graph, return a
        // dict of new model objects
        static _instantiate_references_json(references_json, existing_models, resolver) {
            var _a;
            // Create all instances, but without setting their props
            const references = new Map();
            for (const obj of references_json) {
                const obj_id = obj.id;
                const obj_type = obj.type;
                const obj_attrs = (_a = obj.attributes) !== null && _a !== void 0 ? _a : {};
                let instance = existing_models.get(obj_id);
                if (instance == null) {
                    instance = Document._instantiate_object(obj_id, obj_type, obj_attrs, resolver);
                    if (obj.subtype != null)
                        instance.set_subtype(obj.subtype);
                }
                references.set(instance.id, instance);
            }
            return references;
        }
        // if v looks like a ref, or a collection, resolve it, otherwise return it unchanged
        // recurse into collections but not into HasProps
        static _resolve_refs(value, old_references, new_references, buffers) {
            function resolve_ref(v) {
                var _a;
                if ((0, refs_1.is_ref)(v)) {
                    const obj = (_a = old_references.get(v.id)) !== null && _a !== void 0 ? _a : new_references.get(v.id);
                    if (obj != null)
                        return obj;
                    else
                        throw new Error(`reference ${JSON.stringify(v)} isn't known (not in Document?)`);
                }
                else if ((0, serialization_1.is_NDArray_ref)(v)) {
                    const { buffer, dtype, shape } = (0, serialization_1.decode_NDArray)(v, buffers);
                    return (0, ndarray_1.ndarray)(buffer, { dtype, shape });
                }
                else if ((0, types_1.isArray)(v))
                    return resolve_array(v);
                else if ((0, types_1.isPlainObject)(v))
                    return resolve_dict(v);
                else
                    return v;
            }
            function resolve_array(array) {
                const results = [];
                for (const v of array) {
                    results.push(resolve_ref(v));
                }
                return results;
            }
            function resolve_dict(dict) {
                const resolved = {};
                for (const [k, v] of (0, object_1.entries)(dict)) {
                    resolved[k] = resolve_ref(v);
                }
                return resolved;
            }
            return resolve_ref(value);
        }
        // given a JSON representation of all models in a graph and new
        // model instances, set the properties on the models from the
        // JSON
        static _initialize_references_json(references_json, old_references, new_references, buffers) {
            const to_update = new Map();
            for (const { id, attributes } of references_json) {
                const is_new = !old_references.has(id);
                const instance = is_new ? new_references.get(id) : old_references.get(id);
                // replace references with actual instances in obj_attrs
                const resolved_attrs = Document._resolve_refs(attributes, old_references, new_references, buffers);
                instance.setv(resolved_attrs, { silent: true });
                to_update.set(id, { instance, is_new });
            }
            const ordered_instances = [];
            const handled = new Set();
            function finalize_all_by_dfs(v) {
                if (v instanceof has_props_1.HasProps) {
                    // note that we ignore instances that aren't updated (not in to_update)
                    if (to_update.has(v.id) && !handled.has(v.id)) {
                        handled.add(v.id);
                        const { instance, is_new } = to_update.get(v.id);
                        const { attributes } = instance;
                        for (const value of (0, object_1.values)(attributes)) {
                            finalize_all_by_dfs(value);
                        }
                        if (is_new) {
                            // Finalizing here just to avoid iterating
                            // over `ordered_instances` twice.
                            instance.finalize();
                            // Preserving an ordered collection of instances
                            // to avoid having to go through DFS again.
                            ordered_instances.push(instance);
                        }
                    }
                }
                else if ((0, types_1.isArray)(v)) {
                    for (const e of v)
                        finalize_all_by_dfs(e);
                }
                else if ((0, types_1.isPlainObject)(v)) {
                    for (const value of (0, object_1.values)(v))
                        finalize_all_by_dfs(value);
                }
            }
            for (const item of to_update.values()) {
                finalize_all_by_dfs(item.instance);
            }
            // `connect_signals` has to be executed last because it
            // may rely on properties of dependencies that are initialized
            // only in `finalize`. It's a problem that appears when
            // there are circular references, e.g. as in
            // CDS -> CustomJS (on data change) -> GlyphRenderer (in args) -> CDS.
            for (const instance of ordered_instances) {
                instance.connect_signals();
            }
        }
        //////
        ///{{{
        static _event_for_attribute_change(changed_obj, key, new_value, doc, value_refs) {
            const changed_model = doc.get_model_by_id(changed_obj.id); // XXX!
            if (!changed_model.property(key).syncable)
                return null;
            else {
                const event = {
                    kind: "ModelChanged",
                    model: { id: changed_obj.id },
                    attr: key,
                    new: new_value,
                };
                has_props_1.HasProps._json_record_references(doc, new_value, value_refs, { recursive: true });
                return event;
            }
        }
        static _events_to_sync_objects(from_obj, to_obj, to_doc, value_refs) {
            const from_keys = Object.keys(from_obj.attributes); //XXX!
            const to_keys = Object.keys(to_obj.attributes); //XXX!
            const removed = (0, array_1.difference)(from_keys, to_keys);
            const added = (0, array_1.difference)(to_keys, from_keys);
            const shared = (0, array_1.intersection)(from_keys, to_keys);
            const events = [];
            for (const key of removed) {
                // we don't really have a "remove" event - not sure this ever
                // happens even. One way this could happen is if the server
                // does include_defaults=True and we do
                // include_defaults=false ... in that case it'd be best to
                // just ignore this probably. Warn about it, could mean
                // there's a bug if we don't have a key that the server sent.
                logging_1.logger.warn(`Server sent key ${key} but we don't seem to have it in our JSON`);
            }
            for (const key of added) {
                const new_value = to_obj.attributes[key]; // XXX!
                events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
            }
            for (const key of shared) {
                const old_value = from_obj.attributes[key]; // XXX!
                const new_value = to_obj.attributes[key]; // XXX!
                if (old_value == null && new_value == null) {
                }
                else if (old_value == null || new_value == null) {
                    events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
                else {
                    // XXX: issue #11803, ndarrays' JSON-like repr may not be comparable due to lazy serialization
                    if (key != "data" && !(0, eq_1.is_equal)(old_value, new_value))
                        events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
            }
            return events.filter((e) => e != null);
        }
        // we use this to detect changes during document deserialization
        // (in model constructors and initializers)
        static _compute_patch_since_json(from_json, to_doc) {
            const to_json = to_doc.to_json(false); // include_defaults=false
            function refs(json) {
                const result = new Map();
                for (const obj of json.roots.references)
                    result.set(obj.id, obj);
                return result;
            }
            const from_references = refs(from_json);
            const from_roots = new Map();
            const from_root_ids = [];
            for (const r of from_json.roots.root_ids) {
                from_roots.set(r, from_references.get(r));
                from_root_ids.push(r);
            }
            const to_references = refs(to_json);
            const to_roots = new Map();
            const to_root_ids = [];
            for (const r of to_json.roots.root_ids) {
                to_roots.set(r, to_references.get(r));
                to_root_ids.push(r);
            }
            from_root_ids.sort();
            to_root_ids.sort();
            if ((0, array_1.difference)(from_root_ids, to_root_ids).length > 0 ||
                (0, array_1.difference)(to_root_ids, from_root_ids).length > 0) {
                // this would arise if someone does add_root/remove_root during
                // document deserialization, hopefully they won't ever do so.
                throw new Error("Not implemented: computing add/remove of document roots");
            }
            const value_refs = new Set();
            let events = [];
            for (const id of to_doc._all_models.keys()) {
                if (from_references.has(id)) {
                    const update_model_events = Document._events_to_sync_objects(from_references.get(id), to_references.get(id), to_doc, value_refs);
                    events = events.concat(update_model_events);
                }
            }
            const serializer = new serializer_1.Serializer({ include_defaults: false });
            serializer.to_serializable([...value_refs]);
            return {
                references: [...serializer.definitions],
                events,
            };
        }
        ///}}}
        //////
        to_json_string(include_defaults = true) {
            return JSON.stringify(this.to_json(include_defaults));
        }
        to_json(include_defaults = true) {
            const serializer = new serializer_1.Serializer({ include_defaults });
            const roots = serializer.to_serializable(this._roots);
            return {
                version: version_1.version,
                title: this._title,
                roots: {
                    root_ids: roots.map((r) => r.id),
                    references: [...serializer.definitions],
                },
            };
        }
        static from_json_string(s) {
            const json = JSON.parse(s);
            return Document.from_json(json);
        }
        static from_json(json) {
            logging_1.logger.debug("Creating Document from JSON");
            function pyify(version) {
                return version.replace(/-(dev|rc)\./, "$1");
            }
            const py_version = json.version; // XXX!
            const is_dev = py_version.indexOf("+") !== -1 || py_version.indexOf("-") !== -1;
            const versions_string = `Library versions: JS (${version_1.version}) / Python (${py_version})`;
            if (!is_dev && pyify(version_1.version) != py_version) {
                logging_1.logger.warn("JS/Python version mismatch");
                logging_1.logger.warn(versions_string);
            }
            else
                logging_1.logger.debug(versions_string);
            const resolver = new base_1.ModelResolver();
            if (json.defs != null) {
                (0, defs_1.resolve_defs)(json.defs, resolver);
            }
            const roots_json = json.roots;
            const root_ids = roots_json.root_ids;
            const references_json = roots_json.references;
            const references = Document._instantiate_references_json(references_json, new Map(), resolver);
            Document._initialize_references_json(references_json, new Map(), references, new Map());
            const doc = new Document({ resolver });
            for (const id of root_ids) {
                const root = references.get(id);
                if (root != null) {
                    doc.add_root(root); // XXX: HasProps
                }
            }
            doc.set_title(json.title); // XXX!
            return doc;
        }
        replace_with_json(json) {
            const replacement = Document.from_json(json);
            replacement.destructively_move(this);
        }
        /** @deprecated */
        create_json_patch_string(events) {
            return JSON.stringify(this.create_json_patch(events));
        }
        create_json_patch(events) {
            for (const event of events) {
                if (event.document != this)
                    throw new Error("Cannot create a patch using events from a different document");
            }
            const serializer = new serializer_1.Serializer();
            const events_repr = serializer.to_serializable(events);
            // TODO: We need a proper differential serializer. For now just remove known
            // definitions. We are doing this after a complete serialization, so that all
            // new objects are recorded.
            for (const model of this._all_models.values()) {
                serializer.remove_def(model);
            }
            return {
                events: events_repr,
                references: [...serializer.definitions],
            };
        }
        apply_json_patch(patch, buffers = new Map(), setter_id) {
            const references_json = patch.references;
            const events_json = patch.events;
            const references = Document._instantiate_references_json(references_json, this._all_models, this._resolver);
            if (!(buffers instanceof Map)) {
                buffers = new Map(buffers);
            }
            // The model being changed isn't always in references so add it in
            for (const event_json of events_json) {
                switch (event_json.kind) {
                    case "RootAdded":
                    case "RootRemoved":
                    case "ModelChanged": {
                        const model_id = event_json.model.id;
                        const model = this._all_models.get(model_id);
                        if (model != null) {
                            references.set(model_id, model);
                        }
                        else if (!references.has(model_id)) {
                            logging_1.logger.warn(`Got an event for unknown model ${event_json.model}"`);
                            throw new Error("event model wasn't known");
                        }
                        break;
                    }
                }
            }
            // split references into old and new so we know whether to initialize or update
            const old_references = new Map(this._all_models);
            const new_references = new Map();
            for (const [id, value] of references) {
                if (!old_references.has(id))
                    new_references.set(id, value);
            }
            Document._initialize_references_json(references_json, old_references, new_references, buffers);
            for (const event_json of events_json) {
                switch (event_json.kind) {
                    case "MessageSent": {
                        const { msg_type, msg_data } = event_json;
                        let data;
                        if (msg_data === undefined) {
                            if (buffers.size == 1) {
                                const [[, buffer]] = buffers;
                                data = buffer;
                            }
                            else {
                                throw new Error("expected exactly one buffer");
                            }
                        }
                        else {
                            data = Document._resolve_refs(msg_data, old_references, new_references, buffers);
                        }
                        this._trigger_on_message(msg_type, data);
                        break;
                    }
                    case "ModelChanged": {
                        const patched_id = event_json.model.id;
                        const patched_obj = this._all_models.get(patched_id);
                        if (patched_obj == null) {
                            throw new Error(`Cannot apply patch to ${patched_id} which is not in the document`);
                        }
                        const attr = event_json.attr;
                        const value = Document._resolve_refs(event_json.new, old_references, new_references, buffers);
                        patched_obj.setv({ [attr]: value }, { setter_id });
                        break;
                    }
                    case "ColumnDataChanged": {
                        const column_source_id = event_json.column_source.id;
                        const column_source = this._all_models.get(column_source_id);
                        if (column_source == null) {
                            throw new Error(`Cannot stream to ${column_source_id} which is not in the document`);
                        }
                        const data = Document._resolve_refs(event_json.new, new Map(), new Map(), buffers);
                        if (event_json.cols != null) {
                            for (const k in column_source.data) {
                                if (!(k in data)) {
                                    data[k] = column_source.data[k];
                                }
                            }
                        }
                        column_source.setv({ data }, { setter_id, check_eq: false });
                        break;
                    }
                    case "ColumnsStreamed": {
                        const column_source_id = event_json.column_source.id;
                        const column_source = this._all_models.get(column_source_id);
                        if (column_source == null) {
                            throw new Error(`Cannot stream to ${column_source_id} which is not in the document`);
                        }
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error("Cannot stream to non-ColumnDataSource");
                        }
                        const data = event_json.data;
                        const rollover = event_json.rollover;
                        column_source.stream(data, rollover, setter_id);
                        break;
                    }
                    case "ColumnsPatched": {
                        const column_source_id = event_json.column_source.id;
                        const column_source = this._all_models.get(column_source_id);
                        if (column_source == null) {
                            throw new Error(`Cannot patch ${column_source_id} which is not in the document`);
                        }
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error("Cannot patch non-ColumnDataSource");
                        }
                        const patches = event_json.patches;
                        column_source.patch(patches, setter_id);
                        break;
                    }
                    case "RootAdded": {
                        const root_id = event_json.model.id;
                        const root_obj = references.get(root_id);
                        this.add_root(root_obj, setter_id); // XXX: HasProps
                        break;
                    }
                    case "RootRemoved": {
                        const root_id = event_json.model.id;
                        const root_obj = references.get(root_id);
                        this.remove_root(root_obj, setter_id); // XXX: HasProps
                        break;
                    }
                    case "TitleChanged": {
                        this.set_title(event_json.title, setter_id);
                        break;
                    }
                    default:
                        throw new Error(`Unknown patch event ${JSON.stringify(event_json)}`);
                }
            }
        }
    }
    exports.Document = Document;
    Document.__name__ = "Document";
},
/* base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(13) /* ./core/util/object */;
    const has_props_1 = require(14) /* ./core/has_props */;
    exports.overrides = {};
    const _all_models = new Map();
    exports.Models = ((name) => {
        const model = exports.Models.get(name);
        if (model != null)
            return model;
        else
            throw new Error(`Model '${name}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`);
    });
    exports.Models.get = (name) => {
        var _a;
        return (_a = exports.overrides[name]) !== null && _a !== void 0 ? _a : _all_models.get(name);
    };
    exports.Models.register = (name, model) => {
        exports.overrides[name] = model;
    };
    exports.Models.unregister = (name) => {
        delete exports.overrides[name];
    };
    function is_HasProps(obj) {
        return (0, types_1.isObject)(obj) && obj.prototype instanceof has_props_1.HasProps;
    }
    exports.Models.register_models = (models, force = false, errorFn) => {
        if (models == null)
            return;
        for (const model of (0, types_1.isArray)(models) ? models : (0, object_1.values)(models)) {
            if (is_HasProps(model)) {
                const qualified = model.__qualified__;
                if (force || !_all_models.has(qualified))
                    _all_models.set(qualified, model);
                else if (errorFn != null)
                    errorFn(qualified);
                else
                    console.warn(`Model '${qualified}' was already registered`);
            }
        }
    };
    exports.register_models = exports.Models.register_models;
    exports.Models.registered_names = () => [..._all_models.keys()];
    class ModelResolver {
        constructor() {
            this._known_models = new Map();
        }
        get(name, or_else) {
            var _a;
            const model = (_a = exports.Models.get(name)) !== null && _a !== void 0 ? _a : this._known_models.get(name);
            if (model != null)
                return model;
            else if (or_else !== undefined)
                return or_else;
            else
                throw new Error(`Model '${name}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`);
        }
        register(model) {
            const name = model.__qualified__;
            if (this.get(name, null) == null)
                this._known_models.set(name, model);
            else
                console.warn(`Model '${name}' was already registered with this resolver`);
        }
    }
    exports.ModelResolver = ModelResolver;
    ModelResolver.__name__ = "ModelResolver";
    // TODO: this doesn't belong here, but it's easier this way for backwards compatibility
    const AllModels = (0, tslib_1.__importStar)(require(38) /* ./models */);
    (0, exports.register_models)(AllModels);
    const DOMModels = (0, tslib_1.__importStar)(require(392) /* ./models/dom */);
    (0, exports.register_models)(DOMModels);
},
/* core/util/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const array_1 = require(9) /* ./array */;
    const toString = Object.prototype.toString;
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === "[object Boolean]";
    }
    exports.isBoolean = isBoolean;
    function isNumber(obj) {
        return toString.call(obj) === "[object Number]";
    }
    exports.isNumber = isNumber;
    function isInteger(obj) {
        return isNumber(obj) && Number.isInteger(obj);
    }
    exports.isInteger = isInteger;
    function isString(obj) {
        return toString.call(obj) === "[object String]";
    }
    exports.isString = isString;
    function isSymbol(obj) {
        return typeof obj === "symbol";
    }
    exports.isSymbol = isSymbol;
    function isPrimitive(obj) {
        return obj === null || isBoolean(obj) || isNumber(obj) || isString(obj) || isSymbol(obj);
    }
    exports.isPrimitive = isPrimitive;
    function isFunction(obj) {
        return toString.call(obj) === "[object Function]";
    }
    exports.isFunction = isFunction;
    function isArray(obj) {
        return Array.isArray(obj);
    }
    exports.isArray = isArray;
    function isArrayOf(arr, predicate) {
        return (0, array_1.every)(arr, predicate);
    }
    exports.isArrayOf = isArrayOf;
    function isArrayableOf(arr, predicate) {
        for (let i = 0, end = arr.length; i < end; i++) {
            if (!predicate(arr[i]))
                return false;
        }
        return true;
    }
    exports.isArrayableOf = isArrayableOf;
    function isTypedArray(obj) {
        return ArrayBuffer.isView(obj) && !(obj instanceof DataView);
    }
    exports.isTypedArray = isTypedArray;
    function isObject(obj) {
        const tp = typeof obj;
        return tp === "function" || tp === "object" && !!obj;
    }
    exports.isObject = isObject;
    function isPlainObject(obj) {
        return isObject(obj) && (obj.constructor == null || obj.constructor === Object);
    }
    exports.isPlainObject = isPlainObject;
    function isIterable(obj) {
        return isObject(obj) && obj[Symbol.iterator] !== undefined;
    }
    exports.isIterable = isIterable;
    function isArrayable(obj) {
        return isIterable(obj) && "length" in obj;
    }
    exports.isArrayable = isArrayable;
},
/* core/util/array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const math_1 = require(10) /* ./math */;
    const assert_1 = require(11) /* ./assert */;
    const arrayable_1 = require(12) /* ./arrayable */;
    __esExport("map", arrayable_1.map);
    __esExport("reduce", arrayable_1.reduce);
    __esExport("min", arrayable_1.min);
    __esExport("min_by", arrayable_1.min_by);
    __esExport("max", arrayable_1.max);
    __esExport("max_by", arrayable_1.max_by);
    __esExport("sum", arrayable_1.sum);
    __esExport("cumsum", arrayable_1.cumsum);
    __esExport("every", arrayable_1.every);
    __esExport("some", arrayable_1.some);
    __esExport("find", arrayable_1.find);
    __esExport("find_last", arrayable_1.find_last);
    __esExport("find_index", arrayable_1.find_index);
    __esExport("find_last_index", arrayable_1.find_last_index);
    __esExport("sorted_index", arrayable_1.sorted_index);
    __esExport("is_empty", arrayable_1.is_empty);
    const slice = Array.prototype.slice;
    function head(array) {
        return array[0];
    }
    exports.head = head;
    function tail(array) {
        return array[array.length - 1];
    }
    exports.tail = tail;
    function last(array) {
        return array[array.length - 1];
    }
    exports.last = last;
    function copy(array) {
        return slice.call(array);
    }
    exports.copy = copy;
    function concat(arrays) {
        return [].concat(...arrays);
    }
    exports.concat = concat;
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.includes = includes;
    exports.contains = includes;
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    exports.nth = nth;
    function zip(...arrays) {
        if (arrays.length == 0)
            return [];
        const n = (0, arrayable_1.min)(arrays.map((a) => a.length));
        const k = arrays.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = new Array(k);
            for (let j = 0; j < k; j++)
                result[i][j] = arrays[j][i];
        }
        return result;
    }
    exports.zip = zip;
    function unzip(array) {
        const n = array.length;
        const k = (0, arrayable_1.min)(array.map((a) => a.length));
        const results = Array(k);
        for (let j = 0; j < k; j++)
            results[j] = new Array(n);
        for (let i = 0; i < n; i++) {
            for (let j = 0; j < k; j++)
                results[j][i] = array[i][j];
        }
        return results;
    }
    exports.unzip = unzip;
    function range(start, stop, step = 1) {
        (0, assert_1.assert)(step > 0, "'step' must be a positive number");
        if (stop == null) {
            stop = start;
            start = 0;
        }
        const { max, ceil, abs } = Math;
        const delta = start <= stop ? step : -step;
        const length = max(ceil(abs(stop - start) / step), 0);
        const range = new Array(length);
        for (let i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    exports.range = range;
    function linspace(start, stop, num = 100) {
        const step = (stop - start) / (num - 1);
        const array = new Array(num);
        for (let i = 0; i < num; i++) {
            array[i] = start + step * i;
        }
        return array;
    }
    exports.linspace = linspace;
    function transpose(array) {
        const rows = array.length;
        const cols = array[0].length;
        const transposed = [];
        for (let j = 0; j < cols; j++) {
            transposed[j] = [];
            for (let i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    exports.transpose = transpose;
    function argmin(array) {
        return (0, arrayable_1.min_by)(range(array.length), (i) => array[i]);
    }
    exports.argmin = argmin;
    function argmax(array) {
        return (0, arrayable_1.max_by)(range(array.length), (i) => array[i]);
    }
    exports.argmax = argmax;
    function sort_by(array, key) {
        const tmp = array.map((value, index) => {
            return { value, index, key: key(value) };
        });
        tmp.sort((left, right) => {
            const a = left.key;
            const b = right.key;
            if (a !== b) {
                if (a > b || a === undefined)
                    return 1;
                if (a < b || b === undefined)
                    return -1;
            }
            return left.index - right.index;
        });
        return tmp.map((item) => item.value);
    }
    exports.sort_by = sort_by;
    function uniq(array) {
        const result = new Set();
        for (const value of array) {
            result.add(value);
        }
        return [...result];
    }
    exports.uniq = uniq;
    function uniq_by(array, key) {
        const result = [];
        const seen = [];
        for (const value of array) {
            const computed = key(value);
            if (!includes(seen, computed)) {
                seen.push(computed);
                result.push(value);
            }
        }
        return result;
    }
    exports.uniq_by = uniq_by;
    function union(...arrays) {
        const result = new Set();
        for (const array of arrays) {
            for (const value of array) {
                result.add(value);
            }
        }
        return [...result];
    }
    exports.union = union;
    function intersection(array, ...arrays) {
        const result = [];
        top: for (const item of array) {
            if (includes(result, item))
                continue;
            for (const other of arrays) {
                if (!includes(other, item))
                    continue top;
            }
            result.push(item);
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(array, ...arrays) {
        const rest = concat(arrays);
        return array.filter((value) => !includes(rest, value));
    }
    exports.difference = difference;
    function remove_at(array, i) {
        const result = copy(array);
        result.splice(i, 1);
        return result;
    }
    exports.remove_at = remove_at;
    function remove_by(array, key) {
        for (let i = 0; i < array.length;) {
            if (key(array[i]))
                array.splice(i, 1);
            else
                i++;
        }
    }
    exports.remove_by = remove_by;
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        const length = array.length;
        const shuffled = new Array(length);
        for (let i = 0; i < length; i++) {
            const rand = (0, math_1.randomIn)(0, i);
            if (rand !== i)
                shuffled[i] = shuffled[rand];
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    exports.shuffle = shuffle;
    function pairwise(array, fn) {
        const n = array.length;
        const result = new Array(n - 1);
        for (let i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    exports.pairwise = pairwise;
    function reversed(array) {
        const n = array.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    exports.reversed = reversed;
    function repeat(value, n) {
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = value;
        }
        return result;
    }
    exports.repeat = repeat;
},
/* core/util/math.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const { PI } = Math;
    function angle_norm(angle) {
        if (angle == 0) {
            return 0;
        }
        while (angle <= 0) {
            angle += 2 * PI;
        }
        while (angle > 2 * PI) {
            angle -= 2 * PI;
        }
        return angle;
    }
    exports.angle_norm = angle_norm;
    function angle_dist(lhs, rhs) {
        return angle_norm(lhs - rhs);
    }
    exports.angle_dist = angle_dist;
    function angle_between(mid, lhs, rhs, anticlock = false) {
        const d = angle_dist(lhs, rhs);
        if (d == 0)
            return false;
        if (d == 2 * PI)
            return true;
        const norm_mid = angle_norm(mid);
        const cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        return !anticlock ? cond : !cond;
    }
    exports.angle_between = angle_between;
    function random() {
        return Math.random();
    }
    exports.random = random;
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    exports.randomIn = randomIn;
    function atan2(start, end) {
        /*
         * Calculate the angle between a line containing start and end points (composed
         * of [x, y] arrays) and the positive x-axis.
         */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    exports.atan2 = atan2;
    function radians(degrees) {
        return degrees * (PI / 180);
    }
    exports.radians = radians;
    function degrees(radians) {
        return radians / (PI / 180);
    }
    exports.degrees = degrees;
    function resolve_angle(angle, units) {
        /** Convert CCW angle with units to CW radians (canvas). */
        return -to_radians_coeff(units) * angle;
    }
    exports.resolve_angle = resolve_angle;
    function to_radians_coeff(units) {
        switch (units) {
            case "deg": return PI / 180;
            case "rad": return 1;
            case "grad": return PI / 200;
            case "turn": return 2 * PI;
        }
    }
    exports.to_radians_coeff = to_radians_coeff;
    // http://www2.econ.osaka-u.ac.jp/~tanizaki/class/2013/econome3/13.pdf (Page 432)
    function rnorm(mu, sigma) {
        // Generate a random normal with a mean of 0 and a sigma of 1
        let r1;
        let r2;
        while (true) {
            r1 = random();
            r2 = random();
            r2 = (2 * r2 - 1) * Math.sqrt(2 * (1 / Math.E));
            if (-4 * r1 * r1 * Math.log(r1) >= r2 * r2)
                break;
        }
        let rn = r2 / r1;
        // Transform the standard normal to meet the characteristics that we want (mu, sigma)
        rn = mu + sigma * rn;
        return rn;
    }
    exports.rnorm = rnorm;
    function clamp(val, min, max) {
        return val < min ? min : (val > max ? max : val);
    }
    exports.clamp = clamp;
    function log(x, base = Math.E) {
        return Math.log(x) / Math.log(base);
    }
    exports.log = log;
    exports.float32_epsilon = 1.1920928955078125e-7; // IEEE-754
},
/* core/util/assert.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class AssertionError extends Error {
    }
    exports.AssertionError = AssertionError;
    AssertionError.__name__ = "AssertionError";
    function assert(condition, message) {
        if (condition === true || (condition !== false && condition()))
            return;
        throw new AssertionError(message !== null && message !== void 0 ? message : "Assertion failed");
    }
    exports.assert = assert;
    function unreachable() {
        throw new Error("unreachable code");
    }
    exports.unreachable = unreachable;
},
/* core/util/arrayable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const math_1 = require(10) /* ./math */;
    function is_empty(array) {
        return array.length == 0;
    }
    exports.is_empty = is_empty;
    function copy(array) {
        if (Array.isArray(array))
            return array.slice();
        else
            return new array.constructor(array);
    }
    exports.copy = copy;
    function splice(array, start, k, ...items) {
        const len = array.length;
        if (start < 0)
            start += len;
        if (start < 0)
            start = 0;
        else if (start > len)
            start = len;
        if (k == null || k > len - start)
            k = len - start;
        else if (k < 0)
            k = 0;
        const n = len - k + items.length;
        const result = new array.constructor(n);
        let i = 0;
        for (; i < start; i++) {
            result[i] = array[i];
        }
        for (const item of items) {
            result[i++] = item;
        }
        for (let j = start + k; j < len; j++) {
            result[i++] = array[j];
        }
        return result;
    }
    exports.splice = splice;
    function head(array, n) {
        return splice(array, n, array.length - n);
    }
    exports.head = head;
    function insert(array, item, i) {
        return splice(array, i, 0, item);
    }
    exports.insert = insert;
    function append(array, item) {
        return splice(array, array.length, 0, item);
    }
    exports.append = append;
    function prepend(array, item) {
        return splice(array, 0, 0, item);
    }
    exports.prepend = prepend;
    function indexOf(array, item) {
        for (let i = 0, n = array.length; i < n; i++) {
            if (array[i] === item)
                return i;
        }
        return -1;
    }
    exports.indexOf = indexOf;
    function subselect(array, indices) {
        const n = indices.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = array[indices[i]];
        }
        return result;
    }
    exports.subselect = subselect;
    function mul(array, coeff, output) {
        const n = array.length;
        const result = output !== null && output !== void 0 ? output : new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = array[i] * coeff;
        }
        return result;
    }
    exports.mul = mul;
    function map(array, fn) {
        const n = array.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = fn(array[i], i, array);
        }
        return result;
    }
    exports.map = map;
    function inplace_map(array, fn, output) {
        const n = array.length;
        const result = output !== null && output !== void 0 ? output : array;
        for (let i = 0; i < n; i++) {
            result[i] = fn(array[i], i);
        }
    }
    exports.inplace_map = inplace_map;
    function filter(array, pred) {
        const n = array.length;
        const result = new array.constructor(n);
        let k = 0;
        for (let i = 0; i < n; i++) {
            const value = array[i];
            if (pred(value, i, array))
                result[k++] = value;
        }
        return head(result, k);
    }
    exports.filter = filter;
    function reduce(array, fn, initial) {
        const n = array.length;
        if (initial === undefined && n == 0)
            throw new Error("can't reduce an empty array without an initial value");
        let value;
        let i;
        if (initial === undefined) {
            value = array[0];
            i = 1;
        }
        else {
            value = initial;
            i = 0;
        }
        for (; i < n; i++) {
            value = fn(value, array[i], i, array);
        }
        return value;
    }
    exports.reduce = reduce;
    function min(array) {
        let value;
        let result = Infinity;
        for (let i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value < result) {
                result = value;
            }
        }
        return result;
    }
    exports.min = min;
    function max(array) {
        let value;
        let result = -Infinity;
        for (let i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value > result) {
                result = value;
            }
        }
        return result;
    }
    exports.max = max;
    function minmax(array) {
        let value;
        let min = +Infinity;
        let max = -Infinity;
        for (let i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value)) {
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
            }
        }
        return [min, max];
    }
    exports.minmax = minmax;
    function minmax2(arr, brr) {
        let a;
        let b;
        let a_min = +Infinity;
        let a_max = -Infinity;
        let b_min = +Infinity;
        let b_max = -Infinity;
        const n = Math.min(arr.length, brr.length);
        for (let i = 0; i < n; i++) {
            a = arr[i];
            b = brr[i];
            if (!isNaN(a) && !isNaN(b)) {
                if (a < a_min)
                    a_min = a;
                if (a > a_max)
                    a_max = a;
                if (b < b_min)
                    b_min = b;
                if (b > b_max)
                    b_max = b;
            }
        }
        return [a_min, a_max, b_min, b_max];
    }
    exports.minmax2 = minmax2;
    function min_by(array, key) {
        if (array.length == 0)
            throw new Error("min_by() called with an empty array");
        let result = array[0];
        let resultComputed = key(result);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value);
            if (computed < resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.min_by = min_by;
    function max_by(array, key) {
        if (array.length == 0)
            throw new Error("max_by() called with an empty array");
        let result = array[0];
        let resultComputed = key(result);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value);
            if (computed > resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.max_by = max_by;
    function sum(array) {
        let result = 0;
        for (let i = 0, n = array.length; i < n; i++) {
            result += array[i];
        }
        return result;
    }
    exports.sum = sum;
    function cumsum(array) {
        const result = new array.constructor(array.length);
        reduce(array, (a, b, i) => result[i] = a + b, 0);
        return result;
    }
    exports.cumsum = cumsum;
    function every(array, predicate) {
        for (let i = 0, length = array.length; i < length; i++) {
            if (!predicate(array[i]))
                return false;
        }
        return true;
    }
    exports.every = every;
    function some(array, predicate) {
        for (let i = 0, length = array.length; i < length; i++) {
            if (predicate(array[i]))
                return true;
        }
        return false;
    }
    exports.some = some;
    function index_of(array, value) {
        for (let i = 0, length = array.length; i < length; i++) {
            if (array[i] === value)
                return i;
        }
        return -1;
    }
    exports.index_of = index_of;
    function _find_index(dir) {
        return function (array, predicate) {
            const length = array.length;
            let index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index]))
                    return index;
            }
            return -1;
        };
    }
    exports.find_index = _find_index(1);
    exports.find_last_index = _find_index(-1);
    function find(array, predicate) {
        const index = (0, exports.find_index)(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find = find;
    function find_last(array, predicate) {
        const index = (0, exports.find_last_index)(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find_last = find_last;
    function sorted_index(array, value) {
        let low = 0;
        let high = array.length;
        while (low < high) {
            const mid = Math.floor((low + high) / 2);
            if (array[mid] < value)
                low = mid + 1;
            else
                high = mid;
        }
        return low;
    }
    exports.sorted_index = sorted_index;
    function bin_counts(data, bin_edges) {
        const nbins = bin_edges.length - 1;
        const counts = Array(nbins).fill(0);
        for (let i = 0; i < data.length; i++) {
            const sample = data[i];
            const index = sorted_index(bin_edges, sample);
            const bin = (0, math_1.clamp)(index - 1, 0, nbins - 1);
            counts[bin] += 1;
        }
        return counts;
    }
    exports.bin_counts = bin_counts;
    function interpolate(points, x_values, y_values) {
        // Implementation ported from np.interp
        const n = points.length;
        const results = new Array(n);
        for (let i = 0; i < n; i++) {
            const point = points[i];
            if (isNaN(point)) {
                results[i] = point;
                continue;
            }
            const index = left_edge_index(point, x_values);
            if (index == -1)
                results[i] = y_values[0];
            else if (index == x_values.length)
                results[i] = y_values[y_values.length - 1];
            else if (index == x_values.length - 1 || x_values[index] == point) {
                results[i] = y_values[index];
            }
            else {
                const x0 = x_values[index];
                const y0 = y_values[index];
                const x1 = x_values[index + 1];
                const y1 = y_values[index + 1];
                results[i] = lerp(point, x0, y0, x1, y1);
            }
        }
        return results;
    }
    exports.interpolate = interpolate;
    function lerp(x, x0, y0, x1, y1) {
        const slope = (y1 - y0) / (x1 - x0);
        let res = slope * (x - x0) + y0;
        if (!isFinite(res)) {
            res = slope * (x - x1) + y1;
            if (!isFinite(res) && (y0 == y1))
                res = y0;
        }
        return res;
    }
    function left_edge_index(point, intervals) {
        if (point < intervals[0])
            return -1;
        if (point > intervals[intervals.length - 1])
            return intervals.length;
        let leftEdgeIndex = 0;
        let rightEdgeIndex = intervals.length - 1;
        while (rightEdgeIndex - leftEdgeIndex != 1) {
            const indexOfNumberToCompare = leftEdgeIndex + Math.floor((rightEdgeIndex - leftEdgeIndex) / 2);
            if (point >= intervals[indexOfNumberToCompare])
                leftEdgeIndex = indexOfNumberToCompare;
            else
                rightEdgeIndex = indexOfNumberToCompare;
        }
        return leftEdgeIndex;
    }
    exports.left_edge_index = left_edge_index;
    function norm(array, start, end) {
        const span = end - start;
        return map(array, (x) => (x - start) / span);
    }
    exports.norm = norm;
},
/* core/util/object.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const array_1 = require(9) /* ./array */;
    const { hasOwnProperty } = Object.prototype;
    exports.keys = Object.keys, exports.values = Object.values, exports.entries = Object.entries, exports.extend = Object.assign;
    function clone(obj) {
        return Object.assign({}, obj);
    }
    exports.clone = clone;
    function merge(obj1, obj2) {
        /*
         * Returns an object with the array values for obj1 and obj2 unioned by key.
         */
        const result = Object.create(Object.prototype);
        const keys = (0, array_1.concat)([Object.keys(obj1), Object.keys(obj2)]);
        for (const key of keys) {
            const arr1 = hasOwnProperty.call(obj1, key) ? obj1[key] : [];
            const arr2 = hasOwnProperty.call(obj2, key) ? obj2[key] : [];
            result[key] = (0, array_1.union)(arr1, arr2);
        }
        return result;
    }
    exports.merge = merge;
    function size(obj) {
        return Object.keys(obj).length;
    }
    exports.size = size;
    function is_empty(obj) {
        return size(obj) == 0;
    }
    exports.is_empty = is_empty;
    /** @deprecated */
    exports.isEmpty = is_empty;
    function to_object(map) {
        const obj = {};
        for (const [key, val] of map) {
            obj[key] = val;
        }
        return obj;
    }
    exports.to_object = to_object;
},
/* core/has_props.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const signaling_1 = require(15) /* ./signaling */;
    const refs_1 = require(17) /* ./util/refs */;
    const p = (0, tslib_1.__importStar)(require(18) /* ./properties */);
    const k = (0, tslib_1.__importStar)(require(21) /* ./kinds */);
    const string_1 = require(34) /* ./util/string */;
    const object_1 = require(13) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    const eq_1 = require(26) /* ./util/eq */;
    const serializer_1 = require(30) /* ./serializer */;
    const events_1 = require(35) /* ../document/events */;
    const eq_2 = require(26) /* ./util/eq */;
    const pretty_1 = require(36) /* ./util/pretty */;
    const cloneable_1 = require(37) /* ./util/cloneable */;
    const kinds = (0, tslib_1.__importStar)(require(21) /* ./kinds */);
    class HasProps extends (0, signaling_1.Signalable)() {
        constructor(attrs = {}) {
            var _b, _c;
            super();
            this._subtype = undefined;
            this.document = null;
            this.destroyed = new signaling_1.Signal0(this, "destroyed");
            this.change = new signaling_1.Signal0(this, "change");
            this.transformchange = new signaling_1.Signal0(this, "transformchange");
            this.exprchange = new signaling_1.Signal0(this, "exprchange");
            this.properties = {};
            this._watchers = new WeakMap();
            this._pending = false;
            this._changing = false;
            const get = attrs instanceof Map ? attrs.get.bind(attrs) : (name) => attrs[name];
            this.id = (_b = get("id")) !== null && _b !== void 0 ? _b : (0, string_1.uniqueId)();
            for (const [name, { type, default_value, options }] of (0, object_1.entries)(this._props)) {
                let property;
                if (type instanceof p.PropertyAlias) {
                    Object.defineProperty(this.properties, name, {
                        get: () => this.properties[type.attr],
                        configurable: false,
                        enumerable: false,
                    });
                }
                else {
                    if (type instanceof k.Kind)
                        property = new p.PrimitiveProperty(this, name, type, default_value, get(name), options);
                    else
                        property = new type(this, name, k.Any, default_value, get(name), options);
                    this.properties[name] = property;
                }
            }
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (!((_c = get("__deferred__")) !== null && _c !== void 0 ? _c : false)) {
                this.finalize();
                this.connect_signals();
            }
        }
        get is_syncable() {
            return true;
        }
        // XXX: setter is only required for backwards compatibility
        set type(name) {
            console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead");
            this.constructor.__name__ = name;
        }
        get type() {
            return this.constructor.__qualified__;
        }
        static get __qualified__() {
            const { __module__, __name__ } = this;
            return __module__ != null ? `${__module__}.${__name__}` : __name__;
        }
        static get [Symbol.toStringTag]() {
            return this.__name__;
        }
        static _fix_default(default_value, _attr) {
            if (default_value === undefined || (0, types_1.isFunction)(default_value))
                return default_value;
            else if ((0, types_1.isPrimitive)(default_value))
                return () => default_value;
            else {
                const cloner = new cloneable_1.Cloner();
                return () => cloner.clone(default_value);
            }
        }
        // TODO: don't use Partial<>, but exclude inherited properties
        static define(obj) {
            for (const [name, prop] of (0, object_1.entries)((0, types_1.isFunction)(obj) ? obj(kinds) : obj)) {
                if (this.prototype._props[name] != null)
                    throw new Error(`attempted to redefine property '${this.prototype.type}.${name}'`);
                if (this.prototype[name] != null)
                    throw new Error(`attempted to redefine attribute '${this.prototype.type}.${name}'`);
                Object.defineProperty(this.prototype, name, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get() {
                        const value = this.properties[name].get_value();
                        return value;
                    },
                    set(value) {
                        this.setv({ [name]: value });
                        return this;
                    },
                    configurable: false,
                    enumerable: true,
                });
                const [type, default_value, options = {}] = prop;
                const refined_prop = {
                    type,
                    default_value: this._fix_default(default_value, name),
                    options,
                };
                const props = Object.assign({}, this.prototype._props);
                props[name] = refined_prop;
                this.prototype._props = props;
            }
        }
        static internal(obj) {
            const _object = {};
            for (const [name, prop] of (0, object_1.entries)((0, types_1.isFunction)(obj) ? obj(kinds) : obj)) {
                const [type, default_value, options = {}] = prop;
                _object[name] = [type, default_value, Object.assign(Object.assign({}, options), { internal: true })];
            }
            this.define(_object);
        }
        static mixins(defs) {
            function rename(prefix, mixin) {
                const result = {};
                for (const [name, prop] of (0, object_1.entries)(mixin)) {
                    result[prefix + name] = prop;
                }
                return result;
            }
            const mixin_defs = {};
            const mixins = [];
            for (const def of (0, types_1.isArray)(defs) ? defs : [defs]) {
                if ((0, types_1.isArray)(def)) {
                    const [prefix, mixin] = def;
                    (0, object_1.extend)(mixin_defs, rename(prefix, mixin));
                    mixins.push([prefix, mixin]);
                }
                else {
                    const mixin = def;
                    (0, object_1.extend)(mixin_defs, mixin);
                    mixins.push(["", mixin]);
                }
            }
            this.define(mixin_defs);
            this.prototype._mixins = [...this.prototype._mixins, ...mixins];
        }
        static override(obj) {
            for (const [name, prop] of (0, object_1.entries)(obj)) {
                const default_value = this._fix_default(prop, name);
                const value = this.prototype._props[name];
                if (value == null)
                    throw new Error(`attempted to override nonexistent '${this.prototype.type}.${name}'`);
                const props = Object.assign({}, this.prototype._props);
                props[name] = Object.assign(Object.assign({}, value), { default_value });
                this.prototype._props = props;
            }
        }
        toString() {
            return `${this.type}(${this.id})`;
        }
        property(name) {
            const prop = this.properties[name];
            if (prop != null)
                return prop;
            else
                throw new Error(`unknown property ${this.type}.${name}`);
        }
        get attributes() {
            const attrs = {};
            for (const prop of this) {
                attrs[prop.attr] = prop.get_value();
            }
            return attrs;
        }
        [cloneable_1.clone](cloner) {
            const attrs = new Map();
            for (const prop of this) {
                if (prop.dirty) {
                    attrs.set(prop.attr, cloner.clone(prop.get_value()));
                }
            }
            return new this.constructor(attrs);
        }
        [eq_2.equals](that, cmp) {
            for (const p0 of this) {
                const p1 = that.property(p0.attr);
                if (!cmp.eq(p0.get_value(), p1.get_value()))
                    return false;
            }
            return true;
        }
        [pretty_1.pretty](printer) {
            const T = printer.token;
            const items = [];
            for (const prop of this) {
                if (prop.dirty) {
                    const value = prop.get_value();
                    items.push(`${prop.attr}${T(":")} ${printer.to_string(value)}`);
                }
            }
            const cls = this.constructor.__qualified__;
            return `${cls}${T("(")}${T("{")}${items.join(`${T(",")} `)}${T("}")}${T(")")}`;
        }
        [serializer_1.serialize](serializer) {
            const ref = this.ref();
            serializer.add_ref(this, ref);
            const struct = this.struct();
            for (const prop of this) {
                if (prop.syncable && (serializer.include_defaults || prop.dirty)) {
                    struct.attributes[prop.attr] = serializer.to_serializable(prop.get_value());
                }
            }
            serializer.add_def(this, struct);
            return ref;
        }
        finalize() {
            for (const prop of this) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                    continue;
                const value = prop.get_value(); // XXX: T -> any under instanceof
                if (value != null) {
                    const { transform, expr } = value;
                    if (transform != null)
                        this.connect(transform.change, () => this.transformchange.emit());
                    if (expr != null)
                        this.connect(expr.change, () => this.exprchange.emit());
                }
            }
            this.initialize();
        }
        initialize() { }
        connect_signals() { }
        disconnect_signals() {
            signaling_1.Signal.disconnectReceiver(this);
        }
        destroy() {
            this.disconnect_signals();
            this.destroyed.emit();
        }
        // Create a new model with exact attribute values to this one, but new identity.
        clone() {
            const cloner = new cloneable_1.Cloner();
            return cloner.clone(this);
        }
        changed_for(obj) {
            const changed = this._watchers.get(obj);
            this._watchers.set(obj, false);
            return changed !== null && changed !== void 0 ? changed : true;
        }
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        _setv(changes, options) {
            // Extract attributes and options.
            const check_eq = options.check_eq;
            const changed = [];
            const changing = this._changing;
            this._changing = true;
            for (const [prop, value] of changes) {
                if (check_eq === false || !(0, eq_1.is_equal)(prop.get_value(), value)) {
                    prop.set_value(value);
                    changed.push(prop);
                }
            }
            // Trigger all relevant attribute changes.
            if (changed.length > 0) {
                this._watchers = new WeakMap();
                this._pending = true;
            }
            for (const prop of changed) {
                prop.change.emit();
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (changing)
                return;
            if (!options.no_change) {
                while (this._pending) {
                    this._pending = false;
                    this.change.emit();
                }
            }
            this._pending = false;
            this._changing = false;
        }
        setv(changed_attrs, options = {}) {
            const changes = (0, object_1.entries)(changed_attrs);
            if (changes.length == 0)
                return;
            if (options.silent === true) {
                this._watchers = new WeakMap();
                for (const [attr, value] of changes) {
                    this.properties[attr].set_value(value);
                }
                return;
            }
            const changed = new Map();
            const previous = new Map();
            for (const [attr, value] of changes) {
                const prop = this.properties[attr];
                changed.set(prop, value);
                previous.set(prop, prop.get_value());
            }
            this._setv(changed, options);
            const { document } = this;
            if (document != null) {
                const changed = [];
                for (const [prop, value] of previous) {
                    changed.push([prop, value, prop.get_value()]);
                }
                for (const [, old_value, new_value] of changed) {
                    if (this._needs_invalidate(old_value, new_value)) {
                        document._invalidate_all_models();
                        break;
                    }
                }
                this._push_changes(changed, options);
            }
        }
        /** @deprecated */
        getv(name) {
            return this.property(name).get_value();
        }
        ref() {
            return { id: this.id };
        }
        struct() {
            const struct = {
                type: this.type,
                id: this.id,
                attributes: {},
            };
            if (this._subtype != null) {
                struct.subtype = this._subtype;
            }
            return struct;
        }
        // we only keep the subtype so we match Python;
        // only Python cares about this
        set_subtype(subtype) {
            this._subtype = subtype;
        }
        *[Symbol.iterator]() {
            yield* (0, object_1.values)(this.properties);
        }
        *syncable_properties() {
            for (const prop of this) {
                if (prop.syncable)
                    yield prop;
            }
        }
        /** @deprecated */
        serializable_attributes() {
            const attrs = {};
            for (const prop of this.syncable_properties()) {
                attrs[prop.attr] = prop.get_value();
            }
            return attrs;
        }
        // this is like _value_record_references but expects to find refs
        // instead of models, and takes a doc to look up the refs in
        static _json_record_references(doc, v, refs, options) {
            const { recursive } = options;
            if ((0, refs_1.is_ref)(v)) {
                const model = doc.get_model_by_id(v.id);
                if (model != null && !refs.has(model)) {
                    HasProps._value_record_references(model, refs, { recursive });
                }
            }
            else if ((0, types_1.isArray)(v)) {
                for (const elem of v)
                    HasProps._json_record_references(doc, elem, refs, { recursive });
            }
            else if ((0, types_1.isPlainObject)(v)) {
                for (const elem of (0, object_1.values)(v)) {
                    HasProps._json_record_references(doc, elem, refs, { recursive });
                }
            }
        }
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        static _value_record_references(v, refs, options) {
            const { recursive } = options;
            if (v instanceof HasProps) {
                if (!refs.has(v)) {
                    refs.add(v);
                    if (recursive) {
                        for (const prop of v.syncable_properties()) {
                            const value = prop.get_value();
                            HasProps._value_record_references(value, refs, { recursive });
                        }
                    }
                }
            }
            else if ((0, types_1.isArray)(v)) {
                for (const elem of v)
                    HasProps._value_record_references(elem, refs, { recursive });
            }
            else if ((0, types_1.isPlainObject)(v)) {
                for (const elem of (0, object_1.values)(v)) {
                    HasProps._value_record_references(elem, refs, { recursive });
                }
            }
        }
        references() {
            const refs = new Set();
            HasProps._value_record_references(this, refs, { recursive: true });
            return refs;
        }
        _doc_attached() { }
        _doc_detached() { }
        attach_document(doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null && this.document != doc)
                throw new Error("models must be owned by only a single document");
            this.document = doc;
            this._doc_attached();
        }
        detach_document() {
            // This should only be called by the Document implementation to unset the document field
            this._doc_detached();
            this.document = null;
        }
        _needs_invalidate(old_value, new_value) {
            const new_refs = new Set();
            HasProps._value_record_references(new_value, new_refs, { recursive: false });
            const old_refs = new Set();
            HasProps._value_record_references(old_value, old_refs, { recursive: false });
            for (const new_id of new_refs) {
                if (!old_refs.has(new_id))
                    return true;
            }
            for (const old_id of old_refs) {
                if (!new_refs.has(old_id))
                    return true;
            }
            return false;
        }
        _push_changes(changes, options = {}) {
            if (!this.is_syncable)
                return;
            const { document } = this;
            if (document == null)
                return;
            const { setter_id } = options;
            const events = [];
            for (const [prop, old_value, new_value] of changes) {
                if (prop.syncable)
                    events.push(new events_1.ModelChangedEvent(document, this, prop.attr, old_value, new_value, setter_id));
            }
            if (events.length != 0) {
                let event;
                if (events.length == 1)
                    [event] = events;
                else
                    event = new events_1.DocumentEventBatch(document, events, setter_id);
                document._trigger_on_change(event);
            }
        }
        on_change(properties, fn) {
            for (const property of (0, types_1.isArray)(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
    }
    exports.HasProps = HasProps;
    _a = HasProps;
    (() => {
        _a.prototype._props = {};
        _a.prototype._mixins = [];
    })();
},
/* core/signaling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Based on https://github.com/phosphorjs/phosphor/blob/master/packages/signaling/src/index.ts
    const defer_1 = require(16) /* ./util/defer */;
    const array_1 = require(9) /* ./util/array */;
    class Signal {
        constructor(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        connect(slot, context = null) {
            if (!receiversForSender.has(this.sender)) {
                receiversForSender.set(this.sender, []);
            }
            const receivers = receiversForSender.get(this.sender);
            if (find_connection(receivers, this, slot, context) != null) {
                return false;
            }
            const receiver = context !== null && context !== void 0 ? context : slot;
            if (!sendersForReceiver.has(receiver)) {
                sendersForReceiver.set(receiver, []);
            }
            const senders = sendersForReceiver.get(receiver);
            const connection = { signal: this, slot, context };
            receivers.push(connection);
            senders.push(connection);
            return true;
        }
        disconnect(slot, context = null) {
            const receivers = receiversForSender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            const connection = find_connection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            const receiver = context !== null && context !== void 0 ? context : slot;
            const senders = sendersForReceiver.get(receiver);
            connection.signal = null;
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
            return true;
        }
        emit(args) {
            var _a;
            const receivers = (_a = receiversForSender.get(this.sender)) !== null && _a !== void 0 ? _a : [];
            for (const { signal, slot, context } of receivers) {
                if (signal === this) {
                    slot.call(context, args, this.sender);
                }
            }
        }
    }
    exports.Signal = Signal;
    Signal.__name__ = "Signal";
    class Signal0 extends Signal {
        emit() {
            super.emit(undefined);
        }
    }
    exports.Signal0 = Signal0;
    Signal0.__name__ = "Signal0";
    (function (Signal) {
        function disconnect_between(sender, receiver) {
            const receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            const senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (const connection of senders) {
                if (connection.signal == null)
                    return;
                if (connection.signal.sender === sender)
                    connection.signal = null;
            }
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
        }
        Signal.disconnect_between = disconnect_between;
        function disconnect_sender(sender) {
            var _a;
            const receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            for (const connection of receivers) {
                if (connection.signal == null)
                    return;
                const receiver = (_a = connection.context) !== null && _a !== void 0 ? _a : connection.slot;
                connection.signal = null;
                schedule_cleanup(sendersForReceiver.get(receiver));
            }
            schedule_cleanup(receivers);
        }
        Signal.disconnect_sender = disconnect_sender;
        function disconnect_receiver(receiver, slot, except_senders) {
            const senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (const connection of senders) {
                if (connection.signal == null)
                    return;
                if (slot != null && connection.slot != slot)
                    continue;
                const sender = connection.signal.sender;
                if (except_senders != null && except_senders.has(sender))
                    continue;
                connection.signal = null;
                schedule_cleanup(receiversForSender.get(sender));
            }
            schedule_cleanup(senders);
        }
        Signal.disconnect_receiver = disconnect_receiver;
        function disconnect_all(obj) {
            const receivers = receiversForSender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                for (const connection of receivers) {
                    connection.signal = null;
                }
                schedule_cleanup(receivers);
            }
            const senders = sendersForReceiver.get(obj);
            if (senders != null && senders.length !== 0) {
                for (const connection of senders) {
                    connection.signal = null;
                }
                schedule_cleanup(senders);
            }
        }
        Signal.disconnect_all = disconnect_all;
        /** @deprecated */
        Signal.disconnectBetween = disconnect_between;
        /** @deprecated */
        Signal.disconnectSender = disconnect_sender;
        /** @deprecated */
        Signal.disconnectReceiver = disconnect_receiver;
        /** @deprecated */
        Signal.disconnectAll = disconnect_all;
    })(Signal || (exports.Signal = Signal = {}));
    function Signalable() {
        return class {
            connect(signal, slot) {
                return signal.connect(slot, this);
            }
            disconnect(signal, slot) {
                return signal.disconnect(slot, this);
            }
        };
    }
    exports.Signalable = Signalable;
    const receiversForSender = new WeakMap();
    const sendersForReceiver = new WeakMap();
    function find_connection(conns, signal, slot, context) {
        return (0, array_1.find)(conns, conn => conn.signal === signal && conn.slot === slot && conn.context === context);
    }
    const dirty_set = new Set();
    function schedule_cleanup(connections) {
        if (dirty_set.size === 0) {
            (async () => {
                await (0, defer_1.defer)();
                cleanup_dirty_set();
            })();
        }
        dirty_set.add(connections);
    }
    function cleanup_dirty_set() {
        for (const connections of dirty_set) {
            (0, array_1.remove_by)(connections, (connection) => connection.signal == null);
        }
        dirty_set.clear();
    }
},
/* core/util/defer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const channel = new MessageChannel();
    const tasks = new Map();
    channel.port1.onmessage = (event) => {
        const handle = event.data;
        const fn = tasks.get(handle);
        if (fn != null) {
            try {
                fn();
            }
            finally {
                tasks.delete(handle);
            }
        }
    };
    let counter = 1;
    function defer() {
        return new Promise((resolve) => {
            const handle = counter++;
            tasks.set(handle, resolve);
            channel.port2.postMessage(handle);
        });
    }
    exports.defer = defer;
    function wait(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    exports.wait = wait;
},
/* core/util/refs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./types */;
    const object_1 = require(13) /* ./object */;
    // Determine whether an object has the proper format of a Bokeh reference
    //
    // @param arg [Object] the object to test
    // @return [bool] whether the object is a reference
    //
    // @note this function does not check that the id and types are valid,
    //   only that the format is correct (all required keys are present)
    //
    function is_ref(arg) {
        if ((0, types_1.isPlainObject)(arg)) {
            const attrs = (0, object_1.keys)(arg);
            return attrs.length == 1 && attrs[0] == "id";
        }
        return false;
    }
    exports.is_ref = is_ref;
},
/* core/properties.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.YCoordinateSeqSeqSeqSpec = exports.XCoordinateSeqSeqSeqSpec = exports.YCoordinateSeqSpec = exports.XCoordinateSeqSpec = exports.YCoordinateSpec = exports.XCoordinateSpec = exports.CoordinateSeqSeqSeqSpec = exports.CoordinateSeqSpec = exports.CoordinateSpec = exports.BaseCoordinateSpec = exports.NumberUnitsSpec = exports.UnitsSpec = exports.DataSpec = exports.VectorSpec = exports.TextBaselineScalar = exports.TextAlignScalar = exports.FontStyleScalar = exports.FontSizeScalar = exports.FontScalar = exports.LineDashScalar = exports.LineCapScalar = exports.LineJoinScalar = exports.ArrayScalar = exports.NullStringScalar = exports.StringScalar = exports.NumberScalar = exports.ColorScalar = exports.AnyScalar = exports.ScalarSpec = exports.VerticalAlign = exports.UpdateMode = exports.TooltipAttachment = exports.TickLabelOrientation = exports.TextureRepetition = exports.TextBaseline = exports.TextAlign = exports.TapBehavior = exports.StepMode = exports.StartEnd = exports.SpatialUnits = exports.Sort = exports.SizingMode = exports.Side = exports.RoundingFunction = exports.ResetPolicy = exports.RenderMode = exports.RenderLevel = exports.RadiusDimension = exports.PointPolicy = exports.Place = void 0;
    exports.TextBaselineSpec = exports.TextAlignSpec = exports.FontStyleSpec = exports.FontSizeSpec = exports.FontSpec = exports.LineDashSpec = exports.LineCapSpec = exports.LineJoinSpec = exports.MarkerSpec = exports.ArraySpec = exports.NullStringSpec = exports.StringSpec = exports.AnySpec = exports.NDArraySpec = exports.ColorSpec = exports.ScreenSizeSpec = exports.NumberSpec = exports.IntSpec = exports.BooleanSpec = exports.NullDistanceSpec = exports.DistanceSpec = exports.AngleSpec = void 0;
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(15) /* ./signaling */;
    const logging_1 = require(19) /* ./logging */;
    const enums = (0, tslib_1.__importStar)(require(20) /* ./enums */);
    const types_1 = require(24) /* ./types */;
    const array_1 = require(9) /* ./util/array */;
    const arrayable_1 = require(12) /* ./util/arrayable */;
    const math_1 = require(10) /* ./util/math */;
    const color_1 = require(22) /* ./util/color */;
    const platform_1 = require(27) /* ./util/platform */;
    const types_2 = require(8) /* ./util/types */;
    const settings_1 = require(28) /* ./settings */;
    const ndarray_1 = require(29) /* ./util/ndarray */;
    const uniforms_1 = require(33) /* ./uniforms */;
    __esExport("Uniform", uniforms_1.Uniform);
    __esExport("UniformScalar", uniforms_1.UniformScalar);
    __esExport("UniformVector", uniforms_1.UniformVector);
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        }
        catch (_a) {
            return value.toString();
        }
    }
    function isSpec(obj) {
        return (0, types_2.isPlainObject)(obj) &&
            ((obj.value === undefined ? 0 : 1) +
                (obj.field === undefined ? 0 : 1) +
                (obj.expr === undefined ? 0 : 1) == 1); // garbage JS XOR
    }
    exports.isSpec = isSpec;
    class Property {
        constructor(obj, attr, kind, default_value, initial_value, options = {}) {
            var _a;
            this.obj = obj;
            this.attr = attr;
            this.kind = kind;
            this.default_value = default_value;
            this._dirty = false;
            this.change = new signaling_1.Signal0(this.obj, "change");
            this.internal = (_a = options.internal) !== null && _a !== void 0 ? _a : false;
            this.convert = options.convert;
            this.on_update = options.on_update;
            let attr_value;
            if (initial_value !== undefined) {
                attr_value = initial_value;
                this._dirty = true;
            }
            else {
                const value = this._default_override();
                if (value !== undefined)
                    attr_value = value;
                else if (default_value !== undefined)
                    attr_value = default_value(obj);
                else {
                    // XXX: temporary and super sketchy, but affects only "readonly" and a few internal properties
                    // console.warn(`${this.obj}.${this.attr} has no value nor default`)
                    this.spec = { value: null };
                    return;
                }
            }
            this._update(attr_value);
        }
        get is_value() {
            return this.spec.value !== undefined;
        }
        get syncable() {
            return !this.internal;
        }
        get_value() {
            return this.spec.value;
        }
        set_value(val) {
            this._update(val);
            this._dirty = true;
        }
        // abstract _intrinsic_default(): T
        _default_override() {
            return undefined;
        }
        get dirty() {
            return this._dirty;
        }
        //protected abstract _update(attr_value: T): void
        _update(attr_value) {
            var _a;
            this.validate(attr_value);
            if (this.convert != null) {
                const converted = this.convert(attr_value);
                if (converted !== undefined)
                    attr_value = converted;
            }
            this.spec = { value: attr_value };
            (_a = this.on_update) === null || _a === void 0 ? void 0 : _a.call(this, attr_value, this.obj);
        }
        toString() {
            /*${this.name}*/
            return `Prop(${this.obj}.${this.attr}, spec: ${valueToString(this.spec)})`;
        }
        // ----- customizable policies
        normalize(values) {
            return values;
        }
        validate(value) {
            if (!this.valid(value))
                throw new Error(`${this.obj}.${this.attr} given invalid value: ${valueToString(value)}`);
        }
        valid(value) {
            return this.kind.valid(value);
        }
        // ----- property accessors
        _value(do_spec_transform = true) {
            if (!this.is_value)
                throw new Error("attempted to retrieve property value for property without value specification");
            let ret = this.normalize([this.spec.value])[0];
            if (this.spec.transform != null && do_spec_transform)
                ret = this.spec.transform.compute(ret);
            return ret;
        }
    }
    exports.Property = Property;
    Property.__name__ = "Property";
    class PropertyAlias {
        constructor(attr) {
            this.attr = attr;
        }
    }
    exports.PropertyAlias = PropertyAlias;
    PropertyAlias.__name__ = "PropertyAlias";
    function Alias(attr) {
        return new PropertyAlias(attr);
    }
    exports.Alias = Alias;
    //
    // Primitive Properties
    //
    class PrimitiveProperty extends Property {
    }
    exports.PrimitiveProperty = PrimitiveProperty;
    PrimitiveProperty.__name__ = "PrimitiveProperty";
    /** @deprecated */
    class Any extends Property {
    }
    exports.Any = Any;
    Any.__name__ = "Any";
    /** @deprecated */
    class Array extends Property {
        valid(value) {
            return (0, types_2.isArray)(value) || (0, types_2.isTypedArray)(value);
        }
    }
    exports.Array = Array;
    Array.__name__ = "Array";
    /** @deprecated */
    class Boolean extends Property {
        valid(value) {
            return (0, types_2.isBoolean)(value);
        }
    }
    exports.Boolean = Boolean;
    Boolean.__name__ = "Boolean";
    /** @deprecated */
    class Color extends Property {
        valid(value) {
            return (0, color_1.is_Color)(value);
        }
    }
    exports.Color = Color;
    Color.__name__ = "Color";
    /** @deprecated */
    class Instance extends Property {
    }
    exports.Instance = Instance;
    Instance.__name__ = "Instance";
    /** @deprecated */
    class Number extends Property {
        valid(value) {
            return (0, types_2.isNumber)(value);
        }
    }
    exports.Number = Number;
    Number.__name__ = "Number";
    /** @deprecated */
    class Int extends Number {
        valid(value) {
            return (0, types_2.isNumber)(value) && (value | 0) == value;
        }
    }
    exports.Int = Int;
    Int.__name__ = "Int";
    /** @deprecated */
    class Angle extends Number {
    }
    exports.Angle = Angle;
    Angle.__name__ = "Angle";
    /** @deprecated */
    class Percent extends Number {
        valid(value) {
            return (0, types_2.isNumber)(value) && 0 <= value && value <= 1.0;
        }
    }
    exports.Percent = Percent;
    Percent.__name__ = "Percent";
    /** @deprecated */
    class String extends Property {
        valid(value) {
            return (0, types_2.isString)(value);
        }
    }
    exports.String = String;
    String.__name__ = "String";
    /** @deprecated */
    class NullString extends Property {
        valid(value) {
            return value === null || (0, types_2.isString)(value);
        }
    }
    exports.NullString = NullString;
    NullString.__name__ = "NullString";
    /** @deprecated */
    class FontSize extends String {
    }
    exports.FontSize = FontSize;
    FontSize.__name__ = "FontSize";
    /** @deprecated */
    class Font extends String {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        }
    }
    exports.Font = Font;
    Font.__name__ = "Font";
    //
    // Enum properties
    //
    /** @deprecated */
    class EnumProperty extends Property {
        valid(value) {
            return (0, types_2.isString)(value) && (0, array_1.includes)(this.enum_values, value);
        }
    }
    exports.EnumProperty = EnumProperty;
    EnumProperty.__name__ = "EnumProperty";
    /** @deprecated */
    function Enum(values) {
        return class extends EnumProperty {
            get enum_values() {
                return [...values];
            }
        };
    }
    exports.Enum = Enum;
    class Direction extends EnumProperty {
        get enum_values() {
            return [...enums.Direction];
        }
        normalize(values) {
            const result = new Uint8Array(values.length);
            for (let i = 0; i < values.length; i++) {
                switch (values[i]) {
                    case "clock":
                        result[i] = 0;
                        break;
                    case "anticlock":
                        result[i] = 1;
                        break;
                }
            }
            return result;
        }
    }
    exports.Direction = Direction;
    Direction.__name__ = "Direction";
    /** @deprecated */ exports.Anchor = Enum(enums.Anchor);
    /** @deprecated */ exports.AngleUnits = Enum(enums.AngleUnits);
    /** @deprecated */ exports.BoxOrigin = Enum(enums.BoxOrigin);
    /** @deprecated */ exports.ButtonType = Enum(enums.ButtonType);
    /** @deprecated */ exports.CalendarPosition = Enum(enums.CalendarPosition);
    /** @deprecated */ exports.Dimension = Enum(enums.Dimension);
    /** @deprecated */ exports.Dimensions = Enum(enums.Dimensions);
    /** @deprecated */ exports.Distribution = Enum(enums.Distribution);
    /** @deprecated */ exports.FontStyle = Enum(enums.FontStyle);
    /** @deprecated */ exports.HatchPatternType = Enum(enums.HatchPatternType);
    /** @deprecated */ exports.HTTPMethod = Enum(enums.HTTPMethod);
    /** @deprecated */ exports.HexTileOrientation = Enum(enums.HexTileOrientation);
    /** @deprecated */ exports.HoverMode = Enum(enums.HoverMode);
    /** @deprecated */ exports.LatLon = Enum(enums.LatLon);
    /** @deprecated */ exports.LegendClickPolicy = Enum(enums.LegendClickPolicy);
    /** @deprecated */ exports.LegendLocation = Enum(enums.LegendLocation);
    /** @deprecated */ exports.LineCap = Enum(enums.LineCap);
    /** @deprecated */ exports.LineJoin = Enum(enums.LineJoin);
    /** @deprecated */ exports.LinePolicy = Enum(enums.LinePolicy);
    /** @deprecated */ exports.Location = Enum(enums.Location);
    /** @deprecated */ exports.Logo = Enum(enums.Logo);
    /** @deprecated */ exports.MarkerType = Enum(enums.MarkerType);
    /** @deprecated */ exports.MutedPolicy = Enum(enums.MutedPolicy);
    /** @deprecated */ exports.Orientation = Enum(enums.Orientation);
    /** @deprecated */ exports.OutputBackend = Enum(enums.OutputBackend);
    /** @deprecated */ exports.PaddingUnits = Enum(enums.PaddingUnits);
    /** @deprecated */ exports.Place = Enum(enums.Place);
    /** @deprecated */ exports.PointPolicy = Enum(enums.PointPolicy);
    /** @deprecated */ exports.RadiusDimension = Enum(enums.RadiusDimension);
    /** @deprecated */ exports.RenderLevel = Enum(enums.RenderLevel);
    /** @deprecated */ exports.RenderMode = Enum(enums.RenderMode);
    /** @deprecated */ exports.ResetPolicy = Enum(enums.ResetPolicy);
    /** @deprecated */ exports.RoundingFunction = Enum(enums.RoundingFunction);
    /** @deprecated */ exports.Side = Enum(enums.Side);
    /** @deprecated */ exports.SizingMode = Enum(enums.SizingMode);
    /** @deprecated */ exports.Sort = Enum(enums.Sort);
    /** @deprecated */ exports.SpatialUnits = Enum(enums.SpatialUnits);
    /** @deprecated */ exports.StartEnd = Enum(enums.StartEnd);
    /** @deprecated */ exports.StepMode = Enum(enums.StepMode);
    /** @deprecated */ exports.TapBehavior = Enum(enums.TapBehavior);
    /** @deprecated */ exports.TextAlign = Enum(enums.TextAlign);
    /** @deprecated */ exports.TextBaseline = Enum(enums.TextBaseline);
    /** @deprecated */ exports.TextureRepetition = Enum(enums.TextureRepetition);
    /** @deprecated */ exports.TickLabelOrientation = Enum(enums.TickLabelOrientation);
    /** @deprecated */ exports.TooltipAttachment = Enum(enums.TooltipAttachment);
    /** @deprecated */ exports.UpdateMode = Enum(enums.UpdateMode);
    /** @deprecated */ exports.VerticalAlign = Enum(enums.VerticalAlign);
    //
    // DataSpec properties
    //
    class ScalarSpec extends Property {
        get_value() {
            // XXX: denormalize value for serialization, because bokeh doens't support scalar properties
            const { value, expr, transform } = this.spec;
            return (expr != null || transform != null ? this.spec : value);
            // XXX: allow obj.x = null; obj.x == null
            // return this.spec.value === null ? null : this.spec as any
        }
        _update(attr_value) {
            if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.value != null)
                this.validate(this.spec.value);
        }
        materialize(value) {
            return value;
        }
        scalar(value, n) {
            return new uniforms_1.UniformScalar(value, n);
        }
        uniform(source) {
            var _a;
            const { expr, value, transform } = this.spec;
            const n = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (expr != null) {
                let result = expr.compute(source);
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
            else {
                let result = value;
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
        }
    }
    exports.ScalarSpec = ScalarSpec;
    ScalarSpec.__name__ = "ScalarSpec";
    class AnyScalar extends ScalarSpec {
    }
    exports.AnyScalar = AnyScalar;
    AnyScalar.__name__ = "AnyScalar";
    class ColorScalar extends ScalarSpec {
    }
    exports.ColorScalar = ColorScalar;
    ColorScalar.__name__ = "ColorScalar";
    class NumberScalar extends ScalarSpec {
    }
    exports.NumberScalar = NumberScalar;
    NumberScalar.__name__ = "NumberScalar";
    class StringScalar extends ScalarSpec {
    }
    exports.StringScalar = StringScalar;
    StringScalar.__name__ = "StringScalar";
    class NullStringScalar extends ScalarSpec {
    }
    exports.NullStringScalar = NullStringScalar;
    NullStringScalar.__name__ = "NullStringScalar";
    class ArrayScalar extends ScalarSpec {
    }
    exports.ArrayScalar = ArrayScalar;
    ArrayScalar.__name__ = "ArrayScalar";
    class LineJoinScalar extends ScalarSpec {
    }
    exports.LineJoinScalar = LineJoinScalar;
    LineJoinScalar.__name__ = "LineJoinScalar";
    class LineCapScalar extends ScalarSpec {
    }
    exports.LineCapScalar = LineCapScalar;
    LineCapScalar.__name__ = "LineCapScalar";
    class LineDashScalar extends ScalarSpec {
    }
    exports.LineDashScalar = LineDashScalar;
    LineDashScalar.__name__ = "LineDashScalar";
    class FontScalar extends ScalarSpec {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        }
    }
    exports.FontScalar = FontScalar;
    FontScalar.__name__ = "FontScalar";
    class FontSizeScalar extends ScalarSpec {
    }
    exports.FontSizeScalar = FontSizeScalar;
    FontSizeScalar.__name__ = "FontSizeScalar";
    class FontStyleScalar extends ScalarSpec {
    }
    exports.FontStyleScalar = FontStyleScalar;
    FontStyleScalar.__name__ = "FontStyleScalar";
    class TextAlignScalar extends ScalarSpec {
    }
    exports.TextAlignScalar = TextAlignScalar;
    TextAlignScalar.__name__ = "TextAlignScalar";
    class TextBaselineScalar extends ScalarSpec {
    }
    exports.TextBaselineScalar = TextBaselineScalar;
    TextBaselineScalar.__name__ = "TextBaselineScalar";
    class VectorSpec extends Property {
        get_value() {
            // XXX: allow obj.x = null; obj.x == null
            return this.spec.value === null ? null : this.spec;
        }
        _update(attr_value) {
            if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.value != null)
                this.validate(this.spec.value);
        }
        materialize(value) {
            return value;
        }
        v_materialize(values) {
            return values;
        }
        scalar(value, n) {
            return new uniforms_1.UniformScalar(value, n);
        }
        vector(values) {
            return new uniforms_1.UniformVector(values);
        }
        uniform(source) {
            var _a;
            const { field, expr, value, transform } = this.spec;
            const n = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (field != null) {
                let array = source.get_column(field);
                if (array != null) {
                    if (transform != null)
                        array = transform.v_compute(array);
                    array = this.v_materialize(array);
                    return this.vector(array);
                }
                else {
                    logging_1.logger.warn(`attempted to retrieve property array for nonexistent field '${field}'`);
                    return this.scalar(null, n);
                }
            }
            else if (expr != null) {
                let array = expr.v_compute(source);
                if (transform != null)
                    array = transform.v_compute(array);
                array = this.v_materialize(array);
                return this.vector(array);
            }
            else {
                let result = value;
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
        }
        array(source) {
            var _a;
            let array;
            const length = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (this.spec.field != null) {
                const column = source.get_column(this.spec.field);
                if (column != null)
                    array = this.normalize(column);
                else {
                    logging_1.logger.warn(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`);
                    const missing = new Float64Array(length);
                    missing.fill(NaN);
                    array = missing;
                }
            }
            else if (this.spec.expr != null) {
                array = this.normalize(this.spec.expr.v_compute(source));
            }
            else {
                const value = this._value(false); // don't apply any spec transform
                if ((0, types_2.isNumber)(value)) {
                    const values = new Float64Array(length);
                    values.fill(value);
                    array = values;
                }
                else
                    array = (0, array_1.repeat)(value, length);
            }
            if (this.spec.transform != null)
                array = this.spec.transform.v_compute(array);
            return array;
        }
    }
    exports.VectorSpec = VectorSpec;
    VectorSpec.__name__ = "VectorSpec";
    class DataSpec extends VectorSpec {
    }
    exports.DataSpec = DataSpec;
    DataSpec.__name__ = "DataSpec";
    class UnitsSpec extends VectorSpec {
        _update(attr_value) {
            super._update(attr_value);
            const { units } = this.spec;
            if (units != null && !(0, array_1.includes)(this.valid_units, units)) {
                throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${units}`);
            }
        }
        get units() {
            var _a;
            return (_a = this.spec.units) !== null && _a !== void 0 ? _a : this.default_units;
        }
        set units(units) {
            if (units != this.default_units)
                this.spec.units = units;
            else
                delete this.spec.units;
        }
    }
    exports.UnitsSpec = UnitsSpec;
    UnitsSpec.__name__ = "UnitsSpec";
    class NumberUnitsSpec extends UnitsSpec {
        array(source) {
            return new Float64Array(super.array(source));
        }
    }
    exports.NumberUnitsSpec = NumberUnitsSpec;
    NumberUnitsSpec.__name__ = "NumberUnitsSpec";
    class BaseCoordinateSpec extends DataSpec {
    }
    exports.BaseCoordinateSpec = BaseCoordinateSpec;
    BaseCoordinateSpec.__name__ = "BaseCoordinateSpec";
    class CoordinateSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSpec = CoordinateSpec;
    CoordinateSpec.__name__ = "CoordinateSpec";
    class CoordinateSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSpec = CoordinateSeqSpec;
    CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
    class CoordinateSeqSeqSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSeqSeqSpec = CoordinateSeqSeqSeqSpec;
    CoordinateSeqSeqSeqSpec.__name__ = "CoordinateSeqSeqSeqSpec";
    class XCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSpec = XCoordinateSpec;
    XCoordinateSpec.__name__ = "XCoordinateSpec";
    class YCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSpec = YCoordinateSpec;
    YCoordinateSpec.__name__ = "YCoordinateSpec";
    class XCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSpec = XCoordinateSeqSpec;
    XCoordinateSeqSpec.__name__ = "XCoordinateSeqSpec";
    class YCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSpec = YCoordinateSeqSpec;
    YCoordinateSeqSpec.__name__ = "YCoordinateSeqSpec";
    class XCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSeqSeqSpec = XCoordinateSeqSeqSeqSpec;
    XCoordinateSeqSeqSeqSpec.__name__ = "XCoordinateSeqSeqSeqSpec";
    class YCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSeqSeqSpec = YCoordinateSeqSeqSeqSpec;
    YCoordinateSeqSeqSeqSpec.__name__ = "YCoordinateSeqSeqSeqSpec";
    class AngleSpec extends NumberUnitsSpec {
        get default_units() { return "rad"; }
        get valid_units() { return [...enums.AngleUnits]; }
        materialize(value) {
            const coeff = -(0, math_1.to_radians_coeff)(this.units);
            return value * coeff;
        }
        v_materialize(values) {
            const coeff = -(0, math_1.to_radians_coeff)(this.units);
            const result = new Float32Array(values.length);
            (0, arrayable_1.mul)(values, coeff, result); // TODO: in-place?
            return result;
        }
        array(_source) {
            throw new Error("not supported");
        }
    }
    exports.AngleSpec = AngleSpec;
    AngleSpec.__name__ = "AngleSpec";
    class DistanceSpec extends NumberUnitsSpec {
        get default_units() { return "data"; }
        get valid_units() { return [...enums.SpatialUnits]; }
    }
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.__name__ = "DistanceSpec";
    class NullDistanceSpec extends DistanceSpec {
        materialize(value) {
            return value !== null && value !== void 0 ? value : NaN;
        }
    }
    exports.NullDistanceSpec = NullDistanceSpec;
    NullDistanceSpec.__name__ = "NullDistanceSpec";
    class BooleanSpec extends DataSpec {
        v_materialize(values) {
            return new Uint8Array(values);
        }
        array(source) {
            return new Uint8Array(super.array(source));
        }
    }
    exports.BooleanSpec = BooleanSpec;
    BooleanSpec.__name__ = "BooleanSpec";
    class IntSpec extends DataSpec {
        v_materialize(values) {
            return (0, types_2.isTypedArray)(values) ? values : new Int32Array(values);
        }
        array(source) {
            return new Int32Array(super.array(source));
        }
    }
    exports.IntSpec = IntSpec;
    IntSpec.__name__ = "IntSpec";
    class NumberSpec extends DataSpec {
        v_materialize(values) {
            return (0, types_2.isTypedArray)(values) ? values : new Float64Array(values);
        }
        array(source) {
            return new Float64Array(super.array(source));
        }
    }
    exports.NumberSpec = NumberSpec;
    NumberSpec.__name__ = "NumberSpec";
    class ScreenSizeSpec extends NumberSpec {
        valid(value) {
            return (0, types_2.isNumber)(value) && value >= 0;
        }
    }
    exports.ScreenSizeSpec = ScreenSizeSpec;
    ScreenSizeSpec.__name__ = "ScreenSizeSpec";
    class ColorSpec extends DataSpec {
        materialize(color) {
            return (0, color_1.encode_rgba)((0, color_1.color2rgba)(color));
        }
        v_materialize(colors) {
            if ((0, ndarray_1.is_NDArray)(colors)) {
                if (colors.dtype == "uint32" && colors.dimension == 1) {
                    return (0, platform_1.to_big_endian)(colors);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 1) {
                    const [n] = colors.shape;
                    const array = new types_1.RGBAArray(4 * n);
                    let j = 0;
                    for (const gray of colors) {
                        array[j++] = gray;
                        array[j++] = gray;
                        array[j++] = gray;
                        array[j++] = 255;
                    }
                    return new types_1.ColorArray(array.buffer);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 2) {
                    const [n, d] = colors.shape;
                    if (d == 4) {
                        return new types_1.ColorArray(colors.buffer);
                    }
                    else if (d == 3) {
                        const array = new types_1.RGBAArray(4 * n);
                        for (let i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
                else if ((colors.dtype == "float32" || colors.dtype == "float64") && colors.dimension == 2) {
                    const [n, d] = colors.shape;
                    if (d == 3 || d == 4) {
                        const array = new types_1.RGBAArray(4 * n);
                        for (let i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = (d == 3 ? 1 : colors[i++]) * 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
            }
            else {
                const n = colors.length;
                const array = new types_1.RGBAArray(4 * n);
                let j = 0;
                for (const color of colors) {
                    const [r, g, b, a] = (0, color_1.color2rgba)(color);
                    array[j++] = r;
                    array[j++] = g;
                    array[j++] = b;
                    array[j++] = a;
                }
                return new types_1.ColorArray(array.buffer);
            }
            throw new Error("invalid color array");
        }
        vector(values) {
            return new uniforms_1.ColorUniformVector(values);
        }
    }
    exports.ColorSpec = ColorSpec;
    ColorSpec.__name__ = "ColorSpec";
    class NDArraySpec extends DataSpec {
    }
    exports.NDArraySpec = NDArraySpec;
    NDArraySpec.__name__ = "NDArraySpec";
    class AnySpec extends DataSpec {
    }
    exports.AnySpec = AnySpec;
    AnySpec.__name__ = "AnySpec";
    class StringSpec extends DataSpec {
    }
    exports.StringSpec = StringSpec;
    StringSpec.__name__ = "StringSpec";
    class NullStringSpec extends DataSpec {
    }
    exports.NullStringSpec = NullStringSpec;
    NullStringSpec.__name__ = "NullStringSpec";
    class ArraySpec extends DataSpec {
    }
    exports.ArraySpec = ArraySpec;
    ArraySpec.__name__ = "ArraySpec";
    class MarkerSpec extends DataSpec {
    }
    exports.MarkerSpec = MarkerSpec;
    MarkerSpec.__name__ = "MarkerSpec";
    class LineJoinSpec extends DataSpec {
    }
    exports.LineJoinSpec = LineJoinSpec;
    LineJoinSpec.__name__ = "LineJoinSpec";
    class LineCapSpec extends DataSpec {
    }
    exports.LineCapSpec = LineCapSpec;
    LineCapSpec.__name__ = "LineCapSpec";
    class LineDashSpec extends DataSpec {
    }
    exports.LineDashSpec = LineDashSpec;
    LineDashSpec.__name__ = "LineDashSpec";
    class FontSpec extends DataSpec {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        }
    }
    exports.FontSpec = FontSpec;
    FontSpec.__name__ = "FontSpec";
    class FontSizeSpec extends DataSpec {
    }
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.__name__ = "FontSizeSpec";
    class FontStyleSpec extends DataSpec {
    }
    exports.FontStyleSpec = FontStyleSpec;
    FontStyleSpec.__name__ = "FontStyleSpec";
    class TextAlignSpec extends DataSpec {
    }
    exports.TextAlignSpec = TextAlignSpec;
    TextAlignSpec.__name__ = "TextAlignSpec";
    class TextBaselineSpec extends DataSpec {
    }
    exports.TextBaselineSpec = TextBaselineSpec;
    TextBaselineSpec.__name__ = "TextBaselineSpec";
},
/* core/logging.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // This is based on https://github.com/pimterry/loglevel
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(13) /* ./util/object */;
    const _loggers = {};
    class LogLevel {
        constructor(name, level) {
            this.name = name;
            this.level = level;
        }
    }
    exports.LogLevel = LogLevel;
    LogLevel.__name__ = "LogLevel";
    class Logger {
        constructor(name, level = Logger.INFO) {
            this._name = name;
            this.set_level(level);
        }
        static get levels() {
            return Object.keys(Logger.log_levels);
        }
        static get(name, level = Logger.INFO) {
            if (name.length > 0) {
                let logger = _loggers[name];
                if (logger == null)
                    _loggers[name] = logger = new Logger(name, level);
                return logger;
            }
            else
                throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
        }
        get level() {
            return this.get_level();
        }
        get_level() {
            return this._log_level;
        }
        set_level(log_level) {
            if (log_level instanceof LogLevel)
                this._log_level = log_level;
            else if ((0, types_1.isString)(log_level) && Logger.log_levels[log_level] != null)
                this._log_level = Logger.log_levels[log_level];
            else
                throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
            const logger_name = `[${this._name}]`;
            for (const [name, log_level] of (0, object_1.entries)(Logger.log_levels)) {
                if (log_level.level < this._log_level.level || this._log_level.level === Logger.OFF.level)
                    this[name] = function () { };
                else
                    this[name] = _method_factory(name, logger_name);
            }
        }
        trace(..._args) { }
        debug(..._args) { }
        info(..._args) { }
        warn(..._args) { }
        error(..._args) { }
    }
    exports.Logger = Logger;
    Logger.__name__ = "Logger";
    Logger.TRACE = new LogLevel("trace", 0);
    Logger.DEBUG = new LogLevel("debug", 1);
    Logger.INFO = new LogLevel("info", 2);
    Logger.WARN = new LogLevel("warn", 6);
    Logger.ERROR = new LogLevel("error", 7);
    Logger.FATAL = new LogLevel("fatal", 8);
    Logger.OFF = new LogLevel("off", 9);
    Logger.log_levels = {
        trace: Logger.TRACE,
        debug: Logger.DEBUG,
        info: Logger.INFO,
        warn: Logger.WARN,
        error: Logger.ERROR,
        fatal: Logger.FATAL,
        off: Logger.OFF,
    };
    function _method_factory(method_name, logger_name) {
        if (console[method_name] != null)
            return console[method_name].bind(console, logger_name);
        else if (console.log != null)
            return console.log.bind(console, logger_name);
        else
            return function () { };
    }
    exports.logger = Logger.get("bokeh");
    function set_log_level(level) {
        const previous_level = exports.logger.level;
        if ((0, types_1.isString)(level) && Logger.log_levels[level] == null) {
            console.log(`[bokeh] unrecognized logging level '${level}' passed to Bokeh.set_log_level(), ignoring`);
            console.log(`[bokeh] valid log levels are: ${Logger.levels.join(", ")}`);
        }
        else {
            console.log(`[bokeh] setting log level to: '${(0, types_1.isString)(level) ? level : level.level}'`);
            exports.logger.set_level(level);
        }
        return previous_level;
    }
    exports.set_log_level = set_log_level;
    function with_log_level(level, fn) {
        const original = set_log_level(level);
        try {
            fn();
        }
        finally {
            set_log_level(original);
        }
    }
    exports.with_log_level = with_log_level;
},
/* core/enums.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.VerticalAlign = void 0;
    const kinds_1 = require(21) /* ./kinds */;
    exports.Align = (0, kinds_1.Enum)("start", "center", "end");
    exports.Anchor = (0, kinds_1.Enum)("top_left", "top_center", "top_right", "center_left", "center_center", "center_right", "bottom_left", "bottom_center", "bottom_right", "top", "left", "center", "right", "bottom");
    exports.AngleUnits = (0, kinds_1.Enum)("deg", "rad", "grad", "turn");
    exports.BoxOrigin = (0, kinds_1.Enum)("corner", "center");
    exports.ButtonType = (0, kinds_1.Enum)("default", "primary", "success", "warning", "danger", "light");
    exports.CalendarPosition = (0, kinds_1.Enum)("auto", "above", "below");
    exports.Dimension = (0, kinds_1.Enum)("width", "height");
    exports.Dimensions = (0, kinds_1.Enum)("width", "height", "both");
    exports.Direction = (0, kinds_1.Enum)("clock", "anticlock");
    exports.Distribution = (0, kinds_1.Enum)("uniform", "normal");
    exports.FontStyle = (0, kinds_1.Enum)("normal", "italic", "bold", "bold italic");
    exports.HatchPatternType = (0, kinds_1.Enum)("blank", "dot", "ring", "horizontal_line", "vertical_line", "cross", "horizontal_dash", "vertical_dash", "spiral", "right_diagonal_line", "left_diagonal_line", "diagonal_cross", "right_diagonal_dash", "left_diagonal_dash", "horizontal_wave", "vertical_wave", "criss_cross", " ", ".", "o", "-", "|", "+", '"', ":", "@", "/", "\\", "x", ",", "`", "v", ">", "*");
    exports.HTTPMethod = (0, kinds_1.Enum)("POST", "GET");
    exports.HexTileOrientation = (0, kinds_1.Enum)("pointytop", "flattop");
    exports.HoverMode = (0, kinds_1.Enum)("mouse", "hline", "vline");
    exports.LatLon = (0, kinds_1.Enum)("lat", "lon");
    exports.LegendClickPolicy = (0, kinds_1.Enum)("none", "hide", "mute");
    exports.LegendLocation = exports.Anchor;
    exports.LineCap = (0, kinds_1.Enum)("butt", "round", "square");
    exports.LineJoin = (0, kinds_1.Enum)("miter", "round", "bevel");
    exports.LineDash = (0, kinds_1.Enum)("solid", "dashed", "dotted", "dotdash", "dashdot");
    exports.LinePolicy = (0, kinds_1.Enum)("prev", "next", "nearest", "interp", "none");
    exports.Location = (0, kinds_1.Enum)("above", "below", "left", "right");
    exports.Logo = (0, kinds_1.Enum)("normal", "grey");
    exports.MarkerType = (0, kinds_1.Enum)("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "star", "star_dot", "triangle", "triangle_dot", "triangle_pin", "x", "y");
    exports.MutedPolicy = (0, kinds_1.Enum)("show", "ignore");
    exports.Orientation = (0, kinds_1.Enum)("vertical", "horizontal");
    exports.OutputBackend = (0, kinds_1.Enum)("canvas", "svg", "webgl");
    exports.PaddingUnits = (0, kinds_1.Enum)("percent", "absolute");
    exports.Place = (0, kinds_1.Enum)("above", "below", "left", "right", "center");
    exports.PointPolicy = (0, kinds_1.Enum)("snap_to_data", "follow_mouse", "none");
    exports.RadiusDimension = (0, kinds_1.Enum)("x", "y", "max", "min");
    exports.RenderLevel = (0, kinds_1.Enum)("image", "underlay", "glyph", "guide", "annotation", "overlay");
    exports.RenderMode = (0, kinds_1.Enum)("canvas", "css");
    exports.ResetPolicy = (0, kinds_1.Enum)("standard", "event_only");
    exports.RoundingFunction = (0, kinds_1.Enum)("round", "nearest", "floor", "rounddown", "ceil", "roundup");
    exports.SelectionMode = (0, kinds_1.Enum)("replace", "append", "intersect", "subtract");
    exports.Side = (0, kinds_1.Enum)("above", "below", "left", "right");
    exports.SizingMode = (0, kinds_1.Enum)("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed");
    exports.Sort = (0, kinds_1.Enum)("ascending", "descending");
    exports.SpatialUnits = (0, kinds_1.Enum)("screen", "data");
    exports.StartEnd = (0, kinds_1.Enum)("start", "end");
    exports.StepMode = (0, kinds_1.Enum)("after", "before", "center");
    exports.TapBehavior = (0, kinds_1.Enum)("select", "inspect");
    exports.TextAlign = (0, kinds_1.Enum)("left", "right", "center");
    exports.TextBaseline = (0, kinds_1.Enum)("top", "middle", "bottom", "alphabetic", "hanging", "ideographic");
    exports.TextureRepetition = (0, kinds_1.Enum)("repeat", "repeat_x", "repeat_y", "no_repeat");
    exports.TickLabelOrientation = (0, kinds_1.Enum)("vertical", "horizontal", "parallel", "normal");
    exports.TooltipAttachment = (0, kinds_1.Enum)("horizontal", "vertical", "left", "right", "above", "below");
    exports.UpdateMode = (0, kinds_1.Enum)("replace", "append");
    exports.VerticalAlign = (0, kinds_1.Enum)("top", "middle", "bottom");
},
/* core/kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const tp = (0, tslib_1.__importStar)(require(8) /* ./util/types */);
    const color_1 = require(22) /* ./util/color */;
    const object_1 = require(13) /* ./util/object */;
    const ESMap = window.Map;
    const { hasOwnProperty } = Object.prototype;
    class Kind {
    }
    exports.Kind = Kind;
    Kind.__name__ = "Kind";
    (function (Kinds) {
        class Any extends Kind {
            valid(_value) {
                return true;
            }
        }
        Any.__name__ = "Any";
        Kinds.Any = Any;
        class Unknown extends Kind {
            valid(_value) {
                return true;
            }
        }
        Unknown.__name__ = "Unknown";
        Kinds.Unknown = Unknown;
        class Boolean extends Kind {
            valid(value) {
                return tp.isBoolean(value);
            }
        }
        Boolean.__name__ = "Boolean";
        Kinds.Boolean = Boolean;
        class Ref extends Kind {
            constructor(obj_type) {
                super();
                this.obj_type = obj_type;
            }
            valid(_value) {
                // XXX: disable validation for now, because object graph initialization depends on this.
                // return value instanceof this.obj_type
                return true;
            }
        }
        Ref.__name__ = "Ref";
        Kinds.Ref = Ref;
        class AnyRef extends Kind {
            valid(_value) {
                // XXX: disable validation for now, because object graph initialization depends on this.
                // return tp.isObject(value)
                return true;
            }
        }
        AnyRef.__name__ = "AnyRef";
        Kinds.AnyRef = AnyRef;
        class Number extends Kind {
            valid(value) {
                return tp.isNumber(value);
            }
        }
        Number.__name__ = "Number";
        Kinds.Number = Number;
        class Int extends Number {
            valid(value) {
                return super.valid(value) && tp.isInteger(value);
            }
        }
        Int.__name__ = "Int";
        Kinds.Int = Int;
        class Percent extends Number {
            valid(value) {
                return super.valid(value) && 0 <= value && value <= 1;
            }
        }
        Percent.__name__ = "Percent";
        Kinds.Percent = Percent;
        class Or extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                return this.types.some((type) => type.valid(value));
            }
        }
        Or.__name__ = "Or";
        Kinds.Or = Or;
        class Tuple extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                if (!tp.isArray(value))
                    return false;
                for (let i = 0; i < this.types.length; i++) {
                    const type = this.types[i];
                    const item = value[i];
                    if (!type.valid(item))
                        return false;
                }
                return true;
            }
        }
        Tuple.__name__ = "Tuple";
        Kinds.Tuple = Tuple;
        class Struct extends Kind {
            constructor(struct_type) {
                super();
                this.struct_type = struct_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value))
                    return false;
                const { struct_type } = this;
                if ((0, object_1.size)(struct_type) != (0, object_1.size)(value))
                    return false;
                for (const key in struct_type) {
                    if (hasOwnProperty.call(struct_type, key)) {
                        if (!hasOwnProperty.call(value, key))
                            return false;
                        const item_type = struct_type[key];
                        const item = value[key];
                        if (!item_type.valid(item))
                            return false;
                    }
                }
                return true;
            }
        }
        Struct.__name__ = "Struct";
        Kinds.Struct = Struct;
        class Arrayable extends Kind {
            valid(value) {
                return tp.isArray(value) || tp.isTypedArray(value); // TODO: too specific
            }
        }
        Arrayable.__name__ = "Arrayable";
        Kinds.Arrayable = Arrayable;
        class Array extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isArray(value) && value.every((item) => this.item_type.valid(item));
            }
        }
        Array.__name__ = "Array";
        Kinds.Array = Array;
        class Null extends Kind {
            valid(value) {
                return value === null;
            }
        }
        Null.__name__ = "Null";
        Kinds.Null = Null;
        class Nullable extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === null || this.base_type.valid(value);
            }
        }
        Nullable.__name__ = "Nullable";
        Kinds.Nullable = Nullable;
        class Opt extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === undefined || this.base_type.valid(value);
            }
        }
        Opt.__name__ = "Opt";
        Kinds.Opt = Opt;
        class String extends Kind {
            valid(value) {
                return tp.isString(value);
            }
        }
        String.__name__ = "String";
        Kinds.String = String;
        class Enum extends Kind {
            constructor(values) {
                super();
                this.values = new Set(values);
            }
            valid(value) {
                return this.values.has(value);
            }
            *[Symbol.iterator]() {
                yield* this.values;
            }
        }
        Enum.__name__ = "Enum";
        Kinds.Enum = Enum;
        class Dict extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value))
                    return false;
                for (const key in value) {
                    if (hasOwnProperty.call(value, key)) {
                        const item = value[key];
                        if (!this.item_type.valid(item))
                            return false;
                    }
                }
                return true;
            }
        }
        Dict.__name__ = "Dict";
        Kinds.Dict = Dict;
        class Map extends Kind {
            constructor(key_type, item_type) {
                super();
                this.key_type = key_type;
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESMap))
                    return false;
                for (const [key, item] of value.entries()) {
                    if (!(this.key_type.valid(key) && this.item_type.valid(item)))
                        return false;
                }
                return true;
            }
        }
        Map.__name__ = "Map";
        Kinds.Map = Map;
        class Color extends Kind {
            valid(value) {
                return (0, color_1.is_Color)(value);
            }
        }
        Color.__name__ = "Color";
        Kinds.Color = Color;
        class Function extends Kind {
            valid(value) {
                return tp.isFunction(value);
            }
        }
        Function.__name__ = "Function";
        Kinds.Function = Function;
    })(exports.Kinds || (exports.Kinds = {}));
    exports.Any = new exports.Kinds.Any();
    exports.Unknown = new exports.Kinds.Unknown();
    exports.Boolean = new exports.Kinds.Boolean();
    exports.Number = new exports.Kinds.Number();
    exports.Int = new exports.Kinds.Int();
    exports.String = new exports.Kinds.String();
    exports.Null = new exports.Kinds.Null();
    const Nullable = (base_type) => new exports.Kinds.Nullable(base_type);
    exports.Nullable = Nullable;
    const Opt = (base_type) => new exports.Kinds.Opt(base_type);
    exports.Opt = Opt;
    const Or = (...types) => new exports.Kinds.Or(types);
    exports.Or = Or;
    const Tuple = (...types) => new exports.Kinds.Tuple(types);
    exports.Tuple = Tuple;
    const Struct = (struct_type) => new exports.Kinds.Struct(struct_type);
    exports.Struct = Struct;
    exports.Arrayable = new exports.Kinds.Arrayable();
    const Array = (item_type) => new exports.Kinds.Array(item_type);
    exports.Array = Array;
    const Dict = (item_type) => new exports.Kinds.Dict(item_type);
    exports.Dict = Dict;
    const Map = (key_type, item_type) => new exports.Kinds.Map(key_type, item_type);
    exports.Map = Map;
    const Enum = (...values) => new exports.Kinds.Enum(values);
    exports.Enum = Enum;
    const Ref = (obj_type) => new exports.Kinds.Ref(obj_type);
    exports.Ref = Ref;
    const AnyRef = () => new exports.Kinds.AnyRef();
    exports.AnyRef = AnyRef;
    const Function = () => new exports.Kinds.Function();
    exports.Function = Function;
    exports.Percent = new exports.Kinds.Percent();
    exports.Alpha = exports.Percent;
    exports.Color = new exports.Kinds.Color();
    exports.Auto = (0, exports.Enum)("auto");
    exports.FontSize = exports.String;
    exports.Font = exports.String;
    exports.Angle = exports.Number;
},
/* core/util/color.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const svg_colors_1 = require(23) /* ./svg_colors */;
    const math_1 = require(10) /* ./math */;
    const types_1 = require(8) /* ./types */;
    const { round } = Math;
    function byte(v) {
        return (0, math_1.clamp)(round(v), 0, 255);
    }
    function transparent() {
        return [0, 0, 0, 0];
    }
    exports.transparent = transparent;
    function encode_rgba([r, g, b, a]) {
        return r << 24 | g << 16 | b << 8 | a;
    }
    exports.encode_rgba = encode_rgba;
    function decode_rgba(rgba) {
        const r = (rgba >> 24) & 0xff;
        const g = (rgba >> 16) & 0xff;
        const b = (rgba >> 8) & 0xff;
        const a = rgba & 0xff;
        return [r, g, b, a];
    }
    exports.decode_rgba = decode_rgba;
    function compose_alpha(color, alpha) {
        if ((color & 0xff) == 255)
            return (color & 0xffffff00) | byte(alpha * 255);
        else
            return color;
    }
    exports.compose_alpha = compose_alpha;
    function color2rgba(color, alpha) {
        var _a;
        let r, g, b, a;
        if (color == null)
            [r, g, b, a] = transparent();
        else if ((0, types_1.isInteger)(color))
            [r, g, b, a] = decode_rgba(color);
        else if ((0, types_1.isString)(color))
            [r, g, b, a] = (_a = css4_parse(color)) !== null && _a !== void 0 ? _a : transparent();
        else {
            [r, g, b, a = 1.0] = color;
            a = byte(a * 255);
        }
        if (a == 255 && alpha != null)
            a = byte(alpha * 255);
        return [r, g, b, a];
    }
    exports.color2rgba = color2rgba;
    const _hex_table = {
        0: "0", 1: "1", 2: "2", 3: "3", 4: "4", 5: "5", 6: "6", 7: "7", 8: "8", 9: "9",
        10: "a", 11: "b", 12: "c", 13: "d", 14: "e", 15: "f",
    };
    function hex(v) {
        return _hex_table[v >> 4] + _hex_table[v & 0xf];
    }
    function color2css(color, alpha) {
        const [r, g, b, a] = color2rgba(color, alpha);
        return `rgba(${r}, ${g}, ${b}, ${a / 255})`;
    }
    exports.color2css = color2css;
    function color2hex(color, alpha) {
        const [r, g, b, a] = color2rgba(color, alpha);
        const rgb = `#${hex(r)}${hex(g)}${hex(b)}`;
        return a == 255 ? rgb : `${rgb}${hex(a)}`;
    }
    exports.color2hex = color2hex;
    function color2hexrgb(color) {
        const [r, g, b] = color2rgba(color);
        return `#${hex(r)}${hex(g)}${hex(b)}`;
    }
    exports.color2hexrgb = color2hexrgb;
    /*
    let _last_color = "transparent"
    let _last_alpha = 1.0
    let _last_rgba = transparent()
    
    export function _color2rgba(color: string | null, alpha: number = 1.0): RGBA {
      if (color == _last_color && alpha == _last_alpha)
        return [..._last_rgba]
    
      const [r, g, b, a] = parsed
      const rgba: RGBA = [r, g, b, a == 255 ? byte(alpha*255) : a]
      _last_color = color
      _last_alpha = alpha
      _last_rgba = rgba
      return rgba
    }
    */
    const rgb_modern = /^rgba?\(\s*([^\s,]+?)\s+([^\s,]+?)\s+([^\s,]+?)(?:\s*\/\s*([^\s,]+?))?\s*\)$/;
    const rgb_legacy = /^rgba?\(\s*([^\s,]+?)\s*,\s*([^\s,]+?)\s*,\s*([^\s,]+?)(?:\s*,\s*([^\s,]+?))?\s*\)$/;
    const css4_normalize = (() => {
        const canvas = document.createElement("canvas");
        canvas.width = 1;
        canvas.height = 1;
        const ctx = canvas.getContext("2d");
        const gradient = ctx.createLinearGradient(0, 0, 1, 1);
        return (color) => {
            ctx.fillStyle = gradient; // lgtm [js/useless-assignment-to-property]
            ctx.fillStyle = color;
            const style = ctx.fillStyle;
            return style != gradient ? style : null;
        };
    })();
    function css4_parse(color) {
        var _a;
        /**
          Parses CSS4 color strings:
      
          - transparent
          - named color
          - #RRGGBB[AA]
          - #RGB[A]
          - rgb[a](R G B[ / A])
          - rgb[a](R, G, B[, A])
          - other CSS4 syntax (browser dependent)
      
        */
        color = color.trim().toLowerCase();
        if (!color)
            return null;
        else if (color == "transparent")
            return transparent();
        else if ((0, svg_colors_1.is_named_color)(color)) {
            return decode_rgba(svg_colors_1.named_colors[color]);
        }
        else if (color[0] == "#") {
            const v = Number(`0x${color.substr(1)}`);
            if (isNaN(v))
                return null;
            switch (color.length - 1) {
                case 3: {
                    const r = (v >> 8) & 0xf;
                    const g = (v >> 4) & 0xf;
                    const b = (v >> 0) & 0xf;
                    const rr = (r << 4) | r;
                    const gg = (g << 4) | g;
                    const bb = (b << 4) | b;
                    return [rr, gg, bb, 255];
                }
                case 4: {
                    const r = (v >> 12) & 0xf;
                    const g = (v >> 8) & 0xf;
                    const b = (v >> 4) & 0xf;
                    const a = (v >> 0) & 0xf;
                    const rr = (r << 4) | r;
                    const gg = (g << 4) | g;
                    const bb = (b << 4) | b;
                    const aa = (a << 4) | a;
                    return [rr, gg, bb, aa];
                }
                case 6: {
                    const rr = (v >> 16) & 0xff;
                    const gg = (v >> 8) & 0xff;
                    const bb = (v >> 0) & 0xff;
                    return [rr, gg, bb, 255];
                }
                case 8: {
                    const rr = (v >> 24) & 0xff;
                    const gg = (v >> 16) & 0xff;
                    const bb = (v >> 8) & 0xff;
                    const aa = (v >> 0) & 0xff;
                    return [rr, gg, bb, aa];
                }
            }
        }
        else if (color.startsWith("rgb")) {
            const result = (_a = color.match(rgb_modern)) !== null && _a !== void 0 ? _a : color.match(rgb_legacy);
            if (result != null) {
                let [, r, g, b, a = "1"] = result; // XXX: use groups when IE is dropped
                const rp = r.endsWith("%");
                const gp = g.endsWith("%");
                const bp = b.endsWith("%");
                const ap = a.endsWith("%");
                if (!(rp && gp && bp || (!rp && !gp && !bp)))
                    return null;
                if (rp)
                    r = r.slice(0, -1);
                if (gp)
                    g = g.slice(0, -1);
                if (bp)
                    b = b.slice(0, -1);
                if (ap)
                    a = a.slice(0, -1);
                let R = Number(r);
                let G = Number(g);
                let B = Number(b);
                let A = Number(a);
                if (isNaN(R + G + B + A))
                    return null;
                if (rp)
                    R = 255 * (R / 100);
                if (gp)
                    G = 255 * (G / 100);
                if (bp)
                    B = 255 * (B / 100);
                A = 255 * (ap ? A / 100 : A);
                R = byte(R);
                G = byte(G);
                B = byte(B);
                A = byte(A);
                return [R, G, B, A];
            }
        }
        else {
            const style = css4_normalize(color);
            if (style != null)
                return css4_parse(style);
        }
        return null;
    }
    exports.css4_parse = css4_parse;
    function is_Color(value) {
        if ((0, types_1.isInteger)(value))
            return true;
        if ((0, types_1.isString)(value) && css4_parse(value) != null)
            return true;
        if ((0, types_1.isArray)(value) && (value.length == 3 || value.length == 4))
            return true;
        return false;
    }
    exports.is_Color = is_Color;
    function is_dark([r, g, b]) {
        const l = 1 - (0.299 * r + 0.587 * g + 0.114 * b) / 255;
        return l >= 0.6;
    }
    exports.is_dark = is_dark;
},
/* core/util/svg_colors.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const _named_colors = {
        aliceblue: 0xf0f8ffff,
        antiquewhite: 0xfaebd7ff,
        aqua: 0x00ffffff,
        aquamarine: 0x7fffd4ff,
        azure: 0xf0ffffff,
        beige: 0xf5f5dcff,
        bisque: 0xffe4c4ff,
        black: 0x000000ff,
        blanchedalmond: 0xffebcdff,
        blue: 0x0000ffff,
        blueviolet: 0x8a2be2ff,
        brown: 0xa52a2aff,
        burlywood: 0xdeb887ff,
        cadetblue: 0x5f9ea0ff,
        chartreuse: 0x7fff00ff,
        chocolate: 0xd2691eff,
        coral: 0xff7f50ff,
        cornflowerblue: 0x6495edff,
        cornsilk: 0xfff8dcff,
        crimson: 0xdc143cff,
        cyan: 0x00ffffff,
        darkblue: 0x00008bff,
        darkcyan: 0x008b8bff,
        darkgoldenrod: 0xb8860bff,
        darkgray: 0xa9a9a9ff,
        darkgreen: 0x006400ff,
        darkgrey: 0xa9a9a9ff,
        darkkhaki: 0xbdb76bff,
        darkmagenta: 0x8b008bff,
        darkolivegreen: 0x556b2fff,
        darkorange: 0xff8c00ff,
        darkorchid: 0x9932ccff,
        darkred: 0x8b0000ff,
        darksalmon: 0xe9967aff,
        darkseagreen: 0x8fbc8fff,
        darkslateblue: 0x483d8bff,
        darkslategray: 0x2f4f4fff,
        darkslategrey: 0x2f4f4fff,
        darkturquoise: 0x00ced1ff,
        darkviolet: 0x9400d3ff,
        deeppink: 0xff1493ff,
        deepskyblue: 0x00bfffff,
        dimgray: 0x696969ff,
        dimgrey: 0x696969ff,
        dodgerblue: 0x1e90ffff,
        firebrick: 0xb22222ff,
        floralwhite: 0xfffaf0ff,
        forestgreen: 0x228b22ff,
        fuchsia: 0xff00ffff,
        gainsboro: 0xdcdcdcff,
        ghostwhite: 0xf8f8ffff,
        gold: 0xffd700ff,
        goldenrod: 0xdaa520ff,
        gray: 0x808080ff,
        green: 0x008000ff,
        greenyellow: 0xadff2fff,
        grey: 0x808080ff,
        honeydew: 0xf0fff0ff,
        hotpink: 0xff69b4ff,
        indianred: 0xcd5c5cff,
        indigo: 0x4b0082ff,
        ivory: 0xfffff0ff,
        khaki: 0xf0e68cff,
        lavender: 0xe6e6faff,
        lavenderblush: 0xfff0f5ff,
        lawngreen: 0x7cfc00ff,
        lemonchiffon: 0xfffacdff,
        lightblue: 0xadd8e6ff,
        lightcoral: 0xf08080ff,
        lightcyan: 0xe0ffffff,
        lightgoldenrodyellow: 0xfafad2ff,
        lightgray: 0xd3d3d3ff,
        lightgreen: 0x90ee90ff,
        lightgrey: 0xd3d3d3ff,
        lightpink: 0xffb6c1ff,
        lightsalmon: 0xffa07aff,
        lightseagreen: 0x20b2aaff,
        lightskyblue: 0x87cefaff,
        lightslategray: 0x778899ff,
        lightslategrey: 0x778899ff,
        lightsteelblue: 0xb0c4deff,
        lightyellow: 0xffffe0ff,
        lime: 0x00ff00ff,
        limegreen: 0x32cd32ff,
        linen: 0xfaf0e6ff,
        magenta: 0xff00ffff,
        maroon: 0x800000ff,
        mediumaquamarine: 0x66cdaaff,
        mediumblue: 0x0000cdff,
        mediumorchid: 0xba55d3ff,
        mediumpurple: 0x9370dbff,
        mediumseagreen: 0x3cb371ff,
        mediumslateblue: 0x7b68eeff,
        mediumspringgreen: 0x00fa9aff,
        mediumturquoise: 0x48d1ccff,
        mediumvioletred: 0xc71585ff,
        midnightblue: 0x191970ff,
        mintcream: 0xf5fffaff,
        mistyrose: 0xffe4e1ff,
        moccasin: 0xffe4b5ff,
        navajowhite: 0xffdeadff,
        navy: 0x000080ff,
        oldlace: 0xfdf5e6ff,
        olive: 0x808000ff,
        olivedrab: 0x6b8e23ff,
        orange: 0xffa500ff,
        orangered: 0xff4500ff,
        orchid: 0xda70d6ff,
        palegoldenrod: 0xeee8aaff,
        palegreen: 0x98fb98ff,
        paleturquoise: 0xafeeeeff,
        palevioletred: 0xdb7093ff,
        papayawhip: 0xffefd5ff,
        peachpuff: 0xffdab9ff,
        peru: 0xcd853fff,
        pink: 0xffc0cbff,
        plum: 0xdda0ddff,
        powderblue: 0xb0e0e6ff,
        purple: 0x800080ff,
        rebeccapurple: 0x663399ff,
        red: 0xff0000ff,
        rosybrown: 0xbc8f8fff,
        royalblue: 0x4169e1ff,
        saddlebrown: 0x8b4513ff,
        salmon: 0xfa8072ff,
        sandybrown: 0xf4a460ff,
        seagreen: 0x2e8b57ff,
        seashell: 0xfff5eeff,
        sienna: 0xa0522dff,
        silver: 0xc0c0c0ff,
        skyblue: 0x87ceebff,
        slateblue: 0x6a5acdff,
        slategray: 0x708090ff,
        slategrey: 0x708090ff,
        snow: 0xfffafaff,
        springgreen: 0x00ff7fff,
        steelblue: 0x4682b4ff,
        tan: 0xd2b48cff,
        teal: 0x008080ff,
        thistle: 0xd8bfd8ff,
        tomato: 0xff6347ff,
        turquoise: 0x40e0d0ff,
        violet: 0xee82eeff,
        wheat: 0xf5deb3ff,
        white: 0xffffffff,
        whitesmoke: 0xf5f5f5ff,
        yellow: 0xffff00ff,
        yellowgreen: 0x9acd32ff,
    };
    exports.named_colors = _named_colors;
    function is_named_color(color) {
        return color in exports.named_colors;
    }
    exports.is_named_color = is_named_color;
},
/* core/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.GeneratorFunction = Object.getPrototypeOf(function* () { }).constructor;
    exports.ColorArray = Uint32Array;
    exports.RGBAArray = Uint8ClampedArray;
    function infer_type(a0, a1) {
        if (a0 instanceof Float64Array || a0 instanceof Array)
            return Float64Array;
        if (a1 instanceof Float64Array || a1 instanceof Array)
            return Float64Array;
        return Float32Array;
    }
    exports.infer_type = infer_type;
    exports.ScreenArray = Float32Array;
    function to_screen(array) {
        if (!(array instanceof Float32Array))
            return Float32Array.from(array);
        else
            return array;
    }
    exports.to_screen = to_screen;
    var bitset_1 = require(25) /* ./util/bitset */;
    __esExport("Indices", bitset_1.BitSet);
},
/* core/util/bitset.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const eq_1 = require(26) /* ./eq */;
    const assert_1 = require(11) /* ./assert */;
    class BitSet {
        constructor(size, init = 0) {
            this.size = size;
            this[_a] = "BitSet";
            this._count = null;
            this._nwords = Math.ceil(size / 32);
            if (init == 0 || init == 1) {
                this._array = new Uint32Array(this._nwords);
                if (init == 1) {
                    this._array.fill(0xffffffff);
                }
            }
            else {
                (0, assert_1.assert)(init.length == this._nwords, "Initializer size mismatch");
                this._array = init;
            }
        }
        clone() {
            return new BitSet(this.size, new Uint32Array(this._array));
        }
        [(_a = Symbol.toStringTag, eq_1.equals)](that, cmp) {
            if (!cmp.eq(this.size, that.size))
                return false;
            const { _nwords } = this;
            const trailing = this.size % _nwords;
            const n = trailing == 0 ? _nwords : _nwords - 1;
            for (let i = 0; i < n; i++) {
                if (this._array[i] != that._array[i])
                    return false;
            }
            if (trailing == 0)
                return true;
            else {
                const msb = 1 << (trailing - 1);
                const mask = (msb - 1) ^ msb;
                return (this._array[n] & mask) == (that._array[n] & mask);
            }
        }
        static all_set(size) {
            return new BitSet(size, 1);
        }
        static all_unset(size) {
            return new BitSet(size, 0);
        }
        static from_indices(size, indices) {
            const bits = new BitSet(size);
            for (const i of indices) {
                bits.set(i);
            }
            return bits;
        }
        static from_booleans(size, booleans) {
            const bits = new BitSet(size);
            const n = Math.min(size, booleans.length);
            for (let i = 0; i < n; i++) {
                if (booleans[i])
                    bits.set(i);
            }
            return bits;
        }
        _check_bounds(k) {
            (0, assert_1.assert)(0 <= k && k < this.size, `Out of bounds: 0 <= ${k} < ${this.size}`);
        }
        get(k) {
            this._check_bounds(k);
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            return !!((this._array[i] >> j) & 0x1);
        }
        set(k, v = true) {
            this._check_bounds(k);
            this._count = null;
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            if (v)
                this._array[i] |= 0x1 << j;
            else
                this._array[i] &= ~(0x1 << j);
        }
        unset(k) {
            this.set(k, false);
        }
        *[Symbol.iterator]() {
            yield* this.ones();
        }
        get count() {
            let count = this._count;
            if (count == null)
                this._count = count = this._get_count();
            return count;
        }
        _get_count() {
            const { _array, _nwords, size } = this;
            let c = 0;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += 32;
                }
                else {
                    for (let j = 0; j < 32 && k < size; j++, k++) {
                        if ((word >>> j) & 0x1)
                            c += 1;
                    }
                }
            }
            return c;
        }
        *ones() {
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += 32;
                    continue;
                }
                for (let j = 0; j < 32 && k < size; j++, k++) {
                    if ((word >>> j) & 0x1)
                        yield k;
                }
            }
        }
        *zeros() {
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0xffffffff) {
                    k += 32;
                    continue;
                }
                for (let j = 0; j < 32 && k < size; j++, k++) {
                    if (!((word >>> j) & 0x1))
                        yield k;
                }
            }
        }
        _check_size(other) {
            (0, assert_1.assert)(this.size == other.size, "Size mismatch");
        }
        add(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] |= other._array[i];
            }
        }
        intersect(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] &= other._array[i];
            }
        }
        subtract(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                const a = this._array[i];
                const b = other._array[i];
                this._array[i] = (a ^ b) & a;
            }
        }
        union(other) {
            this._check_size(other);
            const result = this.clone();
            for (let i = 0; i < this._nwords; i++) {
                result._array[i] |= other._array[i];
            }
            return result;
        }
        intersection(other) {
            this._check_size(other);
            const result = this.clone();
            for (let i = 0; i < this._nwords; i++) {
                result._array[i] &= other._array[i];
            }
            return result;
        }
        difference(other) {
            this._check_size(other);
            const result = this.clone();
            for (let i = 0; i < this._nwords; i++) {
                const a = this._array[i];
                const b = other._array[i];
                result._array[i] = (a ^ b) & a;
            }
            return result;
        }
        select(array) {
            (0, assert_1.assert)(this.size <= array.length, "Size mismatch");
            const n = this.count;
            const result = new array.constructor(n);
            let i = 0;
            for (const j of this) {
                result[i++] = array[j];
            }
            return result;
        }
    }
    exports.BitSet = BitSet;
    BitSet.__name__ = "BitSet";
},
/* core/util/eq.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Based on Underscore.js 1.8.3 (http://underscorejs.org)
    const types_1 = require(8) /* ./types */;
    const { hasOwnProperty } = Object.prototype;
    exports.equals = Symbol("equals");
    function is_Equatable(obj) {
        return (0, types_1.isObject)(obj) && obj[exports.equals] !== undefined;
    }
    exports.wildcard = Symbol("wildcard");
    const toString = Object.prototype.toString;
    class Comparator {
        constructor() {
            this.a_stack = [];
            this.b_stack = [];
        }
        eq(a, b) {
            if (Object.is(a, b))
                return true;
            if (a === exports.wildcard || b === exports.wildcard)
                return true;
            if (a == null || b == null)
                return a === b;
            const class_name = toString.call(a);
            if (class_name != toString.call(b))
                return false;
            switch (class_name) {
                case "[object Number]":
                    return this.numbers(a, b);
                case "[object RegExp]":
                case "[object String]":
                    return `${a}` == `${b}`;
                case "[object Date]":
                case "[object Boolean]":
                    return +a === +b;
            }
            // Assume equality for cyclic structures. The algorithm for detecting cyclic
            // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
            // Initializing stack of traversed objects.
            // It's done here since we only need them for objects and arrays comparison.
            const { a_stack, b_stack } = this;
            let length = a_stack.length;
            while (length--) {
                // Linear search. Performance is inversely proportional to the number of
                // unique nested structures.
                if (a_stack[length] === a)
                    return b_stack[length] === b;
            }
            a_stack.push(a);
            b_stack.push(b);
            const result = (() => {
                if (is_Equatable(a) && is_Equatable(b)) {
                    return a[exports.equals](b, this);
                }
                switch (class_name) {
                    case "[object Array]":
                    case "[object Uint8Array]":
                    case "[object Int8Array]":
                    case "[object Uint16Array]":
                    case "[object Int16Array]":
                    case "[object Uint32Array]":
                    case "[object Int32Array]":
                    case "[object Float32Array]":
                    case "[object Float64Array]": {
                        return this.arrays(a, b);
                    }
                    case "[object Map]":
                        return this.maps(a, b);
                    case "[object Set]":
                        return this.sets(a, b);
                    case "[object Object]": {
                        if (a.constructor == b.constructor && (a.constructor == null || a.constructor === Object)) {
                            return this.objects(a, b);
                        }
                    }
                    case "[object Function]": {
                        if (a.constructor == b.constructor && a.constructor === Function) {
                            return this.eq(`${a}`, `${b}`);
                        }
                    }
                }
                if (a instanceof Node) {
                    return this.nodes(a, b);
                }
                throw Error(`can't compare objects of type ${class_name}`);
            })();
            a_stack.pop();
            b_stack.pop();
            return result;
        }
        numbers(a, b) {
            return Object.is(a, b);
        }
        arrays(a, b) {
            const { length } = a;
            if (length != b.length)
                return false;
            for (let i = 0; i < length; i++) {
                if (!this.eq(a[i], b[i]))
                    return false;
            }
            return true;
        }
        iterables(a, b) {
            const ai = a[Symbol.iterator]();
            const bi = b[Symbol.iterator]();
            while (true) {
                const an = ai.next();
                const bn = bi.next();
                if (an.done && bn.done)
                    return true;
                if (an.done || bn.done)
                    return false;
                if (!this.eq(an.value, bn.value))
                    return false;
            }
        }
        maps(a, b) {
            if (a.size != b.size)
                return false;
            for (const [key, val] of a) {
                if (!b.has(key) || !this.eq(val, b.get(key)))
                    return false;
            }
            return true;
        }
        sets(a, b) {
            if (a.size != b.size)
                return false;
            for (const key of a) {
                if (!b.has(key))
                    return false;
            }
            return true;
        }
        objects(a, b) {
            const keys = Object.keys(a);
            if (keys.length != Object.keys(b).length)
                return false;
            for (const key of keys) {
                if (!hasOwnProperty.call(b, key) || !this.eq(a[key], b[key]))
                    return false;
            }
            return true;
        }
        nodes(a, b) {
            if (a.nodeType != b.nodeType)
                return false;
            if (a.textContent != b.textContent)
                return false;
            if (!this.iterables(a.childNodes, b.childNodes))
                return false;
            return true;
        }
    }
    exports.Comparator = Comparator;
    Comparator.__name__ = "Comparator";
    const { abs } = Math;
    class SimilarComparator extends Comparator {
        constructor(tolerance = 1e-4) {
            super();
            this.tolerance = tolerance;
        }
        numbers(a, b) {
            return super.numbers(a, b) || abs(a - b) < this.tolerance;
        }
    }
    exports.SimilarComparator = SimilarComparator;
    SimilarComparator.__name__ = "SimilarComparator";
    function is_equal(a, b) {
        const comparator = new Comparator();
        return comparator.eq(a, b);
    }
    exports.is_equal = is_equal;
    function is_similar(a, b, tolerance) {
        const comparator = new SimilarComparator(tolerance);
        return comparator.eq(a, b);
    }
    exports.is_similar = is_similar;
    /** @deprecated */
    exports.isEqual = is_equal;
},
/* core/util/platform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_windows = (() => {
        return navigator.appVersion.includes("Windows");
    })();
    exports.is_ie = (() => {
        const ua = navigator.userAgent;
        return ua.includes("MSIE") || ua.includes("Trident") || ua.includes("Edge");
    })();
    exports.is_mobile = (() => {
        return typeof window !== "undefined" && ("ontouchstart" in window || navigator.maxTouchPoints > 0);
    })();
    exports.is_little_endian = (() => {
        const buf = new ArrayBuffer(4);
        const buf8 = new Uint8Array(buf);
        const buf32 = new Uint32Array(buf);
        buf32[1] = 0x0a0b0c0d;
        let little_endian = true;
        if (buf8[4] == 0x0a && buf8[5] == 0x0b && buf8[6] == 0x0c && buf8[7] == 0x0d) {
            little_endian = false;
        }
        return little_endian;
    })();
    exports.BYTE_ORDER = exports.is_little_endian ? "little" : "big";
    function to_big_endian(values) {
        if (exports.is_little_endian) {
            const result = new Uint32Array(values.length);
            const view = new DataView(result.buffer);
            let j = 0;
            for (const color of values) {
                view.setUint32(j, color);
                j += 4;
            }
            return result;
        }
        else
            return values;
    }
    exports.to_big_endian = to_big_endian;
},
/* core/settings.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Settings {
        constructor() {
            this._dev = false;
            this._wireframe = false;
        }
        set dev(dev) {
            this._dev = dev;
        }
        get dev() {
            return this._dev;
        }
        set wireframe(wireframe) {
            this._wireframe = wireframe;
        }
        get wireframe() {
            return this._wireframe;
        }
    }
    exports.Settings = Settings;
    Settings.__name__ = "Settings";
    exports.settings = new Settings();
},
/* core/util/ndarray.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a, _b, _c, _d, _e, _f, _g, _h;
    const types_1 = require(8) /* ./types */;
    const assert_1 = require(11) /* ./assert */;
    const eq_1 = require(26) /* ./eq */;
    const serializer_1 = require(30) /* ../serializer */;
    const serialization_1 = require(31) /* ./serialization */;
    const __ndarray__ = Symbol("__ndarray__");
    class Uint8NDArray extends Uint8Array {
        constructor(seq, shape) {
            super(seq);
            this[_a] = true;
            this.dtype = "uint8";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [this.length]);
            this.dimension = this.shape.length;
            // TODO: remove this when IE/legacy is dropped
            if (this[eq_1.equals] == null) {
                this[eq_1.equals] = (that, cmp) => {
                    return Uint8NDArray.prototype[eq_1.equals].call(this, that, cmp);
                };
            }
            if (this[serializer_1.serialize] == null) {
                this[serializer_1.serialize] = (serializer) => {
                    return Uint8NDArray.prototype[serializer_1.serialize].call(this, serializer);
                };
            }
        }
        [(_a = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serializer_1.serialize](_serializer) {
            return (0, serialization_1.encode_NDArray)(this);
        }
    }
    exports.Uint8NDArray = Uint8NDArray;
    Uint8NDArray.__name__ = "Uint8NDArray";
    class Int8NDArray extends Int8Array {
        constructor(seq, shape) {
            super(seq);
            this[_b] = true;
            this.dtype = "int8";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [this.length]);
            this.dimension = this.shape.length;
            // TODO: remove this when IE/legacy is dropped
            if (this[eq_1.equals] == null) {
                this[eq_1.equals] = (that, cmp) => {
                    return Int8NDArray.prototype[eq_1.equals].call(this, that, cmp);
                };
            }
            if (this[serializer_1.serialize] == null) {
                this[serializer_1.serialize] = (serializer) => {
                    return Int8NDArray.prototype[serializer_1.serialize].call(this, serializer);
                };
            }
        }
        [(_b = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serializer_1.serialize](_serializer) {
            return (0, serialization_1.encode_NDArray)(this);
        }
    }
    exports.Int8NDArray = Int8NDArray;
    Int8NDArray.__name__ = "Int8NDArray";
    class Uint16NDArray extends Uint16Array {
        constructor(seq, shape) {
            super(seq);
            this[_c] = true;
            this.dtype = "uint16";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [this.length]);
            this.dimension = this.shape.length;
            // TODO: remove this when IE/legacy is dropped
            if (this[eq_1.equals] == null) {
                this[eq_1.equals] = (that, cmp) => {
                    return Uint16NDArray.prototype[eq_1.equals].call(this, that, cmp);
                };
            }
            if (this[serializer_1.serialize] == null) {
                this[serializer_1.serialize] = (serializer) => {
                    return Uint16NDArray.prototype[serializer_1.serialize].call(this, serializer);
                };
            }
        }
        [(_c = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serializer_1.serialize](_serializer) {
            return (0, serialization_1.encode_NDArray)(this);
        }
    }
    exports.Uint16NDArray = Uint16NDArray;
    Uint16NDArray.__name__ = "Uint16NDArray";
    class Int16NDArray extends Int16Array {
        constructor(seq, shape) {
            super(seq);
            this[_d] = true;
            this.dtype = "int16";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [this.length]);
            this.dimension = this.shape.length;
            // TODO: remove this when IE/legacy is dropped
            if (this[eq_1.equals] == null) {
                this[eq_1.equals] = (that, cmp) => {
                    return Int16NDArray.prototype[eq_1.equals].call(this, that, cmp);
                };
            }
            if (this[serializer_1.serialize] == null) {
                this[serializer_1.serialize] = (serializer) => {
                    return Int16NDArray.prototype[serializer_1.serialize].call(this, serializer);
                };
            }
        }
        [(_d = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serializer_1.serialize](_serializer) {
            return (0, serialization_1.encode_NDArray)(this);
        }
    }
    exports.Int16NDArray = Int16NDArray;
    Int16NDArray.__name__ = "Int16NDArray";
    class Uint32NDArray extends Uint32Array {
        constructor(seq, shape) {
            super(seq);
            this[_e] = true;
            this.dtype = "uint32";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [this.length]);
            this.dimension = this.shape.length;
            // TODO: remove this when IE/legacy is dropped
            if (this[eq_1.equals] == null) {
                this[eq_1.equals] = (that, cmp) => {
                    return Uint32NDArray.prototype[eq_1.equals].call(this, that, cmp);
                };
            }
            if (this[serializer_1.serialize] == null) {
                this[serializer_1.serialize] = (serializer) => {
                    return Uint32NDArray.prototype[serializer_1.serialize].call(this, serializer);
                };
            }
        }
        [(_e = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serializer_1.serialize](_serializer) {
            return (0, serialization_1.encode_NDArray)(this);
        }
    }
    exports.Uint32NDArray = Uint32NDArray;
    Uint32NDArray.__name__ = "Uint32NDArray";
    class Int32NDArray extends Int32Array {
        constructor(seq, shape) {
            super(seq);
            this[_f] = true;
            this.dtype = "int32";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [this.length]);
            this.dimension = this.shape.length;
            // TODO: remove this when IE/legacy is dropped
            if (this[eq_1.equals] == null) {
                this[eq_1.equals] = (that, cmp) => {
                    return Int32NDArray.prototype[eq_1.equals].call(this, that, cmp);
                };
            }
            if (this[serializer_1.serialize] == null) {
                this[serializer_1.serialize] = (serializer) => {
                    return Int32NDArray.prototype[serializer_1.serialize].call(this, serializer);
                };
            }
        }
        [(_f = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serializer_1.serialize](_serializer) {
            return (0, serialization_1.encode_NDArray)(this);
        }
    }
    exports.Int32NDArray = Int32NDArray;
    Int32NDArray.__name__ = "Int32NDArray";
    class Float32NDArray extends Float32Array {
        constructor(seq, shape) {
            super(seq);
            this[_g] = true;
            this.dtype = "float32";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [this.length]);
            this.dimension = this.shape.length;
            // TODO: remove this when IE/legacy is dropped
            if (this[eq_1.equals] == null) {
                this[eq_1.equals] = (that, cmp) => {
                    return Float32NDArray.prototype[eq_1.equals].call(this, that, cmp);
                };
            }
            if (this[serializer_1.serialize] == null) {
                this[serializer_1.serialize] = (serializer) => {
                    return Float32NDArray.prototype[serializer_1.serialize].call(this, serializer);
                };
            }
        }
        [(_g = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serializer_1.serialize](_serializer) {
            return (0, serialization_1.encode_NDArray)(this);
        }
    }
    exports.Float32NDArray = Float32NDArray;
    Float32NDArray.__name__ = "Float32NDArray";
    class Float64NDArray extends Float64Array {
        constructor(seq, shape) {
            super(seq);
            this[_h] = true;
            this.dtype = "float64";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [this.length]);
            this.dimension = this.shape.length;
            // TODO: remove this when IE/legacy is dropped
            if (this[eq_1.equals] == null) {
                this[eq_1.equals] = (that, cmp) => {
                    return Float64NDArray.prototype[eq_1.equals].call(this, that, cmp);
                };
            }
            if (this[serializer_1.serialize] == null) {
                this[serializer_1.serialize] = (serializer) => {
                    return Float64NDArray.prototype[serializer_1.serialize].call(this, serializer);
                };
            }
        }
        [(_h = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serializer_1.serialize](_serializer) {
            return (0, serialization_1.encode_NDArray)(this);
        }
    }
    exports.Float64NDArray = Float64NDArray;
    Float64NDArray.__name__ = "Float64NDArray";
    function is_NDArray(v) {
        return (0, types_1.isObject)(v) && v[__ndarray__] !== undefined;
    }
    exports.is_NDArray = is_NDArray;
    function ndarray(array, options = {}) {
        let { dtype } = options;
        if (dtype == null) {
            if (array instanceof ArrayBuffer || (0, types_1.isArray)(array)) {
                dtype = "float64";
            }
            else {
                dtype = (() => {
                    switch (true) {
                        case array instanceof Uint8Array: return "uint8";
                        case array instanceof Int8Array: return "int8";
                        case array instanceof Uint16Array: return "uint16";
                        case array instanceof Int16Array: return "int16";
                        case array instanceof Uint32Array: return "uint32";
                        case array instanceof Int32Array: return "int32";
                        case array instanceof Float32Array: return "float32";
                        case array instanceof Float64Array: return "float64";
                        default:
                            (0, assert_1.unreachable)();
                    }
                })();
            }
        }
        const { shape } = options;
        switch (dtype) {
            case "uint8": return new Uint8NDArray(array, shape);
            case "int8": return new Int8NDArray(array, shape);
            case "uint16": return new Uint16NDArray(array, shape);
            case "int16": return new Int16NDArray(array, shape);
            case "uint32": return new Uint32NDArray(array, shape);
            case "int32": return new Int32NDArray(array, shape);
            case "float32": return new Float32NDArray(array, shape);
            case "float64": return new Float64NDArray(array, shape);
        }
    }
    exports.ndarray = ndarray;
},
/* core/serializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const assert_1 = require(11) /* ./util/assert */;
    const object_1 = require(13) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    //| Map<SerializableType, SerializableType>
    //| Set<SerializableType>
    //| ArrayBuffer
    // TypedArray?
    exports.serialize = Symbol("serialize");
    function is_Serializable(obj) {
        return (0, types_1.isObject)(obj) && obj[exports.serialize] !== undefined;
    }
    class SerializationError extends Error {
    }
    exports.SerializationError = SerializationError;
    SerializationError.__name__ = "SerializationError";
    class Serializer {
        constructor(options) {
            var _a;
            this._references = new Map();
            this._definitions = new Map();
            this._refmap = new Map();
            this.include_defaults = (_a = options === null || options === void 0 ? void 0 : options.include_defaults) !== null && _a !== void 0 ? _a : true;
        }
        get_ref(obj) {
            return this._references.get(obj);
        }
        add_ref(obj, ref) {
            (0, assert_1.assert)(!this._references.has(obj));
            this._references.set(obj, ref);
        }
        add_def(obj, def) {
            const ref = this.get_ref(obj);
            (0, assert_1.assert)(ref != null);
            this._definitions.set(obj, def);
            this._refmap.set(ref, def);
        }
        get objects() {
            return new Set(this._references.keys());
        }
        get references() {
            return new Set(this._references.values());
        }
        get definitions() {
            return new Set(this._definitions.values());
        }
        resolve_ref(ref) {
            return this._refmap.get(ref);
        }
        remove_ref(obj) {
            return this._references.delete(obj);
        }
        remove_def(obj) {
            return this._definitions.delete(obj);
        }
        to_serializable(obj) {
            const ref = this.get_ref(obj);
            if (ref != null)
                return ref;
            else if (is_Serializable(obj))
                return obj[exports.serialize](this);
            else if ((0, types_1.isArray)(obj) || (0, types_1.isTypedArray)(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.to_serializable(value);
                }
                return result;
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                const result = {};
                for (const [key, value] of (0, object_1.entries)(obj)) {
                    result[key] = this.to_serializable(value);
                }
                return result;
            }
            else if (obj === null || (0, types_1.isBoolean)(obj) || (0, types_1.isNumber)(obj) || (0, types_1.isString)(obj)) {
                return obj;
            }
            else
                throw new SerializationError(`${Object.prototype.toString.call(obj)} is not serializable`);
        }
    }
    exports.Serializer = Serializer;
    Serializer.__name__ = "Serializer";
},
/* core/util/serialization.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./types */;
    const platform_1 = require(27) /* ./platform */;
    const buffer_1 = require(32) /* ./buffer */;
    function is_NDArray_ref(v) {
        return (0, types_1.isPlainObject)(v) && ("__buffer__" in v || "__ndarray__" in v);
    }
    exports.is_NDArray_ref = is_NDArray_ref;
    function decode_NDArray(ref, buffers) {
        const { shape, dtype, order } = ref;
        let bytes;
        if ("__buffer__" in ref) {
            const buffer = buffers.get(ref.__buffer__);
            if (buffer != null)
                bytes = buffer;
            else
                throw new Error(`buffer for ${ref.__buffer__} not found`);
        }
        else {
            bytes = (0, buffer_1.base64_to_buffer)(ref.__ndarray__);
        }
        if (order !== platform_1.BYTE_ORDER) {
            (0, buffer_1.swap)(bytes, dtype);
        }
        return { buffer: bytes, dtype, shape };
    }
    exports.decode_NDArray = decode_NDArray;
    function encode_NDArray(array, buffers) {
        const data = {
            order: platform_1.BYTE_ORDER,
            dtype: array.dtype,
            shape: array.shape,
        };
        if (buffers != null) {
            const __buffer__ = `${buffers.size}`;
            buffers.set(__buffer__, array.buffer);
            return Object.assign({ __buffer__ }, data);
        }
        else {
            const __ndarray__ = {
                toJSON() {
                    return (0, buffer_1.buffer_to_base64)(array.buffer);
                },
            };
            return Object.assign({ __ndarray__ }, data);
        }
    }
    exports.encode_NDArray = encode_NDArray;
},
/* core/util/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function buffer_to_base64(buffer) {
        const bytes = new Uint8Array(buffer);
        const chars = Array.from(bytes).map((b) => String.fromCharCode(b));
        return btoa(chars.join(""));
    }
    exports.buffer_to_base64 = buffer_to_base64;
    function base64_to_buffer(base64) {
        const binary_string = atob(base64);
        const len = binary_string.length;
        const bytes = new Uint8Array(len);
        for (let i = 0, end = len; i < end; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes.buffer;
    }
    exports.base64_to_buffer = base64_to_buffer;
    // NOTE: swap{16,32,64} assume byteOffset == 0
    function swap16(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 2) {
            const t = x[i];
            x[i] = x[i + 1];
            x[i + 1] = t;
        }
    }
    function swap32(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 4) {
            let t = x[i];
            x[i] = x[i + 3];
            x[i + 3] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 2];
            x[i + 2] = t;
        }
    }
    function swap64(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 8) {
            let t = x[i];
            x[i] = x[i + 7];
            x[i + 7] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 6];
            x[i + 6] = t;
            t = x[i + 2];
            x[i + 2] = x[i + 5];
            x[i + 5] = t;
            t = x[i + 3];
            x[i + 3] = x[i + 4];
            x[i + 4] = t;
        }
    }
    function swap(buffer, dtype) {
        switch (dtype) {
            case "uint16":
            case "int16":
                swap16(buffer);
                break;
            case "uint32":
            case "int32":
            case "float32":
                swap32(buffer);
                break;
            case "float64":
                swap64(buffer);
                break;
        }
    }
    exports.swap = swap;
},
/* core/uniforms.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const eq_1 = require(26) /* ./util/eq */;
    class Uniform {
        is_Scalar() { return this.is_scalar; }
        is_Vector() { return !this.is_scalar; }
    }
    exports.Uniform = Uniform;
    Uniform.__name__ = "Uniform";
    class UniformScalar extends Uniform {
        constructor(value, length) {
            super();
            this.value = value;
            this.length = length;
            this.is_scalar = true;
        }
        get(_i) {
            return this.value;
        }
        *[Symbol.iterator]() {
            const { length, value } = this;
            for (let i = 0; i < length; i++) {
                yield value;
            }
        }
        select(indices) {
            return new UniformScalar(this.value, indices.count);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.value, that.value);
        }
    }
    exports.UniformScalar = UniformScalar;
    UniformScalar.__name__ = "UniformScalar";
    class UniformVector extends Uniform {
        constructor(array) {
            super();
            this.array = array;
            this.is_scalar = false;
            this.length = this.array.length;
        }
        get(i) {
            return this.array[i];
        }
        *[Symbol.iterator]() {
            yield* this.array;
        }
        select(indices) {
            const array = indices.select(this.array);
            return new this.constructor(array);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.array, that.array);
        }
    }
    exports.UniformVector = UniformVector;
    UniformVector.__name__ = "UniformVector";
    class ColorUniformVector extends UniformVector {
        constructor(array) {
            super(array);
            this.array = array;
            this._view = new DataView(array.buffer);
        }
        get(i) {
            return this._view.getUint32(4 * i);
        }
        *[Symbol.iterator]() {
            const n = this.length;
            for (let i = 0; i < n; i++)
                yield this.get(i);
        }
    }
    exports.ColorUniformVector = ColorUniformVector;
    ColorUniformVector.__name__ = "ColorUniformVector";
},
/* core/util/string.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const settings_1 = require(28) /* ../settings */;
    function startsWith(str, searchString, position = 0) {
        return str.substr(position, searchString.length) == searchString;
    }
    exports.startsWith = startsWith;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        const s = new Array(32);
        const hexDigits = "0123456789ABCDEF";
        for (let i = 0; i < 32; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[12] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hexDigits.substr((s[16].charCodeAt(0) & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join("");
    }
    exports.uuid4 = uuid4;
    let counter = 1000;
    function uniqueId(prefix) {
        const id = settings_1.settings.dev ? `j${counter++}` : uuid4();
        if (prefix != null)
            return `${prefix}-${id}`;
        else
            return id;
    }
    exports.uniqueId = uniqueId;
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, (ch) => {
            switch (ch) {
                case "&": return "&amp;";
                case "<": return "&lt;";
                case ">": return "&gt;";
                case '"': return "&quot;";
                case "'": return "&#x27;";
                case "`": return "&#x60;";
                default: return ch;
            }
        });
    }
    exports.escape = escape;
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, (_, entity) => {
            switch (entity) {
                case "amp": return "&";
                case "lt": return "<";
                case "gt": return ">";
                case "quot": return '"';
                case "#x27": return "'";
                case "#x60": return "`";
                default: return entity;
            }
        });
    }
    exports.unescape = unescape;
    function use_strict(code) {
        return `'use strict';\n${code}`;
    }
    exports.use_strict = use_strict;
    function to_fixed(val, precision) {
        return val.toFixed(precision).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
    }
    exports.to_fixed = to_fixed;
},
/* document/events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const serializer_1 = require(30) /* ../core/serializer */;
    class DocumentEvent {
        constructor(document) {
            this.document = document;
        }
    }
    exports.DocumentEvent = DocumentEvent;
    DocumentEvent.__name__ = "DocumentEvent";
    class DocumentEventBatch extends DocumentEvent {
        constructor(document, events, setter_id) {
            super(document);
            this.events = events;
            this.setter_id = setter_id;
        }
    }
    exports.DocumentEventBatch = DocumentEventBatch;
    DocumentEventBatch.__name__ = "DocumentEventBatch";
    class DocumentChangedEvent extends DocumentEvent {
    }
    exports.DocumentChangedEvent = DocumentChangedEvent;
    DocumentChangedEvent.__name__ = "DocumentChangedEvent";
    class MessageSentEvent extends DocumentChangedEvent {
        constructor(document, msg_type, msg_data) {
            super(document);
            this.msg_type = msg_type;
            this.msg_data = msg_data;
        }
        [serializer_1.serialize](serializer) {
            const value = this.msg_data;
            const value_serialized = serializer.to_serializable(value);
            return {
                kind: "MessageSent",
                msg_type: this.msg_type,
                msg_data: value_serialized,
            };
        }
    }
    exports.MessageSentEvent = MessageSentEvent;
    MessageSentEvent.__name__ = "MessageSentEvent";
    class ModelChangedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, old, new_, setter_id, hint) {
            super(document);
            this.model = model;
            this.attr = attr;
            this.old = old;
            this.new_ = new_;
            this.setter_id = setter_id;
            this.hint = hint;
        }
        [serializer_1.serialize](serializer) {
            if (this.hint != null)
                return serializer.to_serializable(this.hint);
            const value = this.new_;
            const value_serialized = serializer.to_serializable(value);
            if (this.model != value) {
                // we know we don't want a whole new copy of the obj we're
                // patching unless it's also the value itself
                serializer.remove_def(this.model);
            }
            return {
                kind: "ModelChanged",
                model: this.model.ref(),
                attr: this.attr,
                new: value_serialized,
            };
        }
    }
    exports.ModelChangedEvent = ModelChangedEvent;
    ModelChangedEvent.__name__ = "ModelChangedEvent";
    class ColumnsPatchedEvent extends DocumentChangedEvent {
        constructor(document, column_source, patches) {
            super(document);
            this.column_source = column_source;
            this.patches = patches;
        }
        [serializer_1.serialize](_serializer) {
            return {
                kind: "ColumnsPatched",
                column_source: this.column_source,
                patches: this.patches,
            };
        }
    }
    exports.ColumnsPatchedEvent = ColumnsPatchedEvent;
    ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
    class ColumnsStreamedEvent extends DocumentChangedEvent {
        constructor(document, column_source, data, rollover) {
            super(document);
            this.column_source = column_source;
            this.data = data;
            this.rollover = rollover;
        }
        [serializer_1.serialize](_serializer) {
            return {
                kind: "ColumnsStreamed",
                column_source: this.column_source,
                data: this.data,
                rollover: this.rollover,
            };
        }
    }
    exports.ColumnsStreamedEvent = ColumnsStreamedEvent;
    ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
    class TitleChangedEvent extends DocumentChangedEvent {
        constructor(document, title, setter_id) {
            super(document);
            this.title = title;
            this.setter_id = setter_id;
        }
        [serializer_1.serialize](_serializer) {
            return {
                kind: "TitleChanged",
                title: this.title,
            };
        }
    }
    exports.TitleChangedEvent = TitleChangedEvent;
    TitleChangedEvent.__name__ = "TitleChangedEvent";
    class RootAddedEvent extends DocumentChangedEvent {
        constructor(document, model, setter_id) {
            super(document);
            this.model = model;
            this.setter_id = setter_id;
        }
        [serializer_1.serialize](serializer) {
            return {
                kind: "RootAdded",
                model: serializer.to_serializable(this.model),
            };
        }
    }
    exports.RootAddedEvent = RootAddedEvent;
    RootAddedEvent.__name__ = "RootAddedEvent";
    class RootRemovedEvent extends DocumentChangedEvent {
        constructor(document, model, setter_id) {
            super(document);
            this.model = model;
            this.setter_id = setter_id;
        }
        [serializer_1.serialize](_serializer) {
            return {
                kind: "RootRemoved",
                model: this.model.ref(),
            };
        }
    }
    exports.RootRemovedEvent = RootRemovedEvent;
    RootRemovedEvent.__name__ = "RootRemovedEvent";
},
/* core/util/pretty.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./types */;
    const object_1 = require(13) /* ./object */;
    exports.pretty = Symbol("pretty");
    function is_Printable(obj) {
        return (0, types_1.isObject)(obj) && obj[exports.pretty] !== undefined;
    }
    class Printer {
        constructor(options) {
            this.visited = new Set();
            this.precision = options === null || options === void 0 ? void 0 : options.precision;
        }
        to_string(obj) {
            if ((0, types_1.isObject)(obj)) {
                if (this.visited.has(obj))
                    return "<circular>";
                else
                    this.visited.add(obj);
            }
            if (is_Printable(obj))
                return obj[exports.pretty](this);
            else if ((0, types_1.isBoolean)(obj))
                return this.boolean(obj);
            else if ((0, types_1.isNumber)(obj))
                return this.number(obj);
            else if ((0, types_1.isString)(obj))
                return this.string(obj);
            else if ((0, types_1.isArray)(obj))
                return this.array(obj);
            else if ((0, types_1.isIterable)(obj))
                return this.iterable(obj);
            else if ((0, types_1.isPlainObject)(obj))
                return this.object(obj);
            else if ((0, types_1.isSymbol)(obj))
                return this.symbol(obj);
            else
                return `${obj}`;
        }
        token(val) {
            return val;
        }
        boolean(val) {
            return `${val}`;
        }
        number(val) {
            if (this.precision != null)
                return val.toFixed(this.precision);
            else
                return `${val}`;
        }
        string(val) {
            return `"${val.replace(/'/g, "\\'")}"`; // lgtm [js/incomplete-sanitization]
        }
        symbol(val) {
            return val.toString();
        }
        array(obj) {
            const T = this.token;
            const items = [];
            for (const entry of obj) {
                items.push(this.to_string(entry));
            }
            return `${T("[")}${items.join(`${T(",")} `)}${T("]")}`;
        }
        iterable(obj) {
            var _a;
            const T = this.token;
            const tag = (_a = Object(obj)[Symbol.toStringTag]) !== null && _a !== void 0 ? _a : "Object";
            const items = this.array(obj);
            return `${tag}${T("(")}${items}${T(")")}`;
        }
        object(obj) {
            const T = this.token;
            const items = [];
            for (const [key, val] of (0, object_1.entries)(obj)) {
                items.push(`${key}${T(":")} ${this.to_string(val)}`);
            }
            return `${T("{")}${items.join(`${T(",")} `)}${T("}")}`;
        }
    }
    exports.Printer = Printer;
    Printer.__name__ = "Printer";
    function to_string(obj, options) {
        const printer = new Printer(options);
        return printer.to_string(obj);
    }
    exports.to_string = to_string;
},
/* core/util/cloneable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const object_1 = require(13) /* ./object */;
    const types_1 = require(8) /* ./types */;
    //| Map<CloneableType, CloneableType>
    //| Set<CloneableType>
    exports.clone = Symbol("clone");
    function is_Cloneable(obj) {
        return (0, types_1.isObject)(obj) && obj[exports.clone] !== undefined;
    }
    exports.is_Cloneable = is_Cloneable;
    class CloningError extends Error {
    }
    exports.CloningError = CloningError;
    CloningError.__name__ = "CloningError";
    class Cloner {
        constructor() { }
        clone(obj) {
            if (is_Cloneable(obj))
                return obj[exports.clone](this);
            else if ((0, types_1.isArray)(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.clone(value);
                }
                return result;
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                const result = {};
                for (const [key, value] of (0, object_1.entries)(obj)) {
                    result[key] = this.clone(value);
                }
                return result;
            }
            else if (obj === null || (0, types_1.isBoolean)(obj) || (0, types_1.isNumber)(obj) || (0, types_1.isString)(obj)) {
                return obj;
            }
            else
                throw new CloningError(`${Object.prototype.toString.call(obj)} is not cloneable`);
        }
    }
    exports.Cloner = Cloner;
    Cloner.__name__ = "Cloner";
},
/* models/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    (0, tslib_1.__exportStar)(require(39) /* ./annotations */, exports);
    (0, tslib_1.__exportStar)(require(127) /* ./axes */, exports);
    (0, tslib_1.__exportStar)(require(244) /* ./callbacks */, exports);
    (0, tslib_1.__exportStar)(require(248) /* ./canvas */, exports);
    (0, tslib_1.__exportStar)(require(253) /* ./expressions */, exports);
    (0, tslib_1.__exportStar)(require(262) /* ./filters */, exports);
    (0, tslib_1.__exportStar)(require(192) /* ./formatters */, exports);
    (0, tslib_1.__exportStar)(require(267) /* ./glyphs */, exports);
    (0, tslib_1.__exportStar)(require(301) /* ./graphs */, exports);
    (0, tslib_1.__exportStar)(require(305) /* ./grids */, exports);
    (0, tslib_1.__exportStar)(require(307) /* ./layouts */, exports);
    (0, tslib_1.__exportStar)(require(196) /* ./mappers */, exports);
    (0, tslib_1.__exportStar)(require(320) /* ./text */, exports);
    (0, tslib_1.__exportStar)(require(321) /* ./transforms */, exports);
    (0, tslib_1.__exportStar)(require(329) /* ./plots */, exports);
    (0, tslib_1.__exportStar)(require(337) /* ./policies */, exports);
    (0, tslib_1.__exportStar)(require(206) /* ./ranges */, exports);
    (0, tslib_1.__exportStar)(require(338) /* ./renderers */, exports);
    (0, tslib_1.__exportStar)(require(204) /* ./scales */, exports);
    (0, tslib_1.__exportStar)(require(340) /* ./selections */, exports);
    (0, tslib_1.__exportStar)(require(341) /* ./sources */, exports);
    (0, tslib_1.__exportStar)(require(168) /* ./tickers */, exports);
    (0, tslib_1.__exportStar)(require(346) /* ./tiles */, exports);
    (0, tslib_1.__exportStar)(require(356) /* ./textures */, exports);
    (0, tslib_1.__exportStar)(require(360) /* ./tools */, exports);
},
/* models/annotations/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var annotation_1 = require(40) /* ./annotation */;
    __esExport("Annotation", annotation_1.Annotation);
    var arrow_1 = require(68) /* ./arrow */;
    __esExport("Arrow", arrow_1.Arrow);
    var arrow_head_1 = require(112) /* ./arrow_head */;
    __esExport("ArrowHead", arrow_head_1.ArrowHead);
    var arrow_head_2 = require(112) /* ./arrow_head */;
    __esExport("OpenHead", arrow_head_2.OpenHead);
    var arrow_head_3 = require(112) /* ./arrow_head */;
    __esExport("NormalHead", arrow_head_3.NormalHead);
    var arrow_head_4 = require(112) /* ./arrow_head */;
    __esExport("TeeHead", arrow_head_4.TeeHead);
    var arrow_head_5 = require(112) /* ./arrow_head */;
    __esExport("VeeHead", arrow_head_5.VeeHead);
    var band_1 = require(114) /* ./band */;
    __esExport("Band", band_1.Band);
    var box_annotation_1 = require(116) /* ./box_annotation */;
    __esExport("BoxAnnotation", box_annotation_1.BoxAnnotation);
    var color_bar_1 = require(117) /* ./color_bar */;
    __esExport("ColorBar", color_bar_1.ColorBar);
    var label_1 = require(212) /* ./label */;
    __esExport("Label", label_1.Label);
    var label_set_1 = require(213) /* ./label_set */;
    __esExport("LabelSet", label_set_1.LabelSet);
    var legend_1 = require(214) /* ./legend */;
    __esExport("Legend", legend_1.Legend);
    var legend_item_1 = require(215) /* ./legend_item */;
    __esExport("LegendItem", legend_item_1.LegendItem);
    var poly_annotation_1 = require(217) /* ./poly_annotation */;
    __esExport("PolyAnnotation", poly_annotation_1.PolyAnnotation);
    var slope_1 = require(218) /* ./slope */;
    __esExport("Slope", slope_1.Slope);
    var span_1 = require(219) /* ./span */;
    __esExport("Span", span_1.Span);
    var text_annotation_1 = require(119) /* ./text_annotation */;
    __esExport("TextAnnotation", text_annotation_1.TextAnnotation);
    var title_1 = require(118) /* ./title */;
    __esExport("Title", title_1.Title);
    var toolbar_panel_1 = require(220) /* ./toolbar_panel */;
    __esExport("ToolbarPanel", toolbar_panel_1.ToolbarPanel);
    var tooltip_1 = require(241) /* ./tooltip */;
    __esExport("Tooltip", tooltip_1.Tooltip);
    var whisker_1 = require(243) /* ./whisker */;
    __esExport("Whisker", whisker_1.Whisker);
},
/* models/annotations/annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const renderer_1 = require(41) /* ../renderers/renderer */;
    class AnnotationView extends renderer_1.RendererView {
        get_size() {
            if (this.model.visible) {
                const { width, height } = this._get_size();
                return { width: Math.round(width), height: Math.round(height) };
            }
            else
                return { width: 0, height: 0 };
        }
        _get_size() {
            throw new Error("not implemented");
        }
        connect_signals() {
            super.connect_signals();
            const p = this.model.properties;
            this.on_change(p.visible, () => {
                if (this.layout != null) {
                    this.layout.visible = this.model.visible;
                    this.plot_view.request_layout();
                }
            });
        }
        get needs_clip() {
            return this.layout == null; // TODO: change this, when center layout is fully implemented
        }
        serializable_state() {
            const state = super.serializable_state();
            return this.layout == null ? state : Object.assign(Object.assign({}, state), { bbox: this.layout.bbox.box });
        }
    }
    exports.AnnotationView = AnnotationView;
    AnnotationView.__name__ = "AnnotationView";
    class Annotation extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Annotation = Annotation;
    _a = Annotation;
    Annotation.__name__ = "Annotation";
    (() => {
        _a.override({
            level: "annotation",
        });
    })();
},
/* models/renderers/renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a, _b;
    const view_1 = require(42) /* ../../core/view */;
    const visuals = (0, tslib_1.__importStar)(require(45) /* ../../core/visuals */);
    const enums_1 = require(20) /* ../../core/enums */;
    const model_1 = require(53) /* ../../model */;
    const coordinates_1 = require(54) /* ../canvas/coordinates */;
    class RendererGroup extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.RendererGroup = RendererGroup;
    _a = RendererGroup;
    RendererGroup.__name__ = "RendererGroup";
    (() => {
        _a.define(({ Boolean }) => ({
            visible: [Boolean, true],
        }));
    })();
    class RendererView extends view_1.View {
        get coordinates() {
            const { _coordinates } = this;
            if (_coordinates != null)
                return _coordinates;
            else
                return this._coordinates = this._initialize_coordinates();
        }
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this);
            this.needs_webgl_blit = false;
        }
        connect_signals() {
            super.connect_signals();
            const { x_range_name, y_range_name } = this.model.properties;
            this.on_change([x_range_name, y_range_name], () => this._initialize_coordinates());
            const { group } = this.model;
            if (group != null) {
                this.on_change(group.properties.visible, () => {
                    this.model.visible = group.visible;
                });
            }
        }
        _initialize_coordinates() {
            const { coordinates } = this.model;
            const { frame } = this.plot_view;
            if (coordinates != null) {
                return coordinates.get_transform(frame);
            }
            else {
                const { x_range_name, y_range_name } = this.model;
                const x_scale = frame.x_scales.get(x_range_name);
                const y_scale = frame.y_scales.get(y_range_name);
                return new coordinates_1.CoordinateTransform(x_scale, y_scale);
            }
        }
        get plot_view() {
            return this.parent;
        }
        get plot_model() {
            return this.parent.model;
        }
        get layer() {
            const { overlays, primary } = this.canvas;
            return this.model.level == "overlay" ? overlays : primary;
        }
        get canvas() {
            return this.plot_view.canvas_view;
        }
        request_render() {
            this.request_paint();
        }
        request_paint() {
            this.plot_view.request_paint(this);
        }
        request_layout() {
            this.plot_view.request_layout();
        }
        notify_finished() {
            this.plot_view.notify_finished();
        }
        notify_finished_after_paint() {
            this.plot_view.notify_finished_after_paint();
        }
        get needs_clip() {
            return false;
        }
        get has_webgl() {
            return false;
        }
        /*
        get visible(): boolean {
          const {visible, group} = this.model
          return !visible ? false : (group?.visible ?? true)
        }
        */
        render() {
            if (this.model.visible) {
                this._render();
            }
            this._has_finished = true;
        }
        renderer_view(_renderer) {
            return undefined;
        }
    }
    exports.RendererView = RendererView;
    RendererView.__name__ = "RendererView";
    class Renderer extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Renderer = Renderer;
    _b = Renderer;
    Renderer.__name__ = "Renderer";
    (() => {
        _b.define(({ Boolean, String, Ref, Nullable }) => ({
            group: [Nullable(Ref(RendererGroup)), null],
            level: [enums_1.RenderLevel, "image"],
            visible: [Boolean, true],
            x_range_name: [String, "default"],
            y_range_name: [String, "default"],
            coordinates: [Nullable(Ref(coordinates_1.CoordinateMapping)), null],
        }));
    })();
},
/* core/view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(15) /* ./signaling */;
    const dom_1 = require(43) /* ./dom */;
    const types_1 = require(8) /* ./util/types */;
    const root_css_1 = (0, tslib_1.__importDefault)(require(44) /* ../styles/root.css */);
    class View {
        constructor(options) {
            this.removed = new signaling_1.Signal0(this, "removed");
            this._ready = Promise.resolve(undefined);
            /** @internal */
            this._slots = new WeakMap();
            this._idle_notified = false;
            const { model, parent } = options;
            this.model = model;
            this.parent = parent;
            this.root = parent == null ? this : parent.root;
            this.removed.emit();
        }
        get ready() {
            return this._ready;
        }
        connect(signal, slot) {
            let new_slot = this._slots.get(slot);
            if (new_slot == null) {
                new_slot = (args, sender) => {
                    const promise = Promise.resolve(slot.call(this, args, sender));
                    this._ready = this._ready.then(() => promise);
                };
                this._slots.set(slot, new_slot);
            }
            return signal.connect(new_slot, this);
        }
        disconnect(signal, slot) {
            return signal.disconnect(slot, this);
        }
        initialize() {
            this._has_finished = false;
            if (this.is_root) {
                this._stylesheet = dom_1.stylesheet;
            }
            for (const style of this.styles()) {
                this.stylesheet.append(style);
            }
        }
        async lazy_initialize() { }
        remove() {
            this.disconnect_signals();
            this.removed.emit();
        }
        toString() {
            return `${this.model.type}View(${this.model.id})`;
        }
        serializable_state() {
            return { type: this.model.type };
        }
        get is_root() {
            return this.parent == null;
        }
        has_finished() {
            return this._has_finished;
        }
        get is_idle() {
            return this.has_finished();
        }
        connect_signals() { }
        disconnect_signals() {
            signaling_1.Signal.disconnect_receiver(this);
        }
        on_change(properties, fn) {
            for (const property of (0, types_1.isArray)(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
        cursor(_sx, _sy) {
            return null;
        }
        get stylesheet() {
            if (this.is_root)
                return this._stylesheet;
            else
                return this.root.stylesheet;
        }
        styles() {
            return [root_css_1.default];
        }
        notify_finished() {
            if (!this.is_root)
                this.root.notify_finished();
            else {
                if (!this._idle_notified && this.has_finished()) {
                    if (this.model.document != null) {
                        this._idle_notified = true;
                        this.model.document.notify_idle(this.model);
                    }
                }
            }
        }
    }
    exports.View = View;
    View.__name__ = "View";
},
/* core/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(13) /* ./util/object */;
    const _createElement = (tag) => {
        return (attrs = {}, ...children) => {
            const element = document.createElement(tag);
            element.classList.add("bk");
            if (!(0, types_1.isPlainObject)(attrs)) {
                children = [attrs, ...children];
                attrs = {};
            }
            for (let [attr, value] of (0, object_1.entries)(attrs)) {
                if (value == null || (0, types_1.isBoolean)(value) && !value)
                    continue;
                if (attr === "class") {
                    if ((0, types_1.isString)(value))
                        value = value.split(/\s+/);
                    if ((0, types_1.isArray)(value)) {
                        for (const cls of value) {
                            if (cls != null)
                                element.classList.add(cls);
                        }
                        continue;
                    }
                }
                if (attr === "style" && (0, types_1.isPlainObject)(value)) {
                    for (const [prop, data] of (0, object_1.entries)(value)) {
                        element.style[prop] = data;
                    }
                    continue;
                }
                if (attr === "data" && (0, types_1.isPlainObject)(value)) {
                    for (const [key, data] of (0, object_1.entries)(value)) {
                        element.dataset[key] = data; // XXX: attrs needs a better type
                    }
                    continue;
                }
                element.setAttribute(attr, value);
            }
            function append(child) {
                if ((0, types_1.isString)(child))
                    element.appendChild(document.createTextNode(child));
                else if (child instanceof Node)
                    element.appendChild(child);
                else if (child instanceof NodeList || child instanceof HTMLCollection) {
                    for (const el of child) {
                        element.appendChild(el);
                    }
                }
                else if (child != null && child !== false)
                    throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
            }
            for (const child of children) {
                if ((0, types_1.isArray)(child)) {
                    for (const _child of child)
                        append(_child);
                }
                else
                    append(child);
            }
            return element;
        };
    };
    function createElement(tag, attrs, ...children) {
        return _createElement(tag)(attrs, ...children);
    }
    exports.createElement = createElement;
    exports.div = _createElement("div"), exports.span = _createElement("span"), exports.canvas = _createElement("canvas"), exports.link = _createElement("link"), exports.style = _createElement("style"), exports.a = _createElement("a"), exports.p = _createElement("p"), exports.i = _createElement("i"), exports.pre = _createElement("pre"), exports.button = _createElement("button"), exports.label = _createElement("label"), exports.input = _createElement("input"), exports.select = _createElement("select"), exports.option = _createElement("option"), exports.optgroup = _createElement("optgroup"), exports.textarea = _createElement("textarea");
    function createSVGElement(tag, attrs, ...children) {
        const element = document.createElementNS("http://www.w3.org/2000/svg", tag);
        for (const [attr, value] of (0, object_1.entries)(attrs !== null && attrs !== void 0 ? attrs : {})) {
            if (value == null || (0, types_1.isBoolean)(value) && !value)
                continue;
            element.setAttribute(attr, value);
        }
        function append(child) {
            if ((0, types_1.isString)(child))
                element.appendChild(document.createTextNode(child));
            else if (child instanceof Node)
                element.appendChild(child);
            else if (child instanceof NodeList || child instanceof HTMLCollection) {
                for (const el of child) {
                    element.appendChild(el);
                }
            }
            else if (child != null && child !== false)
                throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
        }
        for (const child of children) {
            if ((0, types_1.isArray)(child)) {
                for (const _child of child)
                    append(_child);
            }
            else
                append(child);
        }
        return element;
    }
    exports.createSVGElement = createSVGElement;
    function nbsp() {
        return document.createTextNode("\u00a0");
    }
    exports.nbsp = nbsp;
    function append(element, ...children) {
        for (const child of children)
            element.appendChild(child);
    }
    exports.append = append;
    function remove(element) {
        const parent = element.parentNode;
        if (parent != null) {
            parent.removeChild(element);
        }
    }
    exports.remove = remove;
    exports.removeElement = remove;
    function replaceWith(element, replacement) {
        const parent = element.parentNode;
        if (parent != null) {
            parent.replaceChild(replacement, element);
        }
    }
    exports.replaceWith = replaceWith;
    function prepend(element, ...nodes) {
        const first = element.firstChild;
        for (const node of nodes) {
            element.insertBefore(node, first);
        }
    }
    exports.prepend = prepend;
    function empty(node, attrs = false) {
        let child;
        while (child = node.firstChild) {
            node.removeChild(child);
        }
        if (attrs && node instanceof Element) {
            for (const attr of node.attributes) {
                node.removeAttributeNode(attr);
            }
        }
    }
    exports.empty = empty;
    function display(element) {
        element.style.display = "";
    }
    exports.display = display;
    function undisplay(element) {
        element.style.display = "none";
    }
    exports.undisplay = undisplay;
    function show(element) {
        element.style.visibility = "";
    }
    exports.show = show;
    function hide(element) {
        element.style.visibility = "hidden";
    }
    exports.hide = hide;
    function offset(element) {
        const rect = element.getBoundingClientRect();
        return {
            top: rect.top + window.pageYOffset - document.documentElement.clientTop,
            left: rect.left + window.pageXOffset - document.documentElement.clientLeft,
        };
    }
    exports.offset = offset;
    function matches(el, selector) {
        var _a, _b, _c;
        const p = Element.prototype;
        const f = (_c = (_b = (_a = p.matches) !== null && _a !== void 0 ? _a : p.webkitMatchesSelector) !== null && _b !== void 0 ? _b : p.mozMatchesSelector) !== null && _c !== void 0 ? _c : p.msMatchesSelector;
        return f.call(el, selector);
    }
    exports.matches = matches;
    function parent(el, selector) {
        let node = el;
        while (node = node.parentElement) {
            if (matches(node, selector))
                return node;
        }
        return null;
    }
    exports.parent = parent;
    function num(value) {
        return parseFloat(value) || 0;
    }
    function extents(el) {
        const style = getComputedStyle(el);
        return {
            border: {
                top: num(style.borderTopWidth),
                bottom: num(style.borderBottomWidth),
                left: num(style.borderLeftWidth),
                right: num(style.borderRightWidth),
            },
            margin: {
                top: num(style.marginTop),
                bottom: num(style.marginBottom),
                left: num(style.marginLeft),
                right: num(style.marginRight),
            },
            padding: {
                top: num(style.paddingTop),
                bottom: num(style.paddingBottom),
                left: num(style.paddingLeft),
                right: num(style.paddingRight),
            },
        };
    }
    exports.extents = extents;
    function size(el) {
        const rect = el.getBoundingClientRect();
        return {
            width: Math.ceil(rect.width),
            height: Math.ceil(rect.height),
        };
    }
    exports.size = size;
    function scroll_size(el) {
        return {
            width: Math.ceil(el.scrollWidth),
            height: Math.ceil(el.scrollHeight),
        };
    }
    exports.scroll_size = scroll_size;
    function outer_size(el) {
        const { margin: { left, right, top, bottom } } = extents(el);
        const { width, height } = size(el);
        return {
            width: Math.ceil(width + left + right),
            height: Math.ceil(height + top + bottom),
        };
    }
    exports.outer_size = outer_size;
    function content_size(el) {
        const { left, top } = el.getBoundingClientRect();
        const { padding } = extents(el);
        let width = 0;
        let height = 0;
        for (const child of el.children) {
            const rect = child.getBoundingClientRect();
            width = Math.max(width, Math.ceil(rect.left - left - padding.left + rect.width));
            height = Math.max(height, Math.ceil(rect.top - top - padding.top + rect.height));
        }
        return { width, height };
    }
    exports.content_size = content_size;
    function position(el, box, margin) {
        const { style } = el;
        style.left = `${box.x}px`;
        style.top = `${box.y}px`;
        style.width = `${box.width}px`;
        style.height = `${box.height}px`;
        if (margin == null)
            style.margin = "";
        else {
            const { top, right, bottom, left } = margin;
            style.margin = `${top}px ${right}px ${bottom}px ${left}px`;
        }
    }
    exports.position = position;
    function children(el) {
        return Array.from(el.children);
    }
    exports.children = children;
    class ClassList {
        constructor(el) {
            this.el = el;
            this.classList = el.classList;
        }
        get values() {
            const values = [];
            for (let i = 0; i < this.classList.length; i++) {
                const item = this.classList.item(i);
                if (item != null)
                    values.push(item);
            }
            return values;
        }
        has(cls) {
            return this.classList.contains(cls);
        }
        add(...classes) {
            for (const cls of classes)
                this.classList.add(cls);
            return this;
        }
        remove(...classes) {
            for (const cls of classes)
                this.classList.remove(cls);
            return this;
        }
        clear() {
            for (const cls of this.values) {
                if (cls != "bk")
                    this.classList.remove(cls);
            }
            return this;
        }
        toggle(cls, activate) {
            const add = activate != null ? activate : !this.has(cls);
            if (add)
                this.add(cls);
            else
                this.remove(cls);
            return this;
        }
    }
    exports.ClassList = ClassList;
    ClassList.__name__ = "ClassList";
    function classes(el) {
        return new ClassList(el);
    }
    exports.classes = classes;
    function toggle_attribute(el, attr, state) {
        if (state == null) {
            state = !el.hasAttribute(attr);
        }
        if (state)
            el.setAttribute(attr, "true");
        else
            el.removeAttribute(attr);
    }
    exports.toggle_attribute = toggle_attribute;
    (function (Keys) {
        Keys[Keys["Backspace"] = 8] = "Backspace";
        Keys[Keys["Tab"] = 9] = "Tab";
        Keys[Keys["Enter"] = 13] = "Enter";
        Keys[Keys["Esc"] = 27] = "Esc";
        Keys[Keys["PageUp"] = 33] = "PageUp";
        Keys[Keys["PageDown"] = 34] = "PageDown";
        Keys[Keys["Left"] = 37] = "Left";
        Keys[Keys["Up"] = 38] = "Up";
        Keys[Keys["Right"] = 39] = "Right";
        Keys[Keys["Down"] = 40] = "Down";
        Keys[Keys["Delete"] = 46] = "Delete";
    })(exports.Keys || (exports.Keys = {}));
    function undisplayed(el, fn) {
        const { display } = el.style;
        el.style.display = "none";
        try {
            return fn();
        }
        finally {
            el.style.display = display;
        }
    }
    exports.undisplayed = undisplayed;
    function unsized(el, fn) {
        return sized(el, {}, fn);
    }
    exports.unsized = unsized;
    function sized(el, size, fn) {
        const { width, height, position, display } = el.style;
        el.style.position = "absolute";
        el.style.display = "";
        el.style.width = size.width != null && size.width != Infinity ? `${size.width}px` : "auto";
        el.style.height = size.height != null && size.height != Infinity ? `${size.height}px` : "auto";
        try {
            return fn();
        }
        finally {
            el.style.position = position;
            el.style.display = display;
            el.style.width = width;
            el.style.height = height;
        }
    }
    exports.sized = sized;
    class StyleSheet {
        constructor(root) {
            this.root = root;
            this.known = new Set();
            this.style = (0, exports.style)({ type: "text/css" });
            prepend(root, this.style);
        }
        append(css) {
            if (!this.known.has(css)) {
                this.style.appendChild(document.createTextNode(css));
                this.known.add(css);
            }
        }
    }
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    exports.stylesheet = new StyleSheet(document.head);
    async function dom_ready() {
        if (document.readyState == "loading") {
            return new Promise((resolve, _reject) => {
                document.addEventListener("DOMContentLoaded", () => resolve(), { once: true });
            });
        }
    }
    exports.dom_ready = dom_ready;
},
/* styles/root.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.root = "bk-root";
    exports.default = `.bk-root{position:relative;width:auto;height:auto;box-sizing:border-box;font-family:Helvetica, Arial, sans-serif;font-size:13px;}.bk-root .bk,.bk-root .bk:before,.bk-root .bk:after{box-sizing:inherit;margin:0;border:0;padding:0;background-image:none;font-family:inherit;font-size:100%;line-height:1.42857143;}.bk-root pre.bk{font-family:Courier, monospace;}`;
},
/* core/visuals/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const line_1 = require(46) /* ./line */;
    __esExport("Line", line_1.Line);
    __esExport("LineScalar", line_1.LineScalar);
    __esExport("LineVector", line_1.LineVector);
    const fill_1 = require(49) /* ./fill */;
    __esExport("Fill", fill_1.Fill);
    __esExport("FillScalar", fill_1.FillScalar);
    __esExport("FillVector", fill_1.FillVector);
    const text_1 = require(50) /* ./text */;
    __esExport("Text", text_1.Text);
    __esExport("TextScalar", text_1.TextScalar);
    __esExport("TextVector", text_1.TextVector);
    const hatch_1 = require(51) /* ./hatch */;
    __esExport("Hatch", hatch_1.Hatch);
    __esExport("HatchScalar", hatch_1.HatchScalar);
    __esExport("HatchVector", hatch_1.HatchVector);
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../property_mixins */);
    const visual_1 = require(47) /* ./visual */;
    __esExport("VisualProperties", visual_1.VisualProperties);
    __esExport("VisualUniforms", visual_1.VisualUniforms);
    class Visuals {
        constructor(view) {
            this._visuals = [];
            for (const [prefix, mixin] of view.model._mixins) {
                const visual = (() => {
                    switch (mixin) {
                        case mixins.Line: return new line_1.Line(view, prefix);
                        case mixins.LineScalar: return new line_1.LineScalar(view, prefix);
                        case mixins.LineVector: return new line_1.LineVector(view, prefix);
                        case mixins.Fill: return new fill_1.Fill(view, prefix);
                        case mixins.FillScalar: return new fill_1.FillScalar(view, prefix);
                        case mixins.FillVector: return new fill_1.FillVector(view, prefix);
                        case mixins.Text: return new text_1.Text(view, prefix);
                        case mixins.TextScalar: return new text_1.TextScalar(view, prefix);
                        case mixins.TextVector: return new text_1.TextVector(view, prefix);
                        case mixins.Hatch: return new hatch_1.Hatch(view, prefix);
                        case mixins.HatchScalar: return new hatch_1.HatchScalar(view, prefix);
                        case mixins.HatchVector: return new hatch_1.HatchVector(view, prefix);
                        default:
                            throw new Error("unknown visual");
                    }
                })();
                if (visual instanceof visual_1.VisualProperties)
                    visual.update();
                this._visuals.push(visual);
                Object.defineProperty(this, prefix + visual.type, {
                    get() { return visual; },
                    configurable: false,
                    enumerable: true,
                });
            }
        }
        *[Symbol.iterator]() {
            yield* this._visuals;
        }
    }
    exports.Visuals = Visuals;
    Visuals.__name__ = "Visuals";
},
/* core/visuals/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(47) /* ./visual */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../property_mixins */);
    const color_1 = require(22) /* ../util/color */;
    const types_1 = require(8) /* ../util/types */;
    function resolve_line_dash(line_dash) {
        if ((0, types_1.isArray)(line_dash))
            return line_dash;
        else {
            switch (line_dash) {
                case "solid": return [];
                case "dashed": return [6];
                case "dotted": return [2, 4];
                case "dotdash": return [2, 4, 6, 4];
                case "dashdot": return [6, 4, 2, 4];
                default:
                    return line_dash.split(" ").map(Number).filter(types_1.isInteger);
            }
        }
    }
    exports.resolve_line_dash = resolve_line_dash;
    class Line extends visual_1.VisualProperties {
        get doit() {
            const color = this.line_color.get_value();
            const alpha = this.line_alpha.get_value();
            const width = this.line_width.get_value();
            return !(color == null || alpha == 0 || width == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.stroke();
            }
            return doit;
        }
        values() {
            return {
                color: this.line_color.get_value(),
                alpha: this.line_alpha.get_value(),
                width: this.line_width.get_value(),
                join: this.line_join.get_value(),
                cap: this.line_cap.get_value(),
                dash: this.line_dash.get_value(),
                offset: this.line_dash_offset.get_value(),
            };
        }
        set_value(ctx) {
            const color = this.line_color.get_value();
            const alpha = this.line_alpha.get_value();
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = this.line_width.get_value();
            ctx.lineJoin = this.line_join.get_value();
            ctx.lineCap = this.line_cap.get_value();
            ctx.lineDash = resolve_line_dash(this.line_dash.get_value());
            ctx.lineDashOffset = this.line_dash_offset.get_value();
        }
    }
    exports.Line = Line;
    Line.__name__ = "Line";
    class LineScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.line_color.value;
            const alpha = this.line_alpha.value;
            const width = this.line_width.value;
            return !(color == 0 || alpha == 0 || width == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.stroke();
            }
            return doit;
        }
        values() {
            return {
                color: this.line_color.value,
                alpha: this.line_alpha.value,
                width: this.line_width.value,
                join: this.line_join.value,
                cap: this.line_cap.value,
                dash: this.line_dash.value,
                offset: this.line_dash_offset.value,
            };
        }
        set_value(ctx) {
            const color = this.line_color.value;
            const alpha = this.line_alpha.value;
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = this.line_width.value;
            ctx.lineJoin = this.line_join.value;
            ctx.lineCap = this.line_cap.value;
            ctx.lineDash = resolve_line_dash(this.line_dash.value);
            ctx.lineDashOffset = this.line_dash_offset.value;
        }
    }
    exports.LineScalar = LineScalar;
    LineScalar.__name__ = "LineScalar";
    class LineVector extends visual_1.VisualUniforms {
        get doit() {
            const { line_color } = this;
            if (line_color.is_Scalar() && line_color.value == 0)
                return false;
            const { line_alpha } = this;
            if (line_alpha.is_Scalar() && line_alpha.value == 0)
                return false;
            const { line_width } = this;
            if (line_width.is_Scalar() && line_width.value == 0)
                return false;
            return true;
        }
        apply(ctx, i) {
            const { doit } = this;
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.stroke();
            }
            return doit;
        }
        values(i) {
            return {
                color: this.line_color.get(i),
                alpha: this.line_alpha.get(i),
                width: this.line_width.get(i),
                join: this.line_join.get(i),
                cap: this.line_cap.get(i),
                dash: this.line_dash.get(i),
                offset: this.line_dash_offset.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const color = this.line_color.get(i);
            const alpha = this.line_alpha.get(i);
            const width = this.line_width.get(i);
            const join = this.line_join.get(i);
            const cap = this.line_cap.get(i);
            const dash = this.line_dash.get(i);
            const offset = this.line_dash_offset.get(i);
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = width;
            ctx.lineJoin = join;
            ctx.lineCap = cap;
            ctx.lineDash = resolve_line_dash(dash);
            ctx.lineDashOffset = offset;
        }
    }
    exports.LineVector = LineVector;
    LineVector.__name__ = "LineVector";
    Line.prototype.type = "line";
    Line.prototype.attrs = Object.keys(mixins.Line);
    LineScalar.prototype.type = "line";
    LineScalar.prototype.attrs = Object.keys(mixins.LineScalar);
    LineVector.prototype.type = "line";
    LineVector.prototype.attrs = Object.keys(mixins.LineVector);
},
/* core/visuals/visual.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class VisualProperties {
        constructor(obj, prefix = "") {
            this.obj = obj;
            this.prefix = prefix;
            const self = this;
            this._props = [];
            for (const attr of this.attrs) {
                const prop = obj.model.properties[prefix + attr];
                prop.change.connect(() => this.update());
                self[attr] = prop;
                this._props.push(prop);
            }
        }
        *[Symbol.iterator]() {
            yield* this._props;
        }
        update() { }
    }
    exports.VisualProperties = VisualProperties;
    VisualProperties.__name__ = "VisualProperties";
    class VisualUniforms {
        constructor(obj, prefix = "") {
            this.obj = obj;
            this.prefix = prefix;
            for (const attr of this.attrs) {
                Object.defineProperty(this, attr, {
                    get() {
                        return obj[prefix + attr];
                    },
                });
            }
        }
        *[Symbol.iterator]() {
            for (const attr of this.attrs) {
                yield this.obj.model.properties[this.prefix + attr];
            }
        }
        update() { }
    }
    exports.VisualUniforms = VisualUniforms;
    VisualUniforms.__name__ = "VisualUniforms";
},
/* core/property_mixins.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const p = (0, tslib_1.__importStar)(require(18) /* ./properties */);
    const enums_1 = require(20) /* ./enums */;
    const k = (0, tslib_1.__importStar)(require(21) /* ./kinds */);
    const object_1 = require(13) /* ./util/object */;
    exports.Line = {
        line_color: [k.Nullable(k.Color), "black"],
        line_alpha: [k.Alpha, 1.0],
        line_width: [k.Number, 1],
        line_join: [enums_1.LineJoin, "bevel"],
        line_cap: [enums_1.LineCap, "butt"],
        line_dash: [k.Or(enums_1.LineDash, k.Array(k.Number)), []],
        line_dash_offset: [k.Number, 0],
    };
    exports.Fill = {
        fill_color: [k.Nullable(k.Color), "gray"],
        fill_alpha: [k.Alpha, 1.0],
    };
    exports.Hatch = {
        hatch_color: [k.Nullable(k.Color), "black"],
        hatch_alpha: [k.Alpha, 1.0],
        hatch_scale: [k.Number, 12.0],
        hatch_pattern: [k.Nullable(k.Or(enums_1.HatchPatternType, k.String)), null],
        hatch_weight: [k.Number, 1.0],
        hatch_extra: [k.Dict(k.AnyRef()), {}], // XXX: recursive imports
    };
    exports.Text = {
        text_color: [k.Nullable(k.Color), "#444444"],
        text_alpha: [k.Alpha, 1.0],
        text_font: [p.Font, "helvetica"],
        text_font_size: [k.FontSize, "16px"],
        text_font_style: [enums_1.FontStyle, "normal"],
        text_align: [enums_1.TextAlign, "left"],
        text_baseline: [enums_1.TextBaseline, "bottom"],
        text_line_height: [k.Number, 1.2],
    };
    exports.LineScalar = {
        line_color: [p.ColorScalar, "black"],
        line_alpha: [p.NumberScalar, 1.0],
        line_width: [p.NumberScalar, 1],
        line_join: [p.LineJoinScalar, "bevel"],
        line_cap: [p.LineCapScalar, "butt"],
        line_dash: [p.LineDashScalar, []],
        line_dash_offset: [p.NumberScalar, 0],
    };
    exports.FillScalar = {
        fill_color: [p.ColorScalar, "gray"],
        fill_alpha: [p.NumberScalar, 1.0],
    };
    exports.HatchScalar = {
        hatch_color: [p.ColorScalar, "black"],
        hatch_alpha: [p.NumberScalar, 1.0],
        hatch_scale: [p.NumberScalar, 12.0],
        hatch_pattern: [p.NullStringScalar, null],
        hatch_weight: [p.NumberScalar, 1.0],
        hatch_extra: [p.AnyScalar, {}],
    };
    exports.TextScalar = {
        text_color: [p.ColorScalar, "#444444"],
        text_alpha: [p.NumberScalar, 1.0],
        text_font: [p.FontScalar, "helvetica"],
        text_font_size: [p.FontSizeScalar, "16px"],
        text_font_style: [p.FontStyleScalar, "normal"],
        text_align: [p.TextAlignScalar, "left"],
        text_baseline: [p.TextBaselineScalar, "bottom"],
        text_line_height: [p.NumberScalar, 1.2],
    };
    exports.LineVector = {
        line_color: [p.ColorSpec, "black"],
        line_alpha: [p.NumberSpec, 1.0],
        line_width: [p.NumberSpec, 1],
        line_join: [p.LineJoinSpec, "bevel"],
        line_cap: [p.LineCapSpec, "butt"],
        line_dash: [p.LineDashSpec, []],
        line_dash_offset: [p.NumberSpec, 0],
    };
    exports.FillVector = {
        fill_color: [p.ColorSpec, "gray"],
        fill_alpha: [p.NumberSpec, 1.0],
    };
    exports.HatchVector = {
        hatch_color: [p.ColorSpec, "black"],
        hatch_alpha: [p.NumberSpec, 1.0],
        hatch_scale: [p.NumberSpec, 12.0],
        hatch_pattern: [p.NullStringSpec, null],
        hatch_weight: [p.NumberSpec, 1.0],
        hatch_extra: [p.AnyScalar, {}],
    };
    exports.TextVector = {
        text_color: [p.ColorSpec, "#444444"],
        text_alpha: [p.NumberSpec, 1.0],
        text_font: [p.FontSpec, "helvetica"],
        text_font_size: [p.FontSizeSpec, "16px"],
        text_font_style: [p.FontStyleSpec, "normal"],
        text_align: [p.TextAlignSpec, "left"],
        text_baseline: [p.TextBaselineSpec, "bottom"],
        text_line_height: [p.NumberSpec, 1.2],
    };
    function attrs_of(model, prefix, mixin, prefixed = false) {
        const attrs = {};
        for (const attr of (0, object_1.keys)(mixin)) {
            const prefixed_attr = `${prefix}${attr}`;
            const value = model[prefixed_attr];
            attrs[prefixed ? prefixed_attr : attr] = value;
        }
        return attrs;
    }
    exports.attrs_of = attrs_of;
},
/* core/visuals/fill.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(47) /* ./visual */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../property_mixins */);
    const color_1 = require(22) /* ../util/color */;
    class Fill extends visual_1.VisualProperties {
        get doit() {
            const color = this.fill_color.get_value();
            const alpha = this.fill_alpha.get_value();
            return !(color == null || alpha == 0);
        }
        apply(ctx, rule) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.fill(rule);
            }
            return doit;
        }
        values() {
            return {
                color: this.fill_color.get_value(),
                alpha: this.fill_alpha.get_value(),
            };
        }
        set_value(ctx) {
            const color = this.fill_color.get_value();
            const alpha = this.fill_alpha.get_value();
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.Fill = Fill;
    Fill.__name__ = "Fill";
    class FillScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.fill_color.value;
            const alpha = this.fill_alpha.value;
            return !(color == 0 || alpha == 0);
        }
        apply(ctx, rule) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.fill(rule);
            }
            return doit;
        }
        values() {
            return {
                color: this.fill_color.value,
                alpha: this.fill_alpha.value,
            };
        }
        set_value(ctx) {
            const color = this.fill_color.value;
            const alpha = this.fill_alpha.value;
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.FillScalar = FillScalar;
    FillScalar.__name__ = "FillScalar";
    class FillVector extends visual_1.VisualUniforms {
        get doit() {
            const { fill_color } = this;
            if (fill_color.is_Scalar() && fill_color.value == 0)
                return false;
            const { fill_alpha } = this;
            if (fill_alpha.is_Scalar() && fill_alpha.value == 0)
                return false;
            return true;
        }
        apply(ctx, i, rule) {
            const { doit } = this;
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.fill(rule);
            }
            return doit;
        }
        values(i) {
            return {
                color: this.fill_color.get(i),
                alpha: this.fill_alpha.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const color = this.fill_color.get(i);
            const alpha = this.fill_alpha.get(i);
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.FillVector = FillVector;
    FillVector.__name__ = "FillVector";
    Fill.prototype.type = "fill";
    Fill.prototype.attrs = Object.keys(mixins.Fill);
    FillScalar.prototype.type = "fill";
    FillScalar.prototype.attrs = Object.keys(mixins.FillScalar);
    FillVector.prototype.type = "fill";
    FillVector.prototype.attrs = Object.keys(mixins.FillVector);
},
/* core/visuals/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(47) /* ./visual */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../property_mixins */);
    const color_1 = require(22) /* ../util/color */;
    class Text extends visual_1.VisualProperties {
        get doit() {
            const color = this.text_color.get_value();
            const alpha = this.text_alpha.get_value();
            return !(color == null || alpha == 0);
        }
        values() {
            return {
                color: this.text_color.get_value(),
                alpha: this.text_alpha.get_value(),
                font: this.text_font.get_value(),
                font_size: this.text_font_size.get_value(),
                font_style: this.text_font_style.get_value(),
                align: this.text_align.get_value(),
                baseline: this.text_baseline.get_value(),
                line_height: this.text_line_height.get_value(),
            };
        }
        set_value(ctx) {
            const color = this.text_color.get_value();
            const alpha = this.text_alpha.get_value();
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.font = this.font_value();
            ctx.textAlign = this.text_align.get_value();
            ctx.textBaseline = this.text_baseline.get_value();
        }
        font_value() {
            const style = this.text_font_style.get_value();
            const size = this.text_font_size.get_value();
            const face = this.text_font.get_value();
            return `${style} ${size} ${face}`;
        }
    }
    exports.Text = Text;
    Text.__name__ = "Text";
    class TextScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.text_color.value;
            const alpha = this.text_alpha.value;
            return !(color == 0 || alpha == 0);
        }
        values() {
            return {
                color: this.text_color.value,
                alpha: this.text_alpha.value,
                font: this.text_font.value,
                font_size: this.text_font_size.value,
                font_style: this.text_font_style.value,
                align: this.text_align.value,
                baseline: this.text_baseline.value,
                line_height: this.text_line_height.value,
            };
        }
        set_value(ctx) {
            const color = this.text_color.value;
            const alpha = this.text_alpha.value;
            const font = this.font_value();
            const align = this.text_align.value;
            const baseline = this.text_baseline.value;
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        }
        font_value() {
            const style = this.text_font_style.value;
            const size = this.text_font_size.value;
            const face = this.text_font.value;
            return `${style} ${size} ${face}`;
        }
    }
    exports.TextScalar = TextScalar;
    TextScalar.__name__ = "TextScalar";
    class TextVector extends visual_1.VisualUniforms {
        values(i) {
            return {
                color: this.text_color.get(i),
                alpha: this.text_alpha.get(i),
                font: this.text_font.get(i),
                font_size: this.text_font_size.get(i),
                font_style: this.text_font_style.get(i),
                align: this.text_align.get(i),
                baseline: this.text_baseline.get(i),
                line_height: this.text_line_height.get(i),
            };
        }
        get doit() {
            const { text_color } = this;
            if (text_color.is_Scalar() && text_color.value == 0)
                return false;
            const { text_alpha } = this;
            if (text_alpha.is_Scalar() && text_alpha.value == 0)
                return false;
            return true;
        }
        set_vectorize(ctx, i) {
            const color = this.text_color.get(i);
            const alpha = this.text_alpha.get(i);
            const font = this.font_value(i);
            const align = this.text_align.get(i);
            const baseline = this.text_baseline.get(i);
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        }
        font_value(i) {
            const style = this.text_font_style.get(i);
            const size = this.text_font_size.get(i);
            const face = this.text_font.get(i);
            return `${style} ${size} ${face}`;
        }
    }
    exports.TextVector = TextVector;
    TextVector.__name__ = "TextVector";
    Text.prototype.type = "text";
    Text.prototype.attrs = Object.keys(mixins.Text);
    TextScalar.prototype.type = "text";
    TextScalar.prototype.attrs = Object.keys(mixins.TextScalar);
    TextVector.prototype.type = "text";
    TextVector.prototype.attrs = Object.keys(mixins.TextVector);
},
/* core/visuals/hatch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(47) /* ./visual */;
    const patterns_1 = require(52) /* ./patterns */;
    const p = (0, tslib_1.__importStar)(require(18) /* ../properties */);
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../property_mixins */);
    class Hatch extends visual_1.VisualProperties {
        constructor() {
            super(...arguments);
            this._update_iteration = 0;
        }
        update() {
            this._update_iteration++;
            this._hatch_image = null;
            if (!this.doit)
                return;
            const color = this.hatch_color.get_value();
            const alpha = this.hatch_alpha.get_value();
            const scale = this.hatch_scale.get_value();
            const pattern = this.hatch_pattern.get_value();
            const weight = this.hatch_weight.get_value();
            const finalize = (image) => {
                this._hatch_image = image;
            };
            const textures = this.hatch_extra.get_value();
            const texture = textures[pattern];
            if (texture != null) {
                const image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    const { _update_iteration } = this;
                    image.then((image) => {
                        if (this._update_iteration == _update_iteration) {
                            finalize(image);
                            this.obj.request_render();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                const layer = this.obj.canvas.create_layer();
                const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        }
        get doit() {
            const color = this.hatch_color.get_value();
            const alpha = this.hatch_alpha.get_value();
            const pattern = this.hatch_pattern.get_value();
            return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        }
        apply(ctx, rule) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(() => ctx.fill(rule));
            }
            return doit;
        }
        set_value(ctx) {
            const pattern = this.pattern(ctx);
            ctx.fillStyle = pattern !== null && pattern !== void 0 ? pattern : "transparent";
        }
        pattern(ctx) {
            const image = this._hatch_image;
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition());
        }
        repetition() {
            const pattern = this.hatch_pattern.get_value();
            const texture = this.hatch_extra.get_value()[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        }
    }
    exports.Hatch = Hatch;
    Hatch.__name__ = "Hatch";
    class HatchScalar extends visual_1.VisualUniforms {
        constructor() {
            super(...arguments);
            this._static_doit = false;
            this._update_iteration = 0;
        }
        _compute_static_doit() {
            const color = this.hatch_color.value;
            const alpha = this.hatch_alpha.value;
            const pattern = this.hatch_pattern.value;
            return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        }
        update() {
            this._update_iteration++;
            const n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit)
                return;
            const color = this.hatch_color.value;
            const alpha = this.hatch_alpha.value;
            const scale = this.hatch_scale.value;
            const pattern = this.hatch_pattern.value;
            const weight = this.hatch_weight.value;
            const finalize = (image) => {
                this._hatch_image = new p.UniformScalar(image, n);
            };
            const textures = this.hatch_extra.value;
            const texture = textures[pattern];
            if (texture != null) {
                const image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    const { _update_iteration } = this;
                    image.then((image) => {
                        if (this._update_iteration == _update_iteration) {
                            finalize(image);
                            this.obj.request_render();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                const layer = this.obj.canvas.create_layer();
                const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        }
        get doit() {
            return this._static_doit;
        }
        apply(ctx, rule) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(() => ctx.fill(rule));
            }
            return doit;
        }
        set_value(ctx) {
            var _a;
            ctx.fillStyle = (_a = this.pattern(ctx)) !== null && _a !== void 0 ? _a : "transparent";
        }
        pattern(ctx) {
            const image = this._hatch_image.value;
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition());
        }
        repetition() {
            const pattern = this.hatch_pattern.value;
            const texture = this.hatch_extra.value[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        }
    }
    exports.HatchScalar = HatchScalar;
    HatchScalar.__name__ = "HatchScalar";
    class HatchVector extends visual_1.VisualUniforms {
        constructor() {
            super(...arguments);
            this._static_doit = false;
            this._update_iteration = 0;
        }
        _compute_static_doit() {
            const { hatch_color } = this;
            if (hatch_color.is_Scalar() && hatch_color.value == 0)
                return false;
            const { hatch_alpha } = this;
            if (hatch_alpha.is_Scalar() && hatch_alpha.value == 0)
                return false;
            const { hatch_pattern } = this;
            if (hatch_pattern.is_Scalar()) {
                const pattern = hatch_pattern.value;
                if (pattern == " " || pattern == "blank" || pattern == null)
                    return false;
            }
            return true;
        }
        update() {
            this._update_iteration++;
            const n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit)
                return;
            const resolve_image = (pattern, color, alpha, scale, weight, finalize) => {
                const textures = this.hatch_extra.value;
                const texture = textures[pattern];
                if (texture != null) {
                    const image = texture.get_pattern(color, alpha, scale, weight);
                    if (image instanceof Promise) {
                        const { _update_iteration } = this;
                        image.then((image) => {
                            if (this._update_iteration == _update_iteration) {
                                finalize(image);
                                this.obj.request_render();
                            }
                        });
                    }
                    else {
                        finalize(image);
                    }
                }
                else {
                    const layer = this.obj.canvas.create_layer();
                    const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                    finalize(image);
                }
            };
            if (this.hatch_color.is_Scalar() &&
                this.hatch_alpha.is_Scalar() &&
                this.hatch_scale.is_Scalar() &&
                this.hatch_pattern.is_Scalar() &&
                this.hatch_weight.is_Scalar()) {
                const color = this.hatch_color.value;
                const alpha = this.hatch_alpha.value;
                const scale = this.hatch_scale.value;
                const pattern = this.hatch_pattern.value;
                const weight = this.hatch_weight.value;
                resolve_image(pattern, color, alpha, scale, weight, (image) => {
                    this._hatch_image = new p.UniformScalar(image, n);
                });
            }
            else {
                const images = new Array(n);
                images.fill(null);
                this._hatch_image = new p.UniformVector(images);
                for (let i = 0; i < n; i++) {
                    const color = this.hatch_color.get(i);
                    const alpha = this.hatch_alpha.get(i);
                    const scale = this.hatch_scale.get(i);
                    const pattern = this.hatch_pattern.get(i);
                    const weight = this.hatch_weight.get(i);
                    resolve_image(pattern, color, alpha, scale, weight, (image) => {
                        images[i] = image;
                    });
                }
            }
        }
        get doit() {
            return this._static_doit;
        }
        apply(ctx, i, rule) {
            const { doit } = this;
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.layer.undo_transform(() => ctx.fill(rule));
            }
            return doit;
        }
        set_vectorize(ctx, i) {
            var _a;
            ctx.fillStyle = (_a = this.pattern(ctx, i)) !== null && _a !== void 0 ? _a : "transparent";
        }
        pattern(ctx, i) {
            const image = this._hatch_image.get(i);
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition(i));
        }
        repetition(i) {
            const pattern = this.hatch_pattern.get(i);
            const texture = this.hatch_extra.value[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        }
    }
    exports.HatchVector = HatchVector;
    HatchVector.__name__ = "HatchVector";
    Hatch.prototype.type = "hatch";
    Hatch.prototype.attrs = Object.keys(mixins.Hatch);
    HatchScalar.prototype.type = "hatch";
    HatchScalar.prototype.attrs = Object.keys(mixins.HatchScalar);
    HatchVector.prototype.type = "hatch";
    HatchVector.prototype.attrs = Object.keys(mixins.HatchVector);
},
/* core/visuals/patterns.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const color_1 = require(22) /* ../util/color */;
    function _horz(ctx, h, h2) {
        ctx.moveTo(0, h2 + 0.5);
        ctx.lineTo(h, h2 + 0.5);
        ctx.stroke();
    }
    function _vert(ctx, h, h2) {
        ctx.moveTo(h2 + 0.5, 0);
        ctx.lineTo(h2 + 0.5, h);
        ctx.stroke();
    }
    function _x(ctx, h) {
        ctx.moveTo(0, h);
        ctx.lineTo(h, 0);
        ctx.stroke();
        ctx.moveTo(0, 0);
        ctx.lineTo(h, h);
        ctx.stroke();
    }
    exports.hatch_aliases = {
        " ": "blank",
        ".": "dot",
        o: "ring",
        "-": "horizontal_line",
        "|": "vertical_line",
        "+": "cross",
        "\"": "horizontal_dash",
        ":": "vertical_dash",
        "@": "spiral",
        "/": "right_diagonal_line",
        "\\": "left_diagonal_line",
        x: "diagonal_cross",
        ",": "right_diagonal_dash",
        "`": "left_diagonal_dash",
        v: "horizontal_wave",
        ">": "vertical_wave",
        "*": "criss_cross",
    };
    function get_pattern(layer, pattern, color, alpha, scale, weight) {
        layer.resize(scale, scale);
        layer.prepare();
        create_hatch_canvas(layer.ctx, pattern, color, alpha, scale, weight);
        return layer.canvas;
    }
    exports.get_pattern = get_pattern;
    function create_hatch_canvas(ctx, hatch_pattern, hatch_color, hatch_alpha, hatch_scale, hatch_weight) {
        var _a;
        const h = hatch_scale;
        const h2 = h / 2;
        const h4 = h2 / 2;
        const color = (0, color_1.color2css)(hatch_color, hatch_alpha);
        ctx.strokeStyle = color;
        ctx.fillStyle = color;
        ctx.lineCap = "square";
        ctx.lineWidth = hatch_weight;
        switch ((_a = exports.hatch_aliases[hatch_pattern]) !== null && _a !== void 0 ? _a : hatch_pattern) {
            // we should not need these if code conditions on hatch.doit, but
            // include them here just for completeness
            case "blank":
                break;
            case "dot":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.fill();
                break;
            case "ring":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.stroke();
                break;
            case "horizontal_line":
                _horz(ctx, h, h2);
                break;
            case "vertical_line":
                _vert(ctx, h, h2);
                break;
            case "cross":
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            case "horizontal_dash":
                _horz(ctx, h2, h2);
                break;
            case "vertical_dash":
                _vert(ctx, h2, h2);
                break;
            case "spiral": {
                const h30 = h / 30;
                ctx.moveTo(h2, h2);
                for (let i = 0; i < 360; i++) {
                    const angle = 0.1 * i;
                    const x = h2 + (h30 * angle) * Math.cos(angle);
                    const y = h2 + (h30 * angle) * Math.sin(angle);
                    ctx.lineTo(x, y);
                }
                ctx.stroke();
                break;
            }
            case "right_diagonal_line":
                ctx.moveTo(-h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(5 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "left_diagonal_line":
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(-h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(5 * h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "diagonal_cross":
                _x(ctx, h);
                break;
            case "right_diagonal_dash":
                ctx.moveTo(h4 + 0.5, 3 * h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, h4 + 0.5);
                ctx.stroke();
                break;
            case "left_diagonal_dash":
                ctx.moveTo(h4 + 0.5, h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, 3 * h4 + 0.5);
                ctx.stroke();
                break;
            case "horizontal_wave":
                ctx.moveTo(0, h4);
                ctx.lineTo(h2, 3 * h4);
                ctx.lineTo(h, h4);
                ctx.stroke();
                break;
            case "vertical_wave":
                ctx.moveTo(h4, 0);
                ctx.lineTo(3 * h4, h2);
                ctx.lineTo(h4, h);
                ctx.stroke();
                break;
            case "criss_cross":
                _x(ctx, h);
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
        }
    }
},
/* model.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const has_props_1 = require(14) /* ./core/has_props */;
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(13) /* ./core/util/object */;
    const eq_1 = require(26) /* ./core/util/eq */;
    const logging_1 = require(19) /* ./core/logging */;
    class Model extends has_props_1.HasProps {
        constructor(attrs) {
            super(attrs);
        }
        get is_syncable() {
            return this.syncable;
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.id, that.id) && super[eq_1.equals](that, cmp);
        }
        initialize() {
            super.initialize();
            this._js_callbacks = new Map();
        }
        connect_signals() {
            super.connect_signals();
            this._update_property_callbacks();
            this.connect(this.properties.js_property_callbacks.change, () => this._update_property_callbacks());
            this.connect(this.properties.js_event_callbacks.change, () => this._update_event_callbacks());
            this.connect(this.properties.subscribed_events.change, () => this._update_event_callbacks());
        }
        /*protected*/ _process_event(event) {
            var _b;
            for (const callback of (_b = this.js_event_callbacks[event.event_name]) !== null && _b !== void 0 ? _b : [])
                callback.execute(event);
            if (this.document != null && this.subscribed_events.some((m) => m == event.event_name))
                this.document.event_manager.send_event(event);
        }
        trigger_event(event) {
            if (this.document != null) {
                event.origin = this;
                this.document.event_manager.trigger(event);
            }
        }
        _update_event_callbacks() {
            if (this.document == null) {
                logging_1.logger.warn("WARNING: Document not defined for updating event callbacks");
                return;
            }
            this.document.event_manager.subscribed_models.add(this);
        }
        _update_property_callbacks() {
            const signal_for = (event) => {
                const [evt, attr = null] = event.split(":");
                return attr != null ? this.properties[attr][evt] : this[evt];
            };
            for (const [event, callbacks] of this._js_callbacks) {
                const signal = signal_for(event);
                for (const cb of callbacks)
                    this.disconnect(signal, cb);
            }
            this._js_callbacks.clear();
            for (const [event, callbacks] of (0, object_1.entries)(this.js_property_callbacks)) {
                const wrappers = callbacks.map((cb) => () => cb.execute(this));
                this._js_callbacks.set(event, wrappers);
                const signal = signal_for(event);
                for (const cb of wrappers)
                    this.connect(signal, cb);
            }
        }
        _doc_attached() {
            if (!(0, object_1.isEmpty)(this.js_event_callbacks) || this.subscribed_events.length != 0)
                this._update_event_callbacks();
        }
        _doc_detached() {
            this.document.event_manager.subscribed_models.delete(this);
        }
        select(selector) {
            if ((0, types_1.isString)(selector))
                return [...this.references()].filter((ref) => ref instanceof Model && ref.name === selector);
            else if (selector.prototype instanceof has_props_1.HasProps)
                return [...this.references()].filter((ref) => ref instanceof selector);
            else
                throw new Error("invalid selector");
        }
        select_one(selector) {
            const result = this.select(selector);
            switch (result.length) {
                case 0:
                    return null;
                case 1:
                    return result[0];
                default:
                    throw new Error("found more than one object matching given selector");
            }
        }
    }
    exports.Model = Model;
    _a = Model;
    Model.__name__ = "Model";
    (() => {
        _a.define(({ Any, Unknown, Boolean, String, Array, Dict, Nullable }) => ({
            tags: [Array(Unknown), []],
            name: [Nullable(String), null],
            js_property_callbacks: [Dict(Array(Any /*TODO*/)), {}],
            js_event_callbacks: [Dict(Array(Any /*TODO*/)), {}],
            subscribed_events: [Array(String), []],
            syncable: [Boolean, true],
        }));
    })();
},
/* models/canvas/coordinates.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a, _b;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const model_1 = require(53) /* ../../model */;
    const scale_1 = require(55) /* ../scales/scale */;
    const linear_scale_1 = require(59) /* ../scales/linear_scale */;
    const log_scale_1 = require(61) /* ../scales/log_scale */;
    const categorical_scale_1 = require(62) /* ../scales/categorical_scale */;
    const range_1 = require(57) /* ../ranges/range */;
    const data_range1d_1 = require(63) /* ../ranges/data_range1d */;
    const factor_range_1 = require(67) /* ../ranges/factor_range */;
    class CoordinateTransform {
        constructor(x_scale, y_scale) {
            this.x_scale = x_scale;
            this.y_scale = y_scale;
            this.x_source = this.x_scale.source_range;
            this.y_source = this.y_scale.source_range;
            this.ranges = [this.x_source, this.y_source];
            this.scales = [this.x_scale, this.y_scale];
        }
        map_to_screen(xs, ys) {
            const sxs = this.x_scale.v_compute(xs);
            const sys = this.y_scale.v_compute(ys);
            return [sxs, sys];
        }
        map_from_screen(sxs, sys) {
            const xs = this.x_scale.v_invert(sxs);
            const ys = this.y_scale.v_invert(sys);
            return [xs, ys];
        }
    }
    exports.CoordinateTransform = CoordinateTransform;
    CoordinateTransform.__name__ = "CoordinateTransform";
    class CoordinateMapping extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        get x_ranges() {
            return new Map([["default", this.x_source]]);
        }
        get y_ranges() {
            return new Map([["default", this.y_source]]);
        }
        _get_scale(range, scale, target) {
            const factor_range = range instanceof factor_range_1.FactorRange;
            const categorical_scale = scale instanceof categorical_scale_1.CategoricalScale;
            if (factor_range != categorical_scale) {
                throw new Error(`Range ${range.type} is incompatible is Scale ${scale.type}`);
            }
            if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d)
                range.scale_hint = "log";
            const derived_scale = scale.clone();
            derived_scale.setv({ source_range: range, target_range: target });
            return derived_scale;
        }
        get_transform(frame) {
            const { x_source, x_scale, x_target } = this;
            const x_source_scale = this._get_scale(x_source, x_scale, x_target);
            const { y_source, y_scale, y_target } = this;
            const y_source_scale = this._get_scale(y_source, y_scale, y_target);
            const xscale = new CompositeScale({
                source_scale: x_source_scale, source_range: x_source_scale.source_range,
                target_scale: frame.x_scale, target_range: frame.x_target,
            });
            const yscale = new CompositeScale({
                source_scale: y_source_scale, source_range: y_source_scale.source_range,
                target_scale: frame.y_scale, target_range: frame.y_target,
            });
            return new CoordinateTransform(xscale, yscale);
        }
    }
    exports.CoordinateMapping = CoordinateMapping;
    _a = CoordinateMapping;
    CoordinateMapping.__name__ = "CoordinateMapping";
    (() => {
        _a.define(({ Ref }) => ({
            x_source: [Ref(range_1.Range), () => new data_range1d_1.DataRange1d()],
            y_source: [Ref(range_1.Range), () => new data_range1d_1.DataRange1d()],
            x_scale: [Ref(scale_1.Scale), () => new linear_scale_1.LinearScale()],
            y_scale: [Ref(scale_1.Scale), () => new linear_scale_1.LinearScale()],
            x_target: [Ref(range_1.Range)],
            y_target: [Ref(range_1.Range)],
        }));
    })();
    class CompositeScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const source_compute = this.source_scale.s_compute;
            const target_compute = this.target_scale.s_compute;
            return (x) => target_compute(source_compute(x));
        }
        get s_invert() {
            const source_invert = this.source_scale.s_invert;
            const target_invert = this.target_scale.s_invert;
            return (sx) => source_invert(target_invert(sx));
        }
        compute(x) {
            return this.s_compute(x);
        }
        v_compute(xs) {
            const { s_compute } = this;
            return (0, arrayable_1.map)(xs, s_compute); // XXX
        }
        invert(sx) {
            return this.s_invert(sx);
        }
        v_invert(sxs) {
            const { s_invert } = this;
            return (0, arrayable_1.map)(sxs, s_invert); // XXX
        }
    }
    exports.CompositeScale = CompositeScale;
    _b = CompositeScale;
    CompositeScale.__name__ = "CompositeScale";
    (() => {
        _b.internal(({ Ref }) => ({
            source_scale: [Ref(scale_1.Scale)],
            target_scale: [Ref(scale_1.Scale)],
        }));
    })();
},
/* models/scales/scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const transform_1 = require(56) /* ../transforms/transform */;
    const range_1 = require(57) /* ../ranges/range */;
    const range1d_1 = require(58) /* ../ranges/range1d */;
    const types_1 = require(24) /* ../../core/types */;
    class Scale extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        compute(x) {
            return this.s_compute(x);
        }
        v_compute(xs) {
            const result = new types_1.ScreenArray(xs.length);
            const { s_compute } = this;
            for (let i = 0; i < xs.length; i++) {
                result[i] = s_compute(xs[i]);
            }
            return result;
        }
        invert(sx) {
            return this.s_invert(sx);
        }
        v_invert(sxs) {
            const result = new Float64Array(sxs.length);
            const { s_invert } = this;
            for (let i = 0; i < sxs.length; i++) {
                result[i] = s_invert(sxs[i]);
            }
            return result;
        }
        r_compute(x0, x1) {
            const { s_compute } = this;
            if (this.target_range.is_reversed)
                return [s_compute(x1), s_compute(x0)];
            else
                return [s_compute(x0), s_compute(x1)];
        }
        r_invert(sx0, sx1) {
            const { s_invert } = this;
            if (this.target_range.is_reversed)
                return [s_invert(sx1), s_invert(sx0)];
            else
                return [s_invert(sx0), s_invert(sx1)];
        }
    }
    exports.Scale = Scale;
    _a = Scale;
    Scale.__name__ = "Scale";
    (() => {
        _a.internal(({ Ref }) => ({
            source_range: [Ref(range_1.Range)],
            target_range: [Ref(range1d_1.Range1d)],
        }));
    })();
},
/* models/transforms/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(53) /* ../../model */;
    class Transform extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Transform = Transform;
    Transform.__name__ = "Transform";
},
/* models/ranges/range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(53) /* ../../model */;
    class Range extends model_1.Model {
        constructor(attrs) {
            super(attrs);
            this.have_updated_interactively = false;
        }
        get is_reversed() {
            return this.start > this.end;
        }
        get is_valid() {
            return isFinite(this.min) && isFinite(this.max);
        }
        get span() {
            return Math.abs(this.end - this.start);
        }
    }
    exports.Range = Range;
    _a = Range;
    Range.__name__ = "Range";
    (() => {
        _a.define(({ Number, Tuple, Or, Auto, Nullable }) => ({
            bounds: [Nullable(Or(Tuple(Nullable(Number), Nullable(Number)), Auto)), null],
            min_interval: [Nullable(Number), null],
            max_interval: [Nullable(Number), null],
        }));
        _a.internal(({ Array, AnyRef }) => ({
            plots: [Array(AnyRef()), []],
        }));
    })();
},
/* models/ranges/range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const range_1 = require(57) /* ./range */;
    class Range1d extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
        _set_auto_bounds() {
            if (this.bounds == "auto") {
                const min = Math.min(this._reset_start, this._reset_end);
                const max = Math.max(this._reset_start, this._reset_end);
                this.setv({ bounds: [min, max] }, { silent: true });
            }
        }
        initialize() {
            super.initialize();
            this._set_auto_bounds();
        }
        get min() {
            return Math.min(this.start, this.end);
        }
        get max() {
            return Math.max(this.start, this.end);
        }
        reset() {
            this._set_auto_bounds();
            const { _reset_start, _reset_end } = this;
            if (this.start != _reset_start || this.end != _reset_end)
                this.setv({ start: _reset_start, end: _reset_end });
            else
                this.change.emit();
        }
        map(fn) {
            return new Range1d({ start: fn(this.start), end: fn(this.end) });
        }
        widen(v) {
            let { start, end } = this;
            if (this.is_reversed) {
                start += v;
                end -= v;
            }
            else {
                start -= v;
                end += v;
            }
            return new Range1d({ start, end });
        }
    }
    exports.Range1d = Range1d;
    _a = Range1d;
    Range1d.__name__ = "Range1d";
    (() => {
        _a.define(({ Number, Nullable }) => ({
            start: [Number, 0],
            end: [Number, 1],
            reset_start: [Nullable(Number), null, {
                    on_update(reset_start, self) {
                        self._reset_start = reset_start !== null && reset_start !== void 0 ? reset_start : self.start;
                    },
                }],
            reset_end: [Nullable(Number), null, {
                    on_update(reset_end, self) {
                        self._reset_end = reset_end !== null && reset_end !== void 0 ? reset_end : self.end;
                    },
                }],
        }));
    })();
},
/* models/scales/linear_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(60) /* ./continuous_scale */;
    class LinearScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset] = this._linear_compute_state();
            return (x) => factor * x + offset;
        }
        get s_invert() {
            const [factor, offset] = this._linear_compute_state();
            return (sx) => (sx - offset) / factor;
        }
        /*protected*/ _linear_compute_state() {
            //
            //  (t1 - t0)       (t1 - t0)
            //  --------- * x - --------- * s0 + t0
            //  (s1 - s0)       (s1 - s0)
            //
            // [  factor  ]     [    offset    ]
            //
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const factor = (target_end - target_start) / (source_end - source_start);
            const offset = -(factor * source_start) + target_start;
            return [factor, offset];
        }
    }
    exports.LinearScale = LinearScale;
    LinearScale.__name__ = "LinearScale";
},
/* models/scales/continuous_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(55) /* ./scale */;
    class ContinuousScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ContinuousScale = ContinuousScale;
    ContinuousScale.__name__ = "ContinuousScale";
},
/* models/scales/log_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(60) /* ./continuous_scale */;
    class LogScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            return (x) => {
                if (inter_factor == 0)
                    return 0;
                else {
                    const _x = (Math.log(x) - inter_offset) / inter_factor;
                    return isFinite(_x) ? _x * factor + offset : NaN;
                }
            };
        }
        get s_invert() {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            return (xprime) => {
                const value = (xprime - offset) / factor;
                return Math.exp(inter_factor * value + inter_offset);
            };
        }
        _get_safe_factor(orig_start, orig_end) {
            let start = orig_start < 0 ? 0 : orig_start;
            let end = orig_end < 0 ? 0 : orig_end;
            if (start == end) {
                if (start == 0)
                    [start, end] = [1, 10];
                else {
                    const log_val = Math.log(start) / Math.log(10);
                    start = 10 ** Math.floor(log_val);
                    if (Math.ceil(log_val) != Math.floor(log_val))
                        end = 10 ** Math.ceil(log_val);
                    else
                        end = 10 ** (Math.ceil(log_val) + 1);
                }
            }
            return [start, end];
        }
        /*protected*/ _compute_state() {
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const screen_range = target_end - target_start;
            const [start, end] = this._get_safe_factor(source_start, source_end);
            let inter_factor;
            let inter_offset;
            if (start == 0) {
                inter_factor = Math.log(end);
                inter_offset = 0;
            }
            else {
                inter_factor = Math.log(end) - Math.log(start);
                inter_offset = Math.log(start);
            }
            const factor = screen_range;
            const offset = target_start;
            return [factor, offset, inter_factor, inter_offset];
        }
    }
    exports.LogScale = LogScale;
    LogScale.__name__ = "LogScale";
},
/* models/scales/categorical_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(55) /* ./scale */;
    const linear_scale_1 = require(59) /* ./linear_scale */;
    const { _linear_compute_state } = linear_scale_1.LinearScale.prototype;
    class CategoricalScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset] = _linear_compute_state.call(this);
            const range = this.source_range;
            return (x) => factor * range.synthetic(x) + offset;
        }
        get s_invert() {
            const [factor, offset] = _linear_compute_state.call(this);
            return (sx) => (sx - offset) / factor;
        }
    }
    exports.CategoricalScale = CategoricalScale;
    CategoricalScale.__name__ = "CategoricalScale";
},
/* models/ranges/data_range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const data_range_1 = require(64) /* ./data_range */;
    const enums_1 = require(20) /* ../../core/enums */;
    const array_1 = require(9) /* ../../core/util/array */;
    const logging_1 = require(19) /* ../../core/logging */;
    const bbox = (0, tslib_1.__importStar)(require(65) /* ../../core/util/bbox */);
    const util_1 = require(66) /* ../util */;
    class DataRange1d extends data_range_1.DataRange {
        constructor(attrs) {
            super(attrs);
            this.have_updated_interactively = false;
        }
        initialize() {
            super.initialize();
            this._initial_start = this.start;
            this._initial_end = this.end;
            this._initial_range_padding = this.range_padding;
            this._initial_range_padding_units = this.range_padding_units;
            this._initial_follow = this.follow;
            this._initial_follow_interval = this.follow_interval;
            this._initial_default_span = this.default_span;
            this._plot_bounds = new Map();
        }
        get min() {
            return Math.min(this.start, this.end);
        }
        get max() {
            return Math.max(this.start, this.end);
        }
        computed_renderers() {
            // TODO (bev) check that renderers actually configured with this range
            const { renderers, names } = this;
            const all_renderers = (0, array_1.concat)(this.plots.map((plot) => plot.data_renderers));
            return (0, util_1.compute_renderers)(renderers.length == 0 ? "auto" : renderers, all_renderers, names);
        }
        /*protected*/ _compute_plot_bounds(renderers, bounds) {
            let result = bbox.empty();
            for (const r of renderers) {
                const rect = bounds.get(r);
                if (rect != null && (r.visible || !this.only_visible)) {
                    result = bbox.union(result, rect);
                }
            }
            return result;
        }
        adjust_bounds_for_aspect(bounds, ratio) {
            const result = bbox.empty();
            let width = bounds.x1 - bounds.x0;
            if (width <= 0) {
                width = 1.0;
            }
            let height = bounds.y1 - bounds.y0;
            if (height <= 0) {
                height = 1.0;
            }
            const xcenter = 0.5 * (bounds.x1 + bounds.x0);
            const ycenter = 0.5 * (bounds.y1 + bounds.y0);
            if (width < ratio * height) {
                width = ratio * height;
            }
            else {
                height = width / ratio;
            }
            result.x1 = xcenter + 0.5 * width;
            result.x0 = xcenter - 0.5 * width;
            result.y1 = ycenter + 0.5 * height;
            result.y0 = ycenter - 0.5 * height;
            return result;
        }
        /*protected*/ _compute_min_max(plot_bounds, dimension) {
            let overall = bbox.empty();
            for (const [plot, rect] of plot_bounds) {
                if (plot.visible)
                    overall = bbox.union(overall, rect);
            }
            let min, max;
            if (dimension == 0)
                [min, max] = [overall.x0, overall.x1];
            else
                [min, max] = [overall.y0, overall.y1];
            return [min, max];
        }
        /*protected*/ _compute_range(min, max) {
            const range_padding = this.range_padding; // XXX: ? 0
            let start, end;
            if (this._initial_start != null)
                min = this._initial_start;
            if (this._initial_end != null)
                max = this._initial_end;
            if (this.scale_hint == "log") {
                if (isNaN(min) || !isFinite(min) || min <= 0) {
                    if (isNaN(max) || !isFinite(max) || max <= 0)
                        min = 0.1;
                    else
                        min = max / 100;
                    logging_1.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${min}`);
                }
                if (isNaN(max) || !isFinite(max) || max <= 0) {
                    if (isNaN(min) || !isFinite(min) || min <= 0)
                        max = 10;
                    else
                        max = min * 100;
                    logging_1.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${max}`);
                }
                let center, span;
                if (max == min) {
                    span = this.default_span + 0.001;
                    center = Math.log(min) / Math.log(10);
                }
                else {
                    let log_min, log_max;
                    if (this.range_padding_units == "percent") {
                        log_min = Math.log(min) / Math.log(10);
                        log_max = Math.log(max) / Math.log(10);
                        span = (log_max - log_min) * (1 + range_padding);
                    }
                    else {
                        log_min = Math.log(min - range_padding) / Math.log(10);
                        log_max = Math.log(max + range_padding) / Math.log(10);
                        span = log_max - log_min;
                    }
                    center = (log_min + log_max) / 2.0;
                }
                start = 10 ** (center - span / 2.0);
                end = 10 ** (center + span / 2.0);
            }
            else {
                let span;
                if (max == min)
                    span = this.default_span;
                else {
                    if (this.range_padding_units == "percent")
                        span = (max - min) * (1 + range_padding);
                    else
                        span = (max - min) + 2 * range_padding;
                }
                const center = (max + min) / 2.0;
                start = center - span / 2.0;
                end = center + span / 2.0;
            }
            let follow_sign = +1;
            if (this.flipped) {
                [start, end] = [end, start];
                follow_sign = -1;
            }
            const follow_interval = this.follow_interval;
            if (follow_interval != null && Math.abs(start - end) > follow_interval) {
                if (this.follow == "start")
                    end = start + follow_sign * follow_interval;
                else if (this.follow == "end")
                    start = end - follow_sign * follow_interval;
            }
            return [start, end];
        }
        update(bounds, dimension, plot, ratio) {
            if (this.have_updated_interactively)
                return;
            const renderers = this.computed_renderers();
            // update the raw data bounds for all renderers we care about
            let total_bounds = this._compute_plot_bounds(renderers, bounds);
            if (ratio != null)
                total_bounds = this.adjust_bounds_for_aspect(total_bounds, ratio);
            this._plot_bounds.set(plot, total_bounds);
            // compute the min/mix for our specified dimension
            const [min, max] = this._compute_min_max(this._plot_bounds.entries(), dimension);
            // derive start, end from bounds and data range config
            let [start, end] = this._compute_range(min, max);
            if (this._initial_start != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_start > 0)
                        start = this._initial_start;
                }
                else
                    start = this._initial_start;
            }
            if (this._initial_end != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_end > 0)
                        end = this._initial_end;
                }
                else
                    end = this._initial_end;
            }
            let needs_emit = false;
            if (this.bounds == "auto") {
                this.setv({ bounds: [start, end] }, { silent: true });
                needs_emit = true;
            }
            // only trigger updates when there are changes
            const [_start, _end] = [this.start, this.end];
            if (start != _start || end != _end) {
                const new_range = {};
                if (start != _start)
                    new_range.start = start;
                if (end != _end)
                    new_range.end = end;
                this.setv(new_range);
                needs_emit = false;
            }
            if (needs_emit)
                this.change.emit();
        }
        reset() {
            this.have_updated_interactively = false;
            // change events silenced as PlotView.update_dataranges triggers property callbacks
            this.setv({
                range_padding: this._initial_range_padding,
                range_padding_units: this._initial_range_padding_units,
                follow: this._initial_follow,
                follow_interval: this._initial_follow_interval,
                default_span: this._initial_default_span,
            }, { silent: true });
            this.change.emit();
        }
    }
    exports.DataRange1d = DataRange1d;
    _a = DataRange1d;
    DataRange1d.__name__ = "DataRange1d";
    (() => {
        _a.define(({ Boolean, Number, Nullable }) => ({
            start: [Number],
            end: [Number],
            range_padding: [Number, 0.1],
            range_padding_units: [enums_1.PaddingUnits, "percent"],
            flipped: [Boolean, false],
            follow: [Nullable(enums_1.StartEnd), null],
            follow_interval: [Nullable(Number), null],
            default_span: [Number, 2.0],
            only_visible: [Boolean, false],
        }));
        _a.internal(({ Enum }) => ({
            scale_hint: [Enum("log", "auto"), "auto"],
        }));
    })();
},
/* models/ranges/data_range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const range_1 = require(57) /* ./range */;
    class DataRange extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataRange = DataRange;
    _a = DataRange;
    DataRange.__name__ = "DataRange";
    (() => {
        _a.define(({ String, Array, AnyRef }) => ({
            names: [Array(String), []],
            renderers: [Array(AnyRef( /*DataRenderer*/)), []], // TODO: [] -> "auto"
        }));
    })();
},
/* core/util/bbox.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(24) /* ../types */;
    const eq_1 = require(26) /* ./eq */;
    const { min, max } = Math;
    function empty() {
        return {
            x0: Infinity,
            y0: Infinity,
            x1: -Infinity,
            y1: -Infinity,
        };
    }
    exports.empty = empty;
    function positive_x() {
        return {
            x0: Number.MIN_VALUE,
            y0: -Infinity,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_x = positive_x;
    function positive_y() {
        return {
            x0: -Infinity,
            y0: Number.MIN_VALUE,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_y = positive_y;
    function union(a, b) {
        return {
            x0: min(a.x0, b.x0),
            x1: max(a.x1, b.x1),
            y0: min(a.y0, b.y0),
            y1: max(a.y1, b.y1),
        };
    }
    exports.union = union;
    class BBox {
        constructor(box) {
            if (box == null) {
                this.x0 = 0;
                this.y0 = 0;
                this.x1 = 0;
                this.y1 = 0;
            }
            else if ("x0" in box) {
                const { x0, y0, x1, y1 } = box;
                if (!(x0 <= x1 && y0 <= y1))
                    throw new Error(`invalid bbox {x0: ${x0}, y0: ${y0}, x1: ${x1}, y1: ${y1}}`);
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }
            else if ("x" in box) {
                const { x, y, width, height } = box;
                if (!(width >= 0 && height >= 0))
                    throw new Error(`invalid bbox {x: ${x}, y: ${y}, width: ${width}, height: ${height}}`);
                this.x0 = x;
                this.y0 = y;
                this.x1 = x + width;
                this.y1 = y + height;
            }
            else {
                let left, right;
                let top, bottom;
                if ("width" in box) {
                    if ("left" in box) {
                        left = box.left;
                        right = left + box.width;
                    }
                    else if ("right" in box) {
                        right = box.right;
                        left = right - box.width;
                    }
                    else {
                        const w2 = box.width / 2;
                        left = box.hcenter - w2;
                        right = box.hcenter + w2;
                    }
                }
                else {
                    left = box.left;
                    right = box.right;
                }
                if ("height" in box) {
                    if ("top" in box) {
                        top = box.top;
                        bottom = top + box.height;
                    }
                    else if ("bottom" in box) {
                        bottom = box.bottom;
                        top = bottom - box.height;
                    }
                    else {
                        const h2 = box.height / 2;
                        top = box.vcenter - h2;
                        bottom = box.vcenter + h2;
                    }
                }
                else {
                    top = box.top;
                    bottom = box.bottom;
                }
                if (!(left <= right && top <= bottom))
                    throw new Error(`invalid bbox {left: ${left}, top: ${top}, right: ${right}, bottom: ${bottom}}`);
                this.x0 = left;
                this.y0 = top;
                this.x1 = right;
                this.y1 = bottom;
            }
        }
        static from_rect({ left, right, top, bottom }) {
            return new BBox({
                x0: Math.min(left, right),
                y0: Math.min(top, bottom),
                x1: Math.max(left, right),
                y1: Math.max(top, bottom),
            });
        }
        equals(that) {
            return this.x0 == that.x0 && this.y0 == that.y0 &&
                this.x1 == that.x1 && this.y1 == that.y1;
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.x0, that.x0) && cmp.eq(this.y0, that.y0) &&
                cmp.eq(this.x1, that.x1) && cmp.eq(this.y1, that.y1);
        }
        toString() {
            return `BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`;
        }
        get left() { return this.x0; }
        get top() { return this.y0; }
        get right() { return this.x1; }
        get bottom() { return this.y1; }
        get p0() { return [this.x0, this.y0]; }
        get p1() { return [this.x1, this.y1]; }
        get x() { return this.x0; }
        get y() { return this.y0; }
        get width() { return this.x1 - this.x0; }
        get height() { return this.y1 - this.y0; }
        get size() { return { width: this.width, height: this.height }; }
        get rect() {
            const { x0, y0, x1, y1 } = this;
            return {
                p0: { x: x0, y: y0 },
                p1: { x: x1, y: y0 },
                p2: { x: x1, y: y1 },
                p3: { x: x0, y: y1 },
            };
        }
        get box() {
            const { x, y, width, height } = this;
            return { x, y, width, height };
        }
        get h_range() { return { start: this.x0, end: this.x1 }; }
        get v_range() { return { start: this.y0, end: this.y1 }; }
        get ranges() { return [this.h_range, this.v_range]; }
        get aspect() { return this.width / this.height; }
        get hcenter() { return (this.left + this.right) / 2; }
        get vcenter() { return (this.top + this.bottom) / 2; }
        get area() { return this.width * this.height; }
        relative() {
            const { width, height } = this;
            return new BBox({ x: 0, y: 0, width, height });
        }
        translate(tx, ty) {
            const { x, y, width, height } = this;
            return new BBox({ x: tx + x, y: ty + y, width, height });
        }
        relativize(x, y) {
            return [x - this.x, y - this.y];
        }
        contains(x, y) {
            return this.x0 <= x && x <= this.x1 && this.y0 <= y && y <= this.y1;
        }
        clip(x, y) {
            if (x < this.x0)
                x = this.x0;
            else if (x > this.x1)
                x = this.x1;
            if (y < this.y0)
                y = this.y0;
            else if (y > this.y1)
                y = this.y1;
            return [x, y];
        }
        grow_by(size) {
            return new BBox({
                left: this.left - size,
                right: this.right + size,
                top: this.top - size,
                bottom: this.bottom + size,
            });
        }
        shrink_by(size) {
            return new BBox({
                left: this.left + size,
                right: this.right - size,
                top: this.top + size,
                bottom: this.bottom - size,
            });
        }
        union(that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1),
            });
        }
        intersection(that) {
            if (!this.intersects(that))
                return null;
            else {
                return new BBox({
                    x0: max(this.x0, that.x0),
                    y0: max(this.y0, that.y0),
                    x1: min(this.x1, that.x1),
                    y1: min(this.y1, that.y1),
                });
            }
        }
        intersects(that) {
            return !(that.x1 < this.x0 || that.x0 > this.x1 ||
                that.y1 < this.y0 || that.y0 > this.y1);
        }
        get xview() {
            return {
                compute: (x) => {
                    return this.left + x;
                },
                v_compute: (xx) => {
                    const _xx = new types_1.ScreenArray(xx.length);
                    const left = this.left;
                    for (let i = 0; i < xx.length; i++) {
                        _xx[i] = left + xx[i];
                    }
                    return _xx;
                },
            };
        }
        get yview() {
            return {
                compute: (y) => {
                    return this.bottom - y;
                },
                v_compute: (yy) => {
                    const _yy = new types_1.ScreenArray(yy.length);
                    const bottom = this.bottom;
                    for (let i = 0; i < yy.length; i++) {
                        _yy[i] = bottom - yy[i];
                    }
                    return _yy;
                },
            };
        }
    }
    exports.BBox = BBox;
    BBox.__name__ = "BBox";
},
/* models/util.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const array_1 = require(9) /* ../core/util/array */;
    function compute_renderers(renderers, all_renderers, names) {
        if (renderers == null)
            return [];
        let result = renderers == "auto" ? all_renderers : renderers;
        if (names.length > 0)
            result = result.filter((r) => (0, array_1.includes)(names, r.name));
        return result;
    }
    exports.compute_renderers = compute_renderers;
},
/* models/ranges/factor_range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const range_1 = require(57) /* ./range */;
    const enums_1 = require(20) /* ../../core/enums */;
    const kinds_1 = require(21) /* ../../core/kinds */;
    const types_1 = require(24) /* ../../core/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const types_2 = require(8) /* ../../core/util/types */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    exports.Factor = (0, kinds_1.Or)(kinds_1.String, (0, kinds_1.Tuple)(kinds_1.String, kinds_1.String), (0, kinds_1.Tuple)(kinds_1.String, kinds_1.String, kinds_1.String));
    exports.FactorSeq = (0, kinds_1.Or)((0, kinds_1.Array)(kinds_1.String), (0, kinds_1.Array)((0, kinds_1.Tuple)(kinds_1.String, kinds_1.String)), (0, kinds_1.Array)((0, kinds_1.Tuple)(kinds_1.String, kinds_1.String, kinds_1.String)));
    function map_one_level(factors, padding, offset = 0) {
        const mapping = new Map();
        for (let i = 0; i < factors.length; i++) {
            const factor = factors[i];
            if (!mapping.has(factor))
                mapping.set(factor, { value: 0.5 + i * (1 + padding) + offset });
            else
                throw new Error(`duplicate factor or subfactor: ${factor}`);
        }
        return [mapping, (factors.length - 1) * padding];
    }
    exports.map_one_level = map_one_level;
    function map_two_levels(factors, outer_pad, factor_pad, offset = 0) {
        var _b;
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1] of factors) {
            const top = (_b = tops.get(f0)) !== null && _b !== void 0 ? _b : [];
            tops.set(f0, [...top, f1]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const [submap, subpad] = map_one_level(top, factor_pad, suboffset);
            total_subpad += subpad;
            const subtot = (0, array_1.sum)(top.map((f1) => submap.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_two_levels = map_two_levels;
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset = 0) {
        var _b;
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1, f2] of factors) {
            const top = (_b = tops.get(f0)) !== null && _b !== void 0 ? _b : [];
            tops.set(f0, [...top, [f1, f2]]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const [submap, subpad] = map_two_levels(top, inner_pad, factor_pad, suboffset);
            total_subpad += subpad;
            const subtot = (0, array_1.sum)(top.map(([f1]) => submap.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_three_levels = map_three_levels;
    class FactorRange extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
        get min() {
            return this.start;
        }
        get max() {
            return this.end;
        }
        initialize() {
            super.initialize();
            this._init(true);
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.properties.factors.change, () => this.reset());
            this.connect(this.properties.factor_padding.change, () => this.reset());
            this.connect(this.properties.group_padding.change, () => this.reset());
            this.connect(this.properties.subgroup_padding.change, () => this.reset());
            this.connect(this.properties.range_padding.change, () => this.reset());
            this.connect(this.properties.range_padding_units.change, () => this.reset());
        }
        reset() {
            this._init(false);
            this.change.emit();
        }
        _lookup(x) {
            switch (x.length) {
                case 1: {
                    const [f0] = x;
                    const mapping = this._mapping;
                    const y0 = mapping.get(f0);
                    return y0 != null ? y0.value : NaN;
                }
                case 2: {
                    const [f0, f1] = x;
                    const mapping = this._mapping;
                    const y0 = mapping.get(f0);
                    if (y0 != null) {
                        const y1 = y0.mapping.get(f1);
                        if (y1 != null)
                            return y1.value;
                    }
                    return NaN;
                }
                case 3: {
                    const [f0, f1, f2] = x;
                    const mapping = this._mapping;
                    const y0 = mapping.get(f0);
                    if (y0 != null) {
                        const y1 = y0.mapping.get(f1);
                        if (y1 != null) {
                            const y2 = y1.mapping.get(f2);
                            if (y2 != null)
                                return y2.value;
                        }
                    }
                    return NaN;
                }
                default:
                    (0, assert_1.unreachable)();
            }
        }
        // convert a string factor into a synthetic coordinate
        synthetic(x) {
            if ((0, types_2.isNumber)(x))
                return x;
            if ((0, types_2.isString)(x))
                return this._lookup([x]);
            let offset = 0;
            const off = x[x.length - 1];
            if ((0, types_2.isNumber)(off)) {
                offset = off;
                x = x.slice(0, -1);
            }
            return this._lookup(x) + offset;
        }
        // convert an array of string factors into synthetic coordinates
        v_synthetic(xs) {
            const n = xs.length;
            const array = new types_1.ScreenArray(n);
            for (let i = 0; i < n; i++) {
                array[i] = this.synthetic(xs[i]);
            }
            return array;
        }
        _init(silent) {
            const { levels, mapping, tops, mids, inside_padding } = (() => {
                if ((0, array_1.every)(this.factors, types_2.isString)) {
                    const factors = this.factors;
                    const [mapping, inside_padding] = map_one_level(factors, this.factor_padding);
                    const tops = null;
                    const mids = null;
                    return { levels: 1, mapping, tops, mids, inside_padding };
                }
                else if ((0, array_1.every)(this.factors, (x) => (0, types_2.isArray)(x) && x.length == 2 && (0, types_2.isString)(x[0]) && (0, types_2.isString)(x[1]))) {
                    const factors = this.factors;
                    const [mapping, inside_padding] = map_two_levels(factors, this.group_padding, this.factor_padding);
                    const tops = [...mapping.keys()];
                    const mids = null;
                    return { levels: 2, mapping, tops, mids, inside_padding };
                }
                else if ((0, array_1.every)(this.factors, (x) => (0, types_2.isArray)(x) && x.length == 3 && (0, types_2.isString)(x[0]) && (0, types_2.isString)(x[1]) && (0, types_2.isString)(x[2]))) {
                    const factors = this.factors;
                    const [mapping, inside_padding] = map_three_levels(factors, this.group_padding, this.subgroup_padding, this.factor_padding);
                    const tops = [...mapping.keys()];
                    const mids = [];
                    for (const [f0, L2] of mapping) {
                        for (const f1 of L2.mapping.keys()) {
                            mids.push([f0, f1]);
                        }
                    }
                    return { levels: 3, mapping, tops, mids, inside_padding };
                }
                else
                    (0, assert_1.unreachable)();
            })();
            this._mapping = mapping;
            this.tops = tops;
            this.mids = mids;
            let start = 0;
            let end = this.factors.length + inside_padding;
            if (this.range_padding_units == "percent") {
                const half_span = (end - start) * this.range_padding / 2;
                start -= half_span;
                end += half_span;
            }
            else {
                start -= this.range_padding;
                end += this.range_padding;
            }
            this.setv({ start, end, levels }, { silent });
            if (this.bounds == "auto")
                this.setv({ bounds: [start, end] }, { silent: true });
        }
    }
    exports.FactorRange = FactorRange;
    _a = FactorRange;
    FactorRange.__name__ = "FactorRange";
    (() => {
        _a.define(({ Number }) => ({
            factors: [exports.FactorSeq, []],
            factor_padding: [Number, 0],
            subgroup_padding: [Number, 0.8],
            group_padding: [Number, 1.4],
            range_padding: [Number, 0],
            range_padding_units: [enums_1.PaddingUnits, "percent"],
            start: [Number],
            end: [Number],
        }));
        _a.internal(({ Number, String, Array, Tuple, Nullable }) => ({
            levels: [Number],
            mids: [Nullable(Array(Tuple(String, String))), null],
            tops: [Nullable(Array(String)), null], // top level factors (whether 2 or 3 total levels)
        }));
    })();
},
/* models/annotations/arrow.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const data_annotation_1 = require(69) /* ./data_annotation */;
    const arrow_head_1 = require(112) /* ./arrow_head */;
    const property_mixins_1 = require(48) /* ../../core/property_mixins */;
    const enums_1 = require(20) /* ../../core/enums */;
    const types_1 = require(24) /* ../../core/types */;
    const build_views_1 = require(113) /* ../../core/build_views */;
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    const math_1 = require(10) /* ../../core/util/math */;
    class ArrowView extends data_annotation_1.DataAnnotationView {
        async lazy_initialize() {
            await super.lazy_initialize();
            const { start, end } = this.model;
            if (start != null)
                this.start = await (0, build_views_1.build_view)(start, { parent: this });
            if (end != null)
                this.end = await (0, build_views_1.build_view)(end, { parent: this });
        }
        set_data(source) {
            var _b, _c;
            super.set_data(source);
            (_b = this.start) === null || _b === void 0 ? void 0 : _b.set_data(source);
            (_c = this.end) === null || _c === void 0 ? void 0 : _c.set_data(source);
        }
        remove() {
            var _b, _c;
            (_b = this.start) === null || _b === void 0 ? void 0 : _b.remove();
            (_c = this.end) === null || _c === void 0 ? void 0 : _c.remove();
            super.remove();
        }
        map_data() {
            const { frame } = this.plot_view;
            if (this.model.start_units == "data") {
                this._sx_start = this.coordinates.x_scale.v_compute(this._x_start);
                this._sy_start = this.coordinates.y_scale.v_compute(this._y_start);
            }
            else {
                this._sx_start = frame.bbox.xview.v_compute(this._x_start);
                this._sy_start = frame.bbox.yview.v_compute(this._y_start);
            }
            if (this.model.end_units == "data") {
                this._sx_end = this.coordinates.x_scale.v_compute(this._x_end);
                this._sy_end = this.coordinates.y_scale.v_compute(this._y_end);
            }
            else {
                this._sx_end = frame.bbox.xview.v_compute(this._x_end);
                this._sy_end = frame.bbox.yview.v_compute(this._y_end);
            }
            const { _sx_start, _sy_start, _sx_end, _sy_end } = this;
            const n = _sx_start.length;
            const angles = this._angles = new types_1.ScreenArray(n);
            for (let i = 0; i < n; i++) {
                // arrow head runs orthogonal to arrow body (???)
                angles[i] = Math.PI / 2 + (0, math_1.atan2)([_sx_start[i], _sy_start[i]], [_sx_end[i], _sy_end[i]]);
            }
        }
        paint(ctx) {
            const { start, end } = this;
            const { _sx_start, _sy_start, _sx_end, _sy_end, _angles } = this;
            const { x, y, width, height } = this.plot_view.frame.bbox;
            for (let i = 0, n = _sx_start.length; i < n; i++) {
                if (end != null) {
                    ctx.save();
                    ctx.translate(_sx_end[i], _sy_end[i]);
                    ctx.rotate(_angles[i]);
                    end.render(ctx, i);
                    ctx.restore();
                }
                if (start != null) {
                    ctx.save();
                    ctx.translate(_sx_start[i], _sy_start[i]);
                    ctx.rotate(_angles[i] + Math.PI);
                    start.render(ctx, i);
                    ctx.restore();
                }
                if (this.visuals.line.doit) {
                    ctx.save();
                    if (start != null || end != null) {
                        ctx.beginPath();
                        ctx.rect(x, y, width, height);
                        if (end != null) {
                            ctx.save();
                            ctx.translate(_sx_end[i], _sy_end[i]);
                            ctx.rotate(_angles[i]);
                            end.clip(ctx, i);
                            ctx.restore();
                        }
                        if (start != null) {
                            ctx.save();
                            ctx.translate(_sx_start[i], _sy_start[i]);
                            ctx.rotate(_angles[i] + Math.PI);
                            start.clip(ctx, i);
                            ctx.restore();
                        }
                        ctx.closePath();
                        ctx.clip();
                    }
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.beginPath();
                    ctx.moveTo(_sx_start[i], _sy_start[i]);
                    ctx.lineTo(_sx_end[i], _sy_end[i]);
                    ctx.stroke();
                    ctx.restore();
                }
            }
        }
    }
    exports.ArrowView = ArrowView;
    ArrowView.__name__ = "ArrowView";
    class Arrow extends data_annotation_1.DataAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Arrow = Arrow;
    _a = Arrow;
    Arrow.__name__ = "Arrow";
    (() => {
        _a.prototype.default_view = ArrowView;
        _a.mixins(property_mixins_1.LineVector);
        _a.define(({ Ref, Nullable }) => ({
            x_start: [p.XCoordinateSpec, { field: "x_start" }],
            y_start: [p.YCoordinateSpec, { field: "y_start" }],
            start_units: [enums_1.SpatialUnits, "data"],
            start: [Nullable(Ref(arrow_head_1.ArrowHead)), null],
            x_end: [p.XCoordinateSpec, { field: "x_end" }],
            y_end: [p.YCoordinateSpec, { field: "y_end" }],
            end_units: [enums_1.SpatialUnits, "data"],
            end: [Nullable(Ref(arrow_head_1.ArrowHead)), () => new arrow_head_1.OpenHead()],
        }));
    })();
},
/* models/annotations/data_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(40) /* ./annotation */;
    const columnar_data_source_1 = require(70) /* ../sources/columnar_data_source */;
    const column_data_source_1 = require(75) /* ../sources/column_data_source */;
    const projections_1 = require(78) /* ../../core/util/projections */;
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    class DataAnnotationView extends annotation_1.AnnotationView {
        constructor() {
            super(...arguments);
            this._initial_set_data = false;
        }
        connect_signals() {
            super.connect_signals();
            const update = () => {
                this.set_data(this.model.source);
                this._rerender();
            };
            this.connect(this.model.change, update);
            this.connect(this.model.source.streaming, update);
            this.connect(this.model.source.patching, update);
            this.connect(this.model.source.change, update);
        }
        _rerender() {
            this.request_render();
        }
        set_data(source) {
            const self = this;
            for (const prop of this.model) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                    continue;
                if (prop instanceof p.BaseCoordinateSpec) {
                    const array = prop.array(source);
                    self[`_${prop.attr}`] = array;
                }
                else {
                    const uniform = prop.uniform(source);
                    self[`${prop.attr}`] = uniform;
                }
            }
            if (this.plot_model.use_map) {
                if (self._x != null)
                    projections_1.inplace.project_xy(self._x, self._y);
                if (self._xs != null)
                    projections_1.inplace.project_xsys(self._xs, self._ys);
            }
            for (const visual of this.visuals) {
                visual.update();
            }
        }
        _render() {
            if (!this._initial_set_data) {
                this.set_data(this.model.source);
                this._initial_set_data = true;
            }
            this.map_data();
            this.paint(this.layer.ctx);
        }
    }
    exports.DataAnnotationView = DataAnnotationView;
    DataAnnotationView.__name__ = "DataAnnotationView";
    class DataAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataAnnotation = DataAnnotation;
    _a = DataAnnotation;
    DataAnnotation.__name__ = "DataAnnotation";
    (() => {
        _a.define(({ Ref }) => ({
            source: [Ref(columnar_data_source_1.ColumnarDataSource), () => new column_data_source_1.ColumnDataSource()],
        }));
    })();
},
/* models/sources/columnar_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const data_source_1 = require(71) /* ./data_source */;
    const signaling_1 = require(15) /* ../../core/signaling */;
    const logging_1 = require(19) /* ../../core/logging */;
    const selection_manager_1 = require(73) /* ../../core/selection_manager */;
    const types_1 = require(8) /* ../../core/util/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const object_1 = require(13) /* ../../core/util/object */;
    const selection_1 = require(72) /* ../selections/selection */;
    const interaction_policy_1 = require(74) /* ../selections/interaction_policy */;
    const ndarray_1 = require(29) /* ../../core/util/ndarray */;
    class ColumnarDataSource extends data_source_1.DataSource {
        constructor(attrs) {
            super(attrs);
            this.selection_manager = new selection_manager_1.SelectionManager(this);
        }
        get_array(key) {
            let column = this.data[key];
            if (column == null)
                this.data[key] = column = [];
            else if (!(0, types_1.isArray)(column))
                this.data[key] = column = Array.from(column);
            return column;
        }
        initialize() {
            super.initialize();
            this._select = new signaling_1.Signal0(this, "select");
            this.inspect = new signaling_1.Signal(this, "inspect");
            this.streaming = new signaling_1.Signal0(this, "streaming");
            this.patching = new signaling_1.Signal(this, "patching");
        }
        get_column(colname) {
            const column = this.data[colname];
            return column != null ? column : null;
        }
        columns() {
            // return the column names in this data source
            return (0, object_1.keys)(this.data);
        }
        get_length(soft = true) {
            const lengths = (0, array_1.uniq)((0, object_1.values)(this.data).map((v) => (0, ndarray_1.is_NDArray)(v) ? v.shape[0] : v.length));
            switch (lengths.length) {
                case 0: {
                    return null; // XXX: don't guess, treat on case-by-case basis
                }
                case 1: {
                    return lengths[0];
                }
                default: {
                    const msg = "data source has columns of inconsistent lengths";
                    if (soft) {
                        logging_1.logger.warn(msg);
                        return lengths.sort()[0];
                    }
                    else
                        throw new Error(msg);
                }
            }
        }
        get length() {
            var _b;
            return (_b = this.get_length()) !== null && _b !== void 0 ? _b : 0;
        }
        clear() {
            const empty = {};
            for (const col of this.columns()) {
                empty[col] = new this.data[col].constructor(0);
            }
            this.data = empty;
        }
    }
    exports.ColumnarDataSource = ColumnarDataSource;
    _a = ColumnarDataSource;
    ColumnarDataSource.__name__ = "ColumnarDataSource";
    (() => {
        _a.define(({ Ref }) => ({
            selection_policy: [Ref(interaction_policy_1.SelectionPolicy), () => new interaction_policy_1.UnionRenderers()],
        }));
        _a.internal(({ AnyRef }) => ({
            inspected: [AnyRef(), () => new selection_1.Selection()],
        }));
    })();
},
/* models/sources/data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(53) /* ../../model */;
    const selection_1 = require(72) /* ../selections/selection */;
    class DataSource extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataSource = DataSource;
    _a = DataSource;
    DataSource.__name__ = "DataSource";
    (() => {
        _a.define(({ Ref }) => ({
            selected: [Ref(selection_1.Selection), () => new selection_1.Selection()],
        }));
    })();
},
/* models/selections/selection.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(53) /* ../../model */;
    const array_1 = require(9) /* ../../core/util/array */;
    const object_1 = require(13) /* ../../core/util/object */;
    class Selection extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        get_view() {
            return this.view;
        }
        get selected_glyph() {
            return this.selected_glyphs.length > 0 ? this.selected_glyphs[0] : null;
        }
        add_to_selected_glyphs(glyph) {
            this.selected_glyphs.push(glyph);
        }
        update(selection, _final = true, mode = "replace") {
            switch (mode) {
                case "replace": {
                    this.indices = selection.indices;
                    this.line_indices = selection.line_indices;
                    this.multiline_indices = selection.multiline_indices;
                    this.image_indices = selection.image_indices;
                    this.view = selection.view;
                    this.selected_glyphs = selection.selected_glyphs;
                    break;
                }
                case "append": {
                    this.update_through_union(selection);
                    break;
                }
                case "intersect": {
                    this.update_through_intersection(selection);
                    break;
                }
                case "subtract": {
                    this.update_through_subtraction(selection);
                    break;
                }
            }
        }
        clear() {
            this.indices = [];
            this.line_indices = [];
            this.multiline_indices = {};
            this.image_indices = [];
            this.view = null;
            this.selected_glyphs = [];
        }
        map(mapper) {
            return new Selection(Object.assign(Object.assign({}, this.attributes), { indices: this.indices.map(mapper),
                // NOTE: line_indices don't support subset indexing
                multiline_indices: (0, object_1.to_object)((0, object_1.entries)(this.multiline_indices).map(([index, line_indices]) => [mapper(Number(index)), line_indices])), image_indices: this.image_indices.map((ndx) => (Object.assign(Object.assign({}, ndx), { index: mapper(ndx.index) }))) }));
        }
        is_empty() {
            return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
        }
        update_through_union(other) {
            this.indices = (0, array_1.union)(this.indices, other.indices);
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
        update_through_intersection(other) {
            this.indices = (0, array_1.intersection)(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
        update_through_subtraction(other) {
            this.indices = (0, array_1.difference)(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
    }
    exports.Selection = Selection;
    _a = Selection;
    Selection.__name__ = "Selection";
    (() => {
        _a.define(({ Int, Array, Dict }) => ({
            indices: [Array(Int), []],
            line_indices: [Array(Int), []],
            multiline_indices: [Dict(Array(Int)), {}],
        }));
        _a.internal(({ Int, Array, AnyRef, Struct, Nullable }) => ({
            selected_glyphs: [Array(AnyRef()), []],
            view: [Nullable(AnyRef()), null],
            // Used internally to support hover tool for now. Python API TBD
            image_indices: [Array(Struct({ index: Int, dim1: Int, dim2: Int, flat_index: Int })), []],
        }));
    })();
},
/* core/selection_manager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const selection_1 = require(72) /* ../models/selections/selection */;
    // XXX: this is needed to cut circular dependency between this, models/renderers/* and models/sources/*
    function is_GlyphRendererView(renderer_view) {
        return renderer_view.model.type == "GlyphRenderer";
    }
    function is_GraphRendererView(renderer_view) {
        return renderer_view.model.type == "GraphRenderer";
    }
    class SelectionManager {
        constructor(source) {
            this.source = source;
            this.inspectors = new Map();
        }
        select(renderer_views, geometry, final, mode = "replace") {
            // divide renderers into glyph_renderers or graph_renderers
            const glyph_renderer_views = [];
            const graph_renderer_views = [];
            for (const r of renderer_views) {
                if (is_GlyphRendererView(r))
                    glyph_renderer_views.push(r);
                else if (is_GraphRendererView(r))
                    graph_renderer_views.push(r);
            }
            let did_hit = false;
            // graph renderer case
            for (const r of graph_renderer_views) {
                const hit_test_result = r.model.selection_policy.hit_test(geometry, r);
                did_hit = did_hit || r.model.selection_policy.do_selection(hit_test_result, r.model, final, mode);
            }
            // glyph renderers
            if (glyph_renderer_views.length > 0) {
                const hit_test_result = this.source.selection_policy.hit_test(geometry, glyph_renderer_views);
                did_hit = did_hit || this.source.selection_policy.do_selection(hit_test_result, this.source, final, mode);
            }
            return did_hit;
        }
        inspect(renderer_view, geometry) {
            let did_hit = false;
            if (is_GlyphRendererView(renderer_view)) {
                const hit_test_result = renderer_view.hit_test(geometry);
                if (hit_test_result != null) {
                    did_hit = !hit_test_result.is_empty();
                    const inspection = this.get_or_create_inspector(renderer_view.model);
                    inspection.update(hit_test_result, true, "replace");
                    this.source.setv({ inspected: inspection }, { silent: true });
                    this.source.inspect.emit([renderer_view.model, { geometry }]);
                }
            }
            else if (is_GraphRendererView(renderer_view)) {
                const hit_test_result = renderer_view.model.inspection_policy.hit_test(geometry, renderer_view);
                did_hit = did_hit || renderer_view.model.inspection_policy.do_inspection(hit_test_result, geometry, renderer_view, false, "replace");
            }
            return did_hit;
        }
        clear(rview) {
            this.source.selected.clear();
            if (rview != null)
                this.get_or_create_inspector(rview.model).clear();
        }
        get_or_create_inspector(renderer) {
            let selection = this.inspectors.get(renderer);
            if (selection == null) {
                selection = new selection_1.Selection();
                this.inspectors.set(renderer, selection);
            }
            return selection;
        }
    }
    exports.SelectionManager = SelectionManager;
    SelectionManager.__name__ = "SelectionManager";
},
/* models/selections/interaction_policy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(53) /* ../../model */;
    class SelectionPolicy extends model_1.Model {
        do_selection(hit_test_result, source, final, mode) {
            if (hit_test_result == null) {
                return false;
            }
            else {
                source.selected.update(hit_test_result, final, mode);
                source._select.emit();
                return !source.selected.is_empty();
            }
        }
    }
    exports.SelectionPolicy = SelectionPolicy;
    SelectionPolicy.__name__ = "SelectionPolicy";
    class IntersectRenderers extends SelectionPolicy {
        hit_test(geometry, renderer_views) {
            const hit_test_result_renderers = [];
            for (const r of renderer_views) {
                const result = r.hit_test(geometry);
                if (result != null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                const hit_test_result = hit_test_result_renderers[0];
                for (const hit_test_result_other of hit_test_result_renderers) {
                    hit_test_result.update_through_intersection(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        }
    }
    exports.IntersectRenderers = IntersectRenderers;
    IntersectRenderers.__name__ = "IntersectRenderers";
    class UnionRenderers extends SelectionPolicy {
        hit_test(geometry, renderer_views) {
            const hit_test_result_renderers = [];
            for (const r of renderer_views) {
                const result = r.hit_test(geometry);
                if (result != null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                const hit_test_result = hit_test_result_renderers[0];
                for (const hit_test_result_other of hit_test_result_renderers) {
                    hit_test_result.update_through_union(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        }
    }
    exports.UnionRenderers = UnionRenderers;
    UnionRenderers.__name__ = "UnionRenderers";
},
/* models/sources/column_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const columnar_data_source_1 = require(70) /* ./columnar_data_source */;
    const types_1 = require(8) /* ../../core/util/types */;
    const object_1 = require(13) /* ../../core/util/object */;
    const typed_array = (0, tslib_1.__importStar)(require(76) /* ../../core/util/typed_array */);
    const set_1 = require(77) /* ../../core/util/set */;
    const events_1 = require(35) /* ../../document/events */;
    //exported for testing
    function stream_to_column(col, new_col, rollover) {
        if ((0, types_1.isArray)(col)) {
            const result = col.concat(new_col);
            if (rollover != null && result.length > rollover)
                return result.slice(-rollover);
            else
                return result;
        }
        else if ((0, types_1.isTypedArray)(col)) {
            const total_len = col.length + new_col.length;
            // handle rollover case for typed arrays
            if (rollover != null && total_len > rollover) {
                const start = total_len - rollover;
                const end = col.length;
                // resize col if it is shorter than the rollover length
                let result;
                if (col.length < rollover) {
                    result = new col.constructor(rollover);
                    result.set(col, 0);
                }
                else
                    result = col;
                // shift values in original col to accommodate new_col
                for (let i = start, endi = end; i < endi; i++) {
                    result[i - start] = result[i];
                }
                // update end values in col with new_col
                for (let i = 0, endi = new_col.length; i < endi; i++) {
                    result[i + (end - start)] = new_col[i];
                }
                return result;
            }
            else {
                const tmp = new col.constructor(new_col);
                return typed_array.concat(col, tmp);
            }
        }
        else
            throw new Error("unsupported array types");
    }
    exports.stream_to_column = stream_to_column;
    // exported for testing
    function slice(ind, length) {
        let start, step, stop;
        if ((0, types_1.isNumber)(ind)) {
            start = ind;
            stop = ind + 1;
            step = 1;
        }
        else {
            start = ind.start != null ? ind.start : 0;
            stop = ind.stop != null ? ind.stop : length;
            step = ind.step != null ? ind.step : 1;
        }
        return [start, stop, step];
    }
    exports.slice = slice;
    // exported for testing
    function patch_to_column(col, patch) {
        const patched = new Set();
        let patched_range = false;
        for (const [ind, val] of patch) {
            // make the single index case look like the length-3 multi-index case
            let shape;
            let item;
            let index;
            let value;
            if ((0, types_1.isArray)(ind)) {
                const [i] = ind;
                patched.add(i);
                shape = col[i].shape;
                item = col[i];
                value = val;
                // this is basically like NumPy's "newaxis", inserting an empty dimension
                // makes length 2 and 3 multi-index cases uniform, so that the same code
                // can handle both
                if (ind.length === 2) {
                    shape = [1, shape[0]];
                    index = [ind[0], 0, ind[1]];
                }
                else
                    index = ind;
            }
            else {
                if ((0, types_1.isNumber)(ind)) {
                    value = [val];
                    patched.add(ind);
                }
                else {
                    value = val;
                    patched_range = true;
                }
                index = [0, 0, ind];
                shape = [1, col.length];
                item = col;
            }
            // now this one nested loop handles all cases
            let flat_index = 0;
            const [istart, istop, istep] = slice(index[1], shape[0]);
            const [jstart, jstop, jstep] = slice(index[2], shape[1]);
            for (let i = istart; i < istop; i += istep) {
                for (let j = jstart; j < jstop; j += jstep) {
                    if (patched_range) {
                        patched.add(j);
                    }
                    item[i * shape[1] + j] = value[flat_index];
                    flat_index++;
                }
            }
        }
        return patched;
    }
    exports.patch_to_column = patch_to_column;
    class ColumnDataSource extends columnar_data_source_1.ColumnarDataSource {
        constructor(attrs) {
            super(attrs);
        }
        stream(new_data, rollover, setter_id) {
            const { data } = this;
            for (const [name, new_column] of (0, object_1.entries)(new_data)) {
                data[name] = stream_to_column(data[name], new_column, rollover);
            }
            this.setv({ data }, { silent: true });
            this.streaming.emit();
            if (this.document != null) {
                const hint = new events_1.ColumnsStreamedEvent(this.document, this.ref(), new_data, rollover);
                this.document._notify_change(this, "data", null, null, { setter_id, hint });
            }
        }
        patch(patches, setter_id) {
            const { data } = this;
            let patched = new Set();
            for (const [column, patch] of (0, object_1.entries)(patches)) {
                patched = (0, set_1.union)(patched, patch_to_column(data[column], patch)); // XXX
            }
            this.setv({ data }, { silent: true });
            this.patching.emit([...patched]);
            if (this.document != null) {
                const hint = new events_1.ColumnsPatchedEvent(this.document, this.ref(), patches);
                this.document._notify_change(this, "data", null, null, { setter_id, hint });
            }
        }
    }
    exports.ColumnDataSource = ColumnDataSource;
    _a = ColumnDataSource;
    ColumnDataSource.__name__ = "ColumnDataSource";
    (() => {
        _a.define(({ Dict, Any /*Arrayable*/ }) => ({
            data: [Dict(Any /*Arrayable*/), {}], // TODO: resolve ndarray refs earlier
        }));
    })();
},
/* core/util/typed_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function concat(array0, ...arrays) {
        let n = array0.length;
        for (const array of arrays)
            n += array.length;
        const result = new array0.constructor(n);
        result.set(array0, 0);
        let i = array0.length;
        for (const array of arrays) {
            result.set(array, i);
            i += array.length;
        }
        return result;
    }
    exports.concat = concat;
},
/* core/util/set.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function union(...sets) {
        const result = new Set();
        for (const set of sets) {
            for (const item of set) {
                result.add(item);
            }
        }
        return result;
    }
    exports.union = union;
    function intersection(set, ...sets) {
        const result = new Set();
        top: for (const item of set) {
            for (const other of sets) {
                if (!other.has(item))
                    continue top;
            }
            result.add(item);
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(set, ...sets) {
        const result = new Set(set);
        for (const item of union(...sets)) {
            result.delete(item);
        }
        return result;
    }
    exports.difference = difference;
},
/* core/util/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const core_1 = (0, tslib_1.__importDefault)(require(79) /* proj4/lib/core */);
    const Proj_1 = (0, tslib_1.__importDefault)(require(80) /* proj4/lib/Proj */);
    const types_1 = require(24) /* ../types */;
    const mercator = new Proj_1.default("GOOGLE");
    const wgs84 = new Proj_1.default("WGS84");
    const _wgs84_mercator = (0, core_1.default)(wgs84, mercator);
    exports.wgs84_mercator = {
        compute(x, y) {
            if (isFinite(x) && isFinite(y))
                return _wgs84_mercator.forward([x, y]);
            else
                return [NaN, NaN];
        },
        invert(merc_x, merc_y) {
            if (isFinite(merc_x) && isFinite(merc_y))
                return _wgs84_mercator.inverse([merc_x, merc_y]);
            else
                return [NaN, NaN];
        },
    };
    const mercator_bounds = {
        lon: [-20026376.39, 20026376.39],
        lat: [-20048966.10, 20048966.10],
    };
    const latlon_bounds = {
        lon: [-180, 180],
        lat: [-85.06, 85.06],
    };
    const { min, max } = Math;
    function clip_mercator(low, high, dimension) {
        const [vmin, vmax] = mercator_bounds[dimension];
        return [max(low, vmin), min(high, vmax)];
    }
    exports.clip_mercator = clip_mercator;
    function in_bounds(value, dimension) {
        const [min, max] = latlon_bounds[dimension];
        return min < value && value < max;
    }
    exports.in_bounds = in_bounds;
    (function (inplace) {
        function project_xy(x, y, merc_x, merc_y) {
            const n = min(x.length, y.length);
            merc_x = merc_x !== null && merc_x !== void 0 ? merc_x : x;
            merc_y = merc_y !== null && merc_y !== void 0 ? merc_y : y;
            for (let i = 0; i < n; i++) {
                const xi = x[i];
                const yi = y[i];
                const [merc_xi, merc_yi] = exports.wgs84_mercator.compute(xi, yi);
                merc_x[i] = merc_xi;
                merc_y[i] = merc_yi;
            }
        }
        inplace.project_xy = project_xy;
        function project_xsys(xs, ys, merc_xs, merc_ys) {
            const n = min(xs.length, ys.length);
            merc_xs = merc_xs !== null && merc_xs !== void 0 ? merc_xs : xs;
            merc_ys = merc_ys !== null && merc_ys !== void 0 ? merc_ys : ys;
            for (let i = 0; i < n; i++) {
                project_xy(xs[i], ys[i], merc_xs[i], merc_ys[i]);
            }
        }
        inplace.project_xsys = project_xsys;
    })(exports.inplace || (exports.inplace = {}));
    function project_xy(x, y) {
        const n = min(x.length, y.length);
        const ArrayType = (0, types_1.infer_type)(x, y);
        const merc_x = new ArrayType(n);
        const merc_y = new ArrayType(n);
        exports.inplace.project_xy(x, y, merc_x, merc_y);
        return [merc_x, merc_y];
    }
    exports.project_xy = project_xy;
    function project_xsys(xs, ys) {
        const n = min(xs.length, ys.length);
        const merc_xs = new Array(n);
        const merc_ys = new Array(n);
        for (let i = 0; i < n; i++) {
            const [merc_x, merc_y] = project_xy(xs[i], ys[i]);
            merc_xs[i] = merc_x;
            merc_ys[i] = merc_y;
        }
        return [merc_xs, merc_ys];
    }
    exports.project_xsys = project_xsys;
},
/* proj4/lib/core.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const Proj_1 = (0, tslib_1.__importDefault)(require(80) /* ./Proj */);
    const transform_1 = (0, tslib_1.__importDefault)(require(106) /* ./transform */);
    var wgs84 = (0, Proj_1.default)('WGS84');
    function transformer(from, to, coords, enforceAxis) {
        var transformedArray, out, keys;
        if (Array.isArray(coords)) {
            transformedArray = (0, transform_1.default)(from, to, coords, enforceAxis) || { x: NaN, y: NaN };
            if (coords.length > 2) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (typeof transformedArray.z === 'number') {
                        return [transformedArray.x, transformedArray.y, transformedArray.z].concat(coords.splice(3));
                    }
                    else {
                        return [transformedArray.x, transformedArray.y, coords[2]].concat(coords.splice(3));
                    }
                }
                else {
                    return [transformedArray.x, transformedArray.y].concat(coords.splice(2));
                }
            }
            else {
                return [transformedArray.x, transformedArray.y];
            }
        }
        else {
            out = (0, transform_1.default)(from, to, coords, enforceAxis);
            keys = Object.keys(coords);
            if (keys.length === 2) {
                return out;
            }
            keys.forEach(function (key) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (key === 'x' || key === 'y' || key === 'z') {
                        return;
                    }
                }
                else {
                    if (key === 'x' || key === 'y') {
                        return;
                    }
                }
                out[key] = coords[key];
            });
            return out;
        }
    }
    function checkProj(item) {
        if (item instanceof Proj_1.default) {
            return item;
        }
        if (item.oProj) {
            return item.oProj;
        }
        return (0, Proj_1.default)(item);
    }
    function proj4(fromProj, toProj, coord) {
        fromProj = checkProj(fromProj);
        var single = false;
        var obj;
        if (typeof toProj === 'undefined') {
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        else if (typeof toProj.x !== 'undefined' || Array.isArray(toProj)) {
            coord = toProj;
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        toProj = checkProj(toProj);
        if (coord) {
            return transformer(fromProj, toProj, coord);
        }
        else {
            obj = {
                forward: function (coords, enforceAxis) {
                    return transformer(fromProj, toProj, coords, enforceAxis);
                },
                inverse: function (coords, enforceAxis) {
                    return transformer(toProj, fromProj, coords, enforceAxis);
                }
            };
            if (single) {
                obj.oProj = toProj;
            }
            return obj;
        }
    }
    exports.default = proj4;
},
/* proj4/lib/Proj.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const parseCode_1 = (0, tslib_1.__importDefault)(require(81) /* ./parseCode */);
    const extend_1 = (0, tslib_1.__importDefault)(require(92) /* ./extend */);
    const projections_1 = (0, tslib_1.__importDefault)(require(93) /* ./projections */);
    const deriveConstants_1 = require(101) /* ./deriveConstants */;
    const Datum_1 = (0, tslib_1.__importDefault)(require(103) /* ./constants/Datum */);
    const datum_1 = (0, tslib_1.__importDefault)(require(104) /* ./datum */);
    const match_1 = (0, tslib_1.__importDefault)(require(88) /* ./match */);
    const nadgrid_1 = require(105) /* ./nadgrid */;
    function Projection(srsCode, callback) {
        if (!(this instanceof Projection)) {
            return new Projection(srsCode);
        }
        callback = callback || function (error) {
            if (error) {
                throw error;
            }
        };
        var json = (0, parseCode_1.default)(srsCode);
        if (typeof json !== 'object') {
            callback(srsCode);
            return;
        }
        var ourProj = Projection.projections.get(json.projName);
        if (!ourProj) {
            callback(srsCode);
            return;
        }
        if (json.datumCode && json.datumCode !== 'none') {
            var datumDef = (0, match_1.default)(Datum_1.default, json.datumCode);
            if (datumDef) {
                json.datum_params = json.datum_params || (datumDef.towgs84 ? datumDef.towgs84.split(',') : null);
                json.ellps = datumDef.ellipse;
                json.datumName = datumDef.datumName ? datumDef.datumName : json.datumCode;
            }
        }
        json.k0 = json.k0 || 1.0;
        json.axis = json.axis || 'enu';
        json.ellps = json.ellps || 'wgs84';
        json.lat1 = json.lat1 || json.lat0; // Lambert_Conformal_Conic_1SP, for example, needs this
        var sphere_ = (0, deriveConstants_1.sphere)(json.a, json.b, json.rf, json.ellps, json.sphere);
        var ecc = (0, deriveConstants_1.eccentricity)(sphere_.a, sphere_.b, sphere_.rf, json.R_A);
        var nadgrids = (0, nadgrid_1.getNadgrids)(json.nadgrids);
        var datumObj = json.datum || (0, datum_1.default)(json.datumCode, json.datum_params, sphere_.a, sphere_.b, ecc.es, ecc.ep2, nadgrids);
        (0, extend_1.default)(this, json); // transfer everything over from the projection because we don't know what we'll need
        (0, extend_1.default)(this, ourProj); // transfer all the methods from the projection
        // copy the 4 things over we calulated in deriveConstants.sphere
        this.a = sphere_.a;
        this.b = sphere_.b;
        this.rf = sphere_.rf;
        this.sphere = sphere_.sphere;
        // copy the 3 things we calculated in deriveConstants.eccentricity
        this.es = ecc.es;
        this.e = ecc.e;
        this.ep2 = ecc.ep2;
        // add in the datum object
        this.datum = datumObj;
        // init the projection
        this.init();
        // legecy callback from back in the day when it went to spatialreference.org
        callback(null, this);
    }
    Projection.projections = projections_1.default;
    Projection.projections.start();
    exports.default = Projection;
},
/* proj4/lib/parseCode.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const defs_1 = (0, tslib_1.__importDefault)(require(82) /* ./defs */);
    const wkt_parser_1 = (0, tslib_1.__importDefault)(require(89) /* wkt-parser */);
    const projString_1 = (0, tslib_1.__importDefault)(require(84) /* ./projString */);
    const match_1 = (0, tslib_1.__importDefault)(require(88) /* ./match */);
    function testObj(code) {
        return typeof code === 'string';
    }
    function testDef(code) {
        return code in defs_1.default;
    }
    var codeWords = ['PROJECTEDCRS', 'PROJCRS', 'GEOGCS', 'GEOCCS', 'PROJCS', 'LOCAL_CS', 'GEODCRS', 'GEODETICCRS', 'GEODETICDATUM', 'ENGCRS', 'ENGINEERINGCRS'];
    function testWKT(code) {
        return codeWords.some(function (word) {
            return code.indexOf(word) > -1;
        });
    }
    var codes = ['3857', '900913', '3785', '102113'];
    function checkMercator(item) {
        var auth = (0, match_1.default)(item, 'authority');
        if (!auth) {
            return;
        }
        var code = (0, match_1.default)(auth, 'epsg');
        return code && codes.indexOf(code) > -1;
    }
    function checkProjStr(item) {
        var ext = (0, match_1.default)(item, 'extension');
        if (!ext) {
            return;
        }
        return (0, match_1.default)(ext, 'proj4');
    }
    function testProj(code) {
        return code[0] === '+';
    }
    function parse(code) {
        if (testObj(code)) {
            //check to see if this is a WKT string
            if (testDef(code)) {
                return defs_1.default[code];
            }
            if (testWKT(code)) {
                var out = (0, wkt_parser_1.default)(code);
                // test of spetial case, due to this being a very common and often malformed
                if (checkMercator(out)) {
                    return defs_1.default['EPSG:3857'];
                }
                var maybeProjStr = checkProjStr(out);
                if (maybeProjStr) {
                    return (0, projString_1.default)(maybeProjStr);
                }
                return out;
            }
            if (testProj(code)) {
                return (0, projString_1.default)(code);
            }
        }
        else {
            return code;
        }
    }
    exports.default = parse;
},
/* proj4/lib/defs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const global_1 = (0, tslib_1.__importDefault)(require(83) /* ./global */);
    const projString_1 = (0, tslib_1.__importDefault)(require(84) /* ./projString */);
    const wkt_parser_1 = (0, tslib_1.__importDefault)(require(89) /* wkt-parser */);
    function defs(name) {
        /*global console*/
        var that = this;
        if (arguments.length === 2) {
            var def = arguments[1];
            if (typeof def === 'string') {
                if (def.charAt(0) === '+') {
                    defs[name] = (0, projString_1.default)(arguments[1]);
                }
                else {
                    defs[name] = (0, wkt_parser_1.default)(arguments[1]);
                }
            }
            else {
                defs[name] = def;
            }
        }
        else if (arguments.length === 1) {
            if (Array.isArray(name)) {
                return name.map(function (v) {
                    if (Array.isArray(v)) {
                        defs.apply(that, v);
                    }
                    else {
                        defs(v);
                    }
                });
            }
            else if (typeof name === 'string') {
                if (name in defs) {
                    return defs[name];
                }
            }
            else if ('EPSG' in name) {
                defs['EPSG:' + name.EPSG] = name;
            }
            else if ('ESRI' in name) {
                defs['ESRI:' + name.ESRI] = name;
            }
            else if ('IAU2000' in name) {
                defs['IAU2000:' + name.IAU2000] = name;
            }
            else {
                console.log(name);
            }
            return;
        }
    }
    (0, global_1.default)(defs);
    exports.default = defs;
},
/* proj4/lib/global.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(defs) {
        defs('EPSG:4326', "+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        defs('EPSG:4269', "+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees");
        defs('EPSG:3857', "+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");
        defs.WGS84 = defs['EPSG:4326'];
        defs['EPSG:3785'] = defs['EPSG:3857']; // maintain backward compat, official code is 3857
        defs.GOOGLE = defs['EPSG:3857'];
        defs['EPSG:900913'] = defs['EPSG:3857'];
        defs['EPSG:102113'] = defs['EPSG:3857'];
    }
    exports.default = default_1;
},
/* proj4/lib/projString.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(85) /* ./constants/values */;
    const PrimeMeridian_1 = (0, tslib_1.__importDefault)(require(86) /* ./constants/PrimeMeridian */);
    const units_1 = (0, tslib_1.__importDefault)(require(87) /* ./constants/units */);
    const match_1 = (0, tslib_1.__importDefault)(require(88) /* ./match */);
    function default_1(defData) {
        var self = {};
        var paramObj = defData.split('+').map(function (v) {
            return v.trim();
        }).filter(function (a) {
            return a;
        }).reduce(function (p, a) {
            var split = a.split('=');
            split.push(true);
            p[split[0].toLowerCase()] = split[1];
            return p;
        }, {});
        var paramName, paramVal, paramOutname;
        var params = {
            proj: 'projName',
            datum: 'datumCode',
            rf: function (v) {
                self.rf = parseFloat(v);
            },
            lat_0: function (v) {
                self.lat0 = v * values_1.D2R;
            },
            lat_1: function (v) {
                self.lat1 = v * values_1.D2R;
            },
            lat_2: function (v) {
                self.lat2 = v * values_1.D2R;
            },
            lat_ts: function (v) {
                self.lat_ts = v * values_1.D2R;
            },
            lon_0: function (v) {
                self.long0 = v * values_1.D2R;
            },
            lon_1: function (v) {
                self.long1 = v * values_1.D2R;
            },
            lon_2: function (v) {
                self.long2 = v * values_1.D2R;
            },
            alpha: function (v) {
                self.alpha = parseFloat(v) * values_1.D2R;
            },
            gamma: function (v) {
                self.rectified_grid_angle = parseFloat(v);
            },
            lonc: function (v) {
                self.longc = v * values_1.D2R;
            },
            x_0: function (v) {
                self.x0 = parseFloat(v);
            },
            y_0: function (v) {
                self.y0 = parseFloat(v);
            },
            k_0: function (v) {
                self.k0 = parseFloat(v);
            },
            k: function (v) {
                self.k0 = parseFloat(v);
            },
            a: function (v) {
                self.a = parseFloat(v);
            },
            b: function (v) {
                self.b = parseFloat(v);
            },
            r_a: function () {
                self.R_A = true;
            },
            zone: function (v) {
                self.zone = parseInt(v, 10);
            },
            south: function () {
                self.utmSouth = true;
            },
            towgs84: function (v) {
                self.datum_params = v.split(",").map(function (a) {
                    return parseFloat(a);
                });
            },
            to_meter: function (v) {
                self.to_meter = parseFloat(v);
            },
            units: function (v) {
                self.units = v;
                var unit = (0, match_1.default)(units_1.default, v);
                if (unit) {
                    self.to_meter = unit.to_meter;
                }
            },
            from_greenwich: function (v) {
                self.from_greenwich = v * values_1.D2R;
            },
            pm: function (v) {
                var pm = (0, match_1.default)(PrimeMeridian_1.default, v);
                self.from_greenwich = (pm ? pm : parseFloat(v)) * values_1.D2R;
            },
            nadgrids: function (v) {
                if (v === '@null') {
                    self.datumCode = 'none';
                }
                else {
                    self.nadgrids = v;
                }
            },
            axis: function (v) {
                var legalAxis = "ewnsud";
                if (v.length === 3 && legalAxis.indexOf(v.substr(0, 1)) !== -1 && legalAxis.indexOf(v.substr(1, 1)) !== -1 && legalAxis.indexOf(v.substr(2, 1)) !== -1) {
                    self.axis = v;
                }
            },
            approx: function () {
                self.approx = true;
            }
        };
        for (paramName in paramObj) {
            paramVal = paramObj[paramName];
            if (paramName in params) {
                paramOutname = params[paramName];
                if (typeof paramOutname === 'function') {
                    paramOutname(paramVal);
                }
                else {
                    self[paramOutname] = paramVal;
                }
            }
            else {
                self[paramName] = paramVal;
            }
        }
        if (typeof self.datumCode === 'string' && self.datumCode !== "WGS84") {
            self.datumCode = self.datumCode.toLowerCase();
        }
        return self;
    }
    exports.default = default_1;
},
/* proj4/lib/constants/values.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.PJD_3PARAM = 1;
    exports.PJD_7PARAM = 2;
    exports.PJD_GRIDSHIFT = 3;
    exports.PJD_WGS84 = 4; // WGS84 or equivalent
    exports.PJD_NODATUM = 5; // WGS84 or equivalent
    exports.SRS_WGS84_SEMIMAJOR = 6378137.0; // only used in grid shift transforms
    exports.SRS_WGS84_SEMIMINOR = 6356752.314; // only used in grid shift transforms
    exports.SRS_WGS84_ESQUARED = 0.0066943799901413165; // only used in grid shift transforms
    exports.SEC_TO_RAD = 4.84813681109535993589914102357e-6;
    exports.HALF_PI = Math.PI / 2;
    // ellipoid pj_set_ell.c
    exports.SIXTH = 0.1666666666666666667;
    /* 1/6 */
    exports.RA4 = 0.04722222222222222222;
    /* 17/360 */
    exports.RA6 = 0.02215608465608465608;
    exports.EPSLN = 1.0e-10;
    // you'd think you could use Number.EPSILON above but that makes
    // Mollweide get into an infinate loop.
    exports.D2R = 0.01745329251994329577;
    exports.R2D = 57.29577951308232088;
    exports.FORTPI = Math.PI / 4;
    exports.TWO_PI = Math.PI * 2;
    // SPI is slightly greater than Math.PI, so values that exceed the -180..180
    // degree range by a tiny amount don't get wrapped. This prevents points that
    // have drifted from their original location along the 180th meridian (due to
    // floating point error) from changing their sign.
    exports.SPI = 3.14159265359;
},
/* proj4/lib/constants/PrimeMeridian.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.greenwich = 0.0; //"0dE",
    exports$1.lisbon = -9.131906111111; //"9d07'54.862\"W",
    exports$1.paris = 2.337229166667; //"2d20'14.025\"E",
    exports$1.bogota = -74.080916666667; //"74d04'51.3\"W",
    exports$1.madrid = -3.687938888889; //"3d41'16.58\"W",
    exports$1.rome = 12.452333333333; //"12d27'8.4\"E",
    exports$1.bern = 7.439583333333; //"7d26'22.5\"E",
    exports$1.jakarta = 106.807719444444; //"106d48'27.79\"E",
    exports$1.ferro = -17.666666666667; //"17d40'W",
    exports$1.brussels = 4.367975; //"4d22'4.71\"E",
    exports$1.stockholm = 18.058277777778; //"18d3'29.8\"E",
    exports$1.athens = 23.7163375; //"23d42'58.815\"E",
    exports$1.oslo = 10.722916666667; //"10d43'22.5\"E"
},
/* proj4/lib/constants/units.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = {
        ft: { to_meter: 0.3048 },
        'us-ft': { to_meter: 1200 / 3937 }
    };
},
/* proj4/lib/match.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var ignoredChar = /[\s_\-\/\(\)]/g;
    function match(obj, key) {
        if (obj[key]) {
            return obj[key];
        }
        var keys = Object.keys(obj);
        var lkey = key.toLowerCase().replace(ignoredChar, '');
        var i = -1;
        var testkey, processedKey;
        while (++i < keys.length) {
            testkey = keys[i];
            processedKey = testkey.toLowerCase().replace(ignoredChar, '');
            if (processedKey === lkey) {
                return obj[testkey];
            }
        }
    }
    exports.default = match;
},
/* wkt-parser/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var D2R = 0.01745329251994329577;
    const parser_1 = (0, tslib_1.__importDefault)(require(90) /* ./parser */);
    const process_1 = require(91) /* ./process */;
    function rename(obj, params) {
        var outName = params[0];
        var inName = params[1];
        if (!(outName in obj) && (inName in obj)) {
            obj[outName] = obj[inName];
            if (params.length === 3) {
                obj[outName] = params[2](obj[outName]);
            }
        }
    }
    function d2r(input) {
        return input * D2R;
    }
    function cleanWKT(wkt) {
        if (wkt.type === 'GEOGCS') {
            wkt.projName = 'longlat';
        }
        else if (wkt.type === 'LOCAL_CS') {
            wkt.projName = 'identity';
            wkt.local = true;
        }
        else {
            if (typeof wkt.PROJECTION === 'object') {
                wkt.projName = Object.keys(wkt.PROJECTION)[0];
            }
            else {
                wkt.projName = wkt.PROJECTION;
            }
        }
        if (wkt.AXIS) {
            var axisOrder = '';
            for (var i = 0, ii = wkt.AXIS.length; i < ii; ++i) {
                var axis = [wkt.AXIS[i][0].toLowerCase(), wkt.AXIS[i][1].toLowerCase()];
                if (axis[0].indexOf('north') !== -1 || ((axis[0] === 'y' || axis[0] === 'lat') && axis[1] === 'north')) {
                    axisOrder += 'n';
                }
                else if (axis[0].indexOf('south') !== -1 || ((axis[0] === 'y' || axis[0] === 'lat') && axis[1] === 'south')) {
                    axisOrder += 's';
                }
                else if (axis[0].indexOf('east') !== -1 || ((axis[0] === 'x' || axis[0] === 'lon') && axis[1] === 'east')) {
                    axisOrder += 'e';
                }
                else if (axis[0].indexOf('west') !== -1 || ((axis[0] === 'x' || axis[0] === 'lon') && axis[1] === 'west')) {
                    axisOrder += 'w';
                }
            }
            if (axisOrder.length === 2) {
                axisOrder += 'u';
            }
            if (axisOrder.length === 3) {
                wkt.axis = axisOrder;
            }
        }
        if (wkt.UNIT) {
            wkt.units = wkt.UNIT.name.toLowerCase();
            if (wkt.units === 'metre') {
                wkt.units = 'meter';
            }
            if (wkt.UNIT.convert) {
                if (wkt.type === 'GEOGCS') {
                    if (wkt.DATUM && wkt.DATUM.SPHEROID) {
                        wkt.to_meter = wkt.UNIT.convert * wkt.DATUM.SPHEROID.a;
                    }
                }
                else {
                    wkt.to_meter = wkt.UNIT.convert;
                }
            }
        }
        var geogcs = wkt.GEOGCS;
        if (wkt.type === 'GEOGCS') {
            geogcs = wkt;
        }
        if (geogcs) {
            //if(wkt.GEOGCS.PRIMEM&&wkt.GEOGCS.PRIMEM.convert){
            //  wkt.from_greenwich=wkt.GEOGCS.PRIMEM.convert*D2R;
            //}
            if (geogcs.DATUM) {
                wkt.datumCode = geogcs.DATUM.name.toLowerCase();
            }
            else {
                wkt.datumCode = geogcs.name.toLowerCase();
            }
            if (wkt.datumCode.slice(0, 2) === 'd_') {
                wkt.datumCode = wkt.datumCode.slice(2);
            }
            if (wkt.datumCode === 'new_zealand_geodetic_datum_1949' || wkt.datumCode === 'new_zealand_1949') {
                wkt.datumCode = 'nzgd49';
            }
            if (wkt.datumCode === 'wgs_1984' || wkt.datumCode === 'world_geodetic_system_1984') {
                if (wkt.PROJECTION === 'Mercator_Auxiliary_Sphere') {
                    wkt.sphere = true;
                }
                wkt.datumCode = 'wgs84';
            }
            if (wkt.datumCode.slice(-6) === '_ferro') {
                wkt.datumCode = wkt.datumCode.slice(0, -6);
            }
            if (wkt.datumCode.slice(-8) === '_jakarta') {
                wkt.datumCode = wkt.datumCode.slice(0, -8);
            }
            if (~wkt.datumCode.indexOf('belge')) {
                wkt.datumCode = 'rnb72';
            }
            if (geogcs.DATUM && geogcs.DATUM.SPHEROID) {
                wkt.ellps = geogcs.DATUM.SPHEROID.name.replace('_19', '').replace(/[Cc]larke\_18/, 'clrk');
                if (wkt.ellps.toLowerCase().slice(0, 13) === 'international') {
                    wkt.ellps = 'intl';
                }
                wkt.a = geogcs.DATUM.SPHEROID.a;
                wkt.rf = parseFloat(geogcs.DATUM.SPHEROID.rf, 10);
            }
            if (geogcs.DATUM && geogcs.DATUM.TOWGS84) {
                wkt.datum_params = geogcs.DATUM.TOWGS84;
            }
            if (~wkt.datumCode.indexOf('osgb_1936')) {
                wkt.datumCode = 'osgb36';
            }
            if (~wkt.datumCode.indexOf('osni_1952')) {
                wkt.datumCode = 'osni52';
            }
            if (~wkt.datumCode.indexOf('tm65')
                || ~wkt.datumCode.indexOf('geodetic_datum_of_1965')) {
                wkt.datumCode = 'ire65';
            }
            if (wkt.datumCode === 'ch1903+') {
                wkt.datumCode = 'ch1903';
            }
            if (~wkt.datumCode.indexOf('israel')) {
                wkt.datumCode = 'isr93';
            }
        }
        if (wkt.b && !isFinite(wkt.b)) {
            wkt.b = wkt.a;
        }
        function toMeter(input) {
            var ratio = wkt.to_meter || 1;
            return input * ratio;
        }
        var renamer = function (a) {
            return rename(wkt, a);
        };
        var list = [
            ['standard_parallel_1', 'Standard_Parallel_1'],
            ['standard_parallel_1', 'Latitude of 1st standard parallel'],
            ['standard_parallel_2', 'Standard_Parallel_2'],
            ['standard_parallel_2', 'Latitude of 2nd standard parallel'],
            ['false_easting', 'False_Easting'],
            ['false_easting', 'False easting'],
            ['false-easting', 'Easting at false origin'],
            ['false_northing', 'False_Northing'],
            ['false_northing', 'False northing'],
            ['false_northing', 'Northing at false origin'],
            ['central_meridian', 'Central_Meridian'],
            ['central_meridian', 'Longitude of natural origin'],
            ['central_meridian', 'Longitude of false origin'],
            ['latitude_of_origin', 'Latitude_Of_Origin'],
            ['latitude_of_origin', 'Central_Parallel'],
            ['latitude_of_origin', 'Latitude of natural origin'],
            ['latitude_of_origin', 'Latitude of false origin'],
            ['scale_factor', 'Scale_Factor'],
            ['k0', 'scale_factor'],
            ['latitude_of_center', 'Latitude_Of_Center'],
            ['latitude_of_center', 'Latitude_of_center'],
            ['lat0', 'latitude_of_center', d2r],
            ['longitude_of_center', 'Longitude_Of_Center'],
            ['longitude_of_center', 'Longitude_of_center'],
            ['longc', 'longitude_of_center', d2r],
            ['x0', 'false_easting', toMeter],
            ['y0', 'false_northing', toMeter],
            ['long0', 'central_meridian', d2r],
            ['lat0', 'latitude_of_origin', d2r],
            ['lat0', 'standard_parallel_1', d2r],
            ['lat1', 'standard_parallel_1', d2r],
            ['lat2', 'standard_parallel_2', d2r],
            ['azimuth', 'Azimuth'],
            ['alpha', 'azimuth', d2r],
            ['srsCode', 'name']
        ];
        list.forEach(renamer);
        if (!wkt.long0 && wkt.longc && (wkt.projName === 'Albers_Conic_Equal_Area' || wkt.projName === 'Lambert_Azimuthal_Equal_Area')) {
            wkt.long0 = wkt.longc;
        }
        if (!wkt.lat_ts && wkt.lat1 && (wkt.projName === 'Stereographic_South_Pole' || wkt.projName === 'Polar Stereographic (variant B)')) {
            wkt.lat0 = d2r(wkt.lat1 > 0 ? 90 : -90);
            wkt.lat_ts = wkt.lat1;
        }
    }
    function default_1(wkt) {
        var lisp = (0, parser_1.default)(wkt);
        var type = lisp.shift();
        var name = lisp.shift();
        lisp.unshift(['name', name]);
        lisp.unshift(['type', type]);
        var obj = {};
        (0, process_1.sExpr)(lisp, obj);
        cleanWKT(obj);
        return obj;
    }
    exports.default = default_1;
},
/* wkt-parser/parser.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = parseString;
    var NEUTRAL = 1;
    var KEYWORD = 2;
    var NUMBER = 3;
    var QUOTED = 4;
    var AFTERQUOTE = 5;
    var ENDED = -1;
    var whitespace = /\s/;
    var latin = /[A-Za-z]/;
    var keyword = /[A-Za-z84]/;
    var endThings = /[,\]]/;
    var digets = /[\d\.E\-\+]/;
    // const ignoredChar = /[\s_\-\/\(\)]/g;
    function Parser(text) {
        if (typeof text !== 'string') {
            throw new Error('not a string');
        }
        this.text = text.trim();
        this.level = 0;
        this.place = 0;
        this.root = null;
        this.stack = [];
        this.currentObject = null;
        this.state = NEUTRAL;
    }
    Parser.prototype.readCharicter = function () {
        var char = this.text[this.place++];
        if (this.state !== QUOTED) {
            while (whitespace.test(char)) {
                if (this.place >= this.text.length) {
                    return;
                }
                char = this.text[this.place++];
            }
        }
        switch (this.state) {
            case NEUTRAL:
                return this.neutral(char);
            case KEYWORD:
                return this.keyword(char);
            case QUOTED:
                return this.quoted(char);
            case AFTERQUOTE:
                return this.afterquote(char);
            case NUMBER:
                return this.number(char);
            case ENDED:
                return;
        }
    };
    Parser.prototype.afterquote = function (char) {
        if (char === '"') {
            this.word += '"';
            this.state = QUOTED;
            return;
        }
        if (endThings.test(char)) {
            this.word = this.word.trim();
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in afterquote yet, index ' + this.place);
    };
    Parser.prototype.afterItem = function (char) {
        if (char === ',') {
            if (this.word !== null) {
                this.currentObject.push(this.word);
            }
            this.word = null;
            this.state = NEUTRAL;
            return;
        }
        if (char === ']') {
            this.level--;
            if (this.word !== null) {
                this.currentObject.push(this.word);
                this.word = null;
            }
            this.state = NEUTRAL;
            this.currentObject = this.stack.pop();
            if (!this.currentObject) {
                this.state = ENDED;
            }
            return;
        }
    };
    Parser.prototype.number = function (char) {
        if (digets.test(char)) {
            this.word += char;
            return;
        }
        if (endThings.test(char)) {
            this.word = parseFloat(this.word);
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in number yet, index ' + this.place);
    };
    Parser.prototype.quoted = function (char) {
        if (char === '"') {
            this.state = AFTERQUOTE;
            return;
        }
        this.word += char;
        return;
    };
    Parser.prototype.keyword = function (char) {
        if (keyword.test(char)) {
            this.word += char;
            return;
        }
        if (char === '[') {
            var newObjects = [];
            newObjects.push(this.word);
            this.level++;
            if (this.root === null) {
                this.root = newObjects;
            }
            else {
                this.currentObject.push(newObjects);
            }
            this.stack.push(this.currentObject);
            this.currentObject = newObjects;
            this.state = NEUTRAL;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in keyword yet, index ' + this.place);
    };
    Parser.prototype.neutral = function (char) {
        if (latin.test(char)) {
            this.word = char;
            this.state = KEYWORD;
            return;
        }
        if (char === '"') {
            this.word = '';
            this.state = QUOTED;
            return;
        }
        if (digets.test(char)) {
            this.word = char;
            this.state = NUMBER;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in neutral yet, index ' + this.place);
    };
    Parser.prototype.output = function () {
        while (this.place < this.text.length) {
            this.readCharicter();
        }
        if (this.state === ENDED) {
            return this.root;
        }
        throw new Error('unable to parse string "' + this.text + '". State is ' + this.state);
    };
    function parseString(txt) {
        var parser = new Parser(txt);
        return parser.output();
    }
},
/* wkt-parser/process.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function mapit(obj, key, value) {
        if (Array.isArray(key)) {
            value.unshift(key);
            key = null;
        }
        var thing = key ? {} : obj;
        var out = value.reduce(function (newObj, item) {
            sExpr(item, newObj);
            return newObj;
        }, thing);
        if (key) {
            obj[key] = out;
        }
    }
    function sExpr(v, obj) {
        if (!Array.isArray(v)) {
            obj[v] = true;
            return;
        }
        var key = v.shift();
        if (key === 'PARAMETER') {
            key = v.shift();
        }
        if (v.length === 1) {
            if (Array.isArray(v[0])) {
                obj[key] = {};
                sExpr(v[0], obj[key]);
                return;
            }
            obj[key] = v[0];
            return;
        }
        if (!v.length) {
            obj[key] = true;
            return;
        }
        if (key === 'TOWGS84') {
            obj[key] = v;
            return;
        }
        if (key === 'AXIS') {
            if (!(key in obj)) {
                obj[key] = [];
            }
            obj[key].push(v);
            return;
        }
        if (!Array.isArray(key)) {
            obj[key] = {};
        }
        var i;
        switch (key) {
            case 'UNIT':
            case 'PRIMEM':
            case 'VERT_DATUM':
                obj[key] = {
                    name: v[0].toLowerCase(),
                    convert: v[1]
                };
                if (v.length === 3) {
                    sExpr(v[2], obj[key]);
                }
                return;
            case 'SPHEROID':
            case 'ELLIPSOID':
                obj[key] = {
                    name: v[0],
                    a: v[1],
                    rf: v[2]
                };
                if (v.length === 4) {
                    sExpr(v[3], obj[key]);
                }
                return;
            case 'PROJECTEDCRS':
            case 'PROJCRS':
            case 'GEOGCS':
            case 'GEOCCS':
            case 'PROJCS':
            case 'LOCAL_CS':
            case 'GEODCRS':
            case 'GEODETICCRS':
            case 'GEODETICDATUM':
            case 'EDATUM':
            case 'ENGINEERINGDATUM':
            case 'VERT_CS':
            case 'VERTCRS':
            case 'VERTICALCRS':
            case 'COMPD_CS':
            case 'COMPOUNDCRS':
            case 'ENGINEERINGCRS':
            case 'ENGCRS':
            case 'FITTED_CS':
            case 'LOCAL_DATUM':
            case 'DATUM':
                v[0] = ['name', v[0]];
                mapit(obj, key, v);
                return;
            default:
                i = -1;
                while (++i < v.length) {
                    if (!Array.isArray(v[i])) {
                        return sExpr(v, obj[key]);
                    }
                }
                return mapit(obj, key, v);
        }
    }
    exports.sExpr = sExpr;
},
/* proj4/lib/extend.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(destination, source) {
        destination = destination || {};
        var value, property;
        if (!source) {
            return destination;
        }
        for (property in source) {
            value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }
        return destination;
    }
    exports.default = default_1;
},
/* proj4/lib/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const merc_1 = (0, tslib_1.__importDefault)(require(94) /* ./projections/merc */);
    const longlat_1 = (0, tslib_1.__importDefault)(require(100) /* ./projections/longlat */);
    var projs = [merc_1.default, longlat_1.default];
    var names = {};
    var projStore = [];
    function add(proj, i) {
        var len = projStore.length;
        if (!proj.names) {
            console.log(i);
            return true;
        }
        projStore[len] = proj;
        proj.names.forEach(function (n) {
            names[n.toLowerCase()] = len;
        });
        return this;
    }
    exports.add = add;
    function get(name) {
        if (!name) {
            return false;
        }
        var n = name.toLowerCase();
        if (typeof names[n] !== 'undefined' && projStore[names[n]]) {
            return projStore[names[n]];
        }
    }
    exports.get = get;
    function start() {
        projs.forEach(add);
    }
    exports.start = start;
    exports.default = {
        start: start,
        add: add,
        get: get
    };
},
/* proj4/lib/projections/merc.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const msfnz_1 = (0, tslib_1.__importDefault)(require(95) /* ../common/msfnz */);
    const adjust_lon_1 = (0, tslib_1.__importDefault)(require(96) /* ../common/adjust_lon */);
    const tsfnz_1 = (0, tslib_1.__importDefault)(require(98) /* ../common/tsfnz */);
    const phi2z_1 = (0, tslib_1.__importDefault)(require(99) /* ../common/phi2z */);
    const values_1 = require(85) /* ../constants/values */;
    function init() {
        var con = this.b / this.a;
        this.es = 1 - con * con;
        if (!('x0' in this)) {
            this.x0 = 0;
        }
        if (!('y0' in this)) {
            this.y0 = 0;
        }
        this.e = Math.sqrt(this.es);
        if (this.lat_ts) {
            if (this.sphere) {
                this.k0 = Math.cos(this.lat_ts);
            }
            else {
                this.k0 = (0, msfnz_1.default)(this.e, Math.sin(this.lat_ts), Math.cos(this.lat_ts));
            }
        }
        else {
            if (!this.k0) {
                if (this.k) {
                    this.k0 = this.k;
                }
                else {
                    this.k0 = 1;
                }
            }
        }
    }
    exports.init = init;
    /* Mercator forward equations--mapping lat,long to x,y
      --------------------------------------------------*/
    function forward(p) {
        var lon = p.x;
        var lat = p.y;
        // convert to radians
        if (lat * values_1.R2D > 90 && lat * values_1.R2D < -90 && lon * values_1.R2D > 180 && lon * values_1.R2D < -180) {
            return null;
        }
        var x, y;
        if (Math.abs(Math.abs(lat) - values_1.HALF_PI) <= values_1.EPSLN) {
            return null;
        }
        else {
            if (this.sphere) {
                x = this.x0 + this.a * this.k0 * (0, adjust_lon_1.default)(lon - this.long0);
                y = this.y0 + this.a * this.k0 * Math.log(Math.tan(values_1.FORTPI + 0.5 * lat));
            }
            else {
                var sinphi = Math.sin(lat);
                var ts = (0, tsfnz_1.default)(this.e, lat, sinphi);
                x = this.x0 + this.a * this.k0 * (0, adjust_lon_1.default)(lon - this.long0);
                y = this.y0 - this.a * this.k0 * Math.log(ts);
            }
            p.x = x;
            p.y = y;
            return p;
        }
    }
    exports.forward = forward;
    /* Mercator inverse equations--mapping x,y to lat/long
      --------------------------------------------------*/
    function inverse(p) {
        var x = p.x - this.x0;
        var y = p.y - this.y0;
        var lon, lat;
        if (this.sphere) {
            lat = values_1.HALF_PI - 2 * Math.atan(Math.exp(-y / (this.a * this.k0)));
        }
        else {
            var ts = Math.exp(-y / (this.a * this.k0));
            lat = (0, phi2z_1.default)(this.e, ts);
            if (lat === -9999) {
                return null;
            }
        }
        lon = (0, adjust_lon_1.default)(this.long0 + x / (this.a * this.k0));
        p.x = lon;
        p.y = lat;
        return p;
    }
    exports.inverse = inverse;
    exports.names = ["Mercator", "Popular Visualisation Pseudo Mercator", "Mercator_1SP", "Mercator_Auxiliary_Sphere", "merc"];
    exports.default = {
        init: init,
        forward: forward,
        inverse: inverse,
        names: exports.names
    };
},
/* proj4/lib/common/msfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(eccent, sinphi, cosphi) {
        var con = eccent * sinphi;
        return cosphi / (Math.sqrt(1 - con * con));
    }
    exports.default = default_1;
},
/* proj4/lib/common/adjust_lon.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(85) /* ../constants/values */;
    const sign_1 = (0, tslib_1.__importDefault)(require(97) /* ./sign */);
    function default_1(x) {
        return (Math.abs(x) <= values_1.SPI) ? x : (x - ((0, sign_1.default)(x) * values_1.TWO_PI));
    }
    exports.default = default_1;
},
/* proj4/lib/common/sign.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(x) {
        return x < 0 ? -1 : 1;
    }
    exports.default = default_1;
},
/* proj4/lib/common/tsfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(85) /* ../constants/values */;
    function default_1(eccent, phi, sinphi) {
        var con = eccent * sinphi;
        var com = 0.5 * eccent;
        con = Math.pow(((1 - con) / (1 + con)), com);
        return (Math.tan(0.5 * (values_1.HALF_PI - phi)) / con);
    }
    exports.default = default_1;
},
/* proj4/lib/common/phi2z.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(85) /* ../constants/values */;
    function default_1(eccent, ts) {
        var eccnth = 0.5 * eccent;
        var con, dphi;
        var phi = values_1.HALF_PI - 2 * Math.atan(ts);
        for (var i = 0; i <= 15; i++) {
            con = eccent * Math.sin(phi);
            dphi = values_1.HALF_PI - 2 * Math.atan(ts * (Math.pow(((1 - con) / (1 + con)), eccnth))) - phi;
            phi += dphi;
            if (Math.abs(dphi) <= 0.0000000001) {
                return phi;
            }
        }
        //console.log("phi2z has NoConvergence");
        return -9999;
    }
    exports.default = default_1;
},
/* proj4/lib/projections/longlat.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function init() {
        //no-op for longlat
    }
    exports.init = init;
    function identity(pt) {
        return pt;
    }
    exports.forward = identity;
    exports.inverse = identity;
    exports.names = ["longlat", "identity"];
    exports.default = {
        init: init,
        forward: identity,
        inverse: identity,
        names: exports.names
    };
},
/* proj4/lib/deriveConstants.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(85) /* ./constants/values */;
    const Ellipsoid_1 = (0, tslib_1.__importStar)(require(102) /* ./constants/Ellipsoid */);
    const match_1 = (0, tslib_1.__importDefault)(require(88) /* ./match */);
    function eccentricity(a, b, rf, R_A) {
        var a2 = a * a; // used in geocentric
        var b2 = b * b; // used in geocentric
        var es = (a2 - b2) / a2; // e ^ 2
        var e = 0;
        if (R_A) {
            a *= 1 - es * (values_1.SIXTH + es * (values_1.RA4 + es * values_1.RA6));
            a2 = a * a;
            es = 0;
        }
        else {
            e = Math.sqrt(es); // eccentricity
        }
        var ep2 = (a2 - b2) / b2; // used in geocentric
        return {
            es: es,
            e: e,
            ep2: ep2
        };
    }
    exports.eccentricity = eccentricity;
    function sphere(a, b, rf, ellps, sphere) {
        if (!a) { // do we have an ellipsoid?
            var ellipse = (0, match_1.default)(Ellipsoid_1.default, ellps);
            if (!ellipse) {
                ellipse = Ellipsoid_1.WGS84;
            }
            a = ellipse.a;
            b = ellipse.b;
            rf = ellipse.rf;
        }
        if (rf && !b) {
            b = (1.0 - 1.0 / rf) * a;
        }
        if (rf === 0 || Math.abs(a - b) < values_1.EPSLN) {
            sphere = true;
            b = a;
        }
        return {
            a: a,
            b: b,
            rf: rf,
            sphere: sphere
        };
    }
    exports.sphere = sphere;
},
/* proj4/lib/constants/Ellipsoid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.MERIT = {
        a: 6378137.0,
        rf: 298.257,
        ellipseName: "MERIT 1983"
    };
    exports$1.SGS85 = {
        a: 6378136.0,
        rf: 298.257,
        ellipseName: "Soviet Geodetic System 85"
    };
    exports$1.GRS80 = {
        a: 6378137.0,
        rf: 298.257222101,
        ellipseName: "GRS 1980(IUGG, 1980)"
    };
    exports$1.IAU76 = {
        a: 6378140.0,
        rf: 298.257,
        ellipseName: "IAU 1976"
    };
    exports$1.airy = {
        a: 6377563.396,
        b: 6356256.910,
        ellipseName: "Airy 1830"
    };
    exports$1.APL4 = {
        a: 6378137,
        rf: 298.25,
        ellipseName: "Appl. Physics. 1965"
    };
    exports$1.NWL9D = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "Naval Weapons Lab., 1965"
    };
    exports$1.mod_airy = {
        a: 6377340.189,
        b: 6356034.446,
        ellipseName: "Modified Airy"
    };
    exports$1.andrae = {
        a: 6377104.43,
        rf: 300.0,
        ellipseName: "Andrae 1876 (Den., Iclnd.)"
    };
    exports$1.aust_SA = {
        a: 6378160.0,
        rf: 298.25,
        ellipseName: "Australian Natl & S. Amer. 1969"
    };
    exports$1.GRS67 = {
        a: 6378160.0,
        rf: 298.2471674270,
        ellipseName: "GRS 67(IUGG 1967)"
    };
    exports$1.bessel = {
        a: 6377397.155,
        rf: 299.1528128,
        ellipseName: "Bessel 1841"
    };
    exports$1.bess_nam = {
        a: 6377483.865,
        rf: 299.1528128,
        ellipseName: "Bessel 1841 (Namibia)"
    };
    exports$1.clrk66 = {
        a: 6378206.4,
        b: 6356583.8,
        ellipseName: "Clarke 1866"
    };
    exports$1.clrk80 = {
        a: 6378249.145,
        rf: 293.4663,
        ellipseName: "Clarke 1880 mod."
    };
    exports$1.clrk58 = {
        a: 6378293.645208759,
        rf: 294.2606763692654,
        ellipseName: "Clarke 1858"
    };
    exports$1.CPM = {
        a: 6375738.7,
        rf: 334.29,
        ellipseName: "Comm. des Poids et Mesures 1799"
    };
    exports$1.delmbr = {
        a: 6376428.0,
        rf: 311.5,
        ellipseName: "Delambre 1810 (Belgium)"
    };
    exports$1.engelis = {
        a: 6378136.05,
        rf: 298.2566,
        ellipseName: "Engelis 1985"
    };
    exports$1.evrst30 = {
        a: 6377276.345,
        rf: 300.8017,
        ellipseName: "Everest 1830"
    };
    exports$1.evrst48 = {
        a: 6377304.063,
        rf: 300.8017,
        ellipseName: "Everest 1948"
    };
    exports$1.evrst56 = {
        a: 6377301.243,
        rf: 300.8017,
        ellipseName: "Everest 1956"
    };
    exports$1.evrst69 = {
        a: 6377295.664,
        rf: 300.8017,
        ellipseName: "Everest 1969"
    };
    exports$1.evrstSS = {
        a: 6377298.556,
        rf: 300.8017,
        ellipseName: "Everest (Sabah & Sarawak)"
    };
    exports$1.fschr60 = {
        a: 6378166.0,
        rf: 298.3,
        ellipseName: "Fischer (Mercury Datum) 1960"
    };
    exports$1.fschr60m = {
        a: 6378155.0,
        rf: 298.3,
        ellipseName: "Fischer 1960"
    };
    exports$1.fschr68 = {
        a: 6378150.0,
        rf: 298.3,
        ellipseName: "Fischer 1968"
    };
    exports$1.helmert = {
        a: 6378200.0,
        rf: 298.3,
        ellipseName: "Helmert 1906"
    };
    exports$1.hough = {
        a: 6378270.0,
        rf: 297.0,
        ellipseName: "Hough"
    };
    exports$1.intl = {
        a: 6378388.0,
        rf: 297.0,
        ellipseName: "International 1909 (Hayford)"
    };
    exports$1.kaula = {
        a: 6378163.0,
        rf: 298.24,
        ellipseName: "Kaula 1961"
    };
    exports$1.lerch = {
        a: 6378139.0,
        rf: 298.257,
        ellipseName: "Lerch 1979"
    };
    exports$1.mprts = {
        a: 6397300.0,
        rf: 191.0,
        ellipseName: "Maupertius 1738"
    };
    exports$1.new_intl = {
        a: 6378157.5,
        b: 6356772.2,
        ellipseName: "New International 1967"
    };
    exports$1.plessis = {
        a: 6376523.0,
        rf: 6355863.0,
        ellipseName: "Plessis 1817 (France)"
    };
    exports$1.krass = {
        a: 6378245.0,
        rf: 298.3,
        ellipseName: "Krassovsky, 1942"
    };
    exports$1.SEasia = {
        a: 6378155.0,
        b: 6356773.3205,
        ellipseName: "Southeast Asia"
    };
    exports$1.walbeck = {
        a: 6376896.0,
        b: 6355834.8467,
        ellipseName: "Walbeck"
    };
    exports$1.WGS60 = {
        a: 6378165.0,
        rf: 298.3,
        ellipseName: "WGS 60"
    };
    exports$1.WGS66 = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "WGS 66"
    };
    exports$1.WGS7 = {
        a: 6378135.0,
        rf: 298.26,
        ellipseName: "WGS 72"
    };
    exports.WGS84 = exports$1.WGS84 = {
        a: 6378137.0,
        rf: 298.257223563,
        ellipseName: "WGS 84"
    };
    exports$1.sphere = {
        a: 6370997.0,
        b: 6370997.0,
        ellipseName: "Normal Sphere (r=6370997)"
    };
},
/* proj4/lib/constants/Datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.wgs84 = {
        towgs84: "0,0,0",
        ellipse: "WGS84",
        datumName: "WGS84"
    };
    exports$1.ch1903 = {
        towgs84: "674.374,15.056,405.346",
        ellipse: "bessel",
        datumName: "swiss"
    };
    exports$1.ggrs87 = {
        towgs84: "-199.87,74.79,246.62",
        ellipse: "GRS80",
        datumName: "Greek_Geodetic_Reference_System_1987"
    };
    exports$1.nad83 = {
        towgs84: "0,0,0",
        ellipse: "GRS80",
        datumName: "North_American_Datum_1983"
    };
    exports$1.nad27 = {
        nadgrids: "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",
        ellipse: "clrk66",
        datumName: "North_American_Datum_1927"
    };
    exports$1.potsdam = {
        towgs84: "598.1,73.7,418.2,0.202,0.045,-2.455,6.7",
        ellipse: "bessel",
        datumName: "Potsdam Rauenberg 1950 DHDN"
    };
    exports$1.carthage = {
        towgs84: "-263.0,6.0,431.0",
        ellipse: "clark80",
        datumName: "Carthage 1934 Tunisia"
    };
    exports$1.hermannskogel = {
        towgs84: "577.326,90.129,463.919,5.137,1.474,5.297,2.4232",
        ellipse: "bessel",
        datumName: "Hermannskogel"
    };
    exports$1.osni52 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "airy",
        datumName: "Irish National"
    };
    exports$1.ire65 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "mod_airy",
        datumName: "Ireland 1965"
    };
    exports$1.rassadiran = {
        towgs84: "-133.63,-157.5,-158.62",
        ellipse: "intl",
        datumName: "Rassadiran"
    };
    exports$1.nzgd49 = {
        towgs84: "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",
        ellipse: "intl",
        datumName: "New Zealand Geodetic Datum 1949"
    };
    exports$1.osgb36 = {
        towgs84: "446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",
        ellipse: "airy",
        datumName: "Airy 1830"
    };
    exports$1.s_jtsk = {
        towgs84: "589,76,480",
        ellipse: 'bessel',
        datumName: 'S-JTSK (Ferro)'
    };
    exports$1.beduaram = {
        towgs84: '-106,-87,188',
        ellipse: 'clrk80',
        datumName: 'Beduaram'
    };
    exports$1.gunung_segara = {
        towgs84: '-403,684,41',
        ellipse: 'bessel',
        datumName: 'Gunung Segara Jakarta'
    };
    exports$1.rnb72 = {
        towgs84: "106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",
        ellipse: "intl",
        datumName: "Reseau National Belge 1972"
    };
},
/* proj4/lib/datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(85) /* ./constants/values */;
    function datum(datumCode, datum_params, a, b, es, ep2, nadgrids) {
        var out = {};
        if (datumCode === undefined || datumCode === 'none') {
            out.datum_type = values_1.PJD_NODATUM;
        }
        else {
            out.datum_type = values_1.PJD_WGS84;
        }
        if (datum_params) {
            out.datum_params = datum_params.map(parseFloat);
            if (out.datum_params[0] !== 0 || out.datum_params[1] !== 0 || out.datum_params[2] !== 0) {
                out.datum_type = values_1.PJD_3PARAM;
            }
            if (out.datum_params.length > 3) {
                if (out.datum_params[3] !== 0 || out.datum_params[4] !== 0 || out.datum_params[5] !== 0 || out.datum_params[6] !== 0) {
                    out.datum_type = values_1.PJD_7PARAM;
                    out.datum_params[3] *= values_1.SEC_TO_RAD;
                    out.datum_params[4] *= values_1.SEC_TO_RAD;
                    out.datum_params[5] *= values_1.SEC_TO_RAD;
                    out.datum_params[6] = (out.datum_params[6] / 1000000.0) + 1.0;
                }
            }
        }
        if (nadgrids) {
            out.datum_type = values_1.PJD_GRIDSHIFT;
            out.grids = nadgrids;
        }
        out.a = a; //datum object also uses these values
        out.b = b;
        out.es = es;
        out.ep2 = ep2;
        return out;
    }
    exports.default = datum;
},
/* proj4/lib/nadgrid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var loadedNadgrids = {};
    /**
     * Load a binary NTv2 file (.gsb) to a key that can be used in a proj string like +nadgrids=<key>. Pass the NTv2 file
     * as an ArrayBuffer.
     */
    function nadgrid(key, data) {
        var view = new DataView(data);
        var isLittleEndian = detectLittleEndian(view);
        var header = readHeader(view, isLittleEndian);
        if (header.nSubgrids > 1) {
            console.log('Only single NTv2 subgrids are currently supported, subsequent sub grids are ignored');
        }
        var subgrids = readSubgrids(view, header, isLittleEndian);
        var nadgrid = { header: header, subgrids: subgrids };
        loadedNadgrids[key] = nadgrid;
        return nadgrid;
    }
    exports.default = nadgrid;
    /**
     * Given a proj4 value for nadgrids, return an array of loaded grids
     */
    function getNadgrids(nadgrids) {
        // Format details: http://proj.maptools.org/gen_parms.html
        if (nadgrids === undefined) {
            return null;
        }
        var grids = nadgrids.split(',');
        return grids.map(parseNadgridString);
    }
    exports.getNadgrids = getNadgrids;
    function parseNadgridString(value) {
        if (value.length === 0) {
            return null;
        }
        var optional = value[0] === '@';
        if (optional) {
            value = value.slice(1);
        }
        if (value === 'null') {
            return { name: 'null', mandatory: !optional, grid: null, isNull: true };
        }
        return {
            name: value,
            mandatory: !optional,
            grid: loadedNadgrids[value] || null,
            isNull: false
        };
    }
    function secondsToRadians(seconds) {
        return (seconds / 3600) * Math.PI / 180;
    }
    function detectLittleEndian(view) {
        var nFields = view.getInt32(8, false);
        if (nFields === 11) {
            return false;
        }
        nFields = view.getInt32(8, true);
        if (nFields !== 11) {
            console.warn('Failed to detect nadgrid endian-ness, defaulting to little-endian');
        }
        return true;
    }
    function readHeader(view, isLittleEndian) {
        return {
            nFields: view.getInt32(8, isLittleEndian),
            nSubgridFields: view.getInt32(24, isLittleEndian),
            nSubgrids: view.getInt32(40, isLittleEndian),
            shiftType: decodeString(view, 56, 56 + 8).trim(),
            fromSemiMajorAxis: view.getFloat64(120, isLittleEndian),
            fromSemiMinorAxis: view.getFloat64(136, isLittleEndian),
            toSemiMajorAxis: view.getFloat64(152, isLittleEndian),
            toSemiMinorAxis: view.getFloat64(168, isLittleEndian),
        };
    }
    function decodeString(view, start, end) {
        return String.fromCharCode.apply(null, new Uint8Array(view.buffer.slice(start, end)));
    }
    function readSubgrids(view, header, isLittleEndian) {
        var gridOffset = 176;
        var grids = [];
        for (var i = 0; i < header.nSubgrids; i++) {
            var subHeader = readGridHeader(view, gridOffset, isLittleEndian);
            var nodes = readGridNodes(view, gridOffset, subHeader, isLittleEndian);
            var lngColumnCount = Math.round(1 + (subHeader.upperLongitude - subHeader.lowerLongitude) / subHeader.longitudeInterval);
            var latColumnCount = Math.round(1 + (subHeader.upperLatitude - subHeader.lowerLatitude) / subHeader.latitudeInterval);
            // Proj4 operates on radians whereas the coordinates are in seconds in the grid
            grids.push({
                ll: [secondsToRadians(subHeader.lowerLongitude), secondsToRadians(subHeader.lowerLatitude)],
                del: [secondsToRadians(subHeader.longitudeInterval), secondsToRadians(subHeader.latitudeInterval)],
                lim: [lngColumnCount, latColumnCount],
                count: subHeader.gridNodeCount,
                cvs: mapNodes(nodes)
            });
        }
        return grids;
    }
    function mapNodes(nodes) {
        return nodes.map(function (r) { return [secondsToRadians(r.longitudeShift), secondsToRadians(r.latitudeShift)]; });
    }
    function readGridHeader(view, offset, isLittleEndian) {
        return {
            name: decodeString(view, offset + 8, offset + 16).trim(),
            parent: decodeString(view, offset + 24, offset + 24 + 8).trim(),
            lowerLatitude: view.getFloat64(offset + 72, isLittleEndian),
            upperLatitude: view.getFloat64(offset + 88, isLittleEndian),
            lowerLongitude: view.getFloat64(offset + 104, isLittleEndian),
            upperLongitude: view.getFloat64(offset + 120, isLittleEndian),
            latitudeInterval: view.getFloat64(offset + 136, isLittleEndian),
            longitudeInterval: view.getFloat64(offset + 152, isLittleEndian),
            gridNodeCount: view.getInt32(offset + 168, isLittleEndian)
        };
    }
    function readGridNodes(view, offset, gridHeader, isLittleEndian) {
        var nodesOffset = offset + 176;
        var gridRecordLength = 16;
        var gridShiftRecords = [];
        for (var i = 0; i < gridHeader.gridNodeCount; i++) {
            var record = {
                latitudeShift: view.getFloat32(nodesOffset + i * gridRecordLength, isLittleEndian),
                longitudeShift: view.getFloat32(nodesOffset + i * gridRecordLength + 4, isLittleEndian),
                latitudeAccuracy: view.getFloat32(nodesOffset + i * gridRecordLength + 8, isLittleEndian),
                longitudeAccuracy: view.getFloat32(nodesOffset + i * gridRecordLength + 12, isLittleEndian),
            };
            gridShiftRecords.push(record);
        }
        return gridShiftRecords;
    }
},
/* proj4/lib/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(85) /* ./constants/values */;
    const datum_transform_1 = (0, tslib_1.__importDefault)(require(107) /* ./datum_transform */);
    const adjust_axis_1 = (0, tslib_1.__importDefault)(require(109) /* ./adjust_axis */);
    const Proj_1 = (0, tslib_1.__importDefault)(require(80) /* ./Proj */);
    const toPoint_1 = (0, tslib_1.__importDefault)(require(110) /* ./common/toPoint */);
    const checkSanity_1 = (0, tslib_1.__importDefault)(require(111) /* ./checkSanity */);
    function checkNotWGS(source, dest) {
        return ((source.datum.datum_type === values_1.PJD_3PARAM || source.datum.datum_type === values_1.PJD_7PARAM) && dest.datumCode !== 'WGS84') || ((dest.datum.datum_type === values_1.PJD_3PARAM || dest.datum.datum_type === values_1.PJD_7PARAM) && source.datumCode !== 'WGS84');
    }
    function transform(source, dest, point, enforceAxis) {
        var wgs84;
        if (Array.isArray(point)) {
            point = (0, toPoint_1.default)(point);
        }
        (0, checkSanity_1.default)(point);
        // Workaround for datum shifts towgs84, if either source or destination projection is not wgs84
        if (source.datum && dest.datum && checkNotWGS(source, dest)) {
            wgs84 = new Proj_1.default('WGS84');
            point = transform(source, wgs84, point, enforceAxis);
            source = wgs84;
        }
        // DGR, 2010/11/12
        if (enforceAxis && source.axis !== 'enu') {
            point = (0, adjust_axis_1.default)(source, false, point);
        }
        // Transform source points to long/lat, if they aren't already.
        if (source.projName === 'longlat') {
            point = {
                x: point.x * values_1.D2R,
                y: point.y * values_1.D2R,
                z: point.z || 0
            };
        }
        else {
            if (source.to_meter) {
                point = {
                    x: point.x * source.to_meter,
                    y: point.y * source.to_meter,
                    z: point.z || 0
                };
            }
            point = source.inverse(point); // Convert Cartesian to longlat
            if (!point) {
                return;
            }
        }
        // Adjust for the prime meridian if necessary
        if (source.from_greenwich) {
            point.x += source.from_greenwich;
        }
        // Convert datums if needed, and if possible.
        point = (0, datum_transform_1.default)(source.datum, dest.datum, point);
        if (!point) {
            return;
        }
        // Adjust for the prime meridian if necessary
        if (dest.from_greenwich) {
            point = {
                x: point.x - dest.from_greenwich,
                y: point.y,
                z: point.z || 0
            };
        }
        if (dest.projName === 'longlat') {
            // convert radians to decimal degrees
            point = {
                x: point.x * values_1.R2D,
                y: point.y * values_1.R2D,
                z: point.z || 0
            };
        }
        else { // else project
            point = dest.forward(point);
            if (dest.to_meter) {
                point = {
                    x: point.x / dest.to_meter,
                    y: point.y / dest.to_meter,
                    z: point.z || 0
                };
            }
        }
        // DGR, 2010/11/12
        if (enforceAxis && dest.axis !== 'enu') {
            return (0, adjust_axis_1.default)(dest, true, point);
        }
        return point;
    }
    exports.default = transform;
},
/* proj4/lib/datum_transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(85) /* ./constants/values */;
    const datumUtils_1 = require(108) /* ./datumUtils */;
    const adjust_lon_1 = (0, tslib_1.__importDefault)(require(96) /* ./common/adjust_lon */);
    function checkParams(type) {
        return (type === values_1.PJD_3PARAM || type === values_1.PJD_7PARAM);
    }
    function default_1(source, dest, point) {
        // Short cut if the datums are identical.
        if ((0, datumUtils_1.compareDatums)(source, dest)) {
            return point; // in this case, zero is sucess,
            // whereas cs_compare_datums returns 1 to indicate TRUE
            // confusing, should fix this
        }
        // Explicitly skip datum transform by setting 'datum=none' as parameter for either source or dest
        if (source.datum_type === values_1.PJD_NODATUM || dest.datum_type === values_1.PJD_NODATUM) {
            return point;
        }
        // If this datum requires grid shifts, then apply it to geodetic coordinates.
        var source_a = source.a;
        var source_es = source.es;
        if (source.datum_type === values_1.PJD_GRIDSHIFT) {
            var gridShiftCode = applyGridShift(source, false, point);
            if (gridShiftCode !== 0) {
                return undefined;
            }
            source_a = values_1.SRS_WGS84_SEMIMAJOR;
            source_es = values_1.SRS_WGS84_ESQUARED;
        }
        var dest_a = dest.a;
        var dest_b = dest.b;
        var dest_es = dest.es;
        if (dest.datum_type === values_1.PJD_GRIDSHIFT) {
            dest_a = values_1.SRS_WGS84_SEMIMAJOR;
            dest_b = values_1.SRS_WGS84_SEMIMINOR;
            dest_es = values_1.SRS_WGS84_ESQUARED;
        }
        // Do we need to go through geocentric coordinates?
        if (source_es === dest_es && source_a === dest_a && !checkParams(source.datum_type) && !checkParams(dest.datum_type)) {
            return point;
        }
        // Convert to geocentric coordinates.
        point = (0, datumUtils_1.geodeticToGeocentric)(point, source_es, source_a);
        // Convert between datums
        if (checkParams(source.datum_type)) {
            point = (0, datumUtils_1.geocentricToWgs84)(point, source.datum_type, source.datum_params);
        }
        if (checkParams(dest.datum_type)) {
            point = (0, datumUtils_1.geocentricFromWgs84)(point, dest.datum_type, dest.datum_params);
        }
        point = (0, datumUtils_1.geocentricToGeodetic)(point, dest_es, dest_a, dest_b);
        if (dest.datum_type === values_1.PJD_GRIDSHIFT) {
            var destGridShiftResult = applyGridShift(dest, true, point);
            if (destGridShiftResult !== 0) {
                return undefined;
            }
        }
        return point;
    }
    exports.default = default_1;
    function applyGridShift(source, inverse, point) {
        if (source.grids === null || source.grids.length === 0) {
            console.log('Grid shift grids not found');
            return -1;
        }
        var input = { x: -point.x, y: point.y };
        var output = { x: Number.NaN, y: Number.NaN };
        var onlyMandatoryGrids = false;
        var attemptedGrids = [];
        for (var i = 0; i < source.grids.length; i++) {
            var grid = source.grids[i];
            attemptedGrids.push(grid.name);
            if (grid.isNull) {
                output = input;
                break;
            }
            onlyMandatoryGrids = grid.mandatory;
            if (grid.grid === null) {
                if (grid.mandatory) {
                    console.log("Unable to find mandatory grid '" + grid.name + "'");
                    return -1;
                }
                continue;
            }
            var subgrid = grid.grid.subgrids[0];
            // skip tables that don't match our point at all
            var epsilon = (Math.abs(subgrid.del[1]) + Math.abs(subgrid.del[0])) / 10000.0;
            var minX = subgrid.ll[0] - epsilon;
            var minY = subgrid.ll[1] - epsilon;
            var maxX = subgrid.ll[0] + (subgrid.lim[0] - 1) * subgrid.del[0] + epsilon;
            var maxY = subgrid.ll[1] + (subgrid.lim[1] - 1) * subgrid.del[1] + epsilon;
            if (minY > input.y || minX > input.x || maxY < input.y || maxX < input.x) {
                continue;
            }
            output = applySubgridShift(input, inverse, subgrid);
            if (!isNaN(output.x)) {
                break;
            }
        }
        if (isNaN(output.x)) {
            console.log("Failed to find a grid shift table for location '" +
                -input.x * values_1.R2D + " " + input.y * values_1.R2D + " tried: '" + attemptedGrids + "'");
            return -1;
        }
        point.x = -output.x;
        point.y = output.y;
        return 0;
    }
    exports.applyGridShift = applyGridShift;
    function applySubgridShift(pin, inverse, ct) {
        var val = { x: Number.NaN, y: Number.NaN };
        if (isNaN(pin.x)) {
            return val;
        }
        var tb = { x: pin.x, y: pin.y };
        tb.x -= ct.ll[0];
        tb.y -= ct.ll[1];
        tb.x = (0, adjust_lon_1.default)(tb.x - Math.PI) + Math.PI;
        var t = nadInterpolate(tb, ct);
        if (inverse) {
            if (isNaN(t.x)) {
                return val;
            }
            t.x = tb.x - t.x;
            t.y = tb.y - t.y;
            var i = 9, tol = 1e-12;
            var dif, del;
            do {
                del = nadInterpolate(t, ct);
                if (isNaN(del.x)) {
                    console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");
                    break;
                }
                dif = { x: tb.x - (del.x + t.x), y: tb.y - (del.y + t.y) };
                t.x += dif.x;
                t.y += dif.y;
            } while (i-- && Math.abs(dif.x) > tol && Math.abs(dif.y) > tol);
            if (i < 0) {
                console.log("Inverse grid shift iterator failed to converge.");
                return val;
            }
            val.x = (0, adjust_lon_1.default)(t.x + ct.ll[0]);
            val.y = t.y + ct.ll[1];
        }
        else {
            if (!isNaN(t.x)) {
                val.x = pin.x + t.x;
                val.y = pin.y + t.y;
            }
        }
        return val;
    }
    function nadInterpolate(pin, ct) {
        var t = { x: pin.x / ct.del[0], y: pin.y / ct.del[1] };
        var indx = { x: Math.floor(t.x), y: Math.floor(t.y) };
        var frct = { x: t.x - 1.0 * indx.x, y: t.y - 1.0 * indx.y };
        var val = { x: Number.NaN, y: Number.NaN };
        var inx;
        if (indx.x < 0 || indx.x >= ct.lim[0]) {
            return val;
        }
        if (indx.y < 0 || indx.y >= ct.lim[1]) {
            return val;
        }
        inx = (indx.y * ct.lim[0]) + indx.x;
        var f00 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx++;
        var f10 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx += ct.lim[0];
        var f11 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx--;
        var f01 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        var m11 = frct.x * frct.y, m10 = frct.x * (1.0 - frct.y), m00 = (1.0 - frct.x) * (1.0 - frct.y), m01 = (1.0 - frct.x) * frct.y;
        val.x = (m00 * f00.x + m10 * f10.x + m01 * f01.x + m11 * f11.x);
        val.y = (m00 * f00.y + m10 * f10.y + m01 * f01.y + m11 * f11.y);
        return val;
    }
},
/* proj4/lib/datumUtils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(85) /* ./constants/values */;
    function compareDatums(source, dest) {
        if (source.datum_type !== dest.datum_type) {
            return false; // false, datums are not equal
        }
        else if (source.a !== dest.a || Math.abs(source.es - dest.es) > 0.000000000050) {
            // the tolerance for es is to ensure that GRS80 and WGS84
            // are considered identical
            return false;
        }
        else if (source.datum_type === values_1.PJD_3PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2]);
        }
        else if (source.datum_type === values_1.PJD_7PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2] && source.datum_params[3] === dest.datum_params[3] && source.datum_params[4] === dest.datum_params[4] && source.datum_params[5] === dest.datum_params[5] && source.datum_params[6] === dest.datum_params[6]);
        }
        else {
            return true; // datums are equal
        }
    } // cs_compare_datums()
    exports.compareDatums = compareDatums;
    /*
     * The function Convert_Geodetic_To_Geocentric converts geodetic coordinates
     * (latitude, longitude, and height) to geocentric coordinates (X, Y, Z),
     * according to the current ellipsoid parameters.
     *
     *    Latitude  : Geodetic latitude in radians                     (input)
     *    Longitude : Geodetic longitude in radians                    (input)
     *    Height    : Geodetic height, in meters                       (input)
     *    X         : Calculated Geocentric X coordinate, in meters    (output)
     *    Y         : Calculated Geocentric Y coordinate, in meters    (output)
     *    Z         : Calculated Geocentric Z coordinate, in meters    (output)
     *
     */
    function geodeticToGeocentric(p, es, a) {
        var Longitude = p.x;
        var Latitude = p.y;
        var Height = p.z ? p.z : 0; //Z value not always supplied
        var Rn; /*  Earth radius at location  */
        var Sin_Lat; /*  Math.sin(Latitude)  */
        var Sin2_Lat; /*  Square of Math.sin(Latitude)  */
        var Cos_Lat; /*  Math.cos(Latitude)  */
        /*
         ** Don't blow up if Latitude is just a little out of the value
         ** range as it may just be a rounding issue.  Also removed longitude
         ** test, it should be wrapped by Math.cos() and Math.sin().  NFW for PROJ.4, Sep/2001.
         */
        if (Latitude < -values_1.HALF_PI && Latitude > -1.001 * values_1.HALF_PI) {
            Latitude = -values_1.HALF_PI;
        }
        else if (Latitude > values_1.HALF_PI && Latitude < 1.001 * values_1.HALF_PI) {
            Latitude = values_1.HALF_PI;
        }
        else if (Latitude < -values_1.HALF_PI) {
            /* Latitude out of range */
            //..reportError('geocent:lat out of range:' + Latitude);
            return { x: -Infinity, y: -Infinity, z: p.z };
        }
        else if (Latitude > values_1.HALF_PI) {
            /* Latitude out of range */
            return { x: Infinity, y: Infinity, z: p.z };
        }
        if (Longitude > Math.PI) {
            Longitude -= (2 * Math.PI);
        }
        Sin_Lat = Math.sin(Latitude);
        Cos_Lat = Math.cos(Latitude);
        Sin2_Lat = Sin_Lat * Sin_Lat;
        Rn = a / (Math.sqrt(1.0e0 - es * Sin2_Lat));
        return {
            x: (Rn + Height) * Cos_Lat * Math.cos(Longitude),
            y: (Rn + Height) * Cos_Lat * Math.sin(Longitude),
            z: ((Rn * (1 - es)) + Height) * Sin_Lat
        };
    } // cs_geodetic_to_geocentric()
    exports.geodeticToGeocentric = geodeticToGeocentric;
    function geocentricToGeodetic(p, es, a, b) {
        /* local defintions and variables */
        /* end-criterium of loop, accuracy of sin(Latitude) */
        var genau = 1e-12;
        var genau2 = (genau * genau);
        var maxiter = 30;
        var P; /* distance between semi-minor axis and location */
        var RR; /* distance between center and location */
        var CT; /* sin of geocentric latitude */
        var ST; /* cos of geocentric latitude */
        var RX;
        var RK;
        var RN; /* Earth radius at location */
        var CPHI0; /* cos of start or old geodetic latitude in iterations */
        var SPHI0; /* sin of start or old geodetic latitude in iterations */
        var CPHI; /* cos of searched geodetic latitude */
        var SPHI; /* sin of searched geodetic latitude */
        var SDPHI; /* end-criterium: addition-theorem of sin(Latitude(iter)-Latitude(iter-1)) */
        var iter; /* # of continous iteration, max. 30 is always enough (s.a.) */
        var X = p.x;
        var Y = p.y;
        var Z = p.z ? p.z : 0.0; //Z value not always supplied
        var Longitude;
        var Latitude;
        var Height;
        P = Math.sqrt(X * X + Y * Y);
        RR = Math.sqrt(X * X + Y * Y + Z * Z);
        /*      special cases for latitude and longitude */
        if (P / a < genau) {
            /*  special case, if P=0. (X=0., Y=0.) */
            Longitude = 0.0;
            /*  if (X,Y,Z)=(0.,0.,0.) then Height becomes semi-minor axis
             *  of ellipsoid (=center of mass), Latitude becomes PI/2 */
            if (RR / a < genau) {
                Latitude = values_1.HALF_PI;
                Height = -b;
                return {
                    x: p.x,
                    y: p.y,
                    z: p.z
                };
            }
        }
        else {
            /*  ellipsoidal (geodetic) longitude
             *  interval: -PI < Longitude <= +PI */
            Longitude = Math.atan2(Y, X);
        }
        /* --------------------------------------------------------------
         * Following iterative algorithm was developped by
         * "Institut for Erdmessung", University of Hannover, July 1988.
         * Internet: www.ife.uni-hannover.de
         * Iterative computation of CPHI,SPHI and Height.
         * Iteration of CPHI and SPHI to 10**-12 radian resp.
         * 2*10**-7 arcsec.
         * --------------------------------------------------------------
         */
        CT = Z / RR;
        ST = P / RR;
        RX = 1.0 / Math.sqrt(1.0 - es * (2.0 - es) * ST * ST);
        CPHI0 = ST * (1.0 - es) * RX;
        SPHI0 = CT * RX;
        iter = 0;
        /* loop to find sin(Latitude) resp. Latitude
         * until |sin(Latitude(iter)-Latitude(iter-1))| < genau */
        do {
            iter++;
            RN = a / Math.sqrt(1.0 - es * SPHI0 * SPHI0);
            /*  ellipsoidal (geodetic) height */
            Height = P * CPHI0 + Z * SPHI0 - RN * (1.0 - es * SPHI0 * SPHI0);
            RK = es * RN / (RN + Height);
            RX = 1.0 / Math.sqrt(1.0 - RK * (2.0 - RK) * ST * ST);
            CPHI = ST * (1.0 - RK) * RX;
            SPHI = CT * RX;
            SDPHI = SPHI * CPHI0 - CPHI * SPHI0;
            CPHI0 = CPHI;
            SPHI0 = SPHI;
        } while (SDPHI * SDPHI > genau2 && iter < maxiter);
        /*      ellipsoidal (geodetic) latitude */
        Latitude = Math.atan(SPHI / Math.abs(CPHI));
        return {
            x: Longitude,
            y: Latitude,
            z: Height
        };
    } // cs_geocentric_to_geodetic()
    exports.geocentricToGeodetic = geocentricToGeodetic;
    /****************************************************************/
    // pj_geocentic_to_wgs84( p )
    //  p = point to transform in geocentric coordinates (x,y,z)
    /** point object, nothing fancy, just allows values to be
        passed back and forth by reference rather than by value.
        Other point classes may be used as long as they have
        x and y properties, which will get modified in the transform method.
    */
    function geocentricToWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x + datum_params[0],
                y: p.y + datum_params[1],
                z: p.z + datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: M_BF * (p.x - Rz_BF * p.y + Ry_BF * p.z) + Dx_BF,
                y: M_BF * (Rz_BF * p.x + p.y - Rx_BF * p.z) + Dy_BF,
                z: M_BF * (-Ry_BF * p.x + Rx_BF * p.y + p.z) + Dz_BF
            };
        }
    } // cs_geocentric_to_wgs84
    exports.geocentricToWgs84 = geocentricToWgs84;
    /****************************************************************/
    // pj_geocentic_from_wgs84()
    //  coordinate system definition,
    //  point to transform in geocentric coordinates (x,y,z)
    function geocentricFromWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x - datum_params[0],
                y: p.y - datum_params[1],
                z: p.z - datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            var x_tmp = (p.x - Dx_BF) / M_BF;
            var y_tmp = (p.y - Dy_BF) / M_BF;
            var z_tmp = (p.z - Dz_BF) / M_BF;
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: x_tmp + Rz_BF * y_tmp - Ry_BF * z_tmp,
                y: -Rz_BF * x_tmp + y_tmp + Rx_BF * z_tmp,
                z: Ry_BF * x_tmp - Rx_BF * y_tmp + z_tmp
            };
        } //cs_geocentric_from_wgs84()
    }
    exports.geocentricFromWgs84 = geocentricFromWgs84;
},
/* proj4/lib/adjust_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(crs, denorm, point) {
        var xin = point.x, yin = point.y, zin = point.z || 0.0;
        var v, t, i;
        var out = {};
        for (i = 0; i < 3; i++) {
            if (denorm && i === 2 && point.z === undefined) {
                continue;
            }
            if (i === 0) {
                v = xin;
                if ("ew".indexOf(crs.axis[i]) !== -1) {
                    t = 'x';
                }
                else {
                    t = 'y';
                }
            }
            else if (i === 1) {
                v = yin;
                if ("ns".indexOf(crs.axis[i]) !== -1) {
                    t = 'y';
                }
                else {
                    t = 'x';
                }
            }
            else {
                v = zin;
                t = 'z';
            }
            switch (crs.axis[i]) {
                case 'e':
                    out[t] = v;
                    break;
                case 'w':
                    out[t] = -v;
                    break;
                case 'n':
                    out[t] = v;
                    break;
                case 's':
                    out[t] = -v;
                    break;
                case 'u':
                    if (point[t] !== undefined) {
                        out.z = v;
                    }
                    break;
                case 'd':
                    if (point[t] !== undefined) {
                        out.z = -v;
                    }
                    break;
                default:
                    //console.log("ERROR: unknow axis ("+crs.axis[i]+") - check definition of "+crs.projName);
                    return null;
            }
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/common/toPoint.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(array) {
        var out = {
            x: array[0],
            y: array[1]
        };
        if (array.length > 2) {
            out.z = array[2];
        }
        if (array.length > 3) {
            out.m = array[3];
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/checkSanity.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(point) {
        checkCoord(point.x);
        checkCoord(point.y);
    }
    exports.default = default_1;
    function checkCoord(num) {
        if (typeof Number.isFinite === 'function') {
            if (Number.isFinite(num)) {
                return;
            }
            throw new TypeError('coordinates must be finite numbers');
        }
        if (typeof num !== 'number' || num !== num || !isFinite(num)) {
            throw new TypeError('coordinates must be finite numbers');
        }
    }
},
/* models/annotations/arrow_head.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a, _b, _c, _d, _e;
    const model_1 = require(53) /* ../../model */;
    const view_1 = require(42) /* ../../core/view */;
    const visuals = (0, tslib_1.__importStar)(require(45) /* ../../core/visuals */);
    const property_mixins_1 = require(48) /* ../../core/property_mixins */;
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    class ArrowHeadView extends view_1.View {
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this);
        }
        request_render() {
            this.parent.request_render();
        }
        get canvas() {
            return this.parent.canvas;
        }
        set_data(source) {
            const self = this;
            for (const prop of this.model) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                    continue;
                const uniform = prop.uniform(source);
                self[`${prop.attr}`] = uniform;
            }
        }
    }
    exports.ArrowHeadView = ArrowHeadView;
    ArrowHeadView.__name__ = "ArrowHeadView";
    class ArrowHead extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ArrowHead = ArrowHead;
    _a = ArrowHead;
    ArrowHead.__name__ = "ArrowHead";
    (() => {
        _a.define(() => ({
            size: [p.NumberSpec, 25],
        }));
    })();
    class OpenHeadView extends ArrowHeadView {
        clip(ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            const size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(0.5 * size_i, size_i);
        }
        render(ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                const size_i = this.size.get(i);
                ctx.beginPath();
                ctx.moveTo(0.5 * size_i, size_i);
                ctx.lineTo(0, 0);
                ctx.lineTo(-0.5 * size_i, size_i);
                ctx.stroke();
            }
        }
    }
    exports.OpenHeadView = OpenHeadView;
    OpenHeadView.__name__ = "OpenHeadView";
    class OpenHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.OpenHead = OpenHead;
    _b = OpenHead;
    OpenHead.__name__ = "OpenHead";
    (() => {
        _b.prototype.default_view = OpenHeadView;
        _b.mixins(property_mixins_1.LineVector);
    })();
    class NormalHeadView extends ArrowHeadView {
        clip(ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            const size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        }
        render(ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.stroke();
            }
        }
        _normal(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.closePath();
        }
    }
    exports.NormalHeadView = NormalHeadView;
    NormalHeadView.__name__ = "NormalHeadView";
    class NormalHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.NormalHead = NormalHead;
    _c = NormalHead;
    NormalHead.__name__ = "NormalHead";
    (() => {
        _c.prototype.default_view = NormalHeadView;
        _c.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
        _c.override({
            fill_color: "black",
        });
    })();
    class VeeHeadView extends ArrowHeadView {
        clip(ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            const size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        }
        render(ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.stroke();
            }
        }
        _vee(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.closePath();
        }
    }
    exports.VeeHeadView = VeeHeadView;
    VeeHeadView.__name__ = "VeeHeadView";
    class VeeHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.VeeHead = VeeHead;
    _d = VeeHead;
    VeeHead.__name__ = "VeeHead";
    (() => {
        _d.prototype.default_view = VeeHeadView;
        _d.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
        _d.override({
            fill_color: "black",
        });
    })();
    class TeeHeadView extends ArrowHeadView {
        render(ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                const size_i = this.size.get(i);
                ctx.beginPath();
                ctx.moveTo(0.5 * size_i, 0);
                ctx.lineTo(-0.5 * size_i, 0);
                ctx.stroke();
            }
        }
        clip(_ctx, _i) { }
    }
    exports.TeeHeadView = TeeHeadView;
    TeeHeadView.__name__ = "TeeHeadView";
    class TeeHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TeeHead = TeeHead;
    _e = TeeHead;
    TeeHead.__name__ = "TeeHead";
    (() => {
        _e.prototype.default_view = TeeHeadView;
        _e.mixins(property_mixins_1.LineVector);
    })();
},
/* core/build_views.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const array_1 = require(9) /* ./util/array */;
    async function _build_view(view_cls, model, options) {
        const view = new view_cls(Object.assign(Object.assign({}, options), { model }));
        view.initialize();
        await view.lazy_initialize();
        return view;
    }
    async function build_view(model, options = { parent: null }, cls = (model) => model.default_view) {
        const view = await _build_view(cls(model), model, options);
        view.connect_signals();
        return view;
    }
    exports.build_view = build_view;
    async function build_views(view_storage, models, options = { parent: null }, cls = (model) => model.default_view) {
        const to_remove = (0, array_1.difference)([...view_storage.keys()], models);
        for (const model of to_remove) {
            view_storage.get(model).remove();
            view_storage.delete(model);
        }
        const created_views = [];
        const new_models = models.filter((model) => !view_storage.has(model));
        for (const model of new_models) {
            const view = await _build_view(cls(model), model, options);
            view_storage.set(model, view);
            created_views.push(view);
        }
        for (const view of created_views)
            view.connect_signals();
        return created_views;
    }
    exports.build_views = build_views;
    function remove_views(view_storage) {
        for (const [model, view] of view_storage) {
            view.remove();
            view_storage.delete(model);
        }
    }
    exports.remove_views = remove_views;
},
/* models/annotations/band.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const upper_lower_1 = require(115) /* ./upper_lower */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    class BandView extends upper_lower_1.UpperLowerView {
        paint(ctx) {
            // Draw the band body
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (let i = this._upper_sx.length - 1; i >= 0; i--) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            // Draw the lower band edge
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            this.visuals.line.apply(ctx);
            // Draw the upper band edge
            ctx.beginPath();
            ctx.moveTo(this._upper_sx[0], this._upper_sy[0]);
            for (let i = 0, end = this._upper_sx.length; i < end; i++) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            this.visuals.line.apply(ctx);
        }
    }
    exports.BandView = BandView;
    BandView.__name__ = "BandView";
    class Band extends upper_lower_1.UpperLower {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Band = Band;
    _a = Band;
    Band.__name__ = "Band";
    (() => {
        _a.prototype.default_view = BandView;
        _a.mixins([mixins.Line, mixins.Fill]);
        _a.override({
            fill_color: "#fff9ba",
            fill_alpha: 0.4,
            line_color: "#cccccc",
            line_alpha: 0.3,
        });
    })();
},
/* models/annotations/upper_lower.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const data_annotation_1 = require(69) /* ./data_annotation */;
    const enums_1 = require(20) /* ../../core/enums */;
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    class UpperLowerView extends data_annotation_1.DataAnnotationView {
        map_data() {
            const { frame } = this.plot_view;
            const dim = this.model.dimension;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const limit_scale = dim == "height" ? yscale : xscale;
            const base_scale = dim == "height" ? xscale : yscale;
            const limit_view = dim == "height" ? frame.bbox.yview : frame.bbox.xview;
            const base_view = dim == "height" ? frame.bbox.xview : frame.bbox.yview;
            let _lower_sx;
            if (this.model.properties.lower.units == "data")
                _lower_sx = limit_scale.v_compute(this._lower);
            else
                _lower_sx = limit_view.v_compute(this._lower);
            let _upper_sx;
            if (this.model.properties.upper.units == "data")
                _upper_sx = limit_scale.v_compute(this._upper);
            else
                _upper_sx = limit_view.v_compute(this._upper);
            let _base_sx;
            if (this.model.properties.base.units == "data")
                _base_sx = base_scale.v_compute(this._base);
            else
                _base_sx = base_view.v_compute(this._base);
            const [i, j] = dim == "height" ? [1, 0] : [0, 1];
            const _lower = [_lower_sx, _base_sx];
            const _upper = [_upper_sx, _base_sx];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            this._upper_sy = _upper[j];
        }
    }
    exports.UpperLowerView = UpperLowerView;
    UpperLowerView.__name__ = "UpperLowerView";
    class XOrYCoordinateSpec extends p.CoordinateSpec {
        get dimension() {
            return this.obj.dimension == "width" ? "x" : "y";
        }
        // XXX: a hack to make a coordinate & unit spec
        get units() {
            var _b;
            return (_b = this.spec.units) !== null && _b !== void 0 ? _b : "data";
        }
    }
    exports.XOrYCoordinateSpec = XOrYCoordinateSpec;
    XOrYCoordinateSpec.__name__ = "XOrYCoordinateSpec";
    class UpperLower extends data_annotation_1.DataAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.UpperLower = UpperLower;
    _a = UpperLower;
    UpperLower.__name__ = "UpperLower";
    (() => {
        _a.define(() => ({
            dimension: [enums_1.Dimension, "height"],
            lower: [XOrYCoordinateSpec, { field: "lower" }],
            upper: [XOrYCoordinateSpec, { field: "upper" }],
            base: [XOrYCoordinateSpec, { field: "base" }],
        }));
    })();
},
/* models/annotations/box_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(40) /* ./annotation */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    const bbox_1 = require(65) /* ../../core/util/bbox */;
    exports.EDGE_TOLERANCE = 2.5;
    class BoxAnnotationView extends annotation_1.AnnotationView {
        constructor() {
            super(...arguments);
            this.bbox = new bbox_1.BBox();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.request_render());
        }
        _render() {
            const { left, right, top, bottom } = this.model;
            // don't render if *all* position are null
            if (left == null && right == null && top == null && bottom == null)
                return;
            const { frame } = this.plot_view;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const _calc_dim = (dim, dim_units, scale, view, frame_extrema) => {
                let sdim;
                if (dim != null) {
                    if (this.model.screen)
                        sdim = dim;
                    else {
                        if (dim_units == "data")
                            sdim = scale.compute(dim);
                        else
                            sdim = view.compute(dim);
                    }
                }
                else
                    sdim = frame_extrema;
                return sdim;
            };
            this.bbox = bbox_1.BBox.from_rect({
                left: _calc_dim(left, this.model.left_units, xscale, frame.bbox.xview, frame.bbox.left),
                right: _calc_dim(right, this.model.right_units, xscale, frame.bbox.xview, frame.bbox.right),
                top: _calc_dim(top, this.model.top_units, yscale, frame.bbox.yview, frame.bbox.top),
                bottom: _calc_dim(bottom, this.model.bottom_units, yscale, frame.bbox.yview, frame.bbox.bottom),
            });
            this._paint_box();
        }
        _paint_box() {
            const { ctx } = this.layer;
            ctx.save();
            const { left, top, width, height } = this.bbox;
            ctx.beginPath();
            ctx.rect(left, top, width, height);
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
            this.visuals.line.apply(ctx);
            ctx.restore();
        }
        interactive_bbox() {
            const tolerance = this.model.line_width + exports.EDGE_TOLERANCE;
            return this.bbox.grow_by(tolerance);
        }
        interactive_hit(sx, sy) {
            if (this.model.in_cursor == null)
                return false;
            const bbox = this.interactive_bbox();
            return bbox.contains(sx, sy);
        }
        cursor(sx, sy) {
            const tol = 3;
            const { left, right, bottom, top } = this.bbox;
            if (Math.abs(sx - left) < tol || Math.abs(sx - right) < tol)
                return this.model.ew_cursor;
            else if (Math.abs(sy - bottom) < tol || Math.abs(sy - top) < tol)
                return this.model.ns_cursor;
            else if (this.bbox.contains(sx, sy))
                return this.model.in_cursor;
            else
                return null;
        }
    }
    exports.BoxAnnotationView = BoxAnnotationView;
    BoxAnnotationView.__name__ = "BoxAnnotationView";
    class BoxAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        update({ left, right, top, bottom }) {
            this.setv({ left, right, top, bottom, screen: true });
        }
    }
    exports.BoxAnnotation = BoxAnnotation;
    _a = BoxAnnotation;
    BoxAnnotation.__name__ = "BoxAnnotation";
    (() => {
        _a.prototype.default_view = BoxAnnotationView;
        _a.mixins([mixins.Line, mixins.Fill, mixins.Hatch]);
        _a.define(({ Number, Nullable }) => ({
            top: [Nullable(Number), null],
            top_units: [enums_1.SpatialUnits, "data"],
            bottom: [Nullable(Number), null],
            bottom_units: [enums_1.SpatialUnits, "data"],
            left: [Nullable(Number), null],
            left_units: [enums_1.SpatialUnits, "data"],
            right: [Nullable(Number), null],
            right_units: [enums_1.SpatialUnits, "data"],
            /** @deprecated */
            render_mode: [enums_1.RenderMode, "canvas"],
        }));
        _a.internal(({ Boolean, String, Nullable }) => ({
            screen: [Boolean, false],
            ew_cursor: [Nullable(String), null],
            ns_cursor: [Nullable(String), null],
            in_cursor: [Nullable(String), null],
        }));
        _a.override({
            fill_color: "#fff9ba",
            fill_alpha: 0.4,
            line_color: "#cccccc",
            line_alpha: 0.3,
        });
    })();
},
/* models/annotations/color_bar.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(40) /* ./annotation */;
    const title_1 = require(118) /* ./title */;
    const cartesian_frame_1 = require(126) /* ../canvas/cartesian_frame */;
    const axes_1 = require(127) /* ../axes */;
    const ticker_1 = require(130) /* ../tickers/ticker */;
    const tickers_1 = require(168) /* ../tickers */;
    const tick_formatter_1 = require(131) /* ../formatters/tick_formatter */;
    const formatters_1 = require(192) /* ../formatters */;
    const labeling_1 = require(132) /* ../policies/labeling */;
    const color_mapper_1 = require(173) /* ../mappers/color_mapper */;
    const continuous_color_mapper_1 = require(172) /* ../mappers/continuous_color_mapper */;
    const mappers_1 = require(196) /* ../mappers */;
    const scales_1 = require(204) /* ../scales */;
    const ranges_1 = require(206) /* ../ranges */;
    const base_text_1 = require(133) /* ../text/base_text */;
    const enums_1 = require(20) /* ../../core/enums */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const array_1 = require(9) /* ../../core/util/array */;
    const layout_1 = require(207) /* ../../core/layout */;
    const alignments_1 = require(208) /* ../../core/layout/alignments */;
    const border_1 = require(211) /* ../../core/layout/border */;
    const side_panel_1 = require(123) /* ../../core/layout/side_panel */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    const build_views_1 = require(113) /* ../../core/build_views */;
    const bbox_1 = require(65) /* ../../core/util/bbox */;
    const types_1 = require(8) /* ../../core/util/types */;
    const MINOR_DIM = 25;
    const MAJOR_DIM_MIN_SCALAR = 0.3;
    const MAJOR_DIM_MAX_SCALAR = 0.8;
    class ColorBarView extends annotation_1.AnnotationView {
        get orientation() {
            return this._orientation;
        }
        initialize() {
            super.initialize();
            const { ticker, formatter, color_mapper } = this.model;
            this._ticker = ticker != "auto" ? ticker : (() => {
                switch (true) {
                    case color_mapper instanceof mappers_1.LogColorMapper:
                        return new tickers_1.LogTicker();
                    case color_mapper instanceof mappers_1.ScanningColorMapper:
                        return new tickers_1.BinnedTicker({ mapper: color_mapper });
                    case color_mapper instanceof mappers_1.CategoricalColorMapper:
                        return new tickers_1.CategoricalTicker();
                    default:
                        return new tickers_1.BasicTicker();
                }
            })();
            this._formatter = formatter != "auto" ? formatter : (() => {
                switch (true) {
                    case this._ticker instanceof tickers_1.LogTicker:
                        return new formatters_1.LogTickFormatter();
                    case color_mapper instanceof mappers_1.CategoricalColorMapper:
                        return new formatters_1.CategoricalTickFormatter();
                    default:
                        return new formatters_1.BasicTickFormatter();
                }
            })();
            /*
            Creates and returns a scale instance that maps the `color_mapper` range
            (low to high) to a screen space range equal to the length of the ColorBar's
            scale image. The scale is used to calculate the tick coordinates in screen
            coordinates for plotting purposes.
        
            Note: the type of color_mapper has to match the type of scale (i.e.
            a LinearColorMapper will require a corresponding LinearScale instance).
            */
            this._major_range = (() => {
                if (color_mapper instanceof mappers_1.CategoricalColorMapper) {
                    const { factors } = color_mapper;
                    return new ranges_1.FactorRange({ factors });
                }
                else if (color_mapper instanceof continuous_color_mapper_1.ContinuousColorMapper) {
                    const { min, max } = color_mapper.metrics;
                    return new ranges_1.Range1d({ start: min, end: max });
                }
                else
                    (0, assert_1.unreachable)();
            })();
            this._major_scale = (() => {
                if (color_mapper instanceof mappers_1.LinearColorMapper)
                    return new scales_1.LinearScale();
                else if (color_mapper instanceof mappers_1.LogColorMapper)
                    return new scales_1.LogScale();
                else if (color_mapper instanceof mappers_1.ScanningColorMapper) {
                    const { binning } = color_mapper.metrics;
                    return new scales_1.LinearInterpolationScale({ binning });
                }
                else if (color_mapper instanceof mappers_1.CategoricalColorMapper) {
                    return new scales_1.CategoricalScale();
                }
                else
                    (0, assert_1.unreachable)();
            })();
            this._minor_range = new ranges_1.Range1d({ start: 0, end: 1 });
            this._minor_scale = new scales_1.LinearScale();
            const major_label_text = mixins.attrs_of(this.model, "major_label_", mixins.Text, true);
            const major_tick_line = mixins.attrs_of(this.model, "major_tick_", mixins.Line, true);
            const minor_tick_line = mixins.attrs_of(this.model, "minor_tick_", mixins.Line, true);
            const title_text = mixins.attrs_of(this.model, "title_", mixins.Text);
            const AxisCls = (() => {
                if (color_mapper instanceof mappers_1.CategoricalColorMapper)
                    return axes_1.CategoricalAxis;
                else if (color_mapper instanceof mappers_1.LogColorMapper)
                    return axes_1.LogAxis;
                else
                    return axes_1.LinearAxis;
            })();
            this._axis = new AxisCls(Object.assign(Object.assign(Object.assign({ ticker: this._ticker, formatter: this._formatter, major_tick_in: this.model.major_tick_in, major_tick_out: this.model.major_tick_out, minor_tick_in: this.model.minor_tick_in, minor_tick_out: this.model.minor_tick_out, major_label_standoff: this.model.label_standoff, major_label_overrides: this.model.major_label_overrides, major_label_policy: this.model.major_label_policy, axis_line_color: null }, major_label_text), major_tick_line), minor_tick_line));
            const { title } = this.model;
            if (title) {
                this._title = new title_1.Title(Object.assign({ text: title, standoff: this.model.title_standoff }, title_text));
            }
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const self = this;
            const parent = {
                get parent() {
                    return self.parent;
                },
                get root() {
                    return self.root;
                },
                get frame() {
                    return self._frame;
                },
                get canvas_view() {
                    return self.parent.canvas_view;
                },
                request_layout() {
                    self.parent.request_layout();
                },
            };
            this._axis_view = await (0, build_views_1.build_view)(this._axis, { parent });
            if (this._title != null)
                this._title_view = await (0, build_views_1.build_view)(this._title, { parent });
        }
        remove() {
            var _b;
            (_b = this._title_view) === null || _b === void 0 ? void 0 : _b.remove();
            this._axis_view.remove();
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            // TODO: this.connect(this.model.change, () => this.plot_view.invalidate_layout())
            this.connect(this._ticker.change, () => this.request_render());
            this.connect(this._formatter.change, () => this.request_render());
            this.connect(this.model.color_mapper.metrics_change, () => {
                const range = this._major_range;
                const scale = this._major_scale;
                const { color_mapper } = this.model;
                if (color_mapper instanceof continuous_color_mapper_1.ContinuousColorMapper && range instanceof ranges_1.Range1d) {
                    const { min, max } = color_mapper.metrics;
                    range.setv({ start: min, end: max });
                }
                if (color_mapper instanceof mappers_1.ScanningColorMapper && scale instanceof scales_1.LinearInterpolationScale) {
                    const { binning } = color_mapper.metrics;
                    scale.binning = binning;
                }
                this._set_canvas_image();
                this.plot_view.request_layout(); // this.request_render()
            });
        }
        _set_canvas_image() {
            const { orientation } = this;
            const palette = (() => {
                const { palette } = this.model.color_mapper;
                if (orientation == "vertical")
                    return (0, array_1.reversed)(palette);
                else
                    return palette;
            })();
            const [w, h] = (() => {
                if (orientation == "vertical")
                    return [1, palette.length];
                else
                    return [palette.length, 1];
            })();
            const canvas = this._image = document.createElement("canvas");
            canvas.width = w;
            canvas.height = h;
            const image_ctx = canvas.getContext("2d");
            const image_data = image_ctx.getImageData(0, 0, w, h);
            // We always want to draw the entire palette linearly, so we create a new
            // LinearColorMapper instance and map a monotonic range of values with
            // length = palette.length to get each palette color in order.
            const cmap = new mappers_1.LinearColorMapper({ palette }).rgba_mapper;
            const buf8 = cmap.v_compute((0, array_1.range)(0, palette.length));
            image_data.data.set(buf8);
            image_ctx.putImageData(image_data, 0, 0);
        }
        update_layout() {
            const { location, width: w, height: h, padding, margin } = this.model;
            const [valign, halign] = (() => {
                if ((0, types_1.isString)(location)) {
                    switch (location) {
                        case "top_left":
                            return ["start", "start"];
                        case "top":
                        case "top_center":
                            return ["start", "center"];
                        case "top_right":
                            return ["start", "end"];
                        case "bottom_left":
                            return ["end", "start"];
                        case "bottom":
                        case "bottom_center":
                            return ["end", "center"];
                        case "bottom_right":
                            return ["end", "end"];
                        case "left":
                        case "center_left":
                            return ["center", "start"];
                        case "center":
                        case "center_center":
                            return ["center", "center"];
                        case "right":
                        case "center_right":
                            return ["center", "end"];
                    }
                }
                else
                    return ["end", "start"]; // "bottom_left"
            })();
            const orientation = this._orientation = (() => {
                const { orientation } = this.model;
                if (orientation == "auto") {
                    if (this.panel != null)
                        return this.panel.is_horizontal ? "horizontal" : "vertical";
                    else {
                        if (halign == "start" || halign == "end" || (halign == "center" && valign == "center"))
                            return "vertical";
                        else
                            return "horizontal";
                    }
                }
                else
                    return orientation;
            })();
            const center_panel = new alignments_1.NodeLayout();
            const top_panel = new alignments_1.VStack();
            const bottom_panel = new alignments_1.VStack();
            const left_panel = new alignments_1.HStack();
            const right_panel = new alignments_1.HStack();
            center_panel.absolute = true;
            top_panel.absolute = true;
            bottom_panel.absolute = true;
            left_panel.absolute = true;
            right_panel.absolute = true;
            const [x_scale, y_scale, x_range, y_range] = (() => {
                if (orientation == "horizontal")
                    return [this._major_scale, this._minor_scale, this._major_range, this._minor_range];
                else
                    return [this._minor_scale, this._major_scale, this._minor_range, this._major_range];
            })();
            this._frame = new cartesian_frame_1.CartesianFrame(x_scale, y_scale, x_range, y_range);
            center_panel.on_resize((bbox) => this._frame.set_geometry(bbox));
            const layout = new border_1.BorderLayout();
            this._inner_layout = layout;
            layout.absolute = true;
            layout.center_panel = center_panel;
            layout.top_panel = top_panel;
            layout.bottom_panel = bottom_panel;
            layout.left_panel = left_panel;
            layout.right_panel = right_panel;
            const padding_box = { left: padding, right: padding, top: padding, bottom: padding };
            const margin_box = (() => {
                if (this.panel == null) {
                    if ((0, types_1.isString)(location))
                        return { left: margin, right: margin, top: margin, bottom: margin };
                    else {
                        const [left, bottom] = location;
                        return { left, right: margin, top: margin, bottom };
                    }
                }
                else {
                    /**
                     * XXX: alignment is broken in Grid, which is used to govern positioning of a ColorBar
                     * in side panels. Earlier attempts at fixing this failed and resulted in a multitude
                     * or regressions in various places in the layout. So instead of this, let's assume that
                     * the positioning is always at "start" regardless of configuration, and fix this here
                     * by manually computing "center" and "end" alignment.
                     */
                    if ((0, types_1.isString)(location)) {
                        layout.fixup_geometry = (outer, inner) => {
                            const origin = outer;
                            if (orientation == "horizontal") {
                                const { top, width, height } = outer;
                                if (halign == "end") {
                                    const { right } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ right, top, width, height });
                                }
                                else if (halign == "center") {
                                    const { hcenter } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ hcenter: Math.round(hcenter), top, width, height });
                                }
                            }
                            else {
                                const { left, width, height } = outer;
                                if (valign == "end") {
                                    const { bottom } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ left, bottom, width, height });
                                }
                                else if (valign == "center") {
                                    const { vcenter } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ left, vcenter: Math.round(vcenter), width, height });
                                }
                            }
                            if (inner != null) {
                                const dh = outer.left - origin.left;
                                const dv = outer.top - origin.top;
                                const { left, top, width, height } = inner;
                                inner = new bbox_1.BBox({ left: left + dh, top: top + dv, width, height });
                            }
                            return [outer, inner];
                        };
                        return undefined;
                    }
                    else {
                        const [left, bottom] = location;
                        layout.fixup_geometry = (outer, inner) => {
                            const origin = outer;
                            const grid = this.layout.bbox;
                            const { width, height } = outer;
                            outer = new bbox_1.BBox({ left: grid.left + left, bottom: grid.bottom - bottom, width, height });
                            if (inner != null) {
                                const dh = outer.left - origin.left;
                                const dv = outer.top - origin.top;
                                const { left, top, width, height } = inner;
                                inner = new bbox_1.BBox({ left: left + dh, top: top + dv, width, height });
                            }
                            return [outer, inner];
                        };
                        return { left, right: 0, top: 0, bottom };
                    }
                }
            })();
            layout.padding = padding_box;
            let major_policy;
            let major_size;
            let min_major_size;
            let max_major_size;
            if (this.panel != null) {
                major_policy = "max";
                major_size = undefined;
                min_major_size = undefined;
                max_major_size = undefined;
            }
            else {
                if ((orientation == "horizontal" ? w : h) == "auto") {
                    major_policy = "fixed";
                    major_size = this.model.color_mapper.palette.length * MINOR_DIM;
                    min_major_size = { percent: MAJOR_DIM_MIN_SCALAR };
                    max_major_size = { percent: MAJOR_DIM_MAX_SCALAR };
                }
                else {
                    major_policy = "fit";
                    major_size = undefined;
                }
            }
            if (orientation == "horizontal") {
                const width = w == "auto" ? undefined : w;
                const height = h == "auto" ? MINOR_DIM : h;
                layout.set_sizing({
                    width_policy: major_policy, height_policy: "min",
                    width: major_size, min_width: min_major_size, max_width: max_major_size,
                    halign, valign, margin: margin_box,
                });
                layout.center_panel.set_sizing({ width_policy: w == "auto" ? "fit" : "fixed", height_policy: "fixed", width, height });
            }
            else {
                const width = w == "auto" ? MINOR_DIM : w;
                const height = h == "auto" ? undefined : h;
                layout.set_sizing({
                    width_policy: "min", height_policy: major_policy,
                    height: major_size, min_height: min_major_size, max_height: max_major_size,
                    halign, valign, margin: margin_box,
                });
                layout.center_panel.set_sizing({ width_policy: "fixed", height_policy: h == "auto" ? "fit" : "fixed", width, height });
            }
            top_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
            bottom_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
            left_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
            right_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
            const { _title_view } = this;
            if (_title_view != null) {
                if (orientation == "horizontal") {
                    _title_view.panel = new side_panel_1.Panel("above");
                    _title_view.update_layout();
                    top_panel.children.push(_title_view.layout);
                }
                else {
                    _title_view.panel = new side_panel_1.Panel("left");
                    _title_view.update_layout();
                    left_panel.children.push(_title_view.layout);
                }
            }
            const { panel } = this;
            const side = (() => {
                if (panel != null && orientation == panel.orientation)
                    return panel.side;
                else
                    return orientation == "horizontal" ? "below" : "right";
            })();
            const stack = (() => {
                switch (side) {
                    case "above":
                        return top_panel;
                    case "below":
                        return bottom_panel;
                    case "left":
                        return left_panel;
                    case "right":
                        return right_panel;
                }
            })();
            const { _axis_view } = this;
            _axis_view.panel = new side_panel_1.Panel(side);
            _axis_view.update_layout();
            stack.children.push(_axis_view.layout);
            if (this.panel != null) {
                const outer = new layout_1.Grid([{ layout, row: 0, col: 0 }]);
                outer.absolute = true;
                if (orientation == "horizontal") {
                    outer.set_sizing({ width_policy: "max", height_policy: "min" });
                }
                else {
                    outer.set_sizing({ width_policy: "min", height_policy: "max" });
                }
                this.layout = outer;
            }
            else {
                this.layout = this._inner_layout;
            }
            const { visible } = this.model;
            this.layout.sizing.visible = visible;
            this._set_canvas_image();
        }
        _render() {
            var _b;
            const { ctx } = this.layer;
            ctx.save();
            this._paint_bbox(ctx, this._inner_layout.bbox);
            this._paint_image(ctx, this._inner_layout.center_panel.bbox);
            (_b = this._title_view) === null || _b === void 0 ? void 0 : _b.render();
            this._axis_view.render();
            ctx.restore();
        }
        _paint_bbox(ctx, bbox) {
            const { x, y } = bbox;
            let { width, height } = bbox;
            // XXX: shrink outline region by 1px to make right and bottom lines visible
            // if they are on the edge of the canvas.
            if (x + width >= this.parent.canvas_view.bbox.width) {
                width -= 1;
            }
            if (y + height >= this.parent.canvas_view.bbox.height) {
                height -= 1;
            }
            ctx.save();
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fillRect(x, y, width, height);
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.strokeRect(x, y, width, height);
            }
            ctx.restore();
        }
        _paint_image(ctx, bbox) {
            const { x, y, width, height } = bbox;
            ctx.save();
            ctx.setImageSmoothingEnabled(false);
            ctx.globalAlpha = this.model.scale_alpha;
            ctx.drawImage(this._image, x, y, width, height);
            if (this.visuals.bar_line.doit) {
                this.visuals.bar_line.set_value(ctx);
                ctx.strokeRect(x, y, width, height);
            }
            ctx.restore();
        }
        serializable_state() {
            const _b = super.serializable_state(), { children = [] } = _b, state = (0, tslib_1.__rest)(_b, ["children"]);
            if (this._title_view != null)
                children.push(this._title_view.serializable_state());
            children.push(this._axis_view.serializable_state());
            return Object.assign(Object.assign({}, state), { children });
        }
    }
    exports.ColorBarView = ColorBarView;
    ColorBarView.__name__ = "ColorBarView";
    class ColorBar extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ColorBar = ColorBar;
    _a = ColorBar;
    ColorBar.__name__ = "ColorBar";
    (() => {
        _a.prototype.default_view = ColorBarView;
        _a.mixins([
            ["major_label_", mixins.Text],
            ["title_", mixins.Text],
            ["major_tick_", mixins.Line],
            ["minor_tick_", mixins.Line],
            ["border_", mixins.Line],
            ["bar_", mixins.Line],
            ["background_", mixins.Fill],
        ]);
        _a.define(({ Alpha, Number, String, Tuple, Dict, Or, Ref, Auto, Nullable }) => ({
            location: [Or(enums_1.Anchor, Tuple(Number, Number)), "top_right"],
            orientation: [Or(enums_1.Orientation, Auto), "auto"],
            title: [Nullable(String), null],
            title_standoff: [Number, 2],
            width: [Or(Number, Auto), "auto"],
            height: [Or(Number, Auto), "auto"],
            scale_alpha: [Alpha, 1.0],
            ticker: [Or(Ref(ticker_1.Ticker), Auto), "auto"],
            formatter: [Or(Ref(tick_formatter_1.TickFormatter), Auto), "auto"],
            major_label_overrides: [Dict(Or(String, Ref(base_text_1.BaseText))), {}],
            major_label_policy: [Ref(labeling_1.LabelingPolicy), () => new labeling_1.NoOverlap()],
            color_mapper: [Ref(color_mapper_1.ColorMapper)],
            label_standoff: [Number, 5],
            margin: [Number, 30],
            padding: [Number, 10],
            major_tick_in: [Number, 5],
            major_tick_out: [Number, 0],
            minor_tick_in: [Number, 0],
            minor_tick_out: [Number, 0],
        }));
        _a.override({
            background_fill_color: "#ffffff",
            background_fill_alpha: 0.95,
            bar_line_color: null,
            border_line_color: null,
            major_label_text_font_size: "11px",
            major_tick_line_color: "#ffffff",
            minor_tick_line_color: null,
            title_text_font_size: "13px",
            title_text_font_style: "italic",
        });
    })();
},
/* models/annotations/title.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const text_annotation_1 = require(119) /* ./text_annotation */;
    const enums_1 = require(20) /* ../../core/enums */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    class TitleView extends text_annotation_1.TextAnnotationView {
        _get_location() {
            const hmargin = this.model.offset;
            const vmargin = this.model.standoff / 2;
            let sx, sy;
            const { bbox } = this.layout;
            switch (this.panel.side) {
                case "above":
                case "below": {
                    switch (this.model.vertical_align) {
                        case "top":
                            sy = bbox.top + vmargin;
                            break;
                        case "middle":
                            sy = bbox.vcenter;
                            break;
                        case "bottom":
                            sy = bbox.bottom - vmargin;
                            break;
                    }
                    switch (this.model.align) {
                        case "left":
                            sx = bbox.left + hmargin;
                            break;
                        case "center":
                            sx = bbox.hcenter;
                            break;
                        case "right":
                            sx = bbox.right - hmargin;
                            break;
                    }
                    break;
                }
                case "left": {
                    switch (this.model.vertical_align) {
                        case "top":
                            sx = bbox.left + vmargin;
                            break;
                        case "middle":
                            sx = bbox.hcenter;
                            break;
                        case "bottom":
                            sx = bbox.right - vmargin;
                            break;
                    }
                    switch (this.model.align) {
                        case "left":
                            sy = bbox.bottom - hmargin;
                            break;
                        case "center":
                            sy = bbox.vcenter;
                            break;
                        case "right":
                            sy = bbox.top + hmargin;
                            break;
                    }
                    break;
                }
                case "right": {
                    switch (this.model.vertical_align) {
                        case "top":
                            sx = bbox.right - vmargin;
                            break;
                        case "middle":
                            sx = bbox.hcenter;
                            break;
                        case "bottom":
                            sx = bbox.left + vmargin;
                            break;
                    }
                    switch (this.model.align) {
                        case "left":
                            sy = bbox.top + hmargin;
                            break;
                        case "center":
                            sy = bbox.vcenter;
                            break;
                        case "right":
                            sy = bbox.bottom - hmargin;
                            break;
                    }
                    break;
                }
            }
            return [sx, sy];
        }
        _render() {
            const { text } = this.model;
            if (text == null || text.length == 0)
                return;
            this.model.text_baseline = this.model.vertical_align;
            this.model.text_align = this.model.align;
            const [sx, sy] = this._get_location();
            const angle = this.panel.get_label_angle_heuristic("parallel");
            const draw = this.model.render_mode == "canvas" ? this._canvas_text.bind(this) : this._css_text.bind(this);
            draw(this.layer.ctx, text, sx, sy, angle);
        }
        _get_size() {
            const { text } = this.model;
            const graphics = new graphics_1.TextBox({ text });
            graphics.visuals = this.visuals.text.values();
            const { width, height } = graphics.size();
            // XXX: The magic 2px is for backwards compatibility. This will be removed at
            // some point, but currently there is no point breaking half of visual tests.
            return { width, height: height == 0 ? 0 : 2 + height + this.model.standoff };
        }
    }
    exports.TitleView = TitleView;
    TitleView.__name__ = "TitleView";
    class Title extends text_annotation_1.TextAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Title = Title;
    _a = Title;
    Title.__name__ = "Title";
    (() => {
        _a.prototype.default_view = TitleView;
        _a.mixins([
            mixins.Text,
            ["border_", mixins.Line],
            ["background_", mixins.Fill],
        ]);
        _a.define(({ Number, String }) => ({
            text: [String, ""],
            vertical_align: [enums_1.VerticalAlign, "bottom"],
            align: [enums_1.TextAlign, "left"],
            offset: [Number, 0],
            standoff: [Number, 10],
        }));
        _a.prototype._props.text_align.options.internal = true;
        _a.prototype._props.text_baseline.options.internal = true;
        _a.override({
            text_font_size: "13px",
            text_font_style: "bold",
            text_line_height: 1.0,
            background_fill_color: null,
            border_line_color: null,
        });
    })();
},
/* models/annotations/text_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const annotation_1 = require(40) /* ./annotation */;
    const dom_1 = require(43) /* ../../core/dom */;
    const enums_1 = require(20) /* ../../core/enums */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    const side_panel_1 = require(123) /* ../../core/layout/side_panel */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    class TextAnnotationView extends annotation_1.AnnotationView {
        update_layout() {
            const { panel } = this;
            if (panel != null)
                this.layout = new side_panel_1.SideLayout(panel, () => this.get_size(), true);
            else
                this.layout = undefined;
        }
        initialize() {
            super.initialize();
            if (this.model.render_mode == "css") {
                this.el = (0, dom_1.div)();
                this.plot_view.canvas_view.add_overlay(this.el);
            }
        }
        remove() {
            if (this.el != null)
                (0, dom_1.remove)(this.el);
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            if (this.model.render_mode == "css") {
                // dispatch CSS update immediately
                this.connect(this.model.change, () => this.render());
            }
            else {
                this.connect(this.model.change, () => this.request_render());
            }
        }
        render() {
            if (!this.model.visible && this.model.render_mode == "css")
                (0, dom_1.undisplay)(this.el);
            super.render();
        }
        _canvas_text(ctx, text, sx, sy, angle) {
            const graphics = new graphics_1.TextBox({ text });
            graphics.angle = angle;
            graphics.position = { sx, sy };
            graphics.visuals = this.visuals.text.values();
            const { background_fill, border_line } = this.visuals;
            if (background_fill.doit || border_line.doit) {
                const { p0, p1, p2, p3 } = graphics.rect();
                ctx.beginPath();
                ctx.moveTo(p0.x, p0.y);
                ctx.lineTo(p1.x, p1.y);
                ctx.lineTo(p2.x, p2.y);
                ctx.lineTo(p3.x, p3.y);
                ctx.closePath();
                this.visuals.background_fill.apply(ctx);
                this.visuals.border_line.apply(ctx);
            }
            if (this.visuals.text.doit)
                graphics.paint(ctx);
        }
        _css_text(ctx, text, sx, sy, angle) {
            const { el } = this;
            (0, assert_1.assert)(el != null);
            (0, dom_1.undisplay)(el);
            el.textContent = text;
            this.visuals.text.set_value(ctx);
            el.style.position = "absolute";
            el.style.left = `${sx}px`;
            el.style.top = `${sy}px`;
            el.style.color = ctx.fillStyle;
            el.style.font = ctx.font;
            el.style.lineHeight = "normal"; // needed to prevent ipynb css override
            el.style.whiteSpace = "pre";
            const [x_anchor, x_t] = (() => {
                switch (this.visuals.text.text_align.get_value()) {
                    case "left": return ["left", "0%"];
                    case "center": return ["center", "-50%"];
                    case "right": return ["right", "-100%"];
                }
            })();
            const [y_anchor, y_t] = (() => {
                switch (this.visuals.text.text_baseline.get_value()) {
                    case "top": return ["top", "0%"];
                    case "middle": return ["center", "-50%"];
                    case "bottom": return ["bottom", "-100%"];
                    default: return ["center", "-50%"]; // "baseline"
                }
            })();
            let transform = `translate(${x_t}, ${y_t})`;
            if (angle) {
                transform += `rotate(${angle}rad)`;
            }
            el.style.transformOrigin = `${x_anchor} ${y_anchor}`;
            el.style.transform = transform;
            if (this.layout == null) {
                // const {bbox} = this.plot_view.frame
                // const {left, right, top, bottom} = bbox
                // el.style.clipPath = ???
            }
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                el.style.backgroundColor = ctx.fillStyle;
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                // attempt to support vector-style ("8 4 8") line dashing for css mode
                el.style.borderStyle = ctx.lineDash.length < 2 ? "solid" : "dashed";
                el.style.borderWidth = `${ctx.lineWidth}px`;
                el.style.borderColor = ctx.strokeStyle;
            }
            (0, dom_1.display)(el);
        }
    }
    exports.TextAnnotationView = TextAnnotationView;
    TextAnnotationView.__name__ = "TextAnnotationView";
    class TextAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TextAnnotation = TextAnnotation;
    _a = TextAnnotation;
    TextAnnotation.__name__ = "TextAnnotation";
    (() => {
        _a.define(() => ({
            /** @deprecated */
            render_mode: [enums_1.RenderMode, "canvas"],
        }));
    })();
},
/* core/graphics.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const bbox_1 = require(65) /* ./util/bbox */;
    const text_1 = require(121) /* ./util/text */;
    const array_1 = require(9) /* ./util/array */;
    const types_1 = require(8) /* ./util/types */;
    const affine_1 = require(122) /* ./util/affine */;
    const color_1 = require(22) /* ./util/color */;
    exports.text_width = (() => {
        const canvas = document.createElement("canvas");
        const ctx = canvas.getContext("2d");
        let current_font = "";
        return (text, font) => {
            if (font != current_font) {
                current_font = font;
                ctx.font = font;
            }
            return ctx.measureText(text).width;
        };
    })();
    class GraphicsBox {
        constructor() {
            this._position = { sx: 0, sy: 0 };
            this.font_size_scale = 1.0;
            this.align = "left";
            this._base_font_size = 13; // the same as .bk-root's font-size (13px)
            this._x_anchor = "left";
            this._y_anchor = "center";
        }
        set base_font_size(v) {
            if (v != null)
                this._base_font_size = v;
        }
        get base_font_size() {
            return this._base_font_size;
        }
        set position(p) {
            this._position = p;
        }
        get position() {
            return this._position;
        }
        infer_text_height() {
            return "ascent_descent";
        }
        bbox() {
            const { p0, p1, p2, p3 } = this.rect();
            const left = Math.min(p0.x, p1.x, p2.x, p3.x);
            const top = Math.min(p0.y, p1.y, p2.y, p3.y);
            const right = Math.max(p0.x, p1.x, p2.x, p3.x);
            const bottom = Math.max(p0.y, p1.y, p2.y, p3.y);
            return new bbox_1.BBox({ left, right, top, bottom });
        }
        size() {
            const { width, height } = this._size();
            const { angle } = this;
            if (!angle)
                return { width, height };
            else {
                const c = Math.cos(Math.abs(angle));
                const s = Math.sin(Math.abs(angle));
                return {
                    width: Math.abs(width * c + height * s),
                    height: Math.abs(width * s + height * c),
                };
            }
        }
        rect() {
            const rect = this._rect();
            const { angle } = this;
            if (!angle)
                return rect;
            else {
                const { sx, sy } = this.position;
                const tr = new affine_1.AffineTransform();
                tr.translate(sx, sy);
                tr.rotate(angle);
                tr.translate(-sx, -sy);
                return tr.apply_rect(rect);
            }
        }
        paint_rect(ctx) {
            const { p0, p1, p2, p3 } = this.rect();
            ctx.save();
            ctx.strokeStyle = "red";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(p0.x), round(p0.y));
            ctx.lineTo(round(p1.x), round(p1.y));
            ctx.lineTo(round(p2.x), round(p2.y));
            ctx.lineTo(round(p3.x), round(p3.y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
        paint_bbox(ctx) {
            const { x, y, width, height } = this.bbox();
            ctx.save();
            ctx.strokeStyle = "blue";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(x), round(y));
            ctx.lineTo(round(x), round(y + height));
            ctx.lineTo(round(x + width), round(y + height));
            ctx.lineTo(round(x + width), round(y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
    }
    exports.GraphicsBox = GraphicsBox;
    GraphicsBox.__name__ = "GraphicsBox";
    class TextBox extends GraphicsBox {
        constructor({ text }) {
            super();
            this.text = text;
        }
        //padding: Padding
        set visuals(v) {
            const color = v.color;
            const alpha = v.alpha;
            const style = v.font_style;
            let size = v.font_size;
            const face = v.font;
            const { font_size_scale, base_font_size } = this;
            const res = (0, text_1.parse_css_font_size)(size);
            if (res != null) {
                let { value, unit } = res;
                value *= font_size_scale;
                if (unit == "em" && base_font_size) {
                    value *= base_font_size;
                    unit = "px";
                }
                size = `${value}${unit}`;
            }
            const font = `${style} ${size} ${face}`;
            this.font = font;
            this.color = (0, color_1.color2css)(color, alpha);
            this.line_height = v.line_height;
            const align = v.align;
            this._x_anchor = align;
            const baseline = v.baseline;
            this._y_anchor = (() => {
                switch (baseline) {
                    case "top": return "top";
                    case "middle": return "center";
                    case "bottom": return "bottom";
                    default: return "baseline";
                }
            })();
        }
        infer_text_height() {
            if (this.text.includes("\n"))
                return "ascent_descent";
            else {
                function is_math_like(text) {
                    for (const c of new Set(text)) {
                        if ("0" <= c && c <= "9")
                            continue;
                        switch (c) {
                            case ",":
                            case ".":
                            case "+":
                            case "-":
                            case "\u2212":
                            case "e":
                                continue;
                            default:
                                return false;
                        }
                    }
                    return true;
                }
                if (is_math_like(this.text))
                    return "cap";
                else
                    return "ascent_descent";
                /*
                const {font} = this
                const fmetrics = font_metrics(font)
          
                let max_ascent = 0
                let max_descent = 0
                for (const c of this.text) {
                  const metrics = glyph_metrics(c, font)
                  max_ascent = Math.max(metrics.ascent)
                  max_descent = Math.max(metrics.descent)
                }
          
                const ascent = (() => {
                  if (max_ascent > fmetrics.cap_height)
                    return "ascent"
                  else if (max_ascent > fmetrics.x_height)
                    return "cap"
                  else
                    return "x"
                })()
          
                return max_descent > 0 ? `${ascent}_descent` as const : ascent
                */
            }
        }
        _text_line(fmetrics) {
            var _a;
            const metric = (_a = this.text_height_metric) !== null && _a !== void 0 ? _a : this.infer_text_height();
            const ascent = (() => {
                switch (metric) {
                    case "x":
                    case "x_descent":
                        return fmetrics.x_height;
                    case "cap":
                    case "cap_descent":
                        return fmetrics.cap_height;
                    case "ascent":
                    case "ascent_descent":
                        return fmetrics.ascent;
                }
            })();
            const descent = (() => {
                switch (metric) {
                    case "x":
                    case "cap":
                    case "ascent":
                        return 0;
                    case "x_descent":
                    case "cap_descent":
                    case "ascent_descent":
                        return fmetrics.descent;
                }
            })();
            return { height: ascent + descent, ascent, descent };
        }
        get nlines() {
            const lines = this.text.split("\n");
            return lines.length;
        }
        _size() {
            var _a, _b;
            const { font } = this;
            const fmetrics = (0, text_1.font_metrics)(font);
            const line_spacing = (this.line_height - 1) * fmetrics.height; // TODO: max(trailing(L[n-1]), leading(L[n]))
            const empty = this.text == "";
            const lines = this.text.split("\n");
            const nlines = lines.length;
            const widths = lines.map((line) => (0, exports.text_width)(line, font));
            const text_line = this._text_line(fmetrics);
            const text_height = text_line.height * nlines;
            /*
            const heights: number[] = []
            const ascents: number[] = []
            const descents: number[] = []
        
            for (const line of lines) {
              const metrics = [...line].map((c) => glyph_metrics(c, font))
              const max_ascent = Math.max(max(metrics.map((m) => m.ascent)), fmetrics.cap_height)
              const max_descent = max(metrics.map((m) => m.descent))
              ascents.push(max_ascent)
              descents.push(max_descent)
              heights.push(max_ascent + max_descent)
            }
        
            const text_height = sum(heights)
            */
            const w_scale = ((_a = this.width) === null || _a === void 0 ? void 0 : _a.unit) == "%" ? this.width.value : 1;
            const h_scale = ((_b = this.height) === null || _b === void 0 ? void 0 : _b.unit) == "%" ? this.height.value : 1;
            const width = (0, array_1.max)(widths) * w_scale;
            const height = empty ? 0 : (text_height + line_spacing * (nlines - 1)) * h_scale;
            return { width, height, metrics: fmetrics };
        }
        _computed_position(size, metrics, nlines) {
            const { width, height } = size;
            const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
            const x = sx - (() => {
                if ((0, types_1.isNumber)(x_anchor))
                    return x_anchor * width;
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            const y = sy - (() => {
                var _a;
                if ((0, types_1.isNumber)(y_anchor))
                    return y_anchor * height;
                else {
                    switch (y_anchor) {
                        case "top": return 0;
                        case "center": return 0.5 * height;
                        case "bottom": return height;
                        case "baseline": {
                            if (nlines == 1) {
                                const metric = (_a = this.text_height_metric) !== null && _a !== void 0 ? _a : this.infer_text_height();
                                switch (metric) {
                                    case "x":
                                    case "x_descent":
                                        return metrics.x_height;
                                    case "cap":
                                    case "cap_descent":
                                        return metrics.cap_height;
                                    case "ascent":
                                    case "ascent_descent":
                                        return metrics.ascent;
                                }
                            }
                            else
                                return 0.5 * height;
                        }
                    }
                }
            })();
            return { x, y };
        }
        _rect() {
            const { width, height, metrics } = this._size();
            const nlines = this.text.split("\n").length;
            const { x, y } = this._computed_position({ width, height }, metrics, nlines);
            const bbox = new bbox_1.BBox({ x, y, width, height });
            return bbox.rect;
        }
        paint(ctx) {
            var _a, _b;
            const { font } = this;
            const fmetrics = (0, text_1.font_metrics)(font);
            const line_spacing = (this.line_height - 1) * fmetrics.height; // TODO: see above
            const lines = this.text.split("\n");
            const nlines = lines.length;
            const widths = lines.map((line) => (0, exports.text_width)(line, font));
            const text_line = this._text_line(fmetrics);
            const text_height = text_line.height * nlines;
            /*
            const heights: number[] = []
            const ascents: number[] = []
            const descents: number[] = []
        
            for (const line of lines) {
              const metrics = [...line].map((c) => glyph_metrics(c, font))
              const max_ascent = Math.max(max(metrics.map((m) => m.ascent)), fmetrics.cap_height)
              const max_descent = max(metrics.map((m) => m.descent))
              ascents.push(max_ascent)
              descents.push(max_descent)
              heights.push(max_ascent + max_descent)
            }
            */
            const w_scale = ((_a = this.width) === null || _a === void 0 ? void 0 : _a.unit) == "%" ? this.width.value : 1;
            const h_scale = ((_b = this.height) === null || _b === void 0 ? void 0 : _b.unit) == "%" ? this.height.value : 1;
            const width = (0, array_1.max)(widths) * w_scale;
            const height = (text_height + line_spacing * (nlines - 1)) * h_scale;
            ctx.save();
            ctx.fillStyle = this.color;
            ctx.font = this.font;
            ctx.textAlign = "left";
            ctx.textBaseline = "alphabetic";
            const { sx, sy } = this.position;
            const { align } = this;
            const { angle } = this;
            if (angle) {
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            let { x, y } = this._computed_position({ width, height }, fmetrics, nlines);
            if (align == "justify") {
                for (let i = 0; i < nlines; i++) {
                    let xij = x;
                    const line = lines[i];
                    const words = line.split(" ");
                    const nwords = words.length;
                    const word_widths = words.map((word) => (0, exports.text_width)(word, font));
                    const word_spacing = (width - (0, array_1.sum)(word_widths)) / (nwords - 1);
                    for (let j = 0; j < nwords; j++) {
                        ctx.fillText(words[j], xij, y);
                        xij += word_widths[j] + word_spacing;
                    }
                    y += /*heights[i]*/ text_line.height + line_spacing;
                }
            }
            else {
                for (let i = 0; i < nlines; i++) {
                    const xi = x + (() => {
                        switch (align) {
                            case "left": return 0;
                            case "center": return 0.5 * (width - widths[i]);
                            case "right": return width - widths[i];
                        }
                    })();
                    ctx.fillStyle = this.color;
                    ctx.fillText(lines[i], xi, y + /*ascents[i]*/ text_line.ascent);
                    y += /*heights[i]*/ text_line.height + line_spacing;
                }
            }
            ctx.restore();
        }
    }
    exports.TextBox = TextBox;
    TextBox.__name__ = "TextBox";
    class BaseExpo extends GraphicsBox {
        constructor(base, expo) {
            super();
            this.base = base;
            this.expo = expo;
        }
        get children() {
            return [this.base, this.expo];
        }
        set base_font_size(v) {
            super.base_font_size = v;
            this.base.base_font_size = v;
            this.expo.base_font_size = v;
        }
        set position(p) {
            this._position = p;
            const bs = this.base.size();
            const es = this.expo.size();
            const shift = this._shift_scale() * bs.height;
            const height = Math.max(bs.height, shift + es.height);
            this.base.position = {
                sx: 0, x_anchor: "left",
                sy: height, y_anchor: "bottom",
            };
            this.expo.position = {
                sx: bs.width, x_anchor: "left",
                sy: shift, y_anchor: "bottom",
            };
        }
        get position() {
            return this._position;
        }
        set visuals(v) {
            this.expo.font_size_scale = 0.7;
            this.base.visuals = v;
            this.expo.visuals = v;
        }
        _shift_scale() {
            if (this.base instanceof TextBox && this.base.nlines == 1) {
                const { x_height, cap_height } = (0, text_1.font_metrics)(this.base.font);
                return x_height / cap_height;
            }
            else {
                return 2 / 3;
            }
        }
        infer_text_height() {
            return this.base.infer_text_height();
        }
        _rect() {
            const bb = this.base.bbox();
            const eb = this.expo.bbox();
            const bbox = bb.union(eb);
            const { x, y } = this._computed_position();
            return bbox.translate(x, y).rect;
        }
        _size() {
            const bs = this.base.size();
            const es = this.expo.size();
            return {
                width: bs.width + es.width,
                height: Math.max(bs.height, this._shift_scale() * bs.height + es.height),
            };
        }
        paint(ctx) {
            ctx.save();
            const { angle } = this;
            if (angle) {
                const { sx, sy } = this.position;
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            const { x, y } = this._computed_position();
            ctx.translate(x, y);
            this.base.paint(ctx);
            this.expo.paint(ctx);
            ctx.restore();
        }
        // paint_rect ...
        paint_bbox(ctx) {
            super.paint_bbox(ctx);
            const { x, y } = this._computed_position();
            ctx.save();
            ctx.translate(x, y);
            for (const child of this.children) {
                child.paint_bbox(ctx);
            }
            ctx.restore();
        }
        _computed_position() {
            const { width, height } = this._size();
            const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
            const x = sx - (() => {
                if ((0, types_1.isNumber)(x_anchor))
                    return x_anchor * width;
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            const y = sy - (() => {
                if ((0, types_1.isNumber)(y_anchor))
                    return y_anchor * height;
                else {
                    switch (y_anchor) {
                        case "top": return 0;
                        case "center": return 0.5 * height;
                        case "bottom": return height;
                        case "baseline": return 0.5 * height; /* TODO */
                    }
                }
            })();
            return { x, y };
        }
    }
    exports.BaseExpo = BaseExpo;
    BaseExpo.__name__ = "BaseExpo";
    class GraphicsBoxes {
        constructor(items) {
            this.items = items;
        }
        set base_font_size(v) {
            for (const item of this.items) {
                item.base_font_size = v;
            }
        }
        get length() {
            return this.items.length;
        }
        set visuals(v) {
            for (const item of this.items) {
                item.visuals = v;
            }
            const metric_map = { x: 0, cap: 1, ascent: 2, x_descent: 3, cap_descent: 4, ascent_descent: 5 };
            const common = (0, array_1.max_by)(this.items.map((item) => item.infer_text_height()), (metric) => metric_map[metric]);
            for (const item of this.items) {
                item.text_height_metric = common;
            }
        }
        set angle(a) {
            for (const item of this.items) {
                item.angle = a;
            }
        }
        max_size() {
            let width = 0;
            let height = 0;
            for (const item of this.items) {
                const size = item.size();
                width = Math.max(width, size.width);
                height = Math.max(height, size.height);
            }
            return { width, height };
        }
    }
    exports.GraphicsBoxes = GraphicsBoxes;
    GraphicsBoxes.__name__ = "GraphicsBoxes";
},
/* core/util/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const assert_1 = require(11) /* ./assert */;
    const has_OffscreenCanvas = (() => {
        try {
            return typeof OffscreenCanvas !== "undefined" && new OffscreenCanvas(0, 0).getContext("2d") != null;
        }
        catch (_a) {
            return false;
        }
    })();
    const _offscreen_canvas = (() => {
        if (has_OffscreenCanvas)
            return (w, h) => new OffscreenCanvas(w, h);
        else {
            return (w, h) => {
                const canvas = document.createElement("canvas");
                canvas.width = w;
                canvas.height = h;
                return canvas;
            };
        }
    })();
    const _native_font_metrics = (() => {
        const canvas = _offscreen_canvas(0, 0);
        const ctx = canvas.getContext("2d");
        return (font) => {
            ctx.font = font;
            const cap_metrics = ctx.measureText("M");
            const x_metrics = ctx.measureText("x");
            const metrics = ctx.measureText("ÅŚg|");
            const font_ascent = metrics.fontBoundingBoxAscent;
            const font_descent = metrics.fontBoundingBoxDescent;
            if (font_ascent != null && font_descent != null) {
                return {
                    height: font_ascent + font_descent,
                    ascent: font_ascent,
                    descent: font_descent,
                    cap_height: cap_metrics.actualBoundingBoxAscent,
                    x_height: x_metrics.actualBoundingBoxAscent,
                };
            }
            const text_ascent = metrics.actualBoundingBoxAscent;
            const text_descent = metrics.actualBoundingBoxDescent;
            if (text_ascent != null && text_descent != null) {
                return {
                    height: text_ascent + text_descent,
                    ascent: text_ascent,
                    descent: text_descent,
                    cap_height: cap_metrics.actualBoundingBoxAscent,
                    x_height: x_metrics.actualBoundingBoxAscent,
                };
            }
            (0, assert_1.unreachable)();
        };
    })();
    const _native_glyph_metrics = (() => {
        const canvas = _offscreen_canvas(0, 0);
        const ctx = canvas.getContext("2d");
        return (glyph, font) => {
            ctx.font = font;
            const metrics = ctx.measureText(glyph);
            const glyph_ascent = metrics.actualBoundingBoxAscent;
            const glyph_descent = metrics.actualBoundingBoxDescent;
            if (glyph_ascent != null && glyph_descent != null) {
                return {
                    width: metrics.width,
                    height: glyph_ascent + glyph_descent,
                    ascent: glyph_ascent,
                    descent: glyph_descent,
                };
            }
            (0, assert_1.unreachable)();
        };
    })();
    const _internal_font_metrics = (() => {
        const canvas = document.createElement("canvas");
        const ctx = canvas.getContext("2d");
        let cwidth = -1;
        let cheight = -1;
        return (font, scale = 1) => {
            ctx.font = font;
            const { width: _em } = ctx.measureText("M");
            const em = _em * scale;
            const width = Math.ceil(em);
            const height = Math.ceil(2.0 * em);
            const baseline = Math.ceil(1.5 * em);
            if (cwidth < width) {
                cwidth = width;
                canvas.width = width;
            }
            if (cheight < height) {
                cheight = height;
                canvas.height = height;
            }
            ctx.save();
            ctx.scale(scale, scale);
            ctx.fillStyle = "#f00";
            ctx.fillRect(0, 0, width, height);
            const measure_ascent = (data) => {
                let k = 0;
                for (let i = 0; i <= baseline; i++) {
                    for (let j = 0; j < width; j++, k += 4)
                        if (data[k] != 255)
                            return baseline - i;
                }
                return 0;
            };
            const measure_descent = (data) => {
                let k = data.length - 4;
                for (let i = height; i >= baseline; i--) {
                    for (let j = 0; j < width; j++, k -= 4)
                        if (data[k] != 255)
                            return i - baseline;
                }
                return 0;
            };
            ctx.font = font;
            ctx.fillStyle = "#000";
            for (const c of "xa") {
                ctx.fillText(c, 0, baseline / scale);
            }
            const { data: data0 } = ctx.getImageData(0, 0, width, height);
            const x_height = measure_ascent(data0) / scale;
            for (const c of "ASQ") {
                ctx.fillText(c, 0, baseline / scale);
            }
            const { data: data1 } = ctx.getImageData(0, 0, width, height);
            const cap_height = measure_ascent(data1) / scale;
            for (const c of "ÅŚgy") {
                ctx.fillText(c, 0, baseline / scale);
            }
            const { data: data2 } = ctx.getImageData(0, 0, width, height);
            const ascent = measure_ascent(data2) / scale;
            const descent = measure_descent(data2) / scale;
            ctx.restore();
            return { height: ascent + descent, ascent, cap_height, x_height, descent };
        };
    })();
    const _internal_glyph_metrics = (() => {
        const canvas = document.createElement("canvas");
        const ctx = canvas.getContext("2d");
        let cwidth = -1;
        let cheight = -1;
        return (glyph, font, scale = 1) => {
            ctx.font = font;
            const { width: _em } = ctx.measureText("M");
            const em = _em * scale;
            const width = Math.ceil(em);
            const height = Math.ceil(2.0 * em);
            const baseline = Math.ceil(1.5 * em);
            if (cwidth < width || cheight < height) {
                cwidth = width;
                canvas.width = width;
                cheight = height;
                canvas.height = height;
            }
            ctx.save();
            ctx.scale(scale, scale);
            ctx.fillStyle = "#f00";
            ctx.fillRect(0, 0, width, height);
            const measure_ascent = (data) => {
                let k = 0;
                for (let i = 0; i <= baseline; i++) {
                    for (let j = 0; j < width; j++, k += 4)
                        if (data[k] != 255)
                            return baseline - i;
                }
                return 0;
            };
            const measure_descent = (data) => {
                let k = data.length - 4;
                for (let i = height; i >= baseline; i--) {
                    for (let j = 0; j < width; j++, k -= 4)
                        if (data[k] != 255)
                            return i - baseline;
                }
                return 0;
            };
            ctx.font = font;
            ctx.fillStyle = "#000";
            ctx.fillText(glyph, 0, baseline / scale);
            const size = ctx.measureText(glyph);
            const { data } = ctx.getImageData(0, 0, width, height);
            const ascent = measure_ascent(data) / scale;
            const descent = measure_descent(data) / scale;
            ctx.restore();
            return { width: size.width, height: ascent + descent, ascent, descent };
        };
    })();
    const _font_metrics = (() => {
        try {
            _native_font_metrics("normal 10px sans-serif");
            return _native_font_metrics;
        }
        catch (_a) {
            return _internal_font_metrics;
        }
    })();
    const _glyph_metrics = (() => {
        try {
            _native_glyph_metrics("A", "normal 10px sans-serif");
            return _native_glyph_metrics;
        }
        catch (_a) {
            return _internal_glyph_metrics;
        }
    })();
    const _metrics_cache = new Map();
    function font_metrics(font) {
        let metrics = _metrics_cache.get(font);
        if (metrics == null) {
            // TODO: document.fonts.check(font)
            metrics = { font: _font_metrics(font), glyphs: new Map() };
            _metrics_cache.set(font, metrics);
        }
        return metrics.font;
    }
    exports.font_metrics = font_metrics;
    function glyph_metrics(glyph, font) {
        let metrics = _metrics_cache.get(font);
        if (metrics == null) {
            font_metrics(font);
            metrics = _metrics_cache.get(font);
        }
        let glyph_metrics = metrics.glyphs.get(glyph);
        if (glyph_metrics == null) {
            glyph_metrics = _glyph_metrics(glyph, font);
            metrics.glyphs.set(glyph, glyph_metrics);
        }
        return glyph_metrics;
    }
    exports.glyph_metrics = glyph_metrics;
    function parse_css_font_size(size) {
        const match = size.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);
        if (match != null) {
            const [, value, , unit] = match;
            const number = Number(value);
            if (isFinite(number))
                return { value: number, unit };
        }
        return null;
    }
    exports.parse_css_font_size = parse_css_font_size;
},
/* core/util/affine.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const { sin, cos } = Math;
    class AffineTransform {
        constructor(a = 1, b = 0, c = 0, d = 1, e = 0, f = 0) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }
        toString() {
            const { a, b, c, d, e, f } = this;
            return `matrix(${a}, ${b}, ${c}, ${d}, ${e}, ${f})`;
        }
        static from_DOMMatrix(matrix) {
            const { a, b, c, d, e, f } = matrix;
            return new AffineTransform(a, b, c, d, e, f);
        }
        to_DOMMatrix() {
            const { a, b, c, d, e, f } = this;
            return new DOMMatrix([a, b, c, d, e, f]);
        }
        clone() {
            const { a, b, c, d, e, f } = this;
            return new AffineTransform(a, b, c, d, e, f);
        }
        get is_identity() {
            const { a, b, c, d, e, f } = this;
            return a == 1 && b == 0 && c == 0 && d == 1 && e == 0 && f == 0;
        }
        apply_point(p) {
            const [x, y] = this.apply(p.x, p.y);
            return { x, y };
        }
        apply_rect(rect) {
            const p0 = this.apply_point(rect.p0);
            const p1 = this.apply_point(rect.p1);
            const p2 = this.apply_point(rect.p2);
            const p3 = this.apply_point(rect.p3);
            return { p0, p1, p2, p3 };
        }
        apply(x, y) {
            const { a, b, c, d, e, f } = this;
            return [
                a * x + c * y + e,
                b * x + d * y + f,
            ];
        }
        iv_apply(xs, ys) {
            const { a, b, c, d, e, f } = this;
            const n = xs.length;
            for (let i = 0; i < n; i++) {
                const x = xs[i];
                const y = ys[i];
                xs[i] = a * x + c * y + e;
                ys[i] = b * x + d * y + f;
            }
        }
        transform(A, B, C, D, E, F) {
            const { a, b, c, d, e, f } = this;
            this.a = a * A + c * B;
            this.c = a * C + c * D;
            this.e = a * E + c * F + e;
            this.b = b * A + d * B;
            this.d = b * C + d * D;
            this.f = b * E + d * F + f;
            return this;
        }
        translate(tx, ty) {
            return this.transform(1, 0, 0, 1, tx, ty);
        }
        scale(cx, cy) {
            return this.transform(cx, 0, 0, cy, 0, 0);
        }
        skew(sx, sy) {
            return this.transform(1, sy, sx, 1, 0, 0);
        }
        rotate(angle) {
            const s = sin(angle);
            const c = cos(angle);
            return this.transform(c, s, -s, c, 0, 0);
        }
        rotate_ccw(angle) {
            return this.rotate(-angle);
        }
        translate_x(tx) {
            return this.translate(tx, 0);
        }
        translate_y(ty) {
            return this.translate(0, ty);
        }
        flip() {
            return this.scale(-1, -1);
        }
        flip_x() {
            return this.scale(1, -1);
        }
        flip_y() {
            return this.scale(-1, 1);
        }
    }
    exports.AffineTransform = AffineTransform;
    AffineTransform.__name__ = "AffineTransform";
},
/* core/layout/side_panel.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(124) /* ./types */;
    const layoutable_1 = require(125) /* ./layoutable */;
    const types_2 = require(8) /* ../util/types */;
    // This table lays out the rules for configuring the baseline, alignment, etc. of
    // title text, based on it's location and orientation
    //
    // side    orient        baseline   align     angle   normal-dist
    // ------------------------------------------------------------------------------
    // above   parallel      bottom     center    0       height
    //         normal        middle     left      -90     width
    //         horizontal    bottom     center    0       height
    //         [angle > 0]   middle     left              width * sin + height * cos
    //         [angle < 0]   middle     right             width * sin + height * cos
    //
    // below   parallel      top        center    0       height
    //         normal        middle     right     90      width
    //         horizontal    top        center    0       height
    //         [angle > 0]   middle     right             width * sin + height * cos
    //         [angle < 0]   middle     left              width * sin + height * cos
    //
    // left    parallel      bottom     center    90      height
    //         normal        middle     right     0       width
    //         horizontal    middle     right     0       width
    //         [angle > 0]   middle     right             width * cos + height * sin
    //         [angle < 0]   middle     right             width * cos + height + sin
    //
    // right   parallel      bottom     center   -90      height
    //         normal        middle     left     0        width
    //         horizontal    middle     left     0        width
    //         [angle > 0]   middle     left              width * cos + height * sin
    //         [angle < 0]   middle     left              width * cos + height + sin
    const pi2 = Math.PI / 2;
    const _angle_lookup = {
        above: {
            parallel: 0,
            normal: -pi2,
            horizontal: 0,
            vertical: -pi2,
        },
        below: {
            parallel: 0,
            normal: pi2,
            horizontal: 0,
            vertical: pi2,
        },
        left: {
            parallel: -pi2,
            normal: 0,
            horizontal: 0,
            vertical: -pi2,
        },
        right: {
            parallel: pi2,
            normal: 0,
            horizontal: 0,
            vertical: pi2,
        },
    };
    const _vertical_align_lookup = {
        above: {
            parallel: "bottom",
            normal: "center",
            horizontal: "bottom",
            vertical: "center",
        },
        below: {
            parallel: "top",
            normal: "center",
            horizontal: "top",
            vertical: "center",
        },
        left: {
            parallel: "bottom",
            normal: "center",
            horizontal: "center",
            vertical: "bottom",
        },
        right: {
            parallel: "bottom",
            normal: "center",
            horizontal: "center",
            vertical: "bottom",
        },
    };
    const _align_lookup = {
        above: {
            parallel: "center",
            normal: "left",
            horizontal: "center",
            vertical: "left",
        },
        below: {
            parallel: "center",
            normal: "left",
            horizontal: "center",
            vertical: "left",
        },
        left: {
            parallel: "center",
            normal: "right",
            horizontal: "right",
            vertical: "center",
        },
        right: {
            parallel: "center",
            normal: "left",
            horizontal: "left",
            vertical: "center",
        },
    };
    const _align_lookup_negative = {
        above: "right",
        below: "left",
        left: "right",
        right: "left",
    };
    const _align_lookup_positive = {
        above: "left",
        below: "right",
        left: "right",
        right: "left",
    };
    class Panel {
        constructor(side) {
            this.side = side;
        }
        get dimension() {
            return this.side == "above" || this.side == "below" ? 0 : 1;
        }
        get normals() {
            switch (this.side) {
                case "above": return [0, -1];
                case "below": return [0, 1];
                case "left": return [-1, 0];
                case "right": return [1, 0];
            }
        }
        get orientation() {
            return this.is_horizontal ? "horizontal" : "vertical";
        }
        get is_horizontal() {
            return this.dimension == 0;
        }
        get is_vertical() {
            return this.dimension == 1;
        }
        get_label_text_heuristics(orient) {
            const { side } = this;
            if ((0, types_2.isString)(orient)) {
                return {
                    vertical_align: _vertical_align_lookup[side][orient],
                    align: _align_lookup[side][orient],
                };
            }
            else {
                return {
                    vertical_align: "center",
                    align: (orient < 0 ? _align_lookup_negative : _align_lookup_positive)[side],
                };
            }
        }
        get_label_angle_heuristic(orient) {
            if ((0, types_2.isString)(orient))
                return _angle_lookup[this.side][orient];
            else
                return -orient;
        }
    }
    exports.Panel = Panel;
    Panel.__name__ = "Panel";
    class SideLayout extends layoutable_1.ContentLayoutable {
        constructor(panel, get_size, rotate = false) {
            super();
            this.panel = panel;
            this.get_size = get_size;
            this.rotate = rotate;
            if (this.panel.is_horizontal)
                this.set_sizing({ width_policy: "max", height_policy: "fixed" });
            else
                this.set_sizing({ width_policy: "fixed", height_policy: "max" });
        }
        _content_size() {
            const { width, height } = this.get_size();
            if (!this.rotate || this.panel.is_horizontal)
                return new types_1.Sizeable({ width, height });
            else
                return new types_1.Sizeable({ width: height, height: width });
        }
        has_size_changed() {
            const { width, height } = this._content_size();
            if (this.panel.is_horizontal)
                return this.bbox.height != height;
            else
                return this.bbox.width != width;
        }
    }
    exports.SideLayout = SideLayout;
    SideLayout.__name__ = "SideLayout";
},
/* core/layout/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const kinds_1 = require(21) /* ../kinds */;
    const { min, max } = Math;
    class Sizeable {
        constructor(size = {}) {
            this.width = size.width != null ? size.width : 0;
            this.height = size.height != null ? size.height : 0;
        }
        bounded_to({ width, height }) {
            return new Sizeable({
                width: this.width == Infinity && width != null ? width : this.width,
                height: this.height == Infinity && height != null ? height : this.height,
            });
        }
        expanded_to({ width, height }) {
            return new Sizeable({
                width: width != Infinity ? max(this.width, width) : this.width,
                height: height != Infinity ? max(this.height, height) : this.height,
            });
        }
        expand_to({ width, height }) {
            this.width = max(this.width, width);
            this.height = max(this.height, height);
        }
        narrowed_to({ width, height }) {
            return new Sizeable({
                width: min(this.width, width),
                height: min(this.height, height),
            });
        }
        narrow_to({ width, height }) {
            this.width = min(this.width, width);
            this.height = min(this.height, height);
        }
        grow_by({ left, right, top, bottom }) {
            const width = this.width + left + right;
            const height = this.height + top + bottom;
            return new Sizeable({ width, height });
        }
        shrink_by({ left, right, top, bottom }) {
            const width = max(this.width - left - right, 0);
            const height = max(this.height - top - bottom, 0);
            return new Sizeable({ width, height });
        }
        map(w_fn, h_fn) {
            return new Sizeable({
                width: w_fn(this.width),
                height: (h_fn != null ? h_fn : w_fn)(this.height),
            });
        }
    }
    exports.Sizeable = Sizeable;
    Sizeable.__name__ = "Sizeable";
    exports.SizingPolicy = (0, kinds_1.Enum)("fixed", "fit", "min", "max");
},
/* core/layout/layoutable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(124) /* ./types */;
    const bbox_1 = require(65) /* ../util/bbox */;
    const types_2 = require(8) /* ../util/types */;
    const { min, max, round } = Math;
    class Layoutable {
        constructor() {
            this.absolute = false;
            this._bbox = new bbox_1.BBox();
            this._inner_bbox = new bbox_1.BBox();
            this._dirty = false;
            this._handlers = [];
        }
        *[Symbol.iterator]() { }
        get bbox() {
            return this._bbox;
        }
        get inner_bbox() {
            return this._inner_bbox;
        }
        get sizing() {
            return this._sizing;
        }
        set visible(visible) {
            this._sizing.visible = visible;
            this._dirty = true;
        }
        set_sizing(sizing) {
            var _a, _b, _c, _d, _e;
            const width_policy = (_a = sizing.width_policy) !== null && _a !== void 0 ? _a : "fit";
            const width = sizing.width;
            const min_width = sizing.min_width;
            const max_width = sizing.max_width;
            const height_policy = (_b = sizing.height_policy) !== null && _b !== void 0 ? _b : "fit";
            const height = sizing.height;
            const min_height = sizing.min_height;
            const max_height = sizing.max_height;
            const aspect = sizing.aspect;
            const margin = (_c = sizing.margin) !== null && _c !== void 0 ? _c : { top: 0, right: 0, bottom: 0, left: 0 };
            const visible = sizing.visible !== false;
            const halign = (_d = sizing.halign) !== null && _d !== void 0 ? _d : "start";
            const valign = (_e = sizing.valign) !== null && _e !== void 0 ? _e : "start";
            this._sizing = {
                width_policy, min_width, width, max_width,
                height_policy, min_height, height, max_height,
                aspect,
                margin,
                visible,
                halign,
                valign,
                size: { width, height },
            };
            this._init();
        }
        _init() { }
        _set_geometry(outer, inner) {
            this._bbox = outer;
            this._inner_bbox = inner;
        }
        set_geometry(outer, inner) {
            const { fixup_geometry } = this;
            if (fixup_geometry != null) {
                [outer, inner] = fixup_geometry(outer, inner);
            }
            this._set_geometry(outer, inner !== null && inner !== void 0 ? inner : outer);
            for (const handler of this._handlers) {
                handler(this._bbox, this._inner_bbox);
            }
        }
        on_resize(handler) {
            this._handlers.push(handler);
        }
        is_width_expanding() {
            return this.sizing.width_policy == "max";
        }
        is_height_expanding() {
            return this.sizing.height_policy == "max";
        }
        apply_aspect(viewport, { width, height }) {
            const { aspect } = this.sizing;
            if (aspect != null) {
                const { width_policy, height_policy } = this.sizing;
                const gt = (width, height) => {
                    const policies = { max: 4, fit: 3, min: 2, fixed: 1 };
                    return policies[width] > policies[height];
                };
                if (width_policy != "fixed" && height_policy != "fixed") {
                    if (width_policy == height_policy) {
                        const w_width = width;
                        const w_height = round(width / aspect);
                        const h_width = round(height * aspect);
                        const h_height = height;
                        const w_diff = Math.abs(viewport.width - w_width) + Math.abs(viewport.height - w_height);
                        const h_diff = Math.abs(viewport.width - h_width) + Math.abs(viewport.height - h_height);
                        if (w_diff <= h_diff) {
                            width = w_width;
                            height = w_height;
                        }
                        else {
                            width = h_width;
                            height = h_height;
                        }
                    }
                    else if (gt(width_policy, height_policy)) {
                        height = round(width / aspect);
                    }
                    else {
                        width = round(height * aspect);
                    }
                }
                else if (width_policy == "fixed") {
                    height = round(width / aspect);
                }
                else if (height_policy == "fixed") {
                    width = round(height * aspect);
                }
            }
            return { width, height };
        }
        measure(viewport_size) {
            if (!this.sizing.visible)
                return { width: 0, height: 0 };
            const exact_width = (width) => {
                return this.sizing.width_policy == "fixed" && this.sizing.width != null ? this.sizing.width : width;
            };
            const exact_height = (height) => {
                return this.sizing.height_policy == "fixed" && this.sizing.height != null ? this.sizing.height : height;
            };
            const viewport = new types_1.Sizeable(viewport_size)
                .shrink_by(this.sizing.margin)
                .map(exact_width, exact_height);
            const computed = this._measure(viewport);
            const clipped = this.clip_size(computed, viewport);
            const width = exact_width(clipped.width);
            const height = exact_height(clipped.height);
            const size = this.apply_aspect(viewport, { width, height });
            return Object.assign(Object.assign({}, computed), size);
        }
        compute(viewport = {}) {
            const size_hint = this.measure({
                width: viewport.width != null && this.is_width_expanding() ? viewport.width : Infinity,
                height: viewport.height != null && this.is_height_expanding() ? viewport.height : Infinity,
            });
            const { width, height } = size_hint;
            const outer = new bbox_1.BBox({ left: 0, top: 0, width, height });
            let inner = undefined;
            if (size_hint.inner != null) {
                const { left, top, right, bottom } = size_hint.inner;
                inner = new bbox_1.BBox({ left, top, right: width - right, bottom: height - bottom });
            }
            this.set_geometry(outer, inner);
        }
        get xview() {
            return this.bbox.xview;
        }
        get yview() {
            return this.bbox.yview;
        }
        clip_size(size, viewport) {
            function clip(size, vsize, min_size, max_size) {
                if (min_size == null)
                    min_size = 0;
                else if (!(0, types_2.isNumber)(min_size))
                    min_size = Math.round(min_size.percent * vsize);
                if (max_size == null)
                    max_size = Infinity;
                else if (!(0, types_2.isNumber)(max_size))
                    max_size = Math.round(max_size.percent * vsize);
                return max(min_size, min(size, max_size));
            }
            return {
                width: clip(size.width, viewport.width, this.sizing.min_width, this.sizing.max_width),
                height: clip(size.height, viewport.height, this.sizing.min_height, this.sizing.max_height),
            };
        }
        has_size_changed() {
            const { _dirty } = this;
            this._dirty = false;
            return _dirty;
        }
    }
    exports.Layoutable = Layoutable;
    Layoutable.__name__ = "Layoutable";
    class LayoutItem extends Layoutable {
        _measure(viewport) {
            const { width_policy, height_policy } = this.sizing;
            const width = (() => {
                const { width } = this.sizing;
                if (viewport.width == Infinity) {
                    return width !== null && width !== void 0 ? width : 0;
                }
                else {
                    switch (width_policy) {
                        case "fixed": return width !== null && width !== void 0 ? width : 0;
                        case "min": return width != null ? min(viewport.width, width) : 0;
                        case "fit": return width != null ? min(viewport.width, width) : viewport.width;
                        case "max": return width != null ? max(viewport.width, width) : viewport.width;
                    }
                }
            })();
            const height = (() => {
                const { height } = this.sizing;
                if (viewport.height == Infinity) {
                    return height !== null && height !== void 0 ? height : 0;
                }
                else {
                    switch (height_policy) {
                        case "fixed": return height !== null && height !== void 0 ? height : 0;
                        case "min": return height != null ? min(viewport.height, height) : 0;
                        case "fit": return height != null ? min(viewport.height, height) : viewport.height;
                        case "max": return height != null ? max(viewport.height, height) : viewport.height;
                    }
                }
            })();
            return { width, height };
        }
    }
    exports.LayoutItem = LayoutItem;
    LayoutItem.__name__ = "LayoutItem";
    class ContentLayoutable extends Layoutable {
        _measure(viewport) {
            const content_size = this._content_size();
            const bounds = viewport
                .bounded_to(this.sizing.size)
                .bounded_to(content_size);
            const width = (() => {
                switch (this.sizing.width_policy) {
                    case "fixed":
                        return this.sizing.width != null ? this.sizing.width : content_size.width;
                    case "min":
                        return content_size.width;
                    case "fit":
                        return bounds.width;
                    case "max":
                        return Math.max(content_size.width, bounds.width);
                }
            })();
            const height = (() => {
                switch (this.sizing.height_policy) {
                    case "fixed":
                        return this.sizing.height != null ? this.sizing.height : content_size.height;
                    case "min":
                        return content_size.height;
                    case "fit":
                        return bounds.height;
                    case "max":
                        return Math.max(content_size.height, bounds.height);
                }
            })();
            return { width, height };
        }
    }
    exports.ContentLayoutable = ContentLayoutable;
    ContentLayoutable.__name__ = "ContentLayoutable";
},
/* models/canvas/cartesian_frame.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const categorical_scale_1 = require(62) /* ../scales/categorical_scale */;
    const log_scale_1 = require(61) /* ../scales/log_scale */;
    const range1d_1 = require(58) /* ../ranges/range1d */;
    const data_range1d_1 = require(63) /* ../ranges/data_range1d */;
    const factor_range_1 = require(67) /* ../ranges/factor_range */;
    const bbox_1 = require(65) /* ../../core/util/bbox */;
    const object_1 = require(13) /* ../../core/util/object */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    class CartesianFrame {
        constructor(in_x_scale, in_y_scale, x_range, y_range, extra_x_ranges = {}, extra_y_ranges = {}, extra_x_scales = {}, extra_y_scales = {}) {
            this.in_x_scale = in_x_scale;
            this.in_y_scale = in_y_scale;
            this.x_range = x_range;
            this.y_range = y_range;
            this.extra_x_ranges = extra_x_ranges;
            this.extra_y_ranges = extra_y_ranges;
            this.extra_x_scales = extra_x_scales;
            this.extra_y_scales = extra_y_scales;
            this._bbox = new bbox_1.BBox();
            (0, assert_1.assert)(in_x_scale.source_range == null && in_x_scale.target_range == null);
            (0, assert_1.assert)(in_y_scale.source_range == null && in_y_scale.target_range == null);
            this._configure_scales();
        }
        get bbox() {
            return this._bbox;
        }
        _get_ranges(range, extra_ranges) {
            return new Map((0, object_1.entries)(Object.assign(Object.assign({}, extra_ranges), { default: range })));
        }
        /*protected*/ _get_scales(scale, extra_scales, ranges, frame_range) {
            var _a;
            const in_scales = new Map((0, object_1.entries)(Object.assign(Object.assign({}, extra_scales), { default: scale })));
            const scales = new Map();
            for (const [name, range] of ranges) {
                const factor_range = range instanceof factor_range_1.FactorRange;
                const categorical_scale = scale instanceof categorical_scale_1.CategoricalScale;
                if (factor_range != categorical_scale) {
                    throw new Error(`Range ${range.type} is incompatible is Scale ${scale.type}`);
                }
                if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d)
                    range.scale_hint = "log";
                const derived_scale = ((_a = in_scales.get(name)) !== null && _a !== void 0 ? _a : scale).clone();
                derived_scale.setv({ source_range: range, target_range: frame_range });
                scales.set(name, derived_scale);
            }
            return scales;
        }
        _configure_frame_ranges() {
            // data to/from screen space transform (left-bottom <-> left-top origin)
            const { bbox } = this;
            this._x_target = new range1d_1.Range1d({ start: bbox.left, end: bbox.right });
            this._y_target = new range1d_1.Range1d({ start: bbox.bottom, end: bbox.top });
        }
        _configure_scales() {
            this._configure_frame_ranges();
            this._x_ranges = this._get_ranges(this.x_range, this.extra_x_ranges);
            this._y_ranges = this._get_ranges(this.y_range, this.extra_y_ranges);
            this._x_scales = this._get_scales(this.in_x_scale, this.extra_x_scales, this._x_ranges, this._x_target);
            this._y_scales = this._get_scales(this.in_y_scale, this.extra_y_scales, this._y_ranges, this._y_target);
        }
        _update_scales() {
            this._configure_frame_ranges();
            for (const [, scale] of this._x_scales) {
                scale.target_range = this._x_target;
            }
            for (const [, scale] of this._y_scales) {
                scale.target_range = this._y_target;
            }
        }
        set_geometry(bbox) {
            this._bbox = bbox;
            this._update_scales();
        }
        get x_target() {
            return this._x_target;
        }
        get y_target() {
            return this._y_target;
        }
        get x_ranges() {
            return this._x_ranges;
        }
        get y_ranges() {
            return this._y_ranges;
        }
        get x_scales() {
            return this._x_scales;
        }
        get y_scales() {
            return this._y_scales;
        }
        get x_scale() {
            return this._x_scales.get("default");
        }
        get y_scale() {
            return this._y_scales.get("default");
        }
        /** @deprecated */
        get xscales() {
            return (0, object_1.to_object)(this.x_scales);
        }
        /** @deprecated */
        get yscales() {
            return (0, object_1.to_object)(this.y_scales);
        }
    }
    exports.CartesianFrame = CartesianFrame;
    CartesianFrame.__name__ = "CartesianFrame";
},
/* models/axes/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var axis_1 = require(128) /* ./axis */;
    __esExport("Axis", axis_1.Axis);
    var categorical_axis_1 = require(140) /* ./categorical_axis */;
    __esExport("CategoricalAxis", categorical_axis_1.CategoricalAxis);
    var continuous_axis_1 = require(143) /* ./continuous_axis */;
    __esExport("ContinuousAxis", continuous_axis_1.ContinuousAxis);
    var datetime_axis_1 = require(144) /* ./datetime_axis */;
    __esExport("DatetimeAxis", datetime_axis_1.DatetimeAxis);
    var linear_axis_1 = require(145) /* ./linear_axis */;
    __esExport("LinearAxis", linear_axis_1.LinearAxis);
    var log_axis_1 = require(162) /* ./log_axis */;
    __esExport("LogAxis", log_axis_1.LogAxis);
    var mercator_axis_1 = require(165) /* ./mercator_axis */;
    __esExport("MercatorAxis", mercator_axis_1.MercatorAxis);
},
/* models/axes/axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const guide_renderer_1 = require(129) /* ../renderers/guide_renderer */;
    const ticker_1 = require(130) /* ../tickers/ticker */;
    const tick_formatter_1 = require(131) /* ../formatters/tick_formatter */;
    const labeling_1 = require(132) /* ../policies/labeling */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    const types_1 = require(24) /* ../../core/types */;
    const side_panel_1 = require(123) /* ../../core/layout/side_panel */;
    const array_1 = require(9) /* ../../core/util/array */;
    const object_1 = require(13) /* ../../core/util/object */;
    const types_2 = require(8) /* ../../core/util/types */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    const factor_range_1 = require(67) /* ../ranges/factor_range */;
    const base_text_1 = require(133) /* ../text/base_text */;
    const build_views_1 = require(113) /* ../../core/build_views */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    const types_3 = require(8) /* ../../core/util/types */;
    const utils_1 = require(134) /* ../text/utils */;
    const { abs } = Math;
    class AxisView extends guide_renderer_1.GuideRendererView {
        constructor() {
            super(...arguments);
            /*private*/ this._axis_label_view = null;
            /*private*/ this._major_label_views = new Map();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this._init_axis_label();
            await this._init_major_labels();
        }
        async _init_axis_label() {
            const { axis_label } = this.model;
            if (axis_label != null) {
                const _axis_label = (0, types_3.isString)(axis_label) ? (0, utils_1.parse_delimited_string)(axis_label) : axis_label;
                this._axis_label_view = await (0, build_views_1.build_view)(_axis_label, { parent: this });
            }
            else
                this._axis_label_view = null;
        }
        async _init_major_labels() {
            const { major_label_overrides } = this.model;
            for (const [label, label_text] of (0, object_1.entries)(major_label_overrides)) {
                const _label_text = (0, types_3.isString)(label_text) ? (0, utils_1.parse_delimited_string)(label_text) : label_text;
                this._major_label_views.set(label, await (0, build_views_1.build_view)(_label_text, { parent: this }));
            }
        }
        update_layout() {
            this.layout = new side_panel_1.SideLayout(this.panel, () => this.get_size(), true);
            this.layout.on_resize(() => this._coordinates = undefined);
        }
        get_size() {
            const { visible, fixed_location } = this.model;
            if (visible && fixed_location == null && this.is_renderable) {
                const { extents } = this;
                const height = Math.round(extents.tick + extents.tick_label + extents.axis_label);
                return { width: 0, height };
            }
            else
                return { width: 0, height: 0 };
        }
        get is_renderable() {
            const [range, cross_range] = this.ranges;
            return range.is_valid && cross_range.is_valid;
        }
        _render() {
            var _b;
            if (!this.is_renderable)
                return;
            const { tick_coords, extents } = this;
            const ctx = this.layer.ctx;
            ctx.save();
            this._draw_rule(ctx, extents);
            this._draw_major_ticks(ctx, extents, tick_coords);
            this._draw_minor_ticks(ctx, extents, tick_coords);
            this._draw_major_labels(ctx, extents, tick_coords);
            this._draw_axis_label(ctx, extents, tick_coords);
            (_b = this._paint) === null || _b === void 0 ? void 0 : _b.call(this, ctx, extents, tick_coords);
            ctx.restore();
        }
        connect_signals() {
            super.connect_signals();
            const { axis_label, major_label_overrides } = this.model.properties;
            this.on_change(axis_label, async () => {
                var _b;
                (_b = this._axis_label_view) === null || _b === void 0 ? void 0 : _b.remove();
                await this._init_axis_label();
            });
            this.on_change(major_label_overrides, async () => {
                for (const label_view of this._major_label_views.values()) {
                    label_view.remove();
                }
                await this._init_major_labels();
            });
            this.connect(this.model.change, () => this.plot_view.request_layout());
        }
        get needs_clip() {
            return this.model.fixed_location != null;
        }
        // drawing sub functions -----------------------------------------------------
        _draw_rule(ctx, _extents) {
            if (!this.visuals.axis_line.doit)
                return;
            const [xs, ys] = this.rule_coords;
            const [sxs, sys] = this.coordinates.map_to_screen(xs, ys);
            const [nx, ny] = this.normals;
            const [xoff, yoff] = this.offsets;
            this.visuals.axis_line.set_value(ctx);
            ctx.beginPath();
            for (let i = 0; i < sxs.length; i++) {
                const sx = Math.round(sxs[i] + nx * xoff);
                const sy = Math.round(sys[i] + ny * yoff);
                ctx.lineTo(sx, sy);
            }
            ctx.stroke();
        }
        _draw_major_ticks(ctx, _extents, tick_coords) {
            const tin = this.model.major_tick_in;
            const tout = this.model.major_tick_out;
            const visuals = this.visuals.major_tick_line;
            this._draw_ticks(ctx, tick_coords.major, tin, tout, visuals);
        }
        _draw_minor_ticks(ctx, _extents, tick_coords) {
            const tin = this.model.minor_tick_in;
            const tout = this.model.minor_tick_out;
            const visuals = this.visuals.minor_tick_line;
            this._draw_ticks(ctx, tick_coords.minor, tin, tout, visuals);
        }
        _draw_major_labels(ctx, extents, tick_coords) {
            const coords = tick_coords.major;
            const labels = this.compute_labels(coords[this.dimension]);
            const orient = this.model.major_label_orientation;
            const standoff = extents.tick + this.model.major_label_standoff;
            const visuals = this.visuals.major_label_text;
            this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
        }
        _axis_label_extent() {
            if (this._axis_label_view == null)
                return 0;
            const axis_label_graphics = this._axis_label_view.graphics();
            const padding = 3;
            axis_label_graphics.visuals = this.visuals.axis_label_text.values();
            axis_label_graphics.angle = this.panel.get_label_angle_heuristic("parallel");
            if ((0, types_2.isNumber)(this.plot_view.base_font_size))
                axis_label_graphics.base_font_size = this.plot_view.base_font_size;
            const size = axis_label_graphics.size();
            const extent = this.dimension == 0 ? size.height : size.width;
            const standoff = this.model.axis_label_standoff;
            return extent > 0 ? standoff + extent + padding : 0;
        }
        _draw_axis_label(ctx, extents, _tick_coords) {
            if (this._axis_label_view == null || this.model.fixed_location != null)
                return;
            const [sx, sy] = (() => {
                const { bbox } = this.layout;
                switch (this.panel.side) {
                    case "above":
                        return [bbox.hcenter, bbox.bottom];
                    case "below":
                        return [bbox.hcenter, bbox.top];
                    case "left":
                        return [bbox.right, bbox.vcenter];
                    case "right":
                        return [bbox.left, bbox.vcenter];
                }
            })();
            const [nx, ny] = this.normals;
            const standoff = extents.tick + extents.tick_label + this.model.axis_label_standoff;
            const { vertical_align, align } = this.panel.get_label_text_heuristics("parallel");
            const position = {
                sx: sx + nx * standoff,
                sy: sy + ny * standoff,
                x_anchor: align,
                y_anchor: vertical_align,
            };
            const axis_label_graphics = this._axis_label_view.graphics();
            axis_label_graphics.visuals = this.visuals.axis_label_text.values();
            axis_label_graphics.angle = this.panel.get_label_angle_heuristic("parallel");
            if (this.plot_view.base_font_size)
                axis_label_graphics.base_font_size = this.plot_view.base_font_size;
            axis_label_graphics.position = position;
            axis_label_graphics.align = align;
            axis_label_graphics.paint(ctx);
        }
        _draw_ticks(ctx, coords, tin, tout, visuals) {
            if (!visuals.doit)
                return;
            const [x, y] = coords;
            const [sxs, sys] = this.coordinates.map_to_screen(x, y);
            const [nx, ny] = this.normals;
            const [xoff, yoff] = this.offsets;
            const [nxin, nyin] = [nx * (xoff - tin), ny * (yoff - tin)];
            const [nxout, nyout] = [nx * (xoff + tout), ny * (yoff + tout)];
            visuals.set_value(ctx);
            ctx.beginPath();
            for (let i = 0; i < sxs.length; i++) {
                const sx0 = Math.round(sxs[i] + nxout);
                const sy0 = Math.round(sys[i] + nyout);
                const sx1 = Math.round(sxs[i] + nxin);
                const sy1 = Math.round(sys[i] + nyin);
                ctx.moveTo(sx0, sy0);
                ctx.lineTo(sx1, sy1);
            }
            ctx.stroke();
        }
        _draw_oriented_labels(ctx, labels, coords, orient, _side, standoff, visuals) {
            if (!visuals.doit || labels.length == 0)
                return;
            const [dxs, dys] = coords;
            const [sxs, sys] = this.coordinates.map_to_screen(dxs, dys);
            const [xoff, yoff] = this.offsets;
            const [nx, ny] = this.normals;
            const nxd = nx * (xoff + standoff);
            const nyd = ny * (yoff + standoff);
            const { vertical_align, align } = this.panel.get_label_text_heuristics(orient);
            const angle = this.panel.get_label_angle_heuristic(orient);
            labels.visuals = visuals.values();
            labels.angle = angle;
            labels.base_font_size = this.plot_view.base_font_size;
            for (let i = 0; i < labels.length; i++) {
                const label = labels.items[i];
                label.position = {
                    sx: sxs[i] + nxd,
                    sy: sys[i] + nyd,
                    x_anchor: align,
                    y_anchor: vertical_align,
                };
                if (label instanceof graphics_1.TextBox)
                    label.align = align;
            }
            const n = labels.length;
            const indices = types_1.Indices.all_set(n);
            const { items } = labels;
            const bboxes = items.map((l) => l.bbox());
            const dist = (() => {
                const [range] = this.ranges;
                if (!range.is_reversed)
                    return this.dimension == 0 ? (i, j) => bboxes[j].left - bboxes[i].right
                        : (i, j) => bboxes[i].top - bboxes[j].bottom;
                else
                    return this.dimension == 0 ? (i, j) => bboxes[i].left - bboxes[j].right
                        : (i, j) => bboxes[j].top - bboxes[i].bottom;
            })();
            const { major_label_policy } = this.model;
            const selected = major_label_policy.filter(indices, bboxes, dist);
            const ids = [...selected.ones()];
            if (ids.length != 0) {
                const cbox = this.parent.canvas_view.bbox;
                const correct_x = (k) => {
                    const bbox = bboxes[k];
                    if (bbox.left < 0) {
                        const offset = -bbox.left;
                        const { position } = items[k];
                        items[k].position = Object.assign(Object.assign({}, position), { sx: position.sx + offset });
                    }
                    else if (bbox.right > cbox.width) {
                        const offset = bbox.right - cbox.width;
                        const { position } = items[k];
                        items[k].position = Object.assign(Object.assign({}, position), { sx: position.sx - offset });
                    }
                };
                const correct_y = (k) => {
                    const bbox = bboxes[k];
                    if (bbox.top < 0) {
                        const offset = -bbox.top;
                        const { position } = items[k];
                        items[k].position = Object.assign(Object.assign({}, position), { sy: position.sy + offset });
                    }
                    else if (bbox.bottom > cbox.height) {
                        const offset = bbox.bottom - cbox.height;
                        const { position } = items[k];
                        items[k].position = Object.assign(Object.assign({}, position), { sy: position.sy - offset });
                    }
                };
                const i = ids[0];
                const j = ids[ids.length - 1];
                if (this.dimension == 0) {
                    correct_x(i);
                    correct_x(j);
                }
                else {
                    correct_y(i);
                    correct_y(j);
                }
            }
            for (const i of selected) {
                const label = items[i];
                label.paint(ctx);
            }
        }
        // extents sub functions -----------------------------------------------------
        /*protected*/ _tick_extent() {
            return this.model.major_tick_out;
        }
        _tick_label_extents() {
            const coords = this.tick_coords.major;
            const labels = this.compute_labels(coords[this.dimension]);
            const orient = this.model.major_label_orientation;
            const standoff = this.model.major_label_standoff;
            const visuals = this.visuals.major_label_text;
            return [this._oriented_labels_extent(labels, orient, standoff, visuals)];
        }
        get extents() {
            const tick_labels = this._tick_label_extents();
            return {
                tick: this._tick_extent(),
                tick_labels,
                tick_label: (0, array_1.sum)(tick_labels),
                axis_label: this._axis_label_extent(),
            };
        }
        _oriented_labels_extent(labels, orient, standoff, visuals) {
            if (labels.length == 0 || !visuals.doit)
                return 0;
            const angle = this.panel.get_label_angle_heuristic(orient);
            labels.visuals = visuals.values();
            labels.angle = angle;
            labels.base_font_size = this.plot_view.base_font_size;
            const size = labels.max_size();
            const extent = this.dimension == 0 ? size.height : size.width;
            const padding = 3;
            return extent > 0 ? standoff + extent + padding : 0;
        }
        // {{{ TODO: state
        get normals() {
            return this.panel.normals;
        }
        get dimension() {
            return this.panel.dimension;
        }
        compute_labels(ticks) {
            const labels = this.model.formatter.format_graphics(ticks, this);
            const { _major_label_views } = this;
            const visited = new Set();
            for (let i = 0; i < ticks.length; i++) {
                const override = _major_label_views.get(ticks[i].toString());
                if (override != null) {
                    visited.add(override);
                    labels[i] = override.graphics();
                }
            }
            // XXX: make sure unused overrides don't prevent document idle
            for (const label_view of this._major_label_views.values()) {
                if (!visited.has(label_view)) {
                    label_view._has_finished = true;
                }
            }
            return new graphics_1.GraphicsBoxes(labels);
        }
        get offsets() {
            // If we have a fixed_position then we should respect that exactly and
            // not apply any offsets (https://github.com/bokeh/bokeh/issues/8552)
            if (this.model.fixed_location != null)
                return [0, 0];
            const { frame } = this.plot_view;
            let [xoff, yoff] = [0, 0];
            switch (this.panel.side) {
                case "below":
                    yoff = abs(this.layout.bbox.top - frame.bbox.bottom);
                    break;
                case "above":
                    yoff = abs(this.layout.bbox.bottom - frame.bbox.top);
                    break;
                case "right":
                    xoff = abs(this.layout.bbox.left - frame.bbox.right);
                    break;
                case "left":
                    xoff = abs(this.layout.bbox.right - frame.bbox.left);
                    break;
            }
            return [xoff, yoff];
        }
        get ranges() {
            const i = this.dimension;
            const j = (i + 1) % 2;
            const { ranges } = this.coordinates;
            return [ranges[i], ranges[j]];
        }
        get computed_bounds() {
            const [range] = this.ranges;
            const user_bounds = this.model.bounds;
            const range_bounds = [range.min, range.max];
            if (user_bounds == "auto")
                return [range.min, range.max];
            else {
                let start;
                let end;
                const [user_start, user_end] = user_bounds;
                const [range_start, range_end] = range_bounds;
                const { min, max } = Math;
                if (abs(user_start - user_end) > abs(range_start - range_end)) {
                    start = max(min(user_start, user_end), range_start);
                    end = min(max(user_start, user_end), range_end);
                }
                else {
                    start = min(user_start, user_end);
                    end = max(user_start, user_end);
                }
                return [start, end];
            }
        }
        get rule_coords() {
            const i = this.dimension;
            const j = (i + 1) % 2;
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            const xs = new Array(2);
            const ys = new Array(2);
            const coords = [xs, ys];
            coords[i][0] = Math.max(start, range.min);
            coords[i][1] = Math.min(end, range.max);
            if (coords[i][0] > coords[i][1])
                coords[i][0] = coords[i][1] = NaN;
            coords[j][0] = this.loc;
            coords[j][1] = this.loc;
            return coords;
        }
        get tick_coords() {
            const i = this.dimension;
            const j = (i + 1) % 2;
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            const ticks = this.model.ticker.get_ticks(start, end, range, this.loc);
            const majors = ticks.major;
            const minors = ticks.minor;
            const xs = [];
            const ys = [];
            const coords = [xs, ys];
            const minor_xs = [];
            const minor_ys = [];
            const minor_coords = [minor_xs, minor_ys];
            const [range_min, range_max] = [range.min, range.max];
            for (let ii = 0; ii < majors.length; ii++) {
                if (majors[ii] < range_min || majors[ii] > range_max)
                    continue;
                coords[i].push(majors[ii]);
                coords[j].push(this.loc);
            }
            for (let ii = 0; ii < minors.length; ii++) {
                if (minors[ii] < range_min || minors[ii] > range_max)
                    continue;
                minor_coords[i].push(minors[ii]);
                minor_coords[j].push(this.loc);
            }
            return {
                major: coords,
                minor: minor_coords,
            };
        }
        get loc() {
            const { fixed_location } = this.model;
            if (fixed_location != null) {
                if ((0, types_2.isNumber)(fixed_location))
                    return fixed_location;
                const [, cross_range] = this.ranges;
                if (cross_range instanceof factor_range_1.FactorRange)
                    return cross_range.synthetic(fixed_location);
                (0, assert_1.unreachable)();
            }
            const [, cross_range] = this.ranges;
            switch (this.panel.side) {
                case "left":
                case "below":
                    return cross_range.start;
                case "right":
                case "above":
                    return cross_range.end;
            }
        }
        // }}}
        serializable_state() {
            return Object.assign(Object.assign({}, super.serializable_state()), { bbox: this.layout.bbox.box });
        }
        remove() {
            var _b;
            (_b = this._axis_label_view) === null || _b === void 0 ? void 0 : _b.remove();
            for (const label_view of this._major_label_views.values()) {
                label_view.remove();
            }
            super.remove();
        }
        has_finished() {
            if (!super.has_finished())
                return false;
            if (this._axis_label_view != null) {
                if (!this._axis_label_view.has_finished())
                    return false;
            }
            for (const label_view of this._major_label_views.values()) {
                if (!label_view.has_finished())
                    return false;
            }
            return true;
        }
    }
    exports.AxisView = AxisView;
    AxisView.__name__ = "AxisView";
    class Axis extends guide_renderer_1.GuideRenderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Axis = Axis;
    _a = Axis;
    Axis.__name__ = "Axis";
    (() => {
        _a.prototype.default_view = AxisView;
        _a.mixins([
            ["axis_", mixins.Line],
            ["major_tick_", mixins.Line],
            ["minor_tick_", mixins.Line],
            ["major_label_", mixins.Text],
            ["axis_label_", mixins.Text],
        ]);
        _a.define(({ Any, Int, Number, String, Ref, Dict, Tuple, Or, Nullable, Auto }) => ({
            bounds: [Or(Tuple(Number, Number), Auto), "auto"],
            ticker: [Ref(ticker_1.Ticker)],
            formatter: [Ref(tick_formatter_1.TickFormatter)],
            axis_label: [Nullable(Or(String, Ref(base_text_1.BaseText))), null],
            axis_label_standoff: [Int, 5],
            major_label_standoff: [Int, 5],
            major_label_orientation: [Or(enums_1.TickLabelOrientation, Number), "horizontal"],
            major_label_overrides: [Dict(Or(String, Ref(base_text_1.BaseText))), {}],
            major_label_policy: [Ref(labeling_1.LabelingPolicy), () => new labeling_1.AllLabels()],
            major_tick_in: [Number, 2],
            major_tick_out: [Number, 6],
            minor_tick_in: [Number, 0],
            minor_tick_out: [Number, 4],
            fixed_location: [Nullable(Or(Number, Any)), null],
        }));
        _a.override({
            axis_line_color: "black",
            major_tick_line_color: "black",
            minor_tick_line_color: "black",
            major_label_text_font_size: "11px",
            major_label_text_align: "center",
            major_label_text_baseline: "alphabetic",
            axis_label_text_font_size: "13px",
            axis_label_text_font_style: "italic",
        });
    })();
},
/* models/renderers/guide_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const renderer_1 = require(41) /* ./renderer */;
    class GuideRendererView extends renderer_1.RendererView {
    }
    exports.GuideRendererView = GuideRendererView;
    GuideRendererView.__name__ = "GuideRendererView";
    class GuideRenderer extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.GuideRenderer = GuideRenderer;
    _a = GuideRenderer;
    GuideRenderer.__name__ = "GuideRenderer";
    (() => {
        _a.override({
            level: "guide",
        });
    })();
},
/* models/tickers/ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(53) /* ../../model */;
    class Ticker extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Ticker = Ticker;
    Ticker.__name__ = "Ticker";
},
/* models/formatters/tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(53) /* ../../model */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    class TickFormatter extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        format_graphics(ticks, opts) {
            return this.doFormat(ticks, opts).map((text) => new graphics_1.TextBox({ text }));
        }
        compute(tick, opts) {
            return this.doFormat([tick], opts !== null && opts !== void 0 ? opts : { loc: 0 })[0];
        }
        v_compute(tick, opts) {
            return this.doFormat(tick, opts !== null && opts !== void 0 ? opts : { loc: 0 });
        }
    }
    exports.TickFormatter = TickFormatter;
    TickFormatter.__name__ = "TickFormatter";
},
/* models/policies/labeling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a, _b;
    const model_1 = require(53) /* ../../model */;
    const object_1 = require(13) /* ../../core/util/object */;
    const string_1 = require(34) /* ../../core/util/string */;
    const types_1 = require(8) /* ../../core/util/types */;
    const types_2 = require(24) /* ../../core/types */;
    class LabelingPolicy extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.LabelingPolicy = LabelingPolicy;
    LabelingPolicy.__name__ = "LabelingPolicy";
    class AllLabels extends LabelingPolicy {
        constructor(attrs) {
            super(attrs);
        }
        filter(indices, _bboxes, _distance) {
            return indices;
        }
    }
    exports.AllLabels = AllLabels;
    AllLabels.__name__ = "AllLabels";
    class NoOverlap extends LabelingPolicy {
        constructor(attrs) {
            super(attrs);
        }
        filter(indices, _bboxes, distance) {
            const { min_distance } = this;
            let k = null;
            for (const i of indices) {
                if (k != null && distance(k, i) < min_distance)
                    indices.unset(i);
                else
                    k = i;
            }
            return indices;
        }
    }
    exports.NoOverlap = NoOverlap;
    _a = NoOverlap;
    NoOverlap.__name__ = "NoOverlap";
    (() => {
        _a.define(({ Number }) => ({
            min_distance: [Number, 5],
        }));
    })();
    class CustomLabelingPolicy extends LabelingPolicy {
        constructor(attrs) {
            super(attrs);
        }
        get names() {
            return (0, object_1.keys)(this.args);
        }
        get values() {
            return (0, object_1.values)(this.args);
        }
        get func() {
            const code = (0, string_1.use_strict)(this.code);
            return new types_2.GeneratorFunction("indices", "bboxes", "distance", ...this.names, code);
        }
        filter(indices, bboxes, distance) {
            const obj = Object.create(null);
            const generator = this.func.call(obj, indices, bboxes, distance, ...this.values);
            let result = generator.next();
            if (result.done && result.value !== undefined) {
                const { value } = result;
                if (value instanceof types_2.Indices)
                    return value;
                else if (value === undefined)
                    return indices;
                else if ((0, types_1.isIterable)(value))
                    return types_2.Indices.from_indices(indices.size, value);
                else
                    return types_2.Indices.all_unset(indices.size);
            }
            else {
                const array = [];
                do {
                    array.push(result.value);
                    result = generator.next();
                } while (!result.done);
                return types_2.Indices.from_indices(indices.size, array);
            }
        }
    }
    exports.CustomLabelingPolicy = CustomLabelingPolicy;
    _b = CustomLabelingPolicy;
    CustomLabelingPolicy.__name__ = "CustomLabelingPolicy";
    (() => {
        _b.define(({ Unknown, String, Dict }) => ({
            args: [Dict(Unknown), {}],
            code: [String, ""],
        }));
    })();
},
/* models/text/base_text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(53) /* ../../model */;
    const view_1 = require(42) /* ../../core/view */;
    class BaseTextView extends view_1.View {
    }
    exports.BaseTextView = BaseTextView;
    BaseTextView.__name__ = "BaseTextView";
    class BaseText extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.BaseText = BaseText;
    _a = BaseText;
    BaseText.__name__ = "BaseText";
    (() => {
        _a.define(({ String }) => ({
            text: [String],
        }));
    })();
},
/* models/text/utils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const math_text_1 = require(135) /* ./math_text */;
    const plain_text_1 = require(139) /* ./plain_text */;
    const delimiters = [
        { start: "$$", end: "$$", inline: false },
        { start: "\\[", end: "\\]", inline: false },
        { start: "\\(", end: "\\)", inline: true },
    ];
    function parse_delimited_string(text) {
        for (const delim of delimiters) {
            const n0 = text.indexOf(delim.start);
            const m0 = n0 + delim.start.length;
            if (n0 == 0) {
                const n1 = text.indexOf(delim.end, m0);
                const m1 = n1;
                if (n1 == text.length - delim.end.length)
                    return new math_text_1.TeX({ text: text.slice(m0, m1), inline: delim.inline });
                else
                    break;
            }
        }
        return new plain_text_1.PlainText({ text });
    }
    exports.parse_delimited_string = parse_delimited_string;
},
/* models/text/math_text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a, _b, _c;
    const types_1 = require(8) /* ../../core/util/types */;
    const image_1 = require(136) /* ../../core/util/image */;
    const color_1 = require(22) /* ../../core/util/color */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    const text_1 = require(121) /* ../../core/util/text */;
    const affine_1 = require(122) /* ../../core/util/affine */;
    const bbox_1 = require(65) /* ../../core/util/bbox */;
    const base_text_1 = require(133) /* ./base_text */;
    const providers_1 = require(137) /* ./providers */;
    /**
     * Helper class for rendering MathText into Canvas
     */
    class MathTextView extends base_text_1.BaseTextView {
        constructor() {
            super(...arguments);
            this._position = { sx: 0, sy: 0 };
            // Align does nothing, needed to maintain compatibility with TextBox,
            // to align you need to use TeX Macros.
            // http://docs.mathjax.org/en/latest/input/tex/macros/index.html?highlight=align
            this.align = "left";
            this._x_anchor = "left";
            this._y_anchor = "center";
            this._base_font_size = 13; // the same as .bk-root's font-size (13px)
            this.font_size_scale = 1.0;
            this.svg_image = null;
        }
        graphics() {
            return this;
        }
        // Same for infer_text_height
        infer_text_height() {
            return "ascent_descent";
        }
        set base_font_size(v) {
            if (v != null)
                this._base_font_size = v;
        }
        get base_font_size() {
            return this._base_font_size;
        }
        get has_image_loaded() {
            return this.svg_image != null;
        }
        _rect() {
            const { width, height } = this._size();
            const { x, y } = this._computed_position();
            const bbox = new bbox_1.BBox({ x, y, width, height });
            return bbox.rect;
        }
        set position(p) {
            this._position = p;
        }
        get position() {
            return this._position;
        }
        get text() {
            return this.model.text;
        }
        get provider() {
            return providers_1.default_provider;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            if (this.provider.status == "not_started")
                await this.provider.fetch();
            if (this.provider.status == "not_started" || this.provider.status == "loading")
                this.provider.ready.connect(() => this.load_image());
            if (this.provider.status == "loaded")
                await this.load_image();
        }
        connect_signals() {
            super.connect_signals();
            this.on_change(this.model.properties.text, () => this.load_image());
        }
        set visuals(v) {
            const color = v.color;
            const alpha = v.alpha;
            const style = v.font_style;
            let size = v.font_size;
            const face = v.font;
            const { font_size_scale, _base_font_size } = this;
            const res = (0, text_1.parse_css_font_size)(size);
            if (res != null) {
                let { value, unit } = res;
                value *= font_size_scale;
                if (unit == "em" && _base_font_size) {
                    value *= _base_font_size;
                    unit = "px";
                }
                size = `${value}${unit}`;
            }
            const font = `${style} ${size} ${face}`;
            this.font = font;
            this.color = (0, color_1.color2css)(color, alpha);
        }
        /**
         * Calculates position of element after considering
         * anchor and dimensions
         */
        _computed_position() {
            const { width, height } = this._size();
            const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
            const x = sx - (() => {
                if ((0, types_1.isNumber)(x_anchor))
                    return x_anchor * width;
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            const y = sy - (() => {
                if ((0, types_1.isNumber)(y_anchor))
                    return y_anchor * height;
                else {
                    switch (y_anchor) {
                        case "top": return 0;
                        case "center": return 0.5 * height;
                        case "bottom": return height;
                        case "baseline": return 0.5 * height;
                    }
                }
            })();
            return { x, y };
        }
        /**
         * Uses the width, height and given angle to calculate the size
        */
        size() {
            const { width, height } = this._size();
            const { angle } = this;
            if (!angle)
                return { width, height };
            else {
                const c = Math.cos(Math.abs(angle));
                const s = Math.sin(Math.abs(angle));
                return {
                    width: Math.abs(width * c + height * s),
                    height: Math.abs(width * s + height * c),
                };
            }
        }
        get_text_dimensions() {
            return {
                width: (0, graphics_1.text_width)(this.model.text, this.font),
                height: (0, text_1.font_metrics)(this.font).height,
            };
        }
        get_image_dimensions() {
            var _d, _e, _f, _g;
            const heightEx = parseFloat((_e = (_d = this.svg_element
                .getAttribute("height")) === null || _d === void 0 ? void 0 : _d.replace(/([A-z])/g, "")) !== null && _e !== void 0 ? _e : "0");
            const widthEx = parseFloat((_g = (_f = this.svg_element
                .getAttribute("width")) === null || _f === void 0 ? void 0 : _f.replace(/([A-z])/g, "")) !== null && _g !== void 0 ? _g : "0");
            return {
                width: (0, text_1.font_metrics)(this.font).x_height * widthEx,
                height: (0, text_1.font_metrics)(this.font).x_height * heightEx,
            };
        }
        _size() {
            return this.has_image_loaded ? this.get_image_dimensions() : this.get_text_dimensions();
        }
        bbox() {
            const { p0, p1, p2, p3 } = this.rect();
            const left = Math.min(p0.x, p1.x, p2.x, p3.x);
            const top = Math.min(p0.y, p1.y, p2.y, p3.y);
            const right = Math.max(p0.x, p1.x, p2.x, p3.x);
            const bottom = Math.max(p0.y, p1.y, p2.y, p3.y);
            return new bbox_1.BBox({ left, right, top, bottom });
        }
        rect() {
            const rect = this._rect();
            const { angle } = this;
            if (!angle)
                return rect;
            else {
                const { sx, sy } = this.position;
                const tr = new affine_1.AffineTransform();
                tr.translate(sx, sy);
                tr.rotate(angle);
                tr.translate(-sx, -sy);
                return tr.apply_rect(rect);
            }
        }
        paint_rect(ctx) {
            const { p0, p1, p2, p3 } = this.rect();
            ctx.save();
            ctx.strokeStyle = "red";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(p0.x), round(p0.y));
            ctx.lineTo(round(p1.x), round(p1.y));
            ctx.lineTo(round(p2.x), round(p2.y));
            ctx.lineTo(round(p3.x), round(p3.y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
        paint_bbox(ctx) {
            const { x, y, width, height } = this.bbox();
            ctx.save();
            ctx.strokeStyle = "blue";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(x), round(y));
            ctx.lineTo(round(x), round(y + height));
            ctx.lineTo(round(x + width), round(y + height));
            ctx.lineTo(round(x + width), round(y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
        async load_image() {
            if (this.provider.MathJax == null)
                return null;
            const mathjax_element = this._process_text(this.model.text);
            if (mathjax_element == null) {
                this._has_finished = true;
                return null;
            }
            const svg_element = mathjax_element.children[0];
            this.svg_element = svg_element;
            svg_element.setAttribute("font", this.font);
            svg_element.setAttribute("stroke", this.color);
            const outer_HTML = svg_element.outerHTML;
            const blob = new Blob([outer_HTML], { type: "image/svg+xml" });
            const url = URL.createObjectURL(blob);
            try {
                this.svg_image = await (0, image_1.load_image)(url);
            }
            finally {
                URL.revokeObjectURL(url);
            }
            this.parent.request_layout();
            return this.svg_image;
        }
        /**
         * Takes a Canvas' Context2d and if the image has already
         * been loaded draws the image in it otherwise draws the model's text.
        */
        paint(ctx) {
            ctx.save();
            const { sx, sy } = this.position;
            if (this.angle) {
                ctx.translate(sx, sy);
                ctx.rotate(this.angle);
                ctx.translate(-sx, -sy);
            }
            const { x, y } = this._computed_position();
            if (this.svg_image != null) {
                const { width, height } = this.get_image_dimensions();
                ctx.drawImage(this.svg_image, x, y, width, height);
            }
            else {
                ctx.fillStyle = this.color;
                ctx.font = this.font;
                ctx.textAlign = "left";
                ctx.textBaseline = "alphabetic";
                ctx.fillText(this.model.text, x, y + (0, text_1.font_metrics)(this.font).ascent);
            }
            ctx.restore();
            if (!this._has_finished && (this.provider.status == "failed" || this.has_image_loaded)) {
                this._has_finished = true;
                this.parent.notify_finished_after_paint();
            }
        }
    }
    exports.MathTextView = MathTextView;
    MathTextView.__name__ = "MathTextView";
    class MathText extends base_text_1.BaseText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MathText = MathText;
    MathText.__name__ = "MathText";
    class AsciiView extends MathTextView {
        _process_text(_text) {
            return undefined; // TODO: this.provider.MathJax?.ascii2svg(text)
        }
    }
    exports.AsciiView = AsciiView;
    AsciiView.__name__ = "AsciiView";
    class Ascii extends MathText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Ascii = Ascii;
    _a = Ascii;
    Ascii.__name__ = "Ascii";
    (() => {
        _a.prototype.default_view = AsciiView;
    })();
    class MathMLView extends MathTextView {
        _process_text(text) {
            var _d;
            return (_d = this.provider.MathJax) === null || _d === void 0 ? void 0 : _d.mathml2svg(text.trim());
        }
    }
    exports.MathMLView = MathMLView;
    MathMLView.__name__ = "MathMLView";
    class MathML extends MathText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MathML = MathML;
    _b = MathML;
    MathML.__name__ = "MathML";
    (() => {
        _b.prototype.default_view = MathMLView;
    })();
    class TeXView extends MathTextView {
        _process_text(text) {
            var _d;
            // TODO: allow plot/document level configuration of macros
            return (_d = this.provider.MathJax) === null || _d === void 0 ? void 0 : _d.tex2svg(text, undefined, this.model.macros);
        }
    }
    exports.TeXView = TeXView;
    TeXView.__name__ = "TeXView";
    class TeX extends MathText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TeX = TeX;
    _c = TeX;
    TeX.__name__ = "TeX";
    (() => {
        _c.prototype.default_view = TeXView;
        _c.define(({ Boolean, Number, String, Dict, Tuple, Or }) => ({
            macros: [Dict(Or(String, Tuple(String, Number))), {}],
            inline: [Boolean, false],
        }));
    })();
},
/* core/util/image.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const logging_1 = require(19) /* ../logging */;
    async function load_image(url, options) {
        return new ImageLoader(url, options).promise;
    }
    exports.load_image = load_image;
    class ImageLoader {
        constructor(url, config = {}) {
            this._image = new Image();
            this._finished = false;
            const { attempts = 1, timeout = 1 } = config;
            this.promise = new Promise((resolve, _reject) => {
                this._image.crossOrigin = "anonymous";
                let retries = 0;
                this._image.onerror = () => {
                    if (++retries == attempts) {
                        const message = `unable to load ${url} image after ${attempts} attempts`;
                        logging_1.logger.warn(message);
                        if (this._image.crossOrigin != null) {
                            logging_1.logger.warn(`attempting to load ${url} without a cross origin policy`);
                            this._image.crossOrigin = null;
                            retries = 0;
                        }
                        else {
                            if (config.failed != null)
                                config.failed();
                            return; // XXX reject(new Error(message))
                        }
                    }
                    setTimeout(() => this._image.src = url, timeout);
                };
                this._image.onload = () => {
                    this._finished = true;
                    if (config.loaded != null)
                        config.loaded(this._image);
                    resolve(this._image);
                };
                this._image.src = url;
            });
        }
        get finished() {
            return this._finished;
        }
        get image() {
            if (this._finished)
                return this._image;
            else
                throw new Error("not loaded yet");
        }
    }
    exports.ImageLoader = ImageLoader;
    ImageLoader.__name__ = "ImageLoader";
},
/* models/text/providers.js */ function _(require, module, exports, __esModule, __esExport) {
    var __createBinding = (this && this.__createBinding) || (Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        Object.defineProperty(o, k2, { enumerable: true, get: function () { return m[k]; } });
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    }));
    var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    });
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };
    __esModule();
    const signaling_1 = require(15) /* ../../core/signaling */;
    const modules_1 = require(138) /* ../../core/util/modules */;
    class MathJaxProvider {
        constructor() {
            this.ready = new signaling_1.Signal0(this, "ready");
            this.status = "not_started";
        }
    }
    exports.MathJaxProvider = MathJaxProvider;
    MathJaxProvider.__name__ = "MathJaxProvider";
    class NoProvider extends MathJaxProvider {
        get MathJax() {
            return null;
        }
        async fetch() {
            this.status = "failed";
        }
    }
    exports.NoProvider = NoProvider;
    NoProvider.__name__ = "NoProvider";
    class CDNProvider extends MathJaxProvider {
        get MathJax() {
            return typeof MathJax !== "undefined" ? MathJax : null;
        }
        async fetch() {
            const script = document.createElement("script");
            script.src = "https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js";
            script.onload = () => {
                this.status = "loaded";
                this.ready.emit();
            };
            script.onerror = () => {
                this.status = "failed";
            };
            this.status = "loading";
            document.head.appendChild(script);
        }
    }
    exports.CDNProvider = CDNProvider;
    CDNProvider.__name__ = "CDNProvider";
    class BundleProvider extends MathJaxProvider {
        get MathJax() {
            return this._mathjax;
        }
        async fetch() {
            this.status = "loading";
            try {
                const mathjax = await (0, modules_1.load_module)(Promise.resolve().then(() => __importStar(require(515) /* ./mathjax */)));
                this._mathjax = mathjax;
                this.status = "loaded";
                this.ready.emit();
            }
            catch (error) {
                this.status = "failed";
            }
        }
    }
    exports.BundleProvider = BundleProvider;
    BundleProvider.__name__ = "BundleProvider";
    exports.default_provider = new BundleProvider();
},
/* core/util/modules.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function is_ModuleError(error) {
        return error instanceof Error && "code" in error;
    }
    /** T is of import("some/module/path") type */
    async function load_module(module) {
        try {
            return await module;
        }
        catch (e) {
            // XXX: this exposes the underyling module system and hinders
            // interoperability with other module systems and bundlers
            if (is_ModuleError(e) && e.code === "MODULE_NOT_FOUND")
                return null;
            else
                throw e;
        }
    }
    exports.load_module = load_module;
},
/* models/text/plain_text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const base_text_1 = require(133) /* ./base_text */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    class PlainTextView extends base_text_1.BaseTextView {
        initialize() {
            super.initialize();
            this._has_finished = true;
        }
        graphics() {
            return new graphics_1.TextBox({ text: this.model.text });
        }
    }
    exports.PlainTextView = PlainTextView;
    PlainTextView.__name__ = "PlainTextView";
    class PlainText extends base_text_1.BaseText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.PlainText = PlainText;
    _a = PlainText;
    PlainText.__name__ = "PlainText";
    (() => {
        _a.prototype.default_view = PlainTextView;
    })();
},
/* models/axes/categorical_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const axis_1 = require(128) /* ./axis */;
    const categorical_ticker_1 = require(141) /* ../tickers/categorical_ticker */;
    const categorical_tick_formatter_1 = require(142) /* ../formatters/categorical_tick_formatter */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    const types_1 = require(8) /* ../../core/util/types */;
    class CategoricalAxisView extends axis_1.AxisView {
        _paint(ctx, extents, tick_coords) {
            this._draw_group_separators(ctx, extents, tick_coords);
        }
        _draw_group_separators(ctx, _extents, _tick_coords) {
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            if (!range.tops || range.tops.length < 2 || !this.visuals.separator_line.doit)
                return;
            const dim = this.dimension;
            const alt = (dim + 1) % 2;
            const coords = [[], []];
            let ind = 0;
            for (let i = 0; i < range.tops.length - 1; i++) {
                let first, last;
                for (let j = ind; j < range.factors.length; j++) {
                    if (range.factors[j][0] == range.tops[i + 1]) {
                        [first, last] = [range.factors[j - 1], range.factors[j]];
                        ind = j;
                        break;
                    }
                }
                const pt = (range.synthetic(first) + range.synthetic(last)) / 2;
                if (pt > start && pt < end) {
                    coords[dim].push(pt);
                    coords[alt].push(this.loc);
                }
            }
            const tex = this.extents.tick_label;
            this._draw_ticks(ctx, coords, -3, tex - 6, this.visuals.separator_line);
        }
        _draw_major_labels(ctx, extents, _tick_coords) {
            const info = this._get_factor_info();
            let standoff = extents.tick + this.model.major_label_standoff;
            for (let i = 0; i < info.length; i++) {
                const [labels, coords, orient, visuals] = info[i];
                this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
                standoff += extents.tick_labels[i];
            }
        }
        _tick_label_extents() {
            const info = this._get_factor_info();
            const extents = [];
            for (const [labels, , orient, visuals] of info) {
                const extent = this._oriented_labels_extent(labels, orient, this.model.major_label_standoff, visuals);
                extents.push(extent);
            }
            return extents;
        }
        _get_factor_info() {
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            const loc = this.loc;
            const ticks = this.model.ticker.get_ticks(start, end, range, loc);
            const coords = this.tick_coords;
            const info = [];
            const map = (labels) => {
                return new graphics_1.GraphicsBoxes(labels.map((label) => (0, types_1.isString)(label) ? new graphics_1.TextBox({ text: label }) : label));
            };
            const format = (ticks) => {
                return map(this.model.formatter.doFormat(ticks, this));
            };
            if (range.levels == 1) {
                const major = ticks.major;
                const labels = format(major);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
            }
            else if (range.levels == 2) {
                const major = ticks.major.map((x) => x[1]);
                const labels = format(major);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
                info.push([map(ticks.tops), coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
            }
            else if (range.levels == 3) {
                const major = ticks.major.map((x) => x[2]);
                const labels = format(major);
                const mid_labels = ticks.mids.map((x) => x[1]);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
                info.push([map(mid_labels), coords.mids, this.model.subgroup_label_orientation, this.visuals.subgroup_text]);
                info.push([map(ticks.tops), coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
            }
            return info;
        }
        get tick_coords() {
            const i = this.dimension;
            const j = (i + 1) % 2;
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            const ticks = this.model.ticker.get_ticks(start, end, range, this.loc);
            const coords = {
                major: [[], []],
                mids: [[], []],
                tops: [[], []],
                minor: [[], []],
            };
            coords.major[i] = ticks.major;
            coords.major[j] = ticks.major.map(() => this.loc);
            if (range.levels == 3) {
                coords.mids[i] = ticks.mids;
                coords.mids[j] = ticks.mids.map(() => this.loc);
            }
            if (range.levels > 1) {
                coords.tops[i] = ticks.tops;
                coords.tops[j] = ticks.tops.map(() => this.loc);
            }
            return coords;
        }
    }
    exports.CategoricalAxisView = CategoricalAxisView;
    CategoricalAxisView.__name__ = "CategoricalAxisView";
    class CategoricalAxis extends axis_1.Axis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.CategoricalAxis = CategoricalAxis;
    _a = CategoricalAxis;
    CategoricalAxis.__name__ = "CategoricalAxis";
    (() => {
        _a.prototype.default_view = CategoricalAxisView;
        _a.mixins([
            ["separator_", mixins.Line],
            ["group_", mixins.Text],
            ["subgroup_", mixins.Text],
        ]);
        _a.define(({ Number, Or }) => ({
            group_label_orientation: [Or(enums_1.TickLabelOrientation, Number), "parallel"],
            subgroup_label_orientation: [Or(enums_1.TickLabelOrientation, Number), "parallel"],
        }));
        _a.override({
            ticker: () => new categorical_ticker_1.CategoricalTicker(),
            formatter: () => new categorical_tick_formatter_1.CategoricalTickFormatter(),
            separator_line_color: "lightgrey",
            separator_line_width: 2,
            group_text_font_style: "bold",
            group_text_font_size: "11px",
            group_text_color: "grey",
            subgroup_text_font_style: "bold",
            subgroup_text_font_size: "11px",
        });
    })();
},
/* models/tickers/categorical_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const ticker_1 = require(130) /* ./ticker */;
    class CategoricalTicker extends ticker_1.Ticker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks(start, end, range, _cross_loc) {
            var _a, _b;
            const majors = this._collect(range.factors, range, start, end);
            const tops = this._collect((_a = range.tops) !== null && _a !== void 0 ? _a : [], range, start, end);
            const mids = this._collect((_b = range.mids) !== null && _b !== void 0 ? _b : [], range, start, end);
            return {
                major: majors,
                minor: [],
                tops,
                mids,
            };
        }
        _collect(factors, range, start, end) {
            const result = [];
            for (const factor of factors) {
                const coord = range.synthetic(factor);
                if (coord > start && coord < end)
                    result.push(factor);
            }
            return result;
        }
    }
    exports.CategoricalTicker = CategoricalTicker;
    CategoricalTicker.__name__ = "CategoricalTicker";
},
/* models/formatters/categorical_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tick_formatter_1 = require(131) /* ./tick_formatter */;
    const array_1 = require(9) /* ../../core/util/array */;
    class CategoricalTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        doFormat(ticks, _opts) {
            return (0, array_1.copy)(ticks);
        }
    }
    exports.CategoricalTickFormatter = CategoricalTickFormatter;
    CategoricalTickFormatter.__name__ = "CategoricalTickFormatter";
},
/* models/axes/continuous_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const axis_1 = require(128) /* ./axis */;
    class ContinuousAxisView extends axis_1.AxisView {
    }
    exports.ContinuousAxisView = ContinuousAxisView;
    ContinuousAxisView.__name__ = "ContinuousAxisView";
    class ContinuousAxis extends axis_1.Axis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ContinuousAxis = ContinuousAxis;
    ContinuousAxis.__name__ = "ContinuousAxis";
},
/* models/axes/datetime_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const linear_axis_1 = require(145) /* ./linear_axis */;
    const datetime_tick_formatter_1 = require(150) /* ../formatters/datetime_tick_formatter */;
    const datetime_ticker_1 = require(155) /* ../tickers/datetime_ticker */;
    class DatetimeAxisView extends linear_axis_1.LinearAxisView {
    }
    exports.DatetimeAxisView = DatetimeAxisView;
    DatetimeAxisView.__name__ = "DatetimeAxisView";
    class DatetimeAxis extends linear_axis_1.LinearAxis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DatetimeAxis = DatetimeAxis;
    _a = DatetimeAxis;
    DatetimeAxis.__name__ = "DatetimeAxis";
    (() => {
        _a.prototype.default_view = DatetimeAxisView;
        _a.override({
            ticker: () => new datetime_ticker_1.DatetimeTicker(),
            formatter: () => new datetime_tick_formatter_1.DatetimeTickFormatter(),
        });
    })();
},
/* models/axes/linear_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_axis_1 = require(143) /* ./continuous_axis */;
    const basic_tick_formatter_1 = require(146) /* ../formatters/basic_tick_formatter */;
    const basic_ticker_1 = require(147) /* ../tickers/basic_ticker */;
    class LinearAxisView extends continuous_axis_1.ContinuousAxisView {
    }
    exports.LinearAxisView = LinearAxisView;
    LinearAxisView.__name__ = "LinearAxisView";
    class LinearAxis extends continuous_axis_1.ContinuousAxis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.LinearAxis = LinearAxis;
    _a = LinearAxis;
    LinearAxis.__name__ = "LinearAxis";
    (() => {
        _a.prototype.default_view = LinearAxisView;
        _a.override({
            ticker: () => new basic_ticker_1.BasicTicker(),
            formatter: () => new basic_tick_formatter_1.BasicTickFormatter(),
        });
    })();
},
/* models/formatters/basic_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const tick_formatter_1 = require(131) /* ./tick_formatter */;
    const string_1 = require(34) /* ../../core/util/string */;
    function unicode_replace(input) {
        let output = "";
        for (const c of input) {
            if (c == "-")
                output += "\u2212";
            else
                output += c;
        }
        return output;
    }
    exports.unicode_replace = unicode_replace;
    class BasicTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
            this.last_precision = 3;
        }
        get scientific_limit_low() {
            return 10.0 ** this.power_limit_low;
        }
        get scientific_limit_high() {
            return 10.0 ** this.power_limit_high;
        }
        _need_sci(ticks) {
            if (!this.use_scientific)
                return false;
            const { scientific_limit_high } = this;
            const { scientific_limit_low } = this;
            const zeroish = ticks.length < 2 ? 0 : Math.abs(ticks[1] - ticks[0]) / 10000;
            for (const tick of ticks) {
                const tick_abs = Math.abs(tick);
                if (tick_abs <= zeroish)
                    continue;
                if (tick_abs >= scientific_limit_high || tick_abs <= scientific_limit_low) {
                    return true;
                }
            }
            return false;
        }
        _format_with_precision(ticks, need_sci, precision) {
            if (need_sci) {
                return ticks.map((tick) => unicode_replace(tick.toExponential(precision)));
            }
            else {
                return ticks.map((tick) => unicode_replace((0, string_1.to_fixed)(tick, precision)));
            }
        }
        _auto_precision(ticks, need_sci) {
            const labels = new Array(ticks.length);
            const asc = this.last_precision <= 15;
            outer: for (let x = this.last_precision; asc ? x <= 15 : x >= 1; asc ? x++ : x--) {
                if (need_sci) {
                    labels[0] = ticks[0].toExponential(x);
                    for (let i = 1; i < ticks.length; i++) {
                        if (labels[i] == labels[i - 1]) {
                            continue outer;
                        }
                    }
                    this.last_precision = x;
                    break;
                }
                else {
                    labels[0] = (0, string_1.to_fixed)(ticks[0], x);
                    for (let i = 1; i < ticks.length; i++) {
                        labels[i] = (0, string_1.to_fixed)(ticks[i], x);
                        if (labels[i] == labels[i - 1]) {
                            continue outer;
                        }
                    }
                    this.last_precision = x;
                    break;
                }
            }
            return this.last_precision;
        }
        doFormat(ticks, _opts) {
            if (ticks.length == 0)
                return [];
            const need_sci = this._need_sci(ticks);
            const precision = this.precision == "auto" ? this._auto_precision(ticks, need_sci) : this.precision;
            return this._format_with_precision(ticks, need_sci, precision);
        }
    }
    exports.BasicTickFormatter = BasicTickFormatter;
    _a = BasicTickFormatter;
    BasicTickFormatter.__name__ = "BasicTickFormatter";
    (() => {
        _a.define(({ Boolean, Int, Auto, Or }) => ({
            precision: [Or(Int, Auto), "auto"],
            use_scientific: [Boolean, true],
            power_limit_high: [Int, 5],
            power_limit_low: [Int, -3],
        }));
    })();
},
/* models/tickers/basic_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const adaptive_ticker_1 = require(148) /* ./adaptive_ticker */;
    class BasicTicker extends adaptive_ticker_1.AdaptiveTicker {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.BasicTicker = BasicTicker;
    BasicTicker.__name__ = "BasicTicker";
},
/* models/tickers/adaptive_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_ticker_1 = require(149) /* ./continuous_ticker */;
    const array_1 = require(9) /* ../../core/util/array */;
    const math_1 = require(10) /* ../../core/util/math */;
    class AdaptiveTicker extends continuous_ticker_1.ContinuousTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_min_interval() {
            return this.min_interval;
        }
        get_max_interval() {
            var _b;
            return (_b = this.max_interval) !== null && _b !== void 0 ? _b : Infinity;
        }
        // These arguments control the range of possible intervals.  The interval I
        // returned by get_interval() will be the one that most closely matches the
        // desired number of ticks, subject to the following constraints:
        // I = (M * B^N), where
        // M is a member of mantissas,
        // B is base,
        // and N is an integer;
        // and min_interval <= I <= max_interval.
        initialize() {
            super.initialize();
            const prefix_mantissa = (0, array_1.nth)(this.mantissas, -1) / this.base;
            const suffix_mantissa = (0, array_1.nth)(this.mantissas, 0) * this.base;
            this.extended_mantissas = [prefix_mantissa, ...this.mantissas, suffix_mantissa];
            this.base_factor = this.get_min_interval() === 0.0 ? 1.0 : this.get_min_interval();
        }
        get_interval(data_low, data_high, desired_n_ticks) {
            const data_range = data_high - data_low;
            const ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
            const interval_exponent = Math.floor((0, math_1.log)(ideal_interval / this.base_factor, this.base));
            const ideal_magnitude = this.base ** interval_exponent * this.base_factor;
            // An untested optimization.
            //   const ideal_mantissa = ideal_interval / ideal_magnitude
            //   index = sorted_index(this.extended_mantissas, ideal_mantissa)
            //   candidate_mantissas = this.extended_mantissas[index..index + 1]
            const candidate_mantissas = this.extended_mantissas;
            const errors = candidate_mantissas.map((mantissa) => {
                return Math.abs(desired_n_ticks - (data_range / (mantissa * ideal_magnitude)));
            });
            const best_mantissa = candidate_mantissas[(0, array_1.argmin)(errors)];
            const interval = best_mantissa * ideal_magnitude;
            return (0, math_1.clamp)(interval, this.get_min_interval(), this.get_max_interval());
        }
    }
    exports.AdaptiveTicker = AdaptiveTicker;
    _a = AdaptiveTicker;
    AdaptiveTicker.__name__ = "AdaptiveTicker";
    (() => {
        _a.define(({ Number, Array, Nullable }) => ({
            base: [Number, 10.0],
            mantissas: [Array(Number), [1, 2, 5]],
            min_interval: [Number, 0.0],
            max_interval: [Nullable(Number), null],
        }));
    })();
},
/* models/tickers/continuous_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const ticker_1 = require(130) /* ./ticker */;
    const array_1 = require(9) /* ../../core/util/array */;
    class ContinuousTicker extends ticker_1.Ticker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks(data_low, data_high, _range, cross_loc) {
            return this.get_ticks_no_defaults(data_low, data_high, cross_loc, this.desired_num_ticks);
        }
        // The version of get_ticks() that does the work (and the version that
        // should be overridden in subclasses).
        get_ticks_no_defaults(data_low, data_high, _cross_loc, desired_n_ticks) {
            const interval = this.get_interval(data_low, data_high, desired_n_ticks);
            const start_factor = Math.floor(data_low / interval);
            const end_factor = Math.ceil(data_high / interval);
            let factors;
            if (!isFinite(start_factor) || !isFinite(end_factor))
                factors = [];
            else
                factors = (0, array_1.range)(start_factor, end_factor + 1);
            const ticks = factors
                .map((factor) => factor * interval)
                .filter((tick) => data_low <= tick && tick <= data_high);
            const num_minor_ticks = this.num_minor_ticks;
            const minor_ticks = [];
            if (num_minor_ticks > 0 && ticks.length > 0) {
                const minor_interval = interval / num_minor_ticks;
                const minor_offsets = (0, array_1.range)(0, num_minor_ticks).map((i) => i * minor_interval);
                for (const x of minor_offsets.slice(1)) {
                    const mt = ticks[0] - x;
                    if (data_low <= mt && mt <= data_high) {
                        minor_ticks.push(mt);
                    }
                }
                for (const tick of ticks) {
                    for (const x of minor_offsets) {
                        const mt = tick + x;
                        if (data_low <= mt && mt <= data_high) {
                            minor_ticks.push(mt);
                        }
                    }
                }
            }
            return {
                major: ticks,
                minor: minor_ticks,
            };
        }
        // Returns the interval size that would produce exactly the number of
        // desired ticks.  (In general we won't use exactly this interval, because
        // we want the ticks to be round numbers.)
        get_ideal_interval(data_low, data_high, desired_n_ticks) {
            const data_range = data_high - data_low;
            return data_range / desired_n_ticks;
        }
    }
    exports.ContinuousTicker = ContinuousTicker;
    _a = ContinuousTicker;
    ContinuousTicker.__name__ = "ContinuousTicker";
    (() => {
        _a.define(({ Int }) => ({
            num_minor_ticks: [Int, 5],
            desired_num_ticks: [Int, 6],
        }));
    })();
},
/* models/formatters/datetime_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const timezone_1 = (0, tslib_1.__importDefault)(require(151) /* timezone */);
    const tick_formatter_1 = require(131) /* ./tick_formatter */;
    const logging_1 = require(19) /* ../../core/logging */;
    const templating_1 = require(152) /* ../../core/util/templating */;
    const array_1 = require(9) /* ../../core/util/array */;
    const types_1 = require(8) /* ../../core/util/types */;
    function _us(t) {
        // From double-precision unix (millisecond) timestamp get
        // microsecond since last second. Precision seems to run
        // out around the hundreds of nanoseconds scale, so rounding
        // to the nearest microsecond should round to a nice
        // microsecond / millisecond tick.
        return Math.round(((t / 1000) % 1) * 1000000);
    }
    function _array(t) {
        return (0, timezone_1.default)(t, "%Y %m %d %H %M %S").split(/\s+/).map(e => parseInt(e, 10));
    }
    function _strftime(t, format) {
        if ((0, types_1.isFunction)(format)) {
            return format(t);
        }
        else {
            // Python's datetime library augments the microsecond directive %f, which is not
            // supported by the javascript library timezone: http://bigeasy.github.io/timezone/.
            // Use a regular expression to replace %f directive with microseconds.
            // TODO: what should we do for negative microsecond strings?
            const microsecond_replacement_string = (0, templating_1.sprintf)("$1%06d", _us(t));
            format = format.replace(/((^|[^%])(%%)*)%f/, microsecond_replacement_string);
            if (format.indexOf("%") == -1) {
                // timezone seems to ignore any strings without any formatting directives,
                // and just return the time argument back instead of the string argument.
                // But we want the string argument, in case a user supplies a format string
                // which doesn't contain a formatting directive or is only using %f.
                return format;
            }
            return (0, timezone_1.default)(t, format);
        }
    }
    // Labels of time units, from finest to coarsest.
    const format_order = [
        "microseconds", "milliseconds", "seconds", "minsec", "minutes", "hourmin", "hours", "days", "months", "years",
    ];
    class DatetimeTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
            // Whether or not to strip the leading zeros on tick labels.
            this.strip_leading_zeros = true;
        }
        initialize() {
            super.initialize();
            // TODO (bev) trigger update on format change
            this._update_width_formats();
        }
        _update_width_formats() {
            const now = +(0, timezone_1.default)(new Date());
            const _widths = function (fmt_strings) {
                const sizes = fmt_strings.map((fmt_string) => _strftime(now, fmt_string).length);
                const sorted = (0, array_1.sort_by)((0, array_1.zip)(sizes, fmt_strings), ([size]) => size);
                return (0, array_1.unzip)(sorted);
            };
            this._width_formats = {
                microseconds: _widths(this.microseconds),
                milliseconds: _widths(this.milliseconds),
                seconds: _widths(this.seconds),
                minsec: _widths(this.minsec),
                minutes: _widths(this.minutes),
                hourmin: _widths(this.hourmin),
                hours: _widths(this.hours),
                days: _widths(this.days),
                months: _widths(this.months),
                years: _widths(this.years),
            };
        }
        // FIXME There is some unfortunate flicker when panning/zooming near the
        // span boundaries.
        // FIXME Rounding is weird at the 20-us scale and below.
        _get_resolution_str(resolution_secs, span_secs) {
            // Our resolution boundaries should not be round numbers, because we want
            // them to fall between the possible tick intervals (which *are* round
            // numbers, as we've worked hard to ensure).  Consequently, we adjust the
            // resolution upwards a small amount (less than any possible step in
            // scales) to make the effective boundaries slightly lower.
            const adjusted_secs = resolution_secs * 1.1;
            switch (false) {
                case !(adjusted_secs < 1e-3): return "microseconds";
                case !(adjusted_secs < 1.0): return "milliseconds";
                case !(adjusted_secs < 60): return span_secs >= 60 ? "minsec" : "seconds";
                case !(adjusted_secs < 3600): return span_secs >= 3600 ? "hourmin" : "minutes";
                case !(adjusted_secs < (24 * 3600)): return "hours";
                case !(adjusted_secs < (31 * 24 * 3600)): return "days";
                case !(adjusted_secs < (365 * 24 * 3600)): return "months";
                default: return "years";
            }
        }
        doFormat(ticks, _opts) {
            // In order to pick the right set of labels, we need to determine
            // the resolution of the ticks.  We can do this using a ticker if
            // it's provided, or by computing the resolution from the actual
            // ticks we've been given.
            if (ticks.length == 0)
                return [];
            const span = Math.abs(ticks[ticks.length - 1] - ticks[0]) / 1000.0;
            const r = span / (ticks.length - 1);
            const resol = this._get_resolution_str(r, span);
            const [, [format]] = this._width_formats[resol];
            // Apply the format to the tick values
            const labels = [];
            const resol_ndx = format_order.indexOf(resol);
            // This dictionary maps the name of a time resolution (in @format_order)
            // to its index in a time.localtime() timetuple.  The default is to map
            // everything to index 0, which is year.  This is not ideal; it might cause
            // a problem with the tick at midnight, january 1st, 0 a.d. being incorrectly
            // promoted at certain tick resolutions.
            const time_tuple_ndx_for_resol = {};
            for (const fmt of format_order) {
                time_tuple_ndx_for_resol[fmt] = 0;
            }
            time_tuple_ndx_for_resol.seconds = 5;
            time_tuple_ndx_for_resol.minsec = 4;
            time_tuple_ndx_for_resol.minutes = 4;
            time_tuple_ndx_for_resol.hourmin = 3;
            time_tuple_ndx_for_resol.hours = 3;
            // As we format each tick, check to see if we are at a boundary of the
            // next higher unit of time.  If so, replace the current format with one
            // from that resolution.  This is not the best heuristic in the world,
            // but it works!  There is some trickiness here due to having to deal
            // with hybrid formats in a reasonable manner.
            for (const t of ticks) {
                let s, tm;
                try {
                    tm = _array(t);
                    s = _strftime(t, format);
                }
                catch (error) {
                    logging_1.logger.warn(`unable to format tick for timestamp value ${t}`);
                    logging_1.logger.warn(` - ${error}`);
                    labels.push("ERR");
                    continue;
                }
                let hybrid_handled = false;
                let next_ndx = resol_ndx;
                // The way to check that we are at the boundary of the next unit of
                // time is by checking that we have 0 units of the resolution, i.e.
                // we are at zero minutes, so display hours, or we are at zero seconds,
                // so display minutes (and if that is zero as well, then display hours).
                while (tm[time_tuple_ndx_for_resol[format_order[next_ndx]]] == 0) {
                    let next_format;
                    next_ndx += 1;
                    if (next_ndx == format_order.length)
                        break;
                    if ((resol == "minsec" || resol == "hourmin") && !hybrid_handled) {
                        if ((resol == "minsec" && tm[4] == 0 && tm[5] != 0) || (resol == "hourmin" && tm[3] == 0 && tm[4] != 0)) {
                            next_format = this._width_formats[format_order[resol_ndx - 1]][1][0];
                            s = _strftime(t, next_format);
                            break;
                        }
                        else {
                            hybrid_handled = true;
                        }
                    }
                    next_format = this._width_formats[format_order[next_ndx]][1][0];
                    s = _strftime(t, next_format);
                }
                // TODO: should expose this in api. %H, %d, etc use leading zeros and
                // users might prefer to see them lined up correctly.
                if (this.strip_leading_zeros) {
                    let ss = s.replace(/^0+/g, "");
                    if (ss != s && isNaN(parseInt(ss))) {
                        // If the string can now be parsed as starting with an integer, then
                        // leave all zeros stripped, otherwise start with a zero. Hence:
                        // A label such as '000ms' should leave one zero.
                        // A label such as '001ms' or '0-1ms' should not leave a leading zero.
                        ss = `0${ss}`;
                    }
                    labels.push(ss);
                }
                else
                    labels.push(s);
            }
            return labels;
        }
    }
    exports.DatetimeTickFormatter = DatetimeTickFormatter;
    _a = DatetimeTickFormatter;
    DatetimeTickFormatter.__name__ = "DatetimeTickFormatter";
    (() => {
        _a.define(({ String, Array }) => ({
            microseconds: [Array(String), ["%fus"]],
            milliseconds: [Array(String), ["%3Nms", "%S.%3Ns"]],
            seconds: [Array(String), ["%Ss"]],
            minsec: [Array(String), [":%M:%S"]],
            minutes: [Array(String), [":%M", "%Mm"]],
            hourmin: [Array(String), ["%H:%M"]],
            hours: [Array(String), ["%Hh", "%H:%M"]],
            days: [Array(String), ["%m/%d", "%a%d"]],
            months: [Array(String), ["%m/%Y", "%b %Y"]],
            years: [Array(String), ["%Y"]],
        }));
    })();
},
/* timezone/index.js */ function _(require, module, exports, __esModule, __esExport) {
    !function (definition) {
        if (typeof module == "object" && module.exports)
            module.exports = definition();
        else if (typeof define == "function")
            define(definition);
        else
            this.tz = definition();
    }(function () {
        /*
          function die () {
            console.log.apply(console, __slice.call(arguments, 0));
            return process.exit(1);
          }
        
          function say () { return console.log.apply(console, __slice.call(arguments, 0)) }
        */
        function actualize(entry, rule, year) {
            var actualized, date = rule.day[1];
            do {
                actualized = new Date(Date.UTC(year, rule.month, Math.abs(date++)));
            } while (rule.day[0] < 7 && actualized.getUTCDay() != rule.day[0]);
            actualized = {
                clock: rule.clock,
                sort: actualized.getTime(),
                rule: rule,
                save: rule.save * 6e4,
                offset: entry.offset
            };
            actualized[actualized.clock] = actualized.sort + rule.time * 6e4;
            if (actualized.posix) {
                actualized.wallclock = actualized[actualized.clock] + (entry.offset + rule.saved);
            }
            else {
                actualized.posix = actualized[actualized.clock] - (entry.offset + rule.saved);
            }
            return actualized;
        }
        function find(request, clock, time) {
            var i, I, entry, found, zone = request[request.zone], actualized = [], abbrev, rules, j, year = new Date(time).getUTCFullYear(), off = 1;
            for (i = 1, I = zone.length; i < I; i++)
                if (zone[i][clock] <= time)
                    break;
            entry = zone[i];
            if (entry.rules) {
                rules = request[entry.rules];
                for (j = year + 1; j >= year - off; --j)
                    for (i = 0, I = rules.length; i < I; i++)
                        if (rules[i].from <= j && j <= rules[i].to)
                            actualized.push(actualize(entry, rules[i], j));
                        else if (rules[i].to < j && off == 1)
                            off = j - rules[i].to;
                actualized.sort(function (a, b) { return a.sort - b.sort; });
                for (i = 0, I = actualized.length; i < I; i++) {
                    if (time >= actualized[i][clock] && actualized[i][actualized[i].clock] > entry[actualized[i].clock])
                        found = actualized[i];
                }
            }
            if (found) {
                if (abbrev = /^(.*)\/(.*)$/.exec(entry.format)) {
                    found.abbrev = abbrev[found.save ? 2 : 1];
                }
                else {
                    found.abbrev = entry.format.replace(/%s/, found.rule.letter);
                }
            }
            return found || entry;
        }
        function convertToWallclock(request, posix) {
            if (request.zone == "UTC")
                return posix;
            request.entry = find(request, "posix", posix);
            return posix + request.entry.offset + request.entry.save;
        }
        function convertToPOSIX(request, wallclock) {
            if (request.zone == "UTC")
                return wallclock;
            var entry, diff;
            request.entry = entry = find(request, "wallclock", wallclock);
            diff = wallclock - entry.wallclock;
            return 0 < diff && diff < entry.save ? null : wallclock - entry.offset - entry.save;
        }
        function adjust(request, posix, match) {
            var increment = +(match[1] + 1) // conversion necessary for week day addition
            , offset = match[2] * increment, index = UNITS.indexOf(match[3].toLowerCase()), date;
            if (index > 9) {
                posix += offset * TIME[index - 10];
            }
            else {
                date = new Date(convertToWallclock(request, posix));
                if (index < 7) {
                    while (offset) {
                        date.setUTCDate(date.getUTCDate() + increment);
                        if (date.getUTCDay() == index)
                            offset -= increment;
                    }
                }
                else if (index == 7) {
                    date.setUTCFullYear(date.getUTCFullYear() + offset);
                }
                else if (index == 8) {
                    date.setUTCMonth(date.getUTCMonth() + offset);
                }
                else {
                    date.setUTCDate(date.getUTCDate() + offset);
                }
                if ((posix = convertToPOSIX(request, date.getTime())) == null) {
                    posix = convertToPOSIX(request, date.getTime() + 864e5 * increment) - 864e5 * increment;
                }
            }
            return posix;
        }
        function convert(vargs) {
            if (!vargs.length)
                return "1.0.23";
            var request = Object.create(this), adjustments = [], i, I, $, argument, date;
            for (i = 0; i < vargs.length; i++) { // leave the for loop alone, it works.
                argument = vargs[i];
                // https://twitter.com/bigeasy/status/215112186572439552
                if (Array.isArray(argument)) {
                    if (!i && !isNaN(argument[1])) {
                        date = argument;
                    }
                    else {
                        argument.splice.apply(vargs, [i--, 1].concat(argument));
                    }
                }
                else if (isNaN(argument)) {
                    $ = typeof argument;
                    if ($ == "string") {
                        if (~argument.indexOf("%")) {
                            request.format = argument;
                        }
                        else if (!i && argument == "*") {
                            date = argument;
                        }
                        else if (!i && ($ = /^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(argument))) {
                            date = [];
                            date.push.apply(date, $.slice(1, 8));
                            if ($[9]) {
                                date.push($[10] + 1);
                                date.push.apply(date, $[11].split(/:/));
                            }
                            else if ($[8]) {
                                date.push(1);
                            }
                        }
                        else if (/^\w{2,3}_\w{2}$/.test(argument)) {
                            request.locale = argument;
                        }
                        else if ($ = UNIT_RE.exec(argument)) {
                            adjustments.push($);
                        }
                        else {
                            request.zone = argument;
                        }
                    }
                    else if ($ == "function") {
                        if ($ = argument.call(request))
                            return $;
                    }
                    else if (/^\w{2,3}_\w{2}$/.test(argument.name)) {
                        request[argument.name] = argument;
                    }
                    else if (argument.zones) {
                        for ($ in argument.zones)
                            request[$] = argument.zones[$];
                        for ($ in argument.rules)
                            request[$] = argument.rules[$];
                    }
                }
                else if (!i) {
                    date = argument;
                }
            }
            if (!request[request.locale])
                delete request.locale;
            if (!request[request.zone])
                delete request.zone;
            if (date != null) {
                if (date == "*") {
                    date = request.clock();
                }
                else if (Array.isArray(date)) {
                    $ = [];
                    I = !date[7];
                    for (i = 0; i < 11; i++)
                        $[i] = +(date[i] || 0); // conversion necessary for decrement
                    --$[1]; // Grr..
                    date = Date.UTC.apply(Date.UTC, $) + -$[7] * ($[8] * 36e5 + $[9] * 6e4 + $[10] * 1e3);
                }
                else {
                    date = Math.floor(date);
                }
                if (!isNaN(date)) {
                    if (I)
                        date = convertToPOSIX(request, date);
                    if (date == null)
                        return date;
                    for (i = 0, I = adjustments.length; i < I; i++) {
                        date = adjust(request, date, adjustments[i]);
                    }
                    if (!request.format)
                        return date;
                    $ = new Date(convertToWallclock(request, date));
                    return request.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g, function (value, flag, colons, padding, specifier) {
                        var f, fill = "0", pad;
                        if (f = request[specifier]) {
                            value = String(f.call(request, $, date, flag, colons.length));
                            if ((flag || f.style) == "_")
                                fill = " ";
                            pad = flag == "-" ? 0 : f.pad || 0;
                            while (value.length < pad)
                                value = fill + value;
                            pad = flag == "-" ? 0 : padding || f.pad;
                            while (value.length < pad)
                                value = fill + value;
                            if (specifier == "N" && pad < value.length)
                                value = value.slice(0, pad);
                            if (flag == "^")
                                value = value.toUpperCase();
                        }
                        return value;
                    });
                }
            }
            return function () { return request.convert(arguments); };
        }
        var context = { clock: function () { return +(new Date()); },
            zone: "UTC",
            entry: { abbrev: "UTC", offset: 0, save: 0 },
            UTC: 1,
            z: function (date, posix, flag, delimiters) {
                var offset = this.entry.offset + this.entry.save, seconds = Math.abs(offset / 1000), parts = [], part = 3600, i, z;
                for (i = 0; i < 3; i++) {
                    parts.push(("0" + Math.floor(seconds / part)).slice(-2));
                    seconds %= part;
                    part /= 60;
                }
                if (flag == "^" && !offset)
                    return "Z";
                if (flag == "^")
                    delimiters = 3;
                if (delimiters == 3) {
                    z = parts.join(":");
                    z = z.replace(/:00$/, "");
                    if (flag != "^")
                        z = z.replace(/:00$/, "");
                }
                else if (delimiters) {
                    z = parts.slice(0, delimiters + 1).join(":");
                    if (flag == "^")
                        z = z.replace(/:00$/, "");
                }
                else {
                    z = parts.slice(0, 2).join("");
                }
                z = (offset < 0 ? "-" : "+") + z;
                z = z.replace(/([-+])(0)/, { "_": " $1", "-": "$1" }[flag] || "$1$2");
                return z;
            },
            "%": function (date) { return "%"; },
            n: function (date) { return "\n"; },
            t: function (date) { return "\t"; },
            U: function (date) { return weekOfYear(date, 0); },
            W: function (date) { return weekOfYear(date, 1); },
            V: function (date) { return isoWeek(date)[0]; },
            G: function (date) { return isoWeek(date)[1]; },
            g: function (date) { return isoWeek(date)[1] % 100; },
            j: function (date) { return Math.floor((date.getTime() - Date.UTC(date.getUTCFullYear(), 0)) / 864e5) + 1; },
            s: function (date) { return Math.floor(date.getTime() / 1000); },
            C: function (date) { return Math.floor(date.getUTCFullYear() / 100); },
            N: function (date) { return date.getTime() % 1000 * 1000000; },
            m: function (date) { return date.getUTCMonth() + 1; },
            Y: function (date) { return date.getUTCFullYear(); },
            y: function (date) { return date.getUTCFullYear() % 100; },
            H: function (date) { return date.getUTCHours(); },
            M: function (date) { return date.getUTCMinutes(); },
            S: function (date) { return date.getUTCSeconds(); },
            e: function (date) { return date.getUTCDate(); },
            d: function (date) { return date.getUTCDate(); },
            u: function (date) { return date.getUTCDay() || 7; },
            w: function (date) { return date.getUTCDay(); },
            l: function (date) { return date.getUTCHours() % 12 || 12; },
            I: function (date) { return date.getUTCHours() % 12 || 12; },
            k: function (date) { return date.getUTCHours(); },
            Z: function (date) { return this.entry.abbrev; },
            a: function (date) { return this[this.locale].day.abbrev[date.getUTCDay()]; },
            A: function (date) { return this[this.locale].day.full[date.getUTCDay()]; },
            h: function (date) { return this[this.locale].month.abbrev[date.getUTCMonth()]; },
            b: function (date) { return this[this.locale].month.abbrev[date.getUTCMonth()]; },
            B: function (date) { return this[this.locale].month.full[date.getUTCMonth()]; },
            P: function (date) { return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)].toLowerCase(); },
            p: function (date) { return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)]; },
            R: function (date, posix) { return this.convert([posix, "%H:%M"]); },
            T: function (date, posix) { return this.convert([posix, "%H:%M:%S"]); },
            D: function (date, posix) { return this.convert([posix, "%m/%d/%y"]); },
            F: function (date, posix) { return this.convert([posix, "%Y-%m-%d"]); },
            x: function (date, posix) { return this.convert([posix, this[this.locale].date]); },
            r: function (date, posix) { return this.convert([posix, this[this.locale].time12 || '%I:%M:%S']); },
            X: function (date, posix) { return this.convert([posix, this[this.locale].time24]); },
            c: function (date, posix) { return this.convert([posix, this[this.locale].dateTime]); },
            convert: convert,
            locale: "en_US",
            en_US: {
                date: "%m/%d/%Y",
                time24: "%I:%M:%S %p",
                time12: "%I:%M:%S %p",
                dateTime: "%a %d %b %Y %I:%M:%S %p %Z",
                meridiem: ["AM", "PM"],
                month: {
                    abbrev: "Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),
                    full: "January|February|March|April|May|June|July|August|September|October|November|December".split("|")
                },
                day: {
                    abbrev: "Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),
                    full: "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")
                }
            }
        };
        var UNITS = "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond", UNIT_RE = new RegExp("^\\s*([+-])(\\d+)\\s+(" + UNITS + ")s?\\s*$", "i"), TIME = [36e5, 6e4, 1e3, 1];
        UNITS = UNITS.toLowerCase().split("|");
        "delmHMSUWVgCIky".replace(/./g, function (e) { context[e].pad = 2; });
        context.N.pad = 9;
        context.j.pad = 3;
        context.k.style = "_";
        context.l.style = "_";
        context.e.style = "_";
        function weekOfYear(date, startOfWeek) {
            var diff, nyd, weekStart;
            nyd = new Date(Date.UTC(date.getUTCFullYear(), 0));
            diff = Math.floor((date.getTime() - nyd.getTime()) / 864e5);
            if (nyd.getUTCDay() == startOfWeek) {
                weekStart = 0;
            }
            else {
                weekStart = 7 - nyd.getUTCDay() + startOfWeek;
                if (weekStart == 8) {
                    weekStart = 1;
                }
            }
            return diff >= weekStart ? Math.floor((diff - weekStart) / 7) + 1 : 0;
        }
        function isoWeek(date) {
            var nyd, nyy, week;
            nyy = date.getUTCFullYear();
            nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
            week = weekOfYear(date, 1) + (nyd > 1 && nyd <= 4 ? 1 : 0);
            if (!week) {
                nyy = date.getUTCFullYear() - 1;
                nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
                week = nyd == 4 || (nyd == 3 && new Date(nyy, 1, 29).getDate() == 29) ? 53 : 52;
                return [week, date.getUTCFullYear() - 1];
            }
            else if (week == 53 && !(nyd == 4 || (nyd == 3 && new Date(nyy, 1, 29).getDate() == 29))) {
                return [1, date.getUTCFullYear() + 1];
            }
            else {
                return [week, date.getUTCFullYear()];
            }
        }
        return function () { return context.convert(arguments); };
    });
},
/* core/util/templating.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const Numbro = (0, tslib_1.__importStar)(require(153) /* @bokeh/numbro */);
    const sprintf_js_1 = require(154) /* sprintf-js */;
    const timezone_1 = (0, tslib_1.__importDefault)(require(151) /* timezone */);
    const kinds_1 = require(21) /* ../kinds */;
    const types_1 = require(8) /* ./types */;
    exports.FormatterType = (0, kinds_1.Enum)("numeral", "printf", "datetime");
    exports.DEFAULT_FORMATTERS = {
        numeral: (value, format, _special_vars) => Numbro.format(value, format),
        datetime: (value, format, _special_vars) => (0, timezone_1.default)(value, format),
        printf: (value, format, _special_vars) => sprintf(format, value),
    };
    function sprintf(format, ...args) {
        return (0, sprintf_js_1.sprintf)(format, ...args);
    }
    exports.sprintf = sprintf;
    function basic_formatter(value, _format, _special_vars) {
        if ((0, types_1.isNumber)(value)) {
            const format = (() => {
                switch (false) {
                    case Math.floor(value) != value:
                        return "%d";
                    case !(Math.abs(value) > 0.1) || !(Math.abs(value) < 1000):
                        return "%0.3f";
                    default:
                        return "%0.3e";
                }
            })();
            return sprintf(format, value);
        }
        else
            return `${value}`; // get strings for categorical types
    }
    exports.basic_formatter = basic_formatter;
    function get_formatter(raw_spec, format, formatters) {
        // no format, use default built in formatter
        if (format == null)
            return basic_formatter;
        // format spec in the formatters dict, use that
        if (formatters != null && raw_spec in formatters) {
            const formatter = formatters[raw_spec];
            if ((0, types_1.isString)(formatter)) {
                if (formatter in exports.DEFAULT_FORMATTERS)
                    return exports.DEFAULT_FORMATTERS[formatter];
                else
                    throw new Error(`Unknown tooltip field formatter type '${formatter}'`);
            }
            return function (value, format, special_vars) {
                return formatter.format(value, format, special_vars);
            };
        }
        // otherwise use "numeral" as default
        return exports.DEFAULT_FORMATTERS.numeral;
    }
    exports.get_formatter = get_formatter;
    function _get_special_value(name, special_vars) {
        if (name in special_vars)
            return special_vars[name];
        else
            throw new Error(`Unknown special variable '\$${name}'`);
    }
    function _get_column_value(name, data_source, i) {
        const column = data_source.get_column(name);
        // missing column
        if (column == null)
            return null;
        // typical (non-image) index
        if ((0, types_1.isNumber)(i))
            return column[i];
        // image index
        const data = column[i.index];
        if ((0, types_1.isTypedArray)(data) || (0, types_1.isArray)(data)) {
            // inspect array of arrays
            if ((0, types_1.isArray)(data[0])) {
                const row = data[i.dim2];
                return row[i.dim1];
            }
            else
                return data[i.flat_index]; // inspect flat array
        }
        else
            return data; // inspect per-image scalar data
    }
    exports._get_column_value = _get_column_value;
    function get_value(raw_name, data_source, i, special_vars) {
        if (raw_name[0] == "$") {
            const name = raw_name.substring(1);
            return _get_special_value(name, special_vars);
        }
        else {
            const name = raw_name.substring(1).replace(/[{}]/g, "");
            return _get_column_value(name, data_source, i);
        }
    }
    exports.get_value = get_value;
    function replace_placeholders(content, data_source, i, formatters, special_vars = {}, encode) {
        let str;
        let has_html;
        if ((0, types_1.isString)(content)) {
            str = content;
            has_html = false;
        }
        else {
            str = content.html;
            has_html = true;
        }
        // this handles the special case @$name, replacing it with an @var corresponding to special_vars.name
        str = str.replace(/@\$name/g, (_match) => `@{${special_vars.name}}`);
        //
        // (?:\$\w+) - special vars: $x
        // (?:@\w+) - simple names: @foo
        // (?:@{(?:[^{}]+)})) - full names: @{one two}
        //
        // (?:{([^{}]+)})? - (optional) format for all of the above: @foo{fmt}
        //
        str = str.replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g, (_match, spec, format) => {
            const value = get_value(spec, data_source, i, special_vars);
            // missing value, return ???
            if (value == null)
                return encode ? encode("???") : "???";
            // 'safe' format, return the value as-is
            if (format == "safe") {
                has_html = true;
                return `${value}`;
            }
            // format and escape everything else
            const formatter = get_formatter(spec, format, formatters);
            const result = `${formatter(value, format, special_vars)}`;
            return encode ? encode(result) : result;
        });
        if (!has_html)
            return str;
        else {
            const parser = new DOMParser();
            const document = parser.parseFromString(str, "text/html");
            return [...document.body.childNodes];
        }
    }
    exports.replace_placeholders = replace_placeholders;
},
/* @bokeh/numbro/numbro.js */ function _(require, module, exports, __esModule, __esExport) {
    /*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
    /************************************
        Constants
    ************************************/
    var numbro, VERSION = '1.6.2', 
    // internal storage for culture config files
    cultures = {}, 
    // Todo: Remove in 2.0.0
    languages = cultures, currentCulture = 'en-US', zeroFormat = null, defaultFormat = '0,0', defaultCurrencyFormat = '0$', 
    // check for nodeJS
    hasModule = (typeof module !== 'undefined' && module.exports), 
    // default culture
    enUS = {
        delimiters: {
            thousands: ',',
            decimal: '.'
        },
        abbreviations: {
            thousand: 'k',
            million: 'm',
            billion: 'b',
            trillion: 't'
        },
        ordinal: function (number) {
            var b = number % 10;
            return (~~(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                    (b === 2) ? 'nd' :
                        (b === 3) ? 'rd' : 'th';
        },
        currency: {
            symbol: '$',
            position: 'prefix'
        },
        defaults: {
            currencyFormat: ',0000 a'
        },
        formats: {
            fourDigits: '0000 a',
            fullWithTwoDecimals: '$ ,0.00',
            fullWithTwoDecimalsNoCurrency: ',0.00'
        }
    };
    /************************************
        Constructors
    ************************************/
    // Numbro prototype object
    function Numbro(number) {
        this._value = number;
    }
    function zeroes(count) {
        var i, ret = '';
        for (i = 0; i < count; i++) {
            ret += '0';
        }
        return ret;
    }
    /**
     * Implementation of toFixed() for numbers with exponent > 21
     *
     *
     */
    function toFixedLarge(value, precision) {
        var mantissa, beforeDec, afterDec, exponent, str;
        str = value.toString();
        mantissa = str.split('e')[0];
        exponent = str.split('e')[1];
        beforeDec = mantissa.split('.')[0];
        afterDec = mantissa.split('.')[1] || '';
        str = beforeDec + afterDec + zeroes(exponent - afterDec.length);
        if (precision > 0) {
            str += '.' + zeroes(precision);
        }
        return str;
    }
    /**
     * Implementation of toFixed() that treats floats more like decimals
     *
     * Fixes binary rounding issues (eg. (0.615).toFixed(2) === '0.61') that present
     * problems for accounting- and finance-related software.
     */
    function toFixed(value, precision, roundingFunction, optionals) {
        var power = Math.pow(10, precision), optionalsRegExp, output;
        if (value.toFixed(0).search('e') > -1) {
            // Above 1e21, toFixed returns scientific notation, which
            // is useless and unexpected
            output = toFixedLarge(value, precision);
        }
        else {
            //roundingFunction = (roundingFunction !== undefined ? roundingFunction : Math.round);
            // Multiply up by precision, round accurately, then divide and use native toFixed():
            output = (roundingFunction(value * power) / power).toFixed(precision);
        }
        if (optionals) {
            optionalsRegExp = new RegExp('0{1,' + optionals + '}$');
            output = output.replace(optionalsRegExp, '');
        }
        return output;
    }
    /************************************
        Formatting
    ************************************/
    // determine what type of formatting we need to do
    function formatNumbro(value, format, roundingFunction) {
        var output;
        // TODO: do something with `language`
        // figure out what kind of format we are dealing with
        if (format.indexOf('$') > -1) { // currency!!!!!
            output = formatCurrency(value, format, roundingFunction);
        }
        else if (format.indexOf('%') > -1) { // percentage
            output = formatPercentage(value, format, roundingFunction);
        }
        else if (format.indexOf(':') > -1) { // time
            output = formatTime(value);
        }
        else { // plain ol' numbers or bytes
            output = formatNumber(value, format, roundingFunction);
        }
        // return string
        return output;
    }
    function formatCurrency(value, originalFormat, roundingFunction) {
        var format = originalFormat, symbolIndex = format.indexOf('$'), openParenIndex = format.indexOf('('), plusSignIndex = format.indexOf('+'), minusSignIndex = format.indexOf('-'), space = '', decimalSeparator = '', spliceIndex, output;
        if (format.indexOf('$') === -1) {
            // Use defaults instead of the format provided
            if (cultures[currentCulture].currency.position === 'infix') {
                decimalSeparator = cultures[currentCulture].currency.symbol;
                if (cultures[currentCulture].currency.spaceSeparated) {
                    decimalSeparator = ' ' + decimalSeparator + ' ';
                }
            }
            else if (cultures[currentCulture].currency.spaceSeparated) {
                space = ' ';
            }
        }
        else {
            // check for space before or after currency
            if (format.indexOf(' $') > -1) {
                space = ' ';
                format = format.replace(' $', '');
            }
            else if (format.indexOf('$ ') > -1) {
                space = ' ';
                format = format.replace('$ ', '');
            }
            else {
                format = format.replace('$', '');
            }
        }
        // Format The Number
        output = formatNumber(value, format, roundingFunction, decimalSeparator);
        if (originalFormat.indexOf('$') === -1) {
            // Use defaults instead of the format provided
            switch (cultures[currentCulture].currency.position) {
                case 'postfix':
                    if (output.indexOf(')') > -1) {
                        output = output.split('');
                        output.splice(-1, 0, space + cultures[currentCulture].currency.symbol);
                        output = output.join('');
                    }
                    else {
                        output = output + space + cultures[currentCulture].currency.symbol;
                    }
                    break;
                case 'infix':
                    break;
                case 'prefix':
                    if (output.indexOf('(') > -1 || output.indexOf('-') > -1) {
                        output = output.split('');
                        spliceIndex = Math.max(openParenIndex, minusSignIndex) + 1;
                        output.splice(spliceIndex, 0, cultures[currentCulture].currency.symbol + space);
                        output = output.join('');
                    }
                    else {
                        output = cultures[currentCulture].currency.symbol + space + output;
                    }
                    break;
                default:
                    throw Error('Currency position should be among ["prefix", "infix", "postfix"]');
            }
        }
        else {
            // position the symbol
            if (symbolIndex <= 1) {
                if (output.indexOf('(') > -1 || output.indexOf('+') > -1 || output.indexOf('-') > -1) {
                    output = output.split('');
                    spliceIndex = 1;
                    if (symbolIndex < openParenIndex || symbolIndex < plusSignIndex || symbolIndex < minusSignIndex) {
                        // the symbol appears before the "(", "+" or "-"
                        spliceIndex = 0;
                    }
                    output.splice(spliceIndex, 0, cultures[currentCulture].currency.symbol + space);
                    output = output.join('');
                }
                else {
                    output = cultures[currentCulture].currency.symbol + space + output;
                }
            }
            else {
                if (output.indexOf(')') > -1) {
                    output = output.split('');
                    output.splice(-1, 0, space + cultures[currentCulture].currency.symbol);
                    output = output.join('');
                }
                else {
                    output = output + space + cultures[currentCulture].currency.symbol;
                }
            }
        }
        return output;
    }
    function formatPercentage(value, format, roundingFunction) {
        var space = '', output;
        value = value * 100;
        // check for space before %
        if (format.indexOf(' %') > -1) {
            space = ' ';
            format = format.replace(' %', '');
        }
        else {
            format = format.replace('%', '');
        }
        output = formatNumber(value, format, roundingFunction);
        if (output.indexOf(')') > -1) {
            output = output.split('');
            output.splice(-1, 0, space + '%');
            output = output.join('');
        }
        else {
            output = output + space + '%';
        }
        return output;
    }
    function formatTime(value) {
        var hours = Math.floor(value / 60 / 60), minutes = Math.floor((value - (hours * 60 * 60)) / 60), seconds = Math.round(value - (hours * 60 * 60) - (minutes * 60));
        return hours + ':' +
            ((minutes < 10) ? '0' + minutes : minutes) + ':' +
            ((seconds < 10) ? '0' + seconds : seconds);
    }
    function formatNumber(value, format, roundingFunction, sep) {
        var negP = false, signed = false, optDec = false, abbr = '', i, abbrK = false, // force abbreviation to thousands
        abbrM = false, // force abbreviation to millions
        abbrB = false, // force abbreviation to billions
        abbrT = false, // force abbreviation to trillions
        abbrForce = false, // force abbreviation
        bytes = '', ord = '', abs = Math.abs(value), binarySuffixes = ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'], decimalSuffixes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'], min, max, power, totalLength, length, minimumPrecision, pow, w, intPrecision, precision, prefix, postfix, thousands, d = '', forcedNeg = false, neg = false, indexOpenP, size, indexMinus, paren = '', minlen;
        // check if number is zero and a custom zero format has been set
        if (value === 0 && zeroFormat !== null) {
            return zeroFormat;
        }
        if (!isFinite(value)) {
            return '' + value;
        }
        if (format.indexOf('{') === 0) {
            var end = format.indexOf('}');
            if (end === -1) {
                throw Error('Format should also contain a "}"');
            }
            prefix = format.slice(1, end);
            format = format.slice(end + 1);
        }
        else {
            prefix = '';
        }
        if (format.indexOf('}') === format.length - 1) {
            var start = format.indexOf('{');
            if (start === -1) {
                throw Error('Format should also contain a "{"');
            }
            postfix = format.slice(start + 1, -1);
            format = format.slice(0, start + 1);
        }
        else {
            postfix = '';
        }
        // check for min length
        var info;
        if (format.indexOf('.') === -1) {
            info = format.match(/([0-9]+).*/);
        }
        else {
            info = format.match(/([0-9]+)\..*/);
        }
        minlen = info === null ? -1 : info[1].length;
        // see if we should use parentheses for negative number or if we should prefix with a sign
        // if both are present we default to parentheses
        if (format.indexOf('-') !== -1) {
            forcedNeg = true;
        }
        if (format.indexOf('(') > -1) {
            negP = true;
            format = format.slice(1, -1);
        }
        else if (format.indexOf('+') > -1) {
            signed = true;
            format = format.replace(/\+/g, '');
        }
        // see if abbreviation is wanted
        if (format.indexOf('a') > -1) {
            intPrecision = format.split('.')[0].match(/[0-9]+/g) || ['0'];
            intPrecision = parseInt(intPrecision[0], 10);
            // check if abbreviation is specified
            abbrK = format.indexOf('aK') >= 0;
            abbrM = format.indexOf('aM') >= 0;
            abbrB = format.indexOf('aB') >= 0;
            abbrT = format.indexOf('aT') >= 0;
            abbrForce = abbrK || abbrM || abbrB || abbrT;
            // check for space before abbreviation
            if (format.indexOf(' a') > -1) {
                abbr = ' ';
                format = format.replace(' a', '');
            }
            else {
                format = format.replace('a', '');
            }
            totalLength = Math.floor(Math.log(abs) / Math.LN10) + 1;
            minimumPrecision = totalLength % 3;
            minimumPrecision = minimumPrecision === 0 ? 3 : minimumPrecision;
            if (intPrecision && abs !== 0) {
                length = Math.floor(Math.log(abs) / Math.LN10) + 1 - intPrecision;
                pow = 3 * ~~((Math.min(intPrecision, totalLength) - minimumPrecision) / 3);
                abs = abs / Math.pow(10, pow);
                if (format.indexOf('.') === -1 && intPrecision > 3) {
                    format += '[.]';
                    size = length === 0 ? 0 : 3 * ~~(length / 3) - length;
                    size = size < 0 ? size + 3 : size;
                    for (i = 0; i < size; i++) {
                        format += '0';
                    }
                }
            }
            if (Math.floor(Math.log(Math.abs(value)) / Math.LN10) + 1 !== intPrecision) {
                if (abs >= Math.pow(10, 12) && !abbrForce || abbrT) {
                    // trillion
                    abbr = abbr + cultures[currentCulture].abbreviations.trillion;
                    value = value / Math.pow(10, 12);
                }
                else if (abs < Math.pow(10, 12) && abs >= Math.pow(10, 9) && !abbrForce || abbrB) {
                    // billion
                    abbr = abbr + cultures[currentCulture].abbreviations.billion;
                    value = value / Math.pow(10, 9);
                }
                else if (abs < Math.pow(10, 9) && abs >= Math.pow(10, 6) && !abbrForce || abbrM) {
                    // million
                    abbr = abbr + cultures[currentCulture].abbreviations.million;
                    value = value / Math.pow(10, 6);
                }
                else if (abs < Math.pow(10, 6) && abs >= Math.pow(10, 3) && !abbrForce || abbrK) {
                    // thousand
                    abbr = abbr + cultures[currentCulture].abbreviations.thousand;
                    value = value / Math.pow(10, 3);
                }
            }
        }
        // see if we are formatting binary bytes
        if (format.indexOf('b') > -1) {
            // check for space before
            if (format.indexOf(' b') > -1) {
                bytes = ' ';
                format = format.replace(' b', '');
            }
            else {
                format = format.replace('b', '');
            }
            for (power = 0; power <= binarySuffixes.length; power++) {
                min = Math.pow(1024, power);
                max = Math.pow(1024, power + 1);
                if (value >= min && value < max) {
                    bytes = bytes + binarySuffixes[power];
                    if (min > 0) {
                        value = value / min;
                    }
                    break;
                }
            }
        }
        // see if we are formatting decimal bytes
        if (format.indexOf('d') > -1) {
            // check for space before
            if (format.indexOf(' d') > -1) {
                bytes = ' ';
                format = format.replace(' d', '');
            }
            else {
                format = format.replace('d', '');
            }
            for (power = 0; power <= decimalSuffixes.length; power++) {
                min = Math.pow(1000, power);
                max = Math.pow(1000, power + 1);
                if (value >= min && value < max) {
                    bytes = bytes + decimalSuffixes[power];
                    if (min > 0) {
                        value = value / min;
                    }
                    break;
                }
            }
        }
        // see if ordinal is wanted
        if (format.indexOf('o') > -1) {
            // check for space before
            if (format.indexOf(' o') > -1) {
                ord = ' ';
                format = format.replace(' o', '');
            }
            else {
                format = format.replace('o', '');
            }
            if (cultures[currentCulture].ordinal) {
                ord = ord + cultures[currentCulture].ordinal(value);
            }
        }
        if (format.indexOf('[.]') > -1) {
            optDec = true;
            format = format.replace('[.]', '.');
        }
        w = value.toString().split('.')[0];
        precision = format.split('.')[1];
        thousands = format.indexOf(',');
        if (precision) {
            if (precision.indexOf('*') !== -1) {
                d = toFixed(value, value.toString().split('.')[1].length, roundingFunction);
            }
            else {
                if (precision.indexOf('[') > -1) {
                    precision = precision.replace(']', '');
                    precision = precision.split('[');
                    d = toFixed(value, (precision[0].length + precision[1].length), roundingFunction, precision[1].length);
                }
                else {
                    d = toFixed(value, precision.length, roundingFunction);
                }
            }
            w = d.split('.')[0];
            if (d.split('.')[1].length) {
                var p = sep ? abbr + sep : cultures[currentCulture].delimiters.decimal;
                d = p + d.split('.')[1];
            }
            else {
                d = '';
            }
            if (optDec && Number(d.slice(1)) === 0) {
                d = '';
            }
        }
        else {
            w = toFixed(value, null, roundingFunction);
        }
        // format number
        if (w.indexOf('-') > -1) {
            w = w.slice(1);
            neg = true;
        }
        if (w.length < minlen) {
            w = new Array(minlen - w.length + 1).join('0') + w;
        }
        if (thousands > -1) {
            w = w.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1' +
                cultures[currentCulture].delimiters.thousands);
        }
        if (format.indexOf('.') === 0) {
            w = '';
        }
        indexOpenP = format.indexOf('(');
        indexMinus = format.indexOf('-');
        if (indexOpenP < indexMinus) {
            paren = ((negP && neg) ? '(' : '') + (((forcedNeg && neg) || (!negP && neg)) ? '-' : '');
        }
        else {
            paren = (((forcedNeg && neg) || (!negP && neg)) ? '-' : '') + ((negP && neg) ? '(' : '');
        }
        return prefix +
            paren + ((!neg && signed && value !== 0) ? '+' : '') +
            w + d +
            ((ord) ? ord : '') +
            ((abbr && !sep) ? abbr : '') +
            ((bytes) ? bytes : '') +
            ((negP && neg) ? ')' : '') +
            postfix;
    }
    /************************************
        Top Level Functions
    ************************************/
    numbro = function (input) {
        if (numbro.isNumbro(input)) {
            input = input.value();
        }
        else if (input === 0 || typeof input === 'undefined') {
            input = 0;
        }
        else if (!Number(input)) {
            input = numbro.fn.unformat(input);
        }
        return new Numbro(Number(input));
    };
    // version number
    numbro.version = VERSION;
    // compare numbro object
    numbro.isNumbro = function (obj) {
        return obj instanceof Numbro;
    };
    /**
     * This function allow the user to set a new language with a fallback if
     * the language does not exist. If no fallback language is provided,
     * it fallbacks to english.
     *
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `setCulture` should be used instead.
     */
    numbro.setLanguage = function (newLanguage, fallbackLanguage) {
        console.warn('`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead');
        var key = newLanguage, prefix = newLanguage.split('-')[0], matchingLanguage = null;
        if (!languages[key]) {
            Object.keys(languages).forEach(function (language) {
                if (!matchingLanguage && language.split('-')[0] === prefix) {
                    matchingLanguage = language;
                }
            });
            key = matchingLanguage || fallbackLanguage || 'en-US';
        }
        chooseCulture(key);
    };
    /**
     * This function allow the user to set a new culture with a fallback if
     * the culture does not exist. If no fallback culture is provided,
     * it fallbacks to "en-US".
     */
    numbro.setCulture = function (newCulture, fallbackCulture) {
        var key = newCulture, suffix = newCulture.split('-')[1], matchingCulture = null;
        if (!cultures[key]) {
            if (suffix) {
                Object.keys(cultures).forEach(function (language) {
                    if (!matchingCulture && language.split('-')[1] === suffix) {
                        matchingCulture = language;
                    }
                });
            }
            key = matchingCulture || fallbackCulture || 'en-US';
        }
        chooseCulture(key);
    };
    /**
     * This function will load languages and then set the global language.  If
     * no arguments are passed in, it will simply return the current global
     * language key.
     *
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `culture` should be used instead.
     */
    numbro.language = function (key, values) {
        console.warn('`language` is deprecated since version 1.6.0. Use `culture` instead');
        if (!key) {
            return currentCulture;
        }
        if (key && !values) {
            if (!languages[key]) {
                throw new Error('Unknown language : ' + key);
            }
            chooseCulture(key);
        }
        if (values || !languages[key]) {
            setCulture(key, values);
        }
        return numbro;
    };
    /**
     * This function will load cultures and then set the global culture.  If
     * no arguments are passed in, it will simply return the current global
     * culture code.
     */
    numbro.culture = function (code, values) {
        if (!code) {
            return currentCulture;
        }
        if (code && !values) {
            if (!cultures[code]) {
                throw new Error('Unknown culture : ' + code);
            }
            chooseCulture(code);
        }
        if (values || !cultures[code]) {
            setCulture(code, values);
        }
        return numbro;
    };
    /**
     * This function provides access to the loaded language data.  If
     * no arguments are passed in, it will simply return the current
     * global language object.
     *
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `culture` should be used instead.
     */
    numbro.languageData = function (key) {
        console.warn('`languageData` is deprecated since version 1.6.0. Use `cultureData` instead');
        if (!key) {
            return languages[currentCulture];
        }
        if (!languages[key]) {
            throw new Error('Unknown language : ' + key);
        }
        return languages[key];
    };
    /**
     * This function provides access to the loaded culture data.  If
     * no arguments are passed in, it will simply return the current
     * global culture object.
     */
    numbro.cultureData = function (code) {
        if (!code) {
            return cultures[currentCulture];
        }
        if (!cultures[code]) {
            throw new Error('Unknown culture : ' + code);
        }
        return cultures[code];
    };
    numbro.culture('en-US', enUS);
    /**
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `cultures` should be used instead.
     */
    numbro.languages = function () {
        console.warn('`languages` is deprecated since version 1.6.0. Use `cultures` instead');
        return languages;
    };
    numbro.cultures = function () {
        return cultures;
    };
    numbro.zeroFormat = function (format) {
        zeroFormat = typeof (format) === 'string' ? format : null;
    };
    numbro.defaultFormat = function (format) {
        defaultFormat = typeof (format) === 'string' ? format : '0.0';
    };
    numbro.defaultCurrencyFormat = function (format) {
        defaultCurrencyFormat = typeof (format) === 'string' ? format : '0$';
    };
    numbro.validate = function (val, culture) {
        var _decimalSep, _thousandSep, _currSymbol, _valArray, _abbrObj, _thousandRegEx, cultureData, temp;
        //coerce val to string
        if (typeof val !== 'string') {
            val += '';
            if (console.warn) {
                console.warn('Numbro.js: Value is not string. It has been co-erced to: ', val);
            }
        }
        //trim whitespaces from either sides
        val = val.trim();
        //if val is just digits return true
        if (!!val.match(/^\d+$/)) {
            return true;
        }
        //if val is empty return false
        if (val === '') {
            return false;
        }
        //get the decimal and thousands separator from numbro.cultureData
        try {
            //check if the culture is understood by numbro. if not, default it to current culture
            cultureData = numbro.cultureData(culture);
        }
        catch (e) {
            cultureData = numbro.cultureData(numbro.culture());
        }
        //setup the delimiters and currency symbol based on culture
        _currSymbol = cultureData.currency.symbol;
        _abbrObj = cultureData.abbreviations;
        _decimalSep = cultureData.delimiters.decimal;
        if (cultureData.delimiters.thousands === '.') {
            _thousandSep = '\\.';
        }
        else {
            _thousandSep = cultureData.delimiters.thousands;
        }
        // validating currency symbol
        temp = val.match(/^[^\d]+/);
        if (temp !== null) {
            val = val.substr(1);
            if (temp[0] !== _currSymbol) {
                return false;
            }
        }
        //validating abbreviation symbol
        temp = val.match(/[^\d]+$/);
        if (temp !== null) {
            val = val.slice(0, -1);
            if (temp[0] !== _abbrObj.thousand && temp[0] !== _abbrObj.million &&
                temp[0] !== _abbrObj.billion && temp[0] !== _abbrObj.trillion) {
                return false;
            }
        }
        _thousandRegEx = new RegExp(_thousandSep + '{2}');
        if (!val.match(/[^\d.,]/g)) {
            _valArray = val.split(_decimalSep);
            if (_valArray.length > 2) {
                return false;
            }
            else {
                if (_valArray.length < 2) {
                    return (!!_valArray[0].match(/^\d+.*\d$/) && !_valArray[0].match(_thousandRegEx));
                }
                else {
                    if (_valArray[0].length === 1) {
                        return (!!_valArray[0].match(/^\d+$/) &&
                            !_valArray[0].match(_thousandRegEx) &&
                            !!_valArray[1].match(/^\d+$/));
                    }
                    else {
                        return (!!_valArray[0].match(/^\d+.*\d$/) &&
                            !_valArray[0].match(_thousandRegEx) &&
                            !!_valArray[1].match(/^\d+$/));
                    }
                }
            }
        }
        return false;
    };
    /************************************
        Helpers
    ************************************/
    function setCulture(code, values) {
        cultures[code] = values;
    }
    function chooseCulture(code) {
        currentCulture = code;
        var defaults = cultures[code].defaults;
        if (defaults && defaults.format) {
            numbro.defaultFormat(defaults.format);
        }
        if (defaults && defaults.currencyFormat) {
            numbro.defaultCurrencyFormat(defaults.currencyFormat);
        }
    }
    function format(input, formatString, language, roundingFunction) {
        if (language != null && language !== numbro.culture()) {
            numbro.setCulture(language);
        }
        return formatNumbro(Number(input), formatString != null ? formatString : defaultFormat, roundingFunction == null ? Math.round : roundingFunction);
    }
    module.exports = { "format": format };
},
/* sprintf-js/src/sprintf.js */ function _(require, module, exports, __esModule, __esExport) {
    /* global window, exports, define */
    !function () {
        'use strict';
        var re = {
            not_string: /[^s]/,
            not_bool: /[^t]/,
            not_type: /[^T]/,
            not_primitive: /[^v]/,
            number: /[diefg]/,
            numeric_arg: /[bcdiefguxX]/,
            json: /[j]/,
            not_json: /[^j]/,
            text: /^[^\x25]+/,
            modulo: /^\x25{2}/,
            placeholder: /^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,
            key: /^([a-z_][a-z_\d]*)/i,
            key_access: /^\.([a-z_][a-z_\d]*)/i,
            index_access: /^\[(\d+)\]/,
            sign: /^[+-]/
        };
        function sprintf(key) {
            // `arguments` is not an array, but should be fine for this call
            return sprintf_format(sprintf_parse(key), arguments);
        }
        function vsprintf(fmt, argv) {
            return sprintf.apply(null, [fmt].concat(argv || []));
        }
        function sprintf_format(parse_tree, argv) {
            var cursor = 1, tree_length = parse_tree.length, arg, output = '', i, k, ph, pad, pad_character, pad_length, is_positive, sign;
            for (i = 0; i < tree_length; i++) {
                if (typeof parse_tree[i] === 'string') {
                    output += parse_tree[i];
                }
                else if (typeof parse_tree[i] === 'object') {
                    ph = parse_tree[i]; // convenience purposes only
                    if (ph.keys) { // keyword argument
                        arg = argv[cursor];
                        for (k = 0; k < ph.keys.length; k++) {
                            if (arg == undefined) {
                                throw new Error(sprintf('[sprintf] Cannot access property "%s" of undefined value "%s"', ph.keys[k], ph.keys[k - 1]));
                            }
                            arg = arg[ph.keys[k]];
                        }
                    }
                    else if (ph.param_no) { // positional argument (explicit)
                        arg = argv[ph.param_no];
                    }
                    else { // positional argument (implicit)
                        arg = argv[cursor++];
                    }
                    if (re.not_type.test(ph.type) && re.not_primitive.test(ph.type) && arg instanceof Function) {
                        arg = arg();
                    }
                    if (re.numeric_arg.test(ph.type) && (typeof arg !== 'number' && isNaN(arg))) {
                        throw new TypeError(sprintf('[sprintf] expecting number but found %T', arg));
                    }
                    if (re.number.test(ph.type)) {
                        is_positive = arg >= 0;
                    }
                    switch (ph.type) {
                        case 'b':
                            arg = parseInt(arg, 10).toString(2);
                            break;
                        case 'c':
                            arg = String.fromCharCode(parseInt(arg, 10));
                            break;
                        case 'd':
                        case 'i':
                            arg = parseInt(arg, 10);
                            break;
                        case 'j':
                            arg = JSON.stringify(arg, null, ph.width ? parseInt(ph.width) : 0);
                            break;
                        case 'e':
                            arg = ph.precision ? parseFloat(arg).toExponential(ph.precision) : parseFloat(arg).toExponential();
                            break;
                        case 'f':
                            arg = ph.precision ? parseFloat(arg).toFixed(ph.precision) : parseFloat(arg);
                            break;
                        case 'g':
                            arg = ph.precision ? String(Number(arg.toPrecision(ph.precision))) : parseFloat(arg);
                            break;
                        case 'o':
                            arg = (parseInt(arg, 10) >>> 0).toString(8);
                            break;
                        case 's':
                            arg = String(arg);
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 't':
                            arg = String(!!arg);
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 'T':
                            arg = Object.prototype.toString.call(arg).slice(8, -1).toLowerCase();
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 'u':
                            arg = parseInt(arg, 10) >>> 0;
                            break;
                        case 'v':
                            arg = arg.valueOf();
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 'x':
                            arg = (parseInt(arg, 10) >>> 0).toString(16);
                            break;
                        case 'X':
                            arg = (parseInt(arg, 10) >>> 0).toString(16).toUpperCase();
                            break;
                    }
                    if (re.json.test(ph.type)) {
                        output += arg;
                    }
                    else {
                        if (re.number.test(ph.type) && (!is_positive || ph.sign)) {
                            sign = is_positive ? '+' : '-';
                            arg = arg.toString().replace(re.sign, '');
                        }
                        else {
                            sign = '';
                        }
                        pad_character = ph.pad_char ? ph.pad_char === '0' ? '0' : ph.pad_char.charAt(1) : ' ';
                        pad_length = ph.width - (sign + arg).length;
                        pad = ph.width ? (pad_length > 0 ? pad_character.repeat(pad_length) : '') : '';
                        output += ph.align ? sign + arg + pad : (pad_character === '0' ? sign + pad + arg : pad + sign + arg);
                    }
                }
            }
            return output;
        }
        var sprintf_cache = Object.create(null);
        function sprintf_parse(fmt) {
            if (sprintf_cache[fmt]) {
                return sprintf_cache[fmt];
            }
            var _fmt = fmt, match, parse_tree = [], arg_names = 0;
            while (_fmt) {
                if ((match = re.text.exec(_fmt)) !== null) {
                    parse_tree.push(match[0]);
                }
                else if ((match = re.modulo.exec(_fmt)) !== null) {
                    parse_tree.push('%');
                }
                else if ((match = re.placeholder.exec(_fmt)) !== null) {
                    if (match[2]) {
                        arg_names |= 1;
                        var field_list = [], replacement_field = match[2], field_match = [];
                        if ((field_match = re.key.exec(replacement_field)) !== null) {
                            field_list.push(field_match[1]);
                            while ((replacement_field = replacement_field.substring(field_match[0].length)) !== '') {
                                if ((field_match = re.key_access.exec(replacement_field)) !== null) {
                                    field_list.push(field_match[1]);
                                }
                                else if ((field_match = re.index_access.exec(replacement_field)) !== null) {
                                    field_list.push(field_match[1]);
                                }
                                else {
                                    throw new SyntaxError('[sprintf] failed to parse named argument key');
                                }
                            }
                        }
                        else {
                            throw new SyntaxError('[sprintf] failed to parse named argument key');
                        }
                        match[2] = field_list;
                    }
                    else {
                        arg_names |= 2;
                    }
                    if (arg_names === 3) {
                        throw new Error('[sprintf] mixing positional and named placeholders is not (yet) supported');
                    }
                    parse_tree.push({
                        placeholder: match[0],
                        param_no: match[1],
                        keys: match[2],
                        sign: match[3],
                        pad_char: match[4],
                        align: match[5],
                        width: match[6],
                        precision: match[7],
                        type: match[8]
                    });
                }
                else {
                    throw new SyntaxError('[sprintf] unexpected placeholder');
                }
                _fmt = _fmt.substring(match[0].length);
            }
            return sprintf_cache[fmt] = parse_tree;
        }
        /**
         * export to either browser or node.js
         */
        /* eslint-disable quote-props */
        if (typeof exports !== 'undefined') {
            exports['sprintf'] = sprintf;
            exports['vsprintf'] = vsprintf;
        }
        if (typeof window !== 'undefined') {
            window['sprintf'] = sprintf;
            window['vsprintf'] = vsprintf;
            if (typeof define === 'function' && define['amd']) {
                define(function () {
                    return {
                        'sprintf': sprintf,
                        'vsprintf': vsprintf
                    };
                });
            }
        }
        /* eslint-enable quote-props */
    }(); // eslint-disable-line
},
/* models/tickers/datetime_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const array_1 = require(9) /* ../../core/util/array */;
    const adaptive_ticker_1 = require(148) /* ./adaptive_ticker */;
    const composite_ticker_1 = require(156) /* ./composite_ticker */;
    const days_ticker_1 = require(157) /* ./days_ticker */;
    const months_ticker_1 = require(160) /* ./months_ticker */;
    const years_ticker_1 = require(161) /* ./years_ticker */;
    const util_1 = require(159) /* ./util */;
    class DatetimeTicker extends composite_ticker_1.CompositeTicker {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DatetimeTicker = DatetimeTicker;
    _a = DatetimeTicker;
    DatetimeTicker.__name__ = "DatetimeTicker";
    (() => {
        _a.override({
            num_minor_ticks: 0,
            tickers: () => [
                // Sub-second.
                new adaptive_ticker_1.AdaptiveTicker({
                    mantissas: [1, 2, 5],
                    base: 10,
                    min_interval: 0,
                    max_interval: 500 * util_1.ONE_MILLI,
                    num_minor_ticks: 0,
                }),
                // Seconds, minutes.
                new adaptive_ticker_1.AdaptiveTicker({
                    mantissas: [1, 2, 5, 10, 15, 20, 30],
                    base: 60,
                    min_interval: util_1.ONE_SECOND,
                    max_interval: 30 * util_1.ONE_MINUTE,
                    num_minor_ticks: 0,
                }),
                // Hours.
                new adaptive_ticker_1.AdaptiveTicker({
                    mantissas: [1, 2, 4, 6, 8, 12],
                    base: 24.0,
                    min_interval: util_1.ONE_HOUR,
                    max_interval: 12 * util_1.ONE_HOUR,
                    num_minor_ticks: 0,
                }),
                // Days.
                new days_ticker_1.DaysTicker({ days: (0, array_1.range)(1, 32) }),
                new days_ticker_1.DaysTicker({ days: (0, array_1.range)(1, 31, 3) }),
                new days_ticker_1.DaysTicker({ days: [1, 8, 15, 22] }),
                new days_ticker_1.DaysTicker({ days: [1, 15] }),
                // Months.
                new months_ticker_1.MonthsTicker({ months: (0, array_1.range)(0, 12, 1) }),
                new months_ticker_1.MonthsTicker({ months: (0, array_1.range)(0, 12, 2) }),
                new months_ticker_1.MonthsTicker({ months: (0, array_1.range)(0, 12, 4) }),
                new months_ticker_1.MonthsTicker({ months: (0, array_1.range)(0, 12, 6) }),
                // Years
                new years_ticker_1.YearsTicker({}),
            ],
        });
    })();
},
/* models/tickers/composite_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_ticker_1 = require(149) /* ./continuous_ticker */;
    const array_1 = require(9) /* ../../core/util/array */;
    class CompositeTicker extends continuous_ticker_1.ContinuousTicker {
        constructor(attrs) {
            super(attrs);
        }
        // The tickers should be in order of increasing interval size; specifically,
        // if S comes before T, then it should be the case that
        // S.get_max_interval() < T.get_min_interval().
        // FIXME Enforce this automatically.
        get min_intervals() {
            return this.tickers.map((ticker) => ticker.get_min_interval());
        }
        get max_intervals() {
            return this.tickers.map((ticker) => ticker.get_max_interval());
        }
        get_min_interval() {
            return this.min_intervals[0];
        }
        get_max_interval() {
            return this.max_intervals[0];
        }
        get_best_ticker(data_low, data_high, desired_n_ticks) {
            const data_range = data_high - data_low;
            const ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
            const ticker_ndxs = [
                (0, array_1.sorted_index)(this.min_intervals, ideal_interval) - 1,
                (0, array_1.sorted_index)(this.max_intervals, ideal_interval),
            ];
            const intervals = [
                this.min_intervals[ticker_ndxs[0]],
                this.max_intervals[ticker_ndxs[1]],
            ];
            const errors = intervals.map((interval) => {
                return Math.abs(desired_n_ticks - (data_range / interval));
            });
            let best_ticker;
            if ((0, array_1.is_empty)(errors.filter((e) => !isNaN(e)))) {
                // this can happen if the data isn't loaded yet, we just default to the first scale
                best_ticker = this.tickers[0];
            }
            else {
                const best_index = (0, array_1.argmin)(errors);
                const best_ticker_ndx = ticker_ndxs[best_index];
                best_ticker = this.tickers[best_ticker_ndx];
            }
            return best_ticker;
        }
        get_interval(data_low, data_high, desired_n_ticks) {
            const best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
            return best_ticker.get_interval(data_low, data_high, desired_n_ticks);
        }
        get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks) {
            const best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
            return best_ticker.get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks);
        }
    }
    exports.CompositeTicker = CompositeTicker;
    _a = CompositeTicker;
    CompositeTicker.__name__ = "CompositeTicker";
    (() => {
        _a.define(({ Array, Ref }) => ({
            tickers: [Array(Ref(continuous_ticker_1.ContinuousTicker)), []],
        }));
    })();
},
/* models/tickers/days_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const single_interval_ticker_1 = require(158) /* ./single_interval_ticker */;
    const util_1 = require(159) /* ./util */;
    const array_1 = require(9) /* ../../core/util/array */;
    // Given a start and end time in millis, returns the shortest array of
    // consecutive months (as Dates) that surrounds both times.
    function date_range_by_month(start_time, end_time) {
        const start_date = (0, util_1.last_month_no_later_than)(new Date(start_time));
        const end_date = (0, util_1.last_month_no_later_than)(new Date(end_time));
        // XXX This is not a reliable technique in general, but it should be
        // safe when the day of the month is 1.  (The problem case is this:
        // Mar 31 -> Apr 31, which becomes May 1.)
        end_date.setUTCMonth(end_date.getUTCMonth() + 1);
        const dates = [];
        const date = start_date;
        while (true) {
            dates.push((0, util_1.copy_date)(date));
            date.setUTCMonth(date.getUTCMonth() + 1);
            if (date > end_date)
                break;
        }
        return dates;
    }
    class DaysTicker extends single_interval_ticker_1.SingleIntervalTicker {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            const days = this.days;
            if (days.length > 1)
                this.interval = (days[1] - days[0]) * util_1.ONE_DAY;
            else
                this.interval = 31 * util_1.ONE_DAY;
        }
        get_ticks_no_defaults(data_low, data_high, _cross_loc, _desired_n_ticks) {
            const month_dates = date_range_by_month(data_low, data_high);
            const days = this.days;
            const days_of_month = (month_date, interval) => {
                const current_month = month_date.getUTCMonth();
                const dates = [];
                for (const day of days) {
                    const day_date = (0, util_1.copy_date)(month_date);
                    day_date.setUTCDate(day);
                    // We can't use all of the values in this.days, because they may not
                    // fall within the current month.  In fact, if, e.g., our month is 28 days
                    // and we're marking every third day, we don't want day 28 to show up
                    // because it'll be right next to the 1st of the next month.  So we
                    // make sure we have a bit of room before we include a day.
                    // TODO (bev) The above description does not exactly work because JS Date
                    // is broken and will happily consider "Feb 28 + 3*ONE_DAY" to have month "2"
                    const future_date = new Date(day_date.getTime() + (interval / 2));
                    if (future_date.getUTCMonth() == current_month)
                        dates.push(day_date);
                }
                return dates;
            };
            const interval = this.interval;
            const day_dates = (0, array_1.concat)(month_dates.map((date) => days_of_month(date, interval)));
            const all_ticks = day_dates.map((day_date) => day_date.getTime());
            const ticks_in_range = all_ticks.filter((tick) => data_low <= tick && tick <= data_high);
            return {
                major: ticks_in_range,
                minor: [],
            };
        }
    }
    exports.DaysTicker = DaysTicker;
    _a = DaysTicker;
    DaysTicker.__name__ = "DaysTicker";
    (() => {
        _a.define(({ Int, Array }) => ({
            days: [Array(Int), []],
        }));
        _a.override({
            num_minor_ticks: 0,
        });
    })();
},
/* models/tickers/single_interval_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_ticker_1 = require(149) /* ./continuous_ticker */;
    class SingleIntervalTicker extends continuous_ticker_1.ContinuousTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_interval(_data_low, _data_high, _n_desired_ticks) {
            return this.interval;
        }
        get_min_interval() {
            return this.interval;
        }
        get_max_interval() {
            return this.interval;
        }
    }
    exports.SingleIntervalTicker = SingleIntervalTicker;
    _a = SingleIntervalTicker;
    SingleIntervalTicker.__name__ = "SingleIntervalTicker";
    (() => {
        _a.define(({ Number }) => ({
            interval: [Number],
        }));
    })();
},
/* models/tickers/util.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // TODO Clear out debugging code, etc.
    // TODO Organize helper functions.
    // TODO The years ticker doesn't always use the roundest numbers; it should
    // probably use a special ticker.
    // TODO Add tests.
    // TODO There used to be a TODO: restore memoization.  So.... do that?
    // TODO Instead of a get_ticks() method, there used to be an auto_ticks()
    // function that took a lot of fancy arguments, but those arguments weren't
    // used anywhere.  Should we restore them?
    // Some time constants, in milliseconds.
    exports.ONE_MILLI = 1.0;
    exports.ONE_SECOND = 1000.0;
    exports.ONE_MINUTE = 60.0 * exports.ONE_SECOND;
    exports.ONE_HOUR = 60 * exports.ONE_MINUTE;
    exports.ONE_DAY = 24 * exports.ONE_HOUR;
    exports.ONE_MONTH = 30 * exports.ONE_DAY; // An approximation, obviously.
    exports.ONE_YEAR = 365 * exports.ONE_DAY;
    // ---------------------------------------------------------------------------
    // Date/time utility functions
    // ---------------------------------------------------------------------------
    // Makes a copy of a date object.
    function copy_date(date) {
        return new Date(date.getTime());
    }
    exports.copy_date = copy_date;
    // Rounds a date down to the month.
    function last_month_no_later_than(date) {
        const new_date = copy_date(date);
        new_date.setUTCDate(1);
        new_date.setUTCHours(0);
        new_date.setUTCMinutes(0);
        new_date.setUTCSeconds(0);
        new_date.setUTCMilliseconds(0);
        return new_date;
    }
    exports.last_month_no_later_than = last_month_no_later_than;
    // Rounds a date down to the year.
    function last_year_no_later_than(date) {
        const new_date = last_month_no_later_than(date);
        new_date.setUTCMonth(0);
        return new_date;
    }
    exports.last_year_no_later_than = last_year_no_later_than;
},
/* models/tickers/months_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const single_interval_ticker_1 = require(158) /* ./single_interval_ticker */;
    const util_1 = require(159) /* ./util */;
    const array_1 = require(9) /* ../../core/util/array */;
    // Given a start and end time in millis, returns the shortest array of
    // consecutive years (as Dates) that surrounds both times.
    function date_range_by_year(start_time, end_time) {
        const start_date = (0, util_1.last_year_no_later_than)(new Date(start_time));
        const end_date = (0, util_1.last_year_no_later_than)(new Date(end_time));
        end_date.setUTCFullYear(end_date.getUTCFullYear() + 1);
        const dates = [];
        const date = start_date;
        while (true) {
            dates.push((0, util_1.copy_date)(date));
            date.setUTCFullYear(date.getUTCFullYear() + 1);
            if (date > end_date)
                break;
        }
        return dates;
    }
    class MonthsTicker extends single_interval_ticker_1.SingleIntervalTicker {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            const months = this.months;
            if (months.length > 1)
                this.interval = (months[1] - months[0]) * util_1.ONE_MONTH;
            else
                this.interval = 12 * util_1.ONE_MONTH;
        }
        get_ticks_no_defaults(data_low, data_high, _cross_loc, _desired_n_ticks) {
            const year_dates = date_range_by_year(data_low, data_high);
            const months = this.months;
            const months_of_year = (year_date) => {
                return months.map((month) => {
                    const month_date = (0, util_1.copy_date)(year_date);
                    month_date.setUTCMonth(month);
                    return month_date;
                });
            };
            const month_dates = (0, array_1.concat)(year_dates.map(months_of_year));
            const all_ticks = month_dates.map((month_date) => month_date.getTime());
            const ticks_in_range = all_ticks.filter((tick) => data_low <= tick && tick <= data_high);
            return {
                major: ticks_in_range,
                minor: [],
            };
        }
    }
    exports.MonthsTicker = MonthsTicker;
    _a = MonthsTicker;
    MonthsTicker.__name__ = "MonthsTicker";
    (() => {
        _a.define(({ Int, Array }) => ({
            months: [Array(Int), []],
        }));
    })();
},
/* models/tickers/years_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const basic_ticker_1 = require(147) /* ./basic_ticker */;
    const single_interval_ticker_1 = require(158) /* ./single_interval_ticker */;
    const util_1 = require(159) /* ./util */;
    class YearsTicker extends single_interval_ticker_1.SingleIntervalTicker {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this.interval = util_1.ONE_YEAR;
            this.basic_ticker = new basic_ticker_1.BasicTicker({ num_minor_ticks: 0 });
        }
        get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks) {
            const start_year = (0, util_1.last_year_no_later_than)(new Date(data_low)).getUTCFullYear();
            const end_year = (0, util_1.last_year_no_later_than)(new Date(data_high)).getUTCFullYear();
            const years = this.basic_ticker.get_ticks_no_defaults(start_year, end_year, cross_loc, desired_n_ticks).major;
            const all_ticks = years.map((year) => Date.UTC(year, 0, 1));
            const ticks_in_range = all_ticks.filter((tick) => data_low <= tick && tick <= data_high);
            return {
                major: ticks_in_range,
                minor: [],
            };
        }
    }
    exports.YearsTicker = YearsTicker;
    YearsTicker.__name__ = "YearsTicker";
},
/* models/axes/log_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_axis_1 = require(143) /* ./continuous_axis */;
    const log_tick_formatter_1 = require(163) /* ../formatters/log_tick_formatter */;
    const log_ticker_1 = require(164) /* ../tickers/log_ticker */;
    class LogAxisView extends continuous_axis_1.ContinuousAxisView {
    }
    exports.LogAxisView = LogAxisView;
    LogAxisView.__name__ = "LogAxisView";
    class LogAxis extends continuous_axis_1.ContinuousAxis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.LogAxis = LogAxis;
    _a = LogAxis;
    LogAxis.__name__ = "LogAxis";
    (() => {
        _a.prototype.default_view = LogAxisView;
        _a.override({
            ticker: () => new log_ticker_1.LogTicker(),
            formatter: () => new log_tick_formatter_1.LogTickFormatter(),
        });
    })();
},
/* models/formatters/log_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const tick_formatter_1 = require(131) /* ./tick_formatter */;
    const basic_tick_formatter_1 = require(146) /* ./basic_tick_formatter */;
    const log_ticker_1 = require(164) /* ../tickers/log_ticker */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    const { abs, log, round } = Math;
    class LogTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this.basic_formatter = new basic_tick_formatter_1.BasicTickFormatter();
        }
        format_graphics(ticks, opts) {
            var _b, _c;
            if (ticks.length == 0)
                return [];
            const base = (_c = (_b = this.ticker) === null || _b === void 0 ? void 0 : _b.base) !== null && _c !== void 0 ? _c : 10;
            const expos = this._exponents(ticks, base);
            if (expos == null)
                return this.basic_formatter.format_graphics(ticks, opts);
            else {
                return expos.map((expo) => {
                    if (abs(expo) < this.min_exponent) {
                        const b = new graphics_1.TextBox({ text: (0, basic_tick_formatter_1.unicode_replace)(`${base ** expo}`) });
                        const e = new graphics_1.TextBox({ text: "" });
                        return new graphics_1.BaseExpo(b, e);
                    }
                    else {
                        const b = new graphics_1.TextBox({ text: (0, basic_tick_formatter_1.unicode_replace)(`${base}`) });
                        const e = new graphics_1.TextBox({ text: (0, basic_tick_formatter_1.unicode_replace)(`${expo}`) });
                        return new graphics_1.BaseExpo(b, e);
                    }
                });
            }
        }
        _exponents(ticks, base) {
            let last_exponent = null;
            const exponents = [];
            for (const tick of ticks) {
                const exponent = round(log(tick) / log(base));
                if (last_exponent != exponent) {
                    last_exponent = exponent;
                    exponents.push(exponent);
                }
                else
                    return null;
            }
            return exponents;
        }
        doFormat(ticks, opts) {
            var _b, _c;
            if (ticks.length == 0)
                return [];
            const base = (_c = (_b = this.ticker) === null || _b === void 0 ? void 0 : _b.base) !== null && _c !== void 0 ? _c : 10;
            const expos = this._exponents(ticks, base);
            if (expos == null)
                return this.basic_formatter.doFormat(ticks, opts);
            else
                return expos.map((expo) => {
                    if (abs(expo) < this.min_exponent)
                        return (0, basic_tick_formatter_1.unicode_replace)(`${base ** expo}`);
                    else
                        return (0, basic_tick_formatter_1.unicode_replace)(`${base}^${expo}`);
                });
        }
    }
    exports.LogTickFormatter = LogTickFormatter;
    _a = LogTickFormatter;
    LogTickFormatter.__name__ = "LogTickFormatter";
    (() => {
        _a.define(({ Int, Ref, Nullable }) => ({
            ticker: [Nullable(Ref(log_ticker_1.LogTicker)), null],
            min_exponent: [Int, 0],
        }));
    })();
},
/* models/tickers/log_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const adaptive_ticker_1 = require(148) /* ./adaptive_ticker */;
    const array_1 = require(9) /* ../../core/util/array */;
    class LogTicker extends adaptive_ticker_1.AdaptiveTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks_no_defaults(data_low, data_high, _cross_loc, desired_n_ticks) {
            const num_minor_ticks = this.num_minor_ticks;
            const minor_ticks = [];
            const base = this.base;
            const log_low = Math.log(data_low) / Math.log(base);
            const log_high = Math.log(data_high) / Math.log(base);
            const log_interval = log_high - log_low;
            let ticks;
            if (!isFinite(log_interval)) {
                ticks = [];
            }
            else if (log_interval < 2) { // treat as linear ticker
                const interval = this.get_interval(data_low, data_high, desired_n_ticks);
                const start_factor = Math.floor(data_low / interval);
                const end_factor = Math.ceil(data_high / interval);
                ticks = (0, array_1.range)(start_factor, end_factor + 1)
                    .filter((factor) => factor != 0)
                    .map((factor) => factor * interval)
                    .filter((tick) => data_low <= tick && tick <= data_high);
                if (num_minor_ticks > 0 && ticks.length > 0) {
                    const minor_interval = interval / num_minor_ticks;
                    const minor_offsets = (0, array_1.range)(0, num_minor_ticks).map((i) => i * minor_interval);
                    for (const x of minor_offsets.slice(1)) {
                        minor_ticks.push(ticks[0] - x);
                    }
                    for (const tick of ticks) {
                        for (const x of minor_offsets) {
                            minor_ticks.push(tick + x);
                        }
                    }
                }
            }
            else {
                const startlog = Math.ceil(log_low * 0.999999);
                const endlog = Math.floor(log_high * 1.000001);
                const interval = Math.ceil((endlog - startlog) / 9.0);
                ticks = (0, array_1.range)(startlog - 1, endlog + 1, interval)
                    .map((i) => base ** i);
                if (num_minor_ticks > 0 && ticks.length > 0) {
                    const minor_interval = base ** interval / num_minor_ticks;
                    const minor_offsets = (0, array_1.range)(1, num_minor_ticks + 1).map((i) => i * minor_interval);
                    for (const x of minor_offsets) {
                        minor_ticks.push(ticks[0] / x);
                    }
                    minor_ticks.push(ticks[0]);
                    for (const tick of ticks) {
                        for (const x of minor_offsets) {
                            minor_ticks.push(tick * x);
                        }
                    }
                }
            }
            return {
                major: ticks.filter((tick) => data_low <= tick && tick <= data_high),
                minor: minor_ticks.filter((tick) => data_low <= tick && tick <= data_high),
            };
        }
    }
    exports.LogTicker = LogTicker;
    _a = LogTicker;
    LogTicker.__name__ = "LogTicker";
    (() => {
        _a.override({
            mantissas: [1, 5],
        });
    })();
},
/* models/axes/mercator_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const axis_1 = require(128) /* ./axis */;
    const linear_axis_1 = require(145) /* ./linear_axis */;
    const mercator_tick_formatter_1 = require(166) /* ../formatters/mercator_tick_formatter */;
    const mercator_ticker_1 = require(167) /* ../tickers/mercator_ticker */;
    class MercatorAxisView extends axis_1.AxisView {
    }
    exports.MercatorAxisView = MercatorAxisView;
    MercatorAxisView.__name__ = "MercatorAxisView";
    class MercatorAxis extends linear_axis_1.LinearAxis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MercatorAxis = MercatorAxis;
    _a = MercatorAxis;
    MercatorAxis.__name__ = "MercatorAxis";
    (() => {
        _a.prototype.default_view = MercatorAxisView;
        _a.override({
            ticker: () => new mercator_ticker_1.MercatorTicker({ dimension: "lat" }),
            formatter: () => new mercator_tick_formatter_1.MercatorTickFormatter({ dimension: "lat" }),
        });
    })();
},
/* models/formatters/mercator_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const basic_tick_formatter_1 = require(146) /* ./basic_tick_formatter */;
    const enums_1 = require(20) /* ../../core/enums */;
    const projections_1 = require(78) /* ../../core/util/projections */;
    class MercatorTickFormatter extends basic_tick_formatter_1.BasicTickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        doFormat(ticks, opts) {
            if (this.dimension == null)
                throw new Error("MercatorTickFormatter.dimension not configured");
            if (ticks.length == 0)
                return [];
            const n = ticks.length;
            const proj_ticks = new Array(n);
            if (this.dimension == "lon") {
                for (let i = 0; i < n; i++) {
                    const [lon] = projections_1.wgs84_mercator.invert(ticks[i], opts.loc);
                    proj_ticks[i] = lon;
                }
            }
            else {
                for (let i = 0; i < n; i++) {
                    const [, lat] = projections_1.wgs84_mercator.invert(opts.loc, ticks[i]);
                    proj_ticks[i] = lat;
                }
            }
            return super.doFormat(proj_ticks, opts);
        }
    }
    exports.MercatorTickFormatter = MercatorTickFormatter;
    _a = MercatorTickFormatter;
    MercatorTickFormatter.__name__ = "MercatorTickFormatter";
    (() => {
        _a.define(({ Nullable }) => ({
            dimension: [Nullable(enums_1.LatLon), null],
        }));
    })();
},
/* models/tickers/mercator_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const basic_ticker_1 = require(147) /* ./basic_ticker */;
    const enums_1 = require(20) /* ../../core/enums */;
    const projections_1 = require(78) /* ../../core/util/projections */;
    class MercatorTicker extends basic_ticker_1.BasicTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks) {
            if (this.dimension == null) {
                throw new Error(`${this}.dimension wasn't configured`);
            }
            [data_low, data_high] = (0, projections_1.clip_mercator)(data_low, data_high, this.dimension);
            if (this.dimension == "lon")
                return this._get_ticks_lon(data_low, data_high, cross_loc, desired_n_ticks);
            else
                return this._get_ticks_lat(data_low, data_high, cross_loc, desired_n_ticks);
        }
        _get_ticks_lon(data_low, data_high, cross_loc, desired_n_ticks) {
            const [proj_low] = projections_1.wgs84_mercator.invert(data_low, cross_loc);
            const [proj_high, proj_cross_loc] = projections_1.wgs84_mercator.invert(data_high, cross_loc);
            const proj_ticks = super.get_ticks_no_defaults(proj_low, proj_high, cross_loc, desired_n_ticks);
            const major = [];
            for (const tick of proj_ticks.major) {
                if ((0, projections_1.in_bounds)(tick, "lon")) {
                    const [lon] = projections_1.wgs84_mercator.compute(tick, proj_cross_loc);
                    major.push(lon);
                }
            }
            const minor = [];
            for (const tick of proj_ticks.minor) {
                if ((0, projections_1.in_bounds)(tick, "lon")) {
                    const [lon] = projections_1.wgs84_mercator.compute(tick, proj_cross_loc);
                    minor.push(lon);
                }
            }
            return { major, minor };
        }
        _get_ticks_lat(data_low, data_high, cross_loc, desired_n_ticks) {
            const [, proj_low] = projections_1.wgs84_mercator.invert(cross_loc, data_low);
            const [proj_cross_loc, proj_high] = projections_1.wgs84_mercator.invert(cross_loc, data_high);
            const proj_ticks = super.get_ticks_no_defaults(proj_low, proj_high, cross_loc, desired_n_ticks);
            const major = [];
            for (const tick of proj_ticks.major) {
                if ((0, projections_1.in_bounds)(tick, "lat")) {
                    const [, lat] = projections_1.wgs84_mercator.compute(proj_cross_loc, tick);
                    major.push(lat);
                }
            }
            const minor = [];
            for (const tick of proj_ticks.minor) {
                if ((0, projections_1.in_bounds)(tick, "lat")) {
                    const [, lat] = projections_1.wgs84_mercator.compute(proj_cross_loc, tick);
                    minor.push(lat);
                }
            }
            return { major, minor };
        }
    }
    exports.MercatorTicker = MercatorTicker;
    _a = MercatorTicker;
    MercatorTicker.__name__ = "MercatorTicker";
    (() => {
        _a.define(({ Nullable }) => ({
            dimension: [Nullable(enums_1.LatLon), null],
        }));
    })();
},
/* models/tickers/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var adaptive_ticker_1 = require(148) /* ./adaptive_ticker */;
    __esExport("AdaptiveTicker", adaptive_ticker_1.AdaptiveTicker);
    var basic_ticker_1 = require(147) /* ./basic_ticker */;
    __esExport("BasicTicker", basic_ticker_1.BasicTicker);
    var categorical_ticker_1 = require(141) /* ./categorical_ticker */;
    __esExport("CategoricalTicker", categorical_ticker_1.CategoricalTicker);
    var composite_ticker_1 = require(156) /* ./composite_ticker */;
    __esExport("CompositeTicker", composite_ticker_1.CompositeTicker);
    var continuous_ticker_1 = require(149) /* ./continuous_ticker */;
    __esExport("ContinuousTicker", continuous_ticker_1.ContinuousTicker);
    var datetime_ticker_1 = require(155) /* ./datetime_ticker */;
    __esExport("DatetimeTicker", datetime_ticker_1.DatetimeTicker);
    var days_ticker_1 = require(157) /* ./days_ticker */;
    __esExport("DaysTicker", days_ticker_1.DaysTicker);
    var fixed_ticker_1 = require(169) /* ./fixed_ticker */;
    __esExport("FixedTicker", fixed_ticker_1.FixedTicker);
    var log_ticker_1 = require(164) /* ./log_ticker */;
    __esExport("LogTicker", log_ticker_1.LogTicker);
    var mercator_ticker_1 = require(167) /* ./mercator_ticker */;
    __esExport("MercatorTicker", mercator_ticker_1.MercatorTicker);
    var months_ticker_1 = require(160) /* ./months_ticker */;
    __esExport("MonthsTicker", months_ticker_1.MonthsTicker);
    var single_interval_ticker_1 = require(158) /* ./single_interval_ticker */;
    __esExport("SingleIntervalTicker", single_interval_ticker_1.SingleIntervalTicker);
    var ticker_1 = require(130) /* ./ticker */;
    __esExport("Ticker", ticker_1.Ticker);
    var years_ticker_1 = require(161) /* ./years_ticker */;
    __esExport("YearsTicker", years_ticker_1.YearsTicker);
    var binned_ticker_1 = require(170) /* ./binned_ticker */;
    __esExport("BinnedTicker", binned_ticker_1.BinnedTicker);
},
/* models/tickers/fixed_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_ticker_1 = require(149) /* ./continuous_ticker */;
    class FixedTicker extends continuous_ticker_1.ContinuousTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks_no_defaults(_data_low, _data_high, _cross_loc, _desired_n_ticks) {
            return {
                major: this.ticks,
                minor: this.minor_ticks,
            };
        }
        // XXX: whatever, because FixedTicker needs to fulfill the interface somehow
        get_interval(_data_low, _data_high, _desired_n_ticks) {
            return 0;
        }
        get_min_interval() {
            return 0;
        }
        get_max_interval() {
            return 0;
        }
    }
    exports.FixedTicker = FixedTicker;
    _a = FixedTicker;
    FixedTicker.__name__ = "FixedTicker";
    (() => {
        _a.define(({ Number, Array }) => ({
            ticks: [Array(Number), []],
            minor_ticks: [Array(Number), []],
        }));
    })();
},
/* models/tickers/binned_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const ticker_1 = require(130) /* ./ticker */;
    const scanning_color_mapper_1 = require(171) /* ../mappers/scanning_color_mapper */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    class BinnedTicker extends ticker_1.Ticker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks(data_low, data_high, _range, _cross_loc) {
            const { binning } = this.mapper.metrics;
            const k_low = Math.max(0, (0, arrayable_1.left_edge_index)(data_low, binning));
            const k_high = Math.min((0, arrayable_1.left_edge_index)(data_high, binning) + 1, binning.length - 1);
            const _major = [];
            for (let k = k_low; k <= k_high; k++) {
                _major.push(binning[k]);
            }
            const { num_major_ticks } = this;
            const major = [];
            const n = num_major_ticks == "auto" ? _major.length : num_major_ticks;
            const step = Math.max(1, Math.floor(_major.length / n));
            for (let i = 0; i < _major.length; i += step) {
                major.push(_major[i]);
            }
            return {
                major,
                minor: [],
            };
        }
    }
    exports.BinnedTicker = BinnedTicker;
    _a = BinnedTicker;
    BinnedTicker.__name__ = "BinnedTicker";
    (() => {
        _a.define(({ Number, Ref, Or, Auto }) => ({
            mapper: [Ref(scanning_color_mapper_1.ScanningColorMapper)],
            num_major_ticks: [Or(Number, Auto), 8],
        }));
    })();
},
/* models/mappers/scanning_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_color_mapper_1 = require(172) /* ./continuous_color_mapper */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    class ScanningColorMapper extends continuous_color_mapper_1.ContinuousColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        cmap(d, palette, low_color, high_color, edges) {
            if (d < edges.binning[0])
                return low_color;
            if (d > edges.binning[edges.binning.length - 1])
                return high_color;
            const key = (0, arrayable_1.left_edge_index)(d, edges.binning);
            return palette[key];
        }
    }
    exports.ScanningColorMapper = ScanningColorMapper;
    ScanningColorMapper.__name__ = "ScanningColorMapper";
},
/* models/mappers/continuous_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const color_mapper_1 = require(173) /* ./color_mapper */;
    const glyph_renderer_1 = require(175) /* ../renderers/glyph_renderer */;
    const array_1 = require(9) /* ../../core/util/array */;
    const types_1 = require(8) /* ../../core/util/types */;
    class ContinuousColorMapper extends color_mapper_1.ColorMapper {
        constructor(attrs) {
            super(attrs);
            this._scan_data = null;
        }
        connect_signals() {
            super.connect_signals();
            const connect_renderers = () => {
                // TODO: if already connected this will bail. However, it won't remove old connections.
                for (const [renderer] of this.domain) {
                    this.connect(renderer.view.change, () => this.update_data());
                    this.connect(renderer.data_source.selected.change, () => this.update_data());
                }
            };
            this.connect(this.properties.domain.change, () => connect_renderers());
            connect_renderers();
        }
        update_data() {
            const { domain, palette } = this;
            const all_data = [...this._collect(domain)];
            this._scan_data = this.scan(all_data, palette.length);
            this.metrics_change.emit();
            this.change.emit();
        }
        get metrics() {
            if (this._scan_data == null) {
                this.update_data();
            }
            return this._scan_data;
        }
        *_collect(domain) {
            for (const [renderer, fields] of domain) {
                for (const field of (0, types_1.isArray)(fields) ? fields : [fields]) {
                    let array = renderer.data_source.get_column(field);
                    array = renderer.view.indices.select(array);
                    const masked = renderer.view.masked;
                    const selected = renderer.data_source.selected.indices;
                    let subset;
                    if (masked != null && selected.length > 0)
                        subset = (0, array_1.intersection)([...masked], selected);
                    else if (masked != null)
                        subset = [...masked];
                    else if (selected.length > 0)
                        subset = selected;
                    if (subset != null) {
                        array = (0, array_1.map)(subset, (i) => array[i]);
                    }
                    if (array.length > 0 && !(0, types_1.isNumber)(array[0])) {
                        for (const subarray of array) {
                            yield* subarray;
                        }
                    }
                    else {
                        yield* array;
                    }
                }
            }
        }
        _v_compute(data, values, palette, colors) {
            const { nan_color } = colors;
            let { low_color, high_color } = colors;
            if (low_color == null)
                low_color = palette[0];
            if (high_color == null)
                high_color = palette[palette.length - 1];
            const { domain } = this;
            const all_data = !(0, array_1.is_empty)(domain) ? [...this._collect(domain)] : data;
            this._scan_data = this.scan(all_data, palette.length);
            this.metrics_change.emit();
            for (let i = 0, end = data.length; i < end; i++) {
                const d = data[i];
                if (isNaN(d))
                    values[i] = nan_color;
                else
                    values[i] = this.cmap(d, palette, low_color, high_color, this._scan_data);
            }
        }
        _colors(conv) {
            return Object.assign(Object.assign({}, super._colors(conv)), { low_color: this.low_color != null ? conv(this.low_color) : undefined, high_color: this.high_color != null ? conv(this.high_color) : undefined });
        }
    }
    exports.ContinuousColorMapper = ContinuousColorMapper;
    _a = ContinuousColorMapper;
    ContinuousColorMapper.__name__ = "ContinuousColorMapper";
    (() => {
        _a.define(({ Number, String, Ref, Color, Or, Tuple, Array, Nullable }) => {
            return {
                high: [Nullable(Number), null],
                low: [Nullable(Number), null],
                high_color: [Nullable(Color), null],
                low_color: [Nullable(Color), null],
                domain: [Array(Tuple(Ref(glyph_renderer_1.GlyphRenderer), Or(String, Array(String)))), []],
            };
        });
    })();
},
/* models/mappers/color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const mapper_1 = require(174) /* ./mapper */;
    const signaling_1 = require(15) /* ../../core/signaling */;
    const types_1 = require(24) /* ../../core/types */;
    const color_1 = require(22) /* ../../core/util/color */;
    const platform_1 = require(27) /* ../../core/util/platform */;
    // export for testing
    function _convert_color(color) {
        return (0, color_1.encode_rgba)((0, color_1.color2rgba)(color));
    }
    exports._convert_color = _convert_color;
    // export for testing
    function _convert_palette(palette) {
        const new_palette = new Uint32Array(palette.length);
        for (let i = 0, end = palette.length; i < end; i++)
            new_palette[i] = _convert_color(palette[i]);
        return new_palette;
    }
    exports._convert_palette = _convert_palette;
    class ColorMapper extends mapper_1.Mapper {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this.metrics_change = new signaling_1.Signal0(this, "metrics_change");
        }
        v_compute(xs) {
            const values = new Array(xs.length);
            this._v_compute(xs, values, this.palette, this._colors((c) => c));
            return values;
        }
        get rgba_mapper() {
            const self = this;
            const palette = _convert_palette(this.palette);
            const colors = this._colors(_convert_color);
            return {
                v_compute(xs) {
                    const values = new types_1.ColorArray(xs.length);
                    self._v_compute(xs, values, palette, colors);
                    return new Uint8ClampedArray((0, platform_1.to_big_endian)(values).buffer);
                },
            };
        }
        _colors(conv) {
            return { nan_color: conv(this.nan_color) };
        }
    }
    exports.ColorMapper = ColorMapper;
    _a = ColorMapper;
    ColorMapper.__name__ = "ColorMapper";
    (() => {
        _a.define(({ Color, Array }) => ({
            palette: [Array(Color)],
            nan_color: [Color, "gray"],
        }));
    })();
},
/* models/mappers/mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const transform_1 = require(56) /* ../transforms/transform */;
    class Mapper extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        compute(_x) {
            // If it's just a single value, then a mapper doesn't really make sense.
            throw new Error("mapping single values is not supported");
        }
    }
    exports.Mapper = Mapper;
    Mapper.__name__ = "Mapper";
},
/* models/renderers/glyph_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const data_renderer_1 = require(176) /* ./data_renderer */;
    const line_1 = require(177) /* ../glyphs/line */;
    const patch_1 = require(186) /* ../glyphs/patch */;
    const harea_1 = require(187) /* ../glyphs/harea */;
    const varea_1 = require(189) /* ../glyphs/varea */;
    const glyph_1 = require(179) /* ../glyphs/glyph */;
    const columnar_data_source_1 = require(70) /* ../sources/columnar_data_source */;
    const cds_view_1 = require(190) /* ../sources/cds_view */;
    const types_1 = require(24) /* ../../core/types */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const object_1 = require(13) /* ../../core/util/object */;
    const build_views_1 = require(113) /* ../../core/build_views */;
    const factor_range_1 = require(67) /* ../ranges/factor_range */;
    const selection_defaults = {
        fill: {},
        line: {},
    };
    const decimated_defaults = {
        fill: { fill_alpha: 0.3, fill_color: "grey" },
        line: { line_alpha: 0.3, line_color: "grey" },
    };
    const nonselection_defaults = {
        fill: { fill_alpha: 0.2 },
        line: {},
    };
    const muted_defaults = {
        fill: { fill_alpha: 0.2 },
        line: {},
    };
    class GlyphRendererView extends data_renderer_1.DataRendererView {
        get glyph_view() {
            return this.glyph;
        }
        async lazy_initialize() {
            var _b;
            await super.lazy_initialize();
            const base_glyph = this.model.glyph;
            this.glyph = await this.build_glyph_view(base_glyph);
            const has_fill = "fill" in this.glyph.visuals;
            const has_line = "line" in this.glyph.visuals;
            const glyph_attrs = Object.assign({}, base_glyph.attributes);
            delete glyph_attrs.id;
            function mk_glyph(defaults) {
                const attrs = (0, object_1.clone)(glyph_attrs);
                if (has_fill)
                    (0, object_1.extend)(attrs, defaults.fill);
                if (has_line)
                    (0, object_1.extend)(attrs, defaults.line);
                return new base_glyph.constructor(attrs);
            }
            function glyph_from_mode(defaults, glyph) {
                if (glyph instanceof glyph_1.Glyph) {
                    return glyph;
                }
                else if (glyph == "auto") {
                    return mk_glyph(defaults);
                }
                return mk_glyph({ fill: {}, line: {} });
            }
            let { selection_glyph, nonselection_glyph, hover_glyph, muted_glyph } = this.model;
            selection_glyph = glyph_from_mode(selection_defaults, selection_glyph);
            this.selection_glyph = await this.build_glyph_view(selection_glyph);
            nonselection_glyph = glyph_from_mode(nonselection_defaults, nonselection_glyph);
            this.nonselection_glyph = await this.build_glyph_view(nonselection_glyph);
            if (hover_glyph != null)
                this.hover_glyph = await this.build_glyph_view(hover_glyph);
            muted_glyph = glyph_from_mode(muted_defaults, muted_glyph);
            this.muted_glyph = await this.build_glyph_view(muted_glyph);
            const decimated_glyph = glyph_from_mode(decimated_defaults, "auto");
            this.decimated_glyph = await this.build_glyph_view(decimated_glyph);
            this.selection_glyph.set_base(this.glyph);
            this.nonselection_glyph.set_base(this.glyph);
            (_b = this.hover_glyph) === null || _b === void 0 ? void 0 : _b.set_base(this.glyph);
            this.muted_glyph.set_base(this.glyph);
            this.decimated_glyph.set_base(this.glyph);
            this.set_data();
        }
        async build_glyph_view(glyph) {
            return (0, build_views_1.build_view)(glyph, { parent: this });
        }
        remove() {
            var _b;
            this.glyph.remove();
            this.selection_glyph.remove();
            this.nonselection_glyph.remove();
            (_b = this.hover_glyph) === null || _b === void 0 ? void 0 : _b.remove();
            this.muted_glyph.remove();
            this.decimated_glyph.remove();
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            const render = () => this.request_render();
            const update = () => this.update_data();
            this.connect(this.model.change, render);
            this.connect(this.glyph.model.change, update);
            this.connect(this.selection_glyph.model.change, update);
            this.connect(this.nonselection_glyph.model.change, update);
            if (this.hover_glyph != null)
                this.connect(this.hover_glyph.model.change, update);
            this.connect(this.muted_glyph.model.change, update);
            this.connect(this.decimated_glyph.model.change, update);
            this.connect(this.model.data_source.change, update);
            this.connect(this.model.data_source.streaming, update);
            this.connect(this.model.data_source.patching, (indices) => this.update_data(indices));
            this.connect(this.model.data_source.selected.change, render);
            this.connect(this.model.data_source._select, render);
            if (this.hover_glyph != null)
                this.connect(this.model.data_source.inspect, render);
            this.connect(this.model.properties.view.change, update);
            this.connect(this.model.view.properties.indices.change, update);
            this.connect(this.model.view.properties.masked.change, () => this.set_visuals());
            this.connect(this.model.properties.visible.change, () => this.plot_view.invalidate_dataranges = true);
            const { x_ranges, y_ranges } = this.plot_view.frame;
            for (const [, range] of x_ranges) {
                if (range instanceof factor_range_1.FactorRange)
                    this.connect(range.change, update);
            }
            for (const [, range] of y_ranges) {
                if (range instanceof factor_range_1.FactorRange)
                    this.connect(range.change, update);
            }
            const { transformchange, exprchange } = this.model.glyph;
            this.connect(transformchange, update);
            this.connect(exprchange, update);
        }
        _update_masked_indices() {
            const masked = this.glyph.mask_data();
            this.model.view.masked = masked;
            return masked;
        }
        update_data(indices) {
            this.set_data(indices);
            this.request_render();
        }
        // in case of partial updates like patching, the list of indices that actually
        // changed may be passed as the "indices" parameter to afford any optional optimizations
        set_data(indices) {
            const source = this.model.data_source;
            this.all_indices = this.model.view.indices;
            const { all_indices } = this;
            this.glyph.set_data(source, all_indices, indices);
            this.set_visuals();
            this._update_masked_indices();
            const { lod_factor } = this.plot_model;
            const n = this.all_indices.count;
            this.decimated = new types_1.Indices(n);
            for (let i = 0; i < n; i += lod_factor) {
                this.decimated.set(i);
            }
            this.plot_view.invalidate_dataranges = true;
        }
        set_visuals() {
            var _b;
            const source = this.model.data_source;
            const { all_indices } = this;
            this.glyph.set_visuals(source, all_indices);
            this.decimated_glyph.set_visuals(source, all_indices);
            this.selection_glyph.set_visuals(source, all_indices);
            this.nonselection_glyph.set_visuals(source, all_indices);
            (_b = this.hover_glyph) === null || _b === void 0 ? void 0 : _b.set_visuals(source, all_indices);
            this.muted_glyph.set_visuals(source, all_indices);
        }
        get has_webgl() {
            return this.glyph.has_webgl;
        }
        _render() {
            const glsupport = this.has_webgl;
            this.glyph.map_data();
            // all_indices is in full data space, indices is converted to subset space by mask_data (that may use the spatial index)
            const all_indices = [...this.all_indices];
            let indices = [...this._update_masked_indices()];
            const { ctx } = this.layer;
            ctx.save();
            // selected is in full set space
            const { selected } = this.model.data_source;
            let selected_full_indices;
            if (!selected || selected.is_empty())
                selected_full_indices = [];
            else {
                if (this.glyph instanceof line_1.LineView && selected.selected_glyph === this.glyph.model)
                    selected_full_indices = this.model.view.convert_indices_from_subset(indices);
                else
                    selected_full_indices = selected.indices;
            }
            // inspected is in full set space
            const { inspected } = this.model.data_source;
            const inspected_full_indices = new Set((() => {
                if (!inspected || inspected.is_empty())
                    return [];
                else {
                    if (inspected.selected_glyph)
                        return this.model.view.convert_indices_from_subset(indices);
                    else if (inspected.indices.length > 0)
                        return inspected.indices;
                    else {
                        // TODO: return inspected.multiline_indices.keys()
                        return Object.keys(inspected.multiline_indices).map((i) => parseInt(i));
                    }
                }
            })());
            // inspected is transformed to subset space
            const inspected_subset_indices = (0, arrayable_1.filter)(indices, (i) => inspected_full_indices.has(all_indices[i]));
            const { lod_threshold } = this.plot_model;
            let glyph;
            let nonselection_glyph;
            let selection_glyph;
            if ((this.model.document != null ? this.model.document.interactive_duration() > 0 : false)
                && !glsupport && lod_threshold != null && all_indices.length > lod_threshold) {
                // Render decimated during interaction if too many elements and not using GL
                indices = [...this.decimated];
                glyph = this.decimated_glyph;
                nonselection_glyph = this.decimated_glyph;
                selection_glyph = this.selection_glyph;
            }
            else {
                glyph = this.model.muted ? this.muted_glyph : this.glyph;
                nonselection_glyph = this.nonselection_glyph;
                selection_glyph = this.selection_glyph;
            }
            if (this.hover_glyph != null && inspected_subset_indices.length) {
                // TODO: keep working on Indices instead of converting back and forth
                const set = new Set(indices);
                for (const i of inspected_subset_indices) {
                    set.delete(i);
                }
                indices = [...set];
            }
            // Render with no selection
            if (!selected_full_indices.length) {
                if (this.glyph instanceof line_1.LineView) {
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices));
                    else
                        glyph.render(ctx, all_indices);
                }
                else if (this.glyph instanceof patch_1.PatchView || this.glyph instanceof harea_1.HAreaView || this.glyph instanceof varea_1.VAreaView) {
                    if (inspected.selected_glyphs.length == 0 || this.hover_glyph == null) {
                        glyph.render(ctx, all_indices);
                    }
                    else {
                        for (const sglyph of inspected.selected_glyphs) {
                            if (sglyph == this.glyph.model)
                                this.hover_glyph.render(ctx, all_indices);
                        }
                    }
                }
                else {
                    glyph.render(ctx, indices);
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, inspected_subset_indices);
                }
                // Render with selection
            }
            else {
                // reset the selection mask
                const selected_mask = {};
                for (const i of selected_full_indices) {
                    selected_mask[i] = true;
                }
                // intersect/different selection with render mask
                const selected_subset_indices = new Array();
                const nonselected_subset_indices = new Array();
                // now, selected is changed to subset space, except for Line glyph
                if (this.glyph instanceof line_1.LineView) {
                    for (const i of all_indices) {
                        if (selected_mask[i] != null)
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                }
                else {
                    for (const i of indices) {
                        if (selected_mask[all_indices[i]] != null)
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                }
                nonselection_glyph.render(ctx, nonselected_subset_indices);
                selection_glyph.render(ctx, selected_subset_indices);
                if (this.hover_glyph != null) {
                    if (this.glyph instanceof line_1.LineView)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices));
                    else
                        this.hover_glyph.render(ctx, inspected_subset_indices);
                }
            }
            ctx.restore();
        }
        draw_legend(ctx, x0, x1, y0, y1, field, label, index) {
            if (this.glyph.data_size == 0)
                return;
            if (index == null)
                index = this.model.get_reference_point(field, label);
            this.glyph.draw_legend_for_index(ctx, { x0, x1, y0, y1 }, index);
        }
        hit_test(geometry) {
            if (!this.model.visible)
                return null;
            const hit_test_result = this.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result == null)
                return null;
            return this.model.view.convert_selection_from_subset(hit_test_result);
        }
    }
    exports.GlyphRendererView = GlyphRendererView;
    GlyphRendererView.__name__ = "GlyphRendererView";
    class GlyphRenderer extends data_renderer_1.DataRenderer {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            if (this.view.source != this.data_source) {
                this.view.source = this.data_source;
                this.view.compute_indices();
            }
        }
        get_reference_point(field, value) {
            if (field != null) {
                const data = this.data_source.get_column(field);
                if (data != null) {
                    for (const [key, index] of Object.entries(this.view.indices_map)) {
                        if (data[parseInt(key)] == value)
                            return index;
                    }
                }
            }
            return 0;
        }
        get_selection_manager() {
            return this.data_source.selection_manager;
        }
    }
    exports.GlyphRenderer = GlyphRenderer;
    _a = GlyphRenderer;
    GlyphRenderer.__name__ = "GlyphRenderer";
    (() => {
        _a.prototype.default_view = GlyphRendererView;
        _a.define(({ Boolean, Auto, Or, Ref, Null, Nullable }) => ({
            data_source: [Ref(columnar_data_source_1.ColumnarDataSource)],
            view: [Ref(cds_view_1.CDSView), (self) => new cds_view_1.CDSView({ source: self.data_source })],
            glyph: [Ref(glyph_1.Glyph)],
            hover_glyph: [Nullable(Ref(glyph_1.Glyph)), null],
            nonselection_glyph: [Or(Ref(glyph_1.Glyph), Auto, Null), "auto"],
            selection_glyph: [Or(Ref(glyph_1.Glyph), Auto, Null), "auto"],
            muted_glyph: [Or(Ref(glyph_1.Glyph), Auto, Null), "auto"],
            muted: [Boolean, false],
        }));
    })();
},
/* models/renderers/data_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const renderer_1 = require(41) /* ./renderer */;
    class DataRendererView extends renderer_1.RendererView {
        get xscale() {
            return this.coordinates.x_scale;
        }
        get yscale() {
            return this.coordinates.y_scale;
        }
    }
    exports.DataRendererView = DataRendererView;
    DataRendererView.__name__ = "DataRendererView";
    class DataRenderer extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
        get selection_manager() {
            return this.get_selection_manager();
        }
    }
    exports.DataRenderer = DataRenderer;
    _a = DataRenderer;
    DataRenderer.__name__ = "DataRenderer";
    (() => {
        _a.override({
            level: "glyph",
        });
    })();
},
/* models/glyphs/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const xy_glyph_1 = require(178) /* ./xy_glyph */;
    const utils_1 = require(184) /* ./utils */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const hittest = (0, tslib_1.__importStar)(require(185) /* ../../core/hittest */);
    const selection_1 = require(72) /* ../selections/selection */;
    class LineView extends xy_glyph_1.XYGlyphView {
        async lazy_initialize() {
            await super.lazy_initialize();
            const { webgl } = this.renderer.plot_view.canvas_view;
            if (webgl === null || webgl === void 0 ? void 0 : webgl.regl_wrapper.has_webgl) {
                const { LineGL } = await Promise.resolve().then(() => (0, tslib_1.__importStar)(require(421) /* ./webgl/line_gl */));
                this.glglyph = new LineGL(webgl.regl_wrapper, this);
            }
        }
        _render(ctx, indices, data) {
            const { sx, sy } = data !== null && data !== void 0 ? data : this;
            let last_i = null;
            const gap = (i) => last_i != null && i - last_i != 1;
            let move = true;
            ctx.beginPath();
            for (const i of indices) {
                const sx_i = sx[i];
                const sy_i = sy[i];
                if (!isFinite(sx_i + sy_i))
                    move = true;
                else {
                    if (move || gap(i)) {
                        ctx.moveTo(sx_i, sy_i);
                        move = false;
                    }
                    else
                        ctx.lineTo(sx_i, sy_i);
                }
                last_i = i;
            }
            this.visuals.line.set_value(ctx);
            ctx.stroke();
        }
        _hit_point(geometry) {
            /* Check if the point geometry hits this line glyph and return an object
            that describes the hit result:
              Args:
                * geometry (object): object with the following keys
                  * sx (float): screen x coordinate of the point
                  * sy (float): screen y coordinate of the point
                  * type (str): type of geometry (in this case it's a point)
            */
            const result = new selection_1.Selection();
            const point = { x: geometry.sx, y: geometry.sy };
            let shortest = 9999;
            const threshold = Math.max(2, this.line_width.value / 2);
            for (let i = 0, end = this.sx.length - 1; i < end; i++) {
                const p0 = { x: this.sx[i], y: this.sy[i] };
                const p1 = { x: this.sx[i + 1], y: this.sy[i + 1] };
                const dist = hittest.dist_to_segment(point, p0, p1);
                if (dist < threshold && dist < shortest) {
                    shortest = dist;
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices = [i];
                }
            }
            return result;
        }
        _hit_span(geometry) {
            const { sx, sy } = geometry;
            const result = new selection_1.Selection();
            let val;
            let values;
            if (geometry.direction == "v") {
                val = this.renderer.yscale.invert(sy);
                values = this._y;
            }
            else {
                val = this.renderer.xscale.invert(sx);
                values = this._x;
            }
            for (let i = 0, end = values.length - 1; i < end; i++) {
                if ((values[i] <= val && val <= values[i + 1]) || (values[i + 1] <= val && val <= values[i])) {
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices.push(i);
                }
            }
            return result;
        }
        get_interpolation_hit(i, geometry) {
            const [x2, y2, x3, y3] = [this._x[i], this._y[i], this._x[i + 1], this._y[i + 1]];
            return (0, utils_1.line_interpolation)(this.renderer, geometry, x2, y2, x3, y3);
        }
        draw_legend_for_index(ctx, bbox, _index) {
            (0, utils_1.generic_line_scalar_legend)(this.visuals, ctx, bbox);
        }
    }
    exports.LineView = LineView;
    LineView.__name__ = "LineView";
    class Line extends xy_glyph_1.XYGlyph {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Line = Line;
    _a = Line;
    Line.__name__ = "Line";
    (() => {
        _a.prototype.default_view = LineView;
        _a.mixins(mixins.LineScalar);
    })();
},
/* models/glyphs/xy_glyph.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const projections_1 = require(78) /* ../../core/util/projections */;
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    const glyph_1 = require(179) /* ./glyph */;
    class XYGlyphView extends glyph_1.GlyphView {
        _project_data() {
            projections_1.inplace.project_xy(this._x, this._y);
        }
        _index_data(index) {
            const { _x, _y, data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const x = _x[i];
                const y = _y[i];
                index.add_point(x, y);
            }
        }
        scenterxy(i) {
            return [this.sx[i], this.sy[i]];
        }
    }
    exports.XYGlyphView = XYGlyphView;
    XYGlyphView.__name__ = "XYGlyphView";
    class XYGlyph extends glyph_1.Glyph {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.XYGlyph = XYGlyph;
    _a = XYGlyph;
    XYGlyph.__name__ = "XYGlyph";
    (() => {
        _a.define(({}) => ({
            x: [p.XCoordinateSpec, { field: "x" }],
            y: [p.YCoordinateSpec, { field: "y" }],
        }));
    })();
},
/* models/glyphs/glyph.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    const bbox = (0, tslib_1.__importStar)(require(65) /* ../../core/util/bbox */);
    const visuals = (0, tslib_1.__importStar)(require(45) /* ../../core/visuals */);
    const view_1 = require(42) /* ../../core/view */;
    const model_1 = require(53) /* ../../model */;
    const logging_1 = require(19) /* ../../core/logging */;
    const types_1 = require(24) /* ../../core/types */;
    const types_2 = require(8) /* ../../core/util/types */;
    const ragged_array_1 = require(180) /* ../../core/util/ragged_array */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const eq_1 = require(26) /* ../../core/util/eq */;
    const spatial_1 = require(181) /* ../../core/util/spatial */;
    const factor_range_1 = require(67) /* ../ranges/factor_range */;
    const selection_1 = require(72) /* ../selections/selection */;
    const { abs, ceil } = Math;
    class GlyphView extends view_1.View {
        constructor() {
            super(...arguments);
            this._index = null;
            this._data_size = null;
            this._nohit_warned = new Set();
        }
        get renderer() {
            return this.parent;
        }
        get has_webgl() {
            return this.glglyph != null;
        }
        get index() {
            const { _index } = this;
            if (_index != null)
                return _index;
            else
                throw new Error(`${this}.index_data() wasn't called`);
        }
        get data_size() {
            const { _data_size } = this;
            if (_data_size != null)
                return _data_size;
            else
                throw new Error(`${this}.set_data() wasn't called`);
        }
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this);
        }
        request_render() {
            this.parent.request_render();
        }
        get canvas() {
            return this.renderer.parent.canvas_view;
        }
        render(ctx, indices, data) {
            var _a;
            if (this.glglyph != null) {
                this.renderer.needs_webgl_blit = this.glglyph.render(ctx, indices, (_a = this.base) !== null && _a !== void 0 ? _a : this);
                if (this.renderer.needs_webgl_blit)
                    return;
            }
            this._render(ctx, indices, data !== null && data !== void 0 ? data : this.base);
        }
        has_finished() {
            return true;
        }
        notify_finished() {
            this.renderer.notify_finished();
        }
        _bounds(bounds) {
            return bounds;
        }
        bounds() {
            return this._bounds(this.index.bbox);
        }
        log_bounds() {
            const { x0, x1 } = this.index.bounds(bbox.positive_x());
            const { y0, y1 } = this.index.bounds(bbox.positive_y());
            return this._bounds({ x0, y0, x1, y1 });
        }
        get_anchor_point(anchor, i, [sx, sy]) {
            switch (anchor) {
                case "center":
                case "center_center": {
                    const [x, y] = this.scenterxy(i, sx, sy);
                    return { x, y };
                }
                default:
                    return null;
            }
        }
        /** @deprecated */
        scenterx(i, sx, sy) {
            return this.scenterxy(i, sx, sy)[0];
        }
        /** @deprecated */
        scentery(i, sx, sy) {
            return this.scenterxy(i, sx, sy)[1];
        }
        sdist(scale, pts, spans, pts_location = "edge", dilate = false) {
            const n = pts.length;
            const sdist = new types_1.ScreenArray(n);
            const compute = scale.s_compute;
            if (pts_location == "center") {
                for (let i = 0; i < n; i++) {
                    const pts_i = pts[i];
                    const halfspan_i = spans.get(i) / 2;
                    const spt0 = compute(pts_i - halfspan_i);
                    const spt1 = compute(pts_i + halfspan_i);
                    sdist[i] = abs(spt1 - spt0);
                }
            }
            else {
                for (let i = 0; i < n; i++) {
                    const pts_i = pts[i];
                    const spt0 = compute(pts_i);
                    const spt1 = compute(pts_i + spans.get(i));
                    sdist[i] = abs(spt1 - spt0);
                }
            }
            if (dilate)
                (0, arrayable_1.inplace_map)(sdist, (sd) => ceil(sd));
            return sdist;
        }
        draw_legend_for_index(_ctx, _bbox, _index) { }
        hit_test(geometry) {
            switch (geometry.type) {
                case "point":
                    if (this._hit_point != null)
                        return this._hit_point(geometry);
                    break;
                case "span":
                    if (this._hit_span != null)
                        return this._hit_span(geometry);
                    break;
                case "rect":
                    if (this._hit_rect != null)
                        return this._hit_rect(geometry);
                    break;
                case "poly":
                    if (this._hit_poly != null)
                        return this._hit_poly(geometry);
                    break;
            }
            if (!this._nohit_warned.has(geometry.type)) {
                logging_1.logger.debug(`'${geometry.type}' selection not available for ${this.model.type}`);
                this._nohit_warned.add(geometry.type);
            }
            return null;
        }
        _hit_rect_against_index(geometry) {
            const { sx0, sx1, sy0, sy1 } = geometry;
            const [x0, x1] = this.renderer.coordinates.x_scale.r_invert(sx0, sx1);
            const [y0, y1] = this.renderer.coordinates.y_scale.r_invert(sy0, sy1);
            const indices = [...this.index.indices({ x0, x1, y0, y1 })];
            return new selection_1.Selection({ indices });
        }
        _project_data() { }
        *_iter_visuals() {
            for (const visual of this.visuals) {
                for (const prop of visual) {
                    if (prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec)
                        yield prop;
                }
            }
        }
        set_base(base) {
            if (base != this && base instanceof this.constructor)
                this.base = base;
        }
        _configure(prop, descriptor) {
            Object.defineProperty(this, (0, types_2.isString)(prop) ? prop : prop.attr, Object.assign({ configurable: true, enumerable: true }, descriptor));
        }
        set_visuals(source, indices) {
            var _a;
            for (const prop of this._iter_visuals()) {
                const { base } = this;
                if (base != null) {
                    const base_prop = base.model.properties[prop.attr];
                    if (base_prop != null && (0, eq_1.is_equal)(prop.get_value(), base_prop.get_value())) {
                        this._configure(prop, {
                            get() { return base[`${prop.attr}`]; },
                        });
                        continue;
                    }
                }
                const uniform = prop.uniform(source).select(indices);
                this._configure(prop, { value: uniform });
            }
            for (const visual of this.visuals) {
                visual.update();
            }
            this._set_visuals();
            (_a = this.glglyph) === null || _a === void 0 ? void 0 : _a.set_visuals_changed();
        }
        _set_visuals() { }
        set_data(source, indices, indices_to_update) {
            var _a;
            const { x_source, y_source } = this.renderer.coordinates;
            const visual_props = new Set(this._iter_visuals());
            this._data_size = indices.count;
            for (const prop of this.model) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                    continue;
                if (visual_props.has(prop)) // let set_visuals() do the work, at least for now
                    continue;
                if (prop instanceof p.BaseCoordinateSpec) {
                    const base_array = prop.array(source);
                    let array = indices.select(base_array);
                    const range = prop.dimension == "x" ? x_source : y_source;
                    if (range instanceof factor_range_1.FactorRange) {
                        if (prop instanceof p.CoordinateSpec) {
                            array = range.v_synthetic(array);
                        }
                        else if (prop instanceof p.CoordinateSeqSpec) {
                            for (let i = 0; i < array.length; i++) {
                                array[i] = range.v_synthetic(array[i]);
                            }
                        }
                    }
                    let final_array;
                    if (prop instanceof p.CoordinateSeqSpec) {
                        // TODO: infer precision
                        final_array = ragged_array_1.RaggedArray.from(array, Float64Array);
                    }
                    else
                        final_array = array;
                    this._configure(`_${prop.attr}`, { value: final_array });
                }
                else {
                    const uniform = prop.uniform(source).select(indices);
                    this._configure(prop, { value: uniform });
                    if (prop instanceof p.DistanceSpec) {
                        const max_value = uniform.is_Scalar() ? uniform.value : (0, arrayable_1.max)(uniform.array);
                        this._configure(`max_${prop.attr}`, { value: max_value });
                    }
                }
            }
            if (this.renderer.plot_view.model.use_map) {
                this._project_data();
            }
            this._set_data(indices_to_update !== null && indices_to_update !== void 0 ? indices_to_update : null); // TODO doesn't take subset indices into account
            (_a = this.glglyph) === null || _a === void 0 ? void 0 : _a.set_data_changed();
            this.index_data();
        }
        _set_data(_indices) { }
        get _index_size() {
            return this.data_size;
        }
        index_data() {
            const index = new spatial_1.SpatialIndex(this._index_size);
            this._index_data(index);
            index.finish();
            this._index = index;
        }
        mask_data() {
            /** Returns subset indices in the viewport. */
            if (this._mask_data == null)
                return types_1.Indices.all_set(this.data_size);
            else
                return this._mask_data();
        }
        map_data() {
            var _a;
            const self = this;
            const { x_scale, y_scale } = this.renderer.coordinates;
            for (const prop of this.model) {
                if (prop instanceof p.BaseCoordinateSpec) {
                    const scale = prop.dimension == "x" ? x_scale : y_scale;
                    let array = self[`_${prop.attr}`];
                    if (array instanceof ragged_array_1.RaggedArray) {
                        const screen = scale.v_compute(array.array);
                        array = new ragged_array_1.RaggedArray(array.offsets, screen);
                    }
                    else {
                        array = scale.v_compute(array);
                    }
                    this[`s${prop.attr}`] = array;
                }
            }
            this._map_data();
            (_a = this.glglyph) === null || _a === void 0 ? void 0 : _a.set_data_changed();
        }
        // This is where specs not included in coords are computed, e.g. radius.
        _map_data() { }
    }
    exports.GlyphView = GlyphView;
    GlyphView.__name__ = "GlyphView";
    class Glyph extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Glyph = Glyph;
    Glyph.__name__ = "Glyph";
},
/* core/util/ragged_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const eq_1 = require(26) /* ./eq */;
    const assert_1 = require(11) /* ./assert */;
    class RaggedArray {
        constructor(offsets, array) {
            this.offsets = offsets;
            this.array = array;
        }
        [(_a = Symbol.toStringTag, eq_1.equals)](that, cmp) {
            return cmp.arrays(this.offsets, that.offsets) && cmp.arrays(this.array, that.array);
        }
        get length() {
            return this.offsets.length;
        }
        clone() {
            return new RaggedArray(this.offsets.slice(), this.array.slice());
        }
        static from(items, ctor) {
            const n = items.length;
            let offset = 0;
            const offsets = (() => {
                const offsets = new Uint32Array(n);
                for (let i = 0; i < n; i++) {
                    const length = items[i].length;
                    offsets[i] = offset;
                    offset += length;
                }
                if (offset < 256)
                    return new Uint8Array(offsets);
                else if (offset < 65536)
                    return new Uint16Array(offsets);
                else
                    return offsets;
            })();
            const array = new ctor(offset);
            for (let i = 0; i < n; i++) {
                array.set(items[i], offsets[i]);
            }
            return new RaggedArray(offsets, array);
        }
        *[Symbol.iterator]() {
            const { offsets, length } = this;
            for (let i = 0; i < length; i++) {
                yield this.array.subarray(offsets[i], offsets[i + 1]);
            }
        }
        _check_bounds(i) {
            (0, assert_1.assert)(0 <= i && i < this.length, `Out of bounds: 0 <= ${i} < ${this.length}`);
        }
        get(i) {
            this._check_bounds(i);
            const { offsets } = this;
            return this.array.subarray(offsets[i], offsets[i + 1]);
        }
        set(i, array) {
            this._check_bounds(i);
            this.array.set(array, this.offsets[i]);
        }
    }
    exports.RaggedArray = RaggedArray;
    RaggedArray.__name__ = "RaggedArray";
    RaggedArray[_a] = "RaggedArray";
},
/* core/util/spatial.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const flatbush_1 = (0, tslib_1.__importDefault)(require(182) /* flatbush */);
    const types_1 = require(24) /* ../types */;
    const bbox_1 = require(65) /* ./bbox */;
    function upperBound(value, arr) {
        let i = 0;
        let j = arr.length - 1;
        while (i < j) {
            const m = (i + j) >> 1;
            if (arr[m] > value) {
                j = m;
            }
            else {
                i = m + 1;
            }
        }
        return arr[i];
    }
    class _FlatBush extends flatbush_1.default {
        get boxes() {
            return this._boxes;
        }
        search_indices(minX, minY, maxX, maxY) {
            if (this._pos !== this._boxes.length) {
                throw new Error("Data not yet indexed - call index.finish().");
            }
            let nodeIndex = this._boxes.length - 4;
            const queue = [];
            const results = new types_1.Indices(this.numItems);
            while (nodeIndex !== undefined) {
                // find the end index of the node
                const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // search through child nodes
                for (let pos = nodeIndex; pos < end; pos += 4) {
                    const index = this._indices[pos >> 2] | 0;
                    // check if node bbox intersects with query bbox
                    const nodeMinX = this._boxes[pos + 0];
                    const nodeMinY = this._boxes[pos + 1];
                    const nodeMaxX = this._boxes[pos + 2];
                    const nodeMaxY = this._boxes[pos + 3];
                    if (maxX < nodeMinX)
                        continue;
                    if (maxY < nodeMinY)
                        continue;
                    if (minX > nodeMaxX)
                        continue;
                    if (minY > nodeMaxY)
                        continue;
                    if (nodeIndex < this.numItems * 4) {
                        results.set(index); // leaf item
                    }
                    else {
                        queue.push(index); // node; add it to the search queue
                    }
                }
                nodeIndex = queue.pop();
            }
            return results;
        }
    }
    _FlatBush.__name__ = "_FlatBush";
    class SpatialIndex {
        constructor(size) {
            this.index = null;
            if (size > 0) {
                this.index = new _FlatBush(size);
            }
        }
        add_rect(x0, y0, x1, y1) {
            var _a;
            if (!isFinite(x0 + y0 + x1 + y1))
                this.add_empty();
            else
                (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(x0, y0, x1, y1);
        }
        add_point(x, y) {
            var _a;
            if (!isFinite(x + y))
                this.add_empty();
            else
                (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(x, y, x, y);
        }
        add_empty() {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(Infinity, Infinity, -Infinity, -Infinity);
        }
        finish() {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.finish();
        }
        _normalize(rect) {
            let { x0, y0, x1, y1 } = rect;
            if (x0 > x1)
                [x0, x1] = [x1, x0];
            if (y0 > y1)
                [y0, y1] = [y1, y0];
            return { x0, y0, x1, y1 };
        }
        get bbox() {
            if (this.index == null)
                return (0, bbox_1.empty)();
            else {
                const { minX, minY, maxX, maxY } = this.index;
                return { x0: minX, y0: minY, x1: maxX, y1: maxY };
            }
        }
        indices(rect) {
            if (this.index == null)
                return new types_1.Indices(0);
            else {
                const { x0, y0, x1, y1 } = this._normalize(rect);
                return this.index.search_indices(x0, y0, x1, y1);
            }
        }
        bounds(rect) {
            const bounds = (0, bbox_1.empty)();
            if (this.index == null)
                return bounds;
            const { boxes } = this.index;
            for (const i of this.indices(rect)) {
                const x0 = boxes[4 * i + 0];
                const y0 = boxes[4 * i + 1];
                const x1 = boxes[4 * i + 2];
                const y1 = boxes[4 * i + 3];
                if (x0 >= rect.x0 && x0 < bounds.x0)
                    bounds.x0 = x0;
                if (x1 <= rect.x1 && x1 > bounds.x1)
                    bounds.x1 = x1;
                if (y0 >= rect.y0 && y0 < bounds.y0)
                    bounds.y0 = y0;
                if (y1 <= rect.y1 && y1 > bounds.y1)
                    bounds.y1 = y1;
            }
            return bounds;
        }
    }
    exports.SpatialIndex = SpatialIndex;
    SpatialIndex.__name__ = "SpatialIndex";
},
/* flatbush/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const flatqueue_1 = (0, tslib_1.__importDefault)(require(183) /* flatqueue */);
    const ARRAY_TYPES = [
        Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Uint16Array,
        Int32Array, Uint32Array, Float32Array, Float64Array
    ];
    const VERSION = 3; // serialized format version
    class Flatbush {
        static from(data) {
            if (!(data instanceof ArrayBuffer)) {
                throw new Error('Data must be an instance of ArrayBuffer.');
            }
            const [magic, versionAndType] = new Uint8Array(data, 0, 2);
            if (magic !== 0xfb) {
                throw new Error('Data does not appear to be in a Flatbush format.');
            }
            if (versionAndType >> 4 !== VERSION) {
                throw new Error(`Got v${versionAndType >> 4} data when expected v${VERSION}.`);
            }
            const [nodeSize] = new Uint16Array(data, 2, 1);
            const [numItems] = new Uint32Array(data, 4, 1);
            return new Flatbush(numItems, nodeSize, ARRAY_TYPES[versionAndType & 0x0f], data);
        }
        constructor(numItems, nodeSize = 16, ArrayType = Float64Array, data) {
            if (numItems === undefined)
                throw new Error('Missing required argument: numItems.');
            if (isNaN(numItems) || numItems <= 0)
                throw new Error(`Unpexpected numItems value: ${numItems}.`);
            this.numItems = +numItems;
            this.nodeSize = Math.min(Math.max(+nodeSize, 2), 65535);
            // calculate the total number of nodes in the R-tree to allocate space for
            // and the index of each tree level (used in search later)
            let n = numItems;
            let numNodes = n;
            this._levelBounds = [n * 4];
            do {
                n = Math.ceil(n / this.nodeSize);
                numNodes += n;
                this._levelBounds.push(numNodes * 4);
            } while (n !== 1);
            this.ArrayType = ArrayType || Float64Array;
            this.IndexArrayType = numNodes < 16384 ? Uint16Array : Uint32Array;
            const arrayTypeIndex = ARRAY_TYPES.indexOf(this.ArrayType);
            const nodesByteSize = numNodes * 4 * this.ArrayType.BYTES_PER_ELEMENT;
            if (arrayTypeIndex < 0) {
                throw new Error(`Unexpected typed array class: ${ArrayType}.`);
            }
            if (data && (data instanceof ArrayBuffer)) {
                this.data = data;
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = numNodes * 4;
                this.minX = this._boxes[this._pos - 4];
                this.minY = this._boxes[this._pos - 3];
                this.maxX = this._boxes[this._pos - 2];
                this.maxY = this._boxes[this._pos - 1];
            }
            else {
                this.data = new ArrayBuffer(8 + nodesByteSize + numNodes * this.IndexArrayType.BYTES_PER_ELEMENT);
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = 0;
                this.minX = Infinity;
                this.minY = Infinity;
                this.maxX = -Infinity;
                this.maxY = -Infinity;
                new Uint8Array(this.data, 0, 2).set([0xfb, (VERSION << 4) + arrayTypeIndex]);
                new Uint16Array(this.data, 2, 1)[0] = nodeSize;
                new Uint32Array(this.data, 4, 1)[0] = numItems;
            }
            // a priority queue for k-nearest-neighbors queries
            this._queue = new flatqueue_1.default();
        }
        add(minX, minY, maxX, maxY) {
            const index = this._pos >> 2;
            this._indices[index] = index;
            this._boxes[this._pos++] = minX;
            this._boxes[this._pos++] = minY;
            this._boxes[this._pos++] = maxX;
            this._boxes[this._pos++] = maxY;
            if (minX < this.minX)
                this.minX = minX;
            if (minY < this.minY)
                this.minY = minY;
            if (maxX > this.maxX)
                this.maxX = maxX;
            if (maxY > this.maxY)
                this.maxY = maxY;
            return index;
        }
        finish() {
            if (this._pos >> 2 !== this.numItems) {
                throw new Error(`Added ${this._pos >> 2} items when expected ${this.numItems}.`);
            }
            if (this.numItems <= this.nodeSize) {
                // only one node, skip sorting and just fill the root box
                this._boxes[this._pos++] = this.minX;
                this._boxes[this._pos++] = this.minY;
                this._boxes[this._pos++] = this.maxX;
                this._boxes[this._pos++] = this.maxY;
                return;
            }
            const width = this.maxX - this.minX;
            const height = this.maxY - this.minY;
            const hilbertValues = new Uint32Array(this.numItems);
            const hilbertMax = (1 << 16) - 1;
            // map item centers into Hilbert coordinate space and calculate Hilbert values
            for (let i = 0; i < this.numItems; i++) {
                let pos = 4 * i;
                const minX = this._boxes[pos++];
                const minY = this._boxes[pos++];
                const maxX = this._boxes[pos++];
                const maxY = this._boxes[pos++];
                const x = Math.floor(hilbertMax * ((minX + maxX) / 2 - this.minX) / width);
                const y = Math.floor(hilbertMax * ((minY + maxY) / 2 - this.minY) / height);
                hilbertValues[i] = hilbert(x, y);
            }
            // sort items by their Hilbert value (for packing later)
            sort(hilbertValues, this._boxes, this._indices, 0, this.numItems - 1, this.nodeSize);
            // generate nodes at each tree level, bottom-up
            for (let i = 0, pos = 0; i < this._levelBounds.length - 1; i++) {
                const end = this._levelBounds[i];
                // generate a parent node for each block of consecutive <nodeSize> nodes
                while (pos < end) {
                    const nodeIndex = pos;
                    // calculate bbox for the new node
                    let nodeMinX = Infinity;
                    let nodeMinY = Infinity;
                    let nodeMaxX = -Infinity;
                    let nodeMaxY = -Infinity;
                    for (let i = 0; i < this.nodeSize && pos < end; i++) {
                        nodeMinX = Math.min(nodeMinX, this._boxes[pos++]);
                        nodeMinY = Math.min(nodeMinY, this._boxes[pos++]);
                        nodeMaxX = Math.max(nodeMaxX, this._boxes[pos++]);
                        nodeMaxY = Math.max(nodeMaxY, this._boxes[pos++]);
                    }
                    // add the new node to the tree data
                    this._indices[this._pos >> 2] = nodeIndex;
                    this._boxes[this._pos++] = nodeMinX;
                    this._boxes[this._pos++] = nodeMinY;
                    this._boxes[this._pos++] = nodeMaxX;
                    this._boxes[this._pos++] = nodeMaxY;
                }
            }
        }
        search(minX, minY, maxX, maxY, filterFn) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            let nodeIndex = this._boxes.length - 4;
            const queue = [];
            const results = [];
            while (nodeIndex !== undefined) {
                // find the end index of the node
                const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // search through child nodes
                for (let pos = nodeIndex; pos < end; pos += 4) {
                    const index = this._indices[pos >> 2] | 0;
                    // check if node bbox intersects with query bbox
                    if (maxX < this._boxes[pos])
                        continue; // maxX < nodeMinX
                    if (maxY < this._boxes[pos + 1])
                        continue; // maxY < nodeMinY
                    if (minX > this._boxes[pos + 2])
                        continue; // minX > nodeMaxX
                    if (minY > this._boxes[pos + 3])
                        continue; // minY > nodeMaxY
                    if (nodeIndex < this.numItems * 4) {
                        if (filterFn === undefined || filterFn(index)) {
                            results.push(index); // leaf item
                        }
                    }
                    else {
                        queue.push(index); // node; add it to the search queue
                    }
                }
                nodeIndex = queue.pop();
            }
            return results;
        }
        neighbors(x, y, maxResults = Infinity, maxDistance = Infinity, filterFn) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            let nodeIndex = this._boxes.length - 4;
            const q = this._queue;
            const results = [];
            const maxDistSquared = maxDistance * maxDistance;
            while (nodeIndex !== undefined) {
                // find the end index of the node
                const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // add child nodes to the queue
                for (let pos = nodeIndex; pos < end; pos += 4) {
                    const index = this._indices[pos >> 2] | 0;
                    const dx = axisDist(x, this._boxes[pos], this._boxes[pos + 2]);
                    const dy = axisDist(y, this._boxes[pos + 1], this._boxes[pos + 3]);
                    const dist = dx * dx + dy * dy;
                    if (nodeIndex < this.numItems * 4) { // leaf node
                        if (filterFn === undefined || filterFn(index)) {
                            // put a negative index if it's an item rather than a node, to recognize later
                            q.push(-index - 1, dist);
                        }
                    }
                    else {
                        q.push(index, dist);
                    }
                }
                // pop items from the queue
                while (q.length && q.peek() < 0) {
                    const dist = q.peekValue();
                    if (dist > maxDistSquared) {
                        q.clear();
                        return results;
                    }
                    results.push(-q.pop() - 1);
                    if (results.length === maxResults) {
                        q.clear();
                        return results;
                    }
                }
                nodeIndex = q.pop();
            }
            q.clear();
            return results;
        }
    }
    exports.default = Flatbush;
    function axisDist(k, min, max) {
        return k < min ? min - k : k <= max ? 0 : k - max;
    }
    // binary search for the first value in the array bigger than the given
    function upperBound(value, arr) {
        let i = 0;
        let j = arr.length - 1;
        while (i < j) {
            const m = (i + j) >> 1;
            if (arr[m] > value) {
                j = m;
            }
            else {
                i = m + 1;
            }
        }
        return arr[i];
    }
    // custom quicksort that partially sorts bbox data alongside the hilbert values
    function sort(values, boxes, indices, left, right, nodeSize) {
        if (Math.floor(left / nodeSize) >= Math.floor(right / nodeSize))
            return;
        const pivot = values[(left + right) >> 1];
        let i = left - 1;
        let j = right + 1;
        while (true) {
            do
                i++;
            while (values[i] < pivot);
            do
                j--;
            while (values[j] > pivot);
            if (i >= j)
                break;
            swap(values, boxes, indices, i, j);
        }
        sort(values, boxes, indices, left, j, nodeSize);
        sort(values, boxes, indices, j + 1, right, nodeSize);
    }
    // swap two values and two corresponding boxes
    function swap(values, boxes, indices, i, j) {
        const temp = values[i];
        values[i] = values[j];
        values[j] = temp;
        const k = 4 * i;
        const m = 4 * j;
        const a = boxes[k];
        const b = boxes[k + 1];
        const c = boxes[k + 2];
        const d = boxes[k + 3];
        boxes[k] = boxes[m];
        boxes[k + 1] = boxes[m + 1];
        boxes[k + 2] = boxes[m + 2];
        boxes[k + 3] = boxes[m + 3];
        boxes[m] = a;
        boxes[m + 1] = b;
        boxes[m + 2] = c;
        boxes[m + 3] = d;
        const e = indices[i];
        indices[i] = indices[j];
        indices[j] = e;
    }
    // Fast Hilbert curve algorithm by http://threadlocalmutex.com/
    // Ported from C++ https://github.com/rawrunprotected/hilbert_curves (public domain)
    function hilbert(x, y) {
        let a = x ^ y;
        let b = 0xFFFF ^ a;
        let c = 0xFFFF ^ (x | y);
        let d = x & (y ^ 0xFFFF);
        let A = a | (b >> 1);
        let B = (a >> 1) ^ a;
        let C = ((c >> 1) ^ (b & (d >> 1))) ^ c;
        let D = ((a & (c >> 1)) ^ (d >> 1)) ^ d;
        a = A;
        b = B;
        c = C;
        d = D;
        A = ((a & (a >> 2)) ^ (b & (b >> 2)));
        B = ((a & (b >> 2)) ^ (b & ((a ^ b) >> 2)));
        C ^= ((a & (c >> 2)) ^ (b & (d >> 2)));
        D ^= ((b & (c >> 2)) ^ ((a ^ b) & (d >> 2)));
        a = A;
        b = B;
        c = C;
        d = D;
        A = ((a & (a >> 4)) ^ (b & (b >> 4)));
        B = ((a & (b >> 4)) ^ (b & ((a ^ b) >> 4)));
        C ^= ((a & (c >> 4)) ^ (b & (d >> 4)));
        D ^= ((b & (c >> 4)) ^ ((a ^ b) & (d >> 4)));
        a = A;
        b = B;
        c = C;
        d = D;
        C ^= ((a & (c >> 8)) ^ (b & (d >> 8)));
        D ^= ((b & (c >> 8)) ^ ((a ^ b) & (d >> 8)));
        a = C ^ (C >> 1);
        b = D ^ (D >> 1);
        let i0 = x ^ y;
        let i1 = b | (0xFFFF ^ (i0 | a));
        i0 = (i0 | (i0 << 8)) & 0x00FF00FF;
        i0 = (i0 | (i0 << 4)) & 0x0F0F0F0F;
        i0 = (i0 | (i0 << 2)) & 0x33333333;
        i0 = (i0 | (i0 << 1)) & 0x55555555;
        i1 = (i1 | (i1 << 8)) & 0x00FF00FF;
        i1 = (i1 | (i1 << 4)) & 0x0F0F0F0F;
        i1 = (i1 | (i1 << 2)) & 0x33333333;
        i1 = (i1 | (i1 << 1)) & 0x55555555;
        return ((i1 << 1) | i0) >>> 0;
    }
},
/* flatqueue/index.mjs */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class FlatQueue {
        constructor() {
            this.ids = [];
            this.values = [];
            this.length = 0;
        }
        clear() {
            this.length = 0;
        }
        push(id, value) {
            let pos = this.length++;
            this.ids[pos] = id;
            this.values[pos] = value;
            while (pos > 0) {
                const parent = (pos - 1) >> 1;
                const parentValue = this.values[parent];
                if (value >= parentValue)
                    break;
                this.ids[pos] = this.ids[parent];
                this.values[pos] = parentValue;
                pos = parent;
            }
            this.ids[pos] = id;
            this.values[pos] = value;
        }
        pop() {
            if (this.length === 0)
                return undefined;
            const top = this.ids[0];
            this.length--;
            if (this.length > 0) {
                const id = this.ids[0] = this.ids[this.length];
                const value = this.values[0] = this.values[this.length];
                const halfLength = this.length >> 1;
                let pos = 0;
                while (pos < halfLength) {
                    let left = (pos << 1) + 1;
                    const right = left + 1;
                    let bestIndex = this.ids[left];
                    let bestValue = this.values[left];
                    const rightValue = this.values[right];
                    if (right < this.length && rightValue < bestValue) {
                        left = right;
                        bestIndex = this.ids[right];
                        bestValue = rightValue;
                    }
                    if (bestValue >= value)
                        break;
                    this.ids[pos] = bestIndex;
                    this.values[pos] = bestValue;
                    pos = left;
                }
                this.ids[pos] = id;
                this.values[pos] = value;
            }
            return top;
        }
        peek() {
            if (this.length === 0)
                return undefined;
            return this.ids[0];
        }
        peekValue() {
            if (this.length === 0)
                return undefined;
            return this.values[0];
        }
    }
    exports.default = FlatQueue;
},
/* models/glyphs/utils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const hittest = (0, tslib_1.__importStar)(require(185) /* ../../core/hittest */);
    function generic_line_scalar_legend(visuals, ctx, { x0, x1, y0, y1 }) {
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        visuals.line.apply(ctx);
        ctx.restore();
    }
    exports.generic_line_scalar_legend = generic_line_scalar_legend;
    function generic_line_vector_legend(visuals, ctx, { x0, x1, y0, y1 }, i) {
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        visuals.line.apply(ctx, i);
        ctx.restore();
    }
    exports.generic_line_vector_legend = generic_line_vector_legend;
    exports.generic_line_legend = generic_line_vector_legend;
    function generic_area_scalar_legend(visuals, ctx, { x0, x1, y0, y1 }) {
        var _a, _b;
        const w = Math.abs(x1 - x0);
        const dw = w * 0.1;
        const h = Math.abs(y1 - y0);
        const dh = h * 0.1;
        const sx0 = x0 + dw;
        const sx1 = x1 - dw;
        const sy0 = y0 + dh;
        const sy1 = y1 - dh;
        ctx.beginPath();
        ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        visuals.fill.apply(ctx);
        (_a = visuals.hatch) === null || _a === void 0 ? void 0 : _a.apply(ctx);
        (_b = visuals.line) === null || _b === void 0 ? void 0 : _b.apply(ctx);
    }
    exports.generic_area_scalar_legend = generic_area_scalar_legend;
    function generic_area_vector_legend(visuals, ctx, { x0, x1, y0, y1 }, i) {
        var _a, _b;
        const w = Math.abs(x1 - x0);
        const dw = w * 0.1;
        const h = Math.abs(y1 - y0);
        const dh = h * 0.1;
        const sx0 = x0 + dw;
        const sx1 = x1 - dw;
        const sy0 = y0 + dh;
        const sy1 = y1 - dh;
        ctx.beginPath();
        ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        visuals.fill.apply(ctx, i);
        (_a = visuals.hatch) === null || _a === void 0 ? void 0 : _a.apply(ctx, i);
        (_b = visuals.line) === null || _b === void 0 ? void 0 : _b.apply(ctx, i);
    }
    exports.generic_area_vector_legend = generic_area_vector_legend;
    exports.generic_area_legend = generic_area_vector_legend;
    function line_interpolation(renderer, geometry, x2, y2, x3, y3) {
        const { sx, sy } = geometry;
        let x0, x1;
        let y0, y1;
        if (geometry.type == "point") {
            // The +/- adjustments here are to dilate the hit point into a virtual "segment" to use below
            [y0, y1] = renderer.yscale.r_invert(sy - 1, sy + 1);
            [x0, x1] = renderer.xscale.r_invert(sx - 1, sx + 1);
        }
        else {
            // The +/- adjustments here are to handle cases such as purely horizontal or vertical lines
            if (geometry.direction == "v") {
                [y0, y1] = renderer.yscale.r_invert(sy, sy);
                [x0, x1] = [Math.min(x2 - 1, x3 - 1), Math.max(x2 + 1, x3 + 1)];
            }
            else {
                [x0, x1] = renderer.xscale.r_invert(sx, sx);
                [y0, y1] = [Math.min(y2 - 1, y3 - 1), Math.max(y2 + 1, y3 + 1)];
            }
        }
        const { x, y } = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3);
        return [x, y]; // XXX: null is not handled at use sites
    }
    exports.line_interpolation = line_interpolation;
},
/* core/hittest.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function point_in_poly(x, y, px, py) {
        let inside = false;
        let x1 = px[px.length - 1];
        let y1 = py[py.length - 1];
        for (let i = 0; i < px.length; i++) {
            const x2 = px[i];
            const y2 = py[i];
            if ((y1 < y) != (y2 < y)) {
                if ((x1 + (y - y1) / (y2 - y1) * (x2 - x1)) < x)
                    inside = !inside;
            }
            x1 = x2;
            y1 = y2;
        }
        return inside;
    }
    exports.point_in_poly = point_in_poly;
    function point_in_ellipse(x, y, angle, b, a, x0, y0) {
        const A = ((Math.cos(angle) / a) ** 2 + (Math.sin(angle) / b) ** 2);
        const B = 2 * Math.cos(angle) * Math.sin(angle) * ((1 / a) ** 2 - (1 / b) ** 2);
        const C = ((Math.cos(angle) / b) ** 2 + (Math.sin(angle) / a) ** 2);
        const eqn = A * (x - x0) ** 2 + B * (x - x0) * (y - y0) + C * (y - y0) ** 2;
        const inside = eqn <= 1;
        return inside;
    }
    exports.point_in_ellipse = point_in_ellipse;
    function dist_2_pts(p0, p1) {
        return (p0.x - p1.x) ** 2 + (p0.y - p1.y) ** 2;
    }
    exports.dist_2_pts = dist_2_pts;
    function dist_to_segment_squared(p, v, w) {
        const l2 = dist_2_pts(v, w);
        if (l2 == 0)
            return dist_2_pts(p, v);
        const t = ((p.x - v.x) * (w.x - v.x) + (p.y - v.y) * (w.y - v.y)) / l2;
        if (t < 0)
            return dist_2_pts(p, v);
        if (t > 1)
            return dist_2_pts(p, w);
        const q = { x: v.x + t * (w.x - v.x), y: v.y + t * (w.y - v.y) };
        return dist_2_pts(p, q);
    }
    exports.dist_to_segment_squared = dist_to_segment_squared;
    function dist_to_segment(p, v, w) {
        return Math.sqrt(dist_to_segment_squared(p, v, w));
    }
    exports.dist_to_segment = dist_to_segment;
    function check_2_segments_intersect(l0_x0, l0_y0, l0_x1, l0_y1, l1_x0, l1_y0, l1_x1, l1_y1) {
        /*
         *  Check if 2 segments (l0 and l1) intersect. Returns a structure with
         *  the following attributes:
         *   * hit (boolean): whether the 2 segments intersect
         *   * x (float): x coordinate of the intersection point
         *   * y (float): y coordinate of the intersection point
         */
        const den = ((l1_y1 - l1_y0) * (l0_x1 - l0_x0)) - ((l1_x1 - l1_x0) * (l0_y1 - l0_y0));
        if (den == 0) {
            return { hit: false, x: null, y: null };
        }
        else {
            let a = l0_y0 - l1_y0;
            let b = l0_x0 - l1_x0;
            const num1 = ((l1_x1 - l1_x0) * a) - ((l1_y1 - l1_y0) * b);
            const num2 = ((l0_x1 - l0_x0) * a) - ((l0_y1 - l0_y0) * b);
            a = num1 / den;
            b = num2 / den;
            const x = l0_x0 + (a * (l0_x1 - l0_x0));
            const y = l0_y0 + (a * (l0_y1 - l0_y0));
            return { hit: (a > 0 && a < 1) && (b > 0 && b < 1), x, y };
        }
    }
    exports.check_2_segments_intersect = check_2_segments_intersect;
},
/* models/glyphs/patch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const xy_glyph_1 = require(178) /* ./xy_glyph */;
    const utils_1 = require(184) /* ./utils */;
    const hittest = (0, tslib_1.__importStar)(require(185) /* ../../core/hittest */);
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const selection_1 = require(72) /* ../selections/selection */;
    class PatchView extends xy_glyph_1.XYGlyphView {
        _render(ctx, indices, data) {
            const { sx, sy } = data !== null && data !== void 0 ? data : this;
            let move = true;
            ctx.beginPath();
            for (const i of indices) {
                const sx_i = sx[i];
                const sy_i = sy[i];
                if (!isFinite(sx_i + sy_i)) {
                    ctx.closePath();
                    move = true;
                }
                else {
                    if (move) {
                        ctx.moveTo(sx_i, sy_i);
                        move = false;
                    }
                    else
                        ctx.lineTo(sx_i, sy_i);
                }
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
            this.visuals.line.apply(ctx);
        }
        draw_legend_for_index(ctx, bbox, _index) {
            (0, utils_1.generic_area_scalar_legend)(this.visuals, ctx, bbox);
        }
        _hit_point(geometry) {
            const result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, this.sx, this.sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        }
    }
    exports.PatchView = PatchView;
    PatchView.__name__ = "PatchView";
    class Patch extends xy_glyph_1.XYGlyph {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Patch = Patch;
    _a = Patch;
    Patch.__name__ = "Patch";
    (() => {
        _a.prototype.default_view = PatchView;
        _a.mixins([mixins.LineScalar, mixins.FillScalar, mixins.HatchScalar]);
    })();
},
/* models/glyphs/harea.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const types_1 = require(24) /* ../../core/types */;
    const area_1 = require(188) /* ./area */;
    const hittest = (0, tslib_1.__importStar)(require(185) /* ../../core/hittest */);
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    const selection_1 = require(72) /* ../selections/selection */;
    class HAreaView extends area_1.AreaView {
        _index_data(index) {
            const { min, max } = Math;
            const { data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const x1 = this._x1[i];
                const x2 = this._x2[i];
                const y = this._y[i];
                index.add_rect(min(x1, x2), y, max(x1, x2), y);
            }
        }
        _render(ctx, _indices, data) {
            const { sx1, sx2, sy } = data !== null && data !== void 0 ? data : this;
            ctx.beginPath();
            for (let i = 0, end = sx1.length; i < end; i++) {
                ctx.lineTo(sx1[i], sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (let i = sx2.length - 1; i >= 0; i--) {
                ctx.lineTo(sx2[i], sy[i]);
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
        }
        _hit_point(geometry) {
            const L = this.sy.length;
            const sx = new types_1.ScreenArray(2 * L);
            const sy = new types_1.ScreenArray(2 * L);
            for (let i = 0, end = L; i < end; i++) {
                sx[i] = this.sx1[i];
                sy[i] = this.sy[i];
                sx[L + i] = this.sx2[L - i - 1];
                sy[L + i] = this.sy[L - i - 1];
            }
            const result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        }
        scenterxy(i) {
            const scx = (this.sx1[i] + this.sx2[i]) / 2;
            const scy = this.sy[i];
            return [scx, scy];
        }
        _map_data() {
            this.sx1 = this.renderer.xscale.v_compute(this._x1);
            this.sx2 = this.renderer.xscale.v_compute(this._x2);
            this.sy = this.renderer.yscale.v_compute(this._y);
        }
    }
    exports.HAreaView = HAreaView;
    HAreaView.__name__ = "HAreaView";
    class HArea extends area_1.Area {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.HArea = HArea;
    _a = HArea;
    HArea.__name__ = "HArea";
    (() => {
        _a.prototype.default_view = HAreaView;
        _a.define(({}) => ({
            x1: [p.XCoordinateSpec, { field: "x1" }],
            x2: [p.XCoordinateSpec, { field: "x2" }],
            y: [p.YCoordinateSpec, { field: "y" }],
        }));
    })();
},
/* models/glyphs/area.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const glyph_1 = require(179) /* ./glyph */;
    const utils_1 = require(184) /* ./utils */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    class AreaView extends glyph_1.GlyphView {
        draw_legend_for_index(ctx, bbox, _index) {
            (0, utils_1.generic_area_scalar_legend)(this.visuals, ctx, bbox);
        }
    }
    exports.AreaView = AreaView;
    AreaView.__name__ = "AreaView";
    class Area extends glyph_1.Glyph {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Area = Area;
    _a = Area;
    Area.__name__ = "Area";
    (() => {
        _a.mixins([mixins.FillScalar, mixins.HatchScalar]);
    })();
},
/* models/glyphs/varea.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const types_1 = require(24) /* ../../core/types */;
    const area_1 = require(188) /* ./area */;
    const hittest = (0, tslib_1.__importStar)(require(185) /* ../../core/hittest */);
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    const selection_1 = require(72) /* ../selections/selection */;
    class VAreaView extends area_1.AreaView {
        _index_data(index) {
            const { min, max } = Math;
            const { data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const x = this._x[i];
                const y1 = this._y1[i];
                const y2 = this._y2[i];
                index.add_rect(x, min(y1, y2), x, max(y1, y2));
            }
        }
        _render(ctx, _indices, data) {
            const { sx, sy1, sy2 } = data !== null && data !== void 0 ? data : this;
            ctx.beginPath();
            for (let i = 0, end = sy1.length; i < end; i++) {
                ctx.lineTo(sx[i], sy1[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (let i = sy2.length - 1; i >= 0; i--) {
                ctx.lineTo(sx[i], sy2[i]);
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
        }
        scenterxy(i) {
            const scx = this.sx[i];
            const scy = (this.sy1[i] + this.sy2[i]) / 2;
            return [scx, scy];
        }
        _hit_point(geometry) {
            const L = this.sx.length;
            const sx = new types_1.ScreenArray(2 * L);
            const sy = new types_1.ScreenArray(2 * L);
            for (let i = 0, end = L; i < end; i++) {
                sx[i] = this.sx[i];
                sy[i] = this.sy1[i];
                sx[L + i] = this.sx[L - i - 1];
                sy[L + i] = this.sy2[L - i - 1];
            }
            const result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        }
        _map_data() {
            this.sx = this.renderer.xscale.v_compute(this._x);
            this.sy1 = this.renderer.yscale.v_compute(this._y1);
            this.sy2 = this.renderer.yscale.v_compute(this._y2);
        }
    }
    exports.VAreaView = VAreaView;
    VAreaView.__name__ = "VAreaView";
    class VArea extends area_1.Area {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.VArea = VArea;
    _a = VArea;
    VArea.__name__ = "VArea";
    (() => {
        _a.prototype.default_view = VAreaView;
        _a.define(({}) => ({
            x: [p.XCoordinateSpec, { field: "x" }],
            y1: [p.YCoordinateSpec, { field: "y1" }],
            y2: [p.YCoordinateSpec, { field: "y2" }],
        }));
    })();
},
/* models/sources/cds_view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(53) /* ../../model */;
    const types_1 = require(24) /* ../../core/types */;
    const filter_1 = require(191) /* ../filters/filter */;
    const columnar_data_source_1 = require(70) /* ./columnar_data_source */;
    class CDSView extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this.compute_indices();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.properties.filters.change, () => this.compute_indices());
            const connect_listeners = () => {
                const fn = () => this.compute_indices();
                if (this.source != null) {
                    this.connect(this.source.change, fn);
                    if (this.source instanceof columnar_data_source_1.ColumnarDataSource) {
                        this.connect(this.source.streaming, fn);
                        this.connect(this.source.patching, fn);
                    }
                }
            };
            let initialized = this.source != null;
            if (initialized)
                connect_listeners();
            else {
                this.connect(this.properties.source.change, () => {
                    if (!initialized) {
                        connect_listeners();
                        initialized = true;
                    }
                });
            }
        }
        compute_indices() {
            var _b;
            const { source } = this;
            if (source == null)
                return;
            // XXX: if the data source is empty, there still may be one
            // index originating from glyph's scalar values.
            const size = (_b = source.get_length()) !== null && _b !== void 0 ? _b : 1;
            const indices = types_1.Indices.all_set(size);
            for (const filter of this.filters) {
                indices.intersect(filter.compute_indices(source));
            }
            this.indices = indices;
            this._indices = [...indices];
            this.indices_map_to_subset();
        }
        indices_map_to_subset() {
            this.indices_map = {};
            for (let i = 0; i < this._indices.length; i++) {
                this.indices_map[this._indices[i]] = i;
            }
        }
        convert_selection_from_subset(selection_subset) {
            return selection_subset.map((i) => this._indices[i]);
        }
        convert_selection_to_subset(selection_full) {
            return selection_full.map((i) => this.indices_map[i]);
        }
        convert_indices_from_subset(indices) {
            return indices.map((i) => this._indices[i]);
        }
    }
    exports.CDSView = CDSView;
    _a = CDSView;
    CDSView.__name__ = "CDSView";
    (() => {
        _a.define(({ Array, Ref }) => ({
            filters: [Array(Ref(filter_1.Filter)), []],
            source: [Ref(columnar_data_source_1.ColumnarDataSource)],
        }));
        _a.internal(({ Int, Dict, Ref, Nullable }) => ({
            indices: [Ref(types_1.Indices)],
            indices_map: [Dict(Int), {}],
            masked: [Nullable(Ref(types_1.Indices)), null],
        }));
    })();
},
/* models/filters/filter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(53) /* ../../model */;
    class Filter extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Filter = Filter;
    Filter.__name__ = "Filter";
},
/* models/formatters/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var basic_tick_formatter_1 = require(146) /* ./basic_tick_formatter */;
    __esExport("BasicTickFormatter", basic_tick_formatter_1.BasicTickFormatter);
    var categorical_tick_formatter_1 = require(142) /* ./categorical_tick_formatter */;
    __esExport("CategoricalTickFormatter", categorical_tick_formatter_1.CategoricalTickFormatter);
    var datetime_tick_formatter_1 = require(150) /* ./datetime_tick_formatter */;
    __esExport("DatetimeTickFormatter", datetime_tick_formatter_1.DatetimeTickFormatter);
    var func_tick_formatter_1 = require(193) /* ./func_tick_formatter */;
    __esExport("FuncTickFormatter", func_tick_formatter_1.FuncTickFormatter);
    var log_tick_formatter_1 = require(163) /* ./log_tick_formatter */;
    __esExport("LogTickFormatter", log_tick_formatter_1.LogTickFormatter);
    var mercator_tick_formatter_1 = require(166) /* ./mercator_tick_formatter */;
    __esExport("MercatorTickFormatter", mercator_tick_formatter_1.MercatorTickFormatter);
    var numeral_tick_formatter_1 = require(194) /* ./numeral_tick_formatter */;
    __esExport("NumeralTickFormatter", numeral_tick_formatter_1.NumeralTickFormatter);
    var printf_tick_formatter_1 = require(195) /* ./printf_tick_formatter */;
    __esExport("PrintfTickFormatter", printf_tick_formatter_1.PrintfTickFormatter);
    var tick_formatter_1 = require(131) /* ./tick_formatter */;
    __esExport("TickFormatter", tick_formatter_1.TickFormatter);
},
/* models/formatters/func_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const tick_formatter_1 = require(131) /* ./tick_formatter */;
    const object_1 = require(13) /* ../../core/util/object */;
    const string_1 = require(34) /* ../../core/util/string */;
    class FuncTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        get names() {
            return (0, object_1.keys)(this.args);
        }
        get values() {
            return (0, object_1.values)(this.args);
        }
        /*protected*/ _make_func() {
            const code = (0, string_1.use_strict)(this.code);
            return new Function("tick", "index", "ticks", ...this.names, code);
        }
        doFormat(ticks, _opts) {
            const cache = {};
            const func = this._make_func().bind(cache);
            return ticks.map((tick, index, ticks) => `${func(tick, index, ticks, ...this.values)}`);
        }
    }
    exports.FuncTickFormatter = FuncTickFormatter;
    _a = FuncTickFormatter;
    FuncTickFormatter.__name__ = "FuncTickFormatter";
    (() => {
        _a.define(({ Unknown, String, Dict }) => ({
            args: [Dict(Unknown), {}],
            code: [String, ""],
        }));
    })();
},
/* models/formatters/numeral_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const Numbro = (0, tslib_1.__importStar)(require(153) /* @bokeh/numbro */);
    const tick_formatter_1 = require(131) /* ./tick_formatter */;
    const enums_1 = require(20) /* ../../core/enums */;
    class NumeralTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        get _rounding_fn() {
            switch (this.rounding) {
                case "round":
                case "nearest":
                    return Math.round;
                case "floor":
                case "rounddown":
                    return Math.floor;
                case "ceil":
                case "roundup":
                    return Math.ceil;
            }
        }
        doFormat(ticks, _opts) {
            const { format, language, _rounding_fn } = this;
            return ticks.map((tick) => Numbro.format(tick, format, language, _rounding_fn));
        }
    }
    exports.NumeralTickFormatter = NumeralTickFormatter;
    _a = NumeralTickFormatter;
    NumeralTickFormatter.__name__ = "NumeralTickFormatter";
    (() => {
        _a.define(({ String }) => ({
            // TODO (bev) all of these could be tightened up
            format: [String, "0,0"],
            language: [String, "en"],
            rounding: [enums_1.RoundingFunction, "round"],
        }));
    })();
},
/* models/formatters/printf_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const tick_formatter_1 = require(131) /* ./tick_formatter */;
    const templating_1 = require(152) /* ../../core/util/templating */;
    class PrintfTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        doFormat(ticks, _opts) {
            return ticks.map((tick) => (0, templating_1.sprintf)(this.format, tick));
        }
    }
    exports.PrintfTickFormatter = PrintfTickFormatter;
    _a = PrintfTickFormatter;
    PrintfTickFormatter.__name__ = "PrintfTickFormatter";
    (() => {
        _a.define(({ String }) => ({
            format: [String, "%s"],
        }));
    })();
},
/* models/mappers/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var categorical_color_mapper_1 = require(197) /* ./categorical_color_mapper */;
    __esExport("CategoricalColorMapper", categorical_color_mapper_1.CategoricalColorMapper);
    var categorical_marker_mapper_1 = require(199) /* ./categorical_marker_mapper */;
    __esExport("CategoricalMarkerMapper", categorical_marker_mapper_1.CategoricalMarkerMapper);
    var categorical_pattern_mapper_1 = require(200) /* ./categorical_pattern_mapper */;
    __esExport("CategoricalPatternMapper", categorical_pattern_mapper_1.CategoricalPatternMapper);
    var continuous_color_mapper_1 = require(172) /* ./continuous_color_mapper */;
    __esExport("ContinuousColorMapper", continuous_color_mapper_1.ContinuousColorMapper);
    var color_mapper_1 = require(173) /* ./color_mapper */;
    __esExport("ColorMapper", color_mapper_1.ColorMapper);
    var linear_color_mapper_1 = require(201) /* ./linear_color_mapper */;
    __esExport("LinearColorMapper", linear_color_mapper_1.LinearColorMapper);
    var log_color_mapper_1 = require(202) /* ./log_color_mapper */;
    __esExport("LogColorMapper", log_color_mapper_1.LogColorMapper);
    var scanning_color_mapper_1 = require(171) /* ./scanning_color_mapper */;
    __esExport("ScanningColorMapper", scanning_color_mapper_1.ScanningColorMapper);
    var eqhist_color_mapper_1 = require(203) /* ./eqhist_color_mapper */;
    __esExport("EqHistColorMapper", eqhist_color_mapper_1.EqHistColorMapper);
},
/* models/mappers/categorical_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const categorical_mapper_1 = require(198) /* ./categorical_mapper */;
    const color_mapper_1 = require(173) /* ./color_mapper */;
    const factor_range_1 = require(67) /* ../ranges/factor_range */;
    class CategoricalColorMapper extends color_mapper_1.ColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        _v_compute(data, values, palette, { nan_color }) {
            (0, categorical_mapper_1.cat_v_compute)(data, this.factors, palette, values, this.start, this.end, nan_color);
        }
    }
    exports.CategoricalColorMapper = CategoricalColorMapper;
    _a = CategoricalColorMapper;
    CategoricalColorMapper.__name__ = "CategoricalColorMapper";
    (() => {
        _a.define(({ Number, Nullable }) => ({
            factors: [factor_range_1.FactorSeq],
            start: [Number, 0],
            end: [Nullable(Number), null],
        }));
    })();
},
/* models/mappers/categorical_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const types_1 = require(8) /* ../../core/util/types */;
    function _cat_equals(a, b) {
        if (a.length != b.length)
            return false;
        for (let i = 0, end = a.length; i < end; i++) {
            if (a[i] !== b[i])
                return false;
        }
        return true;
    }
    exports._cat_equals = _cat_equals;
    function cat_v_compute(data, factors, targets, values, start, end, extra_value) {
        const N = data.length;
        for (let i = 0; i < N; i++) {
            let d = data[i];
            let key;
            if ((0, types_1.isString)(d))
                key = (0, arrayable_1.index_of)(factors, d);
            else {
                if (start != null) {
                    if (end != null)
                        d = d.slice(start, end);
                    else
                        d = d.slice(start);
                }
                else if (end != null)
                    d = d.slice(0, end);
                if (d.length == 1)
                    key = (0, arrayable_1.index_of)(factors, d[0]);
                else
                    key = (0, arrayable_1.find_index)(factors, (x) => _cat_equals(x, d));
            }
            let value;
            if (key < 0 || key >= targets.length)
                value = extra_value;
            else
                value = targets[key];
            values[i] = value;
        }
    }
    exports.cat_v_compute = cat_v_compute;
},
/* models/mappers/categorical_marker_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const categorical_mapper_1 = require(198) /* ./categorical_mapper */;
    const factor_range_1 = require(67) /* ../ranges/factor_range */;
    const mapper_1 = require(174) /* ./mapper */;
    const enums_1 = require(20) /* ../../core/enums */;
    class CategoricalMarkerMapper extends mapper_1.Mapper {
        constructor(attrs) {
            super(attrs);
        }
        v_compute(xs) {
            const values = new Array(xs.length);
            (0, categorical_mapper_1.cat_v_compute)(xs, this.factors, this.markers, values, this.start, this.end, this.default_value);
            return values;
        }
    }
    exports.CategoricalMarkerMapper = CategoricalMarkerMapper;
    _a = CategoricalMarkerMapper;
    CategoricalMarkerMapper.__name__ = "CategoricalMarkerMapper";
    (() => {
        _a.define(({ Number, Array, Nullable }) => ({
            factors: [factor_range_1.FactorSeq],
            markers: [Array(enums_1.MarkerType)],
            start: [Number, 0],
            end: [Nullable(Number), null],
            default_value: [enums_1.MarkerType, "circle"],
        }));
    })();
},
/* models/mappers/categorical_pattern_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const categorical_mapper_1 = require(198) /* ./categorical_mapper */;
    const factor_range_1 = require(67) /* ../ranges/factor_range */;
    const mapper_1 = require(174) /* ./mapper */;
    const enums_1 = require(20) /* ../../core/enums */;
    class CategoricalPatternMapper extends mapper_1.Mapper {
        constructor(attrs) {
            super(attrs);
        }
        v_compute(xs) {
            const values = new Array(xs.length);
            (0, categorical_mapper_1.cat_v_compute)(xs, this.factors, this.patterns, values, this.start, this.end, this.default_value);
            return values;
        }
    }
    exports.CategoricalPatternMapper = CategoricalPatternMapper;
    _a = CategoricalPatternMapper;
    CategoricalPatternMapper.__name__ = "CategoricalPatternMapper";
    (() => {
        _a.define(({ Number, Array, Nullable }) => ({
            factors: [factor_range_1.FactorSeq],
            patterns: [Array(enums_1.HatchPatternType)],
            start: [Number, 0],
            end: [Nullable(Number), null],
            default_value: [enums_1.HatchPatternType, " "],
        }));
    })();
},
/* models/mappers/linear_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_color_mapper_1 = require(172) /* ./continuous_color_mapper */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    class LinearColorMapper extends continuous_color_mapper_1.ContinuousColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        scan(data, n) {
            const low = this.low != null ? this.low : (0, arrayable_1.min)(data);
            const high = this.high != null ? this.high : (0, arrayable_1.max)(data);
            const norm_factor = 1 / (high - low);
            const normed_interval = 1 / n;
            return { max: high, min: low, norm_factor, normed_interval };
        }
        cmap(d, palette, low_color, high_color, scan_data) {
            // This handles the edge case where d == high, since the code below maps
            // values exactly equal to high to palette.length, which is greater than
            // max_key
            const max_key = palette.length - 1;
            if (d == scan_data.max) {
                return palette[max_key];
            }
            const normed_d = (d - scan_data.min) * scan_data.norm_factor;
            const key = Math.floor(normed_d / scan_data.normed_interval);
            if (key < 0)
                return low_color;
            else if (key > max_key)
                return high_color;
            else
                return palette[key];
        }
    }
    exports.LinearColorMapper = LinearColorMapper;
    LinearColorMapper.__name__ = "LinearColorMapper";
},
/* models/mappers/log_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_color_mapper_1 = require(172) /* ./continuous_color_mapper */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    class LogColorMapper extends continuous_color_mapper_1.ContinuousColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        scan(data, n) {
            const low = this.low != null ? this.low : (0, arrayable_1.min)(data);
            const high = this.high != null ? this.high : (0, arrayable_1.max)(data);
            const scale = n / (Math.log(high) - Math.log(low)); // subtract the low offset
            return { max: high, min: low, scale };
        }
        cmap(d, palette, low_color, high_color, scan_data) {
            const max_key = palette.length - 1;
            if (d > scan_data.max) {
                return high_color;
            }
            // This handles the edge case where d == high, since the code below maps
            // values exactly equal to high to palette.length, which is greater than
            // max_key
            if (d == scan_data.max)
                return palette[max_key];
            else if (d < scan_data.min)
                return low_color;
            // Get the key
            const log = Math.log(d) - Math.log(scan_data.min); // subtract the low offset
            let key = Math.floor(log * scan_data.scale);
            // Deal with upper bound
            if (key > max_key) {
                key = max_key;
            }
            return palette[key];
        }
    }
    exports.LogColorMapper = LogColorMapper;
    LogColorMapper.__name__ = "LogColorMapper";
},
/* models/mappers/eqhist_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const scanning_color_mapper_1 = require(171) /* ./scanning_color_mapper */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const array_1 = require(9) /* ../../core/util/array */;
    const logging_1 = require(19) /* ../../core/logging */;
    class EqHistColorMapper extends scanning_color_mapper_1.ScanningColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        scan(data, n) {
            const low = this.low != null ? this.low : (0, arrayable_1.min)(data);
            const high = this.high != null ? this.high : (0, arrayable_1.max)(data);
            const nbins = this.bins;
            const eq_bin_edges = (0, array_1.linspace)(low, high, nbins + 1);
            const hist = (0, arrayable_1.bin_counts)(data, eq_bin_edges);
            const eq_bin_centers = new Array(nbins);
            for (let i = 0, length = eq_bin_edges.length; i < length - 1; i++) {
                const left = eq_bin_edges[i];
                const right = eq_bin_edges[i + 1];
                eq_bin_centers[i] = (left + right) / 2;
            }
            // CDFs
            const cdf = (0, array_1.cumsum)(hist);
            const cdf_max = cdf[cdf.length - 1];
            const norm_cdf = (0, arrayable_1.map)(cdf, (x) => x / cdf_max);
            // Iteratively find as many finite bins as there are colors
            let finite_bins = n - 1;
            let binning = [];
            let iterations = 0;
            let guess = n * 2;
            while ((finite_bins != n) && (iterations < 4) && (finite_bins != 0)) {
                const ratio = guess / finite_bins;
                if (ratio > 1000) {
                    // Abort if distribution is extremely skewed
                    break;
                }
                guess = Math.round(Math.max(n * ratio, n));
                // Interpolate
                const palette_edges = (0, array_1.range)(0, guess);
                const palette_cdf = (0, arrayable_1.map)(norm_cdf, (x) => x * (guess - 1));
                binning = (0, arrayable_1.interpolate)(palette_edges, palette_cdf, eq_bin_centers);
                // Evaluate binning
                const uniq_bins = (0, array_1.uniq)(binning);
                finite_bins = uniq_bins.length - 1;
                iterations++;
            }
            if (finite_bins == 0) {
                binning = [low, high];
                for (let j = 0; j < n - 1; j++)
                    binning.push(high);
            }
            else {
                binning = binning.slice(binning.length - n - 1);
                if (finite_bins != n)
                    logging_1.logger.warn("EqHistColorMapper warning: Histogram equalization did not converge.");
            }
            // XXX: should this be guaranteed by the above algorithm?
            binning[0] = low;
            binning[binning.length - 1] = high;
            return { min: low, max: high, binning };
        }
    }
    exports.EqHistColorMapper = EqHistColorMapper;
    _a = EqHistColorMapper;
    EqHistColorMapper.__name__ = "EqHistColorMapper";
    (() => {
        _a.define(({ Int }) => ({
            bins: [Int, 256 * 256],
        }));
    })();
},
/* models/scales/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var categorical_scale_1 = require(62) /* ./categorical_scale */;
    __esExport("CategoricalScale", categorical_scale_1.CategoricalScale);
    var continuous_scale_1 = require(60) /* ./continuous_scale */;
    __esExport("ContinuousScale", continuous_scale_1.ContinuousScale);
    var linear_scale_1 = require(59) /* ./linear_scale */;
    __esExport("LinearScale", linear_scale_1.LinearScale);
    var linear_interpolation_scale_1 = require(205) /* ./linear_interpolation_scale */;
    __esExport("LinearInterpolationScale", linear_interpolation_scale_1.LinearInterpolationScale);
    var log_scale_1 = require(61) /* ./log_scale */;
    __esExport("LogScale", log_scale_1.LogScale);
    var scale_1 = require(55) /* ./scale */;
    __esExport("Scale", scale_1.Scale);
},
/* models/scales/linear_interpolation_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const scale_1 = require(55) /* ./scale */;
    const linear_scale_1 = require(59) /* ./linear_scale */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    class LinearInterpolationScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        connect_signals() {
            super.connect_signals();
            const { source_range, target_range } = this.properties;
            this.on_change([source_range, target_range], () => {
                this.linear_scale = new linear_scale_1.LinearScale({
                    source_range: this.source_range,
                    target_range: this.target_range,
                });
            });
        }
        get s_compute() {
            throw new Error("not implemented");
        }
        get s_invert() {
            throw new Error("not implemented");
        }
        compute(x) {
            return x;
        }
        v_compute(vs) {
            const { binning } = this;
            const { start, end } = this.source_range;
            const min_val = start;
            const max_val = end;
            const n = binning.length;
            const step = (end - start) / (n - 1);
            const mapping = new Float64Array(n);
            for (let i = 0; i < n; i++) {
                mapping[i] = start + i * step;
            }
            const vvs = (0, arrayable_1.map)(vs, (v) => {
                if (v < min_val)
                    return min_val;
                if (v > max_val)
                    return max_val;
                const k = (0, arrayable_1.left_edge_index)(v, binning);
                if (k == -1)
                    return min_val;
                if (k >= n - 1)
                    return max_val;
                const b0 = binning[k];
                const b1 = binning[k + 1];
                const c = (v - b0) / (b1 - b0);
                const m0 = mapping[k];
                const m1 = mapping[k + 1];
                return m0 + c * (m1 - m0);
            });
            return this.linear_scale.v_compute(vvs);
        }
        invert(xprime) {
            return xprime;
        }
        v_invert(xprimes) {
            return new Float64Array(xprimes);
        }
    }
    exports.LinearInterpolationScale = LinearInterpolationScale;
    _a = LinearInterpolationScale;
    LinearInterpolationScale.__name__ = "LinearInterpolationScale";
    (() => {
        _a.internal(({ Arrayable, Ref }) => ({
            binning: [Arrayable],
            linear_scale: [
                Ref(linear_scale_1.LinearScale),
                (self) => new linear_scale_1.LinearScale({
                    source_range: self.source_range,
                    target_range: self.target_range,
                }),
            ],
        }));
    })();
},
/* models/ranges/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var data_range_1 = require(64) /* ./data_range */;
    __esExport("DataRange", data_range_1.DataRange);
    var data_range1d_1 = require(63) /* ./data_range1d */;
    __esExport("DataRange1d", data_range1d_1.DataRange1d);
    var factor_range_1 = require(67) /* ./factor_range */;
    __esExport("FactorRange", factor_range_1.FactorRange);
    var range_1 = require(57) /* ./range */;
    __esExport("Range", range_1.Range);
    var range1d_1 = require(58) /* ./range1d */;
    __esExport("Range1d", range1d_1.Range1d);
},
/* core/layout/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var types_1 = require(124) /* ./types */;
    __esExport("Sizeable", types_1.Sizeable);
    __esExport("SizingPolicy", types_1.SizingPolicy);
    var layoutable_1 = require(125) /* ./layoutable */;
    __esExport("Layoutable", layoutable_1.Layoutable);
    __esExport("LayoutItem", layoutable_1.LayoutItem);
    var alignments_1 = require(208) /* ./alignments */;
    __esExport("HStack", alignments_1.HStack);
    __esExport("VStack", alignments_1.VStack);
    var grid_1 = require(209) /* ./grid */;
    __esExport("Grid", grid_1.Grid);
    __esExport("Row", grid_1.Row);
    __esExport("Column", grid_1.Column);
    var html_1 = require(210) /* ./html */;
    __esExport("ContentBox", html_1.ContentBox);
    __esExport("VariadicBox", html_1.VariadicBox);
},
/* core/layout/alignments.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const layoutable_1 = require(125) /* ./layoutable */;
    const bbox_1 = require(65) /* ../util/bbox */;
    class Stack extends layoutable_1.Layoutable {
        constructor() {
            super(...arguments);
            this.children = [];
        }
        *[Symbol.iterator]() {
            yield* this.children;
        }
    }
    exports.Stack = Stack;
    Stack.__name__ = "Stack";
    class HStack extends Stack {
        _measure(_viewport) {
            let width = 0;
            let height = 0;
            for (const child of this.children) {
                const size_hint = child.measure({ width: 0, height: 0 });
                width += size_hint.width;
                height = Math.max(height, size_hint.height);
            }
            return { width, height };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            const top = this.absolute ? outer.top : 0;
            let left = this.absolute ? outer.left : 0;
            const { height } = outer;
            for (const child of this.children) {
                const { width } = child.measure({ width: 0, height: 0 });
                child.set_geometry(new bbox_1.BBox({ left, width, top, height }));
                left += width;
            }
        }
    }
    exports.HStack = HStack;
    HStack.__name__ = "HStack";
    class VStack extends Stack {
        _measure(_viewport) {
            let width = 0;
            let height = 0;
            for (const child of this.children) {
                const size_hint = child.measure({ width: 0, height: 0 });
                width = Math.max(width, size_hint.width);
                height += size_hint.height;
            }
            return { width, height };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            const left = this.absolute ? outer.left : 0;
            let top = this.absolute ? outer.top : 0;
            const { width } = outer;
            for (const child of this.children) {
                const { height } = child.measure({ width: 0, height: 0 });
                child.set_geometry(new bbox_1.BBox({ top, height, left, width }));
                top += height;
            }
        }
    }
    exports.VStack = VStack;
    VStack.__name__ = "VStack";
    class NodeLayout extends layoutable_1.Layoutable {
        constructor() {
            super(...arguments);
            this.children = [];
        }
        *[Symbol.iterator]() {
            yield* this.children;
        }
        _measure(viewport) {
            const { width_policy, height_policy } = this.sizing;
            const { min, max } = Math;
            let max_width = 0;
            let max_height = 0;
            for (const layout of this.children) {
                const { width, height } = layout.measure(viewport);
                max_width = max(max_width, width);
                max_height = max(max_height, height);
            }
            const width = (() => {
                const { width } = this.sizing;
                if (viewport.width == Infinity) {
                    return width_policy == "fixed" ? width !== null && width !== void 0 ? width : max_width : max_width;
                }
                else {
                    switch (width_policy) {
                        case "fixed": return width !== null && width !== void 0 ? width : max_width;
                        case "min": return /*width != null ? min(viewport.width, width) :*/ max_width;
                        case "fit": return width != null ? min(viewport.width, width) : viewport.width;
                        case "max": return width != null ? max(viewport.width, width) : viewport.width;
                    }
                }
            })();
            const height = (() => {
                const { height } = this.sizing;
                if (viewport.height == Infinity) {
                    return height_policy == "fixed" ? height !== null && height !== void 0 ? height : max_height : max_height;
                }
                else {
                    switch (height_policy) {
                        case "fixed": return height !== null && height !== void 0 ? height : max_height;
                        case "min": return /*height != null ? min(viewport.height, height) :*/ max_height;
                        case "fit": return height != null ? min(viewport.height, height) : viewport.height;
                        case "max": return height != null ? max(viewport.height, height) : viewport.height;
                    }
                }
            })();
            return { width, height };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            const bbox = this.absolute ? outer : outer.relative();
            const { left, right, top, bottom } = bbox;
            const vcenter = Math.round(bbox.vcenter);
            const hcenter = Math.round(bbox.hcenter);
            for (const layout of this.children) {
                const { margin, halign, valign } = layout.sizing;
                const { width, height, inner } = layout.measure(outer);
                const bbox = (() => {
                    const anchor = `${valign}_${halign}`;
                    switch (anchor) {
                        case "start_start": // "top_left"
                            return new bbox_1.BBox({ left: left + margin.left, top: top + margin.top, width, height });
                        case "start_center": // "top_center"
                            return new bbox_1.BBox({ hcenter, top: top + margin.top, width, height });
                        case "start_end": // "top_right"
                            return new bbox_1.BBox({ right: right - margin.right, top: top + margin.top, width, height });
                        case "center_start": // "center_left"
                            return new bbox_1.BBox({ left: left + margin.left, vcenter, width, height });
                        case "center_center": // "center"
                            return new bbox_1.BBox({ hcenter, vcenter, width, height });
                        case "center_end": // "center_right"
                            return new bbox_1.BBox({ right: right - margin.right, vcenter, width, height });
                        case "end_start": // "bottom_left"
                            return new bbox_1.BBox({ left: left + margin.left, bottom: bottom - margin.bottom, width, height });
                        case "end_center": // "bottom_center"
                            return new bbox_1.BBox({ hcenter, bottom: bottom - margin.bottom, width, height });
                        case "end_end": // "bottom_right"
                            return new bbox_1.BBox({ right: right - margin.right, bottom: bottom - margin.bottom, width, height });
                    }
                })();
                const inner_bbox = inner == null ? bbox : new bbox_1.BBox({
                    left: bbox.left + inner.left,
                    top: bbox.top + inner.top,
                    right: bbox.right - inner.right,
                    bottom: bbox.bottom - inner.bottom,
                });
                layout.set_geometry(bbox, inner_bbox);
            }
        }
    }
    exports.NodeLayout = NodeLayout;
    NodeLayout.__name__ = "NodeLayout";
},
/* core/layout/grid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(124) /* ./types */;
    const layoutable_1 = require(125) /* ./layoutable */;
    const types_2 = require(8) /* ../util/types */;
    const bbox_1 = require(65) /* ../util/bbox */;
    const array_1 = require(9) /* ../util/array */;
    const { max, round } = Math;
    class DefaultMap {
        constructor(def) {
            this.def = def;
            this._map = new Map();
        }
        get(key) {
            let value = this._map.get(key);
            if (value === undefined) {
                value = this.def();
                this._map.set(key, value);
            }
            return value;
        }
        apply(key, fn) {
            const value = this.get(key);
            this._map.set(key, fn(value));
        }
    }
    DefaultMap.__name__ = "DefaultMap";
    class Container {
        constructor() {
            this._items = [];
            this._nrows = 0;
            this._ncols = 0;
        }
        get nrows() {
            return this._nrows;
        }
        get ncols() {
            return this._ncols;
        }
        add(span, data) {
            const { r1, c1 } = span;
            this._nrows = max(this._nrows, r1 + 1);
            this._ncols = max(this._ncols, c1 + 1);
            this._items.push({ span, data });
        }
        at(r, c) {
            const selected = this._items.filter(({ span }) => {
                return span.r0 <= r && r <= span.r1 &&
                    span.c0 <= c && c <= span.c1;
            });
            return selected.map(({ data }) => data);
        }
        row(r) {
            const selected = this._items.filter(({ span }) => span.r0 <= r && r <= span.r1);
            return selected.map(({ data }) => data);
        }
        col(c) {
            const selected = this._items.filter(({ span }) => span.c0 <= c && c <= span.c1);
            return selected.map(({ data }) => data);
        }
        foreach(fn) {
            for (const { span, data } of this._items) {
                fn(span, data);
            }
        }
        map(fn) {
            const result = new Container();
            for (const { span, data } of this._items) {
                result.add(span, fn(span, data));
            }
            return result;
        }
    }
    Container.__name__ = "Container";
    class Grid extends layoutable_1.Layoutable {
        constructor(items = []) {
            super();
            this.items = items;
            this.rows = "auto";
            this.cols = "auto";
            this.spacing = 0;
        }
        *[Symbol.iterator]() {
            for (const { layout } of this.items) {
                yield layout;
            }
        }
        is_width_expanding() {
            if (super.is_width_expanding())
                return true;
            if (this.sizing.width_policy == "fixed")
                return false;
            const { cols } = this._state;
            return (0, array_1.some)(cols, (col) => col.policy == "max");
        }
        is_height_expanding() {
            if (super.is_height_expanding())
                return true;
            if (this.sizing.height_policy == "fixed")
                return false;
            const { rows } = this._state;
            return (0, array_1.some)(rows, (row) => row.policy == "max");
        }
        _init() {
            var _a, _b, _c, _d;
            super._init();
            const items = new Container();
            for (const { layout, row, col, row_span, col_span } of this.items) {
                if (layout.sizing.visible) {
                    const r0 = row;
                    const c0 = col;
                    const r1 = row + (row_span != null ? row_span : 1) - 1;
                    const c1 = col + (col_span != null ? col_span : 1) - 1;
                    items.add({ r0, c0, r1, c1 }, layout);
                }
            }
            const { nrows, ncols } = items;
            const rows = new Array(nrows);
            for (let y = 0; y < nrows; y++) {
                const row = (() => {
                    var _a;
                    const sizing = (0, types_2.isPlainObject)(this.rows) ? (_a = this.rows[y]) !== null && _a !== void 0 ? _a : this.rows["*"] : this.rows;
                    if (sizing == null)
                        return { policy: "auto" };
                    else if ((0, types_2.isNumber)(sizing))
                        return { policy: "fixed", height: sizing };
                    else if ((0, types_2.isString)(sizing))
                        return { policy: sizing };
                    else
                        return sizing;
                })();
                const align = (_a = row.align) !== null && _a !== void 0 ? _a : "auto";
                if (row.policy == "fixed")
                    rows[y] = { policy: "fixed", height: row.height, align };
                else if (row.policy == "min")
                    rows[y] = { policy: "min", align };
                else if (row.policy == "fit" || row.policy == "max")
                    rows[y] = { policy: row.policy, flex: (_b = row.flex) !== null && _b !== void 0 ? _b : 1, align };
                else if (row.policy == "auto") {
                    if ((0, array_1.some)(items.row(y), (layout) => layout.is_height_expanding()))
                        rows[y] = { policy: "max", flex: 1, align };
                    else
                        rows[y] = { policy: "min", align };
                }
                else
                    throw new Error("unrechable");
            }
            const cols = new Array(ncols);
            for (let x = 0; x < ncols; x++) {
                const col = (() => {
                    var _a;
                    const sizing = (0, types_2.isPlainObject)(this.cols) ? (_a = this.cols[x]) !== null && _a !== void 0 ? _a : this.cols["*"] : this.cols;
                    if (sizing == null)
                        return { policy: "auto" };
                    else if ((0, types_2.isNumber)(sizing))
                        return { policy: "fixed", width: sizing };
                    else if ((0, types_2.isString)(sizing))
                        return { policy: sizing };
                    else
                        return sizing;
                })();
                const align = (_c = col.align) !== null && _c !== void 0 ? _c : "auto";
                if (col.policy == "fixed")
                    cols[x] = { policy: "fixed", width: col.width, align };
                else if (col.policy == "min")
                    cols[x] = { policy: "min", align };
                else if (col.policy == "fit" || col.policy == "max")
                    cols[x] = { policy: col.policy, flex: (_d = col.flex) !== null && _d !== void 0 ? _d : 1, align };
                else if (col.policy == "auto") {
                    if ((0, array_1.some)(items.col(x), (layout) => layout.is_width_expanding()))
                        cols[x] = { policy: "max", flex: 1, align };
                    else
                        cols[x] = { policy: "min", align };
                }
                else
                    throw new Error("unrechable");
            }
            const [rspacing, cspacing] = (0, types_2.isNumber)(this.spacing) ? [this.spacing, this.spacing] : this.spacing;
            this._state = { items, nrows, ncols, rows, cols, rspacing, cspacing };
        }
        _measure_totals(row_heights, col_widths) {
            const { nrows, ncols, rspacing, cspacing } = this._state;
            return {
                height: (0, array_1.sum)(row_heights) + (nrows - 1) * rspacing,
                width: (0, array_1.sum)(col_widths) + (ncols - 1) * cspacing,
            };
        }
        _measure_cells(cell_viewport) {
            const { items, nrows, ncols, rows, cols, rspacing, cspacing } = this._state;
            const row_heights = new Array(nrows);
            for (let r = 0; r < nrows; r++) {
                const row = rows[r];
                row_heights[r] = row.policy == "fixed" ? row.height : 0;
            }
            const col_widths = new Array(ncols);
            for (let c = 0; c < ncols; c++) {
                const col = cols[c];
                col_widths[c] = col.policy == "fixed" ? col.width : 0;
            }
            const size_hints = new Container();
            items.foreach((span, layout) => {
                const { r0, c0, r1, c1 } = span;
                const rspace = (r1 - r0) * rspacing;
                const cspace = (c1 - c0) * cspacing;
                let height = 0;
                for (let r = r0; r <= r1; r++) {
                    height += cell_viewport(r, c0).height;
                }
                height += rspace;
                let width = 0;
                for (let c = c0; c <= c1; c++) {
                    width += cell_viewport(r0, c).width;
                }
                width += cspace;
                const size_hint = layout.measure({ width, height });
                size_hints.add(span, { layout, size_hint });
                const size = new types_1.Sizeable(size_hint).grow_by(layout.sizing.margin);
                size.height -= rspace;
                size.width -= cspace;
                const radjustable = [];
                for (let r = r0; r <= r1; r++) {
                    const row = rows[r];
                    if (row.policy == "fixed")
                        size.height -= row.height;
                    else
                        radjustable.push(r);
                }
                if (size.height > 0) {
                    const rheight = round(size.height / radjustable.length);
                    for (const r of radjustable) {
                        row_heights[r] = max(row_heights[r], rheight);
                    }
                }
                const cadjustable = [];
                for (let c = c0; c <= c1; c++) {
                    const col = cols[c];
                    if (col.policy == "fixed")
                        size.width -= col.width;
                    else
                        cadjustable.push(c);
                }
                if (size.width > 0) {
                    const cwidth = round(size.width / cadjustable.length);
                    for (const c of cadjustable) {
                        col_widths[c] = max(col_widths[c], cwidth);
                    }
                }
            });
            const size = this._measure_totals(row_heights, col_widths);
            return { size, row_heights, col_widths, size_hints };
        }
        _measure_grid(viewport) {
            const { nrows, ncols, rows, cols, rspacing, cspacing } = this._state;
            const preferred = this._measure_cells((y, x) => {
                const row = rows[y];
                const col = cols[x];
                return {
                    width: col.policy == "fixed" ? col.width : Infinity,
                    height: row.policy == "fixed" ? row.height : Infinity,
                };
            });
            let available_height;
            if (this.sizing.height_policy == "fixed" && this.sizing.height != null)
                available_height = this.sizing.height;
            else if (viewport.height != Infinity && this.is_height_expanding())
                available_height = viewport.height;
            else
                available_height = preferred.size.height;
            let height_flex = 0;
            for (let y = 0; y < nrows; y++) {
                const row = rows[y];
                if (row.policy == "fit" || row.policy == "max")
                    height_flex += row.flex;
                else
                    available_height -= preferred.row_heights[y];
            }
            available_height -= (nrows - 1) * rspacing;
            if (height_flex != 0 && available_height > 0) {
                for (let y = 0; y < nrows; y++) {
                    const row = rows[y];
                    if (row.policy == "fit" || row.policy == "max") {
                        const height = round(available_height * (row.flex / height_flex));
                        available_height -= height;
                        preferred.row_heights[y] = height;
                        height_flex -= row.flex;
                    }
                }
            }
            else if (available_height < 0) {
                let nadjustable = 0;
                for (let y = 0; y < nrows; y++) {
                    const row = rows[y];
                    if (row.policy != "fixed")
                        nadjustable++;
                }
                let overflow_height = -available_height;
                for (let y = 0; y < nrows; y++) {
                    const row = rows[y];
                    if (row.policy != "fixed") {
                        const height = preferred.row_heights[y];
                        const cutoff = round(overflow_height / nadjustable);
                        preferred.row_heights[y] = max(height - cutoff, 0);
                        overflow_height -= cutoff > height ? height : cutoff;
                        nadjustable--;
                    }
                }
            }
            let available_width;
            if (this.sizing.width_policy == "fixed" && this.sizing.width != null)
                available_width = this.sizing.width;
            else if (viewport.width != Infinity && this.is_width_expanding())
                available_width = viewport.width;
            else
                available_width = preferred.size.width;
            let width_flex = 0;
            for (let x = 0; x < ncols; x++) {
                const col = cols[x];
                if (col.policy == "fit" || col.policy == "max")
                    width_flex += col.flex;
                else
                    available_width -= preferred.col_widths[x];
            }
            available_width -= (ncols - 1) * cspacing;
            if (width_flex != 0 && available_width > 0) {
                for (let x = 0; x < ncols; x++) {
                    const col = cols[x];
                    if (col.policy == "fit" || col.policy == "max") {
                        const width = round(available_width * (col.flex / width_flex));
                        available_width -= width;
                        preferred.col_widths[x] = width;
                        width_flex -= col.flex;
                    }
                }
            }
            else if (available_width < 0) {
                let nadjustable = 0;
                for (let x = 0; x < ncols; x++) {
                    const col = cols[x];
                    if (col.policy != "fixed")
                        nadjustable++;
                }
                let overflow_width = -available_width;
                for (let x = 0; x < ncols; x++) {
                    const col = cols[x];
                    if (col.policy != "fixed") {
                        const width = preferred.col_widths[x];
                        const cutoff = round(overflow_width / nadjustable);
                        preferred.col_widths[x] = max(width - cutoff, 0);
                        overflow_width -= cutoff > width ? width : cutoff;
                        nadjustable--;
                    }
                }
            }
            const { row_heights, col_widths, size_hints } = this._measure_cells((y, x) => {
                return {
                    width: preferred.col_widths[x],
                    height: preferred.row_heights[y],
                };
            });
            const size = this._measure_totals(row_heights, col_widths);
            return { size, row_heights, col_widths, size_hints };
        }
        _measure(viewport) {
            const { size } = this._measure_grid(viewport);
            return size;
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            const { nrows, ncols, rspacing, cspacing } = this._state;
            const { row_heights, col_widths, size_hints } = this._measure_grid(outer);
            const rows = this._state.rows.map((row, r) => {
                return Object.assign(Object.assign({}, row), { top: 0, height: row_heights[r], get bottom() { return this.top + this.height; } });
            });
            const cols = this._state.cols.map((col, c) => {
                return Object.assign(Object.assign({}, col), { left: 0, width: col_widths[c], get right() { return this.left + this.width; } });
            });
            const items = size_hints.map((_, item) => {
                return Object.assign(Object.assign({}, item), { outer: new bbox_1.BBox(), inner: new bbox_1.BBox() });
            });
            for (let r = 0, top = !this.absolute ? 0 : outer.top; r < nrows; r++) {
                const row = rows[r];
                row.top = top;
                top += row.height + rspacing;
            }
            for (let c = 0, left = !this.absolute ? 0 : outer.left; c < ncols; c++) {
                const col = cols[c];
                col.left = left;
                left += col.width + cspacing;
            }
            function span_width(c0, c1) {
                let width = (c1 - c0) * cspacing;
                for (let c = c0; c <= c1; c++) {
                    width += cols[c].width;
                }
                return width;
            }
            function span_height(r0, r1) {
                let height = (r1 - r0) * rspacing;
                for (let r = r0; r <= r1; r++) {
                    height += rows[r].height;
                }
                return height;
            }
            items.foreach(({ r0, c0, r1, c1 }, item) => {
                const { layout, size_hint } = item;
                const { sizing } = layout;
                const { width, height } = size_hint;
                const span = {
                    width: span_width(c0, c1),
                    height: span_height(r0, r1),
                };
                const halign = c0 == c1 && cols[c0].align != "auto" ? cols[c0].align : sizing.halign;
                const valign = r0 == r1 && rows[r0].align != "auto" ? rows[r0].align : sizing.valign;
                let left = cols[c0].left;
                if (halign == "start")
                    left += sizing.margin.left;
                else if (halign == "center")
                    left += round((span.width - width) / 2);
                else if (halign == "end")
                    left += span.width - sizing.margin.right - width;
                let top = rows[r0].top;
                if (valign == "start")
                    top += sizing.margin.top;
                else if (valign == "center")
                    top += round((span.height - height) / 2);
                else if (valign == "end")
                    top += span.height - sizing.margin.bottom - height;
                item.outer = new bbox_1.BBox({ left, top, width, height });
            });
            const row_aligns = rows.map(() => {
                return {
                    start: new DefaultMap(() => 0),
                    end: new DefaultMap(() => 0),
                };
            });
            const col_aligns = cols.map(() => {
                return {
                    start: new DefaultMap(() => 0),
                    end: new DefaultMap(() => 0),
                };
            });
            items.foreach(({ r0, c0, r1, c1 }, { size_hint, outer }) => {
                const { inner } = size_hint;
                if (inner != null) {
                    row_aligns[r0].start.apply(outer.top, (v) => max(v, inner.top));
                    row_aligns[r1].end.apply(rows[r1].bottom - outer.bottom, (v) => max(v, inner.bottom));
                    col_aligns[c0].start.apply(outer.left, (v) => max(v, inner.left));
                    col_aligns[c1].end.apply(cols[c1].right - outer.right, (v) => max(v, inner.right));
                }
            });
            items.foreach(({ r0, c0, r1, c1 }, item) => {
                const { size_hint, outer } = item;
                const inner_bbox = (extents) => {
                    const outer_bbox = this.absolute ? outer : outer.relative();
                    const left = outer_bbox.left + extents.left;
                    const top = outer_bbox.top + extents.top;
                    const right = outer_bbox.right - extents.right;
                    const bottom = outer_bbox.bottom - extents.bottom;
                    return new bbox_1.BBox({ left, top, right, bottom });
                };
                if (size_hint.inner != null) {
                    let inner = inner_bbox(size_hint.inner);
                    if (size_hint.align !== false) {
                        const top = row_aligns[r0].start.get(outer.top);
                        const bottom = row_aligns[r1].end.get(rows[r1].bottom - outer.bottom);
                        const left = col_aligns[c0].start.get(outer.left);
                        const right = col_aligns[c1].end.get(cols[c1].right - outer.right);
                        try {
                            inner = inner_bbox({ top, bottom, left, right });
                        }
                        catch (_a) { }
                    }
                    item.inner = inner;
                }
                else
                    item.inner = outer;
            });
            items.foreach((_, { layout, outer, inner }) => {
                layout.set_geometry(outer, inner);
            });
        }
    }
    exports.Grid = Grid;
    Grid.__name__ = "Grid";
    class Row extends Grid {
        constructor(items) {
            super();
            this.items = items.map((item, i) => ({ layout: item, row: 0, col: i }));
            this.rows = "fit";
        }
    }
    exports.Row = Row;
    Row.__name__ = "Row";
    class Column extends Grid {
        constructor(items) {
            super();
            this.items = items.map((item, i) => ({ layout: item, row: i, col: 0 }));
            this.cols = "fit";
        }
    }
    exports.Column = Column;
    Column.__name__ = "Column";
},
/* core/layout/html.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const layoutable_1 = require(125) /* ./layoutable */;
    const types_1 = require(124) /* ./types */;
    const dom_1 = require(43) /* ../dom */;
    class ContentBox extends layoutable_1.ContentLayoutable {
        constructor(el) {
            super();
            this.content_size = (0, dom_1.unsized)(el, () => new types_1.Sizeable((0, dom_1.size)(el)));
        }
        _content_size() {
            return this.content_size;
        }
    }
    exports.ContentBox = ContentBox;
    ContentBox.__name__ = "ContentBox";
    class VariadicBox extends layoutable_1.Layoutable {
        constructor(el) {
            super();
            this.el = el;
        }
        _measure(viewport) {
            const bounded = new types_1.Sizeable(viewport).bounded_to(this.sizing.size);
            return (0, dom_1.sized)(this.el, bounded, () => {
                const content = new types_1.Sizeable((0, dom_1.content_size)(this.el));
                const { border, padding } = (0, dom_1.extents)(this.el);
                return content.grow_by(border).grow_by(padding).map(Math.ceil);
            });
        }
    }
    exports.VariadicBox = VariadicBox;
    VariadicBox.__name__ = "VariadicBox";
    class CachedVariadicBox extends VariadicBox {
        constructor(el) {
            super(el);
            this._cache = new Map();
        }
        _measure(viewport) {
            const { width, height } = viewport;
            const key = `${width},${height}`;
            let size_hint = this._cache.get(key);
            if (size_hint == null) {
                size_hint = super._measure(viewport);
                this._cache.set(key, size_hint);
            }
            return size_hint;
        }
        invalidate_cache() {
            this._cache.clear();
        }
    }
    exports.CachedVariadicBox = CachedVariadicBox;
    CachedVariadicBox.__name__ = "CachedVariadicBox";
},
/* core/layout/border.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(124) /* ./types */;
    const layoutable_1 = require(125) /* ./layoutable */;
    const bbox_1 = require(65) /* ../util/bbox */;
    class BorderLayout extends layoutable_1.Layoutable {
        constructor() {
            super(...arguments);
            this.min_border = { left: 0, top: 0, right: 0, bottom: 0 };
            this.padding = { left: 0, top: 0, right: 0, bottom: 0 };
        }
        *[Symbol.iterator]() {
            yield this.top_panel;
            yield this.bottom_panel;
            yield this.left_panel;
            yield this.right_panel;
            yield this.center_panel;
        }
        _measure(viewport) {
            viewport = new types_1.Sizeable({
                width: this.sizing.width_policy == "fixed" || viewport.width == Infinity ? this.sizing.width : viewport.width,
                height: this.sizing.height_policy == "fixed" || viewport.height == Infinity ? this.sizing.height : viewport.height,
            });
            const left_hint = this.left_panel.measure({ width: 0, height: viewport.height });
            const left = Math.max(left_hint.width, this.min_border.left) + this.padding.left;
            const right_hint = this.right_panel.measure({ width: 0, height: viewport.height });
            const right = Math.max(right_hint.width, this.min_border.right) + this.padding.right;
            const top_hint = this.top_panel.measure({ width: viewport.width, height: 0 });
            const top = Math.max(top_hint.height, this.min_border.top) + this.padding.top;
            const bottom_hint = this.bottom_panel.measure({ width: viewport.width, height: 0 });
            const bottom = Math.max(bottom_hint.height, this.min_border.bottom) + this.padding.bottom;
            const center_viewport = new types_1.Sizeable(viewport).shrink_by({ left, right, top, bottom });
            const center = this.center_panel.measure(center_viewport);
            const width = left + center.width + right;
            const height = top + center.height + bottom;
            const align = (() => {
                const { width_policy, height_policy } = this.center_panel.sizing;
                return width_policy != "fixed" && height_policy != "fixed";
            })();
            return { width, height, inner: { left, right, top, bottom }, align };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            this.center_panel.set_geometry(inner);
            const left_hint = this.left_panel.measure({ width: 0, height: outer.height });
            const right_hint = this.right_panel.measure({ width: 0, height: outer.height });
            const top_hint = this.top_panel.measure({ width: outer.width, height: 0 });
            const bottom_hint = this.bottom_panel.measure({ width: outer.width, height: 0 });
            const { left, top, right, bottom } = inner;
            this.top_panel.set_geometry(new bbox_1.BBox({ left, right, bottom: top, height: top_hint.height }));
            this.bottom_panel.set_geometry(new bbox_1.BBox({ left, right, top: bottom, height: bottom_hint.height }));
            this.left_panel.set_geometry(new bbox_1.BBox({ top, bottom, right: left, width: left_hint.width }));
            this.right_panel.set_geometry(new bbox_1.BBox({ top, bottom, left: right, width: right_hint.width }));
        }
    }
    exports.BorderLayout = BorderLayout;
    BorderLayout.__name__ = "BorderLayout";
},
/* models/annotations/label.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const text_annotation_1 = require(119) /* ./text_annotation */;
    const math_1 = require(10) /* ../../core/util/math */;
    const enums_1 = require(20) /* ../../core/enums */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    const side_panel_1 = require(123) /* ../../core/layout/side_panel */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    class LabelView extends text_annotation_1.TextAnnotationView {
        update_layout() {
            const { panel } = this;
            if (panel != null)
                this.layout = new side_panel_1.SideLayout(panel, () => this.get_size(), false);
            else
                this.layout = undefined;
        }
        _get_size() {
            const { text } = this.model;
            const graphics = new graphics_1.TextBox({ text });
            const { angle, angle_units } = this.model;
            graphics.angle = (0, math_1.resolve_angle)(angle, angle_units);
            graphics.visuals = this.visuals.text.values();
            const { width, height } = graphics.size();
            return { width, height };
        }
        _render() {
            const { angle, angle_units } = this.model;
            const rotation = (0, math_1.resolve_angle)(angle, angle_units);
            const panel = this.layout != null ? this.layout : this.plot_view.frame;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            let sx = this.model.x_units == "data" ? xscale.compute(this.model.x) : panel.bbox.xview.compute(this.model.x);
            let sy = this.model.y_units == "data" ? yscale.compute(this.model.y) : panel.bbox.yview.compute(this.model.y);
            sx += this.model.x_offset;
            sy -= this.model.y_offset;
            const draw = this.model.render_mode == "canvas" ? this._canvas_text.bind(this) : this._css_text.bind(this);
            draw(this.layer.ctx, this.model.text, sx, sy, rotation);
        }
    }
    exports.LabelView = LabelView;
    LabelView.__name__ = "LabelView";
    class Label extends text_annotation_1.TextAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Label = Label;
    _a = Label;
    Label.__name__ = "Label";
    (() => {
        _a.prototype.default_view = LabelView;
        _a.mixins([
            mixins.Text,
            ["border_", mixins.Line],
            ["background_", mixins.Fill],
        ]);
        _a.define(({ Number, String, Angle }) => ({
            x: [Number],
            x_units: [enums_1.SpatialUnits, "data"],
            y: [Number],
            y_units: [enums_1.SpatialUnits, "data"],
            text: [String, ""],
            angle: [Angle, 0],
            angle_units: [enums_1.AngleUnits, "rad"],
            x_offset: [Number, 0],
            y_offset: [Number, 0],
        }));
        _a.override({
            background_fill_color: null,
            border_line_color: null,
        });
    })();
},
/* models/annotations/label_set.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const data_annotation_1 = require(69) /* ./data_annotation */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    const dom_1 = require(43) /* ../../core/dom */;
    const graphics_1 = require(120) /* ../../core/graphics */;
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    const assert_1 = require(11) /* ../../core/util/assert */;
    class LabelSetView extends data_annotation_1.DataAnnotationView {
        set_data(source) {
            var _b;
            super.set_data(source);
            (_b = this.els) === null || _b === void 0 ? void 0 : _b.forEach((el) => (0, dom_1.remove)(el));
            if (this.model.render_mode == "css") {
                const els = this.els = [...this.text].map(() => (0, dom_1.div)({ style: { display: "none" } }));
                for (const el of els) {
                    this.plot_view.canvas_view.add_overlay(el);
                }
            }
            else
                delete this.els;
        }
        remove() {
            var _b;
            (_b = this.els) === null || _b === void 0 ? void 0 : _b.forEach((el) => (0, dom_1.remove)(el));
            super.remove();
        }
        _rerender() {
            if (this.model.render_mode == "css")
                this.render();
            else
                this.request_render();
        }
        map_data() {
            const { x_scale, y_scale } = this.coordinates;
            const panel = this.layout != null ? this.layout : this.plot_view.frame;
            this.sx = this.model.x_units == "data" ? x_scale.v_compute(this._x) : panel.bbox.xview.v_compute(this._x);
            this.sy = this.model.y_units == "data" ? y_scale.v_compute(this._y) : panel.bbox.yview.v_compute(this._y);
        }
        paint() {
            const draw = this.model.render_mode == "canvas" ? this._v_canvas_text.bind(this) : this._v_css_text.bind(this);
            const { ctx } = this.layer;
            for (let i = 0, end = this.text.length; i < end; i++) {
                const x_offset_i = this.x_offset.get(i);
                const y_offset_i = this.y_offset.get(i);
                const sx_i = this.sx[i] + x_offset_i;
                const sy_i = this.sy[i] - y_offset_i;
                const angle_i = this.angle.get(i);
                const text_i = this.text.get(i);
                draw(ctx, i, text_i, sx_i, sy_i, angle_i);
            }
        }
        _v_canvas_text(ctx, i, text, sx, sy, angle) {
            const graphics = new graphics_1.TextBox({ text });
            graphics.angle = angle;
            graphics.position = { sx, sy };
            graphics.visuals = this.visuals.text.values(i);
            const { background_fill, border_line } = this.visuals;
            if (background_fill.doit || border_line.doit) {
                const { p0, p1, p2, p3 } = graphics.rect();
                ctx.beginPath();
                ctx.moveTo(p0.x, p0.y);
                ctx.lineTo(p1.x, p1.y);
                ctx.lineTo(p2.x, p2.y);
                ctx.lineTo(p3.x, p3.y);
                ctx.closePath();
                this.visuals.background_fill.apply(ctx, i);
                this.visuals.border_line.apply(ctx, i);
            }
            if (this.visuals.text.doit)
                graphics.paint(ctx);
        }
        _v_css_text(ctx, i, text, sx, sy, angle) {
            (0, assert_1.assert)(this.els != null);
            const el = this.els[i];
            el.textContent = text;
            this.visuals.text.set_vectorize(ctx, i);
            el.style.position = "absolute";
            el.style.left = `${sx}px`;
            el.style.top = `${sy}px`;
            el.style.color = ctx.fillStyle;
            el.style.font = ctx.font;
            el.style.lineHeight = "normal"; // needed to prevent ipynb css override
            el.style.whiteSpace = "pre";
            const [x_anchor, x_t] = (() => {
                switch (this.visuals.text.text_align.get(i)) {
                    case "left": return ["left", "0%"];
                    case "center": return ["center", "-50%"];
                    case "right": return ["right", "-100%"];
                }
            })();
            const [y_anchor, y_t] = (() => {
                switch (this.visuals.text.text_baseline.get(i)) {
                    case "top": return ["top", "0%"];
                    case "middle": return ["center", "-50%"];
                    case "bottom": return ["bottom", "-100%"];
                    default: return ["center", "-50%"]; // "baseline"
                }
            })();
            let transform = `translate(${x_t}, ${y_t})`;
            if (angle) {
                transform += `rotate(${angle}rad)`;
            }
            el.style.transformOrigin = `${x_anchor} ${y_anchor}`;
            el.style.transform = transform;
            if (this.layout == null) {
                // const {bbox} = this.plot_view.frame
                // const {left, right, top, bottom} = bbox
                // el.style.clipPath = ???
            }
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_vectorize(ctx, i);
                el.style.backgroundColor = ctx.fillStyle;
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_vectorize(ctx, i);
                // attempt to support vector-style ("8 4 8") line dashing for css mode
                el.style.borderStyle = ctx.lineDash.length < 2 ? "solid" : "dashed";
                el.style.borderWidth = `${ctx.lineWidth}px`;
                el.style.borderColor = ctx.strokeStyle;
            }
            (0, dom_1.display)(el);
        }
    }
    exports.LabelSetView = LabelSetView;
    LabelSetView.__name__ = "LabelSetView";
    class LabelSet extends data_annotation_1.DataAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.LabelSet = LabelSet;
    _a = LabelSet;
    LabelSet.__name__ = "LabelSet";
    (() => {
        _a.prototype.default_view = LabelSetView;
        _a.mixins([
            mixins.TextVector,
            ["border_", mixins.LineVector],
            ["background_", mixins.FillVector],
        ]);
        _a.define(() => ({
            x: [p.XCoordinateSpec, { field: "x" }],
            y: [p.YCoordinateSpec, { field: "y" }],
            x_units: [enums_1.SpatialUnits, "data"],
            y_units: [enums_1.SpatialUnits, "data"],
            text: [p.StringSpec, { field: "text" }],
            angle: [p.AngleSpec, 0],
            x_offset: [p.NumberSpec, { value: 0 }],
            y_offset: [p.NumberSpec, { value: 0 }],
            /** @deprecated */
            render_mode: [enums_1.RenderMode, "canvas"],
        }));
        _a.override({
            background_fill_color: null,
            border_line_color: null,
        });
    })();
},
/* models/annotations/legend.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(40) /* ./annotation */;
    const legend_item_1 = require(215) /* ./legend_item */;
    const enums_1 = require(20) /* ../../core/enums */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const signaling_1 = require(15) /* ../../core/signaling */;
    const side_panel_1 = require(123) /* ../../core/layout/side_panel */;
    const text_1 = require(121) /* ../../core/util/text */;
    const bbox_1 = require(65) /* ../../core/util/bbox */;
    const array_1 = require(9) /* ../../core/util/array */;
    const types_1 = require(8) /* ../../core/util/types */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    class LegendView extends annotation_1.AnnotationView {
        update_layout() {
            const { panel } = this;
            if (panel != null)
                this.layout = new side_panel_1.SideLayout(panel, () => this.get_size());
            else
                this.layout = undefined;
        }
        cursor(_sx, _sy) {
            return this.model.click_policy == "none" ? null : "pointer";
        }
        get legend_padding() {
            return this.model.border_line_color != null ? this.model.padding : 0;
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.request_render());
            this.connect(this.model.item_change, () => this.request_render());
        }
        compute_legend_bbox() {
            const legend_names = this.model.get_legend_names();
            const { glyph_height, glyph_width } = this.model;
            const { label_height, label_width } = this.model;
            this.max_label_height = (0, array_1.max)([(0, text_1.font_metrics)(this.visuals.label_text.font_value()).height, label_height, glyph_height]);
            // this is to measure text properties
            const { ctx } = this.layer;
            ctx.save();
            this.visuals.label_text.set_value(ctx);
            this.text_widths = new Map();
            for (const name of legend_names) {
                this.text_widths.set(name, (0, array_1.max)([ctx.measureText(name).width, label_width]));
            }
            this.visuals.title_text.set_value(ctx);
            this.title_height = this.model.title ? (0, text_1.font_metrics)(this.visuals.title_text.font_value()).height + this.model.title_standoff : 0;
            this.title_width = this.model.title ? ctx.measureText(this.model.title).width : 0;
            ctx.restore();
            const max_label_width = Math.max((0, array_1.max)([...this.text_widths.values()]), 0);
            const legend_margin = this.model.margin;
            const { legend_padding } = this;
            const legend_spacing = this.model.spacing;
            const { label_standoff } = this.model;
            let legend_height, legend_width;
            if (this.model.orientation == "vertical") {
                legend_height = legend_names.length * this.max_label_height + Math.max(legend_names.length - 1, 0) * legend_spacing + 2 * legend_padding + this.title_height;
                legend_width = (0, array_1.max)([(max_label_width + glyph_width + label_standoff + 2 * legend_padding), this.title_width + 2 * legend_padding]);
            }
            else {
                let item_width = 2 * legend_padding + Math.max(legend_names.length - 1, 0) * legend_spacing;
                for (const [, width] of this.text_widths) {
                    item_width += (0, array_1.max)([width, label_width]) + glyph_width + label_standoff;
                }
                legend_width = (0, array_1.max)([this.title_width + 2 * legend_padding, item_width]);
                legend_height = this.max_label_height + this.title_height + 2 * legend_padding;
            }
            const panel = this.layout != null ? this.layout : this.plot_view.frame;
            const [hr, vr] = panel.bbox.ranges;
            const { location } = this.model;
            let sx, sy;
            if ((0, types_1.isString)(location)) {
                switch (location) {
                    case "top_left":
                        sx = hr.start + legend_margin;
                        sy = vr.start + legend_margin;
                        break;
                    case "top":
                    case "top_center":
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.start + legend_margin;
                        break;
                    case "top_right":
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.start + legend_margin;
                        break;
                    case "bottom_right":
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case "bottom":
                    case "bottom_center":
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case "bottom_left":
                        sx = hr.start + legend_margin;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case "left":
                    case "center_left":
                        sx = hr.start + legend_margin;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case "center":
                    case "center_center":
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case "right":
                    case "center_right":
                        sx = hr.end - legend_margin - legend_width;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                }
            }
            else if ((0, types_1.isArray)(location) && location.length == 2) {
                const [vx, vy] = location;
                sx = panel.bbox.xview.compute(vx);
                sy = panel.bbox.yview.compute(vy) - legend_height;
            }
            else
                (0, assert_1.unreachable)();
            return new bbox_1.BBox({ left: sx, top: sy, width: legend_width, height: legend_height });
        }
        interactive_bbox() {
            return this.compute_legend_bbox();
        }
        interactive_hit(sx, sy) {
            const bbox = this.interactive_bbox();
            return bbox.contains(sx, sy);
        }
        on_hit(sx, sy) {
            let yoffset;
            const { glyph_width } = this.model;
            const { legend_padding } = this;
            const legend_spacing = this.model.spacing;
            const { label_standoff } = this.model;
            let xoffset = (yoffset = legend_padding);
            const legend_bbox = this.compute_legend_bbox();
            const vertical = this.model.orientation == "vertical";
            for (const item of this.model.items) {
                const labels = item.get_labels_list_from_label_prop();
                for (const label of labels) {
                    const x1 = legend_bbox.x + xoffset;
                    const y1 = legend_bbox.y + yoffset + this.title_height;
                    let w, h;
                    if (vertical)
                        [w, h] = [legend_bbox.width - 2 * legend_padding, this.max_label_height];
                    else
                        [w, h] = [this.text_widths.get(label) + glyph_width + label_standoff, this.max_label_height];
                    const bbox = new bbox_1.BBox({ left: x1, top: y1, width: w, height: h });
                    if (bbox.contains(sx, sy)) {
                        switch (this.model.click_policy) {
                            case "hide": {
                                for (const r of item.renderers)
                                    r.visible = !r.visible;
                                break;
                            }
                            case "mute": {
                                for (const r of item.renderers)
                                    r.muted = !r.muted;
                                break;
                            }
                        }
                        return true;
                    }
                    if (vertical)
                        yoffset += this.max_label_height + legend_spacing;
                    else
                        xoffset += this.text_widths.get(label) + glyph_width + label_standoff + legend_spacing;
                }
            }
            return false;
        }
        _render() {
            if (this.model.items.length == 0)
                return;
            if (!(0, array_1.some)(this.model.items, item => item.visible))
                return;
            // set a backref on render so that items can later signal item_change upates
            // on the model to trigger a re-render
            for (const item of this.model.items) {
                item.legend = this.model;
            }
            const { ctx } = this.layer;
            const bbox = this.compute_legend_bbox();
            ctx.save();
            this._draw_legend_box(ctx, bbox);
            this._draw_legend_items(ctx, bbox);
            this._draw_title(ctx, bbox);
            ctx.restore();
        }
        _draw_legend_box(ctx, bbox) {
            ctx.beginPath();
            ctx.rect(bbox.x, bbox.y, bbox.width, bbox.height);
            this.visuals.background_fill.apply(ctx);
            this.visuals.border_line.apply(ctx);
        }
        _draw_legend_items(ctx, bbox) {
            const { glyph_width, glyph_height } = this.model;
            const { legend_padding } = this;
            const legend_spacing = this.model.spacing;
            const { label_standoff } = this.model;
            let xoffset = legend_padding;
            let yoffset = legend_padding;
            const vertical = this.model.orientation == "vertical";
            for (const item of this.model.items) {
                if (!item.visible)
                    continue;
                const labels = item.get_labels_list_from_label_prop();
                const field = item.get_field_from_label_prop();
                if (labels.length == 0)
                    continue;
                const active = (() => {
                    switch (this.model.click_policy) {
                        case "none": return true;
                        case "hide": return (0, array_1.every)(item.renderers, r => r.visible);
                        case "mute": return (0, array_1.every)(item.renderers, r => !r.muted);
                    }
                })();
                for (const label of labels) {
                    const x1 = bbox.x + xoffset;
                    const y1 = bbox.y + yoffset + this.title_height;
                    const x2 = x1 + glyph_width;
                    const y2 = y1 + glyph_height;
                    if (vertical)
                        yoffset += this.max_label_height + legend_spacing;
                    else
                        xoffset += this.text_widths.get(label) + glyph_width + label_standoff + legend_spacing;
                    this.visuals.label_text.set_value(ctx);
                    ctx.fillText(label, x2 + label_standoff, y1 + this.max_label_height / 2.0);
                    for (const r of item.renderers) {
                        const view = this.plot_view.renderer_view(r);
                        view === null || view === void 0 ? void 0 : view.draw_legend(ctx, x1, x2, y1, y2, field, label, item.index);
                    }
                    if (!active) {
                        let w, h;
                        if (vertical)
                            [w, h] = [bbox.width - 2 * legend_padding, this.max_label_height];
                        else
                            [w, h] = [this.text_widths.get(label) + glyph_width + label_standoff, this.max_label_height];
                        ctx.beginPath();
                        ctx.rect(x1, y1, w, h);
                        this.visuals.inactive_fill.set_value(ctx);
                        ctx.fill();
                    }
                }
            }
        }
        _draw_title(ctx, bbox) {
            const { title } = this.model;
            if (!title || !this.visuals.title_text.doit)
                return;
            ctx.save();
            ctx.translate(bbox.x0, bbox.y0 + this.title_height);
            this.visuals.title_text.set_value(ctx);
            ctx.fillText(title, this.legend_padding, this.legend_padding - this.model.title_standoff);
            ctx.restore();
        }
        _get_size() {
            const { width, height } = this.compute_legend_bbox();
            return {
                width: width + 2 * this.model.margin,
                height: height + 2 * this.model.margin,
            };
        }
    }
    exports.LegendView = LegendView;
    LegendView.__name__ = "LegendView";
    class Legend extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this.item_change = new signaling_1.Signal0(this, "item_change");
        }
        get_legend_names() {
            const legend_names = [];
            for (const item of this.items) {
                const labels = item.get_labels_list_from_label_prop();
                legend_names.push(...labels);
            }
            return legend_names;
        }
    }
    exports.Legend = Legend;
    _a = Legend;
    Legend.__name__ = "Legend";
    (() => {
        _a.prototype.default_view = LegendView;
        _a.mixins([
            ["label_", mixins.Text],
            ["title_", mixins.Text],
            ["inactive_", mixins.Fill],
            ["border_", mixins.Line],
            ["background_", mixins.Fill],
        ]);
        _a.define(({ Number, String, Array, Tuple, Or, Ref, Nullable }) => ({
            orientation: [enums_1.Orientation, "vertical"],
            location: [Or(enums_1.LegendLocation, Tuple(Number, Number)), "top_right"],
            title: [Nullable(String), null],
            title_standoff: [Number, 5],
            label_standoff: [Number, 5],
            glyph_height: [Number, 20],
            glyph_width: [Number, 20],
            label_height: [Number, 20],
            label_width: [Number, 20],
            margin: [Number, 10],
            padding: [Number, 10],
            spacing: [Number, 3],
            items: [Array(Ref(legend_item_1.LegendItem)), []],
            click_policy: [enums_1.LegendClickPolicy, "none"],
        }));
        _a.override({
            border_line_color: "#e5e5e5",
            border_line_alpha: 0.5,
            border_line_width: 1,
            background_fill_color: "#ffffff",
            background_fill_alpha: 0.95,
            inactive_fill_color: "white",
            inactive_fill_alpha: 0.7,
            label_text_font_size: "13px",
            label_text_baseline: "middle",
            title_text_font_size: "13px",
            title_text_font_style: "italic",
        });
    })();
},
/* models/annotations/legend_item.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const model_1 = require(53) /* ../../model */;
    const glyph_renderer_1 = require(175) /* ../renderers/glyph_renderer */;
    const columnar_data_source_1 = require(70) /* ../sources/columnar_data_source */;
    const vectorization_1 = require(216) /* ../../core/vectorization */;
    const p = (0, tslib_1.__importStar)(require(18) /* ../../core/properties */);
    const logging_1 = require(19) /* ../../core/logging */;
    const array_1 = require(9) /* ../../core/util/array */;
    class LegendItem extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        /*protected*/ _check_data_sources_on_renderers() {
            const field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                const source = this.renderers[0].data_source;
                if (source != null) {
                    for (const r of this.renderers) {
                        if (r.data_source != source) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        /*protected*/ _check_field_label_on_data_source() {
            const field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                const source = this.renderers[0].data_source;
                if (source != null && !(0, array_1.includes)(source.columns(), field)) {
                    return false;
                }
            }
            return true;
        }
        initialize() {
            super.initialize();
            this.legend = null;
            this.connect(this.change, () => { var _b; return (_b = this.legend) === null || _b === void 0 ? void 0 : _b.item_change.emit(); });
            // Validate data_sources match
            const data_source_validation = this._check_data_sources_on_renderers();
            if (!data_source_validation)
                logging_1.logger.error("Non matching data sources on legend item renderers");
            // Validate label in data_source
            const field_validation = this._check_field_label_on_data_source();
            if (!field_validation)
                logging_1.logger.error(`Bad column name on label: ${this.label}`);
        }
        get_field_from_label_prop() {
            const { label } = this;
            return (0, vectorization_1.isField)(label) ? label.field : null;
        }
        get_labels_list_from_label_prop() {
            if (!this.visible)
                return [];
            if ((0, vectorization_1.isValue)(this.label)) {
                const { value } = this.label;
                return value != null ? [value] : [];
            }
            const field = this.get_field_from_label_prop();
            if (field != null) {
                let source;
                if (this.renderers[0] && this.renderers[0].data_source != null)
                    source = this.renderers[0].data_source;
                else
                    return ["No source found"];
                if (source instanceof columnar_data_source_1.ColumnarDataSource) {
                    const data = source.get_column(field);
                    if (data != null)
                        return (0, array_1.uniq)(Array.from(data));
                    else
                        return ["Invalid field"];
                }
            }
            return [];
        }
    }
    exports.LegendItem = LegendItem;
    _a = LegendItem;
    LegendItem.__name__ = "LegendItem";
    (() => {
        _a.define(({ Boolean, Int, Array, Ref, Nullable }) => ({
            label: [p.NullStringSpec, null],
            renderers: [Array(Ref(glyph_renderer_1.GlyphRenderer)), []],
            index: [Nullable(Int), null],
            visible: [Boolean, true],
        }));
    })();
},
/* core/vectorization.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./util/types */;
    function isValue(obj) {
        return (0, types_1.isPlainObject)(obj) && "value" in obj;
    }
    exports.isValue = isValue;
    function isField(obj) {
        return (0, types_1.isPlainObject)(obj) && "field" in obj;
    }
    exports.isField = isField;
    function isExpr(obj) {
        return (0, types_1.isPlainObject)(obj) && "expr" in obj;
    }
    exports.isExpr = isExpr;
},
/* models/annotations/poly_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(40) /* ./annotation */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    class PolyAnnotationView extends annotation_1.AnnotationView {
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.request_render());
        }
        _render() {
            const { xs, ys } = this.model;
            if (xs.length != ys.length)
                return;
            const n = xs.length;
            if (n < 3)
                return;
            const { frame } = this.plot_view;
            const { ctx } = this.layer;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const { screen } = this.model;
            function _calc_dim(values, units, scale, view) {
                if (screen)
                    return values;
                else
                    return units == "data" ? scale.v_compute(values) : view.v_compute(values);
            }
            const sxs = _calc_dim(xs, this.model.xs_units, xscale, frame.bbox.xview);
            const sys = _calc_dim(ys, this.model.ys_units, yscale, frame.bbox.yview);
            ctx.beginPath();
            for (let i = 0; i < n; i++) {
                ctx.lineTo(sxs[i], sys[i]);
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
            this.visuals.line.apply(ctx);
        }
    }
    exports.PolyAnnotationView = PolyAnnotationView;
    PolyAnnotationView.__name__ = "PolyAnnotationView";
    class PolyAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        update({ xs, ys }) {
            this.setv({ xs, ys, screen: true }, { check_eq: false }); // XXX: because of inplace updates in tools
        }
    }
    exports.PolyAnnotation = PolyAnnotation;
    _a = PolyAnnotation;
    PolyAnnotation.__name__ = "PolyAnnotation";
    (() => {
        _a.prototype.default_view = PolyAnnotationView;
        _a.mixins([mixins.Line, mixins.Fill, mixins.Hatch]);
        _a.define(({ Number, Array }) => ({
            xs: [Array(Number), []],
            xs_units: [enums_1.SpatialUnits, "data"],
            ys: [Array(Number), []],
            ys_units: [enums_1.SpatialUnits, "data"],
        }));
        _a.internal(({ Boolean }) => ({
            screen: [Boolean, false],
        }));
        _a.override({
            fill_color: "#fff9ba",
            fill_alpha: 0.4,
            line_color: "#cccccc",
            line_alpha: 0.3,
        });
    })();
},
/* models/annotations/slope.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(40) /* ./annotation */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    class SlopeView extends annotation_1.AnnotationView {
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.request_render());
        }
        _render() {
            const { gradient, y_intercept } = this.model;
            if (gradient == null || y_intercept == null)
                return;
            const { frame } = this.plot_view;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            let sy_start, sy_end, sx_start, sx_end;
            if (gradient == 0) {
                sy_start = yscale.compute(y_intercept);
                sy_end = sy_start;
                sx_start = frame.bbox.left;
                sx_end = sx_start + frame.bbox.width;
            }
            else {
                sy_start = frame.bbox.top;
                sy_end = sy_start + frame.bbox.height;
                const y_start = yscale.invert(sy_start);
                const y_end = yscale.invert(sy_end);
                const x_start = (y_start - y_intercept) / gradient;
                const x_end = (y_end - y_intercept) / gradient;
                sx_start = xscale.compute(x_start);
                sx_end = xscale.compute(x_end);
            }
            const { ctx } = this.layer;
            ctx.save();
            ctx.beginPath();
            this.visuals.line.set_value(ctx);
            ctx.moveTo(sx_start, sy_start);
            ctx.lineTo(sx_end, sy_end);
            ctx.stroke();
            ctx.restore();
        }
    }
    exports.SlopeView = SlopeView;
    SlopeView.__name__ = "SlopeView";
    class Slope extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Slope = Slope;
    _a = Slope;
    Slope.__name__ = "Slope";
    (() => {
        _a.prototype.default_view = SlopeView;
        _a.mixins(mixins.Line);
        _a.define(({ Number, Nullable }) => ({
            gradient: [Nullable(Number), null],
            y_intercept: [Nullable(Number), null],
        }));
        _a.override({
            line_color: "black",
        });
    })();
},
/* models/annotations/span.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(40) /* ./annotation */;
    const mixins = (0, tslib_1.__importStar)(require(48) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    class SpanView extends annotation_1.AnnotationView {
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.plot_view.request_paint(this));
        }
        _render() {
            const { location } = this.model;
            if (location == null) {
                return;
            }
            const { frame } = this.plot_view;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const _calc_dim = (scale, view) => {
                if (this.model.location_units == "data")
                    return scale.compute(location);
                else
                    return this.model.for_hover ? location : view.compute(location);
            };
            let height, sleft, stop, width;
            if (this.model.dimension == "width") {
                stop = _calc_dim(yscale, frame.bbox.yview);
                sleft = frame.bbox.left;
                width = frame.bbox.width;
                height = this.model.line_width;
            }
            else {
                stop = frame.bbox.top;
                sleft = _calc_dim(xscale, frame.bbox.xview);
                width = this.model.line_width;
                height = frame.bbox.height;
            }
            const { ctx } = this.layer;
            ctx.save();
            ctx.beginPath();
            this.visuals.line.set_value(ctx);
            ctx.moveTo(sleft, stop);
            if (this.model.dimension == "width") {
                ctx.lineTo(sleft + width, stop);
            }
            else {
                ctx.lineTo(sleft, stop + height);
            }
            ctx.stroke();
            ctx.restore();
        }
    }
    exports.SpanView = SpanView;
    SpanView.__name__ = "SpanView";
    class Span extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Span = Span;
    _a = Span;
    Span.__name__ = "Span";
    (() => {
        _a.prototype.default_view = SpanView;
        _a.mixins(mixins.Line);
        _a.define(({ Number, Nullable }) => ({
            render_mode: [enums_1.RenderMode, "canvas"],
            location: [Nullable(Number), null],
            location_units: [enums_1.SpatialUnits, "data"],
            dimension: [enums_1.Dimension, "width"],
        }));
        _a.internal(({ Boolean }) => ({
            for_hover: [Boolean, false],
        }));
        _a.override({
            line_color: "black",
        });
    })();
},
/* models/annotations/toolbar_panel.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const annotation_1 = require(40) /* ./annotation */;
    const toolbar_1 = require(221) /* ../tools/toolbar */;
    const build_views_1 = require(113) /* ../../core/build_views */;
    const dom_1 = require(43) /* ../../core/dom */;
    const side_panel_1 = require(123) /* ../../core/layout/side_panel */;
    const bbox_1 = require(65) /* ../../core/util/bbox */;
    class ToolbarPanelView extends annotation_1.AnnotationView {
        constructor() {
            super(...arguments);
            this._invalidate_toolbar = true;
            this._previous_bbox = new bbox_1.BBox();
        }
        update_layout() {
            this.layout = new side_panel_1.SideLayout(this.panel, () => this.get_size(), true);
        }
        initialize() {
            super.initialize();
            this.el = (0, dom_1.div)();
            this.plot_view.canvas_view.add_event(this.el);
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            this._toolbar_view = await (0, build_views_1.build_view)(this.model.toolbar, { parent: this });
            this.plot_view.visibility_callbacks.push((visible) => this._toolbar_view.set_visibility(visible));
        }
        remove() {
            this._toolbar_view.remove();
            (0, dom_1.remove)(this.el);
            super.remove();
        }
        render() {
            if (!this.model.visible)
                (0, dom_1.undisplay)(this.el);
            super.render();
        }
        _render() {
            // TODO: this should be handled by the layout
            const { bbox } = this.layout;
            if (!this._previous_bbox.equals(bbox)) {
                (0, dom_1.position)(this.el, bbox);
                this._previous_bbox = bbox;
                this._invalidate_toolbar = true;
            }
            if (this._invalidate_toolbar) {
                this.el.style.position = "absolute";
                this.el.style.overflow = "hidden";
                (0, dom_1.empty)(this.el);
                this.el.appendChild(this._toolbar_view.el);
                this._toolbar_view.layout.bbox = bbox;
                this._toolbar_view.render();
                this._invalidate_toolbar = false;
            }
            (0, dom_1.display)(this.el);
        }
        _get_size() {
            const { tools, logo } = this.model.toolbar;
            return {
                width: tools.length * 30 + (logo != null ? 25 : 0) + 15,
                height: 30,
            };
        }
    }
    exports.ToolbarPanelView = ToolbarPanelView;
    ToolbarPanelView.__name__ = "ToolbarPanelView";
    class ToolbarPanel extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ToolbarPanel = ToolbarPanel;
    _a = ToolbarPanel;
    ToolbarPanel.__name__ = "ToolbarPanel";
    (() => {
        _a.prototype.default_view = ToolbarPanelView;
        _a.define(({ Ref }) => ({
            toolbar: [Ref(toolbar_1.Toolbar)],
        }));
    })();
},
/* models/tools/toolbar.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const types_1 = require(8) /* ../../core/util/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const object_1 = require(13) /* ../../core/util/object */;
    const tool_1 = require(222) /* ./tool */;
    const gesture_tool_1 = require(223) /* ./gestures/gesture_tool */;
    const inspect_tool_1 = require(232) /* ./inspectors/inspect_tool */;
    const toolbar_base_1 = require(233) /* ./toolbar_base */;
    exports.Drag = tool_1.Tool;
    exports.Inspection = tool_1.Tool;
    exports.Scroll = tool_1.Tool;
    exports.Tap = tool_1.Tool;
    function _get_active_attr(et) {
        switch (et) {
            case "tap": return "active_tap";
            case "pan": return "active_drag";
            case "pinch":
            case "scroll": return "active_scroll";
            case "multi": return "active_multi";
        }
        return null;
    }
    function _supports_auto(et) {
        return et == "tap" || et == "pan";
    }
    class Toolbar extends toolbar_base_1.ToolbarBase {
        constructor(attrs) {
            super(attrs);
        }
        connect_signals() {
            super.connect_signals();
            const { tools, active_drag, active_inspect, active_scroll, active_tap, active_multi } = this.properties;
            this.on_change([tools, active_drag, active_inspect, active_scroll, active_tap, active_multi], () => this._init_tools());
        }
        _init_tools() {
            super._init_tools();
            if (this.active_inspect == "auto") {
                // do nothing as all tools are active be default
            }
            else if (this.active_inspect instanceof inspect_tool_1.InspectTool) {
                let found = false;
                for (const inspector of this.inspectors) {
                    if (inspector != this.active_inspect)
                        inspector.active = false;
                    else
                        found = true;
                }
                if (!found) {
                    this.active_inspect = null;
                }
            }
            else if ((0, types_1.isArray)(this.active_inspect)) {
                const active_inspect = (0, array_1.intersection)(this.active_inspect, this.inspectors);
                if (active_inspect.length != this.active_inspect.length) {
                    this.active_inspect = active_inspect;
                }
                for (const inspector of this.inspectors) {
                    if (!(0, array_1.includes)(this.active_inspect, inspector))
                        inspector.active = false;
                }
            }
            else if (this.active_inspect == null) {
                for (const inspector of this.inspectors)
                    inspector.active = false;
            }
            const _activate_gesture = (tool) => {
                if (tool.active) {
                    // tool was activated by a proxy, but we need to finish configuration manually
                    this._active_change(tool);
                }
                else
                    tool.active = true;
            };
            // Connecting signals has to be done before changing the active state of the tools.
            for (const gesture of (0, object_1.values)(this.gestures)) {
                gesture.tools = (0, array_1.sort_by)(gesture.tools, (tool) => tool.default_order);
                for (const tool of gesture.tools) {
                    this.connect(tool.properties.active.change, () => this._active_change(tool));
                }
            }
            for (const [et, gesture] of (0, object_1.entries)(this.gestures)) {
                const active_attr = _get_active_attr(et);
                if (active_attr) {
                    const active_tool = this[active_attr];
                    if (active_tool == "auto") {
                        if (gesture.tools.length != 0 && _supports_auto(et)) {
                            _activate_gesture(gesture.tools[0]);
                        }
                    }
                    else if (active_tool != null) {
                        if ((0, array_1.includes)(this.tools, active_tool)) {
                            _activate_gesture(active_tool);
                        }
                        else {
                            this[active_attr] = null;
                        }
                    }
                }
            }
        }
    }
    exports.Toolbar = Toolbar;
    _a = Toolbar;
    Toolbar.__name__ = "Toolbar";
    (() => {
        _a.prototype.default_view = toolbar_base_1.ToolbarBaseView;
        _a.define(({ Or, Ref, Auto, Null }) => ({
            active_drag: [Or(Ref(exports.Drag), Auto, Null), "auto"],
            active_inspect: [Or(Ref(exports.Inspection), Auto, Null), "auto"],
            active_scroll: [Or(Ref(exports.Scroll), Auto, Null), "auto"],
            active_tap: [Or(Ref(exports.Tap), Auto, Null), "auto"],
            active_multi: [Or(Ref(gesture_tool_1.GestureTool), Auto, Null), "auto"],
        }));
    })();
},
/* models/tools/tool.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const view_1 = require(42) /* ../../core/view */;
    const array_1 = require(9) /* ../../core/util/array */;
    const model_1 = require(53) /* ../../model */;
    class ToolView extends view_1.View {
        get plot_view() {
            return this.parent;
        }
        get plot_model() {
            return this.parent.model;
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.properties.active.change, () => {
                if (this.model.active)
                    this.activate();
                else
                    this.deactivate();
            });
        }
        // activate is triggered by toolbar ui actions
        activate() { }
        // deactivate is triggered by toolbar ui actions
        deactivate() { }
    }
    exports.ToolView = ToolView;
    ToolView.__name__ = "ToolView";
    class Tool extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        get synthetic_renderers() {
            return [];
        }
        // utility function to get limits along both dimensions, given
        // optional dimensional constraints
        _get_dim_limits([sx0, sy0], [sx1, sy1], frame, dims) {
            const hr = frame.bbox.h_range;
            let sxlim;
            if (dims == "width" || dims == "both") {
                sxlim = [(0, array_1.min)([sx0, sx1]), (0, array_1.max)([sx0, sx1])];
                sxlim = [(0, array_1.max)([sxlim[0], hr.start]), (0, array_1.min)([sxlim[1], hr.end])];
            }
            else
                sxlim = [hr.start, hr.end];
            const vr = frame.bbox.v_range;
            let sylim;
            if (dims == "height" || dims == "both") {
                sylim = [(0, array_1.min)([sy0, sy1]), (0, array_1.max)([sy0, sy1])];
                sylim = [(0, array_1.max)([sylim[0], vr.start]), (0, array_1.min)([sylim[1], vr.end])];
            }
            else
                sylim = [vr.start, vr.end];
            return [sxlim, sylim];
        }
        static register_alias(name, fn) {
            this.prototype._known_aliases.set(name, fn);
        }
        static from_string(name) {
            const fn = this.prototype._known_aliases.get(name);
            if (fn != null)
                return fn();
            else {
                const names = [...this.prototype._known_aliases.keys()];
                throw new Error(`unexpected tool name '${name}', possible tools are ${names.join(", ")}`);
            }
        }
    }
    exports.Tool = Tool;
    _a = Tool;
    Tool.__name__ = "Tool";
    (() => {
        _a.prototype._known_aliases = new Map();
        _a.define(({ String, Nullable }) => ({
            description: [Nullable(String), null],
        }));
        _a.internal(({ Boolean }) => ({
            active: [Boolean, false],
        }));
    })();
},
/* models/tools/gestures/gesture_tool.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const button_tool_1 = require(224) /* ../button_tool */;
    const on_off_button_1 = require(231) /* ../on_off_button */;
    class GestureToolView extends button_tool_1.ButtonToolView {
    }
    exports.GestureToolView = GestureToolView;
    GestureToolView.__name__ = "GestureToolView";
    class GestureTool extends button_tool_1.ButtonTool {
        constructor(attrs) {
            super(attrs);
            this.button_view = on_off_button_1.OnOffButtonView;
        }
    }
    exports.GestureTool = GestureTool;
    GestureTool.__name__ = "GestureTool";
},
/* models/tools/button_tool.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const hammerjs_1 = (0, tslib_1.__importDefault)(require(225) /* hammerjs */);
    const dom_view_1 = require(226) /* ../../core/dom_view */;
    const tool_1 = require(222) /* ./tool */;
    const dom_1 = require(43) /* ../../core/dom */;
    const string_1 = require(34) /* ../../core/util/string */;
    const types_1 = require(8) /* ../../core/util/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const toolbar_css_1 = (0, tslib_1.__importStar)(require(227) /* ../../styles/toolbar.css */), toolbars = toolbar_css_1;
    const icons_css_1 = (0, tslib_1.__importDefault)(require(228) /* ../../styles/icons.css */);
    const menus_css_1 = (0, tslib_1.__importDefault)(require(229) /* ../../styles/menus.css */);
    const menus_1 = require(230) /* ../../core/util/menus */;
    class ButtonToolButtonView extends dom_view_1.DOMView {
        initialize() {
            super.initialize();
            const items = this.model.menu;
            if (items != null) {
                const location = this.parent.model.toolbar_location;
                const reverse = location == "left" || location == "above";
                const orientation = this.parent.model.horizontal ? "vertical" : "horizontal";
                this._menu = new menus_1.ContextMenu(!reverse ? items : (0, array_1.reversed)(items), {
                    orientation,
                    prevent_hide: (event) => event.target == this.el,
                });
            }
            this._hammer = new hammerjs_1.default(this.el, {
                touchAction: "auto",
                inputClass: hammerjs_1.default.TouchMouseInput, // https://github.com/bokeh/bokeh/issues/9187
            });
            this.connect(this.model.change, () => this.render());
            this._hammer.on("tap", (e) => {
                var _b;
                if ((_b = this._menu) === null || _b === void 0 ? void 0 : _b.is_open) {
                    this._menu.hide();
                    return;
                }
                if (e.target == this.el) {
                    this._clicked();
                }
            });
            this._hammer.on("press", () => this._pressed());
            this.el.addEventListener("keydown", (event) => {
                if (event.keyCode == dom_1.Keys.Enter) {
                    this._clicked();
                }
            });
        }
        remove() {
            var _b;
            this._hammer.destroy();
            (_b = this._menu) === null || _b === void 0 ? void 0 : _b.remove();
            super.remove();
        }
        styles() {
            return [...super.styles(), toolbar_css_1.default, icons_css_1.default, menus_css_1.default];
        }
        css_classes() {
            return super.css_classes().concat(toolbars.toolbar_button);
        }
        render() {
            (0, dom_1.empty)(this.el);
            const icon = this.model.computed_icon;
            if ((0, types_1.isString)(icon)) {
                if ((0, string_1.startsWith)(icon, "data:image"))
                    this.el.style.backgroundImage = `url("${icon}")`;
                else
                    this.el.classList.add(icon);
            }
            this.el.title = this.model.tooltip;
            this.el.tabIndex = 0;
            if (this._menu != null) {
                this.root.el.appendChild(this._menu.el);
            }
        }
        _pressed() {
            var _b;
            const at = (() => {
                switch (this.parent.model.toolbar_location) {
                    case "right": return { left_of: this.el };
                    case "left": return { right_of: this.el };
                    case "above": return { below: this.el };
                    case "below": return { above: this.el };
                }
            })();
            (_b = this._menu) === null || _b === void 0 ? void 0 : _b.toggle(at);
        }
    }
    exports.ButtonToolButtonView = ButtonToolButtonView;
    ButtonToolButtonView.__name__ = "ButtonToolButtonView";
    class ButtonToolView extends tool_1.ToolView {
    }
    exports.ButtonToolView = ButtonToolView;
    ButtonToolView.__name__ = "ButtonToolView";
    class ButtonTool extends tool_1.Tool {
        constructor(attrs) {
            super(attrs);
        }
        // utility function to return a tool name, modified
        // by the active dimensions. Used by tools that have dimensions
        _get_dim_tooltip(dims) {
            const { description, tool_name } = this;
            if (description != null)
                return description;
            else if (dims == "both")
                return tool_name;
            else
                return `${tool_name} (${dims == "width" ? "x" : "y"}-axis)`;
        }
        get tooltip() {
            var _b;
            return (_b = this.description) !== null && _b !== void 0 ? _b : this.tool_name;
        }
        get computed_icon() {
            return this.icon;
        }
        get menu() {
            return null;
        }
    }
    exports.ButtonTool = ButtonTool;
    _a = ButtonTool;
    ButtonTool.__name__ = "ButtonTool";
    (() => {
        _a.internal(({ Boolean }) => ({
            disabled: [Boolean, false],
        }));
    })();
},
/* hammerjs/hammer.js */ function _(require, module, exports, __esModule, __esExport) {
    /*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
    (function (window, document, exportName, undefined) {
        'use strict';
        var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
        var TEST_ELEMENT = document.createElement('div');
        var TYPE_FUNCTION = 'function';
        var round = Math.round;
        var abs = Math.abs;
        var now = Date.now;
        /**
         * set a timeout with a given scope
         * @param {Function} fn
         * @param {Number} timeout
         * @param {Object} context
         * @returns {number}
         */
        function setTimeoutContext(fn, timeout, context) {
            return setTimeout(bindFn(fn, context), timeout);
        }
        /**
         * if the argument is an array, we want to execute the fn on each entry
         * if it aint an array we don't want to do a thing.
         * this is used by all the methods that accept a single and array argument.
         * @param {*|Array} arg
         * @param {String} fn
         * @param {Object} [context]
         * @returns {Boolean}
         */
        function invokeArrayArg(arg, fn, context) {
            if (Array.isArray(arg)) {
                each(arg, context[fn], context);
                return true;
            }
            return false;
        }
        /**
         * walk objects and arrays
         * @param {Object} obj
         * @param {Function} iterator
         * @param {Object} context
         */
        function each(obj, iterator, context) {
            var i;
            if (!obj) {
                return;
            }
            if (obj.forEach) {
                obj.forEach(iterator, context);
            }
            else if (obj.length !== undefined) {
                i = 0;
                while (i < obj.length) {
                    iterator.call(context, obj[i], i, obj);
                    i++;
                }
            }
            else {
                for (i in obj) {
                    obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
                }
            }
        }
        /**
         * wrap a method with a deprecation warning and stack trace
         * @param {Function} method
         * @param {String} name
         * @param {String} message
         * @returns {Function} A new function wrapping the supplied method.
         */
        function deprecate(method, name, message) {
            var deprecationMessage = 'DEPRECATED METHOD: ' + name + '\n' + message + ' AT \n';
            return function () {
                var e = new Error('get-stack-trace');
                var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '')
                    .replace(/^\s+at\s+/gm, '')
                    .replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';
                var log = window.console && (window.console.warn || window.console.log);
                if (log) {
                    log.call(window.console, deprecationMessage, stack);
                }
                return method.apply(this, arguments);
            };
        }
        /**
         * extend object.
         * means that properties in dest will be overwritten by the ones in src.
         * @param {Object} target
         * @param {...Object} objects_to_assign
         * @returns {Object} target
         */
        var assign;
        if (typeof Object.assign !== 'function') {
            assign = function assign(target) {
                if (target === undefined || target === null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var output = Object(target);
                for (var index = 1; index < arguments.length; index++) {
                    var source = arguments[index];
                    if (source !== undefined && source !== null) {
                        for (var nextKey in source) {
                            if (source.hasOwnProperty(nextKey)) {
                                output[nextKey] = source[nextKey];
                            }
                        }
                    }
                }
                return output;
            };
        }
        else {
            assign = Object.assign;
        }
        /**
         * extend object.
         * means that properties in dest will be overwritten by the ones in src.
         * @param {Object} dest
         * @param {Object} src
         * @param {Boolean} [merge=false]
         * @returns {Object} dest
         */
        var extend = deprecate(function extend(dest, src, merge) {
            var keys = Object.keys(src);
            var i = 0;
            while (i < keys.length) {
                if (!merge || (merge && dest[keys[i]] === undefined)) {
                    dest[keys[i]] = src[keys[i]];
                }
                i++;
            }
            return dest;
        }, 'extend', 'Use `assign`.');
        /**
         * merge the values from src in the dest.
         * means that properties that exist in dest will not be overwritten by src
         * @param {Object} dest
         * @param {Object} src
         * @returns {Object} dest
         */
        var merge = deprecate(function merge(dest, src) {
            return extend(dest, src, true);
        }, 'merge', 'Use `assign`.');
        /**
         * simple class inheritance
         * @param {Function} child
         * @param {Function} base
         * @param {Object} [properties]
         */
        function inherit(child, base, properties) {
            var baseP = base.prototype, childP;
            childP = child.prototype = Object.create(baseP);
            childP.constructor = child;
            childP._super = baseP;
            if (properties) {
                assign(childP, properties);
            }
        }
        /**
         * simple function bind
         * @param {Function} fn
         * @param {Object} context
         * @returns {Function}
         */
        function bindFn(fn, context) {
            return function boundFn() {
                return fn.apply(context, arguments);
            };
        }
        /**
         * let a boolean value also be a function that must return a boolean
         * this first item in args will be used as the context
         * @param {Boolean|Function} val
         * @param {Array} [args]
         * @returns {Boolean}
         */
        function boolOrFn(val, args) {
            if (typeof val == TYPE_FUNCTION) {
                return val.apply(args ? args[0] || undefined : undefined, args);
            }
            return val;
        }
        /**
         * use the val2 when val1 is undefined
         * @param {*} val1
         * @param {*} val2
         * @returns {*}
         */
        function ifUndefined(val1, val2) {
            return (val1 === undefined) ? val2 : val1;
        }
        /**
         * addEventListener with multiple events at once
         * @param {EventTarget} target
         * @param {String} types
         * @param {Function} handler
         */
        function addEventListeners(target, types, handler) {
            each(splitStr(types), function (type) {
                target.addEventListener(type, handler, false);
            });
        }
        /**
         * removeEventListener with multiple events at once
         * @param {EventTarget} target
         * @param {String} types
         * @param {Function} handler
         */
        function removeEventListeners(target, types, handler) {
            each(splitStr(types), function (type) {
                target.removeEventListener(type, handler, false);
            });
        }
        /**
         * find if a node is in the given parent
         * @method hasParent
         * @param {HTMLElement} node
         * @param {HTMLElement} parent
         * @return {Boolean} found
         */
        function hasParent(node, parent) {
            while (node) {
                if (node == parent) {
                    return true;
                }
                node = node.parentNode;
            }
            return false;
        }
        /**
         * small indexOf wrapper
         * @param {String} str
         * @param {String} find
         * @returns {Boolean} found
         */
        function inStr(str, find) {
            return str.indexOf(find) > -1;
        }
        /**
         * split string on whitespace
         * @param {String} str
         * @returns {Array} words
         */
        function splitStr(str) {
            return str.trim().split(/\s+/g);
        }
        /**
         * find if a array contains the object using indexOf or a simple polyFill
         * @param {Array} src
         * @param {String} find
         * @param {String} [findByKey]
         * @return {Boolean|Number} false when not found, or the index
         */
        function inArray(src, find, findByKey) {
            if (src.indexOf && !findByKey) {
                return src.indexOf(find);
            }
            else {
                var i = 0;
                while (i < src.length) {
                    if ((findByKey && src[i][findByKey] == find) || (!findByKey && src[i] === find)) {
                        return i;
                    }
                    i++;
                }
                return -1;
            }
        }
        /**
         * convert array-like objects to real arrays
         * @param {Object} obj
         * @returns {Array}
         */
        function toArray(obj) {
            return Array.prototype.slice.call(obj, 0);
        }
        /**
         * unique array with objects based on a key (like 'id') or just by the array's value
         * @param {Array} src [{id:1},{id:2},{id:1}]
         * @param {String} [key]
         * @param {Boolean} [sort=False]
         * @returns {Array} [{id:1},{id:2}]
         */
        function uniqueArray(src, key, sort) {
            var results = [];
            var values = [];
            var i = 0;
            while (i < src.length) {
                var val = key ? src[i][key] : src[i];
                if (inArray(values, val) < 0) {
                    results.push(src[i]);
                }
                values[i] = val;
                i++;
            }
            if (sort) {
                if (!key) {
                    results = results.sort();
                }
                else {
                    results = results.sort(function sortUniqueArray(a, b) {
                        return a[key] > b[key];
                    });
                }
            }
            return results;
        }
        /**
         * get the prefixed property
         * @param {Object} obj
         * @param {String} property
         * @returns {String|Undefined} prefixed
         */
        function prefixed(obj, property) {
            var prefix, prop;
            var camelProp = property[0].toUpperCase() + property.slice(1);
            var i = 0;
            while (i < VENDOR_PREFIXES.length) {
                prefix = VENDOR_PREFIXES[i];
                prop = (prefix) ? prefix + camelProp : property;
                if (prop in obj) {
                    return prop;
                }
                i++;
            }
            return undefined;
        }
        /**
         * get a unique id
         * @returns {number} uniqueId
         */
        var _uniqueId = 1;
        function uniqueId() {
            return _uniqueId++;
        }
        /**
         * get the window object of an element
         * @param {HTMLElement} element
         * @returns {DocumentView|Window}
         */
        function getWindowForElement(element) {
            var doc = element.ownerDocument || element;
            return (doc.defaultView || doc.parentWindow || window);
        }
        var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
        var SUPPORT_TOUCH = ('ontouchstart' in window);
        var SUPPORT_POINTER_EVENTS = prefixed(window, 'PointerEvent') !== undefined;
        var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
        var INPUT_TYPE_TOUCH = 'touch';
        var INPUT_TYPE_PEN = 'pen';
        var INPUT_TYPE_MOUSE = 'mouse';
        var INPUT_TYPE_KINECT = 'kinect';
        var COMPUTE_INTERVAL = 25;
        var INPUT_START = 1;
        var INPUT_MOVE = 2;
        var INPUT_END = 4;
        var INPUT_CANCEL = 8;
        var DIRECTION_NONE = 1;
        var DIRECTION_LEFT = 2;
        var DIRECTION_RIGHT = 4;
        var DIRECTION_UP = 8;
        var DIRECTION_DOWN = 16;
        var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
        var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
        var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
        var PROPS_XY = ['x', 'y'];
        var PROPS_CLIENT_XY = ['clientX', 'clientY'];
        /**
         * create new input type manager
         * @param {Manager} manager
         * @param {Function} callback
         * @returns {Input}
         * @constructor
         */
        function Input(manager, callback) {
            var self = this;
            this.manager = manager;
            this.callback = callback;
            this.element = manager.element;
            this.target = manager.options.inputTarget;
            // smaller wrapper around the handler, for the scope and the enabled state of the manager,
            // so when disabled the input events are completely bypassed.
            this.domHandler = function (ev) {
                if (boolOrFn(manager.options.enable, [manager])) {
                    self.handler(ev);
                }
            };
            this.init();
        }
        Input.prototype = {
            /**
             * should handle the inputEvent data and trigger the callback
             * @virtual
             */
            handler: function () { },
            /**
             * bind the events
             */
            init: function () {
                this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
                this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
                this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
            },
            /**
             * unbind the events
             */
            destroy: function () {
                this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
                this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
                this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
            }
        };
        /**
         * create new input type manager
         * called by the Manager constructor
         * @param {Hammer} manager
         * @returns {Input}
         */
        function createInputInstance(manager) {
            var Type;
            var inputClass = manager.options.inputClass;
            if (inputClass) {
                Type = inputClass;
            }
            else if (SUPPORT_POINTER_EVENTS) {
                Type = PointerEventInput;
            }
            else if (SUPPORT_ONLY_TOUCH) {
                Type = TouchInput;
            }
            else if (!SUPPORT_TOUCH) {
                Type = MouseInput;
            }
            else {
                Type = TouchMouseInput;
            }
            return new (Type)(manager, inputHandler);
        }
        /**
         * handle input events
         * @param {Manager} manager
       