# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class Action(msrest.serialization.Model):
    """Model that represents the base action model.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ContinuousAction, DelayAction, DiscreteAction.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Enum that discriminates between action models.Constant filled by server.
    :vartype type: str
    :ivar name: Required. String that represents a Capability URN.
    :vartype name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'continuous': 'ContinuousAction', 'delay': 'DelayAction', 'discrete': 'DiscreteAction'}
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required. String that represents a Capability URN.
        :paramtype name: str
        """
        super(Action, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.name = name


class ActionStatus(msrest.serialization.Model):
    """Model that represents the an action and its status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar action_name: The name of the action status.
    :vartype action_name: str
    :ivar action_id: The id of the action status.
    :vartype action_id: str
    :ivar status: The status of the action.
    :vartype status: str
    :ivar start_time: String that represents the start time of the action.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: String that represents the end time of the action.
    :vartype end_time: ~datetime.datetime
    :ivar targets: The array of targets.
    :vartype targets:
     list[~azure.mgmt.chaos.models.ExperimentExecutionActionTargetDetailsProperties]
    """

    _validation = {
        'action_name': {'readonly': True},
        'action_id': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'targets': {'readonly': True},
    }

    _attribute_map = {
        'action_name': {'key': 'actionName', 'type': 'str'},
        'action_id': {'key': 'actionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'targets': {'key': 'targets', 'type': '[ExperimentExecutionActionTargetDetailsProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ActionStatus, self).__init__(**kwargs)
        self.action_name = None
        self.action_id = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.targets = None


class Branch(msrest.serialization.Model):
    """Model that represents a branch in the step.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. String of the branch name.
    :vartype name: str
    :ivar actions: Required. List of actions.
    :vartype actions: list[~azure.mgmt.chaos.models.Action]
    """

    _validation = {
        'name': {'required': True, 'min_length': 1},
        'actions': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'actions': {'key': 'actions', 'type': '[Action]'},
    }

    def __init__(
        self,
        *,
        name: str,
        actions: List["_models.Action"],
        **kwargs
    ):
        """
        :keyword name: Required. String of the branch name.
        :paramtype name: str
        :keyword actions: Required. List of actions.
        :paramtype actions: list[~azure.mgmt.chaos.models.Action]
        """
        super(Branch, self).__init__(**kwargs)
        self.name = name
        self.actions = actions


class BranchStatus(msrest.serialization.Model):
    """Model that represents the a list of actions and action statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar branch_name: The name of the branch status.
    :vartype branch_name: str
    :ivar branch_id: The id of the branch status.
    :vartype branch_id: str
    :ivar status: The status of the branch.
    :vartype status: str
    :ivar actions: The array of actions.
    :vartype actions: list[~azure.mgmt.chaos.models.ActionStatus]
    """

    _validation = {
        'branch_name': {'readonly': True},
        'branch_id': {'readonly': True},
        'status': {'readonly': True},
        'actions': {'readonly': True},
    }

    _attribute_map = {
        'branch_name': {'key': 'branchName', 'type': 'str'},
        'branch_id': {'key': 'branchId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'actions': {'key': 'actions', 'type': '[ActionStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BranchStatus, self).__init__(**kwargs)
        self.branch_name = None
        self.branch_id = None
        self.status = None
        self.actions = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Capability(Resource):
    """Model that represents a Capability resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The standard system metadata of a resource type.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar publisher: String of the Publisher that this Capability extends.
    :vartype publisher: str
    :ivar target_type: String of the Target Type that this Capability extends.
    :vartype target_type: str
    :ivar description: Localized string of the description.
    :vartype description: str
    :ivar parameters_schema: URL to retrieve JSON schema of the Capability parameters.
    :vartype parameters_schema: str
    :ivar urn: String of the URN for this Capability Type.
    :vartype urn: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'publisher': {'readonly': True},
        'target_type': {'readonly': True},
        'description': {'readonly': True},
        'parameters_schema': {'readonly': True, 'max_length': 2048, 'min_length': 0},
        'urn': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'target_type': {'key': 'properties.targetType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'parameters_schema': {'key': 'properties.parametersSchema', 'type': 'str'},
        'urn': {'key': 'properties.urn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Capability, self).__init__(**kwargs)
        self.system_data = None
        self.publisher = None
        self.target_type = None
        self.description = None
        self.parameters_schema = None
        self.urn = None


class CapabilityListResult(msrest.serialization.Model):
    """Model that represents a list of Capability resources and a link for pagination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Capability resources.
    :vartype value: list[~azure.mgmt.chaos.models.Capability]
    :ivar next_link: URL to retrieve the next page of Capability resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Capability]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CapabilityListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CapabilityType(Resource):
    """Model that represents a Capability Type resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata properties of the capability type resource.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar location: Location of the Capability Type resource.
    :vartype location: str
    :ivar publisher: String of the Publisher that this Capability Type extends.
    :vartype publisher: str
    :ivar target_type: String of the Target Type that this Capability Type extends.
    :vartype target_type: str
    :ivar display_name: Localized string of the display name.
    :vartype display_name: str
    :ivar description: Localized string of the description.
    :vartype description: str
    :ivar parameters_schema: URL to retrieve JSON schema of the Capability Type parameters.
    :vartype parameters_schema: str
    :ivar urn: String of the URN for this Capability Type.
    :vartype urn: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'publisher': {'readonly': True},
        'target_type': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'parameters_schema': {'readonly': True, 'max_length': 2048, 'min_length': 0},
        'urn': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'target_type': {'key': 'properties.targetType', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'parameters_schema': {'key': 'properties.parametersSchema', 'type': 'str'},
        'urn': {'key': 'properties.urn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the Capability Type resource.
        :paramtype location: str
        """
        super(CapabilityType, self).__init__(**kwargs)
        self.system_data = None
        self.location = location
        self.publisher = None
        self.target_type = None
        self.display_name = None
        self.description = None
        self.parameters_schema = None
        self.urn = None


class CapabilityTypeListResult(msrest.serialization.Model):
    """Model that represents a list of Capability Type resources and a link for pagination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Capability Type resources.
    :vartype value: list[~azure.mgmt.chaos.models.CapabilityType]
    :ivar next_link: URL to retrieve the next page of Capability Type resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapabilityType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CapabilityTypeListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ContinuousAction(Action):
    """Model that represents a continuous action.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Enum that discriminates between action models.Constant filled by server.
    :vartype type: str
    :ivar name: Required. String that represents a Capability URN.
    :vartype name: str
    :ivar duration: Required. ISO8601 formatted string that represents a duration.
    :vartype duration: str
    :ivar parameters: Required. List of key value pairs.
    :vartype parameters: list[~azure.mgmt.chaos.models.KeyValuePair]
    :ivar selector_id: Required. String that represents a selector.
    :vartype selector_id: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True, 'max_length': 2048, 'min_length': 0},
        'duration': {'required': True, 'pattern': r'^P(\d+Y)?(\d+M)?(\d+D)?(T(\d+H)?(\d+M)?(\d+(\.\d+)?S)?)?$'},
        'parameters': {'required': True},
        'selector_id': {'required': True, 'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[KeyValuePair]'},
        'selector_id': {'key': 'selectorId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        duration: str,
        parameters: List["_models.KeyValuePair"],
        selector_id: str,
        **kwargs
    ):
        """
        :keyword name: Required. String that represents a Capability URN.
        :paramtype name: str
        :keyword duration: Required. ISO8601 formatted string that represents a duration.
        :paramtype duration: str
        :keyword parameters: Required. List of key value pairs.
        :paramtype parameters: list[~azure.mgmt.chaos.models.KeyValuePair]
        :keyword selector_id: Required. String that represents a selector.
        :paramtype selector_id: str
        """
        super(ContinuousAction, self).__init__(name=name, **kwargs)
        self.type = 'continuous'  # type: str
        self.duration = duration
        self.parameters = parameters
        self.selector_id = selector_id


class DelayAction(Action):
    """Model that represents a delay action.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Enum that discriminates between action models.Constant filled by server.
    :vartype type: str
    :ivar name: Required. String that represents a Capability URN.
    :vartype name: str
    :ivar duration: Required. ISO8601 formatted string that represents a duration.
    :vartype duration: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True, 'max_length': 2048, 'min_length': 0},
        'duration': {'required': True, 'pattern': r'^P(\d+Y)?(\d+M)?(\d+D)?(T(\d+H)?(\d+M)?(\d+(\.\d+)?S)?)?$'},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        duration: str,
        **kwargs
    ):
        """
        :keyword name: Required. String that represents a Capability URN.
        :paramtype name: str
        :keyword duration: Required. ISO8601 formatted string that represents a duration.
        :paramtype duration: str
        """
        super(DelayAction, self).__init__(name=name, **kwargs)
        self.type = 'delay'  # type: str
        self.duration = duration


class DiscreteAction(Action):
    """Model that represents a discrete action.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Enum that discriminates between action models.Constant filled by server.
    :vartype type: str
    :ivar name: Required. String that represents a Capability URN.
    :vartype name: str
    :ivar parameters: Required. List of key value pairs.
    :vartype parameters: list[~azure.mgmt.chaos.models.KeyValuePair]
    :ivar selector_id: Required. String that represents a selector.
    :vartype selector_id: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True, 'max_length': 2048, 'min_length': 0},
        'parameters': {'required': True},
        'selector_id': {'required': True, 'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[KeyValuePair]'},
        'selector_id': {'key': 'selectorId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        parameters: List["_models.KeyValuePair"],
        selector_id: str,
        **kwargs
    ):
        """
        :keyword name: Required. String that represents a Capability URN.
        :paramtype name: str
        :keyword parameters: Required. List of key value pairs.
        :paramtype parameters: list[~azure.mgmt.chaos.models.KeyValuePair]
        :keyword selector_id: Required. String that represents a selector.
        :paramtype selector_id: str
        """
        super(DiscreteAction, self).__init__(name=name, **kwargs)
        self.type = 'discrete'  # type: str
        self.parameters = parameters
        self.selector_id = selector_id


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.chaos.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.chaos.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.chaos.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.chaos.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Experiment(TrackedResource):
    """Model that represents a Experiment resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system metadata of the experiment resource.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar identity: The identity of the experiment resource.
    :vartype identity: ~azure.mgmt.chaos.models.ResourceIdentity
    :ivar steps: Required. List of steps.
    :vartype steps: list[~azure.mgmt.chaos.models.Step]
    :ivar selectors: Required. List of selectors.
    :vartype selectors: list[~azure.mgmt.chaos.models.Selector]
    :ivar start_on_creation: A boolean value that indicates if experiment should be started on
     creation or not.
    :vartype start_on_creation: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'steps': {'required': True, 'min_items': 1},
        'selectors': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'steps': {'key': 'properties.steps', 'type': '[Step]'},
        'selectors': {'key': 'properties.selectors', 'type': '[Selector]'},
        'start_on_creation': {'key': 'properties.startOnCreation', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        steps: List["_models.Step"],
        selectors: List["_models.Selector"],
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        start_on_creation: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: The identity of the experiment resource.
        :paramtype identity: ~azure.mgmt.chaos.models.ResourceIdentity
        :keyword steps: Required. List of steps.
        :paramtype steps: list[~azure.mgmt.chaos.models.Step]
        :keyword selectors: Required. List of selectors.
        :paramtype selectors: list[~azure.mgmt.chaos.models.Selector]
        :keyword start_on_creation: A boolean value that indicates if experiment should be started on
         creation or not.
        :paramtype start_on_creation: bool
        """
        super(Experiment, self).__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.identity = identity
        self.steps = steps
        self.selectors = selectors
        self.start_on_creation = start_on_creation


class ExperimentCancelOperationResult(msrest.serialization.Model):
    """Model that represents the result of a cancel Experiment operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: String of the Experiment name.
    :vartype name: str
    :ivar status_url: URL to retrieve the Experiment status.
    :vartype status_url: str
    """

    _validation = {
        'name': {'readonly': True},
        'status_url': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status_url': {'key': 'statusUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentCancelOperationResult, self).__init__(**kwargs)
        self.name = None
        self.status_url = None


class ExperimentExecutionActionTargetDetailsError(msrest.serialization.Model):
    """Model that represents the Experiment action target details error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentExecutionActionTargetDetailsError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class ExperimentExecutionActionTargetDetailsProperties(msrest.serialization.Model):
    """Model that represents the Experiment action target details properties model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the execution.
    :vartype status: str
    :ivar target: The target for the action.
    :vartype target: str
    :ivar target_failed_time: String that represents the failed date time.
    :vartype target_failed_time: ~datetime.datetime
    :ivar target_completed_time: String that represents the completed date time.
    :vartype target_completed_time: ~datetime.datetime
    :ivar error: The error of the action.
    :vartype error: ~azure.mgmt.chaos.models.ExperimentExecutionActionTargetDetailsError
    """

    _validation = {
        'status': {'readonly': True},
        'target': {'readonly': True},
        'target_failed_time': {'readonly': True},
        'target_completed_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'target_failed_time': {'key': 'targetFailedTime', 'type': 'iso-8601'},
        'target_completed_time': {'key': 'targetCompletedTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'ExperimentExecutionActionTargetDetailsError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentExecutionActionTargetDetailsProperties, self).__init__(**kwargs)
        self.status = None
        self.target = None
        self.target_failed_time = None
        self.target_completed_time = None
        self.error = None


class ExperimentExecutionDetails(msrest.serialization.Model):
    """Model that represents the execution details of a Experiment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: String of the resource type.
    :vartype type: str
    :ivar id: String of the fully qualified resource ID.
    :vartype id: str
    :ivar name: String of the resource name.
    :vartype name: str
    :ivar experiment_id: The id of the experiment.
    :vartype experiment_id: str
    :ivar status: The value of the status of the experiment execution.
    :vartype status: str
    :ivar failure_reason: The reason why the execution failed.
    :vartype failure_reason: str
    :ivar created_date_time: String that represents the created date time.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: String that represents the last action date time.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar start_date_time: String that represents the start date time.
    :vartype start_date_time: ~datetime.datetime
    :ivar stop_date_time: String that represents the stop date time.
    :vartype stop_date_time: ~datetime.datetime
    :ivar run_information: The information of the experiment run.
    :vartype run_information:
     ~azure.mgmt.chaos.models.ExperimentExecutionDetailsPropertiesRunInformation
    """

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'experiment_id': {'readonly': True},
        'status': {'readonly': True},
        'failure_reason': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_action_date_time': {'readonly': True},
        'start_date_time': {'readonly': True},
        'stop_date_time': {'readonly': True},
        'run_information': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'experiment_id': {'key': 'properties.experimentId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'failure_reason': {'key': 'properties.failureReason', 'type': 'str'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'last_action_date_time': {'key': 'properties.lastActionDateTime', 'type': 'iso-8601'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'stop_date_time': {'key': 'properties.stopDateTime', 'type': 'iso-8601'},
        'run_information': {'key': 'properties.runInformation', 'type': 'ExperimentExecutionDetailsPropertiesRunInformation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentExecutionDetails, self).__init__(**kwargs)
        self.type = None
        self.id = None
        self.name = None
        self.experiment_id = None
        self.status = None
        self.failure_reason = None
        self.created_date_time = None
        self.last_action_date_time = None
        self.start_date_time = None
        self.stop_date_time = None
        self.run_information = None


class ExperimentExecutionDetailsListResult(msrest.serialization.Model):
    """Model that represents a list of Experiment execution details and a link for pagination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Experiment execution details.
    :vartype value: list[~azure.mgmt.chaos.models.ExperimentExecutionDetails]
    :ivar next_link: URL to retrieve the next page of Experiment execution details.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExperimentExecutionDetails]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentExecutionDetailsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExperimentExecutionDetailsPropertiesRunInformation(msrest.serialization.Model):
    """The information of the experiment run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar steps: The steps of the experiment run.
    :vartype steps: list[~azure.mgmt.chaos.models.StepStatus]
    """

    _validation = {
        'steps': {'readonly': True},
    }

    _attribute_map = {
        'steps': {'key': 'steps', 'type': '[StepStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentExecutionDetailsPropertiesRunInformation, self).__init__(**kwargs)
        self.steps = None


class ExperimentListResult(msrest.serialization.Model):
    """Model that represents a list of Experiment resources and a link for pagination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Experiment resources.
    :vartype value: list[~azure.mgmt.chaos.models.Experiment]
    :ivar next_link: URL to retrieve the next page of Experiment resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Experiment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExperimentStartOperationResult(msrest.serialization.Model):
    """Model that represents the result of a start Experiment operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: String of the Experiment name.
    :vartype name: str
    :ivar status_url: URL to retrieve the Experiment status.
    :vartype status_url: str
    """

    _validation = {
        'name': {'readonly': True},
        'status_url': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status_url': {'key': 'statusUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentStartOperationResult, self).__init__(**kwargs)
        self.name = None
        self.status_url = None


class ExperimentStatus(msrest.serialization.Model):
    """Model that represents the status of a Experiment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: String of the resource type.
    :vartype type: str
    :ivar id: String of the fully qualified resource ID.
    :vartype id: str
    :ivar name: String of the resource name.
    :vartype name: str
    :ivar status: String that represents the status of a Experiment.
    :vartype status: str
    :ivar created_date_utc: String that represents the created date time of a Experiment.
    :vartype created_date_utc: ~datetime.datetime
    :ivar end_date_utc: String that represents the end date time of a Experiment.
    :vartype end_date_utc: ~datetime.datetime
    """

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'status': {'readonly': True},
        'created_date_utc': {'readonly': True},
        'end_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'created_date_utc': {'key': 'properties.createdDateUtc', 'type': 'iso-8601'},
        'end_date_utc': {'key': 'properties.endDateUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentStatus, self).__init__(**kwargs)
        self.type = None
        self.id = None
        self.name = None
        self.status = None
        self.created_date_utc = None
        self.end_date_utc = None


class ExperimentStatusListResult(msrest.serialization.Model):
    """Model that represents a list of Experiment statuses and a link for pagination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Experiment statuses.
    :vartype value: list[~azure.mgmt.chaos.models.ExperimentStatus]
    :ivar next_link: URL to retrieve the next page of Experiment statuses.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExperimentStatus]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExperimentStatusListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class KeyValuePair(msrest.serialization.Model):
    """A map to describe the settings of an action.

    All required parameters must be populated in order to send to Azure.

    :ivar key: Required. The name of the setting for the action.
    :vartype key: str
    :ivar value: Required. The value of the setting for the action.
    :vartype value: str
    """

    _validation = {
        'key': {'required': True, 'min_length': 1},
        'value': {'required': True, 'min_length': 1},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: str,
        value: str,
        **kwargs
    ):
        """
        :keyword key: Required. The name of the setting for the action.
        :paramtype key: str
        :keyword value: Required. The value of the setting for the action.
        :paramtype value: str
        """
        super(KeyValuePair, self).__init__(**kwargs)
        self.key = key
        self.value = value


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.chaos.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     "user,system".
    :vartype origin: str or ~azure.mgmt.chaos.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Known values are: "Internal".
    :vartype action_type: str or ~azure.mgmt.chaos.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.chaos.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.chaos.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ResourceIdentity(msrest.serialization.Model):
    """The managed identity of a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. String of the resource identity type. Known values are: "None",
     "SystemAssigned".
    :vartype type: str or ~azure.mgmt.chaos.models.ResourceIdentityType
    :ivar principal_id: GUID that represents the principal ID of this resource identity.
    :vartype principal_id: str
    :ivar tenant_id: GUID that represents the tenant ID of this resource identity.
    :vartype tenant_id: str
    """

    _validation = {
        'type': {'required': True},
        'principal_id': {'readonly': True, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'tenant_id': {'readonly': True, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ResourceIdentityType"],
        **kwargs
    ):
        """
        :keyword type: Required. String of the resource identity type. Known values are: "None",
         "SystemAssigned".
        :paramtype type: str or ~azure.mgmt.chaos.models.ResourceIdentityType
        """
        super(ResourceIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None


class Selector(msrest.serialization.Model):
    """Model that represents a selector in the Experiment resource.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Enum of the selector type. Known values are: "Percent", "Random", "Tag",
     "List".
    :vartype type: str or ~azure.mgmt.chaos.models.SelectorType
    :ivar id: Required. String of the selector ID.
    :vartype id: str
    :ivar targets: Required. List of Target references.
    :vartype targets: list[~azure.mgmt.chaos.models.TargetReference]
    """

    _validation = {
        'type': {'required': True},
        'id': {'required': True, 'min_length': 1},
        'targets': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'targets': {'key': 'targets', 'type': '[TargetReference]'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.SelectorType"],
        id: str,
        targets: List["_models.TargetReference"],
        **kwargs
    ):
        """
        :keyword type: Required. Enum of the selector type. Known values are: "Percent", "Random",
         "Tag", "List".
        :paramtype type: str or ~azure.mgmt.chaos.models.SelectorType
        :keyword id: Required. String of the selector ID.
        :paramtype id: str
        :keyword targets: Required. List of Target references.
        :paramtype targets: list[~azure.mgmt.chaos.models.TargetReference]
        """
        super(Selector, self).__init__(**kwargs)
        self.type = type
        self.id = id
        self.targets = targets


class Step(msrest.serialization.Model):
    """Model that represents a step in the Experiment resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. String of the step name.
    :vartype name: str
    :ivar branches: Required. List of branches.
    :vartype branches: list[~azure.mgmt.chaos.models.Branch]
    """

    _validation = {
        'name': {'required': True, 'min_length': 1},
        'branches': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'branches': {'key': 'branches', 'type': '[Branch]'},
    }

    def __init__(
        self,
        *,
        name: str,
        branches: List["_models.Branch"],
        **kwargs
    ):
        """
        :keyword name: Required. String of the step name.
        :paramtype name: str
        :keyword branches: Required. List of branches.
        :paramtype branches: list[~azure.mgmt.chaos.models.Branch]
        """
        super(Step, self).__init__(**kwargs)
        self.name = name
        self.branches = branches


class StepStatus(msrest.serialization.Model):
    """Model that represents the a list of branches and branch statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar step_name: The name of the step.
    :vartype step_name: str
    :ivar step_id: The id of the step.
    :vartype step_id: str
    :ivar status: The value of the status of the step.
    :vartype status: str
    :ivar branches: The array of branches.
    :vartype branches: list[~azure.mgmt.chaos.models.BranchStatus]
    """

    _validation = {
        'step_name': {'readonly': True},
        'step_id': {'readonly': True},
        'status': {'readonly': True},
        'branches': {'readonly': True},
    }

    _attribute_map = {
        'step_name': {'key': 'stepName', 'type': 'str'},
        'step_id': {'key': 'stepId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'branches': {'key': 'branches', 'type': '[BranchStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StepStatus, self).__init__(**kwargs)
        self.step_name = None
        self.step_id = None
        self.status = None
        self.branches = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.chaos.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.chaos.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.chaos.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.chaos.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Target(Resource):
    """Model that represents a Target resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata of the target resource.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar location: Location of the target resource.
    :vartype location: str
    :ivar properties: Required. The properties of the target resource.
    :vartype properties: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        properties: Dict[str, Any],
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the target resource.
        :paramtype location: str
        :keyword properties: Required. The properties of the target resource.
        :paramtype properties: dict[str, any]
        """
        super(Target, self).__init__(**kwargs)
        self.system_data = None
        self.location = location
        self.properties = properties


class TargetListResult(msrest.serialization.Model):
    """Model that represents a list of Target resources and a link for pagination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Target resources.
    :vartype value: list[~azure.mgmt.chaos.models.Target]
    :ivar next_link: URL to retrieve the next page of Target resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Target]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TargetListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class TargetReference(msrest.serialization.Model):
    """Model that represents a reference to a Target in the selector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Enum of the Target reference type. Has constant value: "ChaosTarget".
    :vartype type: str
    :ivar id: Required. String of the resource ID of a Target resource.
    :vartype id: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'id': {'required': True, 'pattern': r'^\/[Ss][Uu][Bb][Ss][Cc][Rr][Ii][Pp][Tt][Ii][Oo][Nn][Ss]\/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\/[Rr][Ee][Ss][Oo][Uu][Rr][Cc][Ee][Gg][Rr][Oo][Uu][Pp][Ss]\/[a-zA-Z0-9_\-\.\(\)]*[a-zA-Z0-9_\-\(\)]\/[Pp][Rr][Oo][Vv][Ii][Dd][Ee][Rr][Ss]\/[a-zA-Z0-9]+\.[a-zA-Z0-9]+\/[a-zA-Z0-9_\-\.]+\/[a-zA-Z0-9_\-\.]+\/[Pp][Rr][Oo][Vv][Ii][Dd][Ee][Rr][Ss]\/[Mm][Ii][Cc][Rr][Oo][Ss][Oo][Ff][Tt]\.[Cc][Hh][Aa][Oo][Ss]\/[Tt][Aa][Rr][Gg][Ee][Tt][Ss]\/[a-zA-Z0-9_\-\.]+$'},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    type = "ChaosTarget"

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. String of the resource ID of a Target resource.
        :paramtype id: str
        """
        super(TargetReference, self).__init__(**kwargs)
        self.id = id


class TargetType(Resource):
    """Model that represents a Target Type resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata properties of the target type resource.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar location: Location of the Target Type resource.
    :vartype location: str
    :ivar display_name: Localized string of the display name.
    :vartype display_name: str
    :ivar description: Localized string of the description.
    :vartype description: str
    :ivar properties_schema: URL to retrieve JSON schema of the Target Type properties.
    :vartype properties_schema: str
    :ivar resource_types: List of resource types this Target Type can extend.
    :vartype resource_types: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'properties_schema': {'readonly': True, 'max_length': 2048, 'min_length': 0},
        'resource_types': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'properties_schema': {'key': 'properties.propertiesSchema', 'type': 'str'},
        'resource_types': {'key': 'properties.resourceTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the Target Type resource.
        :paramtype location: str
        """
        super(TargetType, self).__init__(**kwargs)
        self.system_data = None
        self.location = location
        self.display_name = None
        self.description = None
        self.properties_schema = None
        self.resource_types = None


class TargetTypeListResult(msrest.serialization.Model):
    """Model that represents a list of Target Type resources and a link for pagination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Target Type resources.
    :vartype value: list[~azure.mgmt.chaos.models.TargetType]
    :ivar next_link: URL to retrieve the next page of Target Type resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TargetType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TargetTypeListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
