import * as cdk from 'aws-cdk-lib';
import { aws_ec2 as ec2, aws_iam as iam, aws_lambda as lambda, aws_stepfunctions as stepfunctions } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IRunnerProvider, RunnerRuntimeParameters, RunnerProviderProps } from './common';
export interface LambdaRunnerProps extends RunnerProviderProps {
    /**
     * GitHub Actions label used for this provider.
     *
     * @default 'lambda'
     */
    readonly label?: string;
    /**
     * The amount of memory, in MB, that is allocated to your Lambda function.
     * Lambda uses this value to proportionally allocate the amount of CPU
     * power. For more information, see Resource Model in the AWS Lambda
     * Developer Guide.
     *
     * @default 2048
     */
    readonly memorySize?: number;
    /**
    * The size of the function’s /tmp directory in MiB.
    *
    * @default 10 GiB
    */
    readonly ephemeralStorageSize?: cdk.Size;
    /**
     * The function execution time (in seconds) after which Lambda terminates
     * the function. Because the execution time affects cost, set this value
     * based on the function's expected execution time.
     *
     * @default Duration.minutes(15)
     */
    readonly timeout?: cdk.Duration;
    /**
    * VPC to launch the runners in.
    *
    * @default no VPC
    */
    readonly vpc?: ec2.IVpc;
    /**
    * Security Group to assign to this instance.
    *
    * @default public lambda with no security group
    */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
    * Where to place the network interfaces within the VPC.
    *
    * @default no subnet
    */
    readonly subnetSelection?: ec2.SubnetSelection;
}
/**
 * GitHub Actions runner provider using Lambda to execute the actions.
 *
 * Creates a Docker-based function that gets executed for each job.
 */
export declare class LambdaRunner extends Construct implements IRunnerProvider {
    readonly function: lambda.Function;
    readonly label: string;
    readonly vpc?: ec2.IVpc;
    readonly securityGroup?: ec2.ISecurityGroup;
    readonly grantPrincipal: iam.IPrincipal;
    constructor(scope: Construct, id: string, props: LambdaRunnerProps);
    get connections(): ec2.Connections;
    getStepFunctionTask(parameters: RunnerRuntimeParameters): stepfunctions.IChainable;
}
//# sourceMappingURL=lambda.d.ts.map