// Copyright (c) Mito
import React, { useState } from 'react';
import fscreen from 'fscreen';
import ToolbarButton from './ToolbarButton';
import { ToolbarButtonType } from './utils';
import { ActionEnum } from '../../types';
import ActionSearchBar from './ActionSearchBar';
import Col from '../spacing/Col';
import Dropdown from '../elements/Dropdown';
import { getColumnFormatDropdownItemsUsingSelections } from '../../utils/formatColumns';
// Import CSS
import "../../../css/toolbar.css";
const Toolbar = (props) => {
    const [fullscreen, setFullscreen] = useState(false);
    fscreen.onfullscreenchange = () => {
        setFullscreen(!!fscreen.fullscreenElement);
        void props.mitoAPI.sendLogMessage('button_toggle_fullscreen', {
            // Note that this is true when _end_ in fullscreen mode, and 
            // false when we _end_ not in fullscreen mode, which is much
            // more natural than the alternative
            fullscreen: !!fscreen.fullscreenElement
        });
    };
    const catchup = () => {
        // Fast forwards to the most recent step, allowing editing
        void props.mitoAPI.sendLogMessage('click_catch_up');
        void props.mitoAPI.checkoutStepByIndex(props.lastStepIndex);
    };
    return (React.createElement("div", { className: 'toolbar-container' },
        React.createElement("div", { className: 'toolbar-left-half' },
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.UNDO, buttonTitle: props.actions[ActionEnum.Undo].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Undo].tooltip, onClick: props.actions[ActionEnum.Undo].actionFunction }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.REDO, buttonTitle: props.actions[ActionEnum.Redo].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Redo].tooltip, onClick: props.actions[ActionEnum.Redo].actionFunction }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.CLEAR, buttonTitle: props.actions[ActionEnum.Clear].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Clear].tooltip, onClick: props.actions[ActionEnum.Clear].actionFunction }),
            React.createElement("div", { className: "toolbar-vertical-line" }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.IMPORT, buttonTitle: props.actions[ActionEnum.Import].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Import].tooltip, onClick: props.actions[ActionEnum.Import].actionFunction }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.EXPORT, buttonTitle: props.actions[ActionEnum.Export].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Export].tooltip, onClick: props.actions[ActionEnum.Export].actionFunction }),
            React.createElement("div", { className: "toolbar-vertical-line" }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.ADD_COL, buttonTitle: props.actions[ActionEnum.Add_Column].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Add_Column].tooltip, onClick: props.actions[ActionEnum.Add_Column].actionFunction, highlightToolbarButton: props.highlightAddColButton }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.DEL_COL, buttonTitle: props.actions[ActionEnum.Delete_Column].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Delete_Column].tooltip, onClick: props.actions[ActionEnum.Delete_Column].actionFunction }),
            React.createElement("div", { className: "toolbar-vertical-line" }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.PIVOT, buttonTitle: props.actions[ActionEnum.Pivot].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Pivot].tooltip, onClick: props.actions[ActionEnum.Pivot].actionFunction, highlightToolbarButton: props.highlightPivotTableButton }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.MERGE, buttonTitle: props.actions[ActionEnum.Merge].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Merge].tooltip, onClick: props.actions[ActionEnum.Merge].actionFunction }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.DROP_DUPLICATES, buttonTitle: props.actions[ActionEnum.Drop_Duplicates].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Drop_Duplicates].tooltip, onClick: props.actions[ActionEnum.Drop_Duplicates].actionFunction }),
            React.createElement("div", { className: "toolbar-vertical-line" }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.GRAPH, buttonTitle: props.actions[ActionEnum.Graph].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Graph].tooltip, onClick: props.actions[ActionEnum.Graph].actionFunction }),
            React.createElement("div", { className: "toolbar-vertical-line" }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.FORMAT, buttonTitle: props.actions[ActionEnum.Format].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Format].tooltip, onClick: props.actions[ActionEnum.Format].actionFunction, displayChildren: props.uiState.displayFormatToolbarDropdown },
                React.createElement(Dropdown, { closeDropdown: () => props.setUIState(prevUIState => {
                        return Object.assign(Object.assign({}, prevUIState), { displayFormatToolbarDropdown: false });
                    }) }, getColumnFormatDropdownItemsUsingSelections(props.gridState, props.sheetData, props.mitoAPI)))),
        React.createElement("div", { className: 'toolbar-right-half' },
            props.currStepIdx !== props.lastStepIndex &&
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.CATCH_UP, buttonTitle: "CATCH UP", buttonSubtext: 'Stop looking at a previous step and catch up to the most recent edit', onClick: catchup }),
            React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.STEPS, buttonTitle: props.actions[ActionEnum.Steps].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Steps].tooltip, onClick: props.actions[ActionEnum.Steps].actionFunction }),
            React.createElement("div", { className: "toolbar-vertical-line" }),
            React.createElement(ToolbarButton, { toolbarButtonType: fullscreen ? ToolbarButtonType.CLOSE_FULLSCREEN : ToolbarButtonType.OPEN_FULLSCREEN, buttonTitle: props.actions[ActionEnum.Fullscreen].shortTitle.toUpperCase(), buttonSubtext: props.actions[ActionEnum.Fullscreen].tooltip, onClick: props.actions[ActionEnum.Fullscreen].actionFunction }),
            React.createElement("div", { className: "toolbar-vertical-line" }),
            React.createElement(Col, { className: 'vertical-align-content ml-5px mr-5px' },
                React.createElement(ActionSearchBar, { actions: props.actions, mitoAPI: props.mitoAPI, gridState: props.gridState, mitoContainerRef: props.mitoContainerRef, setGridState: props.setGridState })))));
};
export default Toolbar;
//# sourceMappingURL=Toolbar.js.map