/*
    A helper function for turning a record of values to an array,
    which makes it much easier to work with in the pivot table
    itself.
*/
export const valuesRecordToArray = (valuesRecord) => {
    const valuesArray = [];
    Object.keys(valuesRecord).forEach(columnHeader => {
        valuesRecord[columnHeader].forEach(aggregationType => {
            valuesArray.push([columnHeader, aggregationType]);
        });
    });
    return valuesArray;
};
/*
    A helper function for turning a array of values to an record,
    which is what the backend expects
*/
export const valuesArrayToRecord = (valuesArray) => {
    const valuesRecord = {};
    for (let i = 0; i < valuesArray.length; i++) {
        const [columnHeader, aggregationType] = valuesArray[i];
        if (valuesRecord[columnHeader] === undefined) {
            valuesRecord[columnHeader] = [];
        }
        valuesRecord[columnHeader].push(aggregationType);
    }
    return valuesRecord;
};
/*
    A helper function for making a mapping from dfName -> index of that dataframe,
    for all the df names we can select.

    Useful for making sure the user cannot select the pivot table they are currently
    editing as the source sheet, as this obviously causes errors.
*/
export const allDfNamesToSelectableDfNameToSheetIndex = (dfNames, destinationSheetIndex) => {
    const selectableDfNamesToSheetIndex = {};
    for (let i = 0; i < dfNames.length; i++) {
        if (i !== destinationSheetIndex) {
            selectableDfNamesToSheetIndex[dfNames[i]] = i;
        }
    }
    return selectableDfNamesToSheetIndex;
};
//# sourceMappingURL=pivotUtils.js.map