# Generated by Django 3.1.7 on 2021-04-01 07:58

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields
import security.enums


class Migration(migrations.Migration):
    dependencies = [
        ('security', '0003_migration'),
    ]

    operations = [
        migrations.CreateModel(
            name='CeleryTaskInvocationLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('invocation_id',
                 models.CharField(db_index=True, max_length=250, unique=True, verbose_name='invocation ID')),
                ('celery_task_id',
                 models.CharField(blank=True, db_index=True, max_length=250, null=True, verbose_name='celery ID')),
                ('name', models.CharField(db_index=True, max_length=250, verbose_name='task name')),
                ('queue_name', models.CharField(blank=True, max_length=250, null=True, verbose_name='queue name')),
                ('applied_at', models.DateTimeField(verbose_name='applied at')),
                ('triggered_at', models.DateTimeField(blank=True, null=True, verbose_name='triggered at')),
                ('is_unique', models.BooleanField(verbose_name='is unique')),
                ('is_async', models.BooleanField(verbose_name='is async')),
                ('is_duplicate', models.BooleanField(verbose_name='is duplicate')),
                ('is_on_commit', models.BooleanField(verbose_name='is on commit')),
                ('input', models.TextField(blank=True, editable=False, null=True, verbose_name='input')),
                ('task_args',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True, verbose_name='task args')),
                ('task_kwargs',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True, verbose_name='task kwargs')),
                ('estimated_time_of_first_arrival',
                 models.DateTimeField(blank=True, null=True, verbose_name='estimated time of first arrival')),
                ('expires_at', models.DateTimeField(blank=True, null=True, verbose_name='time of expiration')),
                ('stale_at', models.DateTimeField(blank=True, null=True, verbose_name='stale task time')),
                ('state', enumfields.fields.NumEnumField(db_index=True, default=1,
                                                         enum=security.enums.CeleryTaskInvocationLogState,
                                                         verbose_name='state')),
            ],
            options={
                'verbose_name': 'celery task',
                'verbose_name_plural': 'celery tasks',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskInvocationLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True, verbose_name='content type of the related object')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('celery_task_invocation_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security.celerytaskinvocationlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('celery_task_invocation_log', 'object_ct_id', 'object_id')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='celerytaskloggenericmanytomanyrelation',
            unique_together=None,
        ),
        migrations.RemoveField(
            model_name='celerytaskloggenericmanytomanyrelation',
            name='celery_task_log',
        ),
        migrations.AddField(
            model_name='celerytaskrunlog',
            name='queue_name',
            field=models.CharField(blank=True, max_length=250, null=True, verbose_name='queue name'),
        ),
        migrations.DeleteModel(
            name='CeleryTaskLog',
        ),
        migrations.DeleteModel(
            name='CeleryTaskLogGenericManyToManyRelation',
        ),
    ]
