"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrintTreeStructureVisitor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * @stability stable
 */
class PrintTreeStructureVisitor {
    constructor() {
        /**
         * @stability stable
         */
        this.indent = '|';
        /**
         * @stability stable
         */
        this.indentLevel = 0;
        /**
         * @stability stable
         */
        this.lastIndentLevel = 0;
        /**
         * @stability stable
         */
        this.output = '';
        /**
         * @stability stable
         */
        this.knownChildrenSeen = {};
    }
    /**
     * @stability stable
     */
    preVisit(node) {
        var _b, _c, _d;
        if (node.nodePath == '') {
            return;
        }
        if (node.parentNode) {
            if (this.knownChildrenSeen[node.parentNode.nodeId]) {
                this.knownChildrenSeen[node.parentNode.nodeId] += 1;
            }
            else {
                this.knownChildrenSeen[node.parentNode.nodeId] = 1;
            }
        }
        let parentChildrenSeen = ((_b = node.parentNode) === null || _b === void 0 ? void 0 : _b.nodeId) ? this.knownChildrenSeen[node.parentNode.nodeId] : 1;
        if (this.indentLevel != this.lastIndentLevel) {
            this.makeIndent();
        }
        if (this.indentLevel == 0) {
            this.output = this.output.concat(node.nodeId, '\n');
        }
        else {
            if (parentChildrenSeen == ((_c = node.parentNode) === null || _c === void 0 ? void 0 : _c.childrenNodes.length) || ((_d = node.parentNode) === null || _d === void 0 ? void 0 : _d.childrenNodes.length) == 1) {
                this.indent = this.indent.slice(0, -1);
                this.output = this.output.concat(this.indent, '`-- ', node.nodeId, '\n');
                this.indent = this.indent + ' ';
            }
            else {
                this.output = this.output.concat(this.indent, '-- ', node.nodeId, '\n');
            }
        }
        this.indentLevel += 1;
    }
    //@ts-ignore
    /**
     * @stability stable
     */
    visit(node) {
        if (node.nodePath == '') {
            return;
        }
        this.indentLevel -= 1;
    }
    //@ts-ignore
    /**
     * @stability stable
     */
    postVisit(node) { }
    /**
     * @stability stable
     */
    makeIndent() {
        if (this.indentLevel == 1) {
            this.lastIndentLevel++;
            return;
        }
        if (this.indentLevel > this.lastIndentLevel) {
            while (this.indentLevel > this.lastIndentLevel) {
                this.indent = this.indent + '    |';
                this.lastIndentLevel++;
            }
        }
        else {
            while (this.indentLevel < this.lastIndentLevel) {
                this.indent = this.indent.substr(0, this.indent.length - 5);
                this.lastIndentLevel--;
            }
        }
    }
}
exports.PrintTreeStructureVisitor = PrintTreeStructureVisitor;
_a = JSII_RTTI_SYMBOL_1;
PrintTreeStructureVisitor[_a] = { fqn: "cdk-utilities.PrintTreeStructureVisitor", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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