import * as cdk from '@aws-cdk/core';
import { IVisitor } from './IVisitor';
/**
 * @stability stable
 */
export declare class Node {
    private readonly _nodePath;
    private readonly _nodeId;
    private _parentNode;
    private _childrenNodes;
    private readonly _originalNode;
    /**
     * @stability stable
     */
    constructor(node: cdk.ConstructNode, parent?: Node, children?: Node[]);
    /**
     * @stability stable
     */
    set parentNode(node: Node);
    /**
     * @stability stable
     */
    get parentNode(): Node;
    /**
     * @stability stable
     */
    set childrenNodes(nodes: Node[]);
    /**
     * @stability stable
     */
    get childrenNodes(): Node[];
    /**
     * @stability stable
     */
    get originalNode(): cdk.ConstructNode;
    /**
     * @stability stable
     */
    addChild(node: Node): void;
    /**
     * @stability stable
     */
    get nodePath(): string;
    /**
     * @stability stable
     */
    get nodeId(): string;
    /**
     * @stability stable
     */
    accept(visitor: IVisitor): void;
}
/**
 * @stability stable
 */
export declare class ParseTree {
    private readonly _root;
    /**
     * @stability stable
     */
    constructor(app: cdk.App);
    /**
     * Create The Tree.
     *
     * @stability stable
     */
    createTree(constructNode: cdk.ConstructNode, parent?: Node): void;
    /**
     * @stability stable
     */
    findPaths(): string;
    /**
     * @stability stable
     */
    genTreeStructure(): string;
}
