"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
class FargateToSqs extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        if (props.queuePermissions) {
            defaults.CheckListValues(['Read', 'Write'], props.queuePermissions, 'queue permission');
        }
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.SQS);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        // Setup the SQS Queue
        [this.sqsQueue] = defaults.buildQueue(this, `${id}-queue`, {
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            existingQueueObj: props.existingQueueObj,
        });
        // Enable message send and receive permissions for Fargate service by default
        if (props.queuePermissions) {
            if (props.queuePermissions.includes('Read')) {
                this.sqsQueue.grantConsumeMessages(this.service.taskDefinition.taskRole);
            }
            if (props.queuePermissions.includes('Write')) {
                this.sqsQueue.grantSendMessages(this.service.taskDefinition.taskRole);
            }
        }
        else {
            this.sqsQueue.grantSendMessages(this.service.taskDefinition.taskRole);
        }
        // Setting environment variables
        const queueArnEnvironmentVariableName = props.queueArnEnvironmentVariableName || 'SQS_QUEUE_ARN';
        this.container.addEnvironment(queueArnEnvironmentVariableName, this.sqsQueue.queueArn);
        const queueUrlEnvironmentVariableName = props.queueUrlEnvironmentVariableName || 'SQS_QUEUE_URL';
        this.container.addEnvironment(queueUrlEnvironmentVariableName, this.sqsQueue.queueUrl);
    }
}
exports.FargateToSqs = FargateToSqs;
_a = JSII_RTTI_SYMBOL_1;
FargateToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-sqs.FargateToSqs", version: "1.171.0" };
//# sourceMappingURL=data:application/json;base64,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