use super::*;
use phf::{phf_map, phf_set};

pub const CONVERSION_TABLE: [(Keys, Map<&str, &str>); 3] = [
    (NUMERATIVE_CLASS4, CONV_TABLE4),
    (NUMERATIVE_CLASS5, CONV_TABLE5),
    (NUMERATIVE_CLASS6, CONV_TABLE6),
];

const NUMERATIVE_CLASS4: Keys = phf_set! {
    "人"
};
const CONV_TABLE4: Map<&str, &str> = phf_map! {
   "一"=> "一人,名詞,副詞可能,*,*,*,*,一人,ヒトリ,ヒトリ,2/3,*",
   "二"=> "二人,名詞,副詞可能,*,*,*,*,二人,フタリ,フタリ,3/3,*",
};

const NUMERATIVE_CLASS5: Keys = phf_set! {
    "日"
};
const CONV_TABLE5: Map<&str, &str> = phf_map! {
   "一"=> "一日,名詞,副詞可能,*,*,*,*,一日,イチニチ,イチニチ,4/4,*",
   "二"=> "二日,名詞,副詞可能,*,*,*,*,二日,フツカ,フツカ,0/3,*",
   "三"=> "三日,名詞,副詞可能,*,*,*,*,三日,ミッカ,ミッカ,0/3,*",
   "四"=> "四日,名詞,副詞可能,*,*,*,*,四日,ヨッカ,ヨッカ,0/3,*",
   "五"=> "五日,名詞,副詞可能,*,*,*,*,五日,イツカ,イツカ,0/3,*",
   "六"=> "六日,名詞,副詞可能,*,*,*,*,六日,ムイカ,ムイカ,0/3,*",
   "七"=> "七日,名詞,副詞可能,*,*,*,*,七日,ナノカ,ナノカ,0/3,*",
   "八"=> "八日,名詞,副詞可能,*,*,*,*,八日,ヨウカ,ヨーカ,0/3,*",
   "九"=> "九日,名詞,副詞可能,*,*,*,*,九日,ココノカ,ココノカ,0/4,*",
   "十"=> "十日,名詞,副詞可能,*,*,*,*,十日,トウカ,トーカ,0/3,*",
};

const NUMERATIVE_CLASS6: Keys = phf_set! {
    "日間"
};
const CONV_TABLE6: Map<&str, &str> = phf_map! {
   "一"=> "一日間,名詞,副詞可能,*,*,*,*,一日間,イチニチカン,イチニチカン,4/6,*",
   "二"=> "二日間,名詞,副詞可能,*,*,*,*,二日,フツカカン,フツカカン,3/5,*",
   "三"=> "三日間,名詞,副詞可能,*,*,*,*,三日,ミッカカン,ミッカカン,3/5,*",
   "四"=> "四日間,名詞,副詞可能,*,*,*,*,四日,ヨッカカン,ヨッカカン,3/5,*",
   "五"=> "五日間,名詞,副詞可能,*,*,*,*,五日,イツカカン,イツカカン,3/5,*",
   "六"=> "六日間,名詞,副詞可能,*,*,*,*,六日,ムイカカン,ムイカカン,3/5,*",
   "七"=> "七日間,名詞,副詞可能,*,*,*,*,七日,ナノカカン,ナノカカン,3/5,*",
   "八"=> "八日間,名詞,副詞可能,*,*,*,*,八日,ヨウカカン,ヨーカカン,3/5,*",
   "九"=> "九日間,名詞,副詞可能,*,*,*,*,九日,ココノカカン,ココノカカン,4/6,*",
   "十"=> "十日間,名詞,副詞可能,*,*,*,*,十日,トウカカン,トーカカン,3/5,*",
};
