# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sphinxcontrib',
 'sphinxcontrib.autodoc_pydantic',
 'sphinxcontrib.autodoc_pydantic.directives',
 'sphinxcontrib.autodoc_pydantic.directives.options']

package_data = \
{'': ['*'], 'sphinxcontrib.autodoc_pydantic': ['css/*']}

install_requires = \
['Sphinx>=3.4', 'pydantic>=1.5']

extras_require = \
{':extra == "docs" or extra == "dev"': ['sphinx-tabs==3.2',
                                        'sphinxcontrib-mermaid==0.7.1'],
 'dev': ['sphinx-rtd-theme>=1.0,<2.0',
         'sphinx-copybutton>=0.4,<0.5',
         'pytest>=6,<7',
         'coverage>=5,<6',
         'flake8>=3,<4',
         'tox>=3,<4'],
 'docs': ['sphinx-rtd-theme>=1.0,<2.0', 'sphinx-copybutton>=0.4,<0.5'],
 'test': ['pytest>=6,<7', 'coverage>=5,<6']}

setup_kwargs = {
    'name': 'autodoc-pydantic',
    'version': '1.6.2',
    'description': 'Seamlessly integrate pydantic models in your Sphinx documentation.',
    'long_description': '![Autodoc Pydantic](https://raw.githubusercontent.com/mansenfranzen/autodoc_pydantic/main/docs/source/material/logo_black.svg)\n\n[![PyPI version](https://img.shields.io/pypi/v/autodoc_pydantic?style=for-the-badge)](https://pypi.org/project/autodoc-pydantic/)\n![Python](https://img.shields.io/badge/python-3.6+-blue.svg?style=for-the-badge)\n\n[![Master](https://img.shields.io/github/workflow/status/mansenfranzen/autodoc_pydantic/ci?style=for-the-badge)](https://github.com/mansenfranzen/autodoc_pydantic/actions/workflows/tests.yml)\n[![Coverage](https://img.shields.io/codecov/c/gh/mansenfranzen/autodoc_pydantic?style=for-the-badge)](https://app.codecov.io/gh/mansenfranzen/autodoc_pydantic)\n\n<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->\n[![All Contributors](https://img.shields.io/badge/all_contributors-23-orange.svg?style=for-the-badge)](#contributors)<!-- ALL-CONTRIBUTORS-BADGE:END -->\n[![Downloads](https://img.shields.io/pypi/dm/autodoc_pydantic?color=fe7d37&style=for-the-badge)](https://pypistats.org/packages/autodoc-pydantic)\n\nYou love [pydantic](https://pydantic-docs.helpmanual.io/) ❤ and you want to\ndocument your models and configuration settings with [sphinx](https://www.sphinx-doc.org/en/master/)?\n\nPerfect, let\'s go. But wait, sphinx\' [autodoc](https://www.sphinx-doc.org/en/master/usage/extensions/autodoc.html)\ndoes not integrate too well with pydantic models 😕.\n\nDon\'t worry - just `pip install autodoc_pydantic` ☺.\n\n## Features\n\n- 💬 provides default values, alias and constraints for model fields\n- 🔗 adds hyperlinks between validators and corresponding fields\n- 📃 includes collapsable model json schema\n- 🏄 natively integrates with autodoc and autosummary extensions\n- 📎 defines explicit pydantic prefixes for models, settings, fields, validators and model config\n- 📋 shows summary section for model configuration, fields and validators\n- 👀 hides overloaded and redundant model class signature\n- 📚 sorts fields, validators and model config within models by type\n- 🍀 Supports `pydantic >= 1.5.0` and `sphinx >= 3.4.0`\n\n### Comparison between autodoc sphinx and autodoc pydantic\n\n[![Comparison](https://raw.githubusercontent.com/mansenfranzen/autodoc_pydantic/main/docs/source/material/example_comparison_v1.0.0.gif)](https://autodoc-pydantic.readthedocs.io/en/latest/examples.html#default-configuration)\n\nTo see those features in action, jump over to the [example documentation](https://autodoc-pydantic.readthedocs.io/en/stable/users/examples.html#default-configuration) to compare\nthe appearance of standard sphinx autodoc with *autodoc_pydantic*.\n\n## Documentation\n\nFor more details, please visit the official [documentation](https://autodoc-pydantic.readthedocs.io/en/stable/):\n\n- [Installation](https://autodoc-pydantic.readthedocs.io/en/stable/users/installation.html)\n- [Configuration](https://autodoc-pydantic.readthedocs.io/en/stable/users/configuration.html)\n- [Usage](https://autodoc-pydantic.readthedocs.io/en/stable/users/usage.html)\n- [Examples](https://autodoc-pydantic.readthedocs.io/en/stable/users/examples.html)\n\n## Acknowledgements\n\nThanks to great open source projects [sphinx](https://www.sphinx-doc.org/en/master/),\n[pydantic](https://pydantic-docs.helpmanual.io/) and\n[poetry](https://python-poetry.org/) (and so many more) ❤ in addition to the following contributors:\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tr>\n    <td align="center"><a href="https://github.com/mansenfranzen"><img src="https://avatars.githubusercontent.com/u/18086180?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Franz Wöllert</b></sub></a><br /><a href="#maintenance-mansenfranzen" title="Maintenance">🚧</a> <a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=mansenfranzen" title="Documentation">📖</a> <a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=mansenfranzen" title="Tests">⚠️</a> <a href="#content-mansenfranzen" title="Content">🖋</a></td>\n    <td align="center"><a href="https://github.com/TheBeardedBerserkr"><img src="https://avatars.githubusercontent.com/u/32272268?v=4?s=100" width="100px;" alt=""/><br /><sub><b>TheBeardedBerserkr</b></sub></a><br /><a href="#ideas-TheBeardedBerserkr" title="Ideas, Planning, & Feedback">🤔</a></td>\n    <td align="center"><a href="https://github.com/vlcinsky"><img src="https://avatars.githubusercontent.com/u/635911?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jan Vlčinský</b></sub></a><br /><a href="#security-vlcinsky" title="Security">🛡️</a></td>\n    <td align="center"><a href="https://github.com/antvig"><img src="https://avatars.githubusercontent.com/u/25105210?v=4?s=100" width="100px;" alt=""/><br /><sub><b>antvig</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Aantvig" title="Bug reports">🐛</a> <a href="#userTesting-antvig" title="User Testing">📓</a></td>\n    <td align="center"><a href="https://roguh.com"><img src="https://avatars.githubusercontent.com/u/6373447?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hugo O Rivera</b></sub></a><br /><a href="#ideas-roguh" title="Ideas, Planning, & Feedback">🤔</a></td>\n    <td align="center"><a href="https://github.com/ybnd"><img src="https://avatars.githubusercontent.com/u/31547038?v=4?s=100" width="100px;" alt=""/><br /><sub><b>yura bondarenko</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Aybnd" title="Bug reports">🐛</a> <a href="#userTesting-ybnd" title="User Testing">📓</a></td>\n    <td align="center"><a href="http://tahoward.github.io"><img src="https://avatars.githubusercontent.com/u/547570?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Trevor Howard</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Atahoward" title="Bug reports">🐛</a> <a href="#userTesting-tahoward" title="User Testing">📓</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/thomas-pedot"><img src="https://avatars.githubusercontent.com/u/86731212?v=4?s=100" width="100px;" alt=""/><br /><sub><b>thomas-pedot</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Athomas-pedot" title="Bug reports">🐛</a> <a href="#userTesting-thomas-pedot" title="User Testing">📓</a></td>\n    <td align="center"><a href="https://github.com/matutter"><img src="https://avatars.githubusercontent.com/u/2701379?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mat Utter</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Amatutter" title="Bug reports">🐛</a> <a href="#userTesting-matutter" title="User Testing">📓</a></td>\n    <td align="center"><a href="https://github.com/davidchall"><img src="https://avatars.githubusercontent.com/u/1804856?v=4?s=100" width="100px;" alt=""/><br /><sub><b>David C Hall</b></sub></a><br /><a href="#ideas-davidchall" title="Ideas, Planning, & Feedback">🤔</a> <a href="#userTesting-davidchall" title="User Testing">📓</a></td>\n    <td align="center"><a href="https://yoshanuikabundi.me"><img src="https://avatars.githubusercontent.com/u/28590748?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Josh A. Mitchell</b></sub></a><br /><a href="#ideas-Yoshanuikabundi" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=Yoshanuikabundi" title="Tests">⚠️</a></td>\n    <td align="center"><a href="https://github.com/goroderickgo"><img src="https://avatars.githubusercontent.com/u/17296713?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Roderick Go</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=goroderickgo" title="Tests">⚠️</a></td>\n    <td align="center"><a href="https://github.com/lilyminium"><img src="https://avatars.githubusercontent.com/u/31115101?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Lily Wang</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=lilyminium" title="Documentation">📖</a> <a href="#content-lilyminium" title="Content">🖋</a></td>\n    <td align="center"><a href="https://github.com/j-carson"><img src="https://avatars.githubusercontent.com/u/44308120?v=4?s=100" width="100px;" alt=""/><br /><sub><b>j-carson</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Aj-carson" title="Bug reports">🐛</a> <a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=j-carson" title="Code">💻</a> <a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=j-carson" title="Tests">⚠️</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="http://imada.sdu.dk/~jlandersen/"><img src="https://avatars.githubusercontent.com/u/6465735?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jakob Lykke Andersen</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=jakobandersen" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/astrojuanlu"><img src="https://avatars.githubusercontent.com/u/316517?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Juan Luis Cano Rodríguez</b></sub></a><br /><a href="#content-astrojuanlu" title="Content">🖋</a></td>\n    <td align="center"><a href="https://github.com/nchaly"><img src="https://avatars.githubusercontent.com/u/2665273?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mikalai Chaly</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Anchaly" title="Bug reports">🐛</a> <a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=nchaly" title="Tests">⚠️</a></td>\n    <td align="center"><a href="https://github.com/StigKorsnes"><img src="https://avatars.githubusercontent.com/u/10085536?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Stig Korsnes</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3AStigKorsnes" title="Bug reports">🐛</a> <a href="#ideas-StigKorsnes" title="Ideas, Planning, & Feedback">🤔</a></td>\n    <td align="center"><a href="https://github.com/iliakur"><img src="https://avatars.githubusercontent.com/u/899591?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ilia Kurenkov</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Ailiakur" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://orcid.org/my-orcid?orcid=0000-0002-5470-1676"><img src="https://avatars.githubusercontent.com/u/3826210?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Grzegorz Bokota</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3ACzaki" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/jgunstone"><img src="https://avatars.githubusercontent.com/u/21370980?v=4?s=100" width="100px;" alt=""/><br /><sub><b>jgunstone</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Ajgunstone" title="Bug reports">🐛</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/iwyrkore"><img src="https://avatars.githubusercontent.com/u/92745880?v=4?s=100" width="100px;" alt=""/><br /><sub><b>iwyrkore</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/commits?author=iwyrkore" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/spacemanspiff2007"><img src="https://avatars.githubusercontent.com/u/10754716?v=4?s=100" width="100px;" alt=""/><br /><sub><b>spacemanspiff2007</b></sub></a><br /><a href="https://github.com/mansenfranzen/autodoc_pydantic/issues?q=author%3Aspacemanspiff2007" title="Bug reports">🐛</a> <a href="#ideas-spacemanspiff2007" title="Ideas, Planning, & Feedback">🤔</a></td>\n  </tr>\n</table>\n\n<!-- markdownlint-restore -->\n<!-- prettier-ignore-end -->\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!\n',
    'author': 'mansenfranzen',
    'author_email': 'franz.woellert@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mansenfranzen/autodoc_pydantic',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
