from setuptools import setup, find_namespace_packages

with open("README.md", "r", encoding="utf-8") as f:
    long_description = f.read()

setup(
    name="ashborn-sparky",
    version="0.2.0",  # Recommended: use 0.1.0 format
    author="Ashborn",
    description="A short description of what sparky does",  # Improve this!
    long_description=long_description,
    long_description_content_type="text/markdown",
    license="MIT",
    license_files=("LICENSE.txt",),

    # Source layout
    package_dir={"": "src"},
    packages=find_namespace_packages(where="src"),  # Only once!

    # Include data files
    include_package_data=True,
    package_data={
        "ashborn-sparky": ["data/**"]
    },

    install_requires=[],

    classifiers=[
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.7",
    zip_safe=False,
)