### Statistical Distribution Package

> **Smart-dist** is a package for Crypto Analytics as well as adjunct tools that deal with statistical Binomial and Gaussian distribution data  
  
<br/><br/>


|Crypto Chart||
|--|--|
|![473D53FD-6C4D-4A46-89D6-B810F8015DB2](https://user-images.githubusercontent.com/70070334/136704293-e3d8290c-dff6-4158-ae94-6ded81b1bf9e.jpeg)|![75270875-19BA-405E-81B5-E5B9B66DB100](https://user-images.githubusercontent.com/70070334/136704295-30e050d4-7364-4686-bc30-9be49d3da4eb.jpeg)|


|Gaussian Distribution| Probability Density Function | Binomial Distribution |
|--|--|--|
|![gauss_dist](https://user-images.githubusercontent.com/70070334/136705128-f450b393-27e2-4dfa-8308-579efa113dac.jpeg)|![prob_dist](https://upload.wikimedia.org/wikipedia/commons/thumb/1/1a/Boxplot_vs_PDF.svg/350px-Boxplot_vs_PDF.svg.png)| ![bino_dist](https://upload.wikimedia.org/wikipedia/commons/thumb/7/75/Binomial_distribution_pmf.svg/300px-Binomial_distribution_pmf.svg.png)


<div align="left">
  <table>
    <tr>
      <th>Package Released</th>
      <th>Version</th>
      <th>Downloads</th>
      <th>Installation</th>
      <th>Analysis</th>
     <th>Details</th>
    </tr>
    <tr>
      <td><a href = "https://pypi.org/project/smart-dist/">smart-dist</a></td>
      <td><a href="https://pypi.org/project/smart-dist/"><img src="https://img.shields.io/pypi/v/smart-dist?style=flat-square"/></a></td>
      <td><a href="https://pepy.tech/project/smart-dist"><img src="https://pepy.tech/badge/smart-dist"/></a></td>
      <td>pip install -U smart_dist</td>
      <td><a href = "https://github.com/invest41/Exploring_Libraries/blob/main/Smart_dist_Package_Analysis.ipynb">smart-dist Analysis</a></td>
      <td>
       <img src="https://img.shields.io/pypi/l/smart-dist?style=flat-square"/>
       <img src="https://img.shields.io/badge/dynamic/json?color=blue&label=docs&prefix=v&query=%24.info.version&url=https%3A%2F%2Fpypi.org%2Fpypi%2Fsmart_dist%2Fjson&style=flat-square"/>
       <!--img src="https://img.shields.io/pypi/pyversions/smart-dist?style=flat-square"/-->
       <!--img src="https://app.codacy.com/project/badge/Coverage/ed658f08dcce4f088c850253475540ba"/-->
       <!--img src="https://img.shields.io/codecov/c/github/sfu-db/smart-dist?style=flat-square"/-->
       <!--img src="https://app.codacy.com/project/badge/Grade/ed658f08dcce4f088c850253475540ba"/-->
       <!--img src="https://img.shields.io/discord/702765817154109472?style=flat-square"/-->
     </td>
    </tr>
  </table>
</div> 

### **Crypto Analysis**
- To install the smart-dist project, run this command in your terminal:
```python 3
$ pip install smart_dist
```
- Import the crypto class from the Coinanalysis module, for visualizing crypto data
``` python 
>>> from smart_dist.Coinanalysis import crypto
```
- Initialize a variable to work with the crypto object
```python
>>> coin = crypto()
Crypto Working Space Activated...
```
- Checking for Documentation
```python
>>> help(coin)
```

- **Examples of Valid use**
```python
  >>>  coin.get_crypto_visuals("ETH")

  >>>  coin.get_crypto_visuals("ETH", MA=True)

  >>>  coin.get_crypto_visuals("ETH", period="5d", interval="15m",MA=True, days=[5, 20], save_fig=True)

  >>>  coin.get_crypto_visuals("BTC", period="3d", interval="15m", boll=True, boll_sma=26, save_fig=True, img_format='jpeg')
  ```

|Resulting Crypto Chart||
|--|--|
|![473D53FD-6C4D-4A46-89D6-B810F8015DB2](https://user-images.githubusercontent.com/70070334/136704293-e3d8290c-dff6-4158-ae94-6ded81b1bf9e.jpeg)|![75270875-19BA-405E-81B5-E5B9B66DB100](https://user-images.githubusercontent.com/70070334/136704295-30e050d4-7364-4686-bc30-9be49d3da4eb.jpeg)|

#### **Credit**:
Statistical Distribution package highly influenced by work from Udacity.  
[Udacity's AWS ML SCHOLARSHIP](https://www.udacity.com/scholarships/aws-machine-learning-scholarship-program)
