# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApplicationCSVMappingParameters',
    'ApplicationCatalogConfiguration',
    'ApplicationCheckpointConfiguration',
    'ApplicationCloudWatchLoggingOptionCloudWatchLoggingOption',
    'ApplicationCodeConfiguration',
    'ApplicationCodeContent',
    'ApplicationConfiguration',
    'ApplicationCustomArtifactConfiguration',
    'ApplicationDeployAsApplicationConfiguration',
    'ApplicationEnvironmentProperties',
    'ApplicationFlinkApplicationConfiguration',
    'ApplicationGlueDataCatalogConfiguration',
    'ApplicationInput',
    'ApplicationInputLambdaProcessor',
    'ApplicationInputParallelism',
    'ApplicationInputProcessingConfiguration',
    'ApplicationInputSchema',
    'ApplicationJSONMappingParameters',
    'ApplicationKinesisFirehoseInput',
    'ApplicationKinesisStreamsInput',
    'ApplicationMappingParameters',
    'ApplicationMavenReference',
    'ApplicationMonitoringConfiguration',
    'ApplicationOutputResourceDestinationSchema',
    'ApplicationOutputResourceKinesisFirehoseOutput',
    'ApplicationOutputResourceKinesisStreamsOutput',
    'ApplicationOutputResourceLambdaOutput',
    'ApplicationOutputResourceOutput',
    'ApplicationParallelismConfiguration',
    'ApplicationPropertyGroup',
    'ApplicationRecordColumn',
    'ApplicationRecordFormat',
    'ApplicationReferenceDataSourceCSVMappingParameters',
    'ApplicationReferenceDataSourceJSONMappingParameters',
    'ApplicationReferenceDataSourceMappingParameters',
    'ApplicationReferenceDataSourceRecordColumn',
    'ApplicationReferenceDataSourceRecordFormat',
    'ApplicationReferenceDataSourceReferenceDataSource',
    'ApplicationReferenceDataSourceReferenceSchema',
    'ApplicationReferenceDataSourceS3ReferenceDataSource',
    'ApplicationS3ContentBaseLocation',
    'ApplicationS3ContentLocation',
    'ApplicationSnapshotConfiguration',
    'ApplicationSqlApplicationConfiguration',
    'ApplicationTag',
    'ApplicationZeppelinApplicationConfiguration',
    'ApplicationZeppelinMonitoringConfiguration',
]

@pulumi.output_type
class ApplicationCSVMappingParameters(dict):
    """
    For a SQL-based Kinesis Data Analytics application, provides additional mapping information when the record format uses delimiters, such as CSV. For example, the following sample records use CSV format, where the records use the '\\n' as the row delimiter and a comma (",") as the column delimiter:
    `"name1", "address1"`
    `"name2", "address2"`
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordColumnDelimiter":
            suggest = "record_column_delimiter"
        elif key == "recordRowDelimiter":
            suggest = "record_row_delimiter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationCSVMappingParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationCSVMappingParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationCSVMappingParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_column_delimiter: str,
                 record_row_delimiter: str):
        """
        For a SQL-based Kinesis Data Analytics application, provides additional mapping information when the record format uses delimiters, such as CSV. For example, the following sample records use CSV format, where the records use the '\\n' as the row delimiter and a comma (",") as the column delimiter:
        `"name1", "address1"`
        `"name2", "address2"`
        :param str record_column_delimiter: The column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
        :param str record_row_delimiter: The row delimiter. For example, in a CSV format, '\\n' is the typical row delimiter.
        """
        pulumi.set(__self__, "record_column_delimiter", record_column_delimiter)
        pulumi.set(__self__, "record_row_delimiter", record_row_delimiter)

    @property
    @pulumi.getter(name="recordColumnDelimiter")
    def record_column_delimiter(self) -> str:
        """
        The column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
        """
        return pulumi.get(self, "record_column_delimiter")

    @property
    @pulumi.getter(name="recordRowDelimiter")
    def record_row_delimiter(self) -> str:
        """
        The row delimiter. For example, in a CSV format, '\\n' is the typical row delimiter.
        """
        return pulumi.get(self, "record_row_delimiter")


@pulumi.output_type
class ApplicationCatalogConfiguration(dict):
    """
    The configuration parameters for the default Amazon Glue database. You use this database for SQL queries that you write in a Kinesis Data Analytics Studio notebook.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "glueDataCatalogConfiguration":
            suggest = "glue_data_catalog_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationCatalogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationCatalogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationCatalogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 glue_data_catalog_configuration: Optional['outputs.ApplicationGlueDataCatalogConfiguration'] = None):
        """
        The configuration parameters for the default Amazon Glue database. You use this database for SQL queries that you write in a Kinesis Data Analytics Studio notebook.
        :param 'ApplicationGlueDataCatalogConfiguration' glue_data_catalog_configuration: The configuration parameters for the default Amazon Glue database. You use this database for Apache Flink SQL queries and table API transforms that you write in a Kinesis Data Analytics Studio notebook.
        """
        if glue_data_catalog_configuration is not None:
            pulumi.set(__self__, "glue_data_catalog_configuration", glue_data_catalog_configuration)

    @property
    @pulumi.getter(name="glueDataCatalogConfiguration")
    def glue_data_catalog_configuration(self) -> Optional['outputs.ApplicationGlueDataCatalogConfiguration']:
        """
        The configuration parameters for the default Amazon Glue database. You use this database for Apache Flink SQL queries and table API transforms that you write in a Kinesis Data Analytics Studio notebook.
        """
        return pulumi.get(self, "glue_data_catalog_configuration")


@pulumi.output_type
class ApplicationCheckpointConfiguration(dict):
    """
    Describes an application's checkpointing configuration. Checkpointing is the process of persisting application state for fault tolerance. For more information, see Checkpoints for Fault Tolerance in the Apache Flink Documentation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "checkpointInterval":
            suggest = "checkpoint_interval"
        elif key == "checkpointingEnabled":
            suggest = "checkpointing_enabled"
        elif key == "minPauseBetweenCheckpoints":
            suggest = "min_pause_between_checkpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationCheckpointConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationCheckpointConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationCheckpointConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: 'ApplicationCheckpointConfigurationConfigurationType',
                 checkpoint_interval: Optional[int] = None,
                 checkpointing_enabled: Optional[bool] = None,
                 min_pause_between_checkpoints: Optional[int] = None):
        """
        Describes an application's checkpointing configuration. Checkpointing is the process of persisting application state for fault tolerance. For more information, see Checkpoints for Fault Tolerance in the Apache Flink Documentation.
        :param 'ApplicationCheckpointConfigurationConfigurationType' configuration_type: Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must set this property to `CUSTOM` in order to set the `CheckpointingEnabled`, `CheckpointInterval`, or `MinPauseBetweenCheckpoints` parameters.
        :param int checkpoint_interval: Describes the interval in milliseconds between checkpoint operations.
        :param bool checkpointing_enabled: Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
        :param int min_pause_between_checkpoints: Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start. If a checkpoint operation takes longer than the CheckpointInterval, the application otherwise performs continual checkpoint operations. For more information, see Tuning Checkpointing in the Apache Flink Documentation.
        """
        pulumi.set(__self__, "configuration_type", configuration_type)
        if checkpoint_interval is not None:
            pulumi.set(__self__, "checkpoint_interval", checkpoint_interval)
        if checkpointing_enabled is not None:
            pulumi.set(__self__, "checkpointing_enabled", checkpointing_enabled)
        if min_pause_between_checkpoints is not None:
            pulumi.set(__self__, "min_pause_between_checkpoints", min_pause_between_checkpoints)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> 'ApplicationCheckpointConfigurationConfigurationType':
        """
        Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must set this property to `CUSTOM` in order to set the `CheckpointingEnabled`, `CheckpointInterval`, or `MinPauseBetweenCheckpoints` parameters.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="checkpointInterval")
    def checkpoint_interval(self) -> Optional[int]:
        """
        Describes the interval in milliseconds between checkpoint operations.
        """
        return pulumi.get(self, "checkpoint_interval")

    @property
    @pulumi.getter(name="checkpointingEnabled")
    def checkpointing_enabled(self) -> Optional[bool]:
        """
        Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
        """
        return pulumi.get(self, "checkpointing_enabled")

    @property
    @pulumi.getter(name="minPauseBetweenCheckpoints")
    def min_pause_between_checkpoints(self) -> Optional[int]:
        """
        Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start. If a checkpoint operation takes longer than the CheckpointInterval, the application otherwise performs continual checkpoint operations. For more information, see Tuning Checkpointing in the Apache Flink Documentation.
        """
        return pulumi.get(self, "min_pause_between_checkpoints")


@pulumi.output_type
class ApplicationCloudWatchLoggingOptionCloudWatchLoggingOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreamARN":
            suggest = "log_stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationCloudWatchLoggingOptionCloudWatchLoggingOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationCloudWatchLoggingOptionCloudWatchLoggingOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationCloudWatchLoggingOptionCloudWatchLoggingOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_stream_arn: str):
        pulumi.set(__self__, "log_stream_arn", log_stream_arn)

    @property
    @pulumi.getter(name="logStreamARN")
    def log_stream_arn(self) -> str:
        return pulumi.get(self, "log_stream_arn")


@pulumi.output_type
class ApplicationCodeConfiguration(dict):
    """
    Describes code configuration for an application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeContent":
            suggest = "code_content"
        elif key == "codeContentType":
            suggest = "code_content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationCodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationCodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationCodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_content: 'outputs.ApplicationCodeContent',
                 code_content_type: 'ApplicationCodeConfigurationCodeContentType'):
        """
        Describes code configuration for an application.
        :param 'ApplicationCodeContent' code_content: The location and type of the application code.
        :param 'ApplicationCodeConfigurationCodeContentType' code_content_type: Specifies whether the code content is in text or zip format.
        """
        pulumi.set(__self__, "code_content", code_content)
        pulumi.set(__self__, "code_content_type", code_content_type)

    @property
    @pulumi.getter(name="codeContent")
    def code_content(self) -> 'outputs.ApplicationCodeContent':
        """
        The location and type of the application code.
        """
        return pulumi.get(self, "code_content")

    @property
    @pulumi.getter(name="codeContentType")
    def code_content_type(self) -> 'ApplicationCodeConfigurationCodeContentType':
        """
        Specifies whether the code content is in text or zip format.
        """
        return pulumi.get(self, "code_content_type")


@pulumi.output_type
class ApplicationCodeContent(dict):
    """
    Specifies either the application code, or the location of the application code, for a Flink-based Kinesis Data Analytics application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3ContentLocation":
            suggest = "s3_content_location"
        elif key == "textContent":
            suggest = "text_content"
        elif key == "zipFileContent":
            suggest = "zip_file_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationCodeContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationCodeContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationCodeContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_content_location: Optional['outputs.ApplicationS3ContentLocation'] = None,
                 text_content: Optional[str] = None,
                 zip_file_content: Optional[str] = None):
        """
        Specifies either the application code, or the location of the application code, for a Flink-based Kinesis Data Analytics application.
        :param 'ApplicationS3ContentLocation' s3_content_location: Information about the Amazon S3 bucket that contains the application code.
        :param str text_content: The text-format code for a Flink-based Kinesis Data Analytics application.
        :param str zip_file_content: The zip-format code for a Flink-based Kinesis Data Analytics application.
        """
        if s3_content_location is not None:
            pulumi.set(__self__, "s3_content_location", s3_content_location)
        if text_content is not None:
            pulumi.set(__self__, "text_content", text_content)
        if zip_file_content is not None:
            pulumi.set(__self__, "zip_file_content", zip_file_content)

    @property
    @pulumi.getter(name="s3ContentLocation")
    def s3_content_location(self) -> Optional['outputs.ApplicationS3ContentLocation']:
        """
        Information about the Amazon S3 bucket that contains the application code.
        """
        return pulumi.get(self, "s3_content_location")

    @property
    @pulumi.getter(name="textContent")
    def text_content(self) -> Optional[str]:
        """
        The text-format code for a Flink-based Kinesis Data Analytics application.
        """
        return pulumi.get(self, "text_content")

    @property
    @pulumi.getter(name="zipFileContent")
    def zip_file_content(self) -> Optional[str]:
        """
        The zip-format code for a Flink-based Kinesis Data Analytics application.
        """
        return pulumi.get(self, "zip_file_content")


@pulumi.output_type
class ApplicationConfiguration(dict):
    """
    Specifies the creation parameters for a Kinesis Data Analytics application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationCodeConfiguration":
            suggest = "application_code_configuration"
        elif key == "applicationSnapshotConfiguration":
            suggest = "application_snapshot_configuration"
        elif key == "environmentProperties":
            suggest = "environment_properties"
        elif key == "flinkApplicationConfiguration":
            suggest = "flink_application_configuration"
        elif key == "sqlApplicationConfiguration":
            suggest = "sql_application_configuration"
        elif key == "zeppelinApplicationConfiguration":
            suggest = "zeppelin_application_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_code_configuration: Optional['outputs.ApplicationCodeConfiguration'] = None,
                 application_snapshot_configuration: Optional['outputs.ApplicationSnapshotConfiguration'] = None,
                 environment_properties: Optional['outputs.ApplicationEnvironmentProperties'] = None,
                 flink_application_configuration: Optional['outputs.ApplicationFlinkApplicationConfiguration'] = None,
                 sql_application_configuration: Optional['outputs.ApplicationSqlApplicationConfiguration'] = None,
                 zeppelin_application_configuration: Optional['outputs.ApplicationZeppelinApplicationConfiguration'] = None):
        """
        Specifies the creation parameters for a Kinesis Data Analytics application.
        :param 'ApplicationCodeConfiguration' application_code_configuration: The code location and type parameters for a Flink-based Kinesis Data Analytics application.
        :param 'ApplicationSnapshotConfiguration' application_snapshot_configuration: Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
        :param 'ApplicationEnvironmentProperties' environment_properties: Describes execution properties for a Flink-based Kinesis Data Analytics application.
        :param 'ApplicationFlinkApplicationConfiguration' flink_application_configuration: The creation and update parameters for a Flink-based Kinesis Data Analytics application.
        :param 'ApplicationSqlApplicationConfiguration' sql_application_configuration: The creation and update parameters for a SQL-based Kinesis Data Analytics application.
        :param 'ApplicationZeppelinApplicationConfiguration' zeppelin_application_configuration: The configuration parameters for a Kinesis Data Analytics Studio notebook.
        """
        if application_code_configuration is not None:
            pulumi.set(__self__, "application_code_configuration", application_code_configuration)
        if application_snapshot_configuration is not None:
            pulumi.set(__self__, "application_snapshot_configuration", application_snapshot_configuration)
        if environment_properties is not None:
            pulumi.set(__self__, "environment_properties", environment_properties)
        if flink_application_configuration is not None:
            pulumi.set(__self__, "flink_application_configuration", flink_application_configuration)
        if sql_application_configuration is not None:
            pulumi.set(__self__, "sql_application_configuration", sql_application_configuration)
        if zeppelin_application_configuration is not None:
            pulumi.set(__self__, "zeppelin_application_configuration", zeppelin_application_configuration)

    @property
    @pulumi.getter(name="applicationCodeConfiguration")
    def application_code_configuration(self) -> Optional['outputs.ApplicationCodeConfiguration']:
        """
        The code location and type parameters for a Flink-based Kinesis Data Analytics application.
        """
        return pulumi.get(self, "application_code_configuration")

    @property
    @pulumi.getter(name="applicationSnapshotConfiguration")
    def application_snapshot_configuration(self) -> Optional['outputs.ApplicationSnapshotConfiguration']:
        """
        Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
        """
        return pulumi.get(self, "application_snapshot_configuration")

    @property
    @pulumi.getter(name="environmentProperties")
    def environment_properties(self) -> Optional['outputs.ApplicationEnvironmentProperties']:
        """
        Describes execution properties for a Flink-based Kinesis Data Analytics application.
        """
        return pulumi.get(self, "environment_properties")

    @property
    @pulumi.getter(name="flinkApplicationConfiguration")
    def flink_application_configuration(self) -> Optional['outputs.ApplicationFlinkApplicationConfiguration']:
        """
        The creation and update parameters for a Flink-based Kinesis Data Analytics application.
        """
        return pulumi.get(self, "flink_application_configuration")

    @property
    @pulumi.getter(name="sqlApplicationConfiguration")
    def sql_application_configuration(self) -> Optional['outputs.ApplicationSqlApplicationConfiguration']:
        """
        The creation and update parameters for a SQL-based Kinesis Data Analytics application.
        """
        return pulumi.get(self, "sql_application_configuration")

    @property
    @pulumi.getter(name="zeppelinApplicationConfiguration")
    def zeppelin_application_configuration(self) -> Optional['outputs.ApplicationZeppelinApplicationConfiguration']:
        """
        The configuration parameters for a Kinesis Data Analytics Studio notebook.
        """
        return pulumi.get(self, "zeppelin_application_configuration")


@pulumi.output_type
class ApplicationCustomArtifactConfiguration(dict):
    """
    The configuration of connectors and user-defined functions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactType":
            suggest = "artifact_type"
        elif key == "mavenReference":
            suggest = "maven_reference"
        elif key == "s3ContentLocation":
            suggest = "s3_content_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationCustomArtifactConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationCustomArtifactConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationCustomArtifactConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_type: 'ApplicationCustomArtifactConfigurationArtifactType',
                 maven_reference: Optional['outputs.ApplicationMavenReference'] = None,
                 s3_content_location: Optional['outputs.ApplicationS3ContentLocation'] = None):
        """
        The configuration of connectors and user-defined functions.
        :param 'ApplicationCustomArtifactConfigurationArtifactType' artifact_type: Set this to either `UDF` or `DEPENDENCY_JAR`. `UDF` stands for user-defined functions. This type of artifact must be in an S3 bucket. A `DEPENDENCY_JAR` can be in either Maven or an S3 bucket.
        :param 'ApplicationMavenReference' maven_reference: The parameters required to fully specify a Maven reference.
        :param 'ApplicationS3ContentLocation' s3_content_location: The location of the custom artifacts.
        """
        pulumi.set(__self__, "artifact_type", artifact_type)
        if maven_reference is not None:
            pulumi.set(__self__, "maven_reference", maven_reference)
        if s3_content_location is not None:
            pulumi.set(__self__, "s3_content_location", s3_content_location)

    @property
    @pulumi.getter(name="artifactType")
    def artifact_type(self) -> 'ApplicationCustomArtifactConfigurationArtifactType':
        """
        Set this to either `UDF` or `DEPENDENCY_JAR`. `UDF` stands for user-defined functions. This type of artifact must be in an S3 bucket. A `DEPENDENCY_JAR` can be in either Maven or an S3 bucket.
        """
        return pulumi.get(self, "artifact_type")

    @property
    @pulumi.getter(name="mavenReference")
    def maven_reference(self) -> Optional['outputs.ApplicationMavenReference']:
        """
        The parameters required to fully specify a Maven reference.
        """
        return pulumi.get(self, "maven_reference")

    @property
    @pulumi.getter(name="s3ContentLocation")
    def s3_content_location(self) -> Optional['outputs.ApplicationS3ContentLocation']:
        """
        The location of the custom artifacts.
        """
        return pulumi.get(self, "s3_content_location")


@pulumi.output_type
class ApplicationDeployAsApplicationConfiguration(dict):
    """
    The information required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3ContentLocation":
            suggest = "s3_content_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationDeployAsApplicationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationDeployAsApplicationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationDeployAsApplicationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_content_location: 'outputs.ApplicationS3ContentBaseLocation'):
        """
        The information required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
        :param 'ApplicationS3ContentBaseLocation' s3_content_location: The description of an Amazon S3 object that contains the Amazon Data Analytics application, including the Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and the version number of the Amazon S3 object that contains the data.
        """
        pulumi.set(__self__, "s3_content_location", s3_content_location)

    @property
    @pulumi.getter(name="s3ContentLocation")
    def s3_content_location(self) -> 'outputs.ApplicationS3ContentBaseLocation':
        """
        The description of an Amazon S3 object that contains the Amazon Data Analytics application, including the Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and the version number of the Amazon S3 object that contains the data.
        """
        return pulumi.get(self, "s3_content_location")


@pulumi.output_type
class ApplicationEnvironmentProperties(dict):
    """
    Describes execution properties for a Flink-based Kinesis Data Analytics application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyGroups":
            suggest = "property_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationEnvironmentProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationEnvironmentProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationEnvironmentProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property_groups: Optional[Sequence['outputs.ApplicationPropertyGroup']] = None):
        """
        Describes execution properties for a Flink-based Kinesis Data Analytics application.
        :param Sequence['ApplicationPropertyGroup'] property_groups: Describes the execution property groups.
        """
        if property_groups is not None:
            pulumi.set(__self__, "property_groups", property_groups)

    @property
    @pulumi.getter(name="propertyGroups")
    def property_groups(self) -> Optional[Sequence['outputs.ApplicationPropertyGroup']]:
        """
        Describes the execution property groups.
        """
        return pulumi.get(self, "property_groups")


@pulumi.output_type
class ApplicationFlinkApplicationConfiguration(dict):
    """
    Describes configuration parameters for a Flink-based Kinesis Data Analytics application or a Studio notebook.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkpointConfiguration":
            suggest = "checkpoint_configuration"
        elif key == "monitoringConfiguration":
            suggest = "monitoring_configuration"
        elif key == "parallelismConfiguration":
            suggest = "parallelism_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationFlinkApplicationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationFlinkApplicationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationFlinkApplicationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 checkpoint_configuration: Optional['outputs.ApplicationCheckpointConfiguration'] = None,
                 monitoring_configuration: Optional['outputs.ApplicationMonitoringConfiguration'] = None,
                 parallelism_configuration: Optional['outputs.ApplicationParallelismConfiguration'] = None):
        """
        Describes configuration parameters for a Flink-based Kinesis Data Analytics application or a Studio notebook.
        :param 'ApplicationCheckpointConfiguration' checkpoint_configuration: Describes an application's checkpointing configuration. Checkpointing is the process of persisting application state for fault tolerance. For more information, see Checkpoints for Fault Tolerance in the Apache Flink Documentation.
        :param 'ApplicationMonitoringConfiguration' monitoring_configuration: Describes configuration parameters for Amazon CloudWatch logging for an application.
        :param 'ApplicationParallelismConfiguration' parallelism_configuration: Describes parameters for how an application executes multiple tasks simultaneously.
        """
        if checkpoint_configuration is not None:
            pulumi.set(__self__, "checkpoint_configuration", checkpoint_configuration)
        if monitoring_configuration is not None:
            pulumi.set(__self__, "monitoring_configuration", monitoring_configuration)
        if parallelism_configuration is not None:
            pulumi.set(__self__, "parallelism_configuration", parallelism_configuration)

    @property
    @pulumi.getter(name="checkpointConfiguration")
    def checkpoint_configuration(self) -> Optional['outputs.ApplicationCheckpointConfiguration']:
        """
        Describes an application's checkpointing configuration. Checkpointing is the process of persisting application state for fault tolerance. For more information, see Checkpoints for Fault Tolerance in the Apache Flink Documentation.
        """
        return pulumi.get(self, "checkpoint_configuration")

    @property
    @pulumi.getter(name="monitoringConfiguration")
    def monitoring_configuration(self) -> Optional['outputs.ApplicationMonitoringConfiguration']:
        """
        Describes configuration parameters for Amazon CloudWatch logging for an application.
        """
        return pulumi.get(self, "monitoring_configuration")

    @property
    @pulumi.getter(name="parallelismConfiguration")
    def parallelism_configuration(self) -> Optional['outputs.ApplicationParallelismConfiguration']:
        """
        Describes parameters for how an application executes multiple tasks simultaneously.
        """
        return pulumi.get(self, "parallelism_configuration")


@pulumi.output_type
class ApplicationGlueDataCatalogConfiguration(dict):
    """
    The configuration of the Glue Data Catalog that you use for Apache Flink SQL queries and table API transforms that you write in an application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseARN":
            suggest = "database_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGlueDataCatalogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGlueDataCatalogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGlueDataCatalogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_arn: Optional[str] = None):
        """
        The configuration of the Glue Data Catalog that you use for Apache Flink SQL queries and table API transforms that you write in an application.
        :param str database_arn: The Amazon Resource Name (ARN) of the database.
        """
        if database_arn is not None:
            pulumi.set(__self__, "database_arn", database_arn)

    @property
    @pulumi.getter(name="databaseARN")
    def database_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the database.
        """
        return pulumi.get(self, "database_arn")


@pulumi.output_type
class ApplicationInput(dict):
    """
    When you configure the application input for a SQL-based Kinesis Data Analytics application, you specify the streaming source, the in-application stream name that is created, and the mapping between the two.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputSchema":
            suggest = "input_schema"
        elif key == "namePrefix":
            suggest = "name_prefix"
        elif key == "inputParallelism":
            suggest = "input_parallelism"
        elif key == "inputProcessingConfiguration":
            suggest = "input_processing_configuration"
        elif key == "kinesisFirehoseInput":
            suggest = "kinesis_firehose_input"
        elif key == "kinesisStreamsInput":
            suggest = "kinesis_streams_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_schema: 'outputs.ApplicationInputSchema',
                 name_prefix: str,
                 input_parallelism: Optional['outputs.ApplicationInputParallelism'] = None,
                 input_processing_configuration: Optional['outputs.ApplicationInputProcessingConfiguration'] = None,
                 kinesis_firehose_input: Optional['outputs.ApplicationKinesisFirehoseInput'] = None,
                 kinesis_streams_input: Optional['outputs.ApplicationKinesisStreamsInput'] = None):
        """
        When you configure the application input for a SQL-based Kinesis Data Analytics application, you specify the streaming source, the in-application stream name that is created, and the mapping between the two.
        :param 'ApplicationInputSchema' input_schema: Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
        :param str name_prefix: The name prefix to use when creating an in-application stream. Suppose that you specify a prefix `"MyInApplicationStream"`. Kinesis Data Analytics then creates one or more (as per the InputParallelism count you specified) in-application streams with the names `"MyInApplicationStream_001"`, `"MyInApplicationStream_002"`, and so on.
        :param 'ApplicationInputParallelism' input_parallelism: Describes the number of in-application streams to create.
        :param 'ApplicationInputProcessingConfiguration' input_processing_configuration: The InputProcessingConfiguration for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is InputLambdaProcessor.
        :param 'ApplicationKinesisFirehoseInput' kinesis_firehose_input: If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
        :param 'ApplicationKinesisStreamsInput' kinesis_streams_input: If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
        """
        pulumi.set(__self__, "input_schema", input_schema)
        pulumi.set(__self__, "name_prefix", name_prefix)
        if input_parallelism is not None:
            pulumi.set(__self__, "input_parallelism", input_parallelism)
        if input_processing_configuration is not None:
            pulumi.set(__self__, "input_processing_configuration", input_processing_configuration)
        if kinesis_firehose_input is not None:
            pulumi.set(__self__, "kinesis_firehose_input", kinesis_firehose_input)
        if kinesis_streams_input is not None:
            pulumi.set(__self__, "kinesis_streams_input", kinesis_streams_input)

    @property
    @pulumi.getter(name="inputSchema")
    def input_schema(self) -> 'outputs.ApplicationInputSchema':
        """
        Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
        """
        return pulumi.get(self, "input_schema")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> str:
        """
        The name prefix to use when creating an in-application stream. Suppose that you specify a prefix `"MyInApplicationStream"`. Kinesis Data Analytics then creates one or more (as per the InputParallelism count you specified) in-application streams with the names `"MyInApplicationStream_001"`, `"MyInApplicationStream_002"`, and so on.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="inputParallelism")
    def input_parallelism(self) -> Optional['outputs.ApplicationInputParallelism']:
        """
        Describes the number of in-application streams to create.
        """
        return pulumi.get(self, "input_parallelism")

    @property
    @pulumi.getter(name="inputProcessingConfiguration")
    def input_processing_configuration(self) -> Optional['outputs.ApplicationInputProcessingConfiguration']:
        """
        The InputProcessingConfiguration for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is InputLambdaProcessor.
        """
        return pulumi.get(self, "input_processing_configuration")

    @property
    @pulumi.getter(name="kinesisFirehoseInput")
    def kinesis_firehose_input(self) -> Optional['outputs.ApplicationKinesisFirehoseInput']:
        """
        If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
        """
        return pulumi.get(self, "kinesis_firehose_input")

    @property
    @pulumi.getter(name="kinesisStreamsInput")
    def kinesis_streams_input(self) -> Optional['outputs.ApplicationKinesisStreamsInput']:
        """
        If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "kinesis_streams_input")


@pulumi.output_type
class ApplicationInputLambdaProcessor(dict):
    """
    An object that contains the Amazon Resource Name (ARN) of the Amazon Lambda function that is used to preprocess records in the stream in a SQL-based Kinesis Data Analytics application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceARN":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInputLambdaProcessor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInputLambdaProcessor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInputLambdaProcessor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_arn: str):
        """
        An object that contains the Amazon Resource Name (ARN) of the Amazon Lambda function that is used to preprocess records in the stream in a SQL-based Kinesis Data Analytics application.
        :param str resource_arn: The ARN of the Amazon Lambda function that operates on records in the stream.
        """
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> str:
        """
        The ARN of the Amazon Lambda function that operates on records in the stream.
        """
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class ApplicationInputParallelism(dict):
    """
    For a SQL-based Kinesis Data Analytics application, describes the number of in-application streams to create for a given streaming source.
    """
    def __init__(__self__, *,
                 count: Optional[int] = None):
        """
        For a SQL-based Kinesis Data Analytics application, describes the number of in-application streams to create for a given streaming source.
        :param int count: The number of in-application streams to create.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The number of in-application streams to create.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class ApplicationInputProcessingConfiguration(dict):
    """
    For an SQL-based Amazon Kinesis Data Analytics application, describes a processor that is used to preprocess the records in the stream before being processed by your application code. Currently, the only input processor available is Amazon Lambda.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputLambdaProcessor":
            suggest = "input_lambda_processor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInputProcessingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInputProcessingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInputProcessingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_lambda_processor: Optional['outputs.ApplicationInputLambdaProcessor'] = None):
        """
        For an SQL-based Amazon Kinesis Data Analytics application, describes a processor that is used to preprocess the records in the stream before being processed by your application code. Currently, the only input processor available is Amazon Lambda.
        :param 'ApplicationInputLambdaProcessor' input_lambda_processor: The InputLambdaProcessor that is used to preprocess the records in the stream before being processed by your application code.
        """
        if input_lambda_processor is not None:
            pulumi.set(__self__, "input_lambda_processor", input_lambda_processor)

    @property
    @pulumi.getter(name="inputLambdaProcessor")
    def input_lambda_processor(self) -> Optional['outputs.ApplicationInputLambdaProcessor']:
        """
        The InputLambdaProcessor that is used to preprocess the records in the stream before being processed by your application code.
        """
        return pulumi.get(self, "input_lambda_processor")


@pulumi.output_type
class ApplicationInputSchema(dict):
    """
    For a SQL-based Kinesis Data Analytics application, describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordColumns":
            suggest = "record_columns"
        elif key == "recordFormat":
            suggest = "record_format"
        elif key == "recordEncoding":
            suggest = "record_encoding"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInputSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInputSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInputSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_columns: Sequence['outputs.ApplicationRecordColumn'],
                 record_format: 'outputs.ApplicationRecordFormat',
                 record_encoding: Optional['ApplicationInputSchemaRecordEncoding'] = None):
        """
        For a SQL-based Kinesis Data Analytics application, describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
        :param Sequence['ApplicationRecordColumn'] record_columns: A list of `RecordColumn` objects.
        :param 'ApplicationRecordFormat' record_format: Specifies the format of the records on the streaming source.
        :param 'ApplicationInputSchemaRecordEncoding' record_encoding: Specifies the encoding of the records in the streaming source. For example, UTF-8.
        """
        pulumi.set(__self__, "record_columns", record_columns)
        pulumi.set(__self__, "record_format", record_format)
        if record_encoding is not None:
            pulumi.set(__self__, "record_encoding", record_encoding)

    @property
    @pulumi.getter(name="recordColumns")
    def record_columns(self) -> Sequence['outputs.ApplicationRecordColumn']:
        """
        A list of `RecordColumn` objects.
        """
        return pulumi.get(self, "record_columns")

    @property
    @pulumi.getter(name="recordFormat")
    def record_format(self) -> 'outputs.ApplicationRecordFormat':
        """
        Specifies the format of the records on the streaming source.
        """
        return pulumi.get(self, "record_format")

    @property
    @pulumi.getter(name="recordEncoding")
    def record_encoding(self) -> Optional['ApplicationInputSchemaRecordEncoding']:
        """
        Specifies the encoding of the records in the streaming source. For example, UTF-8.
        """
        return pulumi.get(self, "record_encoding")


@pulumi.output_type
class ApplicationJSONMappingParameters(dict):
    """
    For a SQL-based Kinesis Data Analytics application, provides additional mapping information when JSON is the record format on the streaming source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordRowPath":
            suggest = "record_row_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationJSONMappingParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationJSONMappingParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationJSONMappingParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_row_path: str):
        """
        For a SQL-based Kinesis Data Analytics application, provides additional mapping information when JSON is the record format on the streaming source.
        :param str record_row_path: The path to the top-level parent that contains the records.
        """
        pulumi.set(__self__, "record_row_path", record_row_path)

    @property
    @pulumi.getter(name="recordRowPath")
    def record_row_path(self) -> str:
        """
        The path to the top-level parent that contains the records.
        """
        return pulumi.get(self, "record_row_path")


@pulumi.output_type
class ApplicationKinesisFirehoseInput(dict):
    """
    For a SQL-based Kinesis Data Analytics application, identifies a Kinesis Data Firehose delivery stream as the streaming source. You provide the delivery stream's Amazon Resource Name (ARN).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceARN":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationKinesisFirehoseInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationKinesisFirehoseInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationKinesisFirehoseInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_arn: str):
        """
        For a SQL-based Kinesis Data Analytics application, identifies a Kinesis Data Firehose delivery stream as the streaming source. You provide the delivery stream's Amazon Resource Name (ARN).
        :param str resource_arn: The Amazon Resource Name (ARN) of the delivery stream.
        """
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the delivery stream.
        """
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class ApplicationKinesisStreamsInput(dict):
    """
    Identifies a Kinesis data stream as the streaming source. You provide the stream's Amazon Resource Name (ARN).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceARN":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationKinesisStreamsInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationKinesisStreamsInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationKinesisStreamsInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_arn: str):
        """
        Identifies a Kinesis data stream as the streaming source. You provide the stream's Amazon Resource Name (ARN).
        :param str resource_arn: The ARN of the input Kinesis data stream to read.
        """
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> str:
        """
        The ARN of the input Kinesis data stream to read.
        """
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class ApplicationMappingParameters(dict):
    """
    When you configure a SQL-based Kinesis Data Analytics application's input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cSVMappingParameters":
            suggest = "c_sv_mapping_parameters"
        elif key == "jSONMappingParameters":
            suggest = "j_son_mapping_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationMappingParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationMappingParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationMappingParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 c_sv_mapping_parameters: Optional['outputs.ApplicationCSVMappingParameters'] = None,
                 j_son_mapping_parameters: Optional['outputs.ApplicationJSONMappingParameters'] = None):
        """
        When you configure a SQL-based Kinesis Data Analytics application's input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
        :param 'ApplicationCSVMappingParameters' c_sv_mapping_parameters: Provides additional mapping information when the record format uses delimiters (for example, CSV).
        :param 'ApplicationJSONMappingParameters' j_son_mapping_parameters: Provides additional mapping information when JSON is the record format on the streaming source.
        """
        if c_sv_mapping_parameters is not None:
            pulumi.set(__self__, "c_sv_mapping_parameters", c_sv_mapping_parameters)
        if j_son_mapping_parameters is not None:
            pulumi.set(__self__, "j_son_mapping_parameters", j_son_mapping_parameters)

    @property
    @pulumi.getter(name="cSVMappingParameters")
    def c_sv_mapping_parameters(self) -> Optional['outputs.ApplicationCSVMappingParameters']:
        """
        Provides additional mapping information when the record format uses delimiters (for example, CSV).
        """
        return pulumi.get(self, "c_sv_mapping_parameters")

    @property
    @pulumi.getter(name="jSONMappingParameters")
    def j_son_mapping_parameters(self) -> Optional['outputs.ApplicationJSONMappingParameters']:
        """
        Provides additional mapping information when JSON is the record format on the streaming source.
        """
        return pulumi.get(self, "j_son_mapping_parameters")


@pulumi.output_type
class ApplicationMavenReference(dict):
    """
    The information required to specify a Maven reference. You can use Maven references to specify dependency JAR files.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"
        elif key == "groupId":
            suggest = "group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationMavenReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationMavenReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationMavenReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 group_id: str,
                 version: str):
        """
        The information required to specify a Maven reference. You can use Maven references to specify dependency JAR files.
        :param str artifact_id: The artifact ID of the Maven reference.
        :param str group_id: The group ID of the Maven reference.
        :param str version: The version of the Maven reference.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The artifact ID of the Maven reference.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The group ID of the Maven reference.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the Maven reference.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ApplicationMonitoringConfiguration(dict):
    """
    Describes configuration parameters for Amazon CloudWatch logging for a Java-based Kinesis Data Analytics application. For more information about CloudWatch logging, see Monitoring.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "logLevel":
            suggest = "log_level"
        elif key == "metricsLevel":
            suggest = "metrics_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationMonitoringConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationMonitoringConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationMonitoringConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: 'ApplicationMonitoringConfigurationConfigurationType',
                 log_level: Optional['ApplicationMonitoringConfigurationLogLevel'] = None,
                 metrics_level: Optional['ApplicationMonitoringConfigurationMetricsLevel'] = None):
        """
        Describes configuration parameters for Amazon CloudWatch logging for a Java-based Kinesis Data Analytics application. For more information about CloudWatch logging, see Monitoring.
        :param 'ApplicationMonitoringConfigurationConfigurationType' configuration_type: Describes whether to use the default CloudWatch logging configuration for an application. You must set this property to CUSTOM in order to set the LogLevel or MetricsLevel parameters.
        :param 'ApplicationMonitoringConfigurationLogLevel' log_level: Describes the verbosity of the CloudWatch Logs for an application.
        :param 'ApplicationMonitoringConfigurationMetricsLevel' metrics_level: Describes the granularity of the CloudWatch Logs for an application. The Parallelism level is not recommended for applications with a Parallelism over 64 due to excessive costs.
        """
        pulumi.set(__self__, "configuration_type", configuration_type)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if metrics_level is not None:
            pulumi.set(__self__, "metrics_level", metrics_level)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> 'ApplicationMonitoringConfigurationConfigurationType':
        """
        Describes whether to use the default CloudWatch logging configuration for an application. You must set this property to CUSTOM in order to set the LogLevel or MetricsLevel parameters.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional['ApplicationMonitoringConfigurationLogLevel']:
        """
        Describes the verbosity of the CloudWatch Logs for an application.
        """
        return pulumi.get(self, "log_level")

    @property
    @pulumi.getter(name="metricsLevel")
    def metrics_level(self) -> Optional['ApplicationMonitoringConfigurationMetricsLevel']:
        """
        Describes the granularity of the CloudWatch Logs for an application. The Parallelism level is not recommended for applications with a Parallelism over 64 due to excessive costs.
        """
        return pulumi.get(self, "metrics_level")


@pulumi.output_type
class ApplicationOutputResourceDestinationSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordFormatType":
            suggest = "record_format_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationOutputResourceDestinationSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationOutputResourceDestinationSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationOutputResourceDestinationSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_format_type: Optional[str] = None):
        if record_format_type is not None:
            pulumi.set(__self__, "record_format_type", record_format_type)

    @property
    @pulumi.getter(name="recordFormatType")
    def record_format_type(self) -> Optional[str]:
        return pulumi.get(self, "record_format_type")


@pulumi.output_type
class ApplicationOutputResourceKinesisFirehoseOutput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceARN":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationOutputResourceKinesisFirehoseOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationOutputResourceKinesisFirehoseOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationOutputResourceKinesisFirehoseOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_arn: str):
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> str:
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class ApplicationOutputResourceKinesisStreamsOutput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceARN":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationOutputResourceKinesisStreamsOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationOutputResourceKinesisStreamsOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationOutputResourceKinesisStreamsOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_arn: str):
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> str:
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class ApplicationOutputResourceLambdaOutput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceARN":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationOutputResourceLambdaOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationOutputResourceLambdaOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationOutputResourceLambdaOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_arn: str):
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> str:
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class ApplicationOutputResourceOutput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationSchema":
            suggest = "destination_schema"
        elif key == "kinesisFirehoseOutput":
            suggest = "kinesis_firehose_output"
        elif key == "kinesisStreamsOutput":
            suggest = "kinesis_streams_output"
        elif key == "lambdaOutput":
            suggest = "lambda_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationOutputResourceOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationOutputResourceOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationOutputResourceOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_schema: 'outputs.ApplicationOutputResourceDestinationSchema',
                 kinesis_firehose_output: Optional['outputs.ApplicationOutputResourceKinesisFirehoseOutput'] = None,
                 kinesis_streams_output: Optional['outputs.ApplicationOutputResourceKinesisStreamsOutput'] = None,
                 lambda_output: Optional['outputs.ApplicationOutputResourceLambdaOutput'] = None,
                 name: Optional[str] = None):
        pulumi.set(__self__, "destination_schema", destination_schema)
        if kinesis_firehose_output is not None:
            pulumi.set(__self__, "kinesis_firehose_output", kinesis_firehose_output)
        if kinesis_streams_output is not None:
            pulumi.set(__self__, "kinesis_streams_output", kinesis_streams_output)
        if lambda_output is not None:
            pulumi.set(__self__, "lambda_output", lambda_output)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="destinationSchema")
    def destination_schema(self) -> 'outputs.ApplicationOutputResourceDestinationSchema':
        return pulumi.get(self, "destination_schema")

    @property
    @pulumi.getter(name="kinesisFirehoseOutput")
    def kinesis_firehose_output(self) -> Optional['outputs.ApplicationOutputResourceKinesisFirehoseOutput']:
        return pulumi.get(self, "kinesis_firehose_output")

    @property
    @pulumi.getter(name="kinesisStreamsOutput")
    def kinesis_streams_output(self) -> Optional['outputs.ApplicationOutputResourceKinesisStreamsOutput']:
        return pulumi.get(self, "kinesis_streams_output")

    @property
    @pulumi.getter(name="lambdaOutput")
    def lambda_output(self) -> Optional['outputs.ApplicationOutputResourceLambdaOutput']:
        return pulumi.get(self, "lambda_output")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class ApplicationParallelismConfiguration(dict):
    """
    Describes parameters for how a Flink-based Kinesis Data Analytics application executes multiple tasks simultaneously. For more information about parallelism, see Parallel Execution in the Apache Flink Documentation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "autoScalingEnabled":
            suggest = "auto_scaling_enabled"
        elif key == "parallelismPerKPU":
            suggest = "parallelism_per_kpu"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationParallelismConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationParallelismConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationParallelismConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: 'ApplicationParallelismConfigurationConfigurationType',
                 auto_scaling_enabled: Optional[bool] = None,
                 parallelism: Optional[int] = None,
                 parallelism_per_kpu: Optional[int] = None):
        """
        Describes parameters for how a Flink-based Kinesis Data Analytics application executes multiple tasks simultaneously. For more information about parallelism, see Parallel Execution in the Apache Flink Documentation
        :param 'ApplicationParallelismConfigurationConfigurationType' configuration_type: Describes whether the application uses the default parallelism for the Kinesis Data Analytics service. You must set this property to `CUSTOM` in order to change your application's `AutoScalingEnabled`, `Parallelism`, or `ParallelismPerKPU` properties.
        :param bool auto_scaling_enabled: Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
        :param int parallelism: Describes the initial number of parallel tasks that a Java-based Kinesis Data Analytics application can perform. The Kinesis Data Analytics service can increase this number automatically if ParallelismConfiguration:AutoScalingEnabled is set to true.
        :param int parallelism_per_kpu: Describes the number of parallel tasks that a Java-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application. For more information about KPUs, see Amazon Kinesis Data Analytics Pricing.
        """
        pulumi.set(__self__, "configuration_type", configuration_type)
        if auto_scaling_enabled is not None:
            pulumi.set(__self__, "auto_scaling_enabled", auto_scaling_enabled)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if parallelism_per_kpu is not None:
            pulumi.set(__self__, "parallelism_per_kpu", parallelism_per_kpu)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> 'ApplicationParallelismConfigurationConfigurationType':
        """
        Describes whether the application uses the default parallelism for the Kinesis Data Analytics service. You must set this property to `CUSTOM` in order to change your application's `AutoScalingEnabled`, `Parallelism`, or `ParallelismPerKPU` properties.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> Optional[bool]:
        """
        Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[int]:
        """
        Describes the initial number of parallel tasks that a Java-based Kinesis Data Analytics application can perform. The Kinesis Data Analytics service can increase this number automatically if ParallelismConfiguration:AutoScalingEnabled is set to true.
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter(name="parallelismPerKPU")
    def parallelism_per_kpu(self) -> Optional[int]:
        """
        Describes the number of parallel tasks that a Java-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application. For more information about KPUs, see Amazon Kinesis Data Analytics Pricing.
        """
        return pulumi.get(self, "parallelism_per_kpu")


@pulumi.output_type
class ApplicationPropertyGroup(dict):
    """
    Property key-value pairs passed into an application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyGroupId":
            suggest = "property_group_id"
        elif key == "propertyMap":
            suggest = "property_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationPropertyGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationPropertyGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationPropertyGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property_group_id: Optional[str] = None,
                 property_map: Optional[Any] = None):
        """
        Property key-value pairs passed into an application.
        :param str property_group_id: Describes the key of an application execution property key-value pair.
        :param Any property_map: Describes the value of an application execution property key-value pair.
        """
        if property_group_id is not None:
            pulumi.set(__self__, "property_group_id", property_group_id)
        if property_map is not None:
            pulumi.set(__self__, "property_map", property_map)

    @property
    @pulumi.getter(name="propertyGroupId")
    def property_group_id(self) -> Optional[str]:
        """
        Describes the key of an application execution property key-value pair.
        """
        return pulumi.get(self, "property_group_id")

    @property
    @pulumi.getter(name="propertyMap")
    def property_map(self) -> Optional[Any]:
        """
        Describes the value of an application execution property key-value pair.
        """
        return pulumi.get(self, "property_map")


@pulumi.output_type
class ApplicationRecordColumn(dict):
    """
    For a SQL-based Kinesis Data Analytics application, describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
    Also used to describe the format of the reference data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlType":
            suggest = "sql_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationRecordColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationRecordColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationRecordColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 sql_type: str,
                 mapping: Optional[str] = None):
        """
        For a SQL-based Kinesis Data Analytics application, describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
        Also used to describe the format of the reference data source.
        :param str name: The name of the column that is created in the in-application input stream or reference table.
        :param str sql_type: The type of column created in the in-application input stream or reference table.
        :param str mapping: A reference to the data element in the streaming input or the reference data source.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sql_type", sql_type)
        if mapping is not None:
            pulumi.set(__self__, "mapping", mapping)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column that is created in the in-application input stream or reference table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sqlType")
    def sql_type(self) -> str:
        """
        The type of column created in the in-application input stream or reference table.
        """
        return pulumi.get(self, "sql_type")

    @property
    @pulumi.getter
    def mapping(self) -> Optional[str]:
        """
        A reference to the data element in the streaming input or the reference data source.
        """
        return pulumi.get(self, "mapping")


@pulumi.output_type
class ApplicationRecordFormat(dict):
    """
    For a SQL-based Kinesis Data Analytics application, describes the record format and relevant mapping information that should be applied to schematize the records on the stream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordFormatType":
            suggest = "record_format_type"
        elif key == "mappingParameters":
            suggest = "mapping_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationRecordFormat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationRecordFormat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationRecordFormat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_format_type: 'ApplicationRecordFormatRecordFormatType',
                 mapping_parameters: Optional['outputs.ApplicationMappingParameters'] = None):
        """
        For a SQL-based Kinesis Data Analytics application, describes the record format and relevant mapping information that should be applied to schematize the records on the stream.
        :param 'ApplicationRecordFormatRecordFormatType' record_format_type: The type of record format.
        :param 'ApplicationMappingParameters' mapping_parameters: When you configure application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
        """
        pulumi.set(__self__, "record_format_type", record_format_type)
        if mapping_parameters is not None:
            pulumi.set(__self__, "mapping_parameters", mapping_parameters)

    @property
    @pulumi.getter(name="recordFormatType")
    def record_format_type(self) -> 'ApplicationRecordFormatRecordFormatType':
        """
        The type of record format.
        """
        return pulumi.get(self, "record_format_type")

    @property
    @pulumi.getter(name="mappingParameters")
    def mapping_parameters(self) -> Optional['outputs.ApplicationMappingParameters']:
        """
        When you configure application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
        """
        return pulumi.get(self, "mapping_parameters")


@pulumi.output_type
class ApplicationReferenceDataSourceCSVMappingParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordColumnDelimiter":
            suggest = "record_column_delimiter"
        elif key == "recordRowDelimiter":
            suggest = "record_row_delimiter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationReferenceDataSourceCSVMappingParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationReferenceDataSourceCSVMappingParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationReferenceDataSourceCSVMappingParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_column_delimiter: str,
                 record_row_delimiter: str):
        pulumi.set(__self__, "record_column_delimiter", record_column_delimiter)
        pulumi.set(__self__, "record_row_delimiter", record_row_delimiter)

    @property
    @pulumi.getter(name="recordColumnDelimiter")
    def record_column_delimiter(self) -> str:
        return pulumi.get(self, "record_column_delimiter")

    @property
    @pulumi.getter(name="recordRowDelimiter")
    def record_row_delimiter(self) -> str:
        return pulumi.get(self, "record_row_delimiter")


@pulumi.output_type
class ApplicationReferenceDataSourceJSONMappingParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordRowPath":
            suggest = "record_row_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationReferenceDataSourceJSONMappingParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationReferenceDataSourceJSONMappingParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationReferenceDataSourceJSONMappingParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_row_path: str):
        pulumi.set(__self__, "record_row_path", record_row_path)

    @property
    @pulumi.getter(name="recordRowPath")
    def record_row_path(self) -> str:
        return pulumi.get(self, "record_row_path")


@pulumi.output_type
class ApplicationReferenceDataSourceMappingParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cSVMappingParameters":
            suggest = "c_sv_mapping_parameters"
        elif key == "jSONMappingParameters":
            suggest = "j_son_mapping_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationReferenceDataSourceMappingParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationReferenceDataSourceMappingParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationReferenceDataSourceMappingParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 c_sv_mapping_parameters: Optional['outputs.ApplicationReferenceDataSourceCSVMappingParameters'] = None,
                 j_son_mapping_parameters: Optional['outputs.ApplicationReferenceDataSourceJSONMappingParameters'] = None):
        if c_sv_mapping_parameters is not None:
            pulumi.set(__self__, "c_sv_mapping_parameters", c_sv_mapping_parameters)
        if j_son_mapping_parameters is not None:
            pulumi.set(__self__, "j_son_mapping_parameters", j_son_mapping_parameters)

    @property
    @pulumi.getter(name="cSVMappingParameters")
    def c_sv_mapping_parameters(self) -> Optional['outputs.ApplicationReferenceDataSourceCSVMappingParameters']:
        return pulumi.get(self, "c_sv_mapping_parameters")

    @property
    @pulumi.getter(name="jSONMappingParameters")
    def j_son_mapping_parameters(self) -> Optional['outputs.ApplicationReferenceDataSourceJSONMappingParameters']:
        return pulumi.get(self, "j_son_mapping_parameters")


@pulumi.output_type
class ApplicationReferenceDataSourceRecordColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlType":
            suggest = "sql_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationReferenceDataSourceRecordColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationReferenceDataSourceRecordColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationReferenceDataSourceRecordColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 sql_type: str,
                 mapping: Optional[str] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sql_type", sql_type)
        if mapping is not None:
            pulumi.set(__self__, "mapping", mapping)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sqlType")
    def sql_type(self) -> str:
        return pulumi.get(self, "sql_type")

    @property
    @pulumi.getter
    def mapping(self) -> Optional[str]:
        return pulumi.get(self, "mapping")


@pulumi.output_type
class ApplicationReferenceDataSourceRecordFormat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordFormatType":
            suggest = "record_format_type"
        elif key == "mappingParameters":
            suggest = "mapping_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationReferenceDataSourceRecordFormat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationReferenceDataSourceRecordFormat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationReferenceDataSourceRecordFormat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_format_type: str,
                 mapping_parameters: Optional['outputs.ApplicationReferenceDataSourceMappingParameters'] = None):
        pulumi.set(__self__, "record_format_type", record_format_type)
        if mapping_parameters is not None:
            pulumi.set(__self__, "mapping_parameters", mapping_parameters)

    @property
    @pulumi.getter(name="recordFormatType")
    def record_format_type(self) -> str:
        return pulumi.get(self, "record_format_type")

    @property
    @pulumi.getter(name="mappingParameters")
    def mapping_parameters(self) -> Optional['outputs.ApplicationReferenceDataSourceMappingParameters']:
        return pulumi.get(self, "mapping_parameters")


@pulumi.output_type
class ApplicationReferenceDataSourceReferenceDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceSchema":
            suggest = "reference_schema"
        elif key == "s3ReferenceDataSource":
            suggest = "s3_reference_data_source"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationReferenceDataSourceReferenceDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationReferenceDataSourceReferenceDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationReferenceDataSourceReferenceDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_schema: 'outputs.ApplicationReferenceDataSourceReferenceSchema',
                 s3_reference_data_source: Optional['outputs.ApplicationReferenceDataSourceS3ReferenceDataSource'] = None,
                 table_name: Optional[str] = None):
        pulumi.set(__self__, "reference_schema", reference_schema)
        if s3_reference_data_source is not None:
            pulumi.set(__self__, "s3_reference_data_source", s3_reference_data_source)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="referenceSchema")
    def reference_schema(self) -> 'outputs.ApplicationReferenceDataSourceReferenceSchema':
        return pulumi.get(self, "reference_schema")

    @property
    @pulumi.getter(name="s3ReferenceDataSource")
    def s3_reference_data_source(self) -> Optional['outputs.ApplicationReferenceDataSourceS3ReferenceDataSource']:
        return pulumi.get(self, "s3_reference_data_source")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[str]:
        return pulumi.get(self, "table_name")


@pulumi.output_type
class ApplicationReferenceDataSourceReferenceSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordColumns":
            suggest = "record_columns"
        elif key == "recordFormat":
            suggest = "record_format"
        elif key == "recordEncoding":
            suggest = "record_encoding"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationReferenceDataSourceReferenceSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationReferenceDataSourceReferenceSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationReferenceDataSourceReferenceSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_columns: Sequence['outputs.ApplicationReferenceDataSourceRecordColumn'],
                 record_format: 'outputs.ApplicationReferenceDataSourceRecordFormat',
                 record_encoding: Optional[str] = None):
        pulumi.set(__self__, "record_columns", record_columns)
        pulumi.set(__self__, "record_format", record_format)
        if record_encoding is not None:
            pulumi.set(__self__, "record_encoding", record_encoding)

    @property
    @pulumi.getter(name="recordColumns")
    def record_columns(self) -> Sequence['outputs.ApplicationReferenceDataSourceRecordColumn']:
        return pulumi.get(self, "record_columns")

    @property
    @pulumi.getter(name="recordFormat")
    def record_format(self) -> 'outputs.ApplicationReferenceDataSourceRecordFormat':
        return pulumi.get(self, "record_format")

    @property
    @pulumi.getter(name="recordEncoding")
    def record_encoding(self) -> Optional[str]:
        return pulumi.get(self, "record_encoding")


@pulumi.output_type
class ApplicationReferenceDataSourceS3ReferenceDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketARN":
            suggest = "bucket_arn"
        elif key == "fileKey":
            suggest = "file_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationReferenceDataSourceS3ReferenceDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationReferenceDataSourceS3ReferenceDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationReferenceDataSourceS3ReferenceDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 file_key: str):
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "file_key", file_key)

    @property
    @pulumi.getter(name="bucketARN")
    def bucket_arn(self) -> str:
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter(name="fileKey")
    def file_key(self) -> str:
        return pulumi.get(self, "file_key")


@pulumi.output_type
class ApplicationS3ContentBaseLocation(dict):
    """
    The base location of the Amazon Data Analytics application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketARN":
            suggest = "bucket_arn"
        elif key == "basePath":
            suggest = "base_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationS3ContentBaseLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationS3ContentBaseLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationS3ContentBaseLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 base_path: Optional[str] = None):
        """
        The base location of the Amazon Data Analytics application.
        :param str bucket_arn: The Amazon Resource Name (ARN) of the S3 bucket.
        :param str base_path: The base path for the S3 bucket.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)

    @property
    @pulumi.getter(name="bucketARN")
    def bucket_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the S3 bucket.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[str]:
        """
        The base path for the S3 bucket.
        """
        return pulumi.get(self, "base_path")


@pulumi.output_type
class ApplicationS3ContentLocation(dict):
    """
    The location of an application or a custom artifact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketARN":
            suggest = "bucket_arn"
        elif key == "fileKey":
            suggest = "file_key"
        elif key == "objectVersion":
            suggest = "object_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationS3ContentLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationS3ContentLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationS3ContentLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 file_key: str,
                 object_version: Optional[str] = None):
        """
        The location of an application or a custom artifact.
        :param str bucket_arn: The Amazon Resource Name (ARN) for the S3 bucket containing the application code.
        :param str file_key: The file key for the object containing the application code.
        :param str object_version: The version of the object containing the application code.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "file_key", file_key)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter(name="bucketARN")
    def bucket_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) for the S3 bucket containing the application code.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter(name="fileKey")
    def file_key(self) -> str:
        """
        The file key for the object containing the application code.
        """
        return pulumi.get(self, "file_key")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[str]:
        """
        The version of the object containing the application code.
        """
        return pulumi.get(self, "object_version")


@pulumi.output_type
class ApplicationSnapshotConfiguration(dict):
    """
    Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsEnabled":
            suggest = "snapshots_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationSnapshotConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationSnapshotConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationSnapshotConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_enabled: bool):
        """
        Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
        :param bool snapshots_enabled: Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
        """
        pulumi.set(__self__, "snapshots_enabled", snapshots_enabled)

    @property
    @pulumi.getter(name="snapshotsEnabled")
    def snapshots_enabled(self) -> bool:
        """
        Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
        """
        return pulumi.get(self, "snapshots_enabled")


@pulumi.output_type
class ApplicationSqlApplicationConfiguration(dict):
    """
    Describes the inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics application.
    """
    def __init__(__self__, *,
                 inputs: Optional[Sequence['outputs.ApplicationInput']] = None):
        """
        Describes the inputs, outputs, and reference data sources for a SQL-based Kinesis Data Analytics application.
        :param Sequence['ApplicationInput'] inputs: The array of Input objects describing the input streams used by the application.
        """
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence['outputs.ApplicationInput']]:
        """
        The array of Input objects describing the input streams used by the application.
        """
        return pulumi.get(self, "inputs")


@pulumi.output_type
class ApplicationTag(dict):
    """
    A key-value pair that identifies an application.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair that identifies an application.
        :param str key: The key name of the tag. You can specify a value that's 1 to 128 Unicode characters in length and can't be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that's 0 to 256 characters in length.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that's 1 to 128 Unicode characters in length and can't be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that's 0 to 256 characters in length.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApplicationZeppelinApplicationConfiguration(dict):
    """
    The configuration of a Kinesis Data Analytics Studio notebook.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogConfiguration":
            suggest = "catalog_configuration"
        elif key == "customArtifactsConfiguration":
            suggest = "custom_artifacts_configuration"
        elif key == "deployAsApplicationConfiguration":
            suggest = "deploy_as_application_configuration"
        elif key == "monitoringConfiguration":
            suggest = "monitoring_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationZeppelinApplicationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationZeppelinApplicationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationZeppelinApplicationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_configuration: Optional['outputs.ApplicationCatalogConfiguration'] = None,
                 custom_artifacts_configuration: Optional[Sequence['outputs.ApplicationCustomArtifactConfiguration']] = None,
                 deploy_as_application_configuration: Optional['outputs.ApplicationDeployAsApplicationConfiguration'] = None,
                 monitoring_configuration: Optional['outputs.ApplicationZeppelinMonitoringConfiguration'] = None):
        """
        The configuration of a Kinesis Data Analytics Studio notebook.
        :param 'ApplicationCatalogConfiguration' catalog_configuration: The Amazon Glue Data Catalog that you use in queries in a Kinesis Data Analytics Studio notebook.
        :param Sequence['ApplicationCustomArtifactConfiguration'] custom_artifacts_configuration: A list of CustomArtifactConfiguration objects.
        :param 'ApplicationDeployAsApplicationConfiguration' deploy_as_application_configuration: The information required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
        :param 'ApplicationZeppelinMonitoringConfiguration' monitoring_configuration: The monitoring configuration of a Kinesis Data Analytics Studio notebook.
        """
        if catalog_configuration is not None:
            pulumi.set(__self__, "catalog_configuration", catalog_configuration)
        if custom_artifacts_configuration is not None:
            pulumi.set(__self__, "custom_artifacts_configuration", custom_artifacts_configuration)
        if deploy_as_application_configuration is not None:
            pulumi.set(__self__, "deploy_as_application_configuration", deploy_as_application_configuration)
        if monitoring_configuration is not None:
            pulumi.set(__self__, "monitoring_configuration", monitoring_configuration)

    @property
    @pulumi.getter(name="catalogConfiguration")
    def catalog_configuration(self) -> Optional['outputs.ApplicationCatalogConfiguration']:
        """
        The Amazon Glue Data Catalog that you use in queries in a Kinesis Data Analytics Studio notebook.
        """
        return pulumi.get(self, "catalog_configuration")

    @property
    @pulumi.getter(name="customArtifactsConfiguration")
    def custom_artifacts_configuration(self) -> Optional[Sequence['outputs.ApplicationCustomArtifactConfiguration']]:
        """
        A list of CustomArtifactConfiguration objects.
        """
        return pulumi.get(self, "custom_artifacts_configuration")

    @property
    @pulumi.getter(name="deployAsApplicationConfiguration")
    def deploy_as_application_configuration(self) -> Optional['outputs.ApplicationDeployAsApplicationConfiguration']:
        """
        The information required to deploy a Kinesis Data Analytics Studio notebook as an application with durable state.
        """
        return pulumi.get(self, "deploy_as_application_configuration")

    @property
    @pulumi.getter(name="monitoringConfiguration")
    def monitoring_configuration(self) -> Optional['outputs.ApplicationZeppelinMonitoringConfiguration']:
        """
        The monitoring configuration of a Kinesis Data Analytics Studio notebook.
        """
        return pulumi.get(self, "monitoring_configuration")


@pulumi.output_type
class ApplicationZeppelinMonitoringConfiguration(dict):
    """
    Describes configuration parameters for Amazon CloudWatch logging for a Kinesis Data Analytics Studio notebook. For more information about CloudWatch logging, see Monitoring.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logLevel":
            suggest = "log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationZeppelinMonitoringConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationZeppelinMonitoringConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationZeppelinMonitoringConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_level: Optional['ApplicationZeppelinMonitoringConfigurationLogLevel'] = None):
        """
        Describes configuration parameters for Amazon CloudWatch logging for a Kinesis Data Analytics Studio notebook. For more information about CloudWatch logging, see Monitoring.
        :param 'ApplicationZeppelinMonitoringConfigurationLogLevel' log_level: The verbosity of the CloudWatch Logs for an application. You can set it to `INFO`, `WARN`, `ERROR`, or `DEBUG`.
        """
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional['ApplicationZeppelinMonitoringConfigurationLogLevel']:
        """
        The verbosity of the CloudWatch Logs for an application. You can set it to `INFO`, `WARN`, `ERROR`, or `DEBUG`.
        """
        return pulumi.get(self, "log_level")


