'''
syscall calling conventions:
    x86-32 Linux System Call convention:
    In x86-32 parameters for linux system call are passed using registers. %eax for syscall_number %ebx, %ecx, %edx, %esi, %edi, %ebp are used for passing 6 parameters to system calls. 
    I took fllowing snippet from http://www.cin.ufpe.br/~if817/arquivos/asmtut/index.html#syscalls but I'm doubtful about this. If any one can show an example. It would be great.
    If there are more than six arguments, %ebx must contain the memory location where the list of arguments is stored - but don't worry about this because it's unlikely that you'll use a syscall with more than six arguments.
    for example and little more reading, refer to http://www.int80h.org/bsdasm/#alternate-calling-convention

    x86-64 Linux & DragonFly BSD System Call convention:
    refer to section: "A.2 AMD64 Linux Kernel Conventions" of System V Application Binary Interface AMD64 Architecture Processor Supplement
    Here is the snippet from this section:
        User-level applications use as integer registers for passing the sequence %rdi, %rsi, %rdx, %rcx, %r8 and %r9. The kernel interface uses %rdi, %rsi, %rdx, %r10, %r8 and %r9.
        A system-call is done via the syscall instruction. The kernel destroys registers %rcx and %r11.
        The number of the syscall has to be passed in register %rax.
        System-calls are limited to six arguments, no argument is passed directly on the stack.
        Returning from the syscall, register %rax contains the result of the system-call. A value in the range between -4095 and -1 indicates an error, it is -errno.
        Only values of class INTEGER or class MEMORY are passed to the kernel.
'''

x86_32={
	"__NR_restart_syscall":0,
	"__NR_exit":1,
	"__NR_fork":2,
	"__NR_read":3,
	"__NR_write":4,
	"__NR_open":5,
	"__NR_close":6,
	"__NR_waitpid":7,
	"__NR_creat":8,
	"__NR_link":9,
	"__NR_unlink":10,
	"__NR_execve":11,
	"__NR_chdir":12,
	"__NR_time":13,
	"__NR_mknod":14,
	"__NR_chmod":15,
	"__NR_lchown":16,
	"__NR_break":17,
	"__NR_oldstat":18,
	"__NR_lseek":19,
	"__NR_getpid":20,
	"__NR_mount":21,
	"__NR_umount":22,
	"__NR_setuid":23,
	"__NR_getuid":24,
	"__NR_stime":25,
	"__NR_ptrace":26,
	"__NR_alarm":27,
	"__NR_oldfstat":28,
	"__NR_pause":29,
	"__NR_utime":30,
	"__NR_stty":31,
	"__NR_gtty":32,
	"__NR_access":33,
	"__NR_nice":34,
	"__NR_ftime":35,
	"__NR_sync":36,
	"__NR_kill":37,
	"__NR_rename":38,
	"__NR_mkdir":39,
	"__NR_rmdir":40,
	"__NR_dup":41,
	"__NR_pipe":42,
	"__NR_times":43,
	"__NR_prof":44,
	"__NR_brk":45,
	"__NR_setgid":46,
	"__NR_getgid":47,
	"__NR_signal":48,
	"__NR_geteuid":49,
	"__NR_getegid":50,
	"__NR_acct":51,
	"__NR_umount2":52,
	"__NR_lock":53,
	"__NR_ioctl":54,
	"__NR_fcntl":55,
	"__NR_mpx":56,
	"__NR_setpgid":57,
	"__NR_ulimit":58,
	"__NR_oldolduname":59,
	"__NR_umask":60,
	"__NR_chroot":61,
	"__NR_ustat":62,
	"__NR_dup2":63,
	"__NR_getppid":64,
	"__NR_getpgrp":65,
	"__NR_setsid":66,
	"__NR_sigaction":67,
	"__NR_sgetmask":68,
	"__NR_ssetmask":69,
	"__NR_setreuid":70,
	"__NR_setregid":71,
	"__NR_sigsuspend":72,
	"__NR_sigpending":73,
	"__NR_sethostname":74,
	"__NR_setrlimit":75,
	"__NR_getrlimit":76,#Backcompatible2Giglimitedrlimit*/,
	"__NR_getrusage":77,
	"__NR_gettimeofday":78,
	"__NR_settimeofday":79,
	"__NR_getgroups":80,
	"__NR_setgroups":81,
	"__NR_select":82,
	"__NR_symlink":83,
	"__NR_oldlstat":84,
	"__NR_readlink":85,
	"__NR_uselib":86,
	"__NR_swapon":87,
	"__NR_reboot":88,
	"__NR_readdir":89,
	"__NR_mmap":90,
	"__NR_munmap":91,
	"__NR_truncate":92,
	"__NR_ftruncate":93,
	"__NR_fchmod":94,
	"__NR_fchown":95,
	"__NR_getpriority":96,
	"__NR_setpriority":97,
	"__NR_profil":98,
	"__NR_statfs":99,
	"__NR_fstatfs":100,
	"__NR_ioperm":101,
	"__NR_socketcall":102,
	"__NR_syslog":103,
	"__NR_setitimer":104,
	"__NR_getitimer":105,
	"__NR_stat":106,
	"__NR_lstat":107,
	"__NR_fstat":108,
	"__NR_olduname":109,
	"__NR_iopl":110,
	"__NR_vhangup":111,
	"__NR_idle":112,
	"__NR_vm86old":113,
	"__NR_wait4":114,
	"__NR_swapoff":115,
	"__NR_sysinfo":116,
	"__NR_ipc":117,
	"__NR_fsync":118,
	"__NR_sigreturn":119,
	"__NR_clone":120,
	"__NR_setdomainname":121,
	"__NR_uname":122,
	"__NR_modify_ldt":123,
	"__NR_adjtimex":124,
	"__NR_mprotect":125,
	"__NR_sigprocmask":126,
	"__NR_create_module":127,
	"__NR_init_module":128,
	"__NR_delete_module":129,
	"__NR_get_kernel_syms":130,
	"__NR_quotactl":131,
	"__NR_getpgid":132,
	"__NR_fchdir":133,
	"__NR_bdflush":134,
	"__NR_sysfs":135,
	"__NR_personality":136,
	"__NR_afs_syscall":137,#SyscallforAndrewFileSystem*/,
	"__NR_setfsuid":138,
	"__NR_setfsgid":139,
	"__NR__llseek":140,
	"__NR_getdents":141,
	"__NR__newselect":142,
	"__NR_flock":143,
	"__NR_msync":144,
	"__NR_readv":145,
	"__NR_writev":146,
	"__NR_getsid":147,
	"__NR_fdatasync":148,
	"__NR__sysctl":149,
	"__NR_mlock":150,
	"__NR_munlock":151,
	"__NR_mlockall":152,
	"__NR_munlockall":153,
	"__NR_sched_setparam":154,
	"__NR_sched_getparam":155,
	"__NR_sched_setscheduler":156,
	"__NR_sched_getscheduler":157,
	"__NR_sched_yield":158,
	"__NR_sched_get_priority_max":159,
	"__NR_sched_get_priority_min":160,
	"__NR_sched_rr_get_interval":161,
	"__NR_nanosleep":162,
	"__NR_mremap":163,
	"__NR_setresuid":164,
	"__NR_getresuid":165,
	"__NR_vm86":166,
	"__NR_query_module":167,
	"__NR_poll":168,
	"__NR_nfsservctl":169,
	"__NR_setresgid":170,
	"__NR_getresgid":171,
	"__NR_prctl":172,
	"__NR_rt_sigreturn":173,
	"__NR_rt_sigaction":174,
	"__NR_rt_sigprocmask":175,
	"__NR_rt_sigpending":176,
	"__NR_rt_sigtimedwait":177,
	"__NR_rt_sigqueueinfo":178,
	"__NR_rt_sigsuspend":179,
	"__NR_pread64":180,
	"__NR_pwrite64":181,
	"__NR_chown":182,
	"__NR_getcwd":183,
	"__NR_capget":184,
	"__NR_capset":185,
	"__NR_sigaltstack":186,
	"__NR_sendfile":187,
	"__NR_getpmsg":188,#somepeopleactuallywantstreams*/,
	"__NR_putpmsg":189,#somepeopleactuallywantstreams*/,
	"__NR_vfork":190,
	"__NR_ugetrlimit":191,#SuScompliantgetrlimit*/,
	"__NR_mmap2":192,
	"__NR_truncate64":193,
	"__NR_ftruncate64":194,
	"__NR_stat64":195,
	"__NR_lstat64":196,
	"__NR_fstat64":197,
	"__NR_lchown32":198,
	"__NR_getuid32":199,
	"__NR_getgid32":200,
	"__NR_geteuid32":201,
	"__NR_getegid32":202,
	"__NR_setreuid32":203,
	"__NR_setregid32":204,
	"__NR_getgroups32":205,
	"__NR_setgroups32":206,
	"__NR_fchown32":207,
	"__NR_setresuid32":208,
	"__NR_getresuid32":209,
	"__NR_setresgid32":210,
	"__NR_getresgid32":211,
	"__NR_chown32":212,
	"__NR_setuid32":213,
	"__NR_setgid32":214,
	"__NR_setfsuid32":215,
	"__NR_setfsgid32":216,
	"__NR_pivot_root":217,
	"__NR_mincore":218,
	"__NR_madvise":219,
	"__NR_madvise1":219,#deletewhenClibstubisremoved*/,
	"__NR_getdents64":220,
	"__NR_fcntl64":221,
#":223isunused*/,
	"__NR_gettid":224,
	"__NR_readahead":225,
	"__NR_setxattr":226,
	"__NR_lsetxattr":227,
	"__NR_fsetxattr":228,
	"__NR_getxattr":229,
	"__NR_lgetxattr":230,
	"__NR_fgetxattr":231,
	"__NR_listxattr":232,
	"__NR_llistxattr":233,
	"__NR_flistxattr":234,
	"__NR_removexattr":235,
	"__NR_lremovexattr":236,
	"__NR_fremovexattr":237,
	"__NR_tkill":238,
	"__NR_sendfile64":239,
	"__NR_futex":240,
	"__NR_sched_setaffinity":241,
	"__NR_sched_getaffinity":242,
	"__NR_set_thread_area":243,
	"__NR_get_thread_area":244,
	"__NR_io_setup":245,
	"__NR_io_destroy":246,
	"__NR_io_getevents":247,
	"__NR_io_submit":248,
	"__NR_io_cancel":249,
	"__NR_fadvise64":250,
#":251isavailableforreuse(wasbrieflysys_set_zone_reclaim)*/,
	"__NR_exit_group":252,
	"__NR_lookup_dcookie":253,
	"__NR_epoll_create":254,
	"__NR_epoll_ctl":255,
	"__NR_epoll_wait":256,
	"__NR_remap_file_pages":257,
	"__NR_set_tid_address":258,
	"__NR_timer_create":259,
	"__NR_timer_settime":260,
	"__NR_timer_gettime":261,
	"__NR_timer_getoverrun":262,
	"__NR_timer_delete":263,
	"__NR_clock_settime":264,
	"__NR_clock_gettime":265,
	"__NR_clock_getres":266,
	"__NR_clock_nanosleep":267,
	"__NR_statfs64":268,
	"__NR_fstatfs64":269,
	"__NR_tgkill":270,
	"__NR_utimes":271,
	"__NR_fadvise64_64":272,
	"__NR_vserver":273,
	"__NR_mbind":274,
	"__NR_get_mempolicy":275,
	"__NR_set_mempolicy":276,
	"__NR_mq_open":277,
	"__NR_mq_unlink":278,
	"__NR_mq_timedsend":279,
	"__NR_mq_timedreceive":280,
	"__NR_mq_notify":281,
	"__NR_mq_getsetattr":282,
	"__NR_kexec_load":283,
	"__NR_waitid":284,
#":define"__NR_sys_setaltroot285*/,
	"__NR_add_key":286,
	"__NR_request_key":287,
	"__NR_keyctl":288,
	"__NR_ioprio_set":289,
	"__NR_ioprio_get":290,
	"__NR_inotify_init":291,
	"__NR_inotify_add_watch":292,
	"__NR_inotify_rm_watch":293,
	"__NR_migrate_pages":294,
	"__NR_openat":295,
	"__NR_mkdirat":296,
	"__NR_mknodat":297,
	"__NR_fchownat":298,
	"__NR_futimesat":299,
	"__NR_fstatat64":300,
	"__NR_unlinkat":301,
	"__NR_renameat":302,
	"__NR_linkat":303,
	"__NR_symlinkat":304,
	"__NR_readlinkat":305,
	"__NR_fchmodat":306,
	"__NR_faccessat":307,
	"__NR_pselect6":308,
	"__NR_ppoll":309,
	"__NR_unshare":310,
	"__NR_set_robust_list":311,
	"__NR_get_robust_list":312,
	"__NR_splice":313,
	"__NR_sync_file_range":314,
	"__NR_tee":315,
	"__NR_vmsplice":316,
	"__NR_move_pages":317,
	"__NR_getcpu":318,
	"__NR_epoll_pwait":319,
	"__NR_utimensat":320,
	"__NR_signalfd":321,
	"__NR_timerfd_create":322,
	"__NR_eventfd":323,
	"__NR_fallocate":324,
	"__NR_timerfd_settime":325,
	"__NR_timerfd_gettime":326,
	"__NR_signalfd4":327,
	"__NR_eventfd2":328,
	"__NR_epoll_create1":329,
	"__NR_dup3":330,
	"__NR_pipe2":331,
	"__NR_inotify_init1":332,
	"__NR_preadv":333,
	"__NR_pwritev":334,
	"__NR_rt_tgsigqueueinfo":335,
	"__NR_perf_counter_open":336,
}


x86_64={
	"__NR_read":0,
	"__NR_write":1,
	"__NR_open":2,
	"__NR_close":3,
	"__NR_stat":4,
	"__NR_fstat":5,
	"__NR_lstat":6,
	"__NR_poll":7,
	"__NR_lseek":8,
	"__NR_mmap":9,
	"__NR_mprotect":10,
	"__NR_munmap":11,
	"__NR_brk":12,
	"__NR_rt_sigaction":13,
	"__NR_rt_sigprocmask":14,
	"__NR_rt_sigreturn":15,
	"__NR_ioctl":16,
	"__NR_pread64":17,
	"__NR_pwrite64":18,
	"__NR_readv":19,
	"__NR_writev":20,
	"__NR_access":21,
	"__NR_pipe":22,
	"__NR_select":23,
	"__NR_sched_yield":24,
	"__NR_mremap":25,
	"__NR_msync":26,
	"__NR_mincore":27,
	"__NR_madvise":28,
	"__NR_shmget":29,
	"__NR_shmat":30,
	"__NR_shmctl":31,
	"__NR_dup":32,
	"__NR_dup2":33,
	"__NR_pause":34,
	"__NR_nanosleep":35,
	"__NR_getitimer":36,
	"__NR_alarm":37,
	"__NR_setitimer":38,
	"__NR_getpid":39,
	"__NR_sendfile":40,
	"__NR_socket":41,
	"__NR_connect":42,
	"__NR_accept":43,
	"__NR_sendto":44,
	"__NR_recvfrom":45,
	"__NR_sendmsg":46,
	"__NR_recvmsg":47,
	"__NR_shutdown":48,
	"__NR_bind":49,
	"__NR_listen":50,
	"__NR_getsockname":51,
	"__NR_getpeername":52,
	"__NR_socketpair":53,
	"__NR_setsockopt":54,
	"__NR_getsockopt":55,
	"__NR_clone":56,
	"__NR_fork":57,
	"__NR_vfork":58,
	"__NR_execve":59,
	"__NR_exit":60,
	"__NR_wait4":61,
	"__NR_kill":62,
	"__NR_uname":63,
	"__NR_semget":64,
	"__NR_semop":65,
	"__NR_semctl":66,
	"__NR_shmdt":67,
	"__NR_msgget":68,
	"__NR_msgsnd":69,
	"__NR_msgrcv":70,
	"__NR_msgctl":71,
	"__NR_fcntl":72,
	"__NR_flock":73,
	"__NR_fsync":74,
	"__NR_fdatasync":75,
	"__NR_truncate":76,
	"__NR_ftruncate":77,
	"__NR_getdents":78,
	"__NR_getcwd":79,
	"__NR_chdir":80,
	"__NR_fchdir":81,
	"__NR_rename":82,
	"__NR_mkdir":83,
	"__NR_rmdir":84,
	"__NR_creat":85,
	"__NR_link":86,
	"__NR_unlink":87,
	"__NR_symlink":88,
	"__NR_readlink":89,
	"__NR_chmod":90,
	"__NR_fchmod":91,
	"__NR_chown":92,
	"__NR_fchown":93,
	"__NR_lchown":94,
	"__NR_umask":95,
	"__NR_gettimeofday":96,
	"__NR_getrlimit":97,
	"__NR_getrusage":98,
	"__NR_sysinfo":99,
	"__NR_times":100,
	"__NR_ptrace":101,
	"__NR_getuid":102,
	"__NR_syslog":103,
#":attheveryendthestuffthatneverrunsduringthebenchmarks*/,
	"__NR_getgid":104,
	"__NR_setuid":105,
	"__NR_setgid":106,
	"__NR_geteuid":107,
	"__NR_getegid":108,
	"__NR_setpgid":109,
	"__NR_getppid":110,
	"__NR_getpgrp":111,
	"__NR_setsid":112,
	"__NR_setreuid":113,
	"__NR_setregid":114,
	"__NR_getgroups":115,
	"__NR_setgroups":116,
	"__NR_setresuid":117,
	"__NR_getresuid":118,
	"__NR_setresgid":119,
	"__NR_getresgid":120,
	"__NR_getpgid":121,
    "__NR_setfsuid":122,
    "__NR_setfsgid":123,
    "__NR_getsid":124,
    "__NR_capget":125,
    "__NR_capset":126,
    "__NR_rt_sigpending":127,
	"__NR_rt_sigtimedwait":128,
	"__NR_rt_sigqueueinfo":129,
	"__NR_rt_sigsuspend":130,
	"__NR_sigaltstack":131,
	"__NR_utime":132,
	"__NR_mknod":133,
#":Onlyneededfora.out*/,
	"__NR_uselib":134,
	"__NR_personality":135,
	"__NR_ustat":136,
	"__NR_statfs":137,
	"__NR_fstatfs":138,
	"__NR_sysfs":139,
	"__NR_getpriority":140,
	"__NR_setpriority":141,
	"__NR_sched_setparam":142,
	"__NR_sched_getparam":143,
	"__NR_sched_setscheduler":144,
	"__NR_sched_getscheduler":145,
	"__NR_sched_get_priority_max":146,
	"__NR_sched_get_priority_min":147,
	"__NR_sched_rr_get_interval":148,
	"__NR_mlock":149,
	"__NR_munlock":150,
	"__NR_mlockall":151,
	"__NR_munlockall":152,
	"__NR_vhangup":153,
	"__NR_modify_ldt":154,
	"__NR_pivot_root":155,
	"__NR__sysctl":156,
	"__NR_prctl":157,
	"__NR_arch_prctl":158,
	"__NR_adjtimex":159,
	"__NR_setrlimit":160,
	"__NR_chroot":161,
	"__NR_sync":162,
	"__NR_acct":163,
	"__NR_settimeofday":164,
	"__NR_mount":165,
	"__NR_umount2":166,
	"__NR_swapon":167,
	"__NR_swapoff":168,
	"__NR_reboot":169,
	"__NR_sethostname":170,
	"__NR_setdomainname":171,
	"__NR_iopl":172,
	"__NR_ioperm":173,
	"__NR_create_module":174,
	"__NR_init_module":175,
	"__NR_delete_module":176,
	"__NR_get_kernel_syms":177,
	"__NR_query_module":178,
	"__NR_quotactl":179,
	"__NR_nfsservctl":180,
#":reservedforLiS/STREAMS*/,
	"__NR_getpmsg":181,
	"__NR_putpmsg":182,
#":reservedforAFS*/,
	"__NR_afs_syscall":183,
#":reservedfortux*/,
	"__NR_tuxcall":184,
	"__NR_security":185,
	"__NR_gettid":186,
	"__NR_readahead":187,
	"__NR_setxattr":188,
	"__NR_lsetxattr":189,
	"__NR_fsetxattr":190,
	"__NR_getxattr":191,
	"__NR_lgetxattr":192,
	"__NR_fgetxattr":193,
	"__NR_listxattr":194,
	"__NR_llistxattr":195,
	"__NR_flistxattr":196,
	"__NR_removexattr":197,
	"__NR_lremovexattr":198,
	"__NR_fremovexattr":199,
	"__NR_tkill":200,
	"__NR_time":201,
	"__NR_futex":202,
	"__NR_sched_setaffinity":203,
	"__NR_sched_getaffinity":204,
	"__NR_set_thread_area":205,
	"__NR_io_setup":206,
	"__NR_io_destroy":207,
	"__NR_io_getevents":208,
	"__NR_io_submit":209,
	"__NR_io_cancel":210,
	"__NR_get_thread_area":211,
	"__NR_lookup_dcookie":212,
	"__NR_splice":275,
	"__NR_tee":276,
	"__NR_sync_file_range":277,
	"__NR_vmsplice":278,
	"__NR_move_pages":279,
	"__NR_utimensat":280,
	"__NR_epoll_pwait":281,
	"__NR_signalfd":282,
	"__NR_timerfd_create":283,
	"__NR_eventfd":284,
	"__NR_fallocate":285,
	"__NR_timerfd_settime":286,
	"__NR_timerfd_gettime":287,
	"__NR_accept4":288,
	"__NR_signalfd4":289,
	"__NR_eventfd2":290,
	"__NR_epoll_create1":291,
	"__NR_dup3":292,
	"__NR_pipe2":293,
	"__NR_inotify_init1":294,
	"__NR_preadv":295,
	"__NR_pwritev":296,
	"__NR_rt_tgsigqueueinfo":297,
	"__NR_perf_counter_open":298,
}
