# Clone GitHub and Deploy to Vercel
2023-04-05 Bowen Chiu
此專案的用途是複製一個 GitHub repository，並將其部署到 Vercel 上。

## pip install 使用方法

此套件用於複製一個 GitHub repository，以及發布到 Vercel

### 安裝

```
python -m pip install vercel-deploy
```

### git_clone 使用方法

```python
import git_clone

source_url = "https://github.com/source_user/source_repo.git"
target_name = "new_repo_name"

git_clone.main(source_url, target_name)
```

- `source_url`：來源 repository 的 URL。
- `target_name`：新 repository 的名稱。

程式會使用 `.env` 檔案內的 `GITHUB_ACCESS_TOKEN` 登入 GitHub，然後將 `source_url` repository 的內容複製到一個新的 repository，並命名為 `target_name`。

## 使用 vercel_deploy 套件

此套件用於將一個 GitHub repository 部署到 Vercel 上。

### 安裝

```
python -m pip install vercel_deploy
```

### vercel_deploy 使用方法

```python
import vercel_deploy

github_repo_url = "https://github.com/user/repo.git"
vercel_project_name = "my-vercel-project"
vercel_team_id = "team_id"

vercel_deploy.main(github_repo_url, vercel_project_name, vercel_team_id)
```

- `github_repo_url`：要部署的 repository 的 URL。
- `vercel_project_name`：Vercel 的專案名稱。
- `vercel_team_id`：Vercel 的 Team ID（如果是個人專案，則不需要此參數）。

程式會使用 `.env` 檔案內的 `GITHUB_ACCESS_TOKEN` 和 `VERCEL_ACCESS_TOKEN` 登入 GitHub 和 Vercel，然後創建一個新的 Vercel 專案，並將 `github_repo_url` repository 的內容部署到此專案上。

## 此套件的原始程式碼在 github source code 的使用方法

1. 設定環境變數
   - 在專案根目錄下建立一個名為 `.env` 的檔案
   - 在檔案內加入以下內容：

   ```
   GITHUB_ACCESS_TOKEN=<your-github-access-token>
   VERCEL_ACCESS_TOKEN=<your-vercel-access-token>
   ```

   - `GITHUB_ACCESS_TOKEN` 是一個 [Personal Access Token](https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token)，需要有讀取權限。
   - `VERCEL_ACCESS_TOKEN` 是一個 [Vercel Access Token](https://vercel.com/account/tokens)，需要有部署權限。

2. Clone GitHub repository
   - 執行以下指令複製一個 GitHub repository：

   ```
   $ sh go_github.sh
   ```

   - `go_github.sh` 是一個 shell script，會呼叫 `git_clone.py`。

3. Deploy to Vercel
   - 執行以下指令將 GitHub repository 部署到 Vercel：

   ```
   $ sh go_vercel.sh
   ```

   - `go_vercel.sh` 是一個 shell script，會呼叫 `vercel_deploy.py`。

## 執行預期結果

執行 `go_github.sh` 後，會在 GitHub 上複製一份 repository。

執行 `go_vercel.sh` 後，會將剛才複製的 repository 部署到 Vercel 上。

## 重要 .py 檔案列表、用途、程式說明

### git_clone.py

此檔案會複製一個 GitHub repository。

使用方式：

```
python git_clone.py <source_url> <target_name>
```

- `source_url`：來源 repository 的 URL。
- `target_name`：新 repository 的名稱。

程式會使用 `.env` 檔案內的 `GITHUB_ACCESS_TOKEN` 登入 GitHub，然後將 `source_url` repository 的內容複製到一個新的 repository，並命名為 `target_name`。

### vercel_deploy.py

此檔案會將一個 GitHub repository 部署到 Vercel 上。

使用方式：

```
python vercel_deploy.py <github_repo_url> <vercel_project_name> <vercel_team_id>
```

- `github_repo_url`：要部署的 repository 的 URL。
- `vercel_project_name`：Vercel 的專案名稱。
- `vercel_team_id`：Vercel 的 Team ID。

程式會使用 `.env` 檔案內的 `GITHUB_ACCESS_TOKEN` 和 `VERCEL_ACCESS_TOKEN` 登入 GitHub 和 Vercel，然後創建一個新的 Vercel 專案，並將 `github_repo_url` repository 的內容部署到此專案上。