import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::Lambda::Alias`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 */
export interface CfnAliasProps {
    /**
     * `AWS::Lambda::Alias.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::Alias.FunctionVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionversion
     */
    readonly functionVersion: string;
    /**
     * `AWS::Lambda::Alias.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-name
     */
    readonly name: string;
    /**
     * `AWS::Lambda::Alias.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-description
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::Alias.ProvisionedConcurrencyConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-provisionedconcurrencyconfig
     */
    readonly provisionedConcurrencyConfig?: CfnAlias.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Alias.RoutingConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-routingconfig
     */
    readonly routingConfig?: CfnAlias.AliasRoutingConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Lambda::Alias`
 *
 * @cloudformationResource AWS::Lambda::Alias
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 */
export declare class CfnAlias extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Alias";
    /**
     * `AWS::Lambda::Alias.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::Alias.FunctionVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionversion
     */
    functionVersion: string;
    /**
     * `AWS::Lambda::Alias.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-name
     */
    name: string;
    /**
     * `AWS::Lambda::Alias.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-description
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::Alias.ProvisionedConcurrencyConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-provisionedconcurrencyconfig
     */
    provisionedConcurrencyConfig: CfnAlias.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Alias.RoutingConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-routingconfig
     */
    routingConfig: CfnAlias.AliasRoutingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Lambda::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAliasProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnAlias {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-aliasroutingconfiguration.html
     */
    interface AliasRoutingConfigurationProperty {
        /**
         * `CfnAlias.AliasRoutingConfigurationProperty.AdditionalVersionWeights`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-aliasroutingconfiguration.html#cfn-lambda-alias-aliasroutingconfiguration-additionalversionweights
         */
        readonly additionalVersionWeights: Array<CfnAlias.VersionWeightProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnAlias {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-provisionedconcurrencyconfiguration.html
     */
    interface ProvisionedConcurrencyConfigurationProperty {
        /**
         * `CfnAlias.ProvisionedConcurrencyConfigurationProperty.ProvisionedConcurrentExecutions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-provisionedconcurrencyconfiguration.html#cfn-lambda-alias-provisionedconcurrencyconfiguration-provisionedconcurrentexecutions
         */
        readonly provisionedConcurrentExecutions: number;
    }
}
export declare namespace CfnAlias {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html
     */
    interface VersionWeightProperty {
        /**
         * `CfnAlias.VersionWeightProperty.FunctionVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html#cfn-lambda-alias-versionweight-functionversion
         */
        readonly functionVersion: string;
        /**
         * `CfnAlias.VersionWeightProperty.FunctionWeight`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html#cfn-lambda-alias-versionweight-functionweight
         */
        readonly functionWeight: number;
    }
}
/**
 * Properties for defining a `AWS::Lambda::EventInvokeConfig`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 */
export interface CfnEventInvokeConfigProps {
    /**
     * `AWS::Lambda::EventInvokeConfig.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.Qualifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-qualifier
     */
    readonly qualifier: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.DestinationConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig
     */
    readonly destinationConfig?: CfnEventInvokeConfig.DestinationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumEventAgeInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumeventageinseconds
     */
    readonly maximumEventAgeInSeconds?: number;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumRetryAttempts`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumretryattempts
     */
    readonly maximumRetryAttempts?: number;
}
/**
 * A CloudFormation `AWS::Lambda::EventInvokeConfig`
 *
 * @cloudformationResource AWS::Lambda::EventInvokeConfig
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 */
export declare class CfnEventInvokeConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::EventInvokeConfig";
    /**
     * `AWS::Lambda::EventInvokeConfig.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.Qualifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-qualifier
     */
    qualifier: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.DestinationConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig
     */
    destinationConfig: CfnEventInvokeConfig.DestinationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumEventAgeInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumeventageinseconds
     */
    maximumEventAgeInSeconds: number | undefined;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumRetryAttempts`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumretryattempts
     */
    maximumRetryAttempts: number | undefined;
    /**
     * Create a new `AWS::Lambda::EventInvokeConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventInvokeConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEventInvokeConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig.html
     */
    interface DestinationConfigProperty {
        /**
         * `CfnEventInvokeConfig.DestinationConfigProperty.OnFailure`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig-onfailure
         */
        readonly onFailure?: CfnEventInvokeConfig.OnFailureProperty | cdk.IResolvable;
        /**
         * `CfnEventInvokeConfig.DestinationConfigProperty.OnSuccess`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig-onsuccess
         */
        readonly onSuccess?: CfnEventInvokeConfig.OnSuccessProperty | cdk.IResolvable;
    }
}
export declare namespace CfnEventInvokeConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onfailure.html
     */
    interface OnFailureProperty {
        /**
         * `CfnEventInvokeConfig.OnFailureProperty.Destination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onfailure.html#cfn-lambda-eventinvokeconfig-destinationconfig-onfailure-destination
         */
        readonly destination: string;
    }
}
export declare namespace CfnEventInvokeConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onsuccess.html
     */
    interface OnSuccessProperty {
        /**
         * `CfnEventInvokeConfig.OnSuccessProperty.Destination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onsuccess.html#cfn-lambda-eventinvokeconfig-destinationconfig-onsuccess-destination
         */
        readonly destination: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::EventSourceMapping`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 */
export interface CfnEventSourceMappingProps {
    /**
     * `AWS::Lambda::EventSourceMapping.EventSourceArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn
     */
    readonly eventSourceArn: string;
    /**
     * `AWS::Lambda::EventSourceMapping.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::EventSourceMapping.BatchSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize
     */
    readonly batchSize?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.BisectBatchOnFunctionError`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror
     */
    readonly bisectBatchOnFunctionError?: boolean | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.DestinationConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig
     */
    readonly destinationConfig?: CfnEventSourceMapping.DestinationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumBatchingWindowInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds
     */
    readonly maximumBatchingWindowInSeconds?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRecordAgeInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds
     */
    readonly maximumRecordAgeInSeconds?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRetryAttempts`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts
     */
    readonly maximumRetryAttempts?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.ParallelizationFactor`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor
     */
    readonly parallelizationFactor?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.StartingPosition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition
     */
    readonly startingPosition?: string;
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`
 *
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 */
export declare class CfnEventSourceMapping extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::EventSourceMapping";
    /**
     * `AWS::Lambda::EventSourceMapping.EventSourceArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn
     */
    eventSourceArn: string;
    /**
     * `AWS::Lambda::EventSourceMapping.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::EventSourceMapping.BatchSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize
     */
    batchSize: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.BisectBatchOnFunctionError`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror
     */
    bisectBatchOnFunctionError: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.DestinationConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig
     */
    destinationConfig: CfnEventSourceMapping.DestinationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumBatchingWindowInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds
     */
    maximumBatchingWindowInSeconds: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRecordAgeInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds
     */
    maximumRecordAgeInSeconds: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRetryAttempts`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts
     */
    maximumRetryAttempts: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.ParallelizationFactor`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor
     */
    parallelizationFactor: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.StartingPosition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition
     */
    startingPosition: string | undefined;
    /**
     * Create a new `AWS::Lambda::EventSourceMapping`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventSourceMappingProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEventSourceMapping {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-destinationconfig.html
     */
    interface DestinationConfigProperty {
        /**
         * `CfnEventSourceMapping.DestinationConfigProperty.OnFailure`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-destinationconfig.html#cfn-lambda-eventsourcemapping-destinationconfig-onfailure
         */
        readonly onFailure: CfnEventSourceMapping.OnFailureProperty | cdk.IResolvable;
    }
}
export declare namespace CfnEventSourceMapping {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-onfailure.html
     */
    interface OnFailureProperty {
        /**
         * `CfnEventSourceMapping.OnFailureProperty.Destination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-onfailure.html#cfn-lambda-eventsourcemapping-onfailure-destination
         */
        readonly destination: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::Function`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export interface CfnFunctionProps {
    /**
     * `AWS::Lambda::Function.Code`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-code
     */
    readonly code: CfnFunction.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.Handler`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-handler
     */
    readonly handler: string;
    /**
     * `AWS::Lambda::Function.Role`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-role
     */
    readonly role: string;
    /**
     * `AWS::Lambda::Function.Runtime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-runtime
     */
    readonly runtime: string;
    /**
     * `AWS::Lambda::Function.DeadLetterConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-deadletterconfig
     */
    readonly deadLetterConfig?: CfnFunction.DeadLetterConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-description
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::Function.Environment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-environment
     */
    readonly environment?: CfnFunction.EnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.FileSystemConfigs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-filesystemconfigs
     */
    readonly fileSystemConfigs?: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-functionname
     */
    readonly functionName?: string;
    /**
     * `AWS::Lambda::Function.KmsKeyArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-kmskeyarn
     */
    readonly kmsKeyArn?: string;
    /**
     * `AWS::Lambda::Function.Layers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-layers
     */
    readonly layers?: string[];
    /**
     * `AWS::Lambda::Function.MemorySize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-memorysize
     */
    readonly memorySize?: number;
    /**
     * `AWS::Lambda::Function.ReservedConcurrentExecutions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-reservedconcurrentexecutions
     */
    readonly reservedConcurrentExecutions?: number;
    /**
     * `AWS::Lambda::Function.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Lambda::Function.Timeout`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-timeout
     */
    readonly timeout?: number;
    /**
     * `AWS::Lambda::Function.TracingConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tracingconfig
     */
    readonly tracingConfig?: CfnFunction.TracingConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-vpcconfig
     */
    readonly vpcConfig?: CfnFunction.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Lambda::Function`
 *
 * @cloudformationResource AWS::Lambda::Function
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export declare class CfnFunction extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Function";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Lambda::Function.Code`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-code
     */
    code: CfnFunction.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.Handler`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-handler
     */
    handler: string;
    /**
     * `AWS::Lambda::Function.Role`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-role
     */
    role: string;
    /**
     * `AWS::Lambda::Function.Runtime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-runtime
     */
    runtime: string;
    /**
     * `AWS::Lambda::Function.DeadLetterConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-deadletterconfig
     */
    deadLetterConfig: CfnFunction.DeadLetterConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-description
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::Function.Environment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-environment
     */
    environment: CfnFunction.EnvironmentProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.FileSystemConfigs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-filesystemconfigs
     */
    fileSystemConfigs: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-functionname
     */
    functionName: string | undefined;
    /**
     * `AWS::Lambda::Function.KmsKeyArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-kmskeyarn
     */
    kmsKeyArn: string | undefined;
    /**
     * `AWS::Lambda::Function.Layers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-layers
     */
    layers: string[] | undefined;
    /**
     * `AWS::Lambda::Function.MemorySize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-memorysize
     */
    memorySize: number | undefined;
    /**
     * `AWS::Lambda::Function.ReservedConcurrentExecutions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-reservedconcurrentexecutions
     */
    reservedConcurrentExecutions: number | undefined;
    /**
     * `AWS::Lambda::Function.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Lambda::Function.Timeout`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-timeout
     */
    timeout: number | undefined;
    /**
     * `AWS::Lambda::Function.TracingConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tracingconfig
     */
    tracingConfig: CfnFunction.TracingConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-vpcconfig
     */
    vpcConfig: CfnFunction.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Lambda::Function`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html
     */
    interface CodeProperty {
        /**
         * `CfnFunction.CodeProperty.S3Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3bucket
         */
        readonly s3Bucket?: string;
        /**
         * `CfnFunction.CodeProperty.S3Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3key
         */
        readonly s3Key?: string;
        /**
         * `CfnFunction.CodeProperty.S3ObjectVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3objectversion
         */
        readonly s3ObjectVersion?: string;
        /**
         * `CfnFunction.CodeProperty.ZipFile`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-zipfile
         */
        readonly zipFile?: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-deadletterconfig.html
     */
    interface DeadLetterConfigProperty {
        /**
         * `CfnFunction.DeadLetterConfigProperty.TargetArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-deadletterconfig.html#cfn-lambda-function-deadletterconfig-targetarn
         */
        readonly targetArn?: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-environment.html
     */
    interface EnvironmentProperty {
        /**
         * `CfnFunction.EnvironmentProperty.Variables`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-environment.html#cfn-lambda-function-environment-variables
         */
        readonly variables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html
     */
    interface FileSystemConfigProperty {
        /**
         * `CfnFunction.FileSystemConfigProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-arn
         */
        readonly arn: string;
        /**
         * `CfnFunction.FileSystemConfigProperty.LocalMountPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-localmountpath
         */
        readonly localMountPath: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-tracingconfig.html
     */
    interface TracingConfigProperty {
        /**
         * `CfnFunction.TracingConfigProperty.Mode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-tracingconfig.html#cfn-lambda-function-tracingconfig-mode
         */
        readonly mode?: string;
    }
}
export declare namespace CfnFunction {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-subnetids
         */
        readonly subnetIds: string[];
    }
}
/**
 * Properties for defining a `AWS::Lambda::LayerVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html
 */
export interface CfnLayerVersionProps {
    /**
     * `AWS::Lambda::LayerVersion.Content`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-content
     */
    readonly content: CfnLayerVersion.ContentProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::LayerVersion.CompatibleRuntimes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-compatibleruntimes
     */
    readonly compatibleRuntimes?: string[];
    /**
     * `AWS::Lambda::LayerVersion.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-description
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::LayerVersion.LayerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-layername
     */
    readonly layerName?: string;
    /**
     * `AWS::Lambda::LayerVersion.LicenseInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-licenseinfo
     */
    readonly licenseInfo?: string;
}
/**
 * A CloudFormation `AWS::Lambda::LayerVersion`
 *
 * @cloudformationResource AWS::Lambda::LayerVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html
 */
export declare class CfnLayerVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::LayerVersion";
    /**
     * `AWS::Lambda::LayerVersion.Content`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-content
     */
    content: CfnLayerVersion.ContentProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::LayerVersion.CompatibleRuntimes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-compatibleruntimes
     */
    compatibleRuntimes: string[] | undefined;
    /**
     * `AWS::Lambda::LayerVersion.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-description
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::LayerVersion.LayerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-layername
     */
    layerName: string | undefined;
    /**
     * `AWS::Lambda::LayerVersion.LicenseInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-licenseinfo
     */
    licenseInfo: string | undefined;
    /**
     * Create a new `AWS::Lambda::LayerVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLayerVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnLayerVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html
     */
    interface ContentProperty {
        /**
         * `CfnLayerVersion.ContentProperty.S3Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3bucket
         */
        readonly s3Bucket: string;
        /**
         * `CfnLayerVersion.ContentProperty.S3Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3key
         */
        readonly s3Key: string;
        /**
         * `CfnLayerVersion.ContentProperty.S3ObjectVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3objectversion
         */
        readonly s3ObjectVersion?: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::LayerVersionPermission`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html
 */
export interface CfnLayerVersionPermissionProps {
    /**
     * `AWS::Lambda::LayerVersionPermission.Action`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-action
     */
    readonly action: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.LayerVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-layerversionarn
     */
    readonly layerVersionArn: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-principal
     */
    readonly principal: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.OrganizationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-organizationid
     */
    readonly organizationId?: string;
}
/**
 * A CloudFormation `AWS::Lambda::LayerVersionPermission`
 *
 * @cloudformationResource AWS::Lambda::LayerVersionPermission
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html
 */
export declare class CfnLayerVersionPermission extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::LayerVersionPermission";
    /**
     * `AWS::Lambda::LayerVersionPermission.Action`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-action
     */
    action: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.LayerVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-layerversionarn
     */
    layerVersionArn: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-principal
     */
    principal: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.OrganizationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-organizationid
     */
    organizationId: string | undefined;
    /**
     * Create a new `AWS::Lambda::LayerVersionPermission`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLayerVersionPermissionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Lambda::Permission`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html
 */
export interface CfnPermissionProps {
    /**
     * `AWS::Lambda::Permission.Action`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-action
     */
    readonly action: string;
    /**
     * `AWS::Lambda::Permission.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::Permission.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principal
     */
    readonly principal: string;
    /**
     * `AWS::Lambda::Permission.EventSourceToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-eventsourcetoken
     */
    readonly eventSourceToken?: string;
    /**
     * `AWS::Lambda::Permission.SourceAccount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourceaccount
     */
    readonly sourceAccount?: string;
    /**
     * `AWS::Lambda::Permission.SourceArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourcearn
     */
    readonly sourceArn?: string;
}
/**
 * A CloudFormation `AWS::Lambda::Permission`
 *
 * @cloudformationResource AWS::Lambda::Permission
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html
 */
export declare class CfnPermission extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Permission";
    /**
     * `AWS::Lambda::Permission.Action`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-action
     */
    action: string;
    /**
     * `AWS::Lambda::Permission.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::Permission.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principal
     */
    principal: string;
    /**
     * `AWS::Lambda::Permission.EventSourceToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-eventsourcetoken
     */
    eventSourceToken: string | undefined;
    /**
     * `AWS::Lambda::Permission.SourceAccount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourceaccount
     */
    sourceAccount: string | undefined;
    /**
     * `AWS::Lambda::Permission.SourceArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourcearn
     */
    sourceArn: string | undefined;
    /**
     * Create a new `AWS::Lambda::Permission`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPermissionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Lambda::Version`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html
 */
export interface CfnVersionProps {
    /**
     * `AWS::Lambda::Version.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::Version.CodeSha256`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256
     */
    readonly codeSha256?: string;
    /**
     * `AWS::Lambda::Version.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
     */
    readonly provisionedConcurrencyConfig?: CfnVersion.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Lambda::Version`
 *
 * @cloudformationResource AWS::Lambda::Version
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html
 */
export declare class CfnVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Version";
    /**
     * @cloudformationAttribute Version
     */
    readonly attrVersion: string;
    /**
     * `AWS::Lambda::Version.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::Version.CodeSha256`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256
     */
    codeSha256: string | undefined;
    /**
     * `AWS::Lambda::Version.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
     */
    provisionedConcurrencyConfig: CfnVersion.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Lambda::Version`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-version-provisionedconcurrencyconfiguration.html
     */
    interface ProvisionedConcurrencyConfigurationProperty {
        /**
         * `CfnVersion.ProvisionedConcurrencyConfigurationProperty.ProvisionedConcurrentExecutions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-version-provisionedconcurrencyconfiguration.html#cfn-lambda-version-provisionedconcurrencyconfiguration-provisionedconcurrentexecutions
         */
        readonly provisionedConcurrentExecutions: number;
    }
}
