# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['my_autopylot',
 'my_autopylot.Windows.functions',
 'my_autopylot.Windows.functions.blackbox',
 'my_autopylot.Windows.functions.chrome',
 'my_autopylot.Windows.functions.excel',
 'my_autopylot.Windows.functions.extras',
 'my_autopylot.Windows.functions.folder',
 'my_autopylot.Windows.functions.keyboard',
 'my_autopylot.Windows.functions.mouse',
 'my_autopylot.Windows.functions.screen_scraping',
 'my_autopylot.Windows.functions.string',
 'my_autopylot.Windows.functions.voice',
 'my_autopylot.Windows.functions.windows',
 'my_autopylot.cli',
 'my_autopylot.resources']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=9.0.1,<10.0.0',
 'PyGetWindow>=0.0.9,<0.0.10',
 'PyScreeze>=0.1.28,<0.2.0',
 'SpeechRecognition>=3.8.1,<4.0.0',
 'colored>=1.4.3,<2.0.0',
 'emoji>=1.7.0,<2.0.0',
 'gTTS>=2.2.3,<3.0.0',
 'helium>=3.0.8,<4.0.0',
 'pandas>=1.4.1,<2.0.0',
 'psutil>=5.9.0,<6.0.0',
 'pyfiglet>=0.8.post1,<0.9',
 'pyinspect>=0.1.0,<0.2.0',
 'pywinauto>=0.6.8,<0.7.0',
 'rich>=11.2.0,<12.0.0',
 'speedtest-cli>=2.1.3,<3.0.0',
 'webdriver-manager>=3.5.3,<4.0.0']

entry_points = \
{'console_scripts': ['ap = my_autopylot.cli.my_autopylot:main',
                     'ap_py = my_autopylot.cli.ap_console:main',
                     'ap_st = my_autopylot.cli.speed_test:main']}

setup_kwargs = {
    'name': 'my-autopylot',
    'version': '0.0.5',
    'description': 'Auto-Pylot is a Python based RPA platform for Software BOT development as an Open Source project. We strive to liberate humans from mundane, repetitive tasks, giving them more time to use their intellect and creativity to solve higher-order business challenges and perform knowledge work. We see a world where every employee will work side by side with Digital Workers, taking the robot out of the human, making them exponentially more productive and far more fulfilled.',
    'long_description': '## Welcome to My-AutoPylot , Made in India with &#10084;&#65039; \n\n<br>\n\n<img src="https://raw.githubusercontent.com/py-bots/media-pyles/main/autopylot/Auto%20Pylot%20Figlet%20Dark.png">\n\n\n# What is My-AutoPylot?\n\nPyBots is an Indian firm based in Vadodara, Gujarat. My-AutoPylot is a product developed based on Python. Its a RPA framework for developers and common people to create Software BOTs. Using AI, we\'re working on Common Man\'s RPA.\n\n\n<!-- #### Check out Project Status\n\n![PyPI](https://img.shields.io/pypi/v/ClointFusion?label=PyPI%20Version) \n![PyPI - License](https://img.shields.io/pypi/l/ClointFusion?label=License) \n![PyPI - Status](https://img.shields.io/pypi/status/ClointFusion?label=Release%20Status) \n![ClointFusion](https://snyk.io/advisor/python/ClointFusion/badge.svg) \n![PyPI - Downloads](https://img.shields.io/pypi/dm/ClointFusion?label=PyPI%20Downloads) \n![Libraries.io SourceRank](https://img.shields.io/librariesio/sourcerank/pypi/ClointFusion) \n![PyPI - Format](https://img.shields.io/pypi/format/ClointFusion?label=PyPI%20Format) \n![GitHub contributors](https://img.shields.io/github/contributors/ClointFusion/ClointFusion?label=Contributors) \n![GitHub last commit](https://img.shields.io/github/last-commit/ClointFusion/ClointFusion?label=Last%20Commit) \n\n![GitHub Repo stars](https://img.shields.io/github/stars/ClointFusion/ClointFusion?label=Stars&style=social) \n![Twitter URL](https://img.shields.io/twitter/url?style=social&url=https%3A%2F%2Ftwitter.com%2FClointFusion) \n![YouTube Channel Subscribers](https://img.shields.io/youtube/channel/subscribers/UCIygBtp1y_XEnC71znWEW2w?style=social) \n![Twitter Follow](https://img.shields.io/twitter/follow/ClointFusion?style=social) -->\n<!-- \n## Release Notes\n\n- Click here for <a href="https://github.com/ClointFusion/ClointFusion/blob/master/Release_Notes.txt" target="_blank"> Release Notes</a>\n\n--- -->\n\n# Installation\n\n<br>\n\n> ### My-AutoPylot is currently supported on Windows only ! (For macOS and Linux : Comming soon.)\n\n## Windows :\n\n* My-AutoPylot is compatible with both Windows 10 and Windows 11.\n* Installing on a Windows PC is a breeze.\n* Make certain that Python 3.8 or Python 3.9 is installed.\n* Then, from the command prompt, execute the following command.\n\n    ```\n    pip install -U my-autopylot\n    ```\n\n# Importing\n\n<br>\n\n> ### My-AutoPylot can be accessed using one of two methods.\n\n## Windows :\n\n* ### Terminal : Opens a Python interpreter using the command " import my-autopylot as ap "\n\n    ```\n    ap_py\n    ```\n* ### Code Editor or IDE : Import My-AutoPylot first, and then run the file in Python.\n\n    ```\n    # ap_bot.py\n\n    import my_autopylot as ap\n\n    ap.windows_launch_app(\'notepad\')\n    ```\n    ```\n    python ap_bot.py\n    ```\n\n\n# My-AutoPylot in Action\n\n## **Now access more than 100 functions (hit ctrl+space in your IDE)**\n\n***TIP: You can find and inspect all of My-AutoPylot\'s functions using only one function i.e., `find()`. Just pass the partial name of the function.***\n\n```\nap.find("excel")\n\nap.find("window")\n\n```\n\n* ### 4 functions on Mouse Operations:\n\n| Function | Accepted Parameters | Description |\n| :--------: | :----: | :----------- |\n| ap.mouse_click() | x=" ", y=" ", left_or_right="left", no_of_clicks=1, type_of_movement="abs or rel"  | Clicks at the given X Y Co-ordinates on the screen using ingle / double / triple click(s). Optionally copies selected data to clipboard (works for double / triple clicks) |\n| ap.mouse_move() | x=" ", y=" ", type_of_movement="abs or rel" | Moves the cursor to the given X Y Co-ordinates |\n| ap.mouse_drag_from_to() | x1=" ", y1=" ", x2=" ",y2=" " | Clicks and drags from X1 Y1 co-ordinates to X2 Y2 Co-ordinates on the screen |\n| ap.mouse_search_snip_return_coordinates_x_y() | img=" ", wait=10 | Searches the given image on the screen and returns its center of X Y co-ordinates. |\n\n<br>\n<!-- <img src="https://github.com/ClointFusion/Image_ICONS_GIFs/blob/main/Mouse_Operations.gif?raw=true" height="400"> -->\n\n----\n\n* ### 8 functions on Window Operations (works only in Windows OS):\n\n| Function | Accepted Parameters | Description |\n| :--------: | :----: | :----------- |\n| ap.windows_show_desktop() | None | Minimizes all the applications and shows Desktop. |\n| ap.windows_launch_app() | pathOfExeFile=" " | Launches any exe or batch file or excel file etc. |\n| ap.window_get_active_window() | None | Launches any exe or batch file or excel file etc. |\n| ap.window_activate_window() | window_title=" " | Launches any exe or batch file or excel file etc. |\n| ap.window_get_all_opened_titles_windows() | window_title=" " | Gives the title of all the existing (open) windows. |\n| ap.window_activate_and_maximize_windows() | windowName=" " | Activates and maximizes the desired window. |\n| ap.window_minimize_windows() | windowName=" " | Activates and minimizes the desired window. | \n| ap.window_close_windows() | windowName=" " | Close the desired window. |\n\n<br>\n<!-- <img src="https://github.com/ClointFusion/Image_ICONS_GIFs/blob/main/Functions%20Light%20GIFs/Window Operations.gif?raw=true" height="400"> -->\n\n----\n\n* ### 8 functions on Folder Operations:\n\n| Function | Accepted Parameters | Description |\n| :--------: | :----: | :----------- |\n| ap.folder_read_text_file() | txt_file_path=" " | Reads from a given text file and returns entire contents as a single list |\n| ap.folder_write_text_file() | txt_file_path=" ", contents=" " |  Writes given contents to a text file |\n| ap.folder_create() | strFolderPath=" " | When you are making leaf directory, if any intermediate-level directory is missing, folder_create() method creates them. |\n| ap.folder_create_text_file() | textFolderPath=" ", txtFileName=" " | Creates text file in the given path. |\n| ap.folder_get_all_filenames_as_list() | strFolderPath=" ", extension=\'all\' | Get all the files of the given folder in a list. |\n| ap.folder_delete_all_files() | fullPathOfTheFolder=" ", file_extension_without_dot="all" | Deletes all the files of the given folder |\n| ap.file_rename() | old_file_path=\'\', new_file_name=\'\', print_status=True | Renames the given file name to new file name with same extension. |\n| ap.file_get_json_details() | path_of_json_file=\'\', section=\'\' | Returns all the details of the given section in a dictionary |\n\n<br>\n<!-- <img src="https://github.com/ClointFusion/Image_ICONS_GIFs/blob/main/Folder_Operations.gif?raw=true" height="400"> -->\n\n----\n\n* ### 3 functions on Keyboard Operations:\n\n| Function | Accepted Parameters | Description |\n| :--------: | :----: | :----------- |\n| ap.key_press() | key_1=\'\', key_2=\'\', key_3=\'\', write_to_window=" " | Emulates the given keystrokes. |\n| ap.key_write_enter() | text_to_write=" ", write_to_window=" ", delay_after_typing=1, key="e" | Writes/Types the given text and press enter (by default) or tab key. |\n| ap.key_hit_enter() | write_to_window=" " | Enter key will be pressed once. |\n\n<br>\n<!-- <img src="https://github.com/ClointFusion/Image_ICONS_GIFs/blob/main/KB_Operations.gif?raw=true" height="400"> -->\n\n----\n\n* ### 5 functions on Screen-scraping Operations:\n\n| Function | Accepted Parameters | Description |\n| :--------: | :----: | :----------- |\n| ap.scrape_save_contents_to_notepad() | folderPathToSaveTheNotepad=" ", switch_to_window=" ",X=0, Y=0 | Copy pastes all the available text on the screen to notepad and saves it. |\n| ap.screen_clear_search() | delay=0.2 | Clears previously found text (crtl+f highlight) |\n| ap.search_highlight_tab_enter_open() | searchText=" ", hitEnterKey="Yes", shift_tab=\'No\' | Searches for a text on screen using crtl+f and hits enter. This function is useful in Citrix environment. |\n| ap.find_text_on_screen() | searchText=" ", delay=0.1, occurance=1, isSearchToBeCleared=False | Clears previous search and finds the provided text on screen. |\n\n<br>\n<!-- <img src="https://github.com/ClointFusion/Image_ICONS_GIFs/blob/main/Screen_Scraping.gif?raw=true" height="400"> -->\n\n----\n\n* ### 11 functions on Browser Operations:\n\n| Function | Accepted Parameters | Description |\n| :--------: | :----: | :----------- |\n| driver = ap.ChromeBrowser() |  | Function to launch browser and start the session. |\n| driver.open_browser() | dummy_browser=True,<br> incognito=False,<br> profile="Default" | Function to launch browser and start the session. |\n| driver.navigate() | url=" " | Navigates to Specified URL. |\n| driver.write() | Value=" ",  User_Visible_Text_Element=" " |  Write a string on the given element. |\n| driver.mouse_click() | User_Visible_Text_Element=" ", element=" ",<br> double_click=False, right_click=False | Click on the given element. |\n| driver.mouse_hover() | User_Visible_Text_Element=" " | Performs a Mouse Hover over the Given User Visible Text Element |\n| driver.scroll() | direction="down", weight="100" px  | Scrolls the browser window. | \n| driver.key_press() | key_1=" ", key_2=" " | Type text using Browser Helium Functions and press hot keys |\n| driver.hit_enter() | None | Hits enter KEY using Browser Helium Functions |\n| driver.wait_until() | text=" ", element="t" | Wait until a specific element is found. |\n| driver.refresh_page() | None | Refresh the page. |\n| driver.set_waiting_time() | time=10 | Set the waiting time for the self.browser_driver. If element is not found in the given time, it will raise an exception.\n| driver.find_element() | element_xpath="xpath" | Find the element using xpath.\n| driver.get_text() | element_xpath=" ", element="t" | Wait until a specific element is found. |\n| driver.close() | None | Close the Helium browser. |\n\n<br>\n<!-- <img src="https://github.com/ClointFusion/Image_ICONS_GIFs/blob/main/Functions%20Light%20GIFs/browser_functions.gif?raw=true" height="400"> -->\n\n----\n<!-- \n* ### 4 functions on Alert Messages:\n\n| Function | Accepted Parameters | Description |\n| :--------: | :----: | :----------- |\n| ap.message_counter_down_timer() | strMsg="Calling ClointFusion Function in (seconds)", start_value=5 | Function to show count-down timer. Default is 5 seconds. |\n| ap.message_pop_up() | strMsg=" ", delay=3 | Specified message will popup on the screen for a specified duration of time.|\n| ap.message_flash() | msg=" ", delay=3 | Specified msg will popup for a specified duration of time with OK button. |\n| ap.message_toast() | message,website_url=" ", file_folder_path=" " | Function for displaying Windows 10 Toast Notifications. Pass website URL OR file / folder path that needs to be opened when user clicks on the toast notification. |\n\n---- -->\n\n* ### 3 functions on String Operations: \n\n| Function | Accepted Parameters | Description |\n| :--------: | :----: | :----------- |\n| ap.string_remove_special_characters() | inputStr=" " | Removes all the special character. |\n| ap.string_extract_only_alphabets() | inputString=" " | Returns only alphabets from given input string |\n| ap.string_extract_only_numbers() | inputString=" " | Returns only numbers from given input string |\n\n<br>\n<!-- <img src="https://github.com/ClointFusion/Image_ICONS_GIFs/blob/main/String_Operations.gif?raw=true" height="400"> -->\n\n----\n\n* ### Some miscellaneous functions:\n\n| Function | Accepted Parameters | Description |\n| :--------: | :----: | :----------- |\n| ap.clear_screen() | None | Clears Python Interpreter Terminal Window Screen |\n| ap.print_with_magic_color() | strMsg:str=" ", magic:bool=False | Function to color and format terminal output |\n| ap.show_emoji() | strInput=" " | Function which prints Emojis |\n| ap.download_this_file() | url=" " | Downloads a given url file to BOT output folder or Browser\'s Download folder |\n| ap.pause_program() | seconds="5" | Stops the program for given seconds |\n\n<br>\n<!-- <img src="https://github.com/ClointFusion/Image_ICONS_GIFs/blob/main/miscallaneous.gif?raw=true" height="400">     -->\n\n\n<!-- # BOTS made out of My-AutoPylot\n\n### Outlook Email BOT implemented using Auto Pylot\n\n<img src="https://github.com/ClointFusion/Image_ICONS_GIFs/blob/main/Functions%20Light%20GIFs/Gmail_and_Outlook_BOT.gif?raw=true" height="400">\n\n<br> -->\n\n# We love your contribution\n\nContribute to us by giving a star, writing articles on `My-AutoPylot`, giving comments, reporting bugs, bug fixes, feature enhancements, adding documentation, and many other ways. \n\n\n## Invitation to our Monthly Branded Hackathon\n\nWe also invite everyone to take part in our monthly branded event, the `My-AutoPylot Hackathon`, and stand a chance to work with us.\n\n<!-- Checkout our Hackathon Website for more details here: [ClointFusion Hackathon](https://sites.google.com/view/clointfusion-hackathon -->\n<!-- ) -->\n\n<br>\n\n<!-- ## Date &#10084;&#65039; with My-AutoPylot -->\n\n<!-- This an initiative for fast track entry into our growing workforce. For more details, please visit: [Date with ClointFusion](https://lnkd.in/gh_r9YB) -->\n\n\n## Acknowledgements\n\nWe sincerely thanks to all it\'s dependent packages for the great contribution, which made `My-AutoPylot` possible!\n\n<!-- Please find all the dependencies [here](https://openbase.com/python/ClointFusion/dependencies)  -->\n<!-- \n<a href="https://openbase.com/python/ClointFusion/dependencies" target="blank">ClointFusion thanks all its dependent packages for the great contribution, which has made ClointFusion possible !</a> -->\n\n\n## Need help in Building BOTS?\n\nWrite us by clicking below<br>\n<div align=\'left\'>\n<a href="mailto:support@pybots.ai" target="_blank"><img src="https://img.shields.io/badge/Gmail-D14836?style=for-the-badge&logo=gmail&logoColor=white" alt="Gmail"></a> &nbsp;\n</div>\n\n---\n\n<!-- Disclaimer: We collect anonymous data on installation and usage statistics in order to improve our product and provide better services. -->',
    'author': 'PyBots',
    'author_email': 'support@pybots.ai',
    'maintainer': None,
    'maintainer_email': None,
    'url': '',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<=3.9.40',
}


setup(**setup_kwargs)
