# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CsvFileResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'title': 'str',
        'file_contents': 'str'
    }

    attribute_map = {
        'title': 'Title',
        'file_contents': 'FileContents'
    }

    def __init__(self, title=None, file_contents=None):  # noqa: E501
        """CsvFileResult - a model defined in Swagger"""  # noqa: E501

        self._title = None
        self._file_contents = None
        self.discriminator = None

        if title is not None:
            self.title = title
        if file_contents is not None:
            self.file_contents = file_contents

    @property
    def title(self):
        """Gets the title of this CsvFileResult.  # noqa: E501

        Title of the CSV file  # noqa: E501

        :return: The title of this CsvFileResult.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this CsvFileResult.

        Title of the CSV file  # noqa: E501

        :param title: The title of this CsvFileResult.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def file_contents(self):
        """Gets the file_contents of this CsvFileResult.  # noqa: E501

        Contents of the CSV file  # noqa: E501

        :return: The file_contents of this CsvFileResult.  # noqa: E501
        :rtype: str
        """
        return self._file_contents

    @file_contents.setter
    def file_contents(self, file_contents):
        """Sets the file_contents of this CsvFileResult.

        Contents of the CSV file  # noqa: E501

        :param file_contents: The file_contents of this CsvFileResult.  # noqa: E501
        :type: str
        """
        if file_contents is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', file_contents):  # noqa: E501
            raise ValueError(r"Invalid value for `file_contents`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._file_contents = file_contents

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CsvFileResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CsvFileResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
