# <img src="https://raw.githubusercontent.com/executablebooks/jupyter-book/master/docs/images/logo.png" width=40 /> Jupyter Book

[![CircleCI](https://circleci.com/gh/executablebooks/jupyter-book.svg?style=svg)](https://circleci.com/gh/executablebooks/jupyter-book)
[![codecov](https://codecov.io/gh/ExecutableBookProject/jupyter-book/branch/master/graph/badge.svg)](https://codecov.io/gh/ExecutableBookProject/jupyter-book)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.2799972.svg)](https://doi.org/10.5281/zenodo.2799972)

Jupyter Book is an open-source tool for building publication-quality books and documents from computational material.

Jupyter Book allows users to

* write their content in [markdown files](https://myst-parser.readthedocs.io/en/latest/) or [Jupyter](https://jupyter.org/) notebooks,
* include computational elements (e.g., code cells) in either type,
* include rich syntax such as citations, cross-references, and numbered equations, and
* using a simple command, run the embedded code cells, [cache](https://jupyter-cache.readthedocs.io/en/latest/) the outputs and convert this content into:
    * a web-based interactive book and
    * a publication-quality PDF.

## Governance of this project

Jupyter Book is still developing relatively rapidly, so please be patient if things change
or features iterate and change quickly. Once Jupyter Book hits 1.0, it will slow down
considerably!

## Contribute or improve the book

Notice some inefficient CSS? A typo in the text? Want to add a cool feature so that others
can enjoy the improvements to Jupyter Books? Check out the [Jupyter Book Contributor's
Guide](https://jupyterbook.org/advanced/contributing.html). We'd love your help!

We ask that all contributions to Jupyter Book respect the
[Jupyter code of conduct](https://github.com/jupyter/governance/blob/master/conduct/code_of_conduct.md).

## Acknowledgements

Jupyter Book is maintained and primarily developed by
the [Executable Book Project](https://executablebooks.org).
