"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatadogIntegrationStack = exports.DatadogIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn = require("aws-cdk-lib/aws-cloudformation");
const cdk = require("aws-cdk-lib/core");
const constructs_1 = require("constructs");
const config_1 = require("./config");
const util_1 = require("./util");
class DatadogIntegration extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.DATADOG_AWS_ACCOUNT_ID = '464622532012'; // DO NOT CHANGE!
        const propsWithDefaults = config_1.applyDefaultsToConfig(props);
        let policyMacroStack;
        if (propsWithDefaults.installDatadogPolicyMacro) {
            policyMacroStack = this.createPolicyMacroStack();
        }
        this.createIntegrationRole(propsWithDefaults, policyMacroStack);
        this.createForwarderStack(propsWithDefaults);
    }
    createPolicyMacroStack() {
        return new cfn.CfnStack(this, 'PolicyMacroStack', {
            templateUrl: 'https://datadog-cloudformation-template.s3.amazonaws.com/aws/datadog_policy_macro.yaml',
        });
    }
    createIntegrationRole(props, policyMacroStack) {
        const integrationRoleStack = new cfn.CfnStack(this, 'IntegrationRoleStack', {
            templateUrl: 'https://datadog-cloudformation-template.s3.amazonaws.com/aws/datadog_integration_role.yaml',
            parameters: Object.assign({
                ExternalId: props.externalId,
                BasePermissions: props.permissions.toString(),
                IAMRoleName: props.iamRoleName,
                LogArchives: util_1.bucketsToString(props.logArchives),
                CloudTrails: util_1.bucketsToString(props.cloudTrails),
                DdAWSAccountId: this.DATADOG_AWS_ACCOUNT_ID,
            }, { ...props.additionalIntegrationRoleParams }),
        });
        if (policyMacroStack) {
            integrationRoleStack.addDependsOn(policyMacroStack);
        }
        return integrationRoleStack;
    }
    createForwarderStack(props) {
        return new cfn.CfnStack(this, 'ForwarderStack', {
            templateUrl: `https://datadog-cloudformation-template.s3.amazonaws.com/aws/forwarder/${props.forwarderVersion}.yaml`,
            parameters: Object.assign({
                DdApiKey: 'USE_ARN',
                DdApiKeySecretArn: props.apiKey.secretArn,
                DdSite: props.site,
                FunctionName: props.forwarderName,
            }, { ...props.additionalForwarderParams }),
        });
    }
}
exports.DatadogIntegration = DatadogIntegration;
_a = JSII_RTTI_SYMBOL_1;
DatadogIntegration[_a] = { fqn: "cdk-datadog-integration.DatadogIntegration", version: "2.0.1" };
class DatadogIntegrationStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        new DatadogIntegration(this, id, props);
    }
}
exports.DatadogIntegrationStack = DatadogIntegrationStack;
_b = JSII_RTTI_SYMBOL_1;
DatadogIntegrationStack[_b] = { fqn: "cdk-datadog-integration.DatadogIntegrationStack", version: "2.0.1" };
//# sourceMappingURL=data:application/json;base64,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