# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/30_eggs.ipynb.

# %% auto 0
__all__ = ['il_moduleloader', 'il_modulespec', 'os_pathlike', 'pl_path', 'pl_posixpath', 'i_sig', 'i_param', 'i_paramkind',
           'i_empty', 'l_logger', 'it_chain', 'it_prod', 'it_ziplong', 'c_dict_keys', 'c_dict_values', 'c_dict_items',
           't_moduletype', 't_methodwrappertype', 't_builtinfunctiontype', 't_tracebacktype', 't_functiontype',
           't_nonetype', 'c_mapping', 'c_iterable', 'm_nan', 'np_nan', 'np_NaN', 'np_NAN', 'pd_na', 'pd_natype',
           'n_number', 're_pattern', 're_match', 's_template', 'np_array', 'np_matrix', 'np_recarray', 'np_bool',
           'np_type', 'np_empty', 'np_datasource', 'sp_sparray', 'sp_spmatrix', 'sp_linalg', 'sp_speigs', 'sp_pdist',
           'sp_csc_array', 'sp_csc_matrix', 'sp_coo_array', 'sp_coo_matrix', 'sp_csr_array', 'sp_csr_matrix',
           'sp_dia_array', 'sp_dia_matrix', 'sp_dok_array', 'sp_dok_matrix', 'sp_lil_array', 'sp_lil_matrix',
           'sp_bsr_array', 'sp_bsr_matrix', 'pd_index', 'pd_series', 'pd_dataframe', 'pd_catindex', 'pd_delegate',
           'pd_cataccessor', 'pt_C', 'pt_nan', 'pt_size', 'pt_type', 'pt_device', 'pt_nn', 'pt_module', 'pt_dataset',
           'pt_dataloader', 'pt_tensorbase', 'pt_tensor', 'pt_inttensor', 'pt_floattensor', 'pt_longtensor',
           'pt_doubletensor', 'pt_booltensor', 'pt_memoryformat', 'pt_preserveformat', 'tv_datasets', 'tv_transforms',
           'tv_functional', 'pl_module', 'pl_datamodule', 'td_odefunc', 'td_sdefunc', 'td_neuralode', 'td_neuralsde',
           'td_augmenter', 'ts_sdeito', 'ts_brownianinterval', 'ad_adata', 'gt_base', 'gt_data', 'gt_bgraph',
           'gt_dgraph', 'gt_lgraph', 'gt_kgraph', 'gt_tgraph', 'gt_mgraph', 'gt_klgraph', 'gt_mlgraph', 'gt_tlgraph',
           'cv_vidcap', 'pil_image', 'mpl', 'mp_pyplot', 'mpl_colormap', 'mpl_lcolormap', 'mpl_lscolormap',
           'mpl_artist', 'mpl_patch', 'mpl_axbase', 'mpl_axes', 'sk_baseestimator', 'sk_pairwise', 'ph_phate',
           'r_jupmix', 'r_richtree', 'r_richtext', 'r_richcons', 'r_richprog', 'r_richtask', 'tq_as', 'tq_nb',
           'tq_auto', 't_typer']

# %% ../nbs/30_eggs.ipynb 6
#| export


# %% ../nbs/30_eggs.ipynb 8
from abc import ABCMeta
from enum import EnumMeta
from types import ModuleType, FunctionType, BuiltinFunctionType

# %% ../nbs/30_eggs.ipynb 10
#| export

# %% ../nbs/30_eggs.ipynb 12
#| export

# %% ../nbs/30_eggs.ipynb 14
from .spec import DuckSpec
from . import mods

# %% ../nbs/30_eggs.ipynb 17
il_moduleloader = DuckSpec(asset='importlib.abc.Loader', ducked=mods._importlib, default=type)
'''`importlib.Loader`''';

il_modulespec = DuckSpec(asset='importlib.machinery.ModuleSpec', ducked=mods._importlib, default=type)
'''`importlib.machinery.ModuleSpec`''';

# %% ../nbs/30_eggs.ipynb 19
os_pathlike = DuckSpec(asset='os.PathLike', ducked=mods._os, default=str)
'''`os.pathlike`''';

pl_path = DuckSpec(asset='pathlib.Path', ducked=mods._pathlib, default=os_pathlike, delayed=dict(default=True))
'''`pathlib.Path`''';

pl_posixpath = DuckSpec(asset='pathlib.PosixPath', ducked=mods._pathlib, default=os_pathlike, delayed=dict(default=True))
'''`pathlib.PosixPath`''';

# %% ../nbs/30_eggs.ipynb 21
i_sig = DuckSpec(asset='inspect.Signature', ducked=mods._inspect, default=type)
'''`inspect.Signature`''';

i_param = DuckSpec(asset='inspect.Parameter', ducked=mods._inspect, default=type)
'''`inspect.Parameter`''';

i_paramkind = DuckSpec(asset='inspect._ParameterKind', ducked=mods._inspect, default=EnumMeta)
'''`inspect._ParameterKind`''';

i_empty = DuckSpec(asset='inspect._empty', ducked=mods._inspect, default=type)
'''`inspect.emtpy`''';

# %% ../nbs/30_eggs.ipynb 23
l_logger = DuckSpec(asset='logging.Logger', ducked=mods._logging, default=type)
'''`logging.Logger`''';

# %% ../nbs/30_eggs.ipynb 25
it_chain = DuckSpec(asset='itertools.chain', ducked=mods._itertools, default=type)
'''`itertools.chain`''';

it_prod = DuckSpec(asset='itertools.product', ducked=mods._itertools, default=type)
'''`itertools.product`''';

it_ziplong = DuckSpec(asset='itertools.zip_longest', ducked=mods._itertools, default=type)
'''`itertools.zip_longest`''';

# %% ../nbs/30_eggs.ipynb 28
c_dict_keys = DuckSpec(asset='_collections_abc.dict_keys', ducked=mods._collectionsabc, default=type)
'''`collections.abc.dict_keys`''';

c_dict_values = DuckSpec(asset='_collections_abc.dict_values', ducked=mods._collectionsabc, default=type)
'''`collections.abc.dict_values`''';

c_dict_items = DuckSpec(asset='_collections_abc.dict_items', ducked=mods._collectionsabc, default=type)
'''`collections.abc.dict_items`''';

# %% ../nbs/30_eggs.ipynb 31
t_moduletype = DuckSpec(asset='types.ModuleType', ducked=mods._types, default=type)
'''`types.ModuleType`''';

t_methodwrappertype = DuckSpec(asset='types.MethodWrapperType', ducked=mods._types, default=type)
'''`types.MethodWrapperType`''';

t_builtinfunctiontype = DuckSpec(asset='types.BuiltinFunctionType', ducked=mods._types, default=type)
'''`types.BuiltinFunctionType`''';

t_tracebacktype = DuckSpec(asset='types.TracebackType', ducked=mods._types, default=type)
'''`types.TracebackType`''';

t_functiontype = DuckSpec(asset='types.FunctionType', ducked=mods._types, default=type)
'''`types.FunctionType`''';

t_nonetype = DuckSpec(asset='types.NoneType', ducked=mods._types, default=type)
'''`types.NoneType`''';

c_mapping = DuckSpec('collections.abc.Mapping', default=type)
'''`collections.abc.Mapping`''';

c_iterable = DuckSpec('collections.abc.Iterable', default=type)
'''`collections.abc.Iterable`''';

# %% ../nbs/30_eggs.ipynb 34
m_nan = DuckSpec(asset='math.nan', ducked=mods._math, default=float('nan'))
'''`math.nan`''';

np_nan = DuckSpec(asset='numpy.nan', ducked=mods._numpy, default=m_nan, delayed=dict(default=True))
'''`numpy.nan`''';

np_NaN = DuckSpec(asset='numpy.NaN', ducked=mods._numpy, default=m_nan, delayed=dict(default=True))
'''`numpy.NaN`''';

np_NAN = DuckSpec(asset='numpy.NAN', ducked=mods._numpy, default=m_nan, delayed=dict(default=True))
'''`numpy.NAN`''';

pd_na = DuckSpec(asset='pandas.NA', ducked=mods._pandas, default=m_nan, delayed=dict(default=True))
'''`pandas.NA`''';

pd_natype = DuckSpec(asset='pandas._libs.missing.NAType', ducked=mods._pandas, default=type(m_nan))
'''`pandas._libs.missing.NAType`''';

# %% ../nbs/30_eggs.ipynb 38
n_number = DuckSpec(asset='numbers.Number', ducked=mods._numbers, default=ABCMeta)
'''`numbers.Number`''';

# %% ../nbs/30_eggs.ipynb 40
re_pattern = DuckSpec(asset='re.Pattern', ducked=mods._re, default=type)
'''`re.Pattern`''';

re_match = DuckSpec(asset='re.Match', ducked=mods._re, default=type)
'''`re.Match`''';

s_template = DuckSpec(asset='string.Template', ducked=mods._string, default=type)
'''`string.Template`''';

# %% ../nbs/30_eggs.ipynb 43
np_array = DuckSpec(asset='numpy.ndarray', ducked=mods._numpy, default=list)
'''`numpy.ndarray`''';

np_matrix = DuckSpec(asset='numpy.matrix', ducked=mods._numpy, default=list)
'''`numpy.matrix`''';

np_recarray = DuckSpec(asset='numpy.recarray', ducked=mods._numpy, default=list)
'''`numpy.recarray`''';

np_bool = DuckSpec(asset='numpy.bool_', ducked=mods._numpy, default=bool)
'''`numpy.bool_`''';

np_type = DuckSpec(asset='numpy.dtype', ducked=mods._numpy, default=type)
'''`numpy.dtype`''';

np_empty = DuckSpec(asset='numpy.empty', ducked=mods._numpy, default=BuiltinFunctionType)
'''`numpy.empty`''';

np_datasource = DuckSpec(asset='numpy.DataSource', ducked=mods._numpy, default=os_pathlike, delayed=dict(default=True))
'''`numpy.DataSource`''';

# %% ../nbs/30_eggs.ipynb 46
# NOTE: required as scipy.sparse.sparray location depends on version
sp_sparray = DuckSpec(asset='scipy.sparse._arrays._sparray', ducked=mods._scipy, default=list)
sp_sparray = DuckSpec(asset='scipy.sparse.sparray', ducked=mods._scipy, default=(sp_sparray or list), delayed=dict(default=True))
'''`scipy.sparse.sparray`''';

sp_spmatrix = DuckSpec(asset='scipy.sparse.spmatrix', ducked=mods._scipy, default=list)
'''`scipy.sparse.spmatrix`''';

# %% ../nbs/30_eggs.ipynb 47
sp_linalg = DuckSpec(asset='scipy.sparse.linalg', ducked=mods._scipy, default=ModuleType('scipy.sparse.linalg'))
'''`scipy.sparse.linalg`''';

sp_speigs = DuckSpec(asset='scipy.sparse.linalg.eigs', ducked=mods._scipy, default=FunctionType)
'''`scipy.sparse.linalg.eigs`''';

sp_pdist = DuckSpec(asset='scipy.spatial.distance.pdist', ducked=mods._scipy, default=FunctionType)
'''`scipy.spatial.distance.pdist`''';

# %% ../nbs/30_eggs.ipynb 49
sp_csc_array = DuckSpec(asset='scipy.sparse.csc_array', ducked=mods._scipy, default=list)
'''`scipy.sparse.csc_array`''';

sp_csc_matrix = DuckSpec(asset='scipy.sparse.csc_matrix', ducked=mods._scipy, default=list)
'''`scipy.sparse.csc_matrix`''';

sp_coo_array = DuckSpec(asset='scipy.sparse.coo_array', ducked=mods._scipy, default=list)
'''`scipy.sparse.coo_array`''';

sp_coo_matrix = DuckSpec(asset='scipy.sparse.coo_matrix', ducked=mods._scipy, default=list)
'''`scipy.sparse.coo_matrix`''';

sp_csr_array = DuckSpec(asset='scipy.sparse.csr_array', ducked=mods._scipy, default=list)
'''`scipy.sparse.csr_array`''';

sp_csr_matrix = DuckSpec(asset='scipy.sparse.csr_matrix', ducked=mods._scipy, default=list)
'''`scipy.sparse.csr_matrix`''';

sp_dia_array = DuckSpec(asset='scipy.sparse.dia_array', ducked=mods._scipy, default=list)
'''`scipy.sparse.dia_array`''';

sp_dia_matrix = DuckSpec(asset='scipy.sparse.dia_matrix', ducked=mods._scipy, default=list)
'''`scipy.sparse.dia_matrix`''';

sp_dok_array = DuckSpec(asset='scipy.sparse.dok_array', ducked=mods._scipy, default=list)
'''`scipy.sparse.dok_array`''';

sp_dok_matrix = DuckSpec(asset='scipy.sparse.dok_matrix', ducked=mods._scipy, default=list)
'''`scipy.sparse.dok_matrix`''';

sp_lil_array = DuckSpec(asset='scipy.sparse.lil_array', ducked=mods._scipy, default=list)
'''`scipy.sparse.lil_array`''';

sp_lil_matrix = DuckSpec(asset='scipy.sparse.lil_matrix', ducked=mods._scipy, default=list)
'''`scipy.sparse.lil_matrix`''';

sp_bsr_array = DuckSpec(asset='scipy.sparse.bsr_array', ducked=mods._scipy, default=list)
'''`scipy.sparse.bsr_array`''';

sp_bsr_matrix = DuckSpec(asset='scipy.sparse.bsr_matrix', ducked=mods._scipy, default=list)
'''`scipy.sparse.bsr_matrix`''';

# %% ../nbs/30_eggs.ipynb 51
pd_index = DuckSpec(asset='pandas.Index', ducked=mods._pandas, default=list)
'''`pandas.Index`''';

pd_series = DuckSpec(asset='pandas.Series', ducked=mods._pandas, default=list)
'''`pandas.Series`''';

pd_dataframe = DuckSpec(asset='pandas.DataFrame', ducked=mods._pandas, default=list)
'''`pandas.DataFrame`''';

pd_catindex = DuckSpec(asset='pandas.CategoricalIndex', ducked=mods._pandas, default=list)
'''`pandas.CategoricalIndex`''';

pd_delegate = DuckSpec(asset='pandas.core.accessor.PandasDelegate', ducked=mods._pandas, default=object)
'''`pandas.core.accessor.PandasDelegate`''';

pd_cataccessor = DuckSpec(asset='pandas.core.arrays.categorical.CategoricalAccessor', ducked=mods._pandas, default=object)
'''`pandas.core.arrays.categorical.CategoricalAccessor`''';

# %% ../nbs/30_eggs.ipynb 54
pt_C = DuckSpec('torch._C', is_module=True, ducked=mods._torch_c)
'''`torch._C`''';

pt_nan = DuckSpec('torch.nan', ducked=mods._torch_c, default=m_nan)
'''`torch.nan`''';

# %% ../nbs/30_eggs.ipynb 56
pt_size = DuckSpec(asset='torch.Size', ducked=mods._torch, default=tuple)
'''`torch.Size`''';

pt_type = DuckSpec(asset='torch.dtype', ducked=mods._torch_c, default=type)
'''`torch.dtype`''';

pt_device = DuckSpec(asset='torch.device', ducked=mods._torch, default=str)
'''`torch.device`''';

# %% ../nbs/30_eggs.ipynb 57
pt_nn = DuckSpec(asset='torch.nn', is_module=True, ducked=mods._torch, default=ModuleType('torch.nn'))
'''`torch.nn`''';

# %% ../nbs/30_eggs.ipynb 58
pt_module = DuckSpec(asset='torch.nn.Module', ducked=mods._torch, default=type)
'''`torch.nn.Module`''';

pt_dataset = DuckSpec(asset='torch.utils.data.Dataset', ducked=mods._torch, default=list)
'''`torch.utils.data.Dataset`''';

pt_dataloader = DuckSpec(asset='torch.utils.data.DataLoader', ducked=mods._torch, default=list)
'''`torch.utils.data.DataLoader`''';

# %% ../nbs/30_eggs.ipynb 59
pt_tensorbase = DuckSpec(asset='torch._C._TensorBase', ducked=mods._torch_c, default=list)
'''`torch._C._TensorBase`''';

pt_tensor = DuckSpec(asset='torch.Tensor', ducked=mods._torch, default=list, bases=(pt_tensorbase, ), delayed=dict(bases=True))
'''`torch.Tensor`''';

pt_inttensor = DuckSpec(asset='torch.IntTensor', ducked=mods._torch, default=list, bases=(pt_tensor, ), delayed=dict(bases=True))
'''`torch.IntTensor`''';

pt_floattensor = DuckSpec(asset='torch.FloatTensor', ducked=mods._torch, default=list, bases=(pt_tensor, ), delayed=dict(bases=True))
'''`torch.FloatTensor`''';

pt_longtensor = DuckSpec(asset='torch.LongTensor', ducked=mods._torch, default=list, bases=(pt_tensor, ), delayed=dict(bases=True))
'''`torch.LongTensor`''';

pt_doubletensor = DuckSpec(asset='torch.DoubleTensor', ducked=mods._torch, default=list, bases=(pt_tensor, ), delayed=dict(bases=True))
'''`torch.DoubleTensor`''';

pt_booltensor = DuckSpec(asset='torch.BoolTensor', ducked=mods._torch, default=list, bases=(pt_tensor, ), delayed=dict(bases=True))
'''`torch.BoolTensor`''';

# %% ../nbs/30_eggs.ipynb 60
pt_memoryformat = DuckSpec(asset='torch.memory_format', ducked=mods._torch, default=type)
'''`torch.memory_format`''';

pt_preserveformat = DuckSpec(asset='torch.preserve_format', bases=(pt_memoryformat, ), ducked=mods._torch, default=type, delayed=dict(bases=True))
'''`torch.preserve_format`''';

# %% ../nbs/30_eggs.ipynb 63
tv_datasets = DuckSpec(asset='torchvision.datasets', is_module=True, ducked=mods._torchvision, default=ModuleType('torchvision.datasets'))
'''`torchvision.datasets`''';

tv_transforms = DuckSpec(asset='torchvision.transforms', is_module=True, ducked=mods._torchvision, default=ModuleType('torchvision.transforms'))
'''`torchvision.transforms`''';

tv_functional = DuckSpec(asset='torchvision.transforms.functional', is_module=True, ducked=mods._torchvision, default=ModuleType('torchvision.transforms.functional'))
'''`torchvision.transforms.functional`''';

# %% ../nbs/30_eggs.ipynb 66
pl_module = DuckSpec(asset='pytorch_lightning.LightningModule', ducked=mods._pytorch_lightning, default=pt_module, delayed=dict(default=True))
'''`lightning.LightningModule`''';

pl_datamodule = DuckSpec(asset='pytorch_lightning.LightningDataModule', ducked=mods._pytorch_lightning, default=list)
'''`lightning.LightningDataModule`''';

# %% ../nbs/30_eggs.ipynb 68
td_odefunc = DuckSpec(asset='torchdyn.core.defunc.ODEFunc', ducked=mods._torchdyn, default=type)
'''`torchdyn.core.defunc.ODEFunc`''';

td_sdefunc = DuckSpec(asset='torchdyn.core.defunc.SDEFunc', ducked=mods._torchdyn, default=type)
'''`torchdyn.core.defunc.SDEFunc`''';

td_neuralode = DuckSpec(asset='torchdyn.core.NeuralODE', ducked=mods._torchdyn, default=pt_module, delayed=dict(default=True))
'''`torchdyn.core.NeuralODE`''';

td_neuralsde = DuckSpec(asset='torchdyn.core.NeuralSDE', ducked=mods._torchdyn, default=pt_module, delayed=dict(default=True))
'''`torchdyn.core.NeuralSDE`''';

td_augmenter = DuckSpec(asset='torchdyn.nn.Augmenter', ducked=mods._torchdyn, default=type)
'''`torchdyn.nn.augmenter`''';

# %% ../nbs/30_eggs.ipynb 70
ts_sdeito = DuckSpec(asset='torchsde.SDEIto', ducked=mods._torchsde, default=type)
'''`torchsde.ito`''';

ts_brownianinterval = DuckSpec(asset='torchsde.BrownianInterval', ducked=mods._torchsde, default=type)
'''`torchsde.BrownianInterval`''';

# %% ../nbs/30_eggs.ipynb 72
ad_adata = DuckSpec(asset='anndata.AnnData', ducked=mods._anndata, default=list)
'''`anndata.AnnData`''';

# %% ../nbs/30_eggs.ipynb 75
gt_base = DuckSpec(asset='graphtools.base.Base', ducked=mods._graphtools, default=type)
'''`graphtools.base.Base`''';

gt_data = DuckSpec(asset='graphtools.base.Data', ducked=mods._graphtools, default=type, bases=(gt_base, ),  delayed=dict(bases=True))
'''`graphtools.base.Data`''';

gt_bgraph = DuckSpec(asset='graphtools.base.BaseGraph', ducked=mods._graphtools, default=type, bases=(gt_base, ),  delayed=dict(bases=True))
'''`graphtools.base.BaseGraph`''';

gt_dgraph = DuckSpec(asset='graphtools.base.DataGraph', ducked=mods._graphtools, default=type, bases=(gt_base, gt_bgraph),  delayed=dict(bases=True))
'''`graphtools.base.DataGraph`''';

# %% ../nbs/30_eggs.ipynb 76
gt_lgraph = DuckSpec(asset='graphtools.graphs.LandmarkGraph', ducked=mods._graphtools, default=type, bases=(gt_dgraph, ), delayed=dict(bases=True))
'''`graphtools.graphs.LandmarkGraph`''';

gt_kgraph = DuckSpec(asset='graphtools.graphs.kNNGraph', ducked=mods._graphtools, default=type, bases=(gt_dgraph, ), delayed=dict(bases=True))
'''`graphtools.graphs.kNNGraph`''';

gt_tgraph = DuckSpec(asset='graphtools.graphs.TraditionalGraph', ducked=mods._graphtools, default=type, bases=(gt_dgraph, ), delayed=dict(bases=True))
'''`graphtools.graphs.TraditionalGraph`''';

gt_mgraph = DuckSpec(asset='graphtools.graphs.MNNGraph', ducked=mods._graphtools, default=type, bases=(gt_dgraph, ), delayed=dict(bases=True))
'''`graphtools.graphs.MNNGraph`''';

# %% ../nbs/30_eggs.ipynb 77
gt_klgraph = DuckSpec(asset='graphtools.graphs.kNNLandmarkGraph', ducked=mods._graphtools, default=type, bases=(gt_kgraph, gt_lgraph, ), delayed=dict(bases=True))
'''`graphtools.graphs.kNNLandmarkGraph`''';

gt_mlgraph = DuckSpec(asset='graphtools.graphs.MNNLandmarkGraph', ducked=mods._graphtools, default=type, bases=(gt_mgraph, gt_lgraph, ), delayed=dict(bases=True))
'''`graphtools.graphs.MNNLandmarkGraph`''';

gt_tlgraph = DuckSpec(asset='graphtools.graphs.TraditionalLandmarkGraph', ducked=mods._graphtools, default=type, bases=(gt_tgraph, gt_lgraph, ), delayed=dict(bases=True))
'''`graphtools.graphs.TraditionalLandmarkGraph`''';

# %% ../nbs/30_eggs.ipynb 80
cv_vidcap = DuckSpec(asset='cv2.VideoCapture', ducked=mods._cv2, default=type)
'''`cv2.VideoCapture`''';

# %% ../nbs/30_eggs.ipynb 82
pil_image = DuckSpec(asset='PIL.Image.Image', ducked=mods._PIL, default=type)
'''`PIL.Image.Image`''';

# %% ../nbs/30_eggs.ipynb 84
mpl = DuckSpec(asset='matplotlib', is_module=True, ducked=mods._matplotlib, default=ModuleType('matplotlib'))
'''`matplotlib`''';

mp_pyplot = DuckSpec(asset='matplotlib.pyplot', is_module=True, ducked=mods._matplotlib, default=ModuleType('matplotlib.pyplot'))
'''`matplotlib.pyplot`''';

mpl_colormap = DuckSpec(asset='matplotlib.colors.Colormap', ducked=mods._matplotlib, default=type)
'''`matplotlib.colors.Colormap`''';

mpl_lcolormap = DuckSpec(asset='matplotlib.colors.ListedColormap', ducked=mods._matplotlib, default=type, bases=(mpl_colormap, ), delayed=dict(bases=True))
'''`matplotlib.colors.ListedColormap`''';

mpl_lscolormap = DuckSpec(asset='matplotlib.colors.LinearSegmentedColormap', ducked=mods._matplotlib, default=type, bases=(mpl_colormap, ), delayed=dict(bases=True))
'''`matplotlib.colors.LinearSegmentedColormap`''';

_mpl_base = DuckSpec(asset='matplotlib.axes._base', is_module=True, ducked=mods._mpl_base, default=ModuleType('matplotlib.axes._base'))
'''`matplotlib.axes._base`''';

_mpl_axes = DuckSpec(asset='matplotlib.axes._axes', is_module=True, ducked=mods._mpl_axes, default=ModuleType('matplotlib.axes._axes'))
'''`matplotlib.axes._axes`''';

# _mpl_base._AxesBase
mpl_artist = DuckSpec(asset='matplotlib.artist.Artist', ducked=mods._mpl_artist, default=type)
'''`matplotlib.artist.Artist`''';

mpl_patch = DuckSpec(asset='matplotlib.patches.Patch', ducked=mods._mpl_patches, default=type, bases=lambda: (mpl_artist.duck, ), delayed=dict(bases=True))
'''`matplotlib.patches.Patch`''';

mpl_axbase = DuckSpec(asset='matplotlib.axes._base._AxesBase', ducked=mods._mpl_base, default=type, bases=lambda: (mpl_artist.duck, ), delayed=dict(bases=True))
'''`matplotlib.axes._base._AxesBase`''';

mpl_axes = DuckSpec(asset='matplotlib.axes._axes.Axes', ducked=mods._mpl_axes, default=type, bases=lambda: (mpl_axbase.duck, ), delayed=dict(bases=True))
'''`matplotlib.axes._axes.Axes`''';

# %% ../nbs/30_eggs.ipynb 87
sk_baseestimator = DuckSpec(asset='sklearn.base.BaseEstimator', ducked=mods._sklearn, default=type)
'''`sklearn.base.BaseEstimator`''';

sk_pairwise = DuckSpec(asset='sklearn.metrics.pairwise', is_module=True, ducked=mods._sklearn, default=ModuleType('sklearn.metrics.pairwise'))
'''`sklearn.metrics.pairwise`''';

# %% ../nbs/30_eggs.ipynb 90
ph_phate = DuckSpec(asset='phate.PHATE', ducked=mods._phate, default=sk_baseestimator, delayed=dict(default=True))
'''`phate.PHATE`''';

# %% ../nbs/30_eggs.ipynb 92
r_jupmix = DuckSpec(asset='rich.jupyter.JupyterMixin', ducked=mods._rich, default=type)
'''`rich.jupyter.JupyterMixin`''';

r_richtree = DuckSpec(asset='rich.tree.Tree', ducked=mods._rich, default=type, bases=(r_jupmix, ), delayed=dict(bases=True))
'''`rich.tree.Tree`''';

r_richtext = DuckSpec(asset='rich.text.Text', ducked=mods._rich, default=type, bases=(r_jupmix, ), delayed=dict(bases=True))
'''`rich.text.Text`''';

r_richcons = DuckSpec(asset='rich.console.Console', ducked=mods._rich, default=type, bases=(r_jupmix, ), delayed=dict(bases=True))
'''`rich.console.Console`''';

r_richprog = DuckSpec(asset='rich.progress.Progress', ducked=mods._rich, default=type, bases=(r_jupmix, ), delayed=dict(bases=True))
'''`rich.progress.Progress`''';

r_richtask = DuckSpec(asset='rich.progress.Task', ducked=mods._rich, default=type, bases=(r_jupmix, ), delayed=dict(bases=True))
'''`rich.progress.Task`''';

# %% ../nbs/30_eggs.ipynb 94
_tq_com = DuckSpec(asset='tqdm.utils.Comparable', ducked=mods._tqdm, default=type)
'''`tqdm.utils.Comparable`''';

_tq_std = DuckSpec(asset='tqdm.std.tqdm', ducked=mods._tqdm, default=type, bases=(_tq_com, ), delayed=dict(bases=True))
'''`tqdm.std.tqdm`''';

tq_as = DuckSpec(asset='tqdm.asyncio.tqdm_asyncio', ducked=mods._tqdm, default=type, bases=(_tq_std, ), delayed=dict(bases=True))
'''`tqdm.tqdm_asyncio.tqdm_asyncio`''';

tq_nb = DuckSpec(asset='tqdm.notebook.tqdm_notebook', ducked=mods._tqdm, default=type, bases=(_tq_std, ), delayed=dict(bases=True))
'''`tqdm.notebook.tqdm_notebook`''';

tq_auto = DuckSpec(asset='tqdm.auto.tqdm', ducked=mods._tqdm, default=lambda x: x, bases=(tq_nb, tq_as), delayed=dict(bases=True))
'''`tqdm.auto.tqdm`''';

# %% ../nbs/30_eggs.ipynb 96
t_typer = DuckSpec(asset='typer.Typer', ducked=mods._typer, default=type)
'''`typer.Typer`''';
