# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/40_duck.ipynb.

# %% auto 0
__all__ = ['iterable', 'itertype', 'npbool', 'boolic', 'bool01', 'bools', 'intq', 'ints', 'floatq', 'floats', 'real', 'realq',
           'reals', 'num', 'numq', 'nums', 'numstr', 'none', 'na', 'pynan', 'pdna', 'npnan', 'nan', 'nanq', 'nans',
           'pattern', 'rematch', 'strtmpl', 'nilstr', 'notnilstr', 'strbytes', 'notstrbytes', 'strq', 'strs',
           'ospathlike', 'plibpath', 'posixpath', 'pathlike', 'moduleloader', 'modulespec', 'moduletype', 'wrappertype',
           'builtinfunctype', 'trackbacktype', 'functiontype', 'mapping', 'dictkeys', 'dictvalues', 'dictitems', 'sig',
           'param', 'paramkind', 'logger', 'ichain', 'iprod', 'ziplong', 'artist', 'colormap', 'lcolormap',
           'lscolormap', 'mplpatch', 'mplaxbase', 'mplaxes', 'nparray', 'npmatrix', 'recarray', 'npempty',
           'npdatasource', 'sparray', 'spmatrix', 'cscarray', 'cscmatrix', 'cooarray', 'coomatrix', 'csrarray',
           'csrmatrix', 'diaarray', 'diamatrix', 'dokarray', 'dokmatrix', 'lilarray', 'lilmatrix', 'bsrarray',
           'bsrmatrix', 'sparsearray', 'sparsematrix', 'sparse', 'array', 'matrix', 'cv2vidcap', 'pilimage', 'vidcap',
           'image', 'groupkey', 'pddelegate', 'pdcataccessor', 'pdindex', 'pdcatindex', 'pdseries', 'boolindex',
           'catindex', 'indextype', 'indexlike', 'seriestype', 'serieslike', 'pddataframe', 'dataframe', 'pttype',
           'memfmt', 'presfmt', 'ptsize', 'ptdevice', 'pttensor', 'inttensor', 'booltensor', 'floattensor',
           'longtensor', 'doubletensor', 'nantensor', 'tensor', 'ptmodule', 'plmodule', 'nnmodule', 'ptdataset',
           'pldatamodule', 'ptdataloader', 'neuralode', 'neuralsde', 'neuraldynamics', 'augmenter', 'odefunc',
           'sdefunc', 'sdeito', 'brownianintervial', 'dtype', 'device', 'size', 'datasource', 'adata', 'adatas',
           'graphtype', 'datatype', 'shaped', 'dimmed', 'dim1', 'dim2', 'dim3', 'dim4', 'richtree', 'richtext',
           'richcons', 'richprog', 'richtask', 'tqdmauto', 'typerapp']

# %% ../nbs/40_duck.ipynb 6
#| export


# %% ../nbs/40_duck.ipynb 8
from typing import Iterable

# %% ../nbs/40_duck.ipynb 10
#| export

# %% ../nbs/40_duck.ipynb 12
#| export

# %% ../nbs/40_duck.ipynb 14
from .base import Duck
from . import eggs
from .enum import Species

# %% ../nbs/40_duck.ipynb 17
class iterable(Duck):
    '''`typings.Iterable`, `collections.abc.Iterable`'''
    __ducktype__ = (Iterable, eggs.c_iterable, )
    
class itertype(Duck):
    '''iterable type (i.e. `Iterable`, `list`, or `tuple`)'''
    __ducktype__ = (iterable, list, tuple)

# %% ../nbs/40_duck.ipynb 20
class npbool(Duck): 
    '''`np.bool_`'''
    __ducktype__ = (eggs.np_bool, )

class boolic(Duck): 
    '''`bool`, `np.bool_`'''
    __ducktype__ = (bool, eggs.np_bool)

class bool01(Duck):
    '''`bool`, `np.bool_`, `0`, `1`'''
    __ducktype__ = (boolic, 0, 1)
    
class bools(Duck):
    '''list of bool01'''
    __ducktype__ = (itertype, list, tuple)
    __expected__ = dict(dtype=bool01)

# %% ../nbs/40_duck.ipynb 23
class intq(Duck):
    '''`int` or None'''
    __ducktype__ = (int, )
    __species__ = Species.OPT
    
class ints(Duck):
    '''iterable of `int`s'''
    __ducktype__ = (itertype,)
    __expected__ = dict(dtype=int)

# %% ../nbs/40_duck.ipynb 25
class floatq(Duck):
    '''`float` or None'''
    __ducktype__ = (float, )
    __species__ = Species.OPT
    
class floats(Duck):
    '''iterable of `float`s'''
    __ducktype__ = (itertype,)
    __expected__ = dict(dtype=float)

# %% ../nbs/40_duck.ipynb 27
class real(Duck):
    '''R (i.e. `int` or `float`)'''
    __ducktype__ = (int, float, )
    
class realq(Duck):
    '''`real` or None'''
    __ducktype__ = (int, float, )
    __species__ = Species.OPT
    
class reals(Duck):
    '''iterable of `real`'''
    __ducktype__ = (itertype,)
    __expected__ = dict(dtype=real)

# %% ../nbs/40_duck.ipynb 29
class num(Duck):
    '''`int`, `float`, `complex`, or `Number`'''
    __ducktype__ = (int, float, complex, eggs.n_number)
    
class numq(Duck):
    '''`real` or None'''
    __ducktype__ = (num, )
    __species__ = Species.OPT
    
class nums(Duck):
    '''iterable of `num`'''
    __ducktype__ = (itertype,)
    __expected__ = dict(dtype=num)

# %% ../nbs/40_duck.ipynb 33
class numstr(Duck):
    '''`num` or str'''
    __ducktype__ = (num, str,)

# %% ../nbs/40_duck.ipynb 36
class none(Duck): 
    '''`None` or `NoneType`'''
    __ducktype__ = (None, eggs.t_nonetype)
    
class na(Duck): 
    '''`NA` or `NAType`'''
    __ducktype__ = (eggs.pd_na, eggs.pd_natype,)

# %% ../nbs/40_duck.ipynb 38
class pynan(Duck): 
    '''`math.nan`''';
    __ducktype__ = (eggs.m_nan, )
    
class pdna(Duck): 
    '''`pd.NA`''';
    __ducktype__ = (
        eggs.pd_na, 
    )

class npnan(Duck): 
    '''`np.nan`, `np.NaN`, or `np.NAN`'''
    __ducktype__ = (
        eggs.np_nan, eggs.np_NaN, eggs.np_NAN, 
    )

# %% ../nbs/40_duck.ipynb 39
class nan(Duck):
    '''`math.nan`, `pd.NA`, `np.nan`, `np.NaN`, or `np.NAN`'''
    __ducktype__ = (
        eggs.m_nan, eggs.np_nan, eggs.np_NaN, eggs.np_NAN, 
        eggs.pd_na,# eggs.pd_natype, #float('nan')
    )
    
class nanq(Duck):
    '''`nan` or None'''
    __ducktype__ = (nan, )
    __species__ = Species.OPT
    
class nans(Duck):
    '''iterable of `nan`'''
    __ducktype__ = (itertype,)
    __expected__ = dict(dtype=nan)

# %% ../nbs/40_duck.ipynb 46
class pattern(Duck): 
    '''`re.Pattern`'''
    __ducktype__ = (eggs.re_pattern, )

class rematch(Duck): 
    '''`re.Match`'''
    __ducktype__ = (eggs.re_match, )

class strtmpl(Duck): 
    '''`string.Template`'''
    __ducktype__ = (eggs.s_template, )

# %% ../nbs/40_duck.ipynb 48
class nilstr(Duck):
    '''`''` (the nil string)'''
    __ducktype__ = ('', )
    __guard__ = lambda x: x == ''
    
class notnilstr(nilstr): 
    '''not `nilstr` (not `''`, the nil string)'''
    __species__ = Species.NOT

# %% ../nbs/40_duck.ipynb 49
class strbytes(Duck):
    '''str or bytes'''
    __ducktype__ = (str, bytes)
    
class notstrbytes(strbytes): 
    '''not (str or bytes)'''
    __species__ = Species.NOT

# %% ../nbs/40_duck.ipynb 50
class strq(Duck): 
    '''`str` or None'''
    __ducktype__ = (str, )
    __species__ = Species.OPT

class strs(Duck): 
    '''iterable of `str`'''
    __ducktype__ = (itertype, notstrbytes, )
    __expected__ = dict(dtype=str)

# %% ../nbs/40_duck.ipynb 53
class ospathlike(Duck):
    '''`os.PathLike`'''
    __ducktype__ = (eggs.os_pathlike, )

class plibpath(Duck):
    '''`pathlib.Path`'''
    __ducktype__ = (eggs.pl_path, )

class posixpath(Duck):
    '''`pathlib.PosixPath`'''
    __ducktype__ = (eggs.pl_posixpath, )

# %% ../nbs/40_duck.ipynb 55
class pathlike(Duck):
    '''`os.PathLike`, `pathlib.Path`, `pathlib.PosixPath`'''
    __ducktype__ = (str, bytes, eggs.os_pathlike, eggs.pl_path, eggs.pl_posixpath)    

# %% ../nbs/40_duck.ipynb 57
class moduleloader(Duck):
    '''`importlib.Loader`'''
    __ducktype__ = (eggs.il_moduleloader, )
    
class modulespec(Duck):
    '''`importlib.machinery.ModuleSpec`'''
    __ducktype__ = (eggs.il_modulespec, )

# %% ../nbs/40_duck.ipynb 59
class moduletype(Duck):
    '''`types.ModuleType`'''
    __ducktype__ = (eggs.t_moduletype, )
    
class wrappertype(Duck):
    '''`types.MethodWrapperType`'''
    __ducktype__ = (eggs.t_methodwrappertype, )
    
class builtinfunctype(Duck):
    '''`types.BuiltinFunctionType`'''
    __ducktype__ = (eggs.t_builtinfunctiontype, )
    
class trackbacktype(Duck):
    '''`types.TracebackType`'''
    __ducktype__ = (eggs.t_tracebacktype, )
    
class functiontype(Duck):
    '''`types.FunctionType`'''
    __ducktype__ = (eggs.t_functiontype, )
    
class mapping(Duck):
    '''`collections.Mapping`'''
    __ducktype__ = (eggs.c_mapping, )

# %% ../nbs/40_duck.ipynb 61
class dictkeys(Duck):
    '''`_collections_abc.dict_keys`'''
    __ducktype__ = (eggs.c_dict_keys, )
    
class dictvalues(Duck):
    '''`_collections_abc.dict_values`'''
    __ducktype__ = (eggs.c_dict_values, )
    
class dictitems(Duck):
    '''`_collections_abc.dict_items`'''
    __ducktype__ = (eggs.c_dict_items, )

# %% ../nbs/40_duck.ipynb 63
class sig(Duck):
    '''`inspect.Signature`'''
    __ducktype__ = (eggs.i_sig, )
    
class param(Duck):
    '''`inspect.Parameter`'''
    __ducktype__ = (eggs.i_param, )
    
class paramkind(Duck):
    '''`inspect._ParameterKind`'''
    __ducktype__ = (eggs.i_paramkind, )

# %% ../nbs/40_duck.ipynb 65
class logger(Duck):
    '''`logging.Logger`'''
    __ducktype__ = (eggs.l_logger, )

# %% ../nbs/40_duck.ipynb 67
class ichain(Duck):
    '''`itertools.chain`'''
    __ducktype__ = (eggs.it_chain, )
    
class iprod(Duck):
    '''`itertools.product`'''
    __ducktype__ = (eggs.it_prod, )
    
class ziplong(Duck):
    '''`itertools.zip_longest`'''
    __ducktype__ = (eggs.it_ziplong, )

# %% ../nbs/40_duck.ipynb 70
class _mpl_base(Duck):
    '''`matplotlib.axes._base`''';
    __ducktype__ = (eggs._mpl_base, )
    
class _mpl_axes(Duck):
    '''`matplotlib.axes._axes`''';
    __ducktype__ = (eggs._mpl_axes, )
    

class artist(Duck): 
    '''`matplotlib.artist.Artist`'''
    __ducktype__ = (eggs.mpl_artist, )
    
class colormap(Duck): 
    '''`matplotlib.colors.Colormap`'''
    __ducktype__ = (eggs.mpl_colormap, )

class lcolormap(Duck): 
    '''`matplotlib.colors.ListedColormap`'''
    __ducktype__ = (eggs.mpl_lcolormap, )
    
class lscolormap(Duck): 
    '''`matplotlib.colors.LinearSegmentedColormap`'''
    __ducktype__ = (eggs.mpl_lscolormap, )
    
class mplpatch(Duck): 
    '''`matplotlib.patches.Patch`'''
    __ducktype__ = (eggs.mpl_patch, )

class mplaxbase(Duck): 
    '''`matplotlib.axes._base._AxesBase`'''
    __ducktype__ = (eggs.mpl_axbase, )

class mplaxes(Duck): 
    '''`matplotlib.axes._axes.Axes`'''
    __ducktype__ = (eggs.mpl_axes, )
    

# %% ../nbs/40_duck.ipynb 73
class nparray(Duck):
    '''`numpy.ndarray`''';
    __ducktype__ = (eggs.np_array, )
    
class npmatrix(Duck):
    '''`numpy.matrix`''';
    __ducktype__ = (eggs.np_matrix, )

class recarray(Duck):
    '''`numpy.recarray`''';
    __ducktype__ = (eggs.np_recarray, )
    
class npempty(Duck):
    '''`numpy.empty`''';
    __ducktype__ = (eggs.np_empty, )

# %% ../nbs/40_duck.ipynb 74
class npdatasource(Duck): 
    '''`numpy.DataSource`''';
    __ducktype__ = (eggs.np_datasource, )

# %% ../nbs/40_duck.ipynb 76
class sparray(Duck): 
    '''`scipy.sparse.aparray`''';
    __ducktype__ = (eggs.sp_sparray, )

class spmatrix(Duck): 
    '''`scipy.sparse.spmatrix`''';
    __ducktype__ = (eggs.sp_spmatrix, )
    

# %% ../nbs/40_duck.ipynb 78
class cscarray(Duck):
    '''`scipy.sparse.csc_array`''';
    __ducktype__ = (eggs.sp_csc_array, )
    
class cscmatrix(Duck):
    '''`scipy.sparse.csc_matrix`''';
    __ducktype__ = (eggs.sp_csc_matrix, )

class cooarray(Duck):
    '''`scipy.sparse.coo_array`''';
    __ducktype__ = (eggs.sp_coo_array, )

class coomatrix(Duck):
    '''`scipy.sparse.coo_matrix`''';
    __ducktype__ = (eggs.sp_coo_matrix, )

class csrarray(Duck):
    '''`scipy.sparse.csr_array`''';
    __ducktype__ = (eggs.sp_csr_array, )

class csrmatrix(Duck):
    '''`scipy.sparse.csr_matrix`''';
    __ducktype__ = (eggs.sp_csr_matrix, )

class diaarray(Duck):
    '''`scipy.sparse.dia_array`''';
    __ducktype__ = (eggs.sp_dia_array, )

class diamatrix(Duck):
    '''`scipy.sparse.dia_matrix`''';
    __ducktype__ = (eggs.sp_dia_matrix, )

class dokarray(Duck):
    '''`scipy.sparse.dok_array`''';
    __ducktype__ = (eggs.sp_dok_array, )

class dokmatrix(Duck):
    '''`scipy.sparse.dok_matrix`''';
    __ducktype__ = (eggs.sp_dok_matrix, )

class lilarray(Duck):
    '''`scipy.sparse.lil_array`''';
    __ducktype__ = (eggs.sp_lil_array, )

class lilmatrix(Duck):
    '''`scipy.sparse.lil_matrix`''';
    __ducktype__ = (eggs.sp_lil_matrix, )

class bsrarray(Duck):
    '''`scipy.sparse.bsr_array`''';
    __ducktype__ = (eggs.sp_bsr_array, )

class bsrmatrix(Duck):
    '''`scipy.sparse.bsr_matrix`''';
    __ducktype__ = (eggs.sp_bsr_matrix, )

# %% ../nbs/40_duck.ipynb 80
class sparsearray(Duck): 
    '''sparse array (e.g. 
    `scipy.sparse.sparray`, `scipy.sparse.cscarray`, `scipy.sparse.cooarray`, 
    `scipy.sparse.csrarray`, `scipy.sparse.diaarray`, `scipy.sparse.dokarray`, 
    `scipy.sparse.lilarray`, or `scipy.sparse.bsrarray`)'''
    __ducktype__ = (sparray, cscarray, cooarray, csrarray, diaarray, dokarray, lilarray, bsrarray)
    
    
class sparsematrix(Duck): 
    '''sparse type (e.g.  
    `scipy.sparse.spmatrix`, `scipy.sparse.cscmatrix`, `scipy.sparse.coomatrix`, 
    `scipy.sparse.csrmatrix`, `scipy.sparse.diamatrix`, `scipy.sparse.dokmatrix`, 
    `scipy.sparse.lilmatrix`, or `scipy.sparse.bsrmatrix`)'''
    __ducktype__ = (spmatrix, cscmatrix, coomatrix, csrmatrix, diamatrix, dokmatrix, lilmatrix, bsrmatrix)


# %% ../nbs/40_duck.ipynb 82
class sparse(Duck): 
    '''sparse type (e.g. `sparsearray` or `sparsematrix`)'''
    __ducktype__ = (sparray, sparsematrix)
    
class array(Duck): 
    '''array type (e.g. `np.array`, `np.recarray`, `sp.sparray`, `itertype`, or `list`)'''
    __ducktype__ = (nparray, recarray, sparray, itertype, list)
    
class matrix(Duck): 
    '''matrix type(e.g. `np.matrix`, `sp.matrix`, `itertype`, or `list`)'''
    __ducktype__ = (npmatrix, spmatrix, itertype, list)

# %% ../nbs/40_duck.ipynb 85
class cv2vidcap(Duck): 
    '''`cv2.VideoCapture`''';
    __ducktype__ = (eggs.cv_vidcap, )

class pilimage(Duck): 
    '''`PIL.Image.Image`''';
    __ducktype__ = (eggs.pil_image, )    

# %% ../nbs/40_duck.ipynb 87
class vidcap(Duck): 
    '''`cv2.VideoCapture`''';
    __ducktype__ = (eggs.cv_vidcap, )
    
class image(Duck): 
    '''`PIL.Image.Image`''';
    __ducktype__ = (eggs.pil_image, )

# %% ../nbs/40_duck.ipynb 90
class groupkey(Duck): 
    '''groupby key (e.g. `str`, `tuple`, or `numstr`)'''
    __ducktype__ = (str, tuple, numstr)
    

# %% ../nbs/40_duck.ipynb 92
class pddelegate(Duck):
    '''`pandas.core.accessor.PandasDelegate`''';
    __ducktype__ = (object, eggs.pd_delegate, )
    
class pdcataccessor(Duck):
    '''`pandas.core.arrays.categorical.CategoricalAccessor`''';
    __ducktype__ = (object, eggs.pd_cataccessor, )

# %% ../nbs/40_duck.ipynb 94
class pdindex(Duck):
    '''`pandas.Index`''';
    __ducktype__ = (eggs.pd_index, )
    
class pdcatindex(Duck):
    '''`pandas.CategoricalIndex`''';
    __ducktype__ = (eggs.pd_catindex, )

# %% ../nbs/40_duck.ipynb 96
class pdseries(Duck):
    '''`pandas.Series`''';
    __ducktype__ = (eggs.pd_series, )
    

# %% ../nbs/40_duck.ipynb 98
class boolindex(Duck): 
    '''boolean index'''
    __ducktype__ = (list, pdindex, nparray, bools, )
    __expected__ = dict(dtype=bool01)
    
class catindex(Duck): 
    '''categorical index'''
    __ducktype__ = (pdcatindex, )

# %% ../nbs/40_duck.ipynb 100
class indextype(Duck): 
    '''index types(e.g. `pd.Index`, `pd.CategoricalIndex`, `np.ndarray`, or `boolindex`)'''
    __ducktype__ = (pdindex, pdcatindex, boolindex, nparray)
    
    
class indexlike(Duck): 
    '''index-like objects (e.g. `list`, `tuple`,`bools`, `nums`, 
    `itertype`, `pd.Index`, `pd.CategoricalIndex`, `boolindex`, or `np.array`)'''
    __ducktype__ = (list, tuple, bools, nums, itertype, pdindex, pdcatindex, boolindex, nparray)

# %% ../nbs/40_duck.ipynb 102
class seriestype(Duck): 
    '''series type (e.g. `pd.Series`, `np.array`, `np.recarray`, `list`, or `indexlike`)'''
    __ducktype__ = (pdseries, nparray, recarray, list, indexlike)
    

class serieslike(Duck): 
    '''series-like type'''
    __ducktype__ = (pdseries, nparray, recarray, list, indexlike)

# %% ../nbs/40_duck.ipynb 104
class pddataframe(Duck): 
    '''`pandas.DataFrame`''';
    __ducktype__ = (eggs.pd_dataframe, )

# %% ../nbs/40_duck.ipynb 106
class dataframe(Duck): 
    '''`pandas.DataFrame`''';
    __ducktype__ = (eggs.pd_dataframe, )

# %% ../nbs/40_duck.ipynb 109
class pttype(Duck): 
    '''`torch.dtype`'''
    __ducktype__ = (eggs.pt_type, )

# %% ../nbs/40_duck.ipynb 111
class memfmt(Duck): 
    '''`torch.memory_format`''';
    __ducktype__ = (eggs.pt_memoryformat, )

class presfmt(Duck): 
    '''`torch.preserve_format`''';
    __ducktype__ = (eggs.pt_preserveformat, )


# %% ../nbs/40_duck.ipynb 113
class ptsize(Duck): 
    '''`torch.Size`'''
    __ducktype__ = (eggs.pt_size, iterable, tuple, )

# %% ../nbs/40_duck.ipynb 115
class ptdevice(Duck): 
    '''`torch.device`'''
    __ducktype__ = (eggs.pt_device, iterable, tuple, )


# %% ../nbs/40_duck.ipynb 117
class pttensor(Duck): 
    '''`torch.Tensor`''';
    __ducktype__ = (eggs.pt_tensor, )
    
class inttensor(Duck): 
    '''`torch.IntTensor`''';
    __ducktype__ = (eggs.pt_inttensor, )
    
class booltensor(Duck): 
    '''`torch.BoolTensor`''';
    __ducktype__ = (eggs.pt_booltensor, )
    
class floattensor(Duck): 
    '''`torch.FloatTensor`''';
    __ducktype__ = (eggs.pt_floattensor, )
    
class longtensor(Duck): 
    '''`torch.LongTensor`''';
    __ducktype__ = (eggs.pt_longtensor, )
    
class doubletensor(Duck): 
    '''`torch.DoubleTensor`''';
    __ducktype__ = (eggs.pt_doubletensor, )

# %% ../nbs/40_duck.ipynb 119
class nantensor(Duck): 
    '''tensor of `nan`s'''
    __ducktype__ = (pttensor, nans, )
    __expected__ = dict(dtype=nan)

# %% ../nbs/40_duck.ipynb 121
class tensor(Duck): 
    '''tensor type (e.g. `torch.tensor`, `torch.IntTensor`, `torch.BoolTensor`, or `torch.FloatTensor`)'''
    __ducktype__ = (pttensor, inttensor, booltensor, floattensor, longtensor, doubletensor, )

# %% ../nbs/40_duck.ipynb 123
class ptmodule(Duck): 
    '''`torch.nn.Module`'''
    __ducktype__ = (eggs.pt_module, )

class plmodule(Duck): 
    '''`pytorch_lightning.LightningModule`'''
    __ducktype__ = (eggs.pl_module, )

# %% ../nbs/40_duck.ipynb 125
class nnmodule(Duck): 
    '''module type (e.g. `torch.nn.Module` or `pytorch_lightning.LightningModule`)'''
    __ducktype__ = (ptmodule, plmodule, )

# %% ../nbs/40_duck.ipynb 127
class ptdataset(Duck): 
    '''`torch.utils.data.Dataset`'''
    __ducktype__ = (eggs.pt_dataset, )

class pldatamodule(Duck): 
    '''`pytorch_lightning.LightningDataModule`'''
    __ducktype__ = (eggs.pl_datamodule, )

class ptdataloader(Duck): 
    '''`torch.utils.data.DataLoader`'''
    __ducktype__ = (eggs.pt_dataloader, )


# %% ../nbs/40_duck.ipynb 130
class neuralode(Duck): 
    '''torchdyn neural ODE'''
    __ducktype__ = (eggs.td_neuralode, )

class neuralsde(Duck): 
    '''torchdyn neural SDE'''
    __ducktype__ = (eggs.td_neuralsde, )

class neuraldynamics(Duck): 
    '''neuralode or neuralsde'''
    __ducktype__ = (neuralode, neuralsde, )


# %% ../nbs/40_duck.ipynb 131
class augmenter(Duck): 
    '''`torchdyn.nn.augmenter`''';
    __ducktype__ = (eggs.td_augmenter, )

# %% ../nbs/40_duck.ipynb 132
class odefunc(Duck): 
    '''`torchdyn.ODEFunc`'''
    __ducktype__ = (eggs.td_odefunc, )

class sdefunc(Duck): 
    '''`torchdyn.SDEFunc`'''
    __ducktype__ = (eggs.td_sdefunc, )


# %% ../nbs/40_duck.ipynb 134
class sdeito(Duck): 
    '''`torchsde.ito`'''
    __ducktype__ = (eggs.ts_sdeito, )

class brownianintervial(Duck): 
    '''`torchsde.BrownianInterval`'''
    __ducktype__ = (eggs.ts_brownianinterval, )


# %% ../nbs/40_duck.ipynb 137
class dtype(Duck): 
    '''Type of data (e.g. `np.dtype` or `torch.dtype`)'''
    __ducktype__ = (type, eggs.np_type, eggs.pt_type, )

# %% ../nbs/40_duck.ipynb 139
class device(Duck): 
    '''`torch.device`'''
    __ducktype__ = (eggs.pt_device, )

# %% ../nbs/40_duck.ipynb 141
class size(Duck): 
    '''size type (e.g. `tuple`, `torch.Size`, `itertype`)'''
    __ducktype__ = (tuple, ptsize, itertype, )
    __expected__ = dict(dtype=int)

# %% ../nbs/40_duck.ipynb 143
class datasource(Duck): 
    '''`numpy.DataSource`''';
    __ducktype__ = (eggs.np_datasource, )   

# %% ../nbs/40_duck.ipynb 145
class adata(Duck): 
    '''`anndata.AnnData`''';
    __ducktype__ = (eggs.ad_adata, )

class adatas(Duck): 
    '''`anndata.AnnData`''';
    __ducktype__ = (itertype, )
    __expected__ = dict(dtype=adata)

# %% ../nbs/40_duck.ipynb 147
class graphtype(Duck): 
    '''graph type (e.g. `BaseGraph`, `DataGraph`, `LandmarkGraph`, `kNNGraph`, `TraditionalGraph`, 
    `MNNGraph`, `kNNLandmarkGraph`, `TraditionalLandmarkGraph`, or `MNNLandmarkGraph`)'''
    __ducktype__ = (
        eggs.gt_bgraph, eggs.gt_dgraph, eggs.gt_lgraph, 
        eggs.gt_kgraph, eggs.gt_tgraph, eggs.gt_mgraph, 
        eggs.gt_klgraph, eggs.gt_tlgraph, eggs.gt_mlgraph
    )

# %% ../nbs/40_duck.ipynb 149
class datatype(Duck): 
    '''data type (e.g.  `np.array`, `np.matrix`, `sp.array`, `sp.matrix`,  `np.recarray`, or `anndata`)'''
    __ducktype__ = (array, matrix, adata, )


# %% ../nbs/40_duck.ipynb 151
class shaped(Duck): 
    '''shaped `datatype`'''
    __ducktype__ = (datatype, indextype, seriestype, dataframe, tensor, )
    __required__ = ('shape', )

# %% ../nbs/40_duck.ipynb 153
class dimmed(Duck): 
    '''`np.ndarray` with shape `(i, ...)`'''
    __ducktype__ = (list, nparray, list, itertype, )
    __required__ = ('ndim', )

class dim1(dimmed): 
    '''`np.ndarray` with shape `(i, )`'''
    __ducktype__ = (dimmed, )
    __expected__ = dict(ndim=1)
    

class dim2(dimmed): 
    '''`np.ndarray` with shape `(i, j, )`'''
    __ducktype__ = (dimmed, )
    __expected__ = dict(ndim=2)
    

class dim3(dimmed): 
    '''`np.ndarray` with shape `(i, j, k, )`'''
    __ducktype__ = (dimmed, )
    __expected__ = dict(ndim=3)

class dim4(dimmed): 
    '''`np.ndarray` with shape `(i, j, k, l, )`'''
    __ducktype__ = (dimmed, )
    __expected__ = dict(ndim=4)

# %% ../nbs/40_duck.ipynb 156
class richtree(Duck):
    '''`rich.tree.Tree`'''
    __ducktype__ = (eggs.r_richtree, )
    
class richtext(Duck):
    '''`rich.text.Text`'''
    __ducktype__ = (eggs.r_richtext, )
    
class richcons(Duck):
    '''`rich.console.Console`'''
    __ducktype__ = (eggs.r_richcons, )
    
class richprog(Duck):
    '''`rich.progress.Progress`'''
    __ducktype__ = (eggs.r_richprog, )
    
class richtask(Duck):
    '''`rich.progress.Task`'''
    __ducktype__ = (eggs.r_richtask, )

# %% ../nbs/40_duck.ipynb 158
class tqdmauto(Duck):
    '''`tqdm.auto.tqdm`'''
    __ducktype__ = (eggs.tq_as, )

# %% ../nbs/40_duck.ipynb 160
class typerapp(Duck):
    '''`typer.Typer`'''
    __ducktype__ = (eggs.t_typer, )
    
